/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.risorse;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class CalcoloAsSet {
    private String DATI = "dati";
    private String NOME_FILE_COEFFICENTI = "coefficentiAs.ger";
    public static final int CODICE_STUDIO = 0;
    public static final int COSTO_PROD_SERV = 1;
    public static final int BENI = 2;
    public static final int SPESE_LAV_DIP = 3;
    public static final int SPESE_ACQ_SERV = 4;
    public static final int VALORE_MED_MAGAZZ = 5;
    public static final int CV_CVPROD = 6;
    public static final int VAR_UTILIZZATA = 7;
    private RigaCoefficenti[] rigaCoefficenti = null;
    private Vector messaggioErrore = null;

    public CalcoloAsSet(String[] listaCodiciStudio) throws Exception {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.NOME_FILE_COEFFICENTI)));
            this.rigaCoefficenti = this.getRighe(listaCodiciStudio, br);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setMessaggioErrore("file : " + this.NOME_FILE_COEFFICENTI + " non trovato ");
        }
        catch (IOException iOException) {
            this.setMessaggioErrore("Impossibile leggere il file : " + this.NOME_FILE_COEFFICENTI);
        }
        catch (NullPointerException npe) {
            this.setMessaggioErrore(((Throwable)npe).getMessage());
        }
    }

    public String getCoefficente(int posizioneStudio, int codiceCoefficente) {
        return this.rigaCoefficenti[posizioneStudio].getCoefficente(codiceCoefficente);
    }

    public Vector getMessaggioErrore() {
        return this.messaggioErrore;
    }

    public String[] getRigaCoefficenti(int posizioneStudio) {
        return this.rigaCoefficenti[posizioneStudio].getCoefficenti();
    }

    private RigaCoefficenti[] getRighe(String[] codiceStudio, BufferedReader input) throws IOException, NullPointerException {
        int i;
        String linea = null;
        RigaCoefficenti[] rc = null;
        linea = input.readLine();
        rc = new RigaCoefficenti[codiceStudio.length];
        while (linea != null) {
            i = 0;
            while (i < codiceStudio.length) {
                if (linea.startsWith(codiceStudio[i])) {
                    rc[i] = new RigaCoefficenti(this, linea);
                }
                ++i;
            }
            linea = input.readLine();
        }
        input.close();
        i = 0;
        while (i < rc.length) {
            if (rc[i] == null) {
                throw new NullPointerException("Codice Studio Non trovato : " + codiceStudio[i]);
            }
            ++i;
        }
        return rc;
    }

    public static void main(String[] args) {
        CalcoloAsSet cs = null;
        String[] studi = new String[]{"SD07B", "SM03A"};
        String[] ap = null;
        try {
            cs = new CalcoloAsSet(studi);
            int i = 0;
            while (i < studi.length) {
                ap = cs.getRigaCoefficenti(i);
                System.out.println(cs.getCoefficente(i, 0));
                int j = 1;
                while (j < ap.length) {
                    System.out.println(ap[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            System.out.println((String)cs.getMessaggioErrore().elementAt(1));
        }
    }

    private void setMessaggioErrore(String messaggio) {
        if (this.messaggioErrore == null) {
            this.messaggioErrore = new Vector();
            this.messaggioErrore.addElement("E");
        }
        this.messaggioErrore.addElement(messaggio);
    }

    private class RigaCoefficenti {
        /* synthetic */ CalcoloAsSet this$0;
        private String[] rigaCoef = null;

        public RigaCoefficenti(CalcoloAsSet this$0, String riga) {
            this.this$0 = this$0;
            StringTokenizer st = new StringTokenizer(riga, "*");
            this.rigaCoef = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreElements()) {
                this.rigaCoef[i++] = (String)st.nextElement();
            }
            st = null;
        }

        public String getCoefficente(int codiceCoefficente) {
            return codiceCoefficente >= 0 && codiceCoefficente < this.rigaCoef.length ? this.rigaCoef[codiceCoefficente] : null;
        }

        public String[] getCoefficenti() {
            return this.rigaCoef;
        }
    }
}

