/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc.keyinfo;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dom.XencDOMStructure;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KANonceImpl
extends XencDOMStructure {
    protected byte[] value_;

    protected void unmarshalElement(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.unmarshalElement(dOMCryptoContext, element);
        try {
            this.value_ = DOMStructure.getBytesFromElement(element);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MarshalException("Failed to parse KA-Nonce value.", numberFormatException);
        }
    }

    protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element = super.marshalElement(dOMCryptoContext, node, node2);
        DOMStructure.addBytesToElement(element, this.value_, dOMCryptoContext);
        return element;
    }

    public byte[] getValue() {
        return (byte[])this.value_.clone();
    }

    public String getLocalName() {
        return "KA-Nonce";
    }

    public KANonceImpl(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("The argument 'value' must not be null.");
        }
        this.value_ = byArray;
    }

    public KANonceImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.value_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }
}

