/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.wsaddressing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;

public final class W3CEndpointReferenceBuilder {
    private String address;
    private List<Element> referenceParameters = new ArrayList<Element>();
    private List<Element> metadata = new ArrayList<Element>();
    private QName interfaceName;
    private QName serviceName;
    private QName endpointName;
    private String wsdlDocumentLocation;
    private Map<QName, String> attributes = new HashMap<QName, String>();
    private List<Element> elements = new ArrayList<Element>();

    public W3CEndpointReferenceBuilder address(String string) {
        this.address = string;
        return this;
    }

    public W3CEndpointReferenceBuilder interfaceName(QName qName) {
        this.interfaceName = qName;
        return this;
    }

    public W3CEndpointReferenceBuilder serviceName(QName qName) {
        this.serviceName = qName;
        return this;
    }

    public W3CEndpointReferenceBuilder endpointName(QName qName) {
        if (this.serviceName == null) {
            throw new IllegalStateException("The W3CEndpointReferenceBuilder's serviceName must be set before setting the endpointName: " + qName);
        }
        this.endpointName = qName;
        return this;
    }

    public W3CEndpointReferenceBuilder wsdlDocumentLocation(String string) {
        this.wsdlDocumentLocation = string;
        return this;
    }

    public W3CEndpointReferenceBuilder referenceParameter(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("The referenceParameter cannot be null.");
        }
        this.referenceParameters.add(element);
        return this;
    }

    public W3CEndpointReferenceBuilder metadata(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("The metadataElement cannot be null.");
        }
        this.metadata.add(element);
        return this;
    }

    public W3CEndpointReferenceBuilder element(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("The extension element cannot be null.");
        }
        this.elements.add(element);
        return this;
    }

    public W3CEndpointReferenceBuilder attribute(QName qName, String string) {
        if (qName == null || string == null) {
            throw new IllegalArgumentException("The extension attribute name or value cannot be null.");
        }
        this.attributes.put(qName, string);
        return this;
    }

    public W3CEndpointReference build() {
        if (this.elements.isEmpty() && this.attributes.isEmpty() && this.interfaceName == null) {
            return Provider.provider().createW3CEndpointReference(this.address, this.serviceName, this.endpointName, this.metadata, this.wsdlDocumentLocation, this.referenceParameters);
        }
        return Provider.provider().createW3CEndpointReference(this.address, this.interfaceName, this.serviceName, this.endpointName, this.metadata, this.wsdlDocumentLocation, this.referenceParameters, this.elements, this.attributes);
    }
}

