/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;
import sun.font.GlyphList;
import sun.font.XRGlyphCacheEntry;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.pipe.Region;
import sun.java2d.xr.GrowableEltArray;
import sun.java2d.xr.GrowableIntArray;
import sun.java2d.xr.GrowableRectArray;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRColor;
import sun.java2d.xr.XRUtils;

public class XRBackendNative
implements XRBackend {
    private static long FMTPTR_A8;
    private static long FMTPTR_ARGB32;
    private static long MASK_XIMG;

    private static native void initIDs();

    @Override
    public native long createGC(int var1);

    @Override
    public native void freeGC(long var1);

    @Override
    public native int createPixmap(int var1, int var2, int var3, int var4);

    private native int createPictureNative(int var1, long var2);

    @Override
    public native void freePicture(int var1);

    @Override
    public native void freePixmap(int var1);

    @Override
    public native void setGCExposures(long var1, boolean var3);

    @Override
    public native void setGCForeground(long var1, int var3);

    @Override
    public native void setPictureRepeat(int var1, int var2);

    @Override
    public native void copyArea(int var1, int var2, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    @Override
    public native void setGCMode(long var1, boolean var3);

    private static native void GCRectanglesNative(int var0, long var1, int[] var3, int var4);

    @Override
    public native void renderComposite(byte var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private native void renderRectangle(int var1, byte var2, short var3, short var4, short var5, short var6, int var7, int var8, int var9, int var10);

    private static native void XRenderRectanglesNative(int var0, byte var1, short var2, short var3, short var4, short var5, int[] var6, int var7);

    private native void XRSetTransformNative(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native int XRCreateLinearGradientPaintNative(float[] var0, short[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    private static native int XRCreateRadialGradientPaintNative(float[] var0, short[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    @Override
    public native void setFilter(int var1, int var2);

    private static native void XRSetClipNative(long var0, int var2, int var3, int var4, int var5, Region var6, boolean var7);

    @Override
    public void GCRectangles(int n, long l, GrowableRectArray growableRectArray) {
        XRBackendNative.GCRectanglesNative(n, l, growableRectArray.getArray(), growableRectArray.getSize());
    }

    @Override
    public int createPicture(int n, int n2) {
        return this.createPictureNative(n, XRBackendNative.getFormatPtr(n2));
    }

    @Override
    public void setPictureTransform(int n, AffineTransform affineTransform) {
        this.XRSetTransformNative(n, XRUtils.XDoubleToFixed(affineTransform.getScaleX()), XRUtils.XDoubleToFixed(affineTransform.getShearX()), XRUtils.XDoubleToFixed(affineTransform.getTranslateX()), XRUtils.XDoubleToFixed(affineTransform.getShearY()), XRUtils.XDoubleToFixed(affineTransform.getScaleY()), XRUtils.XDoubleToFixed(affineTransform.getTranslateY()));
    }

    @Override
    public void renderRectangle(int n, byte by, XRColor xRColor, int n2, int n3, int n4, int n5) {
        this.renderRectangle(n, by, (short)xRColor.red, (short)xRColor.green, (short)xRColor.blue, (short)xRColor.alpha, n2, n3, n4, n5);
    }

    private short[] getRenderColors(int[] nArray) {
        short[] sArray = new short[nArray.length * 4];
        XRColor xRColor = new XRColor();
        for (int i = 0; i < nArray.length; ++i) {
            xRColor.setColorValues(nArray[i], true);
            sArray[i * 4 + 0] = (short)xRColor.alpha;
            sArray[i * 4 + 1] = (short)xRColor.red;
            sArray[i * 4 + 2] = (short)xRColor.green;
            sArray[i * 4 + 3] = (short)xRColor.blue;
        }
        return sArray;
    }

    private static long getFormatPtr(int n) {
        switch (n) {
            case 2: {
                return FMTPTR_A8;
            }
            case 0: {
                return FMTPTR_ARGB32;
            }
        }
        return 0L;
    }

    @Override
    public int createLinearGradient(Point2D point2D, Point2D point2D2, float[] fArray, int[] nArray, int n, AffineTransform affineTransform) {
        short[] sArray = this.getRenderColors(nArray);
        int n2 = XRBackendNative.XRCreateLinearGradientPaintNative(fArray, sArray, XRUtils.XDoubleToFixed(point2D.getX()), XRUtils.XDoubleToFixed(point2D.getY()), XRUtils.XDoubleToFixed(point2D2.getX()), XRUtils.XDoubleToFixed(point2D2.getY()), fArray.length, n, XRUtils.XDoubleToFixed(affineTransform.getScaleX()), XRUtils.XDoubleToFixed(affineTransform.getShearX()), XRUtils.XDoubleToFixed(affineTransform.getTranslateX()), XRUtils.XDoubleToFixed(affineTransform.getShearY()), XRUtils.XDoubleToFixed(affineTransform.getScaleY()), XRUtils.XDoubleToFixed(affineTransform.getTranslateY()));
        return n2;
    }

    @Override
    public int createRadialGradient(Point2D point2D, Point2D point2D2, float f, float f2, float[] fArray, int[] nArray, int n, AffineTransform affineTransform) {
        short[] sArray = this.getRenderColors(nArray);
        return XRBackendNative.XRCreateRadialGradientPaintNative(fArray, sArray, fArray.length, XRUtils.XDoubleToFixed(f), XRUtils.XDoubleToFixed(f2), n, XRUtils.XDoubleToFixed(affineTransform.getScaleX()), XRUtils.XDoubleToFixed(affineTransform.getShearX()), XRUtils.XDoubleToFixed(affineTransform.getTranslateX()), XRUtils.XDoubleToFixed(affineTransform.getShearY()), XRUtils.XDoubleToFixed(affineTransform.getScaleY()), XRUtils.XDoubleToFixed(affineTransform.getTranslateY()));
    }

    @Override
    public void setGCClipRectangles(long l, Region region) {
        XRBackendNative.XRSetClipNative(l, region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY(), region.isRectangular() ? null : region, true);
    }

    @Override
    public void setClipRectangles(int n, Region region) {
        if (region != null) {
            XRBackendNative.XRSetClipNative(n, region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY(), region.isRectangular() ? null : region, false);
        } else {
            XRBackendNative.XRSetClipNative(n, 0, 0, Short.MAX_VALUE, Short.MAX_VALUE, null, false);
        }
    }

    @Override
    public void renderRectangles(int n, byte by, XRColor xRColor, GrowableRectArray growableRectArray) {
        XRBackendNative.XRenderRectanglesNative(n, by, (short)xRColor.red, (short)xRColor.green, (short)xRColor.blue, (short)xRColor.alpha, growableRectArray.getArray(), growableRectArray.getSize());
    }

    private static long[] getGlyphInfoPtrs(List<XRGlyphCacheEntry> list) {
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get(i).getGlyphInfoPtr();
        }
        return lArray;
    }

    @Override
    public void XRenderAddGlyphs(int n, GlyphList glyphList, List<XRGlyphCacheEntry> list, byte[] byArray) {
        long[] lArray = XRBackendNative.getGlyphInfoPtrs(list);
        XRBackendNative.XRAddGlyphsNative(n, lArray, lArray.length, byArray, byArray.length);
    }

    @Override
    public void XRenderFreeGlyphs(int n, int[] nArray) {
        XRBackendNative.XRFreeGlyphsNative(n, nArray, nArray.length);
    }

    private static native void XRAddGlyphsNative(int var0, long[] var1, int var2, byte[] var3, int var4);

    private static native void XRFreeGlyphsNative(int var0, int[] var1, int var2);

    private static native void XRenderCompositeTextNative(int var0, int var1, int var2, long var3, int[] var5, int[] var6, int var7, int var8);

    @Override
    public int XRenderCreateGlyphSet(int n) {
        return XRBackendNative.XRenderCreateGlyphSetNative(XRBackendNative.getFormatPtr(n));
    }

    private static native int XRenderCreateGlyphSetNative(long var0);

    @Override
    public void XRenderCompositeText(byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, GrowableEltArray growableEltArray) {
        GrowableIntArray growableIntArray = growableEltArray.getGlyphs();
        XRBackendNative.XRenderCompositeTextNative(by, n, n2, 0L, growableEltArray.getArray(), growableIntArray.getArray(), growableEltArray.getSize(), growableIntArray.getSize());
    }

    @Override
    public void putMaskImage(int n, long l, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, float f) {
        XRBackendNative.putMaskNative(n, l, byArray, n2, n3, n4, n5, n6, n7, n8, n9, f, MASK_XIMG);
    }

    private static native void putMaskNative(int var0, long var1, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, float var12, long var13);

    public void padBlit(byte by, int n, int n2, int n3, AffineTransform affineTransform, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        XRBackendNative.padBlitNative(by, n, n2, n3, XRUtils.XDoubleToFixed(affineTransform.getScaleX()), XRUtils.XDoubleToFixed(affineTransform.getShearX()), XRUtils.XDoubleToFixed(affineTransform.getTranslateX()), XRUtils.XDoubleToFixed(affineTransform.getShearY()), XRUtils.XDoubleToFixed(affineTransform.getScaleY()), XRUtils.XDoubleToFixed(affineTransform.getTranslateY()), n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
    }

    private static native void padBlitNative(byte var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19);

    @Override
    public void renderCompositeTrapezoids(byte by, int n, int n2, int n3, int n4, int n5, TrapezoidList trapezoidList) {
        XRBackendNative.renderCompositeTrapezoidsNative(by, n, XRBackendNative.getFormatPtr(n2), n3, n4, n5, trapezoidList.getTrapArray());
    }

    private static native void renderCompositeTrapezoidsNative(byte var0, int var1, long var2, int var4, int var5, int var6, int[] var7);

    static {
        XRBackendNative.initIDs();
    }
}

