/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.AccordionBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.control.skin.TitledPaneSkin;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Control;
import javafx.scene.control.TitledPane;
import javafx.scene.shape.Rectangle;

public class AccordionSkin
extends SkinBase<Accordion, AccordionBehavior> {
    private TitledPane firstTitledPane;
    private Rectangle clipRect;
    private boolean relocateAllPanes = false;
    private boolean resize = false;
    private double previousHeight = 0.0;
    private TitledPane expandedPane = null;
    private TitledPane previousPane = null;
    private Map<TitledPane, ChangeListener> listeners = new HashMap<TitledPane, ChangeListener>();

    public AccordionSkin(final Accordion accordion) {
        super(accordion, new AccordionBehavior(accordion));
        accordion.getPanes().addListener(new ListChangeListener<TitledPane>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends TitledPane> change) {
                if (AccordionSkin.this.firstTitledPane != null) {
                    AccordionSkin.this.firstTitledPane.getStyleClass().remove("first-titled-pane");
                }
                if (!accordion.getPanes().isEmpty()) {
                    AccordionSkin.this.firstTitledPane = (TitledPane)accordion.getPanes().get(0);
                    AccordionSkin.this.firstTitledPane.getStyleClass().add("first-titled-pane");
                }
                AccordionSkin.this.getChildren().setAll((Collection<Node>)accordion.getPanes());
                while (change.next()) {
                    AccordionSkin.this.removeTitledPaneListeners(change.getRemoved());
                    AccordionSkin.this.initTitledPaneListeners(change.getAddedSubList());
                }
            }
        });
        if (!accordion.getPanes().isEmpty()) {
            this.firstTitledPane = (TitledPane)accordion.getPanes().get(0);
            this.firstTitledPane.getStyleClass().add("first-titled-pane");
        }
        this.clipRect = new Rectangle();
        this.setClip(this.clipRect);
        this.initTitledPaneListeners(accordion.getPanes());
        this.getChildren().setAll((Collection<Node>)accordion.getPanes());
        this.requestLayout();
    }

    @Override
    protected double computeMinHeight(double d) {
        double d2 = 0.0;
        for (Node node : this.getManagedChildren()) {
            d2 += this.snapSize(node.minHeight(d));
        }
        return d2;
    }

    @Override
    protected double computePrefHeight(double d) {
        TitledPane titledPane;
        double d2 = 0.0;
        TitledPane titledPane2 = titledPane = ((Accordion)this.getSkinnable()).getExpandedPane() != null ? ((Accordion)this.getSkinnable()).getExpandedPane() : this.previousPane;
        if (titledPane != null) {
            d2 = titledPane.prefHeight(-1.0);
        }
        for (Node node : this.getManagedChildren()) {
            TitledPane titledPane3 = (TitledPane)node;
            if (titledPane3.equals(titledPane)) continue;
            d2 += this.snapSize(titledPane3.minHeight(d));
        }
        return d2 + this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom());
    }

    @Override
    protected void layoutChildren() {
        Object object;
        double d = this.snapSize(this.getWidth()) - (this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight()));
        double d2 = this.snapSize(this.getHeight()) - (this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom()));
        double d3 = this.snapSpace(this.getInsets().getLeft());
        double d4 = this.snapSpace(this.getInsets().getTop());
        double d5 = 0.0;
        double d6 = 0.0;
        for (TitledPane titledPane : ((Accordion)this.getSkinnable()).getPanes()) {
            object = titledPane;
            if (((TitledPane)object).isExpanded()) continue;
            d6 += this.snapSize(((Control)object).minHeight(-1.0));
        }
        double d7 = 0.0;
        d7 = this.previousPane != null && this.previousPane.equals(this.expandedPane) && ((Accordion)this.getSkinnable()).getExpandedPane() == null ? (((Accordion)this.getSkinnable()).getPanes().size() == 1 ? d2 : d2 - d6 + this.previousPane.minHeight(-1.0)) : d2 - d6;
        object = ((Accordion)this.getSkinnable()).getPanes().iterator();
        while (object.hasNext()) {
            TitledPane titledPane;
            TitledPane titledPane2 = titledPane = (TitledPane)object.next();
            TitledPaneSkin titledPaneSkin = (TitledPaneSkin)titledPane2.getSkin();
            titledPaneSkin.setMaxTitledPaneHeightForAccordion(d7);
            double d8 = this.snapSize(titledPaneSkin.getTitledPaneHeightForAccordion());
            titledPane2.resize(d, d8);
            if (!this.resize && this.previousPane != null && this.expandedPane != null) {
                if (((Accordion)this.getSkinnable()).getPanes().indexOf(this.previousPane) < ((Accordion)this.getSkinnable()).getPanes().indexOf(this.expandedPane)) {
                    if (!this.relocateAllPanes && ((Accordion)this.getSkinnable()).getPanes().indexOf(titledPane2) > ((Accordion)this.getSkinnable()).getPanes().indexOf(this.expandedPane)) continue;
                    titledPane2.relocate(d3, d4);
                    d4 += d8 + d5;
                    continue;
                }
                if (((Accordion)this.getSkinnable()).getPanes().indexOf(this.previousPane) > ((Accordion)this.getSkinnable()).getPanes().indexOf(this.expandedPane)) {
                    if (!this.relocateAllPanes && ((Accordion)this.getSkinnable()).getPanes().indexOf(titledPane2) > ((Accordion)this.getSkinnable()).getPanes().indexOf(this.previousPane)) continue;
                    titledPane2.relocate(d3, d4);
                    d4 += d8 + d5;
                    continue;
                }
                this.relocateAllPanes = true;
                titledPane2.relocate(d3, d4);
                d4 += d8 + d5;
                continue;
            }
            titledPane2.relocate(d3, d4);
            d4 += d8 + d5;
        }
        if (this.expandedPane != null && ((TitledPaneSkin)this.expandedPane.getSkin()).getTitledPaneHeightForAccordion() == d7) {
            this.relocateAllPanes = false;
        }
    }

    @Override
    protected void setWidth(double d) {
        super.setWidth(d);
        this.clipRect.setWidth(d);
    }

    @Override
    protected void setHeight(double d) {
        super.setHeight(d);
        this.clipRect.setHeight(d);
        if (this.previousHeight != d) {
            this.previousHeight = d;
            this.resize = true;
        } else {
            this.resize = false;
        }
    }

    private void initTitledPaneListeners(List<? extends TitledPane> list) {
        for (TitledPane titledPane : list) {
            titledPane.setExpanded(titledPane == ((Accordion)this.getSkinnable()).getExpandedPane());
            if (titledPane.isExpanded()) {
                this.expandedPane = titledPane;
            }
            ChangeListener<Boolean> changeListener = this.expandedPropertyListener(titledPane);
            titledPane.expandedProperty().addListener(changeListener);
            this.listeners.put(titledPane, changeListener);
        }
    }

    private void removeTitledPaneListeners(List<? extends TitledPane> list) {
        for (TitledPane titledPane : list) {
            if (!this.listeners.containsKey(titledPane)) continue;
            titledPane.expandedProperty().removeListener(this.listeners.get(titledPane));
            this.listeners.remove(titledPane);
        }
    }

    private ChangeListener<Boolean> expandedPropertyListener(final TitledPane titledPane) {
        return new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                AccordionSkin.this.previousPane = AccordionSkin.this.expandedPane;
                if (bl2.booleanValue()) {
                    if (((Accordion)AccordionSkin.this.getSkinnable()).getExpandedPane() != null) {
                        ((Accordion)AccordionSkin.this.getSkinnable()).getExpandedPane().setExpanded(false);
                    }
                    if (titledPane != null) {
                        ((Accordion)AccordionSkin.this.getSkinnable()).setExpandedPane(titledPane);
                    }
                    AccordionSkin.this.expandedPane = ((Accordion)AccordionSkin.this.getSkinnable()).getExpandedPane();
                } else {
                    AccordionSkin.this.expandedPane = ((Accordion)AccordionSkin.this.getSkinnable()).getExpandedPane();
                    ((Accordion)AccordionSkin.this.getSkinnable()).setExpandedPane(null);
                }
            }
        };
    }
}

