/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer;

import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.cli.Parser;
import com.glavsoft.viewer.mvp.View;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.ParametersHandler;
import com.glavsoft.viewer.swing.SwingConnectionWorkerFactory;
import com.glavsoft.viewer.swing.SwingViewerWindowFactory;
import com.glavsoft.viewer.swing.gui.ConnectionView;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class Viewer
extends JApplet
implements Runnable,
WindowListener {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private int paramsMask;
    private boolean allowAppletInteractiveConnections;
    private final ConnectionParams connectionParams = new ConnectionParams();
    private String passwordFromParams;
    boolean isSeparateFrame = true;
    boolean isApplet = true;
    private final ProtocolSettings settings = ProtocolSettings.getDefaultSettings();
    private final UiSettings uiSettings = new UiSettings();
    private volatile boolean isAppletStopped = false;
    private ConnectionPresenter connectionPresenter;

    public static void main(String[] args) {
        Parser parser = new Parser();
        ParametersHandler.completeParserOptions(parser);
        parser.parse(args);
        if (parser.isSet("help")) {
            Viewer.printUsage(parser.optionsUsage());
            System.exit(0);
        }
        Viewer viewer = new Viewer(parser);
        SwingUtilities.invokeLater(viewer);
    }

    public static void printUsage(String additional) {
        System.out.println("Usage: java -jar (progfilename) [hostname [port_number]] [Options]\n    or\n java -jar (progfilename) [Options]\n    or\n java -jar (progfilename) -help\n    to view this help\n\nWhere Options are:\n" + additional + "\nOptions format: -optionName=optionValue. Ex. -host=localhost -port=5900 -viewonly=yes\n" + "Both option name and option value are case insensitive.");
    }

    public Viewer() {
    }

    private Viewer(Parser parser) {
        this();
        this.setLoggingLevel(parser.isSet("v") ? Level.FINE : (parser.isSet("vv") ? Level.FINER : Level.INFO));
        this.paramsMask = ParametersHandler.completeSettingsFromCLI(parser, this.connectionParams, this.settings, this.uiSettings);
        this.passwordFromParams = parser.getValueFor("password");
        this.logger.info("TightVNC Viewer version " + Viewer.ver());
        this.isApplet = false;
    }

    private void setLoggingLevel(Level levelToSet) {
        Logger appLogger = Logger.getLogger("com.glavsoft");
        appLogger.setLevel(levelToSet);
        Handler ch = null;
        for (Handler h : appLogger.getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            ch = (ConsoleHandler)h;
            break;
        }
        if (null == ch) {
            ch = new ConsoleHandler();
            appLogger.addHandler(ch);
        }
        ch.setLevel(levelToSet);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Window w;
        if (e != null && e.getComponent() != null && (w = e.getWindow()) != null) {
            w.setVisible(false);
            w.dispose();
        }
        this.closeApp();
    }

    public void closeApp() {
        if (this.connectionPresenter != null) {
            this.connectionPresenter.cancelConnection();
            this.logger.info("Connections cancelled.");
        }
        if (this.isApplet) {
            if (!this.isAppletStopped) {
                this.logger.severe("Applet is stopped.");
                this.isAppletStopped = true;
                this.repaint();
                this.stop();
            }
        } else {
            System.exit(0);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isAppletStopped) {
            super.paint(g);
        } else {
            this.getContentPane().removeAll();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawString("Disconnected", 10, 20);
        }
    }

    @Override
    public void destroy() {
        this.closeApp();
        super.destroy();
    }

    @Override
    public void init() {
        this.paramsMask = ParametersHandler.completeSettingsFromApplet(this, this.connectionParams, this.settings, this.uiSettings);
        this.isSeparateFrame = ParametersHandler.isSeparateFrame;
        this.passwordFromParams = this.getParameter("password");
        this.isApplet = true;
        this.allowAppletInteractiveConnections = ParametersHandler.allowAppletInteractiveConnections;
        this.repaint();
        try {
            SwingUtilities.invokeAndWait(this);
        }
        catch (Exception e) {
            this.logger.severe(e.getMessage());
        }
    }

    @Override
    public void start() {
        super.start();
    }

    private boolean checkJsch() {
        try {
            Class.forName("com.jcraft.jsch.JSch");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void run() {
        boolean hasJsch = this.checkJsch();
        boolean allowInteractive = this.allowAppletInteractiveConnections || !this.isApplet;
        this.connectionPresenter = new ConnectionPresenter(hasJsch, allowInteractive);
        this.connectionPresenter.addModel("ConnectionParamsModel", this.connectionParams);
        ConnectionView connectionView = new ConnectionView(this, this.connectionPresenter, hasJsch);
        this.connectionPresenter.addView("ConnectionView", connectionView);
        if (this.isApplet) {
            this.connectionPresenter.addView("AppletStatusStringView", new View(){

                @Override
                public void showView() {
                }

                @Override
                public void closeView() {
                }

                public void setMessage(String message) {
                    Viewer.this.getAppletContext().showStatus(message);
                }
            });
        }
        SwingViewerWindowFactory viewerWindowFactory = new SwingViewerWindowFactory(this.isSeparateFrame, this.isApplet, this);
        this.connectionPresenter.setConnectionWorkerFactory(new SwingConnectionWorkerFactory(connectionView.getFrame(), this.passwordFromParams, this.connectionPresenter, viewerWindowFactory));
        this.connectionPresenter.startConnection(this.settings, this.uiSettings, this.paramsMask);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public static String ver() {
        InputStream mfStream = Viewer.class.getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
        if (null == mfStream) {
            System.out.println("No Manifest file found.");
            return "-1";
        }
        try {
            Manifest mf = new Manifest();
            mf.read(mfStream);
            Attributes atts = mf.getMainAttributes();
            return atts.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (IOException e) {
            return "-2";
        }
    }
}

