/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.transport;

import com.glavsoft.exceptions.TransportException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Writer {
    private final DataOutputStream os;

    public Writer(OutputStream os) {
        this.os = new DataOutputStream(os);
    }

    public void flush() throws TransportException {
        try {
            this.os.flush();
        }
        catch (IOException e) {
            throw new TransportException("Cannot flush output stream", e);
        }
    }

    public void writeByte(int b) throws TransportException {
        this.write((byte)(b & 0xFF));
    }

    public void write(byte b) throws TransportException {
        try {
            this.os.writeByte(b);
        }
        catch (IOException e) {
            throw new TransportException("Cannot write byte", e);
        }
    }

    public void writeInt16(int sh) throws TransportException {
        this.write((short)(sh & 0xFFFF));
    }

    public void write(short sh) throws TransportException {
        try {
            this.os.writeShort(sh);
        }
        catch (IOException e) {
            throw new TransportException("Cannot write short", e);
        }
    }

    public void writeInt32(int i) throws TransportException {
        this.write(i);
    }

    public void writeInt64(long i) throws TransportException {
        try {
            this.os.writeLong(i);
        }
        catch (IOException e) {
            throw new TransportException("Cannot write long", e);
        }
    }

    public void write(int i) throws TransportException {
        try {
            this.os.writeInt(i);
        }
        catch (IOException e) {
            throw new TransportException("Cannot write int", e);
        }
    }

    public void write(byte[] b) throws TransportException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int length) throws TransportException {
        this.write(b, 0, length);
    }

    public void write(byte[] b, int offset, int length) throws TransportException {
        try {
            this.os.write(b, offset, length <= b.length ? length : b.length);
        }
        catch (IOException e) {
            throw new TransportException("Cannot write " + length + " bytes", e);
        }
    }
}

