/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.parse;

import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.ParentRefPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.input.CommentTrimmer;
import com.thaiopensource.relaxng.input.parse.AnnotationsImpl;
import com.thaiopensource.relaxng.input.parse.CommentListImpl;
import com.thaiopensource.relaxng.input.parse.ElementAnnotationBuilderImpl;
import com.thaiopensource.relaxng.input.parse.NamespaceContextImpl;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.CommentList;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.DataPatternBuilder;
import com.thaiopensource.relaxng.parse.Div;
import com.thaiopensource.relaxng.parse.ElementAnnotationBuilder;
import com.thaiopensource.relaxng.parse.Grammar;
import com.thaiopensource.relaxng.parse.GrammarSection;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Include;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.SubParseable;
import com.thaiopensource.relaxng.parse.SubParser;
import com.thaiopensource.util.Localizer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class SchemaBuilderImpl
implements SchemaBuilder<Pattern, NameClass, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> {
    private final SubParser<Pattern, NameClass, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> subParser;
    private final ErrorHandler eh;
    private final Map<String, SchemaDocument> schemas;
    private final DatatypeLibraryFactory dlf;
    private final boolean commentsNeedTrimming;
    private boolean hadError = false;
    private static final Localizer localizer = new Localizer(SchemaBuilderImpl.class);

    private SchemaBuilderImpl(SubParser<Pattern, NameClass, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> subParser, ErrorHandler errorHandler, Map<String, SchemaDocument> map, DatatypeLibraryFactory datatypeLibraryFactory, boolean bl) {
        this.subParser = subParser;
        this.eh = errorHandler;
        this.schemas = map;
        this.dlf = datatypeLibraryFactory;
        this.commentsNeedTrimming = bl;
    }

    @Override
    public Pattern makeChoice(List<Pattern> list, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        return SchemaBuilderImpl.makeComposite(new ChoicePattern(), list, sourceLocation, annotationsImpl);
    }

    private static Pattern makeComposite(CompositePattern compositePattern, List<Pattern> list, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        compositePattern.getChildren().addAll(list);
        return SchemaBuilderImpl.finishPattern(compositePattern, sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeGroup(List<Pattern> list, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        return SchemaBuilderImpl.makeComposite(new GroupPattern(), list, sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeInterleave(List<Pattern> list, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        return SchemaBuilderImpl.makeComposite(new InterleavePattern(), list, sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeOneOrMore(Pattern pattern, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new OneOrMorePattern(pattern), sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeZeroOrMore(Pattern pattern, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new ZeroOrMorePattern(pattern), sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeOptional(Pattern pattern, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new OptionalPattern(pattern), sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeList(Pattern pattern, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new ListPattern(pattern), sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeMixed(Pattern pattern, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new MixedPattern(pattern), sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeEmpty(SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        return SchemaBuilderImpl.finishPattern(new EmptyPattern(), sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeNotAllowed(SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        return SchemaBuilderImpl.finishPattern(new NotAllowedPattern(), sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeText(SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        return SchemaBuilderImpl.finishPattern(new TextPattern(), sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeAttribute(NameClass nameClass, Pattern pattern, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new AttributePattern(nameClass, pattern), sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeElement(NameClass nameClass, Pattern pattern, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        return SchemaBuilderImpl.finishPattern(new ElementPattern(nameClass, pattern), sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeValue(String string, String string2, String string3, Context context, String string4, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
        ValuePattern valuePattern = new ValuePattern(string, string2, string3);
        DatatypeLibrary datatypeLibrary = this.dlf.createDatatypeLibrary(string);
        if (datatypeLibrary != null) {
            try {
                DatatypeBuilder datatypeBuilder = datatypeLibrary.createDatatypeBuilder(string2);
                try {
                    Datatype datatype = datatypeBuilder.createDatatype();
                    try {
                        TraceValidationContext traceValidationContext;
                        TraceValidationContext traceValidationContext2 = traceValidationContext = datatype.isContextDependent() ? new TraceValidationContext(valuePattern.getPrefixMap(), context, string4) : null;
                        if (datatype.createValue(string3, traceValidationContext) == null) {
                            datatype.checkValid(string3, traceValidationContext);
                        }
                    }
                    catch (DatatypeException datatypeException) {
                        this.diagnoseDatatypeException("invalid_value_detail", "invalid_value", datatypeException, sourceLocation);
                    }
                }
                catch (DatatypeException datatypeException) {
                    this.diagnoseDatatypeException("invalid_params_detail", "invalid_params", datatypeException, sourceLocation);
                }
            }
            catch (DatatypeException datatypeException) {
                this.diagnoseDatatypeException("unsupported_datatype_detail", "unknown_datatype", datatypeException, sourceLocation);
            }
        }
        return SchemaBuilderImpl.finishPattern(valuePattern, sourceLocation, annotationsImpl);
    }

    @Override
    public Pattern makeExternalRef(String string, String string2, String string3, Scope<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> scope, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException, IllegalSchemaException {
        SubParseable<Pattern, NameClass, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> subParseable = this.subParser.createSubParseable(string, string2);
        String string4 = subParseable.getUri();
        ExternalRefPattern externalRefPattern = new ExternalRefPattern(string4);
        externalRefPattern.setNs(SchemaBuilderImpl.mapInheritNs(string3));
        externalRefPattern.setHref(string);
        externalRefPattern.setBaseUri(string2);
        SchemaBuilderImpl.finishPattern(externalRefPattern, sourceLocation, annotationsImpl);
        if (this.schemas.get(string4) == null) {
            this.schemas.put(string4, new SchemaDocument(null));
            this.schemas.put(string4, new SchemaDocument(subParseable.parse(this, scope)));
        }
        return externalRefPattern;
    }

    private static Pattern finishPattern(Pattern pattern, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        SchemaBuilderImpl.finishAnnotated(pattern, sourceLocation, annotationsImpl);
        return pattern;
    }

    @Override
    public NameClass makeNameClassChoice(List<NameClass> list, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        ChoiceNameClass choiceNameClass = new ChoiceNameClass();
        choiceNameClass.getChildren().addAll(list);
        return SchemaBuilderImpl.finishNameClass(choiceNameClass, sourceLocation, annotationsImpl);
    }

    @Override
    public NameClass makeName(String string, String string2, String string3, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        NameNameClass nameNameClass = new NameNameClass(SchemaBuilderImpl.mapInheritNs(string), string2);
        nameNameClass.setPrefix(string3);
        return SchemaBuilderImpl.finishNameClass(nameNameClass, sourceLocation, annotationsImpl);
    }

    @Override
    public NameClass makeNsName(String string, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        return SchemaBuilderImpl.finishNameClass(new NsNameNameClass(SchemaBuilderImpl.mapInheritNs(string)), sourceLocation, annotationsImpl);
    }

    @Override
    public NameClass makeNsName(String string, NameClass nameClass, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        return SchemaBuilderImpl.finishNameClass(new NsNameNameClass(SchemaBuilderImpl.mapInheritNs(string), nameClass), sourceLocation, annotationsImpl);
    }

    @Override
    public NameClass makeAnyName(SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        return SchemaBuilderImpl.finishNameClass(new AnyNameNameClass(), sourceLocation, annotationsImpl);
    }

    @Override
    public NameClass makeAnyName(NameClass nameClass, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        return SchemaBuilderImpl.finishNameClass(new AnyNameNameClass(nameClass), sourceLocation, annotationsImpl);
    }

    @Override
    public Grammar<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> makeGrammar(Scope scope) {
        GrammarPattern grammarPattern = new GrammarPattern();
        return new GrammarSectionImpl(grammarPattern, grammarPattern);
    }

    private static NameClass finishNameClass(NameClass nameClass, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        SchemaBuilderImpl.finishAnnotated(nameClass, sourceLocation, annotationsImpl);
        return nameClass;
    }

    private static void finishAnnotated(Annotated annotated, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) {
        annotated.setSourceLocation(sourceLocation);
        if (annotationsImpl != null) {
            annotationsImpl.apply(annotated);
        }
    }

    @Override
    public NameClass annotateNameClass(NameClass nameClass, AnnotationsImpl annotationsImpl) throws BuildException {
        if (annotationsImpl != null) {
            annotationsImpl.apply(nameClass);
        }
        return nameClass;
    }

    @Override
    public Pattern annotatePattern(Pattern pattern, AnnotationsImpl annotationsImpl) throws BuildException {
        if (annotationsImpl != null) {
            annotationsImpl.apply(pattern);
        }
        return pattern;
    }

    @Override
    public Pattern annotateAfterPattern(Pattern pattern, ElementAnnotationBuilderImpl elementAnnotationBuilderImpl) throws BuildException {
        SchemaBuilderImpl.addAfterAnnotation(pattern, elementAnnotationBuilderImpl);
        return pattern;
    }

    @Override
    public NameClass annotateAfterNameClass(NameClass nameClass, ElementAnnotationBuilderImpl elementAnnotationBuilderImpl) throws BuildException {
        SchemaBuilderImpl.addAfterAnnotation(nameClass, elementAnnotationBuilderImpl);
        return nameClass;
    }

    private static void addAfterAnnotation(Annotated annotated, ElementAnnotationBuilderImpl elementAnnotationBuilderImpl) {
        elementAnnotationBuilderImpl.addTo(annotated.getFollowingElementAnnotations());
    }

    @Override
    public Pattern commentAfterPattern(Pattern pattern, CommentListImpl commentListImpl) throws BuildException {
        SchemaBuilderImpl.addAfterComment(pattern, commentListImpl);
        return pattern;
    }

    @Override
    public NameClass commentAfterNameClass(NameClass nameClass, CommentListImpl commentListImpl) throws BuildException {
        SchemaBuilderImpl.addAfterComment(nameClass, commentListImpl);
        return nameClass;
    }

    private static void addAfterComment(Annotated annotated, CommentList commentList) {
        if (commentList != null) {
            annotated.getFollowingElementAnnotations().addAll(((CommentListImpl)commentList).list);
        }
    }

    @Override
    public SourceLocation makeLocation(String string, int n, int n2) {
        return new SourceLocation(string, n, n2);
    }

    @Override
    public CommentListImpl makeCommentList() {
        if (this.commentsNeedTrimming) {
            return new TrimmingCommentListImpl();
        }
        return new CommentListImpl();
    }

    @Override
    public DataPatternBuilder<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> makeDataPatternBuilder(String string, String string2, SourceLocation sourceLocation) throws BuildException {
        DataPattern dataPattern = new DataPattern(string, string2);
        dataPattern.setSourceLocation(sourceLocation);
        return new DataPatternBuilderImpl(dataPattern);
    }

    @Override
    public Pattern makeErrorPattern() {
        return null;
    }

    @Override
    public NameClass makeErrorNameClass() {
        return null;
    }

    @Override
    public AnnotationsImpl makeAnnotations(CommentListImpl commentListImpl, Context context) {
        return new AnnotationsImpl(commentListImpl, context);
    }

    @Override
    public ElementAnnotationBuilder<SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl> makeElementAnnotationBuilder(String string, String string2, String string3, SourceLocation sourceLocation, CommentListImpl commentListImpl, Context context) {
        ElementAnnotation elementAnnotation = new ElementAnnotation(string, string2);
        elementAnnotation.setPrefix(string3);
        elementAnnotation.setSourceLocation(sourceLocation);
        elementAnnotation.setContext(new NamespaceContextImpl(context));
        return new ElementAnnotationBuilderImpl(commentListImpl, elementAnnotation);
    }

    @Override
    public boolean usesComments() {
        return true;
    }

    private static Combine mapCombine(GrammarSection.Combine combine) {
        if (combine == null) {
            return null;
        }
        return combine == GrammarSection.COMBINE_CHOICE ? Combine.CHOICE : Combine.INTERLEAVE;
    }

    private static String mapInheritNs(String string) {
        return string;
    }

    private void parse(Parseable<Pattern, NameClass, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> parseable, String string) throws IllegalSchemaException {
        this.schemas.put(string, new SchemaDocument(parseable.parse(this, new ScopeImpl())));
    }

    static SchemaCollection parse(Parseable<Pattern, NameClass, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> parseable, String string, ErrorHandler errorHandler, DatatypeLibraryFactory datatypeLibraryFactory, boolean bl) throws IllegalSchemaException, IOException, SAXException {
        try {
            SchemaCollection schemaCollection = new SchemaCollection();
            SchemaBuilderImpl schemaBuilderImpl = new SchemaBuilderImpl(parseable, errorHandler, schemaCollection.getSchemaDocumentMap(), datatypeLibraryFactory, bl);
            schemaCollection.setMainUri(string);
            schemaBuilderImpl.parse(parseable, string);
            if (schemaBuilderImpl.hadError) {
                throw new IllegalSchemaException();
            }
            return schemaCollection;
        }
        catch (BuildException buildException) {
            Throwable throwable = buildException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof SAXException) {
                throw (SAXException)throwable;
            }
            if (throwable instanceof Exception) {
                throw new SAXException((Exception)throwable);
            }
            throw new SAXException(throwable.getClass().getName() + " thrown");
        }
    }

    private void error(SAXParseException sAXParseException) throws BuildException {
        this.hadError = true;
        try {
            if (this.eh != null) {
                this.eh.error(sAXParseException);
            }
        }
        catch (SAXException sAXException) {
            throw new BuildException(sAXException);
        }
    }

    private void diagnoseDatatypeException(String string, String string2, DatatypeException datatypeException, SourceLocation sourceLocation) throws BuildException {
        String string3 = datatypeException.getMessage();
        if (string3 != null) {
            this.error(string, string3, sourceLocation);
        } else {
            this.error(string2, sourceLocation);
        }
    }

    private static Locator makeLocator(final SourceLocation sourceLocation) {
        return new Locator(){

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public int getColumnNumber() {
                if (sourceLocation == null) {
                    return -1;
                }
                return sourceLocation.getColumnNumber();
            }

            @Override
            public String getSystemId() {
                if (sourceLocation == null) {
                    return null;
                }
                return sourceLocation.getUri();
            }

            @Override
            public int getLineNumber() {
                if (sourceLocation == null) {
                    return -1;
                }
                return sourceLocation.getLineNumber();
            }
        };
    }

    private void error(String string, SourceLocation sourceLocation) throws BuildException {
        this.error(new SAXParseException(localizer.message(string), SchemaBuilderImpl.makeLocator(sourceLocation)));
    }

    private void error(String string, String string2, SourceLocation sourceLocation) throws BuildException {
        this.error(new SAXParseException(localizer.message(string, string2), SchemaBuilderImpl.makeLocator(sourceLocation)));
    }

    private void error(String string, String string2, String string3, SourceLocation sourceLocation) throws BuildException {
        this.error(new SAXParseException(localizer.message(string, string2, string3), SchemaBuilderImpl.makeLocator(sourceLocation)));
    }

    private void error(String string, String string2, String string3, String string4, SourceLocation sourceLocation) throws BuildException {
        this.error(new SAXParseException(localizer.message(string, new Object[]{string2, string3, string4}), SchemaBuilderImpl.makeLocator(sourceLocation)));
    }

    private static class TraceValidationContext
    implements ValidationContext {
        private final Map<String, String> map;
        private final ValidationContext vc;
        private final String ns;

        TraceValidationContext(Map<String, String> map, ValidationContext validationContext, String string) {
            this.map = map;
            this.vc = validationContext;
            this.ns = string.length() == 0 ? null : string;
        }

        @Override
        public String resolveNamespacePrefix(String string) {
            String string2;
            if (string.length() == 0) {
                string2 = this.ns;
            } else {
                string2 = this.vc.resolveNamespacePrefix(string);
                if (string2 == SchemaBuilder.INHERIT_NS) {
                    return null;
                }
            }
            if (string2 != null) {
                this.map.put(string, string2);
            }
            return string2;
        }

        @Override
        public String getBaseUri() {
            return this.vc.getBaseUri();
        }

        @Override
        public boolean isUnparsedEntity(String string) {
            return this.vc.isUnparsedEntity(string);
        }

        @Override
        public boolean isNotation(String string) {
            return this.vc.isNotation(string);
        }
    }

    private class GrammarSectionImpl
    extends ScopeImpl
    implements Grammar<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl>,
    Div<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl>,
    Include<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl>,
    IncludedGrammar<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> {
        private final Annotated subject;
        private final List<Component> components;
        Component lastComponent;

        private GrammarSectionImpl(Annotated annotated, Container container) {
            this.subject = annotated;
            this.components = container.getComponents();
        }

        @Override
        public void define(String string, GrammarSection.Combine combine, Pattern pattern, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
            if (string == "#start") {
                string = DefineComponent.START;
            }
            DefineComponent defineComponent = new DefineComponent(string, pattern);
            if (combine != null) {
                defineComponent.setCombine(SchemaBuilderImpl.mapCombine(combine));
            }
            SchemaBuilderImpl.finishAnnotated(defineComponent, sourceLocation, annotationsImpl);
            this.add(defineComponent);
        }

        @Override
        public Div<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> makeDiv() {
            DivComponent divComponent = new DivComponent();
            this.add(divComponent);
            return new GrammarSectionImpl(divComponent, divComponent);
        }

        @Override
        public Include<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> makeInclude() {
            IncludeComponent includeComponent = new IncludeComponent();
            this.add(includeComponent);
            return new GrammarSectionImpl(includeComponent, includeComponent);
        }

        @Override
        public void topLevelAnnotation(ElementAnnotationBuilderImpl elementAnnotationBuilderImpl) throws BuildException {
            if (this.lastComponent == null) {
                elementAnnotationBuilderImpl.addTo(this.subject.getChildElementAnnotations());
            } else {
                SchemaBuilderImpl.addAfterAnnotation(this.lastComponent, elementAnnotationBuilderImpl);
            }
        }

        @Override
        public void topLevelComment(CommentListImpl commentListImpl) throws BuildException {
            if (commentListImpl != null) {
                if (this.lastComponent == null) {
                    this.subject.getChildElementAnnotations().addAll(commentListImpl.list);
                } else {
                    SchemaBuilderImpl.addAfterComment(this.lastComponent, commentListImpl);
                }
            }
        }

        private void add(Component component) {
            this.components.add(component);
            this.lastComponent = component;
        }

        @Override
        public void endDiv(SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
            SchemaBuilderImpl.finishAnnotated(this.subject, sourceLocation, annotationsImpl);
        }

        @Override
        public void endInclude(String string, String string2, String string3, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException, IllegalSchemaException {
            IncludeComponent includeComponent = (IncludeComponent)this.subject;
            SubParseable<Pattern, NameClass, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> subParseable = SchemaBuilderImpl.this.subParser.createSubParseable(string, string2);
            String string4 = subParseable.getUri();
            includeComponent.setUri(string4);
            includeComponent.setBaseUri(string2);
            includeComponent.setHref(string);
            includeComponent.setNs(SchemaBuilderImpl.mapInheritNs(string3));
            SchemaBuilderImpl.finishAnnotated(includeComponent, sourceLocation, annotationsImpl);
            if (SchemaBuilderImpl.this.schemas.get(string4) == null) {
                SchemaBuilderImpl.this.schemas.put(string4, new SchemaDocument(null));
                GrammarPattern grammarPattern = new GrammarPattern();
                try {
                    Pattern pattern = subParseable.parseAsInclude(SchemaBuilderImpl.this, new GrammarSectionImpl(grammarPattern, grammarPattern));
                    SchemaBuilderImpl.this.schemas.put(string4, new SchemaDocument(pattern));
                }
                catch (IllegalSchemaException illegalSchemaException) {
                    SchemaBuilderImpl.this.schemas.remove(string4);
                    SchemaBuilderImpl.this.hadError = true;
                    throw illegalSchemaException;
                }
            }
        }

        @Override
        public Pattern endGrammar(SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
            SchemaBuilderImpl.finishAnnotated(this.subject, sourceLocation, annotationsImpl);
            return (Pattern)this.subject;
        }

        @Override
        public Pattern endIncludedGrammar(SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
            SchemaBuilderImpl.finishAnnotated(this.subject, sourceLocation, annotationsImpl);
            return (Pattern)this.subject;
        }
    }

    static class TrimmingCommentListImpl
    extends CommentListImpl {
        TrimmingCommentListImpl() {
        }

        @Override
        public void addComment(String string, SourceLocation sourceLocation) throws BuildException {
            super.addComment(CommentTrimmer.trimComment(string), sourceLocation);
        }
    }

    private class DataPatternBuilderImpl
    implements DataPatternBuilder<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> {
        private final DataPattern p;
        private DatatypeBuilder dtb = null;

        DataPatternBuilderImpl(DataPattern dataPattern) throws BuildException {
            this.p = dataPattern;
            DatatypeLibrary datatypeLibrary = SchemaBuilderImpl.this.dlf.createDatatypeLibrary(dataPattern.getDatatypeLibrary());
            if (datatypeLibrary != null) {
                try {
                    this.dtb = datatypeLibrary.createDatatypeBuilder(dataPattern.getType());
                }
                catch (DatatypeException datatypeException) {
                    String string = dataPattern.getDatatypeLibrary();
                    String string2 = dataPattern.getType();
                    SourceLocation sourceLocation = dataPattern.getSourceLocation();
                    String string3 = datatypeException.getMessage();
                    if (string3 != null) {
                        SchemaBuilderImpl.this.error("unsupported_datatype_detail", string, string2, string3, sourceLocation);
                    }
                    SchemaBuilderImpl.this.error("unknown_datatype", string, string2, sourceLocation);
                }
            }
        }

        @Override
        public void addParam(String string, String string2, Context context, String string3, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
            Param param = new Param(string, string2);
            param.setContext(new NamespaceContextImpl(context));
            SchemaBuilderImpl.finishAnnotated(param, sourceLocation, annotationsImpl);
            this.p.getParams().add(param);
            if (this.dtb != null) {
                try {
                    this.dtb.addParameter(string, string2, context);
                }
                catch (DatatypeException datatypeException) {
                    SchemaBuilderImpl.this.diagnoseDatatypeException("invalid_param_detail", "invalid_param", datatypeException, sourceLocation);
                }
            }
        }

        @Override
        public void annotation(ElementAnnotationBuilderImpl elementAnnotationBuilderImpl) {
            List<Param> list = this.p.getParams();
            elementAnnotationBuilderImpl.addTo(list.isEmpty() ? this.p.getChildElementAnnotations() : list.get(list.size() - 1).getFollowingElementAnnotations());
        }

        @Override
        public Pattern makePattern(SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
            if (this.dtb != null) {
                try {
                    this.dtb.createDatatype();
                }
                catch (DatatypeException datatypeException) {
                    SchemaBuilderImpl.this.diagnoseDatatypeException("invalid_params_detail", "invalid_params", datatypeException, sourceLocation);
                }
            }
            return SchemaBuilderImpl.finishPattern(this.p, sourceLocation, annotationsImpl);
        }

        @Override
        public Pattern makePattern(Pattern pattern, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
            this.p.setExcept(pattern);
            return SchemaBuilderImpl.finishPattern(this.p, sourceLocation, annotationsImpl);
        }
    }

    private static class ScopeImpl
    implements Scope<Pattern, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> {
        private ScopeImpl() {
        }

        @Override
        public Pattern makeRef(String string, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
            return SchemaBuilderImpl.finishPattern(new RefPattern(string), sourceLocation, annotationsImpl);
        }

        @Override
        public Pattern makeParentRef(String string, SourceLocation sourceLocation, AnnotationsImpl annotationsImpl) throws BuildException {
            return SchemaBuilderImpl.finishPattern(new ParentRefPattern(string), sourceLocation, annotationsImpl);
        }
    }
}

