// Copyright 2018 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.13.0
// source: grafeas.proto

package grafeas_go_proto

import (
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	attestation_go_proto "github.com/grafeas/grafeas/proto/v1beta1/attestation_go_proto"
	build_go_proto "github.com/grafeas/grafeas/proto/v1beta1/build_go_proto"
	common_go_proto "github.com/grafeas/grafeas/proto/v1beta1/common_go_proto"
	deployment_go_proto "github.com/grafeas/grafeas/proto/v1beta1/deployment_go_proto"
	discovery_go_proto "github.com/grafeas/grafeas/proto/v1beta1/discovery_go_proto"
	image_go_proto "github.com/grafeas/grafeas/proto/v1beta1/image_go_proto"
	intoto_go_proto "github.com/grafeas/grafeas/proto/v1beta1/intoto_go_proto"
	package_go_proto "github.com/grafeas/grafeas/proto/v1beta1/package_go_proto"
	provenance_go_proto "github.com/grafeas/grafeas/proto/v1beta1/provenance_go_proto"
	sbom_go_proto "github.com/grafeas/grafeas/proto/v1beta1/sbom_go_proto"
	spdx_go_proto "github.com/grafeas/grafeas/proto/v1beta1/spdx_go_proto"
	vex_go_proto "github.com/grafeas/grafeas/proto/v1beta1/vex_go_proto"
	vulnerability_go_proto "github.com/grafeas/grafeas/proto/v1beta1/vulnerability_go_proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An instance of an analysis type that has been found on a resource.
type Occurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The resource for which the occurrence applies.
	Resource *Resource `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// Required. Immutable. The analysis note associated with this occurrence, in
	// the form of `projects/[PROVIDER_ID]/notes/[NOTE_ID]`. This field can be
	// used as a filter in list requests.
	NoteName string `protobuf:"bytes,3,opt,name=note_name,json=noteName,proto3" json:"note_name,omitempty"`
	// Output only. This explicitly denotes which of the occurrence details are
	// specified. This field can be used as a filter in list requests.
	Kind common_go_proto.NoteKind `protobuf:"varint,4,opt,name=kind,proto3,enum=grafeas.v1beta1.NoteKind" json:"kind,omitempty"`
	// A description of actions that can be taken to remedy the note.
	Remediation string `protobuf:"bytes,5,opt,name=remediation,proto3" json:"remediation,omitempty"`
	// Output only. The time this occurrence was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this occurrence was last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Immutable. Describes the details of the note kind found on this
	// resource.
	//
	// Types that are assignable to Details:
	//
	//	*Occurrence_Vulnerability
	//	*Occurrence_Build
	//	*Occurrence_DerivedImage
	//	*Occurrence_Installation
	//	*Occurrence_Deployment
	//	*Occurrence_Discovered
	//	*Occurrence_Attestation
	//	*Occurrence_Intoto
	//	*Occurrence_Sbom
	//	*Occurrence_SpdxPackage
	//	*Occurrence_SpdxFile
	//	*Occurrence_SpdxRelationship
	//	*Occurrence_SbomReference
	Details isOccurrence_Details `protobuf_oneof:"details"`
	// https://github.com/secure-systems-lab/dsse
	Envelope *common_go_proto.Envelope `protobuf:"bytes,20,opt,name=envelope,proto3" json:"envelope,omitempty"`
}

func (x *Occurrence) Reset() {
	*x = Occurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Occurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Occurrence) ProtoMessage() {}

func (x *Occurrence) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Occurrence.ProtoReflect.Descriptor instead.
func (*Occurrence) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{0}
}

func (x *Occurrence) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Occurrence) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *Occurrence) GetNoteName() string {
	if x != nil {
		return x.NoteName
	}
	return ""
}

func (x *Occurrence) GetKind() common_go_proto.NoteKind {
	if x != nil {
		return x.Kind
	}
	return common_go_proto.NoteKind(0)
}

func (x *Occurrence) GetRemediation() string {
	if x != nil {
		return x.Remediation
	}
	return ""
}

func (x *Occurrence) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Occurrence) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (m *Occurrence) GetDetails() isOccurrence_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *Occurrence) GetVulnerability() *vulnerability_go_proto.Details {
	if x, ok := x.GetDetails().(*Occurrence_Vulnerability); ok {
		return x.Vulnerability
	}
	return nil
}

func (x *Occurrence) GetBuild() *build_go_proto.Details {
	if x, ok := x.GetDetails().(*Occurrence_Build); ok {
		return x.Build
	}
	return nil
}

func (x *Occurrence) GetDerivedImage() *image_go_proto.Details {
	if x, ok := x.GetDetails().(*Occurrence_DerivedImage); ok {
		return x.DerivedImage
	}
	return nil
}

func (x *Occurrence) GetInstallation() *package_go_proto.Details {
	if x, ok := x.GetDetails().(*Occurrence_Installation); ok {
		return x.Installation
	}
	return nil
}

func (x *Occurrence) GetDeployment() *deployment_go_proto.Details {
	if x, ok := x.GetDetails().(*Occurrence_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (x *Occurrence) GetDiscovered() *discovery_go_proto.Details {
	if x, ok := x.GetDetails().(*Occurrence_Discovered); ok {
		return x.Discovered
	}
	return nil
}

func (x *Occurrence) GetAttestation() *attestation_go_proto.Details {
	if x, ok := x.GetDetails().(*Occurrence_Attestation); ok {
		return x.Attestation
	}
	return nil
}

func (x *Occurrence) GetIntoto() *intoto_go_proto.Details {
	if x, ok := x.GetDetails().(*Occurrence_Intoto); ok {
		return x.Intoto
	}
	return nil
}

func (x *Occurrence) GetSbom() *spdx_go_proto.DocumentOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_Sbom); ok {
		return x.Sbom
	}
	return nil
}

func (x *Occurrence) GetSpdxPackage() *spdx_go_proto.PackageInfoOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_SpdxPackage); ok {
		return x.SpdxPackage
	}
	return nil
}

func (x *Occurrence) GetSpdxFile() *spdx_go_proto.FileOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_SpdxFile); ok {
		return x.SpdxFile
	}
	return nil
}

func (x *Occurrence) GetSpdxRelationship() *spdx_go_proto.RelationshipOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_SpdxRelationship); ok {
		return x.SpdxRelationship
	}
	return nil
}

func (x *Occurrence) GetSbomReference() *sbom_go_proto.SBOMReferenceOccurrence {
	if x, ok := x.GetDetails().(*Occurrence_SbomReference); ok {
		return x.SbomReference
	}
	return nil
}

func (x *Occurrence) GetEnvelope() *common_go_proto.Envelope {
	if x != nil {
		return x.Envelope
	}
	return nil
}

type isOccurrence_Details interface {
	isOccurrence_Details()
}

type Occurrence_Vulnerability struct {
	// Describes a security vulnerability.
	Vulnerability *vulnerability_go_proto.Details `protobuf:"bytes,8,opt,name=vulnerability,proto3,oneof"`
}

type Occurrence_Build struct {
	// Describes a verifiable build.
	Build *build_go_proto.Details `protobuf:"bytes,9,opt,name=build,proto3,oneof"`
}

type Occurrence_DerivedImage struct {
	// Describes how this resource derives from the basis in the associated
	// note.
	DerivedImage *image_go_proto.Details `protobuf:"bytes,10,opt,name=derived_image,json=derivedImage,proto3,oneof"`
}

type Occurrence_Installation struct {
	// Describes the installation of a package on the linked resource.
	Installation *package_go_proto.Details `protobuf:"bytes,11,opt,name=installation,proto3,oneof"`
}

type Occurrence_Deployment struct {
	// Describes the deployment of an artifact on a runtime.
	Deployment *deployment_go_proto.Details `protobuf:"bytes,12,opt,name=deployment,proto3,oneof"`
}

type Occurrence_Discovered struct {
	// Describes when a resource was discovered.
	Discovered *discovery_go_proto.Details `protobuf:"bytes,13,opt,name=discovered,proto3,oneof"`
}

type Occurrence_Attestation struct {
	// Describes an attestation of an artifact.
	Attestation *attestation_go_proto.Details `protobuf:"bytes,14,opt,name=attestation,proto3,oneof"`
}

type Occurrence_Intoto struct {
	// Describes a specific in-toto link.
	Intoto *intoto_go_proto.Details `protobuf:"bytes,15,opt,name=intoto,proto3,oneof"`
}

type Occurrence_Sbom struct {
	// Describes a specific software bill of materials document.
	Sbom *spdx_go_proto.DocumentOccurrence `protobuf:"bytes,16,opt,name=sbom,proto3,oneof"`
}

type Occurrence_SpdxPackage struct {
	// Describes a specific SPDX Package.
	SpdxPackage *spdx_go_proto.PackageInfoOccurrence `protobuf:"bytes,17,opt,name=spdx_package,json=spdxPackage,proto3,oneof"`
}

type Occurrence_SpdxFile struct {
	// Describes a specific SPDX File.
	SpdxFile *spdx_go_proto.FileOccurrence `protobuf:"bytes,18,opt,name=spdx_file,json=spdxFile,proto3,oneof"`
}

type Occurrence_SpdxRelationship struct {
	// Describes a specific SPDX Relationship.
	SpdxRelationship *spdx_go_proto.RelationshipOccurrence `protobuf:"bytes,19,opt,name=spdx_relationship,json=spdxRelationship,proto3,oneof"`
}

type Occurrence_SbomReference struct {
	// Describes a specific SBOM reference occurrences.
	SbomReference *sbom_go_proto.SBOMReferenceOccurrence `protobuf:"bytes,21,opt,name=sbom_reference,json=sbomReference,proto3,oneof"`
}

func (*Occurrence_Vulnerability) isOccurrence_Details() {}

func (*Occurrence_Build) isOccurrence_Details() {}

func (*Occurrence_DerivedImage) isOccurrence_Details() {}

func (*Occurrence_Installation) isOccurrence_Details() {}

func (*Occurrence_Deployment) isOccurrence_Details() {}

func (*Occurrence_Discovered) isOccurrence_Details() {}

func (*Occurrence_Attestation) isOccurrence_Details() {}

func (*Occurrence_Intoto) isOccurrence_Details() {}

func (*Occurrence_Sbom) isOccurrence_Details() {}

func (*Occurrence_SpdxPackage) isOccurrence_Details() {}

func (*Occurrence_SpdxFile) isOccurrence_Details() {}

func (*Occurrence_SpdxRelationship) isOccurrence_Details() {}

func (*Occurrence_SbomReference) isOccurrence_Details() {}

// An entity that can have metadata. For example, a Docker image.
type Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated, do not use. Use uri instead.
	//
	// The name of the resource. For example, the name of a Docker image -
	// "Debian".
	//
	// Deprecated: Do not use.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The unique URI of the resource. For example,
	// `https://gcr.io/project/image@sha256:foo` for a Docker image.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Deprecated, do not use. Use uri instead.
	//
	// The hash of the resource content. For example, the Docker digest.
	//
	// Deprecated: Do not use.
	ContentHash *provenance_go_proto.Hash `protobuf:"bytes,3,opt,name=content_hash,json=contentHash,proto3" json:"content_hash,omitempty"`
}

func (x *Resource) Reset() {
	*x = Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{1}
}

// Deprecated: Do not use.
func (x *Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Resource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Deprecated: Do not use.
func (x *Resource) GetContentHash() *provenance_go_proto.Hash {
	if x != nil {
		return x.ContentHash
	}
	return nil
}

// A type of analysis that can be done for a resource.
type Note struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A one sentence description of this note.
	ShortDescription string `protobuf:"bytes,2,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// A detailed description of this note.
	LongDescription string `protobuf:"bytes,3,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Output only. The type of analysis. This field can be used as a filter in
	// list requests.
	Kind common_go_proto.NoteKind `protobuf:"varint,4,opt,name=kind,proto3,enum=grafeas.v1beta1.NoteKind" json:"kind,omitempty"`
	// URLs associated with this note.
	RelatedUrl []*common_go_proto.RelatedUrl `protobuf:"bytes,5,rep,name=related_url,json=relatedUrl,proto3" json:"related_url,omitempty"`
	// Time of expiration for this note. Empty if note does not expire.
	ExpirationTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Output only. The time this note was created. This field can be used as a
	// filter in list requests.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this note was last updated. This field can be used as
	// a filter in list requests.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Other notes related to this note.
	RelatedNoteNames []string `protobuf:"bytes,9,rep,name=related_note_names,json=relatedNoteNames,proto3" json:"related_note_names,omitempty"`
	// Required. Immutable. The type of analysis this note represents.
	//
	// Types that are assignable to Type:
	//
	//	*Note_Vulnerability
	//	*Note_Build
	//	*Note_BaseImage
	//	*Note_Package
	//	*Note_Deployable
	//	*Note_Discovery
	//	*Note_AttestationAuthority
	//	*Note_Intoto
	//	*Note_Sbom
	//	*Note_SpdxPackage
	//	*Note_SpdxFile
	//	*Note_SpdxRelationship
	//	*Note_VulnerabilityAssessment
	//	*Note_SbomReference
	Type isNote_Type `protobuf_oneof:"type"`
}

func (x *Note) Reset() {
	*x = Note{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Note) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Note) ProtoMessage() {}

func (x *Note) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Note.ProtoReflect.Descriptor instead.
func (*Note) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{2}
}

func (x *Note) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Note) GetShortDescription() string {
	if x != nil {
		return x.ShortDescription
	}
	return ""
}

func (x *Note) GetLongDescription() string {
	if x != nil {
		return x.LongDescription
	}
	return ""
}

func (x *Note) GetKind() common_go_proto.NoteKind {
	if x != nil {
		return x.Kind
	}
	return common_go_proto.NoteKind(0)
}

func (x *Note) GetRelatedUrl() []*common_go_proto.RelatedUrl {
	if x != nil {
		return x.RelatedUrl
	}
	return nil
}

func (x *Note) GetExpirationTime() *timestamp.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *Note) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Note) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Note) GetRelatedNoteNames() []string {
	if x != nil {
		return x.RelatedNoteNames
	}
	return nil
}

func (m *Note) GetType() isNote_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Note) GetVulnerability() *vulnerability_go_proto.Vulnerability {
	if x, ok := x.GetType().(*Note_Vulnerability); ok {
		return x.Vulnerability
	}
	return nil
}

func (x *Note) GetBuild() *build_go_proto.Build {
	if x, ok := x.GetType().(*Note_Build); ok {
		return x.Build
	}
	return nil
}

func (x *Note) GetBaseImage() *image_go_proto.Basis {
	if x, ok := x.GetType().(*Note_BaseImage); ok {
		return x.BaseImage
	}
	return nil
}

func (x *Note) GetPackage() *package_go_proto.Package {
	if x, ok := x.GetType().(*Note_Package); ok {
		return x.Package
	}
	return nil
}

func (x *Note) GetDeployable() *deployment_go_proto.Deployable {
	if x, ok := x.GetType().(*Note_Deployable); ok {
		return x.Deployable
	}
	return nil
}

func (x *Note) GetDiscovery() *discovery_go_proto.Discovery {
	if x, ok := x.GetType().(*Note_Discovery); ok {
		return x.Discovery
	}
	return nil
}

func (x *Note) GetAttestationAuthority() *attestation_go_proto.Authority {
	if x, ok := x.GetType().(*Note_AttestationAuthority); ok {
		return x.AttestationAuthority
	}
	return nil
}

func (x *Note) GetIntoto() *intoto_go_proto.InToto {
	if x, ok := x.GetType().(*Note_Intoto); ok {
		return x.Intoto
	}
	return nil
}

func (x *Note) GetSbom() *spdx_go_proto.DocumentNote {
	if x, ok := x.GetType().(*Note_Sbom); ok {
		return x.Sbom
	}
	return nil
}

func (x *Note) GetSpdxPackage() *spdx_go_proto.PackageInfoNote {
	if x, ok := x.GetType().(*Note_SpdxPackage); ok {
		return x.SpdxPackage
	}
	return nil
}

func (x *Note) GetSpdxFile() *spdx_go_proto.FileNote {
	if x, ok := x.GetType().(*Note_SpdxFile); ok {
		return x.SpdxFile
	}
	return nil
}

func (x *Note) GetSpdxRelationship() *spdx_go_proto.RelationshipNote {
	if x, ok := x.GetType().(*Note_SpdxRelationship); ok {
		return x.SpdxRelationship
	}
	return nil
}

func (x *Note) GetVulnerabilityAssessment() *vex_go_proto.VulnerabilityAssessmentNote {
	if x, ok := x.GetType().(*Note_VulnerabilityAssessment); ok {
		return x.VulnerabilityAssessment
	}
	return nil
}

func (x *Note) GetSbomReference() *sbom_go_proto.SBOMReferenceNote {
	if x, ok := x.GetType().(*Note_SbomReference); ok {
		return x.SbomReference
	}
	return nil
}

type isNote_Type interface {
	isNote_Type()
}

type Note_Vulnerability struct {
	// A note describing a package vulnerability.
	Vulnerability *vulnerability_go_proto.Vulnerability `protobuf:"bytes,10,opt,name=vulnerability,proto3,oneof"`
}

type Note_Build struct {
	// A note describing build provenance for a verifiable build.
	Build *build_go_proto.Build `protobuf:"bytes,11,opt,name=build,proto3,oneof"`
}

type Note_BaseImage struct {
	// A note describing a base image.
	BaseImage *image_go_proto.Basis `protobuf:"bytes,12,opt,name=base_image,json=baseImage,proto3,oneof"`
}

type Note_Package struct {
	// A note describing a package hosted by various package managers.
	Package *package_go_proto.Package `protobuf:"bytes,13,opt,name=package,proto3,oneof"`
}

type Note_Deployable struct {
	// A note describing something that can be deployed.
	Deployable *deployment_go_proto.Deployable `protobuf:"bytes,14,opt,name=deployable,proto3,oneof"`
}

type Note_Discovery struct {
	// A note describing the initial analysis of a resource.
	Discovery *discovery_go_proto.Discovery `protobuf:"bytes,15,opt,name=discovery,proto3,oneof"`
}

type Note_AttestationAuthority struct {
	// A note describing an attestation role.
	AttestationAuthority *attestation_go_proto.Authority `protobuf:"bytes,16,opt,name=attestation_authority,json=attestationAuthority,proto3,oneof"`
}

type Note_Intoto struct {
	// A note describing an in-toto link.
	Intoto *intoto_go_proto.InToto `protobuf:"bytes,17,opt,name=intoto,proto3,oneof"`
}

type Note_Sbom struct {
	// A note describing a software bill of materials.
	Sbom *spdx_go_proto.DocumentNote `protobuf:"bytes,18,opt,name=sbom,proto3,oneof"`
}

type Note_SpdxPackage struct {
	// A note describing an SPDX Package.
	SpdxPackage *spdx_go_proto.PackageInfoNote `protobuf:"bytes,19,opt,name=spdx_package,json=spdxPackage,proto3,oneof"`
}

type Note_SpdxFile struct {
	// A note describing an SPDX File.
	SpdxFile *spdx_go_proto.FileNote `protobuf:"bytes,20,opt,name=spdx_file,json=spdxFile,proto3,oneof"`
}

type Note_SpdxRelationship struct {
	// A note describing an SPDX File.
	SpdxRelationship *spdx_go_proto.RelationshipNote `protobuf:"bytes,21,opt,name=spdx_relationship,json=spdxRelationship,proto3,oneof"`
}

type Note_VulnerabilityAssessment struct {
	// A note describing a vulnerability assessment.
	VulnerabilityAssessment *vex_go_proto.VulnerabilityAssessmentNote `protobuf:"bytes,22,opt,name=vulnerability_assessment,json=vulnerabilityAssessment,proto3,oneof"`
}

type Note_SbomReference struct {
	// A note describing an SBOM reference.
	SbomReference *sbom_go_proto.SBOMReferenceNote `protobuf:"bytes,23,opt,name=sbom_reference,json=sbomReference,proto3,oneof"`
}

func (*Note_Vulnerability) isNote_Type() {}

func (*Note_Build) isNote_Type() {}

func (*Note_BaseImage) isNote_Type() {}

func (*Note_Package) isNote_Type() {}

func (*Note_Deployable) isNote_Type() {}

func (*Note_Discovery) isNote_Type() {}

func (*Note_AttestationAuthority) isNote_Type() {}

func (*Note_Intoto) isNote_Type() {}

func (*Note_Sbom) isNote_Type() {}

func (*Note_SpdxPackage) isNote_Type() {}

func (*Note_SpdxFile) isNote_Type() {}

func (*Note_SpdxRelationship) isNote_Type() {}

func (*Note_VulnerabilityAssessment) isNote_Type() {}

func (*Note_SbomReference) isNote_Type() {}

// Request to get an occurrence.
type GetOccurrenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOccurrenceRequest) Reset() {
	*x = GetOccurrenceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOccurrenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOccurrenceRequest) ProtoMessage() {}

func (x *GetOccurrenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOccurrenceRequest.ProtoReflect.Descriptor instead.
func (*GetOccurrenceRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{3}
}

func (x *GetOccurrenceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list occurrences.
type ListOccurrencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project to list occurrences for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of occurrences to return in the list. Must be positive. Max allowed
	// page size is 1000. If not specified, page size defaults to 20.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListOccurrencesRequest) Reset() {
	*x = ListOccurrencesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOccurrencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOccurrencesRequest) ProtoMessage() {}

func (x *ListOccurrencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOccurrencesRequest.ProtoReflect.Descriptor instead.
func (*ListOccurrencesRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{4}
}

func (x *ListOccurrencesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOccurrencesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListOccurrencesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOccurrencesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for listing occurrences.
type ListOccurrencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The occurrences requested.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOccurrencesResponse) Reset() {
	*x = ListOccurrencesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOccurrencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOccurrencesResponse) ProtoMessage() {}

func (x *ListOccurrencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOccurrencesResponse.ProtoReflect.Descriptor instead.
func (*ListOccurrencesResponse) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{5}
}

func (x *ListOccurrencesResponse) GetOccurrences() []*Occurrence {
	if x != nil {
		return x.Occurrences
	}
	return nil
}

func (x *ListOccurrencesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to delete a occurrence.
type DeleteOccurrenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteOccurrenceRequest) Reset() {
	*x = DeleteOccurrenceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteOccurrenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOccurrenceRequest) ProtoMessage() {}

func (x *DeleteOccurrenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteOccurrenceRequest.ProtoReflect.Descriptor instead.
func (*DeleteOccurrenceRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteOccurrenceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to create a new occurrence.
type CreateOccurrenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the occurrence is to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The occurrence to create.
	Occurrence *Occurrence `protobuf:"bytes,2,opt,name=occurrence,proto3" json:"occurrence,omitempty"`
}

func (x *CreateOccurrenceRequest) Reset() {
	*x = CreateOccurrenceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOccurrenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOccurrenceRequest) ProtoMessage() {}

func (x *CreateOccurrenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOccurrenceRequest.ProtoReflect.Descriptor instead.
func (*CreateOccurrenceRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{7}
}

func (x *CreateOccurrenceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateOccurrenceRequest) GetOccurrence() *Occurrence {
	if x != nil {
		return x.Occurrence
	}
	return nil
}

// Request to update an occurrence.
type UpdateOccurrenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The updated occurrence.
	Occurrence *Occurrence `protobuf:"bytes,2,opt,name=occurrence,proto3" json:"occurrence,omitempty"`
	// The fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateOccurrenceRequest) Reset() {
	*x = UpdateOccurrenceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateOccurrenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOccurrenceRequest) ProtoMessage() {}

func (x *UpdateOccurrenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOccurrenceRequest.ProtoReflect.Descriptor instead.
func (*UpdateOccurrenceRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateOccurrenceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateOccurrenceRequest) GetOccurrence() *Occurrence {
	if x != nil {
		return x.Occurrence
	}
	return nil
}

func (x *UpdateOccurrenceRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to get a note.
type GetNoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNoteRequest) Reset() {
	*x = GetNoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNoteRequest) ProtoMessage() {}

func (x *GetNoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNoteRequest.ProtoReflect.Descriptor instead.
func (*GetNoteRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{9}
}

func (x *GetNoteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to get the note to which the specified occurrence is attached.
type GetOccurrenceNoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOccurrenceNoteRequest) Reset() {
	*x = GetOccurrenceNoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOccurrenceNoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOccurrenceNoteRequest) ProtoMessage() {}

func (x *GetOccurrenceNoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOccurrenceNoteRequest.ProtoReflect.Descriptor instead.
func (*GetOccurrenceNoteRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{10}
}

func (x *GetOccurrenceNoteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list notes.
type ListNotesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project to list notes for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of notes to return in the list. Must be positive. Max allowed page
	// size is 1000. If not specified, page size defaults to 20.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListNotesRequest) Reset() {
	*x = ListNotesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotesRequest) ProtoMessage() {}

func (x *ListNotesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotesRequest.ProtoReflect.Descriptor instead.
func (*ListNotesRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{11}
}

func (x *ListNotesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNotesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListNotesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNotesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for listing notes.
type ListNotesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The notes requested.
	Notes []*Note `protobuf:"bytes,1,rep,name=notes,proto3" json:"notes,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListNotesResponse) Reset() {
	*x = ListNotesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotesResponse) ProtoMessage() {}

func (x *ListNotesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotesResponse.ProtoReflect.Descriptor instead.
func (*ListNotesResponse) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{12}
}

func (x *ListNotesResponse) GetNotes() []*Note {
	if x != nil {
		return x.Notes
	}
	return nil
}

func (x *ListNotesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to delete a note.
type DeleteNoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteNoteRequest) Reset() {
	*x = DeleteNoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNoteRequest) ProtoMessage() {}

func (x *DeleteNoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNoteRequest.ProtoReflect.Descriptor instead.
func (*DeleteNoteRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteNoteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to create a new note.
type CreateNoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the note is to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The ID to use for this note.
	NoteId string `protobuf:"bytes,2,opt,name=note_id,json=noteId,proto3" json:"note_id,omitempty"`
	// The note to create.
	Note *Note `protobuf:"bytes,3,opt,name=note,proto3" json:"note,omitempty"`
}

func (x *CreateNoteRequest) Reset() {
	*x = CreateNoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNoteRequest) ProtoMessage() {}

func (x *CreateNoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNoteRequest.ProtoReflect.Descriptor instead.
func (*CreateNoteRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{14}
}

func (x *CreateNoteRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateNoteRequest) GetNoteId() string {
	if x != nil {
		return x.NoteId
	}
	return ""
}

func (x *CreateNoteRequest) GetNote() *Note {
	if x != nil {
		return x.Note
	}
	return nil
}

// Request to update a note.
type UpdateNoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The updated note.
	Note *Note `protobuf:"bytes,2,opt,name=note,proto3" json:"note,omitempty"`
	// The fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateNoteRequest) Reset() {
	*x = UpdateNoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNoteRequest) ProtoMessage() {}

func (x *UpdateNoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNoteRequest.ProtoReflect.Descriptor instead.
func (*UpdateNoteRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateNoteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateNoteRequest) GetNote() *Note {
	if x != nil {
		return x.Note
	}
	return nil
}

func (x *UpdateNoteRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to list occurrences for a note.
type ListNoteOccurrencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the note to list occurrences for in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of occurrences to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListNoteOccurrencesRequest) Reset() {
	*x = ListNoteOccurrencesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNoteOccurrencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNoteOccurrencesRequest) ProtoMessage() {}

func (x *ListNoteOccurrencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNoteOccurrencesRequest.ProtoReflect.Descriptor instead.
func (*ListNoteOccurrencesRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{16}
}

func (x *ListNoteOccurrencesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListNoteOccurrencesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListNoteOccurrencesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNoteOccurrencesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for listing occurrences for a note.
type ListNoteOccurrencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The occurrences attached to the specified note.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListNoteOccurrencesResponse) Reset() {
	*x = ListNoteOccurrencesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNoteOccurrencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNoteOccurrencesResponse) ProtoMessage() {}

func (x *ListNoteOccurrencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNoteOccurrencesResponse.ProtoReflect.Descriptor instead.
func (*ListNoteOccurrencesResponse) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{17}
}

func (x *ListNoteOccurrencesResponse) GetOccurrences() []*Occurrence {
	if x != nil {
		return x.Occurrences
	}
	return nil
}

func (x *ListNoteOccurrencesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to create notes in batch.
type BatchCreateNotesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the notes are to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The notes to create, the key is expected to be the note ID. Max allowed length is 1000.
	Notes map[string]*Note `protobuf:"bytes,2,rep,name=notes,proto3" json:"notes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchCreateNotesRequest) Reset() {
	*x = BatchCreateNotesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateNotesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateNotesRequest) ProtoMessage() {}

func (x *BatchCreateNotesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateNotesRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateNotesRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{18}
}

func (x *BatchCreateNotesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateNotesRequest) GetNotes() map[string]*Note {
	if x != nil {
		return x.Notes
	}
	return nil
}

// Response for creating notes in batch.
type BatchCreateNotesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The notes that were created.
	Notes []*Note `protobuf:"bytes,1,rep,name=notes,proto3" json:"notes,omitempty"`
}

func (x *BatchCreateNotesResponse) Reset() {
	*x = BatchCreateNotesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateNotesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateNotesResponse) ProtoMessage() {}

func (x *BatchCreateNotesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateNotesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateNotesResponse) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{19}
}

func (x *BatchCreateNotesResponse) GetNotes() []*Note {
	if x != nil {
		return x.Notes
	}
	return nil
}

// Request to create occurrences in batch.
type BatchCreateOccurrencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the occurrences are to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The occurrences to create. Max allowed length is 1000.
	Occurrences []*Occurrence `protobuf:"bytes,2,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
}

func (x *BatchCreateOccurrencesRequest) Reset() {
	*x = BatchCreateOccurrencesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateOccurrencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateOccurrencesRequest) ProtoMessage() {}

func (x *BatchCreateOccurrencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateOccurrencesRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateOccurrencesRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{20}
}

func (x *BatchCreateOccurrencesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateOccurrencesRequest) GetOccurrences() []*Occurrence {
	if x != nil {
		return x.Occurrences
	}
	return nil
}

// Response for creating occurrences in batch.
type BatchCreateOccurrencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The occurrences that were created.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
}

func (x *BatchCreateOccurrencesResponse) Reset() {
	*x = BatchCreateOccurrencesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateOccurrencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateOccurrencesResponse) ProtoMessage() {}

func (x *BatchCreateOccurrencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateOccurrencesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateOccurrencesResponse) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{21}
}

func (x *BatchCreateOccurrencesResponse) GetOccurrences() []*Occurrence {
	if x != nil {
		return x.Occurrences
	}
	return nil
}

// Request to get a vulnerability summary for some set of occurrences.
type GetVulnerabilityOccurrencesSummaryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the project to get a vulnerability summary for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *GetVulnerabilityOccurrencesSummaryRequest) Reset() {
	*x = GetVulnerabilityOccurrencesSummaryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVulnerabilityOccurrencesSummaryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVulnerabilityOccurrencesSummaryRequest) ProtoMessage() {}

func (x *GetVulnerabilityOccurrencesSummaryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVulnerabilityOccurrencesSummaryRequest.ProtoReflect.Descriptor instead.
func (*GetVulnerabilityOccurrencesSummaryRequest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{22}
}

func (x *GetVulnerabilityOccurrencesSummaryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GetVulnerabilityOccurrencesSummaryRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// A summary of how many vulnerability occurrences there are per resource and
// severity type.
type VulnerabilityOccurrencesSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A listing by resource of the number of fixable and total vulnerabilities.
	Counts []*VulnerabilityOccurrencesSummary_FixableTotalByDigest `protobuf:"bytes,1,rep,name=counts,proto3" json:"counts,omitempty"`
}

func (x *VulnerabilityOccurrencesSummary) Reset() {
	*x = VulnerabilityOccurrencesSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityOccurrencesSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityOccurrencesSummary) ProtoMessage() {}

func (x *VulnerabilityOccurrencesSummary) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityOccurrencesSummary.ProtoReflect.Descriptor instead.
func (*VulnerabilityOccurrencesSummary) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{23}
}

func (x *VulnerabilityOccurrencesSummary) GetCounts() []*VulnerabilityOccurrencesSummary_FixableTotalByDigest {
	if x != nil {
		return x.Counts
	}
	return nil
}

// Per resource and severity counts of fixable and total vulnerabilities.
type VulnerabilityOccurrencesSummary_FixableTotalByDigest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The affected resource.
	Resource *Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The severity for this count. SEVERITY_UNSPECIFIED indicates total across
	// all severities.
	Severity vulnerability_go_proto.Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1beta1.vulnerability.Severity" json:"severity,omitempty"`
	// The number of fixable vulnerabilities associated with this resource.
	FixableCount int64 `protobuf:"varint,3,opt,name=fixable_count,json=fixableCount,proto3" json:"fixable_count,omitempty"`
	// The total number of vulnerabilities associated with this resource.
	TotalCount int64 `protobuf:"varint,4,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
}

func (x *VulnerabilityOccurrencesSummary_FixableTotalByDigest) Reset() {
	*x = VulnerabilityOccurrencesSummary_FixableTotalByDigest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityOccurrencesSummary_FixableTotalByDigest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityOccurrencesSummary_FixableTotalByDigest) ProtoMessage() {}

func (x *VulnerabilityOccurrencesSummary_FixableTotalByDigest) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityOccurrencesSummary_FixableTotalByDigest.ProtoReflect.Descriptor instead.
func (*VulnerabilityOccurrencesSummary_FixableTotalByDigest) Descriptor() ([]byte, []int) {
	return file_grafeas_proto_rawDescGZIP(), []int{23, 0}
}

func (x *VulnerabilityOccurrencesSummary_FixableTotalByDigest) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *VulnerabilityOccurrencesSummary_FixableTotalByDigest) GetSeverity() vulnerability_go_proto.Severity {
	if x != nil {
		return x.Severity
	}
	return vulnerability_go_proto.Severity(0)
}

func (x *VulnerabilityOccurrencesSummary_FixableTotalByDigest) GetFixableCount() int64 {
	if x != nil {
		return x.FixableCount
	}
	return 0
}

func (x *VulnerabilityOccurrencesSummary_FixableTotalByDigest) GetTotalCount() int64 {
	if x != nil {
		return x.TotalCount
	}
	return 0
}

var File_grafeas_proto protoreflect.FileDescriptor

var file_grafeas_proto_rawDesc = []byte{
	0x0a, 0x0d, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x0f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1a, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x62,
	0x6f, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x76, 0x65, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x75, 0x6c, 0x6e, 0x65,
	0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xff,
	0x0a, 0x0a, 0x0a, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x6f, 0x74, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x6f, 0x74,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4e, 0x0a, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x36, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x45, 0x0a, 0x0d, 0x64, 0x65, 0x72, 0x69,
	0x76, 0x65, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x0c, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12,
	0x46, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x2e,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x48, 0x00, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x44,
	0x0a, 0x0a, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x65, 0x64, 0x12, 0x48, 0x0a, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x61, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39,
	0x0a, 0x06, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x12, 0x3e, 0x0a, 0x04, 0x73, 0x62, 0x6f,
	0x6d, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x04, 0x73, 0x62, 0x6f, 0x6d, 0x12, 0x50, 0x0a, 0x0c, 0x73, 0x70, 0x64,
	0x78, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0b,
	0x73, 0x70, 0x64, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x43, 0x0a, 0x09, 0x73,
	0x70, 0x64, 0x78, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x08, 0x73, 0x70, 0x64, 0x78, 0x46, 0x69, 0x6c, 0x65,
	0x12, 0x5b, 0x0a, 0x11, 0x73, 0x70, 0x64, 0x78, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x68, 0x69, 0x70, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x70,
	0x64, 0x78, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x4f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x10, 0x73, 0x70, 0x64,
	0x78, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x12, 0x56, 0x0a,
	0x0e, 0x73, 0x62, 0x6f, 0x6d, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x62, 0x6f, 0x6d, 0x2e, 0x53, 0x42, 0x4f,
	0x4d, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x62, 0x6f, 0x6d, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x52, 0x08, 0x65, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x3a, 0x47, 0xea, 0x41,
	0x44, 0x0a, 0x15, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4f, 0x63,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x7d, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x22, 0x7d, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x47, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x73, 0x68, 0x22,
	0x9a, 0x0c, 0x0a, 0x04, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11,
	0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x6c, 0x6f, 0x6e,
	0x67, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x6c, 0x6f, 0x6e, 0x67, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x19, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x12, 0x3c, 0x0a, 0x0b, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x75,
	0x72, 0x6c, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x0a, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x55, 0x72,
	0x6c, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x74, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x4e, 0x6f, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x54,
	0x0a, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x12, 0x34, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x48, 0x00, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x3d, 0x0a, 0x0a, 0x62, 0x61,
	0x73, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2e, 0x42, 0x61, 0x73, 0x69, 0x73, 0x48, 0x00, 0x52, 0x09,
	0x62, 0x61, 0x73, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x3c, 0x0a, 0x07, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x07,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x48, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x61,
	0x62, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x44, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x09, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x12, 0x5d, 0x0a, 0x15, 0x61, 0x74, 0x74, 0x65, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x48, 0x00,
	0x52, 0x14, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x38, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e,
	0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x48, 0x00, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f,
	0x12, 0x38, 0x0a, 0x04, 0x73, 0x62, 0x6f, 0x6d, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f,
	0x74, 0x65, 0x48, 0x00, 0x52, 0x04, 0x73, 0x62, 0x6f, 0x6d, 0x12, 0x4a, 0x0a, 0x0c, 0x73, 0x70,
	0x64, 0x78, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x70, 0x64, 0x78, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x3d, 0x0a, 0x09, 0x73, 0x70, 0x64, 0x78, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x70, 0x64, 0x78,
	0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x08, 0x73, 0x70, 0x64,
	0x78, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x55, 0x0a, 0x11, 0x73, 0x70, 0x64, 0x78, 0x5f, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x73, 0x70, 0x64, 0x78, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x68, 0x69, 0x70, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x10, 0x73, 0x70, 0x64, 0x78,
	0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x12, 0x6d, 0x0a, 0x18,
	0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x61, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x76, 0x65, 0x78, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x74, 0x65,
	0x48, 0x00, 0x52, 0x17, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0e, 0x73,
	0x62, 0x6f, 0x6d, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x17, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x62, 0x6f, 0x6d, 0x2e, 0x53, 0x42, 0x4f, 0x4d, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0d,
	0x73, 0x62, 0x6f, 0x6d, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x3a, 0x35, 0xea,
	0x41, 0x32, 0x0a, 0x0f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4e,
	0x6f, 0x74, 0x65, 0x12, 0x1f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x6e,
	0x6f, 0x74, 0x65, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x49, 0x0a, 0x14,
	0x47, 0x65, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x1d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x17, 0x0a, 0x15, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb9, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x80, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3d, 0x0a, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4c, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x31, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x1d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x17, 0x0a, 0x15, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x69, 0x6f, 0x2f, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a,
	0x0a, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22,
	0xcb, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x17, 0x0a, 0x15, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4f, 0x63,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0a, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x3d, 0x0a,
	0x0e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x2b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x17, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x11, 0x0a, 0x0f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69,
	0x6f, 0x2f, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4d, 0x0a, 0x18,
	0x47, 0x65, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x6f, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x17, 0x0a, 0x15,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb3, 0x01, 0x0a, 0x10,
	0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x68, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x05, 0x6e, 0x6f,
	0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x40, 0x0a, 0x11, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x2b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x17,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x11, 0x0a, 0x0f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x69, 0x6f, 0x2f, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xae, 0x01,
	0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1c, 0x0a, 0x07, 0x6e, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6e, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x12, 0x2e,
	0x0a, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e,
	0x6f, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0x22, 0xad,
	0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x17, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x11, 0x0a, 0x0f, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x2e, 0x0a, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x6f, 0x74,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9d,
	0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x17, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x11, 0x0a, 0x0f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x69, 0x6f, 0x2f,
	0x4e, 0x6f, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x84,
	0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d,
	0x0a, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x87, 0x02, 0x0a, 0x17, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4e,
	0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x1a, 0x4f,
	0x0a, 0x0a, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2b,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4e, 0x6f, 0x74, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x47, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f,
	0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x6e,
	0x6f, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74,
	0x65, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x22, 0xb0, 0x01, 0x0a, 0x1d, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x5f, 0x0a, 0x1e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a,
	0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x90, 0x01, 0x0a,
	0x29, 0x47, 0x65, 0x74, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22,
	0xdb, 0x02, 0x0a, 0x1f, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x12, 0x5d, 0x0a, 0x06, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x6f, 0x74,
	0x61, 0x6c, 0x42, 0x79, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x06, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x1a, 0xd8, 0x01, 0x0a, 0x14, 0x46, 0x69, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x6f,
	0x74, 0x61, 0x6c, 0x42, 0x79, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x08, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x69, 0x78, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c,
	0x66, 0x69, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x32, 0xaa, 0x13,
	0x0a, 0x0e, 0x47, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31,
	0x12, 0x8c, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x25, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xa6, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0x27, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x8d, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x2a, 0x28, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xab, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x28, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x3a, 0x0a, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0xcf, 0x01, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x2e, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f,
	0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xb5, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x32, 0x28, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0a, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0xda, 0x41, 0x1b, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x12, 0x94, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x29, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x15, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30,
	0x12, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x73,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x74, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x4e, 0x6f,
	0x74, 0x65, 0x12, 0x1f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f,
	0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x8e, 0x01,
	0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x21, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0xda, 0x41,
	0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x7b,
	0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x22, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24,
	0x2a, 0x22, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x8f, 0x01, 0x0a, 0x0a,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x22, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x22, 0x22, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x65,
	0x73, 0x3a, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x6e, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x6e, 0x6f, 0x74, 0x65, 0x12, 0xb1, 0x01,
	0x0a, 0x10, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74,
	0x65, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x22,
	0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f,
	0x74, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x6f, 0x74, 0x65,
	0x73, 0x12, 0x91, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65,
	0x12, 0x22, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x22, 0x48, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2a, 0x32, 0x22, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e,
	0x6f, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0xda, 0x41, 0x15,
	0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6e, 0x6f, 0x74, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xb6, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f,
	0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4e, 0x6f, 0x74, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30,
	0x12, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0xda, 0x41, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0xe9,
	0x01, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x3a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x75, 0x6c, 0x6e, 0x65,
	0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x30, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x3a, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x57, 0x0a, 0x12, 0x69, 0x6f,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x50, 0x01, 0x5a, 0x39, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0xa2, 0x02, 0x03,
	0x47, 0x52, 0x41, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_grafeas_proto_rawDescOnce sync.Once
	file_grafeas_proto_rawDescData = file_grafeas_proto_rawDesc
)

func file_grafeas_proto_rawDescGZIP() []byte {
	file_grafeas_proto_rawDescOnce.Do(func() {
		file_grafeas_proto_rawDescData = protoimpl.X.CompressGZIP(file_grafeas_proto_rawDescData)
	})
	return file_grafeas_proto_rawDescData
}

var file_grafeas_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_grafeas_proto_goTypes = []interface{}{
	(*Occurrence)(nil),                                           // 0: grafeas.v1beta1.Occurrence
	(*Resource)(nil),                                             // 1: grafeas.v1beta1.Resource
	(*Note)(nil),                                                 // 2: grafeas.v1beta1.Note
	(*GetOccurrenceRequest)(nil),                                 // 3: grafeas.v1beta1.GetOccurrenceRequest
	(*ListOccurrencesRequest)(nil),                               // 4: grafeas.v1beta1.ListOccurrencesRequest
	(*ListOccurrencesResponse)(nil),                              // 5: grafeas.v1beta1.ListOccurrencesResponse
	(*DeleteOccurrenceRequest)(nil),                              // 6: grafeas.v1beta1.DeleteOccurrenceRequest
	(*CreateOccurrenceRequest)(nil),                              // 7: grafeas.v1beta1.CreateOccurrenceRequest
	(*UpdateOccurrenceRequest)(nil),                              // 8: grafeas.v1beta1.UpdateOccurrenceRequest
	(*GetNoteRequest)(nil),                                       // 9: grafeas.v1beta1.GetNoteRequest
	(*GetOccurrenceNoteRequest)(nil),                             // 10: grafeas.v1beta1.GetOccurrenceNoteRequest
	(*ListNotesRequest)(nil),                                     // 11: grafeas.v1beta1.ListNotesRequest
	(*ListNotesResponse)(nil),                                    // 12: grafeas.v1beta1.ListNotesResponse
	(*DeleteNoteRequest)(nil),                                    // 13: grafeas.v1beta1.DeleteNoteRequest
	(*CreateNoteRequest)(nil),                                    // 14: grafeas.v1beta1.CreateNoteRequest
	(*UpdateNoteRequest)(nil),                                    // 15: grafeas.v1beta1.UpdateNoteRequest
	(*ListNoteOccurrencesRequest)(nil),                           // 16: grafeas.v1beta1.ListNoteOccurrencesRequest
	(*ListNoteOccurrencesResponse)(nil),                          // 17: grafeas.v1beta1.ListNoteOccurrencesResponse
	(*BatchCreateNotesRequest)(nil),                              // 18: grafeas.v1beta1.BatchCreateNotesRequest
	(*BatchCreateNotesResponse)(nil),                             // 19: grafeas.v1beta1.BatchCreateNotesResponse
	(*BatchCreateOccurrencesRequest)(nil),                        // 20: grafeas.v1beta1.BatchCreateOccurrencesRequest
	(*BatchCreateOccurrencesResponse)(nil),                       // 21: grafeas.v1beta1.BatchCreateOccurrencesResponse
	(*GetVulnerabilityOccurrencesSummaryRequest)(nil),            // 22: grafeas.v1beta1.GetVulnerabilityOccurrencesSummaryRequest
	(*VulnerabilityOccurrencesSummary)(nil),                      // 23: grafeas.v1beta1.VulnerabilityOccurrencesSummary
	nil,                                                          // 24: grafeas.v1beta1.BatchCreateNotesRequest.NotesEntry
	(*VulnerabilityOccurrencesSummary_FixableTotalByDigest)(nil), // 25: grafeas.v1beta1.VulnerabilityOccurrencesSummary.FixableTotalByDigest
	(common_go_proto.NoteKind)(0),                                // 26: grafeas.v1beta1.NoteKind
	(*timestamp.Timestamp)(nil),                                  // 27: google.protobuf.Timestamp
	(*vulnerability_go_proto.Details)(nil),                       // 28: grafeas.v1beta1.vulnerability.Details
	(*build_go_proto.Details)(nil),                               // 29: grafeas.v1beta1.build.Details
	(*image_go_proto.Details)(nil),                               // 30: grafeas.v1beta1.image.Details
	(*package_go_proto.Details)(nil),                             // 31: grafeas.v1beta1.package.Details
	(*deployment_go_proto.Details)(nil),                          // 32: grafeas.v1beta1.deployment.Details
	(*discovery_go_proto.Details)(nil),                           // 33: grafeas.v1beta1.discovery.Details
	(*attestation_go_proto.Details)(nil),                         // 34: grafeas.v1beta1.attestation.Details
	(*intoto_go_proto.Details)(nil),                              // 35: grafeas.v1beta1.intoto.Details
	(*spdx_go_proto.DocumentOccurrence)(nil),                     // 36: grafeas.v1beta1.spdx.DocumentOccurrence
	(*spdx_go_proto.PackageInfoOccurrence)(nil),                  // 37: grafeas.v1beta1.spdx.PackageInfoOccurrence
	(*spdx_go_proto.FileOccurrence)(nil),                         // 38: grafeas.v1beta1.spdx.FileOccurrence
	(*spdx_go_proto.RelationshipOccurrence)(nil),                 // 39: grafeas.v1beta1.spdx.RelationshipOccurrence
	(*sbom_go_proto.SBOMReferenceOccurrence)(nil),                // 40: grafeas.v1beta1.sbom.SBOMReferenceOccurrence
	(*common_go_proto.Envelope)(nil),                             // 41: grafeas.v1beta1.Envelope
	(*provenance_go_proto.Hash)(nil),                             // 42: grafeas.v1beta1.provenance.Hash
	(*common_go_proto.RelatedUrl)(nil),                           // 43: grafeas.v1beta1.RelatedUrl
	(*vulnerability_go_proto.Vulnerability)(nil),                 // 44: grafeas.v1beta1.vulnerability.Vulnerability
	(*build_go_proto.Build)(nil),                                 // 45: grafeas.v1beta1.build.Build
	(*image_go_proto.Basis)(nil),                                 // 46: grafeas.v1beta1.image.Basis
	(*package_go_proto.Package)(nil),                             // 47: grafeas.v1beta1.package.Package
	(*deployment_go_proto.Deployable)(nil),                       // 48: grafeas.v1beta1.deployment.Deployable
	(*discovery_go_proto.Discovery)(nil),                         // 49: grafeas.v1beta1.discovery.Discovery
	(*attestation_go_proto.Authority)(nil),                       // 50: grafeas.v1beta1.attestation.Authority
	(*intoto_go_proto.InToto)(nil),                               // 51: grafeas.v1beta1.intoto.InToto
	(*spdx_go_proto.DocumentNote)(nil),                           // 52: grafeas.v1beta1.spdx.DocumentNote
	(*spdx_go_proto.PackageInfoNote)(nil),                        // 53: grafeas.v1beta1.spdx.PackageInfoNote
	(*spdx_go_proto.FileNote)(nil),                               // 54: grafeas.v1beta1.spdx.FileNote
	(*spdx_go_proto.RelationshipNote)(nil),                       // 55: grafeas.v1beta1.spdx.RelationshipNote
	(*vex_go_proto.VulnerabilityAssessmentNote)(nil),             // 56: grafeas.v1beta1.vex.VulnerabilityAssessmentNote
	(*sbom_go_proto.SBOMReferenceNote)(nil),                      // 57: grafeas.v1beta1.sbom.SBOMReferenceNote
	(*field_mask.FieldMask)(nil),                                 // 58: google.protobuf.FieldMask
	(vulnerability_go_proto.Severity)(0),                         // 59: grafeas.v1beta1.vulnerability.Severity
	(*empty.Empty)(nil),                                          // 60: google.protobuf.Empty
}
var file_grafeas_proto_depIdxs = []int32{
	1,  // 0: grafeas.v1beta1.Occurrence.resource:type_name -> grafeas.v1beta1.Resource
	26, // 1: grafeas.v1beta1.Occurrence.kind:type_name -> grafeas.v1beta1.NoteKind
	27, // 2: grafeas.v1beta1.Occurrence.create_time:type_name -> google.protobuf.Timestamp
	27, // 3: grafeas.v1beta1.Occurrence.update_time:type_name -> google.protobuf.Timestamp
	28, // 4: grafeas.v1beta1.Occurrence.vulnerability:type_name -> grafeas.v1beta1.vulnerability.Details
	29, // 5: grafeas.v1beta1.Occurrence.build:type_name -> grafeas.v1beta1.build.Details
	30, // 6: grafeas.v1beta1.Occurrence.derived_image:type_name -> grafeas.v1beta1.image.Details
	31, // 7: grafeas.v1beta1.Occurrence.installation:type_name -> grafeas.v1beta1.package.Details
	32, // 8: grafeas.v1beta1.Occurrence.deployment:type_name -> grafeas.v1beta1.deployment.Details
	33, // 9: grafeas.v1beta1.Occurrence.discovered:type_name -> grafeas.v1beta1.discovery.Details
	34, // 10: grafeas.v1beta1.Occurrence.attestation:type_name -> grafeas.v1beta1.attestation.Details
	35, // 11: grafeas.v1beta1.Occurrence.intoto:type_name -> grafeas.v1beta1.intoto.Details
	36, // 12: grafeas.v1beta1.Occurrence.sbom:type_name -> grafeas.v1beta1.spdx.DocumentOccurrence
	37, // 13: grafeas.v1beta1.Occurrence.spdx_package:type_name -> grafeas.v1beta1.spdx.PackageInfoOccurrence
	38, // 14: grafeas.v1beta1.Occurrence.spdx_file:type_name -> grafeas.v1beta1.spdx.FileOccurrence
	39, // 15: grafeas.v1beta1.Occurrence.spdx_relationship:type_name -> grafeas.v1beta1.spdx.RelationshipOccurrence
	40, // 16: grafeas.v1beta1.Occurrence.sbom_reference:type_name -> grafeas.v1beta1.sbom.SBOMReferenceOccurrence
	41, // 17: grafeas.v1beta1.Occurrence.envelope:type_name -> grafeas.v1beta1.Envelope
	42, // 18: grafeas.v1beta1.Resource.content_hash:type_name -> grafeas.v1beta1.provenance.Hash
	26, // 19: grafeas.v1beta1.Note.kind:type_name -> grafeas.v1beta1.NoteKind
	43, // 20: grafeas.v1beta1.Note.related_url:type_name -> grafeas.v1beta1.RelatedUrl
	27, // 21: grafeas.v1beta1.Note.expiration_time:type_name -> google.protobuf.Timestamp
	27, // 22: grafeas.v1beta1.Note.create_time:type_name -> google.protobuf.Timestamp
	27, // 23: grafeas.v1beta1.Note.update_time:type_name -> google.protobuf.Timestamp
	44, // 24: grafeas.v1beta1.Note.vulnerability:type_name -> grafeas.v1beta1.vulnerability.Vulnerability
	45, // 25: grafeas.v1beta1.Note.build:type_name -> grafeas.v1beta1.build.Build
	46, // 26: grafeas.v1beta1.Note.base_image:type_name -> grafeas.v1beta1.image.Basis
	47, // 27: grafeas.v1beta1.Note.package:type_name -> grafeas.v1beta1.package.Package
	48, // 28: grafeas.v1beta1.Note.deployable:type_name -> grafeas.v1beta1.deployment.Deployable
	49, // 29: grafeas.v1beta1.Note.discovery:type_name -> grafeas.v1beta1.discovery.Discovery
	50, // 30: grafeas.v1beta1.Note.attestation_authority:type_name -> grafeas.v1beta1.attestation.Authority
	51, // 31: grafeas.v1beta1.Note.intoto:type_name -> grafeas.v1beta1.intoto.InToto
	52, // 32: grafeas.v1beta1.Note.sbom:type_name -> grafeas.v1beta1.spdx.DocumentNote
	53, // 33: grafeas.v1beta1.Note.spdx_package:type_name -> grafeas.v1beta1.spdx.PackageInfoNote
	54, // 34: grafeas.v1beta1.Note.spdx_file:type_name -> grafeas.v1beta1.spdx.FileNote
	55, // 35: grafeas.v1beta1.Note.spdx_relationship:type_name -> grafeas.v1beta1.spdx.RelationshipNote
	56, // 36: grafeas.v1beta1.Note.vulnerability_assessment:type_name -> grafeas.v1beta1.vex.VulnerabilityAssessmentNote
	57, // 37: grafeas.v1beta1.Note.sbom_reference:type_name -> grafeas.v1beta1.sbom.SBOMReferenceNote
	0,  // 38: grafeas.v1beta1.ListOccurrencesResponse.occurrences:type_name -> grafeas.v1beta1.Occurrence
	0,  // 39: grafeas.v1beta1.CreateOccurrenceRequest.occurrence:type_name -> grafeas.v1beta1.Occurrence
	0,  // 40: grafeas.v1beta1.UpdateOccurrenceRequest.occurrence:type_name -> grafeas.v1beta1.Occurrence
	58, // 41: grafeas.v1beta1.UpdateOccurrenceRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 42: grafeas.v1beta1.ListNotesResponse.notes:type_name -> grafeas.v1beta1.Note
	2,  // 43: grafeas.v1beta1.CreateNoteRequest.note:type_name -> grafeas.v1beta1.Note
	2,  // 44: grafeas.v1beta1.UpdateNoteRequest.note:type_name -> grafeas.v1beta1.Note
	58, // 45: grafeas.v1beta1.UpdateNoteRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 46: grafeas.v1beta1.ListNoteOccurrencesResponse.occurrences:type_name -> grafeas.v1beta1.Occurrence
	24, // 47: grafeas.v1beta1.BatchCreateNotesRequest.notes:type_name -> grafeas.v1beta1.BatchCreateNotesRequest.NotesEntry
	2,  // 48: grafeas.v1beta1.BatchCreateNotesResponse.notes:type_name -> grafeas.v1beta1.Note
	0,  // 49: grafeas.v1beta1.BatchCreateOccurrencesRequest.occurrences:type_name -> grafeas.v1beta1.Occurrence
	0,  // 50: grafeas.v1beta1.BatchCreateOccurrencesResponse.occurrences:type_name -> grafeas.v1beta1.Occurrence
	25, // 51: grafeas.v1beta1.VulnerabilityOccurrencesSummary.counts:type_name -> grafeas.v1beta1.VulnerabilityOccurrencesSummary.FixableTotalByDigest
	2,  // 52: grafeas.v1beta1.BatchCreateNotesRequest.NotesEntry.value:type_name -> grafeas.v1beta1.Note
	1,  // 53: grafeas.v1beta1.VulnerabilityOccurrencesSummary.FixableTotalByDigest.resource:type_name -> grafeas.v1beta1.Resource
	59, // 54: grafeas.v1beta1.VulnerabilityOccurrencesSummary.FixableTotalByDigest.severity:type_name -> grafeas.v1beta1.vulnerability.Severity
	3,  // 55: grafeas.v1beta1.GrafeasV1Beta1.GetOccurrence:input_type -> grafeas.v1beta1.GetOccurrenceRequest
	4,  // 56: grafeas.v1beta1.GrafeasV1Beta1.ListOccurrences:input_type -> grafeas.v1beta1.ListOccurrencesRequest
	6,  // 57: grafeas.v1beta1.GrafeasV1Beta1.DeleteOccurrence:input_type -> grafeas.v1beta1.DeleteOccurrenceRequest
	7,  // 58: grafeas.v1beta1.GrafeasV1Beta1.CreateOccurrence:input_type -> grafeas.v1beta1.CreateOccurrenceRequest
	20, // 59: grafeas.v1beta1.GrafeasV1Beta1.BatchCreateOccurrences:input_type -> grafeas.v1beta1.BatchCreateOccurrencesRequest
	8,  // 60: grafeas.v1beta1.GrafeasV1Beta1.UpdateOccurrence:input_type -> grafeas.v1beta1.UpdateOccurrenceRequest
	10, // 61: grafeas.v1beta1.GrafeasV1Beta1.GetOccurrenceNote:input_type -> grafeas.v1beta1.GetOccurrenceNoteRequest
	9,  // 62: grafeas.v1beta1.GrafeasV1Beta1.GetNote:input_type -> grafeas.v1beta1.GetNoteRequest
	11, // 63: grafeas.v1beta1.GrafeasV1Beta1.ListNotes:input_type -> grafeas.v1beta1.ListNotesRequest
	13, // 64: grafeas.v1beta1.GrafeasV1Beta1.DeleteNote:input_type -> grafeas.v1beta1.DeleteNoteRequest
	14, // 65: grafeas.v1beta1.GrafeasV1Beta1.CreateNote:input_type -> grafeas.v1beta1.CreateNoteRequest
	18, // 66: grafeas.v1beta1.GrafeasV1Beta1.BatchCreateNotes:input_type -> grafeas.v1beta1.BatchCreateNotesRequest
	15, // 67: grafeas.v1beta1.GrafeasV1Beta1.UpdateNote:input_type -> grafeas.v1beta1.UpdateNoteRequest
	16, // 68: grafeas.v1beta1.GrafeasV1Beta1.ListNoteOccurrences:input_type -> grafeas.v1beta1.ListNoteOccurrencesRequest
	22, // 69: grafeas.v1beta1.GrafeasV1Beta1.GetVulnerabilityOccurrencesSummary:input_type -> grafeas.v1beta1.GetVulnerabilityOccurrencesSummaryRequest
	0,  // 70: grafeas.v1beta1.GrafeasV1Beta1.GetOccurrence:output_type -> grafeas.v1beta1.Occurrence
	5,  // 71: grafeas.v1beta1.GrafeasV1Beta1.ListOccurrences:output_type -> grafeas.v1beta1.ListOccurrencesResponse
	60, // 72: grafeas.v1beta1.GrafeasV1Beta1.DeleteOccurrence:output_type -> google.protobuf.Empty
	0,  // 73: grafeas.v1beta1.GrafeasV1Beta1.CreateOccurrence:output_type -> grafeas.v1beta1.Occurrence
	21, // 74: grafeas.v1beta1.GrafeasV1Beta1.BatchCreateOccurrences:output_type -> grafeas.v1beta1.BatchCreateOccurrencesResponse
	0,  // 75: grafeas.v1beta1.GrafeasV1Beta1.UpdateOccurrence:output_type -> grafeas.v1beta1.Occurrence
	2,  // 76: grafeas.v1beta1.GrafeasV1Beta1.GetOccurrenceNote:output_type -> grafeas.v1beta1.Note
	2,  // 77: grafeas.v1beta1.GrafeasV1Beta1.GetNote:output_type -> grafeas.v1beta1.Note
	12, // 78: grafeas.v1beta1.GrafeasV1Beta1.ListNotes:output_type -> grafeas.v1beta1.ListNotesResponse
	60, // 79: grafeas.v1beta1.GrafeasV1Beta1.DeleteNote:output_type -> google.protobuf.Empty
	2,  // 80: grafeas.v1beta1.GrafeasV1Beta1.CreateNote:output_type -> grafeas.v1beta1.Note
	19, // 81: grafeas.v1beta1.GrafeasV1Beta1.BatchCreateNotes:output_type -> grafeas.v1beta1.BatchCreateNotesResponse
	2,  // 82: grafeas.v1beta1.GrafeasV1Beta1.UpdateNote:output_type -> grafeas.v1beta1.Note
	17, // 83: grafeas.v1beta1.GrafeasV1Beta1.ListNoteOccurrences:output_type -> grafeas.v1beta1.ListNoteOccurrencesResponse
	23, // 84: grafeas.v1beta1.GrafeasV1Beta1.GetVulnerabilityOccurrencesSummary:output_type -> grafeas.v1beta1.VulnerabilityOccurrencesSummary
	70, // [70:85] is the sub-list for method output_type
	55, // [55:70] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_grafeas_proto_init() }
func file_grafeas_proto_init() {
	if File_grafeas_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_grafeas_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Occurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Note); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOccurrenceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOccurrencesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOccurrencesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteOccurrenceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateOccurrenceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateOccurrenceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOccurrenceNoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteNoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNoteOccurrencesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNoteOccurrencesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateNotesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateNotesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateOccurrencesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateOccurrencesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVulnerabilityOccurrencesSummaryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityOccurrencesSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityOccurrencesSummary_FixableTotalByDigest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_grafeas_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Occurrence_Vulnerability)(nil),
		(*Occurrence_Build)(nil),
		(*Occurrence_DerivedImage)(nil),
		(*Occurrence_Installation)(nil),
		(*Occurrence_Deployment)(nil),
		(*Occurrence_Discovered)(nil),
		(*Occurrence_Attestation)(nil),
		(*Occurrence_Intoto)(nil),
		(*Occurrence_Sbom)(nil),
		(*Occurrence_SpdxPackage)(nil),
		(*Occurrence_SpdxFile)(nil),
		(*Occurrence_SpdxRelationship)(nil),
		(*Occurrence_SbomReference)(nil),
	}
	file_grafeas_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Note_Vulnerability)(nil),
		(*Note_Build)(nil),
		(*Note_BaseImage)(nil),
		(*Note_Package)(nil),
		(*Note_Deployable)(nil),
		(*Note_Discovery)(nil),
		(*Note_AttestationAuthority)(nil),
		(*Note_Intoto)(nil),
		(*Note_Sbom)(nil),
		(*Note_SpdxPackage)(nil),
		(*Note_SpdxFile)(nil),
		(*Note_SpdxRelationship)(nil),
		(*Note_VulnerabilityAssessment)(nil),
		(*Note_SbomReference)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_grafeas_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_grafeas_proto_goTypes,
		DependencyIndexes: file_grafeas_proto_depIdxs,
		MessageInfos:      file_grafeas_proto_msgTypes,
	}.Build()
	File_grafeas_proto = out.File
	file_grafeas_proto_rawDesc = nil
	file_grafeas_proto_goTypes = nil
	file_grafeas_proto_depIdxs = nil
}
