/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.general;

import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gCLINE.data.RunCommand;
import edu.harvard.mgh.purcell.gCLINE.general.GCFileChooser;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public abstract class Configure
extends JDialog {
    protected Record data;
    private GCFileChooser localChooser;
    protected JTextField editor;
    protected JTextField updateField;

    public abstract void process();

    private JPanel createUpdate() {
        JPanel ans = new JPanel();
        ans.setBorder(new TitledBorder("Automatic Updater"));
        ans.add(new JLabel("Update file information every "));
        ans.add(this.updateField);
        ans.add(new JLabel("seconds"));
        return ans;
    }

    private JPanel createAltEditor() {
        JPanel ans = new JPanel();
        ans.setBorder(new TitledBorder("Alternative Editor"));
        this.localChooser = new GCFileChooser(this.data.frame, null, true, false, this.data.getConn(), "");
        this.localChooser.addFileChoosenListener(new GCFileChooser.FileChoosenListener(){

            public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                Configure.this.editor.setText(((Configure)Configure.this).localChooser.fileName);
            }
        });
        JButton browse = new JButton("Browse");
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Configure.this.localChooser.showChooser();
            }
        });
        JButton test = new JButton("Test");
        test.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new RunCommand(Configure.this.editor.getText(), Configure.this.data, true)).start();
            }
        });
        ans.add(this.editor);
        ans.add(browse);
        ans.add(test);
        return ans;
    }

    private JPanel createButton() {
        JPanel ans = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Configure.this.process();
                Configure.this.dispose();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Configure.this.dispose();
            }
        });
        ans.add(ok);
        ans.add(cancel);
        return ans;
    }

    protected abstract JPanel createFormSpecific();

    public Configure(Record d) {
        super((Frame)d.frame, "Configuration");
        this.data = d;
        this.editor = new JTextField(this.data.getAltEditor(), 30);
        this.updateField = this.data.isRemote() ? new JTextField(new Integer(this.data.getRemoteUpdateSec()).toString(), 4) : new JTextField(new Integer(this.data.getLocalUpdateSec()).toString(), 4);
        this.getRootPane().setLayout(new BoxLayout(this.getRootPane(), 3));
        this.getRootPane().add(this.createUpdate());
        this.getRootPane().add(this.createAltEditor());
        this.getRootPane().add(this.createButton());
    }

    public void makeVisible() {
        this.pack();
        this.setVisible(true);
    }
}

