/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.subsystem.SubsystemMessageStore;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SubsystemOutputStream
extends OutputStream {
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    SubsystemMessageStore messageStore;
    int messageStart = 0;

    public SubsystemOutputStream(SubsystemMessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.processMessage();
    }

    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    private void processMessage() throws IOException {
        int messageLength;
        if (this.buffer.size() > this.messageStart + 4 && (messageLength = (int)ByteArrayReader.readInt(this.buffer.toByteArray(), this.messageStart)) <= this.buffer.size() - 4) {
            byte[] msgdata = new byte[messageLength];
            System.arraycopy(this.buffer.toByteArray(), this.messageStart + 4, msgdata, 0, messageLength);
            try {
                this.messageStore.addMessage(msgdata);
            }
            catch (InvalidMessageException ime) {
                throw new IOException("An invalid message was encountered in the outputstream: " + ime.getMessage());
            }
            if (messageLength == this.buffer.size() - 4) {
                this.buffer.reset();
                this.messageStart = 0;
            } else {
                this.messageStart = messageLength + 4;
            }
        }
    }
}

