/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.init;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.InitUtility;
import org.jdesktop.jdic.init.JdicInitException;

public class JdicManager {
    private boolean isShareNativeInitialized = false;
    private boolean isBrowserNativeInitialized = false;
    boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    String libPathEnv = this.isWindows ? "PATH" : "LD_LIBRARY_PATH";
    String binaryPath = null;
    private static JdicManager sSingleton = null;

    private JdicManager() {
    }

    public static synchronized JdicManager getManager() {
        if (sSingleton == null) {
            sSingleton = new JdicManager();
        }
        return sSingleton;
    }

    public void initShareNative() throws JdicInitException {
        if (this.isShareNativeInitialized) {
            return;
        }
        try {
            Object object;
            Object object2;
            this.binaryPath = new URL(JdicManager.class.getProtectionDomain().getCodeSource().getLocation(), ".").openConnection().getPermission().getName();
            this.binaryPath = new File(this.binaryPath).getCanonicalPath();
            if (System.getProperty("javawebstart.version") != null) {
                object2 = "RNjdic-native.jar/";
                this.binaryPath = this.binaryPath + File.separator + (String)object2;
            } else {
                this.binaryPath = this.binaryPath + File.separator + JdicManager.getPlatform() + File.separator + JdicManager.getArchitecture();
                object2 = new File(new File(this.binaryPath).getParent() + File.separator + "jdic_stub.jar").toURL();
                object = (URLClassLoader)JdicManager.class.getClassLoader();
                Class clazz = URLClassLoader.class;
                try {
                    Method method = clazz.getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    method.invoke(object, object2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new IOException("Error, could not add URL to system classloader");
                }
            }
            object2 = this.binaryPath + File.pathSeparator + System.getProperty("java.library.path");
            System.setProperty("java.library.path", (String)object2);
            object = ClassLoader.class.getDeclaredField("sys_paths");
            ((Field)object).setAccessible(true);
            if (object != null) {
                ((Field)object).set(System.class.getClassLoader(), null);
            }
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
        this.isShareNativeInitialized = true;
    }

    public void initBrowserNative() throws JdicInitException {
        if (this.isBrowserNativeInitialized) {
            return;
        }
        try {
            InitUtility.preAppendEnv(this.libPathEnv, this.binaryPath);
            String string = WebBrowserUtil.getBrowserPath();
            if (string == null) {
                throw new JdicInitException("Can't locate the native browser path!");
            }
            if (WebBrowserUtil.isDefaultBrowserMozilla()) {
                Object object;
                String string2 = InitUtility.getEnv("MOZILLA_FIVE_HOME");
                if (string2 == null) {
                    object = new File(string);
                    string2 = ((File)object).isDirectory() ? ((File)object).getCanonicalPath() : ((File)object).getCanonicalFile().getParent();
                }
                if (!this.isWindows) {
                    InitUtility.preAppendEnv("PATH", this.binaryPath);
                    object = WebBrowserUtil.getEmbedBinaryName();
                    Runtime.getRuntime().exec("chmod a+x " + this.binaryPath + File.separator + (String)object);
                } else {
                    object = string2 + File.separator + "xpcom.dll";
                    if (!new File((String)object).isFile()) {
                        String string3 = WebBrowserUtil.getMozillaGreHome();
                        if (string3 == null) {
                            throw new JdicInitException("Can't locate the GRE directory of the installed Mozilla binary: " + string2);
                        }
                        string2 = string3;
                    }
                }
                InitUtility.setEnv("MOZILLA_FIVE_HOME", string2);
                InitUtility.preAppendEnv(this.libPathEnv, string2);
            }
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
        this.isBrowserNativeInitialized = true;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public static String getPlatform() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return "windows";
        }
        return JdicManager.canonical(string);
    }

    public static String getArchitecture() {
        String string = System.getProperty("os.arch");
        if (string.endsWith("86")) {
            return "x86";
        }
        return JdicManager.canonical(string);
    }

    public static String canonical(String string) {
        return string.toLowerCase().replaceAll("[\\\\/ ]", "_");
    }
}

