// Code generated by 'ccgo -lmodernc.org/z/lib -o internal\minigzip_windows_amd64.go -trace-translation-units C:\Users\0xjnml\go\src\modernc.org\z\tmp\cdb.json minigzip.exe', DO NOT EDIT.

package main

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/z/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ types.Size_t

func main() { libc.Start(main1) }

type ptrdiff_t = int64 /* <builtin>:3:26 */

type size_t = uint64 /* <builtin>:9:23 */

type wchar_t = uint16 /* <builtin>:15:24 */

type va_list = uintptr /* <builtin>:50:27 */

type ssize_t = int64 /* crtdefs.h:45:35 */

type rsize_t = size_t /* crtdefs.h:52:16 */

type intptr_t = int64 /* crtdefs.h:62:35 */

type uintptr_t = uint64 /* crtdefs.h:75:44 */

type wint_t = uint16   /* crtdefs.h:106:24 */
type wctype_t = uint16 /* crtdefs.h:107:24 */

type errno_t = int32 /* crtdefs.h:113:13 */

type time_t = int64 /* crtdefs.h:138:20 */

type threadlocaleinfostruct = struct {
	refcount      int32
	lc_codepage   uint32
	lc_collate_cp uint32
	lc_handle     [6]uint32
	lc_id         [6]LC_ID
	lc_category   [6]struct {
		locale    uintptr
		wlocale   uintptr
		refcount  uintptr
		wrefcount uintptr
	}
	lc_clike            int32
	mb_cur_max          int32
	lconv_intl_refcount uintptr
	lconv_num_refcount  uintptr
	lconv_mon_refcount  uintptr
	lconv               uintptr
	ctype1_refcount     uintptr
	ctype1              uintptr
	pctype              uintptr
	pclmap              uintptr
	pcumap              uintptr
	lc_time_curr        uintptr
} /* crtdefs.h:422:1 */

type pthreadlocinfo = uintptr /* crtdefs.h:424:39 */
type pthreadmbcinfo = uintptr /* crtdefs.h:425:36 */

type localeinfo_struct = struct {
	locinfo pthreadlocinfo
	mbcinfo pthreadmbcinfo
} /* crtdefs.h:428:9 */

type _locale_tstruct = localeinfo_struct /* crtdefs.h:431:3 */
type _locale_t = uintptr                 /* crtdefs.h:431:19 */

type tagLC_ID = struct {
	wLanguage uint16
	wCountry  uint16
	wCodePage uint16
} /* crtdefs.h:422:1 */

type LC_ID = tagLC_ID  /* crtdefs.h:439:3 */
type LPLC_ID = uintptr /* crtdefs.h:439:9 */

type threadlocinfo = threadlocaleinfostruct /* crtdefs.h:468:3 */

// ISO C Standard:  7.17  Common definitions  <stddef.h>

// Any one of these symbols __need_* means that GNU libc
//    wants us just to define one data type.  So don't define
//    the symbols that indicate this file's entire job has been done.
// snaroff@next.com says the NeXT needs this.
// Irix 5.1 needs this.

// In 4.3bsd-net2, machine/ansi.h defines these symbols, which are
//    defined if the corresponding type is *not* defined.
//    FreeBSD-2.1 defines _MACHINE_ANSI_H_ instead of _ANSI_H_

// Sequent's header files use _PTRDIFF_T_ in some conflicting way.
//    Just ignore it.

// On VxWorks, <type/vxTypesBase.h> may have defined macros like
//    _TYPE_size_t which will typedef size_t.  fixincludes patched the
//    vxTypesBase.h so that this macro is only defined if _GCC_SIZE_T is
//    not defined, and so that defining this macro defines _GCC_SIZE_T.
//    If we find that the macros are still defined at this point, we must
//    invoke them so that the type is defined as expected.

// In case nobody has defined these types, but we aren't running under
//    GCC 2.00, make sure that __PTRDIFF_TYPE__, __SIZE_TYPE__, and
//    __WCHAR_TYPE__ have reasonable values.  This can happen if the
//    parts of GCC is compiled by an older compiler, that actually
//    include gstddef.h, such as collect2.

// Signed type of difference of two pointers.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// If this symbol has done its job, get rid of it.

// Unsigned type of `sizeof' something.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// Wide character type.
//    Locale-writers should change this as necessary to
//    be big enough to hold unique values not between 0 and 127,
//    and not (wchar_t) -1, for each defined multibyte character.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

//  In 4.3bsd-net2, leave these undefined to indicate that size_t, etc.
//     are already defined.
//  BSD/OS 3.1 and FreeBSD [23].x require the MACHINE_ANSI_H check here.

// A null pointer constant.

// Offset of member MEMBER in a struct of type TYPE.

// Type whose alignment is supported in every context and is at least
//    as great as that of any standard type not using alignment
//    specifiers.
type max_align_t = struct {
	__max_align_ll int64
	__max_align_ld float64
} /* stddef.h:426:3 */

// Copyright (C) 1989-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// ISO C Standard:  7.17  Common definitions  <stddef.h>
type z_size_t = size_t /* zconf.h:248:21 */

// Maximum value for memLevel in deflateInit2

// Maximum value for windowBits in deflateInit2 and inflateInit2.
// WARNING: reducing MAX_WBITS makes minigzip unable to extract .gz files
// created by gzip. (Files created by minigzip can still be extracted by
// gzip.)

// The memory requirements for deflate are (in bytes):
//             (1 << (windowBits+2)) +  (1 << (memLevel+9))
//  that is: 128K for windowBits=15  +  128K for memLevel = 8  (default values)
//  plus a few kilobytes for small objects. For example, if you want to reduce
//  the default memory requirements from 256K to 128K, compile with
//      make CFLAGS="-O -DMAX_WBITS=14 -DMAX_MEM_LEVEL=7"
//  Of course this will generally degrade compression (there's no free lunch).
//
//    The memory requirements for inflate are (in bytes) 1 << windowBits
//  that is, 32K for windowBits=15 (default value) plus about 7 kilobytes
//  for small objects.

// Type declarations

// The following definitions for FAR are needed only for MSDOS mixed
// model programming (small or medium model with some far allocations).
// This was tested only with MSC; for other MSDOS compilers you may have
// to define NO_MEMCPY in zutil.h.  If you don't need the mixed model,
// just define FAR to be empty.

// If building or using zlib as a DLL, define ZLIB_DLL.
// This is not mandatory, but it offers a little performance increase.
// If building or using zlib with the WINAPI/WINAPIV calling convention,
// define ZLIB_WINAPI.
// Caution: the standard ZLIB1.DLL is NOT compiled using ZLIB_WINAPI.

type Byte = uint8   /* zconf.h:391:24 */ // 8 bits
type uInt = uint32  /* zconf.h:393:24 */ // 16 bits or more
type uLong = uint32 /* zconf.h:394:24 */ // 32 bits or more

type Bytef = Byte   /* zconf.h:400:22 */
type charf = int8   /* zconf.h:402:19 */
type intf = int32   /* zconf.h:403:19 */
type uIntf = uInt   /* zconf.h:404:19 */
type uLongf = uLong /* zconf.h:405:19 */

type voidpc = uintptr /* zconf.h:408:23 */
type voidpf = uintptr /* zconf.h:409:23 */
type voidp = uintptr  /* zconf.h:410:23 */

// Copyright (C) 1992-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.
//
// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// This administrivia gets added to the beginning of limits.h
//    if the system has its own version of limits.h.

// We use _GCC_LIMITS_H_ because we want this not to match
//    any macros that the system's limits.h uses for its own purposes.

// Use "..." so that we find syslimits.h only in this same directory.
// syslimits.h stands for the system's own limits.h file.
//    If we can use it ok unmodified, then we install this text.
//    If fixincludes fixes it, then the fixed version is installed
//    instead of this text.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.
// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// File system limits
//
// NOTE: Apparently the actual size of PATH_MAX is 260, but a space is
//       required for the NUL. TODO: Test?
// NOTE: PATH_MAX is the POSIX equivalent for Microsoft's MAX_PATH; the two
//       are semantically identical, with a limit of 259 characters for the
//       path name, plus one for a terminating NUL, for a total of 260.

// Copyright (C) 1991-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.
//
// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// Number of bits in a `char'.

// Maximum length of a multibyte character.

// Minimum and maximum values a `signed char' can hold.

// Maximum value an `unsigned char' can hold.  (Minimum is 0).

// Minimum and maximum values a `char' can hold.

// Minimum and maximum values a `signed short int' can hold.

// Maximum value an `unsigned short int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed int' can hold.

// Maximum value an `unsigned int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long int' can hold.
//    (Same as `int').

// Maximum value an `unsigned long int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long long int' can hold.

// Maximum value an `unsigned long long int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long long int' can hold.

// Maximum value an `unsigned long long int' can hold.  (Minimum is 0).

// This administrivia gets added to the end of limits.h
//    if the system has its own version of limits.h.

type z_crc_t = uint32 /* zconf.h:429:17 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

type _ino_t = uint16 /* types.h:43:24 */
type ino_t = uint16  /* types.h:45:24 */

type _dev_t = uint32 /* types.h:51:22 */
type dev_t = uint32  /* types.h:53:22 */

type _pid_t = int64 /* types.h:63:17 */

type pid_t = _pid_t /* types.h:68:16 */

type _mode_t = uint16 /* types.h:74:24 */

type mode_t = _mode_t /* types.h:77:17 */

type _off_t = int32  /* _mingw_off_t.h:5:16 */
type off32_t = int32 /* _mingw_off_t.h:7:16 */

type _off64_t = int64 /* _mingw_off_t.h:13:39 */
type off64_t = int64  /* _mingw_off_t.h:15:39 */

type off_t = off64_t /* _mingw_off_t.h:24:17 */

type useconds_t = uint32 /* types.h:84:22 */

type timespec = struct {
	tv_sec  time_t
	tv_nsec int32
	_       [4]byte
} /* types.h:89:1 */

type itimerspec = struct {
	it_interval struct {
		tv_sec  time_t
		tv_nsec int32
		_       [4]byte
	}
	it_value struct {
		tv_sec  time_t
		tv_nsec int32
		_       [4]byte
	}
} /* types.h:94:1 */

type _sigset_t = uint64 /* types.h:104:28 */

// Copyright (C) 1989, 1997, 1998, 1999, 2000 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GCC; see the file COPYING.  If not, write to
// the Free Software Foundation, 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.

// As a special exception, if you include this header file into source
//    files compiled by GCC, this header file does not by itself cause
//    the resulting executable to be covered by the GNU General Public
//    License.  This exception does not however invalidate any other
//    reasons why the executable file might be covered by the GNU General
//    Public License.

// ISO C Standard:  7.15  Variable arguments  <stdarg.h>

// Define __gnuc_va_list.

// Define the standard macros for the user,
//    if this invocation was from the user program.

// Define va_list, if desired, from __gnuc_va_list.
// We deliberately do not define va_list when called from
//    stdio.h, because ANSI C says that stdio.h is not supposed to define
//    va_list.  stdio.h needs to have access to that data type,
//    but must not use that name.  It should use the name __gnuc_va_list,
//    which is safe because it is reserved for the implementation.

// The macro _VA_LIST_ is the same thing used by this file in Ultrix.
//    But on BSD NET2 we must not test or define or undef it.
//    (Note that the comments in NET 2's ansi.h
//    are incorrect for _VA_LIST_--see stdio.h!)
// The macro _VA_LIST_DEFINED is used in Windows NT 3.5

// include mingw stuff
// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Copyright (C) 1989-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// ISO C Standard:  7.15  Variable arguments  <stdarg.h>

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// ISO C Standard:  7.17  Common definitions  <stddef.h>

// Copyright (C) 1989-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// ISO C Standard:  7.17  Common definitions  <stddef.h>

// a little trick to accommodate both "#define _LARGEFILE64_SOURCE" and
// "#define _LARGEFILE64_SOURCE 1" as requesting 64-bit operations, (even
// though the former does not conform to the LFS document), but considering
// both "#undef _LARGEFILE64_SOURCE" and "#define _LARGEFILE64_SOURCE 0" as
// equivalently requesting no 64-bit operations

// MVS linker does not support external names larger than 8 bytes

//
//     The 'zlib' compression library provides in-memory compression and
//   decompression functions, including integrity checks of the uncompressed data.
//   This version of the library supports only one compression method (deflation)
//   but other algorithms will be added later and will have the same stream
//   interface.
//
//     Compression can be done in a single step if the buffers are large enough,
//   or can be done by repeated calls of the compression function.  In the latter
//   case, the application must provide more input and/or consume the output
//   (providing more output space) before each call.
//
//     The compressed data format used by default by the in-memory functions is
//   the zlib format, which is a zlib wrapper documented in RFC 1950, wrapped
//   around a deflate stream, which is itself documented in RFC 1951.
//
//     The library also supports reading and writing files in gzip (.gz) format
//   with an interface similar to that of stdio using the functions that start
//   with "gz".  The gzip format is different from the zlib format.  gzip is a
//   gzip wrapper, documented in RFC 1952, wrapped around a deflate stream.
//
//     This library can optionally read and write gzip and raw deflate streams in
//   memory as well.
//
//     The zlib format was designed to be compact and fast for use in memory
//   and on communications channels.  The gzip format was designed for single-
//   file compression on file systems, has a larger header than zlib to maintain
//   directory information, and uses a different, slower check method than zlib.
//
//     The library does not install any signal handler.  The decoder checks
//   the consistency of the compressed data, so the library should never crash
//   even in the case of corrupted input.

type alloc_func = uintptr /* zlib.h:81:16 */
type free_func = uintptr  /* zlib.h:82:16 */

type z_stream_s = struct {
	next_in   uintptr
	avail_in  uInt
	total_in  uLong
	next_out  uintptr
	avail_out uInt
	total_out uLong
	msg       uintptr
	state     uintptr
	zalloc    alloc_func
	zfree     free_func
	opaque    voidpf
	data_type int32
	adler     uLong
	reserved  uLong
	_         [4]byte
} /* zlib.h:86:9 */

type z_stream = z_stream_s /* zlib.h:106:3 */

type z_streamp = uintptr /* zlib.h:108:22 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header_s = struct {
	text      int32
	time      uLong
	xflags    int32
	os        int32
	extra     uintptr
	extra_len uInt
	extra_max uInt
	name      uintptr
	name_max  uInt
	_         [4]byte
	comment   uintptr
	comm_max  uInt
	hcrc      int32
	done      int32
	_         [4]byte
} /* zlib.h:114:9 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header = gz_header_s /* zlib.h:129:3 */

type gz_headerp = uintptr /* zlib.h:131:23 */
//
//      inflateGetHeader() requests that gzip header information be stored in the
//    provided gz_header structure.  inflateGetHeader() may be called after
//    inflateInit2() or inflateReset(), and before the first call of inflate().
//    As inflate() processes the gzip stream, head->done is zero until the header
//    is completed, at which time head->done is set to one.  If a zlib stream is
//    being decoded, then head->done is set to -1 to indicate that there will be
//    no gzip header information forthcoming.  Note that Z_BLOCK or Z_TREES can be
//    used to force inflate() to return immediately after header processing is
//    complete and before any actual data is decompressed.
//
//      The text, time, xflags, and os fields are filled in with the gzip header
//    contents.  hcrc is set to true if there is a header CRC.  (The header CRC
//    was valid if done is set to one.) If extra is not Z_NULL, then extra_max
//    contains the maximum number of bytes to write to extra.  Once done is true,
//    extra_len contains the actual extra field length, and extra contains the
//    extra field, or that field truncated if extra_max is less than extra_len.
//    If name is not Z_NULL, then up to name_max characters are written there,
//    terminated with a zero unless the length is greater than name_max.  If
//    comment is not Z_NULL, then up to comm_max characters are written there,
//    terminated with a zero unless the length is greater than comm_max.  When any
//    of extra, name, or comment are not Z_NULL and the respective field is not
//    present in the header, then that field is set to Z_NULL to signal its
//    absence.  This allows the use of deflateSetHeader() with the returned
//    structure to duplicate the header.  However if those fields are set to
//    allocated memory, then the application will need to save those pointers
//    elsewhere so that they can be eventually freed.
//
//      If inflateGetHeader is not used, then the header information is simply
//    discarded.  The header is always checked for validity, including the header
//    CRC if present.  inflateReset() will reset the process to discard the header
//    information.  The application would need to call inflateGetHeader() again to
//    retrieve the header from the next gzip stream.
//
//      inflateGetHeader returns Z_OK if success, or Z_STREAM_ERROR if the source
//    stream state was inconsistent.

//
// ZEXTERN int ZEXPORT inflateBackInit OF((z_streamp strm, int windowBits,
//                                         unsigned char FAR *window));
//
//      Initialize the internal stream state for decompression using inflateBack()
//    calls.  The fields zalloc, zfree and opaque in strm must be initialized
//    before the call.  If zalloc and zfree are Z_NULL, then the default library-
//    derived memory allocation routines are used.  windowBits is the base two
//    logarithm of the window size, in the range 8..15.  window is a caller
//    supplied buffer of that size.  Except for special applications where it is
//    assured that deflate was used with small window sizes, windowBits must be 15
//    and a 32K byte window must be supplied to be able to decompress general
//    deflate streams.
//
//      See inflateBack() for the usage of these routines.
//
//      inflateBackInit will return Z_OK on success, Z_STREAM_ERROR if any of
//    the parameters are invalid, Z_MEM_ERROR if the internal state could not be
//    allocated, or Z_VERSION_ERROR if the version of the library does not match
//    the version of the header file.

type in_func = uintptr  /* zlib.h:1092:18 */
type out_func = uintptr /* zlib.h:1094:13 */
//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile_s = struct {
	have uint32
	_    [4]byte
	next uintptr
	pos  int32
	_    [4]byte
} /* zlib.h:1300:9 */

//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile = uintptr /* zlib.h:1300:25 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Undefine __mingw_<printf> macros.

type _iobuf = struct {
	_ptr      uintptr
	_cnt      int32
	_         [4]byte
	_base     uintptr
	_flag     int32
	_file     int32
	_charbuf  int32
	_bufsiz   int32
	_tmpfname uintptr
} /* stdio.h:26:3 */

type FILE = _iobuf /* stdio.h:36:25 */

type fpos_t = int64 /* stdio.h:104:37 */

func snprintf(tls *libc.TLS, __stream uintptr, __n size_t, __format uintptr, va uintptr) int32 { /* stdio.h:786:5: */
	var __retval int32
	var __local_argv uintptr
	__local_argv = va
	__retval = libc.X__ms_vsnprintf(tls, __stream, __n, __format, __local_argv)
	_ = __local_argv
	return __retval
}

func vsnwprintf(tls *libc.TLS, s uintptr, n size_t, format uintptr, arg va_list) int32 { /* stdio.h:1209:15: */
	return libc.X_vsnwprintf(tls, s, n, format, arg)

}

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

func vswprintf(tls *libc.TLS, __stream uintptr, __count size_t, __format uintptr, __local_argv uintptr) int32 { /* swprintf.inl:27:5: */
	return vsnwprintf(tls, __stream, __count, __format, __local_argv)
}

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Copyright (C) 1992-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.
//
// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// This administrivia gets added to the beginning of limits.h
//    if the system has its own version of limits.h.

// We use _GCC_LIMITS_H_ because we want this not to match
//    any macros that the system's limits.h uses for its own purposes.

type _onexit_t = uintptr /* stdlib.h:49:15 */

type _div_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:59:11 */

type div_t = _div_t /* stdlib.h:62:5 */

type _ldiv_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:64:11 */

type ldiv_t = _ldiv_t /* stdlib.h:67:5 */

type _LDOUBLE = struct{ ld [10]uint8 } /* stdlib.h:76:5 */

type _CRT_DOUBLE = struct{ x float64 } /* stdlib.h:83:5 */

type _CRT_FLOAT = struct{ f float32 } /* stdlib.h:87:5 */

type _LONGDOUBLE = struct{ x float64 } /* stdlib.h:94:5 */

type _LDBL12 = struct{ ld12 [12]uint8 } /* stdlib.h:101:5 */

type _purecall_handler = uintptr /* stdlib.h:142:16 */

type _invalid_parameter_handler = uintptr /* stdlib.h:147:16 */

type lldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:699:61 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Return codes for _heapwalk()

// Values for _heapinfo.useflag

// The structure used to walk through the heap with _heapwalk.
type _heapinfo = struct {
	_pentry  uintptr
	_size    size_t
	_useflag int32
	_        [4]byte
} /* malloc.h:46:11 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Return codes for _heapwalk()

// Values for _heapinfo.useflag

// The structure used to walk through the heap with _heapwalk.
type _HEAPINFO = _heapinfo /* malloc.h:50:5 */
type _fsize_t = uint32     /* io.h:29:25 */

type _finddata32_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        _fsize_t
	name        [260]int8
} /* io.h:35:3 */

type _finddata32i64_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        int64
	name        [260]int8
	_           [4]byte
} /* io.h:44:3 */

type _finddata64i32_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        _fsize_t
	name        [260]int8
} /* io.h:53:3 */

type __finddata64_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        int64
	name        [260]int8
	_           [4]byte
} /* io.h:62:3 */

type _wfinddata32_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        _fsize_t
	name        [260]wchar_t
} /* io.h:94:3 */

type _wfinddata32i64_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        int64
	name        [260]wchar_t
} /* io.h:103:3 */

type _wfinddata64i32_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        _fsize_t
	name        [260]wchar_t
	_           [4]byte
} /* io.h:112:3 */

type _wfinddata64_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        int64
	name        [260]wchar_t
} /* io.h:121:3 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

var prog uintptr /* minigzip.c:336:13: */

// ===========================================================================
// Display error message and exit
func error(tls *libc.TLS, msg uintptr) { /* minigzip.c:351:6: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts /* "%s: %s\n" */, libc.VaList(bp, prog, msg))
	libc.Xexit(tls, 1)
}

// ===========================================================================
// Compress input to output then close both files.

func gz_compress(tls *libc.TLS, in uintptr, out gzFile) { /* minigzip.c:362:6: */
	bp := tls.Alloc(16388)
	defer tls.Free(16388)

	// var buf [16384]int8 at bp, 16384

	var len int32
	// var err int32 at bp+16384, 4

	for {
		len = int32(libc.Xfread(tls, bp /* &buf[0] */, uint64(1), uint64(unsafe.Sizeof([16384]int8{})), in))
		if libc.Xferror(tls, in) != 0 {
			libc.Xperror(tls, ts+8 /* "fread" */)
			libc.Xexit(tls, 1)
		}
		if len == 0 {
			break
		}

		if z.Xgzwrite(tls, out, bp /* &buf[0] */, uint32(len)) != len {
			error(tls, z.Xgzerror(tls, out, bp+16384 /* &err */))
		}
	}
	libc.Xfclose(tls, in)
	if z.Xgzclose(tls, out) != 0 {
		error(tls, ts+14 /* "failed gzclose" */)
	}
}

// ===========================================================================
// Uncompress input to output then close both files.
func gz_uncompress(tls *libc.TLS, in gzFile, out uintptr) { /* minigzip.c:430:6: */
	bp := tls.Alloc(16388)
	defer tls.Free(16388)

	// var buf [16384]int8 at bp, 16384

	var len int32
	// var err int32 at bp+16384, 4

	for {
		len = z.Xgzread(tls, in, bp /* &buf[0] */, uint32(unsafe.Sizeof([16384]int8{})))
		if len < 0 {
			error(tls, z.Xgzerror(tls, in, bp+16384 /* &err */))
		}
		if len == 0 {
			break
		}

		if int32(libc.Xfwrite(tls, bp /* &buf[0] */, uint64(1), uint64(uint32(len)), out)) != len {
			error(tls, ts+29 /* "failed fwrite" */)
		}
	}
	if libc.Xfclose(tls, out) != 0 {
		error(tls, ts+43 /* "failed fclose" */)
	}

	if z.Xgzclose(tls, in) != 0 {
		error(tls, ts+14 /* "failed gzclose" */)
	}
}

// ===========================================================================
// Compress the given file: create a corresponding .gz file and remove the
// original.
func file_compress(tls *libc.TLS, file uintptr, mode uintptr) { /* minigzip.c:457:6: */
	bp := tls.Alloc(1064)
	defer tls.Free(1064)

	// var outfile [1024]int8 at bp+40, 1024

	var in uintptr
	var out gzFile

	if (libc.Xstrlen(tls, file) + libc.Xstrlen(tls, ts+57 /* ".gz" */)) >= size_t(unsafe.Sizeof([1024]int8{})) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+61 /* "%s: filename too..." */, libc.VaList(bp, prog))
		libc.Xexit(tls, 1)
	}

	snprintf(tls, bp+40 /* &outfile[0] */, uint64(unsafe.Sizeof([1024]int8{})), ts+84 /* "%s%s" */, libc.VaList(bp+8, file, ts+57 /* ".gz" */))

	in = libc.Xfopen(tls, file, ts+89 /* "rb" */)
	if in == (uintptr(0)) {
		libc.Xperror(tls, file)
		libc.Xexit(tls, 1)
	}
	out = z.Xgzopen(tls, bp+40 /* &outfile[0] */, mode)
	if out == (uintptr(0)) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+92 /* "%s: can't gzopen..." */, libc.VaList(bp+24, prog, bp+40 /* &outfile[0] */))
		libc.Xexit(tls, 1)
	}
	gz_compress(tls, in, out)

	libc.Xunlink(tls, file)
}

// ===========================================================================
// Uncompress the given file and remove the original.
func file_uncompress(tls *libc.TLS, file uintptr) { /* minigzip.c:496:6: */
	bp := tls.Alloc(1064)
	defer tls.Free(1064)

	// var buf [1024]int8 at bp+40, 1024

	var infile uintptr
	var outfile uintptr
	var out uintptr
	var in gzFile
	var len uint32 = uint32(libc.Xstrlen(tls, file))

	if (size_t(len) + libc.Xstrlen(tls, ts+57 /* ".gz" */)) >= size_t(unsafe.Sizeof([1024]int8{})) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+61 /* "%s: filename too..." */, libc.VaList(bp, prog))
		libc.Xexit(tls, 1)
	}

	snprintf(tls, bp+40 /* &buf[0] */, uint64(unsafe.Sizeof([1024]int8{})), ts+113 /* "%s" */, libc.VaList(bp+8, file))

	if (uint64(len) > (uint64(unsafe.Sizeof([4]int8{})) - uint64(1))) && (libc.Xstrcmp(tls, ((file+uintptr(len))-uintptr((uint64(unsafe.Sizeof([4]int8{}))-uint64(1)))), ts+57 /* ".gz" */) == 0) {
		infile = file
		outfile = bp + 40 /* &buf[0] */
		*(*int8)(unsafe.Pointer(outfile + uintptr((len - uint32(3))))) = int8(0)
	} else {
		outfile = file
		infile = bp + 40 /* &buf[0] */
		snprintf(tls, (bp + 40 /* &buf[0] */ + uintptr(len)), (uint64(unsafe.Sizeof([1024]int8{})) - uint64(len)), ts+113 /* "%s" */, libc.VaList(bp+16, ts+57 /* ".gz" */))
	}
	in = z.Xgzopen(tls, infile, ts+89 /* "rb" */)
	if in == (uintptr(0)) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+92 /* "%s: can't gzopen..." */, libc.VaList(bp+24, prog, infile))
		libc.Xexit(tls, 1)
	}
	out = libc.Xfopen(tls, outfile, ts+116 /* "wb" */)
	if out == (uintptr(0)) {
		libc.Xperror(tls, file)
		libc.Xexit(tls, 1)
	}

	gz_uncompress(tls, in, out)

	libc.Xunlink(tls, infile)
}

// ===========================================================================
// Usage:  minigzip [-c] [-d] [-f] [-h] [-r] [-1 to -9] [files...]
//   -c : write to standard output
//   -d : decompress
//   -f : compress with Z_FILTERED
//   -h : compress with Z_HUFFMAN_ONLY
//   -r : compress with Z_RLE
//   -1 to -9 : compression level

func main1(tls *libc.TLS, argc int32, argv uintptr) int32 { /* minigzip.c:556:5: */
	bp := tls.Alloc(44)
	defer tls.Free(44)

	var copyout int32 = 0
	var uncompr int32 = 0
	var file gzFile
	var bname uintptr
	// var outmode [20]int8 at bp+24, 20

	snprintf(tls, bp+24 /* &outmode[0] */, uint64(unsafe.Sizeof([20]int8{})), ts+113 /* "%s" */, libc.VaList(bp, ts+119 /* "wb6 " */))

	prog = *(*uintptr)(unsafe.Pointer(argv))
	bname = libc.Xstrrchr(tls, *(*uintptr)(unsafe.Pointer(argv)), '/')
	if bname != 0 {
		bname++
	} else {
		bname = *(*uintptr)(unsafe.Pointer(argv))
	}
	argc--
	argv += 8

	if !(libc.Xstrcmp(tls, bname, ts+124 /* "gunzip" */) != 0) {
		uncompr = 1
	} else if !(libc.Xstrcmp(tls, bname, ts+131 /* "zcat" */) != 0) {
		copyout = libc.AssignInt32(&uncompr, 1)
	}

	for argc > 0 {
		if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+136 /* "-c" */) == 0 {
			copyout = 1
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+139 /* "-d" */) == 0 {
			uncompr = 1
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+142 /* "-f" */) == 0 {
			*(*int8)(unsafe.Pointer(bp + 24 /* &outmode[0] */ + 3)) = int8('f')
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+145 /* "-h" */) == 0 {
			*(*int8)(unsafe.Pointer(bp + 24 /* &outmode[0] */ + 3)) = int8('h')
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+148 /* "-r" */) == 0 {
			*(*int8)(unsafe.Pointer(bp + 24 /* &outmode[0] */ + 3)) = int8('R')
		} else if (((int32(*(*int8)(unsafe.Pointer((*(*uintptr)(unsafe.Pointer(argv)))))) == '-') && (int32(*(*int8)(unsafe.Pointer((*(*uintptr)(unsafe.Pointer(argv))) + 1))) >= '1')) && (int32(*(*int8)(unsafe.Pointer((*(*uintptr)(unsafe.Pointer(argv))) + 1))) <= '9')) && (int32(*(*int8)(unsafe.Pointer((*(*uintptr)(unsafe.Pointer(argv))) + 2))) == 0) {
			*(*int8)(unsafe.Pointer(bp + 24 /* &outmode[0] */ + 2)) = *(*int8)(unsafe.Pointer((*(*uintptr)(unsafe.Pointer(argv))) + 1))
		} else {
			break
		}
		argc--
		argv += 8
	}
	if int32(*(*int8)(unsafe.Pointer(bp + 24 /* &outmode[0] */ + 3))) == ' ' {
		*(*int8)(unsafe.Pointer(bp + 24 /* &outmode[0] */ + 3)) = int8(0)
	}
	if argc == 0 {
		libc.Xsetmode(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(0))), 0x8000)
		libc.Xsetmode(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(1))), 0x8000)
		if uncompr != 0 {
			file = z.Xgzdopen(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(0))), ts+89 /* "rb" */)
			if file == (uintptr(0)) {
				error(tls, ts+151 /* "can't gzdopen st..." */)
			}
			gz_uncompress(tls, file, libc.X__acrt_iob_func(tls, uint32(1)))
		} else {
			file = z.Xgzdopen(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(1))), bp+24 /* &outmode[0] */)
			if file == (uintptr(0)) {
				error(tls, ts+171 /* "can't gzdopen st..." */)
			}
			gz_compress(tls, libc.X__acrt_iob_func(tls, uint32(0)), file)
		}
	} else {
		if copyout != 0 {
			libc.Xsetmode(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(1))), 0x8000)
		}
		for ok := true; ok; ok = func() bool { argv += 8; return libc.PreDecInt32(&argc, 1) != 0 }() {
			if uncompr != 0 {
				if copyout != 0 {
					file = z.Xgzopen(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+89 /* "rb" */)
					if file == (uintptr(0)) {
						libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+92 /* "%s: can't gzopen..." */, libc.VaList(bp+8, prog, *(*uintptr)(unsafe.Pointer(argv))))
					} else {
						gz_uncompress(tls, file, libc.X__acrt_iob_func(tls, uint32(1)))
					}
				} else {
					file_uncompress(tls, *(*uintptr)(unsafe.Pointer(argv)))
				}
			} else {
				if copyout != 0 {
					var in uintptr = libc.Xfopen(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+89 /* "rb" */)

					if in == (uintptr(0)) {
						libc.Xperror(tls, *(*uintptr)(unsafe.Pointer(argv)))
					} else {
						file = z.Xgzdopen(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(1))), bp+24 /* &outmode[0] */)
						if file == (uintptr(0)) {
							error(tls, ts+171 /* "can't gzdopen st..." */)
						}

						gz_compress(tls, in, file)
					}

				} else {
					file_compress(tls, *(*uintptr)(unsafe.Pointer(argv)), bp+24 /* &outmode[0] */)
				}
			}
		}
	}
	return 0
}

var ts1 = "%s: %s\n\x00fread\x00failed gzclose\x00failed fwrite\x00failed fclose\x00.gz\x00%s: filename too long\n\x00%s%s\x00rb\x00%s: can't gzopen %s\n\x00%s\x00wb\x00wb6 \x00gunzip\x00zcat\x00-c\x00-d\x00-f\x00-h\x00-r\x00can't gzdopen stdin\x00can't gzdopen stdout\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
