/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shared.uuid;

import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.shared.uuid.JenaUUID;

public class UUID_V1
extends JenaUUID {
    public static final int version = 1;
    public static final int variant = 2;
    long bitsMostSignificant;
    long bitsLeastSignificant;

    UUID_V1(long mostSigBits, long leastSigBits) {
        if (!this.check(mostSigBits, leastSigBits)) {
            this.check(mostSigBits, leastSigBits);
            throw new IllegalArgumentException("Funny bits");
        }
        this.bitsMostSignificant = mostSigBits;
        this.bitsLeastSignificant = leastSigBits;
    }

    @Override
    public long getMostSignificantBits() {
        return this.bitsMostSignificant;
    }

    @Override
    public long getLeastSignificantBits() {
        return this.bitsLeastSignificant;
    }

    private boolean check(long mostSigBits, long leastSigBits) {
        int _variant = this._getVariant(mostSigBits, leastSigBits);
        int _version = this._getVersion(mostSigBits, leastSigBits);
        if (_variant != 2) {
            return false;
        }
        return _version == 1;
    }

    long getTimeHigh() {
        return BitsLong.unpack(this.bitsMostSignificant, 0, 12);
    }

    long getTimeMid() {
        return BitsLong.unpack(this.bitsMostSignificant, 16, 32);
    }

    long getTimeLow() {
        return BitsLong.unpack(this.bitsMostSignificant, 32, 64);
    }

    public long getTimestamp() {
        return this.getTimeLow() | this.getTimeMid() << 32 | this.getTimeHigh() << 48;
    }

    public long getClockSequence() {
        return BitsLong.unpack(this.bitsLeastSignificant, 48, 62);
    }

    public long getNode() {
        return BitsLong.unpack(this.bitsLeastSignificant, 0, 48);
    }

    @Override
    public int getVersion() {
        return super._getVersion(this.bitsMostSignificant, this.bitsLeastSignificant);
    }

    @Override
    public int getVariant() {
        return super._getVariant(this.bitsMostSignificant, this.bitsLeastSignificant);
    }
}

