/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.ArrayList;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokespecial;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.process.analyzer.classfile.visitor.CompareInstructionVisitor;
import jd.core.process.analyzer.classfile.visitor.SearchInstructionByOpcodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitInstanceFieldsReconstructor {
    public static void Reconstruct(ClassFile classFile) {
        ArrayList<PutField> putFieldList = new ArrayList<PutField>();
        ConstantPool constants = classFile.getConstantPool();
        Method[] methods = classFile.getMethods();
        if (methods == null) {
            return;
        }
        int methodIndex = methods.length;
        Method putFieldListMethod = null;
        while (methodIndex > 0) {
            List<Instruction> list;
            Method method = methods[--methodIndex];
            if ((method.access_flags & 0x1040) != 0 || method.getCode() == null || method.getFastNodes() == null || method.containsError() || method.name_index != constants.instanceConstructorIndex || (list = method.getFastNodes()) == null) continue;
            int length = list.size();
            if (length <= 0) break;
            int j = InitInstanceFieldsReconstructor.GetSuperCallIndex(classFile, constants, list);
            if (j < 0) continue;
            int lineNumberBefore = ++j > 0 ? list.get((int)(j - 1)).lineNumber : Instruction.UNKNOWN_LINE_NUMBER;
            Instruction instruction = null;
            while (j < length) {
                Instruction valueInstruction;
                instruction = list.get(j++);
                if (instruction.opcode != 181) break;
                PutField putField = (PutField)instruction;
                ConstantFieldref cfr = constants.getConstantFieldref(putField.index);
                if (cfr.class_index != classFile.getThisClassIndex() || putField.objectref.opcode != 25) break;
                ALoad aLaod = (ALoad)putField.objectref;
                if (aLaod.index != 0 || (valueInstruction = SearchInstructionByOpcodeVisitor.visit(putField.valueref, 25)) != null && ((ALoad)valueInstruction).index != 0 || SearchInstructionByOpcodeVisitor.visit(putField.valueref, 268) != null || SearchInstructionByOpcodeVisitor.visit(putField.valueref, 21) != null) break;
                putFieldList.add(putField);
                putFieldListMethod = method;
            }
            if (lineNumberBefore == Instruction.UNKNOWN_LINE_NUMBER || instruction == null) break;
            int i = putFieldList.size();
            int lineNumberAfter = instruction.lineNumber;
            if (instruction.opcode == 177 && j == length && i != 0 && lineNumberAfter == ((PutField)putFieldList.get((int)(i - 1))).lineNumber) break;
            while (i-- > 0) {
                int lineNumber = ((PutField)putFieldList.get((int)i)).lineNumber;
                if (lineNumberBefore > lineNumber || lineNumber > lineNumberAfter) continue;
                putFieldList.remove(i);
            }
            break block0;
        }
        CompareInstructionVisitor visitor = new CompareInstructionVisitor();
        block3: while (methodIndex > 0) {
            int j;
            List<Instruction> list;
            int length;
            Method method = methods[--methodIndex];
            if ((method.access_flags & 0x1040) != 0 || method.getCode() == null || method.name_index != constants.instanceConstructorIndex || (length = (list = method.getFastNodes()).size()) <= 0 || (j = InitInstanceFieldsReconstructor.GetSuperCallIndex(classFile, constants, list)) < 0) continue;
            int firstPutFieldIndex = j + 1;
            int putFieldListLength = putFieldList.size();
            while (firstPutFieldIndex + putFieldListLength > length) {
                putFieldList.remove(--putFieldListLength);
            }
            int i = 0;
            while (i < putFieldListLength) {
                Instruction initFieldInstruction = (Instruction)putFieldList.get(i);
                Instruction instruction = list.get(firstPutFieldIndex + i);
                if (initFieldInstruction.lineNumber != instruction.lineNumber || !visitor.visit(initFieldInstruction, instruction)) {
                    while (i < putFieldListLength) {
                        putFieldList.remove(--putFieldListLength);
                    }
                    continue block3;
                }
                ++i;
            }
        }
        int putFieldListLength = putFieldList.size();
        Field[] fields = classFile.getFields();
        if (putFieldListLength > 0 && fields != null) {
            int fieldLength = fields.length;
            int putFieldListIndex = putFieldListLength;
            while (putFieldListIndex-- > 0) {
                PutField putField = (PutField)putFieldList.get(putFieldListIndex);
                ConstantFieldref cfr = constants.getConstantFieldref(putField.index);
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
                int fieldIndex = 0;
                while (fieldIndex < fieldLength) {
                    Field field = fields[fieldIndex];
                    if (cnat.name_index == field.name_index && cnat.descriptor_index == field.descriptor_index && (field.access_flags & 8) == 0) {
                        Instruction valueref = putField.valueref;
                        field.setValueAndMethod(valueref, putFieldListMethod);
                        if (valueref.opcode != 283) break;
                        valueref.opcode = 282;
                        break;
                    }
                    ++fieldIndex;
                }
                if (fieldIndex != fieldLength) continue;
                putFieldList.remove(putFieldListIndex);
                --putFieldListLength;
            }
            if (putFieldListLength > 0) {
                methodIndex = methods.length;
                block9: while (methodIndex-- > 0) {
                    List<Instruction> list;
                    int length;
                    Method method = methods[methodIndex];
                    if ((method.access_flags & 0x1040) != 0 || method.getCode() == null || method.name_index != constants.instanceConstructorIndex || (length = (list = method.getFastNodes()).size()) <= 0) continue;
                    putFieldListIndex = 0;
                    int putFieldIndex = ((PutField)putFieldList.get((int)putFieldListIndex)).index;
                    int index = 0;
                    while (index < length) {
                        Instruction instruction = list.get(index);
                        if (instruction.opcode == 181) {
                            PutField putField = (PutField)instruction;
                            if (putField.index == putFieldIndex) {
                                ConstantFieldref cfr = constants.getConstantFieldref(putField.index);
                                if (cfr.class_index == classFile.getThisClassIndex() && putField.objectref.opcode == 25) {
                                    ALoad aLaod = (ALoad)putField.objectref;
                                    if (aLaod.index == 0) {
                                        list.remove(index--);
                                        --length;
                                        if (++putFieldListIndex >= putFieldListLength) continue block9;
                                        putFieldIndex = ((PutField)putFieldList.get((int)putFieldListIndex)).index;
                                    }
                                }
                            }
                        }
                        ++index;
                    }
                }
            }
        }
    }

    private static int GetSuperCallIndex(ClassFile classFile, ConstantPool constants, List<Instruction> list) {
        int length = list.size();
        int i = 0;
        while (i < length) {
            Instruction instruction = list.get(i);
            if (instruction.opcode == 183) {
                Invokespecial is = (Invokespecial)instruction;
                if (is.objectref.opcode == 25 && ((ALoad)is.objectref).index == 0) {
                    ConstantMethodref cmr = constants.getConstantMethodref(is.index);
                    ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
                    if (cnat.name_index == constants.instanceConstructorIndex) {
                        if (cmr.class_index == classFile.getThisClassIndex()) {
                            return -1;
                        }
                        return i;
                    }
                }
            }
            ++i;
        }
        return -1;
    }
}

