/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.List;
import java.util.Stack;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.ByteCodeConstants;
import jd.core.model.instruction.bytecode.instruction.IInc;
import jd.core.model.instruction.bytecode.instruction.ILoad;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IIncFactory
extends InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Stack<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        byte index = code[offset + 1];
        byte count = code[offset + 2];
        if (stack.isEmpty() || jumps[offset]) {
            IInc instruction = new IInc(opcode, offset, lineNumber, index, count);
            list.add(instruction);
            listForAnalyze.add(instruction);
        } else {
            Instruction instruction = (Instruction)stack.lastElement();
            if (instruction.opcode == 21 && ((ILoad)instruction).index == index) {
                stack.pop();
                instruction = new IncInstruction(278, offset, lineNumber, instruction, count);
                stack.push(instruction);
                listForAnalyze.add(instruction);
            } else if (count == -1 || count == 1) {
                instruction = new IInc(opcode, offset, lineNumber, index, count);
                stack.push(instruction);
            } else {
                instruction = new IInc(opcode, offset, lineNumber, index, count);
                list.add(instruction);
                listForAnalyze.add(instruction);
            }
        }
        return ByteCodeConstants.NO_OF_OPERANDS[opcode];
    }
}

