/////////////////////////////////////////////////////////////////////////////
//
// ColourButton
// Control panel like colour picker
// Based on code taken from http://www.codeproject.com/
//
/////////////////////////////////////////////////////////////////////////////

#ifndef COLOUR_BUTTON_H_
#define COLOUR_BUTTON_H_

#include <UxTheme.h>

// In order to ease use, these values have been hard coded in
// ColourButton.rc. This avoids the need for another header file.

#define IDD_COLOURBTN (5100)
#define IDC_COLOUR1   (5101)
#define IDC_COLOUR20  (5120)
#define IDC_OTHER     (5121)

// The dialog that pops up when the colour button is pressed
class CColourButtonDlg : public CDialog
{
// Construction
public:
	CColourButtonDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CColourButtonDlg)
	enum { IDD = IDD_COLOURBTN };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CColourButtonDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CColourButtonDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	afx_msg void OnOther();
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG
	void OnColor(UINT id);
	void EndDialog(int nResult);

	DECLARE_MESSAGE_MAP()

public:
	static COLORREF m_Colours[20];
	static BYTE m_Used[20];
	int m_ColourIndex;
	CButton *m_pParent;
	CString m_strOther;
};

// The colour button
class CColourButton : public CButton
{
// Construction
public:
	CColourButton(BOOL bPopup = TRUE);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CColourButton)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CColourButton();

	// Generated message map functions
protected:
	//{{AFX_MSG(CColourButton)
	afx_msg void OnClicked();
	//}}AFX_MSG
	void DrawItem(LPDRAWITEMSTRUCT);

	DECLARE_MESSAGE_MAP()

	// The selected colour
public:
	COLORREF GetCurrentColour(void) { return m_CurrentColour; }
	void SetCurrentColour(COLORREF Colour) { m_CurrentColour = Colour; }

	void SetOtherText(LPCTSTR pszOther) { m_Dialog.m_strOther = pszOther; }

protected:
	HMODULE m_hThemeDll;

	BOOL IsAppThemed(void);
	HTHEME OpenThemeData(LPCWSTR pszClassList);
	void CloseThemeData(HTHEME hTheme);
	void DrawThemeBackground(HTHEME hTheme, HDC hDC, 
		int iPartId, int iStateId, const RECT *pRect, const RECT *pClipRect);

protected:
	COLORREF m_CurrentColour;
	BOOL m_bPopup;

	// The popup dialog
	CColourButtonDlg m_Dialog;
};

#endif // COLOUR_BUTTON_H_
