// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/dialogflow/cx/v3beta1/session.proto

package cx

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Type of the response message.
type StreamingRecognitionResult_MessageType int32

const (
	// Not specified. Should never be used.
	StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED StreamingRecognitionResult_MessageType = 0
	// Message contains a (possibly partial) transcript.
	StreamingRecognitionResult_TRANSCRIPT StreamingRecognitionResult_MessageType = 1
	// Event indicates that the server has detected the end of the user's speech
	// utterance and expects no additional speech. Therefore, the server will
	// not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection. This message is only sent if
	// [`single_utterance`][google.cloud.dialogflow.cx.v3beta1.InputAudioConfig.single_utterance] was set to
	// `true`, and is not used otherwise.
	StreamingRecognitionResult_END_OF_SINGLE_UTTERANCE StreamingRecognitionResult_MessageType = 2
)

// Enum value maps for StreamingRecognitionResult_MessageType.
var (
	StreamingRecognitionResult_MessageType_name = map[int32]string{
		0: "MESSAGE_TYPE_UNSPECIFIED",
		1: "TRANSCRIPT",
		2: "END_OF_SINGLE_UTTERANCE",
	}
	StreamingRecognitionResult_MessageType_value = map[string]int32{
		"MESSAGE_TYPE_UNSPECIFIED": 0,
		"TRANSCRIPT":               1,
		"END_OF_SINGLE_UTTERANCE":  2,
	}
)

func (x StreamingRecognitionResult_MessageType) Enum() *StreamingRecognitionResult_MessageType {
	p := new(StreamingRecognitionResult_MessageType)
	*p = x
	return p
}

func (x StreamingRecognitionResult_MessageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamingRecognitionResult_MessageType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[0].Descriptor()
}

func (StreamingRecognitionResult_MessageType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[0]
}

func (x StreamingRecognitionResult_MessageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamingRecognitionResult_MessageType.Descriptor instead.
func (StreamingRecognitionResult_MessageType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{4, 0}
}

// Type of a Match.
type Match_MatchType int32

const (
	// Not specified. Should never be used.
	Match_MATCH_TYPE_UNSPECIFIED Match_MatchType = 0
	// The query was matched to an intent.
	Match_INTENT Match_MatchType = 1
	// The query directly triggered an intent.
	Match_DIRECT_INTENT Match_MatchType = 2
	// The query was used for parameter filling.
	Match_PARAMETER_FILLING Match_MatchType = 3
	// No match was found for the query.
	Match_NO_MATCH Match_MatchType = 4
	// Indicates an empty query.
	Match_NO_INPUT Match_MatchType = 5
	// The query directly triggered an event.
	Match_EVENT Match_MatchType = 6
)

// Enum value maps for Match_MatchType.
var (
	Match_MatchType_name = map[int32]string{
		0: "MATCH_TYPE_UNSPECIFIED",
		1: "INTENT",
		2: "DIRECT_INTENT",
		3: "PARAMETER_FILLING",
		4: "NO_MATCH",
		5: "NO_INPUT",
		6: "EVENT",
	}
	Match_MatchType_value = map[string]int32{
		"MATCH_TYPE_UNSPECIFIED": 0,
		"INTENT":                 1,
		"DIRECT_INTENT":          2,
		"PARAMETER_FILLING":      3,
		"NO_MATCH":               4,
		"NO_INPUT":               5,
		"EVENT":                  6,
	}
)

func (x Match_MatchType) Enum() *Match_MatchType {
	p := new(Match_MatchType)
	*p = x
	return p
}

func (x Match_MatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Match_MatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[1].Descriptor()
}

func (Match_MatchType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes[1]
}

func (x Match_MatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Match_MatchType.Descriptor instead.
func (Match_MatchType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{13, 0}
}

// The request to detect user's intent.
type DetectIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session this query is sent to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/sessions/<Session ID>` or `projects/<Project ID>/locations/<Location
	// ID>/agents/<Agent ID>/environments/<Environment ID>/sessions/<Session ID>`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment.
	// It's up to the API caller to choose an appropriate `Session ID`. It can be
	// a random number or some type of session identifiers (preferably hashed).
	// The length of the `Session ID` must not exceed 36 characters.
	//
	// For more information, see the [sessions
	// guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Instructs the speech synthesizer how to generate the output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
}

func (x *DetectIntentRequest) Reset() {
	*x = DetectIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectIntentRequest) ProtoMessage() {}

func (x *DetectIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectIntentRequest.ProtoReflect.Descriptor instead.
func (*DetectIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{0}
}

func (x *DetectIntentRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *DetectIntentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *DetectIntentRequest) GetQueryInput() *QueryInput {
	if x != nil {
		return x.QueryInput
	}
	return nil
}

func (x *DetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

// The message returned from the DetectIntent method.
type DetectIntentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The result of the conversational query.
	QueryResult *QueryResult `protobuf:"bytes,2,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the
	// [`query_result.response_messages`][google.cloud.dialogflow.cx.v3beta1.QueryResult.response_messages] field. If
	// multiple default text responses exist, they will be concatenated when
	// generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	//
	// In some scenarios, multiple output audio fields may be present in the
	// response structure. In these cases, only the top-most-level audio output
	// has content.
	OutputAudio []byte `protobuf:"bytes,4,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,5,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
}

func (x *DetectIntentResponse) Reset() {
	*x = DetectIntentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectIntentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectIntentResponse) ProtoMessage() {}

func (x *DetectIntentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectIntentResponse.ProtoReflect.Descriptor instead.
func (*DetectIntentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{1}
}

func (x *DetectIntentResponse) GetResponseId() string {
	if x != nil {
		return x.ResponseId
	}
	return ""
}

func (x *DetectIntentResponse) GetQueryResult() *QueryResult {
	if x != nil {
		return x.QueryResult
	}
	return nil
}

func (x *DetectIntentResponse) GetOutputAudio() []byte {
	if x != nil {
		return x.OutputAudio
	}
	return nil
}

func (x *DetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

// The top-level message sent by the client to the
// [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.StreamingDetectIntent] method.
//
// Multiple request messages should be sent in order:
//
// 1.  The first message must contain
// [session][google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.session],
//     [query_input][google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.query_input] plus optionally
//     [query_params][google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.query_params]. If the client
//     wants to receive an audio response, it should also contain
//     [output_audio_config][google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.output_audio_config].
//
// 2.  If [query_input][google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.query_input] was set to
//     [query_input.audio.config][google.cloud.dialogflow.cx.v3beta1.AudioInput.config], all subsequent messages
//     must contain [query_input.audio.audio][google.cloud.dialogflow.cx.v3beta1.AudioInput.audio] to continue with
//     Speech recognition.
//     If you decide to rather detect an intent from text
//     input after you already started Speech recognition, please send a message
//     with [query_input.text][google.cloud.dialogflow.cx.v3beta1.QueryInput.text].
//
//     However, note that:
//
//     * Dialogflow will bill you for the audio duration so far.
//     * Dialogflow discards all Speech recognition results in favor of the
//       input text.
//     * Dialogflow will use the language code from the first message.
//
// After you sent all input, you must half-close or abort the request stream.
type StreamingDetectIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the session this query is sent to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/sessions/<Session ID>` or `projects/<Project ID>/locations/<Location
	// ID>/agents/<Agent ID>/environments/<Environment ID>/sessions/<Session ID>`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment.
	// It's up to the API caller to choose an appropriate `Session ID`. It can be
	// a random number or some type of session identifiers (preferably hashed).
	// The length of the `Session ID` must not exceed 36 characters.
	// Note: session must be set in the first request.
	//
	// For more information, see the [sessions
	// guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Instructs the speech synthesizer how to generate the output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
}

func (x *StreamingDetectIntentRequest) Reset() {
	*x = StreamingDetectIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingDetectIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingDetectIntentRequest) ProtoMessage() {}

func (x *StreamingDetectIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingDetectIntentRequest.ProtoReflect.Descriptor instead.
func (*StreamingDetectIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{2}
}

func (x *StreamingDetectIntentRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *StreamingDetectIntentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *StreamingDetectIntentRequest) GetQueryInput() *QueryInput {
	if x != nil {
		return x.QueryInput
	}
	return nil
}

func (x *StreamingDetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

// The top-level message returned from the `StreamingDetectIntent` method.
//
// Multiple response messages can be returned in order:
//
// 1.  If the input was set to streaming audio, the first one or more messages
//     contain `recognition_result`. Each `recognition_result` represents a more
//     complete transcript of what the user said. The last `recognition_result`
//     has `is_final` set to `true`.
//
// 2.  The last message contains `detect_intent_response`.
type StreamingDetectIntentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output response.
	//
	// Types that are assignable to Response:
	//	*StreamingDetectIntentResponse_RecognitionResult
	//	*StreamingDetectIntentResponse_DetectIntentResponse
	Response isStreamingDetectIntentResponse_Response `protobuf_oneof:"response"`
}

func (x *StreamingDetectIntentResponse) Reset() {
	*x = StreamingDetectIntentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingDetectIntentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingDetectIntentResponse) ProtoMessage() {}

func (x *StreamingDetectIntentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingDetectIntentResponse.ProtoReflect.Descriptor instead.
func (*StreamingDetectIntentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{3}
}

func (m *StreamingDetectIntentResponse) GetResponse() isStreamingDetectIntentResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *StreamingDetectIntentResponse) GetRecognitionResult() *StreamingRecognitionResult {
	if x, ok := x.GetResponse().(*StreamingDetectIntentResponse_RecognitionResult); ok {
		return x.RecognitionResult
	}
	return nil
}

func (x *StreamingDetectIntentResponse) GetDetectIntentResponse() *DetectIntentResponse {
	if x, ok := x.GetResponse().(*StreamingDetectIntentResponse_DetectIntentResponse); ok {
		return x.DetectIntentResponse
	}
	return nil
}

type isStreamingDetectIntentResponse_Response interface {
	isStreamingDetectIntentResponse_Response()
}

type StreamingDetectIntentResponse_RecognitionResult struct {
	// The result of speech recognition.
	RecognitionResult *StreamingRecognitionResult `protobuf:"bytes,1,opt,name=recognition_result,json=recognitionResult,proto3,oneof"`
}

type StreamingDetectIntentResponse_DetectIntentResponse struct {
	// The response from detect intent.
	DetectIntentResponse *DetectIntentResponse `protobuf:"bytes,2,opt,name=detect_intent_response,json=detectIntentResponse,proto3,oneof"`
}

func (*StreamingDetectIntentResponse_RecognitionResult) isStreamingDetectIntentResponse_Response() {}

func (*StreamingDetectIntentResponse_DetectIntentResponse) isStreamingDetectIntentResponse_Response() {
}

// Contains a speech recognition result corresponding to a portion of the audio
// that is currently being processed or an indication that this is the end
// of the single requested utterance.
//
// Example:
//
// 1.  transcript: "tube"
//
// 2.  transcript: "to be a"
//
// 3.  transcript: "to be"
//
// 4.  transcript: "to be or not to be"
//     is_final: true
//
// 5.  transcript: " that's"
//
// 6.  transcript: " that is"
//
// 7.  message_type: `END_OF_SINGLE_UTTERANCE`
//
// 8.  transcript: " that is the question"
//     is_final: true
//
// Only two of the responses contain final results (#4 and #8 indicated by
// `is_final: true`). Concatenating these generates the full transcript: "to be
// or not to be that is the question".
//
// In each response we populate:
//
// *  for `TRANSCRIPT`: `transcript` and possibly `is_final`.
//
// *  for `END_OF_SINGLE_UTTERANCE`: only `message_type`.
type StreamingRecognitionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the result message.
	MessageType StreamingRecognitionResult_MessageType `protobuf:"varint,1,opt,name=message_type,json=messageType,proto3,enum=google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult_MessageType" json:"message_type,omitempty"`
	// Transcript text representing the words that the user spoke.
	// Populated if and only if `message_type` = `TRANSCRIPT`.
	Transcript string `protobuf:"bytes,2,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// If `false`, the `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, the recognizer will not return
	// any further hypotheses about this piece of the audio. May only be populated
	// for `message_type` = `TRANSCRIPT`.
	IsFinal bool `protobuf:"varint,3,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// The Speech confidence between 0.0 and 1.0 for the current portion of audio.
	// A higher number indicates an estimated greater likelihood that the
	// recognized words are correct. The default of 0.0 is a sentinel value
	// indicating that confidence was not set.
	//
	// This field is typically only provided if `is_final` is true and you should
	// not rely on it being accurate or even set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// An estimate of the likelihood that the speech recognizer will
	// not change its guess about this interim recognition result:
	// * If the value is unspecified or 0.0, Dialogflow didn't compute the
	//   stability. In particular, Dialogflow will only provide stability for
	//   `TRANSCRIPT` results with `is_final = false`.
	// * Otherwise, the value is in (0.0, 1.0] where 0.0 means completely
	//   unstable and 1.0 means completely stable.
	Stability float32 `protobuf:"fixed32,6,opt,name=stability,proto3" json:"stability,omitempty"`
	// Word-specific information for the words recognized by Speech in
	// [transcript][google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.transcript]. Populated if and only if `message_type` = `TRANSCRIPT` and
	// [InputAudioConfig.enable_word_info] is set.
	SpeechWordInfo []*SpeechWordInfo `protobuf:"bytes,7,rep,name=speech_word_info,json=speechWordInfo,proto3" json:"speech_word_info,omitempty"`
	// Time offset of the end of this Speech recognition result relative to the
	// beginning of the audio. Only populated for `message_type` =
	// `TRANSCRIPT`.
	SpeechEndOffset *durationpb.Duration `protobuf:"bytes,8,opt,name=speech_end_offset,json=speechEndOffset,proto3" json:"speech_end_offset,omitempty"`
}

func (x *StreamingRecognitionResult) Reset() {
	*x = StreamingRecognitionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingRecognitionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognitionResult) ProtoMessage() {}

func (x *StreamingRecognitionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognitionResult.ProtoReflect.Descriptor instead.
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{4}
}

func (x *StreamingRecognitionResult) GetMessageType() StreamingRecognitionResult_MessageType {
	if x != nil {
		return x.MessageType
	}
	return StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED
}

func (x *StreamingRecognitionResult) GetTranscript() string {
	if x != nil {
		return x.Transcript
	}
	return ""
}

func (x *StreamingRecognitionResult) GetIsFinal() bool {
	if x != nil {
		return x.IsFinal
	}
	return false
}

func (x *StreamingRecognitionResult) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *StreamingRecognitionResult) GetStability() float32 {
	if x != nil {
		return x.Stability
	}
	return 0
}

func (x *StreamingRecognitionResult) GetSpeechWordInfo() []*SpeechWordInfo {
	if x != nil {
		return x.SpeechWordInfo
	}
	return nil
}

func (x *StreamingRecognitionResult) GetSpeechEndOffset() *durationpb.Duration {
	if x != nil {
		return x.SpeechEndOffset
	}
	return nil
}

// Represents the parameters of a conversational query.
type QueryParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time zone of this conversational query from the [time zone
	// database](https://www.iana.org/time-zones), e.g., America/New_York,
	// Europe/Paris. If not provided, the time zone specified in the agent is
	// used.
	TimeZone string `protobuf:"bytes,1,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// The geo location of this conversational query.
	GeoLocation *latlng.LatLng `protobuf:"bytes,2,opt,name=geo_location,json=geoLocation,proto3" json:"geo_location,omitempty"`
	// Additional session entity types to replace or extend developer entity types
	// with. The entity synonyms apply to all languages and persist for the
	// session of this query.
	SessionEntityTypes []*SessionEntityType `protobuf:"bytes,3,rep,name=session_entity_types,json=sessionEntityTypes,proto3" json:"session_entity_types,omitempty"`
	// This field can be used to pass custom data into the webhook associated with
	// the agent. Arbitrary JSON objects are supported.
	Payload *structpb.Struct `protobuf:"bytes,4,opt,name=payload,proto3" json:"payload,omitempty"`
	// Additional parameters to be put into [session
	// parameters][SessionInfo.parameters]. To remove a
	// parameter from the session, clients should explicitly set the parameter
	// value to null.
	//
	// Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object
	// composed of a collection of (MapKey, MapValue) pairs:
	//
	// -   MapKey type: string
	// -   MapKey value: parameter name
	// -   MapValue type:
	//     -   If parameter's entity type is a composite entity: map
	//     -   Else: depending on parameter value type, could be one of string,
	//     number, boolean, null, list or map
	// -   MapValue value:
	//     -   If parameter's entity type is a composite entity:
	//         map from composite entity property names to property values
	//     -   Else: parameter value
	Parameters *structpb.Struct `protobuf:"bytes,5,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Configures whether sentiment analysis should be performed. If not
	// provided, sentiment analysis is not performed.
	AnalyzeQueryTextSentiment bool `protobuf:"varint,8,opt,name=analyze_query_text_sentiment,json=analyzeQueryTextSentiment,proto3" json:"analyze_query_text_sentiment,omitempty"`
	// This field can be used to pass HTTP headers for a webhook
	// call. These headers will be sent to webhook along with the headers that
	// have been configured through Dialogflow web console. The headers defined
	// within this field will overwrite the headers configured through Dialogflow
	// console if there is a conflict. Header names are case-insensitive.
	// Google's specified headers are not allowed. Including: "Host",
	// "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
	// "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
	WebhookHeaders map[string]string `protobuf:"bytes,10,rep,name=webhook_headers,json=webhookHeaders,proto3" json:"webhook_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *QueryParameters) Reset() {
	*x = QueryParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryParameters) ProtoMessage() {}

func (x *QueryParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryParameters.ProtoReflect.Descriptor instead.
func (*QueryParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{5}
}

func (x *QueryParameters) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *QueryParameters) GetGeoLocation() *latlng.LatLng {
	if x != nil {
		return x.GeoLocation
	}
	return nil
}

func (x *QueryParameters) GetSessionEntityTypes() []*SessionEntityType {
	if x != nil {
		return x.SessionEntityTypes
	}
	return nil
}

func (x *QueryParameters) GetPayload() *structpb.Struct {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *QueryParameters) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *QueryParameters) GetAnalyzeQueryTextSentiment() bool {
	if x != nil {
		return x.AnalyzeQueryTextSentiment
	}
	return false
}

func (x *QueryParameters) GetWebhookHeaders() map[string]string {
	if x != nil {
		return x.WebhookHeaders
	}
	return nil
}

// Represents the query input. It can contain one of:
//
// 1.  A conversational query in the form of text.
//
// 2.  An intent query that specifies which intent to trigger.
//
// 3.  Natural language speech audio to be processed.
//
// 4.  An event to be triggered.
//
type QueryInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The input specification.
	//
	// Types that are assignable to Input:
	//	*QueryInput_Text
	//	*QueryInput_Intent
	//	*QueryInput_Audio
	//	*QueryInput_Event
	//	*QueryInput_Dtmf
	Input isQueryInput_Input `protobuf_oneof:"input"`
	// Required. The language of the input. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language) for a
	// list of the currently supported language codes. Note that queries in the
	// same session do not necessarily need to specify the same language.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *QueryInput) Reset() {
	*x = QueryInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryInput) ProtoMessage() {}

func (x *QueryInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryInput.ProtoReflect.Descriptor instead.
func (*QueryInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{6}
}

func (m *QueryInput) GetInput() isQueryInput_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *QueryInput) GetText() *TextInput {
	if x, ok := x.GetInput().(*QueryInput_Text); ok {
		return x.Text
	}
	return nil
}

func (x *QueryInput) GetIntent() *IntentInput {
	if x, ok := x.GetInput().(*QueryInput_Intent); ok {
		return x.Intent
	}
	return nil
}

func (x *QueryInput) GetAudio() *AudioInput {
	if x, ok := x.GetInput().(*QueryInput_Audio); ok {
		return x.Audio
	}
	return nil
}

func (x *QueryInput) GetEvent() *EventInput {
	if x, ok := x.GetInput().(*QueryInput_Event); ok {
		return x.Event
	}
	return nil
}

func (x *QueryInput) GetDtmf() *DtmfInput {
	if x, ok := x.GetInput().(*QueryInput_Dtmf); ok {
		return x.Dtmf
	}
	return nil
}

func (x *QueryInput) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isQueryInput_Input interface {
	isQueryInput_Input()
}

type QueryInput_Text struct {
	// The natural language text to be processed.
	Text *TextInput `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}

type QueryInput_Intent struct {
	// The intent to be triggered.
	Intent *IntentInput `protobuf:"bytes,3,opt,name=intent,proto3,oneof"`
}

type QueryInput_Audio struct {
	// The natural language speech audio to be processed.
	Audio *AudioInput `protobuf:"bytes,5,opt,name=audio,proto3,oneof"`
}

type QueryInput_Event struct {
	// The event to be triggered.
	Event *EventInput `protobuf:"bytes,6,opt,name=event,proto3,oneof"`
}

type QueryInput_Dtmf struct {
	// The DTMF event to be handled.
	Dtmf *DtmfInput `protobuf:"bytes,7,opt,name=dtmf,proto3,oneof"`
}

func (*QueryInput_Text) isQueryInput_Input() {}

func (*QueryInput_Intent) isQueryInput_Input() {}

func (*QueryInput_Audio) isQueryInput_Input() {}

func (*QueryInput_Event) isQueryInput_Input() {}

func (*QueryInput_Dtmf) isQueryInput_Input() {}

// Represents the result of a conversational query.
type QueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The original conversational query.
	//
	// Types that are assignable to Query:
	//	*QueryResult_Text
	//	*QueryResult_TriggerIntent
	//	*QueryResult_Transcript
	//	*QueryResult_TriggerEvent
	Query isQueryResult_Query `protobuf_oneof:"query"`
	// The language that was triggered during intent detection.
	// See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The collected [session parameters][google.cloud.dialogflow.cx.v3beta1.SessionInfo.parameters].
	//
	// Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object
	// composed of a collection of (MapKey, MapValue) pairs:
	//
	// -   MapKey type: string
	// -   MapKey value: parameter name
	// -   MapValue type:
	//     -   If parameter's entity type is a composite entity: map
	//     -   Else: depending on parameter value type, could be one of string,
	//     number, boolean, null, list or map
	// -   MapValue value:
	//     -   If parameter's entity type is a composite entity:
	//         map from composite entity property names to property values
	//     -   Else: parameter value
	Parameters *structpb.Struct `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// The list of rich messages returned to the client. Responses vary from
	// simple text messages to more sophisticated, structured payloads used
	// to drive complex logic.
	ResponseMessages []*ResponseMessage `protobuf:"bytes,4,rep,name=response_messages,json=responseMessages,proto3" json:"response_messages,omitempty"`
	// The list of webhook call status in the order of call sequence.
	WebhookStatuses []*status.Status `protobuf:"bytes,13,rep,name=webhook_statuses,json=webhookStatuses,proto3" json:"webhook_statuses,omitempty"`
	// The list of webhook payload in [WebhookResponse.payload][google.cloud.dialogflow.cx.v3beta1.WebhookResponse.payload], in
	// the order of call sequence. If some webhook call fails or doesn't return
	// any payload, an empty `Struct` would be used instead.
	WebhookPayloads []*structpb.Struct `protobuf:"bytes,6,rep,name=webhook_payloads,json=webhookPayloads,proto3" json:"webhook_payloads,omitempty"`
	// The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all fields are filled in this message,
	// including but not limited to `name` and `display_name`.
	CurrentPage *Page `protobuf:"bytes,7,opt,name=current_page,json=currentPage,proto3" json:"current_page,omitempty"`
	// The [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] that matched the conversational query. Some, not all fields
	// are filled in this message, including but not limited to: `name` and
	// `display_name`.
	// This field is deprecated, please use [QueryResult.match][google.cloud.dialogflow.cx.v3beta1.QueryResult.match] instead.
	//
	// Deprecated: Do not use.
	Intent *Intent `protobuf:"bytes,8,opt,name=intent,proto3" json:"intent,omitempty"`
	// The intent detection confidence. Values range from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to
	// help match the best intent within the classification threshold.
	// This value may change for the same end-user expression at any time due to a
	// model retraining or change in implementation.
	// This field is deprecated, please use [QueryResult.match][google.cloud.dialogflow.cx.v3beta1.QueryResult.match] instead.
	//
	// Deprecated: Do not use.
	IntentDetectionConfidence float32 `protobuf:"fixed32,9,opt,name=intent_detection_confidence,json=intentDetectionConfidence,proto3" json:"intent_detection_confidence,omitempty"`
	// Intent match result, could be an intent or an event.
	Match *Match `protobuf:"bytes,15,opt,name=match,proto3" json:"match,omitempty"`
	// The free-form diagnostic info. For example, this field could contain
	// webhook call latency. The string keys of the Struct's fields map can change
	// without notice.
	DiagnosticInfo *structpb.Struct `protobuf:"bytes,10,opt,name=diagnostic_info,json=diagnosticInfo,proto3" json:"diagnostic_info,omitempty"`
	// The sentiment analyss result, which depends on
	// [`analyze_query_text_sentiment`]
	// [google.cloud.dialogflow.cx.v3beta1.QueryParameters.analyze_query_text_sentiment], specified in the request.
	SentimentAnalysisResult *SentimentAnalysisResult `protobuf:"bytes,17,opt,name=sentiment_analysis_result,json=sentimentAnalysisResult,proto3" json:"sentiment_analysis_result,omitempty"`
}

func (x *QueryResult) Reset() {
	*x = QueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResult) ProtoMessage() {}

func (x *QueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResult.ProtoReflect.Descriptor instead.
func (*QueryResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{7}
}

func (m *QueryResult) GetQuery() isQueryResult_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (x *QueryResult) GetText() string {
	if x, ok := x.GetQuery().(*QueryResult_Text); ok {
		return x.Text
	}
	return ""
}

func (x *QueryResult) GetTriggerIntent() string {
	if x, ok := x.GetQuery().(*QueryResult_TriggerIntent); ok {
		return x.TriggerIntent
	}
	return ""
}

func (x *QueryResult) GetTranscript() string {
	if x, ok := x.GetQuery().(*QueryResult_Transcript); ok {
		return x.Transcript
	}
	return ""
}

func (x *QueryResult) GetTriggerEvent() string {
	if x, ok := x.GetQuery().(*QueryResult_TriggerEvent); ok {
		return x.TriggerEvent
	}
	return ""
}

func (x *QueryResult) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *QueryResult) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *QueryResult) GetResponseMessages() []*ResponseMessage {
	if x != nil {
		return x.ResponseMessages
	}
	return nil
}

func (x *QueryResult) GetWebhookStatuses() []*status.Status {
	if x != nil {
		return x.WebhookStatuses
	}
	return nil
}

func (x *QueryResult) GetWebhookPayloads() []*structpb.Struct {
	if x != nil {
		return x.WebhookPayloads
	}
	return nil
}

func (x *QueryResult) GetCurrentPage() *Page {
	if x != nil {
		return x.CurrentPage
	}
	return nil
}

// Deprecated: Do not use.
func (x *QueryResult) GetIntent() *Intent {
	if x != nil {
		return x.Intent
	}
	return nil
}

// Deprecated: Do not use.
func (x *QueryResult) GetIntentDetectionConfidence() float32 {
	if x != nil {
		return x.IntentDetectionConfidence
	}
	return 0
}

func (x *QueryResult) GetMatch() *Match {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *QueryResult) GetDiagnosticInfo() *structpb.Struct {
	if x != nil {
		return x.DiagnosticInfo
	}
	return nil
}

func (x *QueryResult) GetSentimentAnalysisResult() *SentimentAnalysisResult {
	if x != nil {
		return x.SentimentAnalysisResult
	}
	return nil
}

type isQueryResult_Query interface {
	isQueryResult_Query()
}

type QueryResult_Text struct {
	// If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput] was provided as input, this field
	// will contain a copy of the text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type QueryResult_TriggerIntent struct {
	// If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was provided as input, this field will
	// contain a copy of the intent identifier.
	TriggerIntent string `protobuf:"bytes,11,opt,name=trigger_intent,json=triggerIntent,proto3,oneof"`
}

type QueryResult_Transcript struct {
	// If [natural language speech audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as input,
	// this field will contain the trascript for the audio.
	Transcript string `protobuf:"bytes,12,opt,name=transcript,proto3,oneof"`
}

type QueryResult_TriggerEvent struct {
	// If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided as input, this field will contain
	// the name of the event.
	TriggerEvent string `protobuf:"bytes,14,opt,name=trigger_event,json=triggerEvent,proto3,oneof"`
}

func (*QueryResult_Text) isQueryResult_Query() {}

func (*QueryResult_TriggerIntent) isQueryResult_Query() {}

func (*QueryResult_Transcript) isQueryResult_Query() {}

func (*QueryResult_TriggerEvent) isQueryResult_Query() {}

// Represents the natural language text to be processed.
type TextInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The UTF-8 encoded natural language text to be processed. Text length must
	// not exceed 256 characters.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *TextInput) Reset() {
	*x = TextInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextInput) ProtoMessage() {}

func (x *TextInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextInput.ProtoReflect.Descriptor instead.
func (*TextInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{8}
}

func (x *TextInput) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Represents the intent to trigger programmatically rather than as a result of
// natural language processing.
type IntentInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the intent.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/intents/<Intent ID>`.
	Intent string `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
}

func (x *IntentInput) Reset() {
	*x = IntentInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentInput) ProtoMessage() {}

func (x *IntentInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentInput.ProtoReflect.Descriptor instead.
func (*IntentInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{9}
}

func (x *IntentInput) GetIntent() string {
	if x != nil {
		return x.Intent
	}
	return ""
}

// Represents the natural speech audio to be processed.
type AudioInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Instructs the speech recognizer how to process the speech audio.
	Config *InputAudioConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// The natural language speech audio to be processed.
	// A single request can contain up to 1 minute of speech audio data.
	// The [transcribed text][google.cloud.dialogflow.cx.v3beta1.QueryResult.transcript] cannot contain more than 256
	// bytes.
	//
	// For non-streaming audio detect intent, both `config` and `audio` must be
	// provided.
	// For streaming audio detect intent, `config` must be provided in
	// the first request and `audio` must be provided in all following requests.
	Audio []byte `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
}

func (x *AudioInput) Reset() {
	*x = AudioInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioInput) ProtoMessage() {}

func (x *AudioInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioInput.ProtoReflect.Descriptor instead.
func (*AudioInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{10}
}

func (x *AudioInput) GetConfig() *InputAudioConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *AudioInput) GetAudio() []byte {
	if x != nil {
		return x.Audio
	}
	return nil
}

// Represents the event to trigger.
type EventInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the event.
	Event string `protobuf:"bytes,1,opt,name=event,proto3" json:"event,omitempty"`
}

func (x *EventInput) Reset() {
	*x = EventInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventInput) ProtoMessage() {}

func (x *EventInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventInput.ProtoReflect.Descriptor instead.
func (*EventInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{11}
}

func (x *EventInput) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

// Represents the input for dtmf event.
type DtmfInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dtmf digits.
	Digits string `protobuf:"bytes,1,opt,name=digits,proto3" json:"digits,omitempty"`
	// The finish digit (if any).
	FinishDigit string `protobuf:"bytes,2,opt,name=finish_digit,json=finishDigit,proto3" json:"finish_digit,omitempty"`
}

func (x *DtmfInput) Reset() {
	*x = DtmfInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DtmfInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DtmfInput) ProtoMessage() {}

func (x *DtmfInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DtmfInput.ProtoReflect.Descriptor instead.
func (*DtmfInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{12}
}

func (x *DtmfInput) GetDigits() string {
	if x != nil {
		return x.Digits
	}
	return ""
}

func (x *DtmfInput) GetFinishDigit() string {
	if x != nil {
		return x.FinishDigit
	}
	return ""
}

// Represents one match result of [MatchIntent][].
type Match struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] that matched the query. Some, not all fields are filled in
	// this message, including but not limited to: `name` and `display_name`. Only
	// filled for [`INTENT`][google.cloud.dialogflow.cx.v3beta1.Match.MatchType] match type.
	Intent *Intent `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	// The event that matched the query. Only filled for
	// [`EVENT`][google.cloud.dialogflow.cx.v3beta1.Match.MatchType] match type.
	Event string `protobuf:"bytes,6,opt,name=event,proto3" json:"event,omitempty"`
	// The collection of parameters extracted from the query.
	//
	// Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object
	// composed of a collection of (MapKey, MapValue) pairs:
	//
	// -   MapKey type: string
	// -   MapKey value: parameter name
	// -   MapValue type:
	//     -   If parameter's entity type is a composite entity: map
	//     -   Else: depending on parameter value type, could be one of string,
	//     number, boolean, null, list or map
	// -   MapValue value:
	//     -   If parameter's entity type is a composite entity:
	//         map from composite entity property names to property values
	//     -   Else: parameter value
	Parameters *structpb.Struct `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Final text input which was matched during MatchIntent. This value can be
	// different from original input sent in request because of spelling
	// correction or other processing.
	ResolvedInput string `protobuf:"bytes,3,opt,name=resolved_input,json=resolvedInput,proto3" json:"resolved_input,omitempty"`
	// Type of this [Match][google.cloud.dialogflow.cx.v3beta1.Match].
	MatchType Match_MatchType `protobuf:"varint,4,opt,name=match_type,json=matchType,proto3,enum=google.cloud.dialogflow.cx.v3beta1.Match_MatchType" json:"match_type,omitempty"`
	// The confidence of this match. Values range from 0.0 (completely uncertain)
	// to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to help match
	// the best intent within the classification threshold. This value may change
	// for the same end-user expression at any time due to a model retraining or
	// change in implementation.
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *Match) Reset() {
	*x = Match{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Match) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Match) ProtoMessage() {}

func (x *Match) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Match.ProtoReflect.Descriptor instead.
func (*Match) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{13}
}

func (x *Match) GetIntent() *Intent {
	if x != nil {
		return x.Intent
	}
	return nil
}

func (x *Match) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

func (x *Match) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Match) GetResolvedInput() string {
	if x != nil {
		return x.ResolvedInput
	}
	return ""
}

func (x *Match) GetMatchType() Match_MatchType {
	if x != nil {
		return x.MatchType
	}
	return Match_MATCH_TYPE_UNSPECIFIED
}

func (x *Match) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Request of [MatchIntent][].
type MatchIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session this query is sent to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/sessions/<Session ID>` or `projects/<Project ID>/locations/<Location
	// ID>/agents/<Agent ID>/environments/<Environment ID>/sessions/<Session ID>`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment.
	// It's up to the API caller to choose an appropriate `Session ID`. It can be
	// a random number or some type of session identifiers (preferably hashed).
	// The length of the `Session ID` must not exceed 36 characters.
	//
	// For more information, see the [sessions
	// guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
}

func (x *MatchIntentRequest) Reset() {
	*x = MatchIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MatchIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MatchIntentRequest) ProtoMessage() {}

func (x *MatchIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MatchIntentRequest.ProtoReflect.Descriptor instead.
func (*MatchIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{14}
}

func (x *MatchIntentRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *MatchIntentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *MatchIntentRequest) GetQueryInput() *QueryInput {
	if x != nil {
		return x.QueryInput
	}
	return nil
}

// Response of [MatchIntent][].
type MatchIntentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The original conversational query.
	//
	// Types that are assignable to Query:
	//	*MatchIntentResponse_Text
	//	*MatchIntentResponse_TriggerIntent
	//	*MatchIntentResponse_Transcript
	//	*MatchIntentResponse_TriggerEvent
	Query isMatchIntentResponse_Query `protobuf_oneof:"query"`
	// Match results, if more than one, ordered descendingly by the confidence
	// we have that the particular intent matches the query.
	Matches []*Match `protobuf:"bytes,4,rep,name=matches,proto3" json:"matches,omitempty"`
	// The current [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Some, not all fields are filled in this message,
	// including but not limited to `name` and `display_name`.
	CurrentPage *Page `protobuf:"bytes,5,opt,name=current_page,json=currentPage,proto3" json:"current_page,omitempty"`
}

func (x *MatchIntentResponse) Reset() {
	*x = MatchIntentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MatchIntentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MatchIntentResponse) ProtoMessage() {}

func (x *MatchIntentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MatchIntentResponse.ProtoReflect.Descriptor instead.
func (*MatchIntentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{15}
}

func (m *MatchIntentResponse) GetQuery() isMatchIntentResponse_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (x *MatchIntentResponse) GetText() string {
	if x, ok := x.GetQuery().(*MatchIntentResponse_Text); ok {
		return x.Text
	}
	return ""
}

func (x *MatchIntentResponse) GetTriggerIntent() string {
	if x, ok := x.GetQuery().(*MatchIntentResponse_TriggerIntent); ok {
		return x.TriggerIntent
	}
	return ""
}

func (x *MatchIntentResponse) GetTranscript() string {
	if x, ok := x.GetQuery().(*MatchIntentResponse_Transcript); ok {
		return x.Transcript
	}
	return ""
}

func (x *MatchIntentResponse) GetTriggerEvent() string {
	if x, ok := x.GetQuery().(*MatchIntentResponse_TriggerEvent); ok {
		return x.TriggerEvent
	}
	return ""
}

func (x *MatchIntentResponse) GetMatches() []*Match {
	if x != nil {
		return x.Matches
	}
	return nil
}

func (x *MatchIntentResponse) GetCurrentPage() *Page {
	if x != nil {
		return x.CurrentPage
	}
	return nil
}

type isMatchIntentResponse_Query interface {
	isMatchIntentResponse_Query()
}

type MatchIntentResponse_Text struct {
	// If [natural language text][google.cloud.dialogflow.cx.v3beta1.TextInput] was provided as input, this field
	// will contain a copy of the text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type MatchIntentResponse_TriggerIntent struct {
	// If an [intent][google.cloud.dialogflow.cx.v3beta1.IntentInput] was provided as input, this field will
	// contain a copy of the intent identifier.
	TriggerIntent string `protobuf:"bytes,2,opt,name=trigger_intent,json=triggerIntent,proto3,oneof"`
}

type MatchIntentResponse_Transcript struct {
	// If [natural language speech audio][google.cloud.dialogflow.cx.v3beta1.AudioInput] was provided as input,
	// this field will contain the trascript for the audio.
	Transcript string `protobuf:"bytes,3,opt,name=transcript,proto3,oneof"`
}

type MatchIntentResponse_TriggerEvent struct {
	// If an [event][google.cloud.dialogflow.cx.v3beta1.EventInput] was provided as input, this field will
	// contain a copy of the event name.
	TriggerEvent string `protobuf:"bytes,6,opt,name=trigger_event,json=triggerEvent,proto3,oneof"`
}

func (*MatchIntentResponse_Text) isMatchIntentResponse_Query() {}

func (*MatchIntentResponse_TriggerIntent) isMatchIntentResponse_Query() {}

func (*MatchIntentResponse_Transcript) isMatchIntentResponse_Query() {}

func (*MatchIntentResponse_TriggerEvent) isMatchIntentResponse_Query() {}

// Request of [FulfillIntent][]
type FulfillIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Must be same as the corresponding MatchIntent request, otherwise the
	// behavior is undefined.
	MatchIntentRequest *MatchIntentRequest `protobuf:"bytes,1,opt,name=match_intent_request,json=matchIntentRequest,proto3" json:"match_intent_request,omitempty"`
	// The matched intent/event to fulfill.
	Match *Match `protobuf:"bytes,2,opt,name=match,proto3" json:"match,omitempty"`
	// Instructs the speech synthesizer how to generate output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,3,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
}

func (x *FulfillIntentRequest) Reset() {
	*x = FulfillIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FulfillIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FulfillIntentRequest) ProtoMessage() {}

func (x *FulfillIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FulfillIntentRequest.ProtoReflect.Descriptor instead.
func (*FulfillIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{16}
}

func (x *FulfillIntentRequest) GetMatchIntentRequest() *MatchIntentRequest {
	if x != nil {
		return x.MatchIntentRequest
	}
	return nil
}

func (x *FulfillIntentRequest) GetMatch() *Match {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *FulfillIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

// Response of [FulfillIntent][]
type FulfillIntentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The result of the conversational query.
	QueryResult *QueryResult `protobuf:"bytes,2,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the
	// [`query_result.response_messages`][google.cloud.dialogflow.cx.v3beta1.QueryResult.response_messages] field. If
	// multiple default text responses exist, they will be concatenated when
	// generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	//
	// In some scenarios, multiple output audio fields may be present in the
	// response structure. In these cases, only the top-most-level audio output
	// has content.
	OutputAudio []byte `protobuf:"bytes,3,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
}

func (x *FulfillIntentResponse) Reset() {
	*x = FulfillIntentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FulfillIntentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FulfillIntentResponse) ProtoMessage() {}

func (x *FulfillIntentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FulfillIntentResponse.ProtoReflect.Descriptor instead.
func (*FulfillIntentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{17}
}

func (x *FulfillIntentResponse) GetResponseId() string {
	if x != nil {
		return x.ResponseId
	}
	return ""
}

func (x *FulfillIntentResponse) GetQueryResult() *QueryResult {
	if x != nil {
		return x.QueryResult
	}
	return nil
}

func (x *FulfillIntentResponse) GetOutputAudio() []byte {
	if x != nil {
		return x.OutputAudio
	}
	return nil
}

func (x *FulfillIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

// The result of sentiment analysis. Sentiment analysis inspects user input
// and identifies the prevailing subjective opinion, especially to determine a
// user's attitude as positive, negative, or neutral.
type SentimentAnalysisResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// A non-negative number in the [0, +inf) range, which represents the absolute
	// magnitude of sentiment, regardless of score (positive or negative).
	Magnitude float32 `protobuf:"fixed32,2,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
}

func (x *SentimentAnalysisResult) Reset() {
	*x = SentimentAnalysisResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SentimentAnalysisResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SentimentAnalysisResult) ProtoMessage() {}

func (x *SentimentAnalysisResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SentimentAnalysisResult.ProtoReflect.Descriptor instead.
func (*SentimentAnalysisResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP(), []int{18}
}

func (x *SentimentAnalysisResult) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *SentimentAnalysisResult) GetMagnitude() float32 {
	if x != nil {
		return x.Magnitude
	}
	return 0
}

var File_google_cloud_dialogflow_cx_v3beta1_session_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x61, 0x67, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xef, 0x02, 0x0a, 0x13, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x43, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x54,
	0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x65, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x95, 0x02, 0x0a, 0x14,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0b, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x65, 0x0a, 0x13,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0xf5, 0x02, 0x0a, 0x1c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x54,
	0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x65, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8e, 0x02, 0x0a, 0x1d,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a,
	0x12, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x11, 0x72, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x70,
	0x0a, 0x16, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x14, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x83, 0x04, 0x0a,
	0x1a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x6d, 0x0a, 0x0c, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73,
	0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73,
	0x46, 0x69, 0x6e, 0x61, 0x6c, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x12, 0x5c, 0x0a, 0x10, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x77, 0x6f,
	0x72, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x64, 0x5f,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x45,
	0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x58, 0x0a, 0x0b, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x45, 0x53, 0x53, 0x41,
	0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x43, 0x52,
	0x49, 0x50, 0x54, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x44, 0x5f, 0x4f, 0x46, 0x5f,
	0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x55, 0x54, 0x54, 0x45, 0x52, 0x41, 0x4e, 0x43, 0x45,
	0x10, 0x02, 0x22, 0xb1, 0x04, 0x0a, 0x0f, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a,
	0x6f, 0x6e, 0x65, 0x12, 0x36, 0x0a, 0x0c, 0x67, 0x65, 0x6f, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x0b,
	0x67, 0x65, 0x6f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x14, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x12, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x3f, 0x0a, 0x1c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x70, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x1a, 0x41, 0x0a, 0x13, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa4, 0x03, 0x0a, 0x0a, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x06, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x46, 0x0a,
	0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x05,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x64, 0x74, 0x6d, 0x66, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x74, 0x6d, 0x66, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x48, 0x00, 0x52, 0x04, 0x64, 0x74, 0x6d, 0x66, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x22, 0xb6, 0x07,
	0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x14, 0x0a,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74,
	0x65, 0x78, 0x74, 0x12, 0x27, 0x0a, 0x0e, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x74,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x0a,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x25,
	0x0a, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x60, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x10, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x10, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x0f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x10, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0x4b, 0x0a, 0x0c, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x52, 0x0b, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x12, 0x46, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a,
	0x1b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x02, 0x42, 0x02, 0x18, 0x01, 0x52, 0x19, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x3f, 0x0a, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x05, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x40, 0x0a, 0x0f, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x77, 0x0a, 0x19, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x17, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x07, 0x0a,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22, 0x24, 0x0a, 0x09, 0x54, 0x65, 0x78, 0x74, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x22, 0x4f, 0x0a, 0x0b,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x75, 0x0a,
	0x0a, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14,
	0x0a, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x22, 0x22, 0x0a, 0x0a, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x46, 0x0a, 0x09, 0x44, 0x74, 0x6d, 0x66,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x69, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x69, 0x67, 0x69, 0x74, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x64, 0x69, 0x67, 0x69, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x44, 0x69, 0x67, 0x69, 0x74,
	0x22, 0xbc, 0x03, 0x0a, 0x05, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x42, 0x0a, 0x06, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x25, 0x0a,
	0x0e, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x52, 0x0a, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x84, 0x01, 0x0a, 0x09, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x11,
	0x0a, 0x0d, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10,
	0x02, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x5f, 0x46,
	0x49, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x5f, 0x4d,
	0x41, 0x54, 0x43, 0x48, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x5f, 0x49, 0x4e, 0x50,
	0x55, 0x54, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x06, 0x22,
	0x87, 0x02, 0x0a, 0x12, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0c, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x54, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x22, 0xb8, 0x02, 0x0a, 0x13, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x27, 0x0a, 0x0e, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x12, 0x25, 0x0a, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x4b,
	0x0a, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x52, 0x0b,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x67, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x22, 0xa8, 0x02, 0x0a, 0x14, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x68, 0x0a,
	0x14, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x12, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x65, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x96, 0x02, 0x0a, 0x15, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x0c, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x21,
	0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x12, 0x65, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4d, 0x0a, 0x17, 0x53, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x61, 0x67,
	0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x6d, 0x61,
	0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x32, 0x8a, 0x0a, 0x0a, 0x08, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0xba, 0x02, 0x0a, 0x0c, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb6, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xaf, 0x01, 0x22, 0x4a, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x01,
	0x2a, 0x5a, 0x5e, 0x22, 0x59, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x01,
	0x2a, 0x12, 0xa2, 0x01, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0xb5, 0x02, 0x0a, 0x0b, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb4, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xad,
	0x01, 0x22, 0x49, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0x5a,
	0x5d, 0x22, 0x58, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0xe9,
	0x02, 0x0a, 0x0d, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xe2, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdb, 0x01, 0x22,
	0x60, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x74, 0x22, 0x6f, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c,
	0x6c, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x42, 0x83, 0x03, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42,
	0x0c, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x3b, 0x63, 0x78, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74,
	0x61, 0x31, 0xea, 0x41, 0xd4, 0x01, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x64, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_dialogflow_cx_v3beta1_session_proto_goTypes = []interface{}{
	(StreamingRecognitionResult_MessageType)(0), // 0: google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.MessageType
	(Match_MatchType)(0),                        // 1: google.cloud.dialogflow.cx.v3beta1.Match.MatchType
	(*DetectIntentRequest)(nil),                 // 2: google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest
	(*DetectIntentResponse)(nil),                // 3: google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
	(*StreamingDetectIntentRequest)(nil),        // 4: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest
	(*StreamingDetectIntentResponse)(nil),       // 5: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
	(*StreamingRecognitionResult)(nil),          // 6: google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult
	(*QueryParameters)(nil),                     // 7: google.cloud.dialogflow.cx.v3beta1.QueryParameters
	(*QueryInput)(nil),                          // 8: google.cloud.dialogflow.cx.v3beta1.QueryInput
	(*QueryResult)(nil),                         // 9: google.cloud.dialogflow.cx.v3beta1.QueryResult
	(*TextInput)(nil),                           // 10: google.cloud.dialogflow.cx.v3beta1.TextInput
	(*IntentInput)(nil),                         // 11: google.cloud.dialogflow.cx.v3beta1.IntentInput
	(*AudioInput)(nil),                          // 12: google.cloud.dialogflow.cx.v3beta1.AudioInput
	(*EventInput)(nil),                          // 13: google.cloud.dialogflow.cx.v3beta1.EventInput
	(*DtmfInput)(nil),                           // 14: google.cloud.dialogflow.cx.v3beta1.DtmfInput
	(*Match)(nil),                               // 15: google.cloud.dialogflow.cx.v3beta1.Match
	(*MatchIntentRequest)(nil),                  // 16: google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest
	(*MatchIntentResponse)(nil),                 // 17: google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse
	(*FulfillIntentRequest)(nil),                // 18: google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest
	(*FulfillIntentResponse)(nil),               // 19: google.cloud.dialogflow.cx.v3beta1.FulfillIntentResponse
	(*SentimentAnalysisResult)(nil),             // 20: google.cloud.dialogflow.cx.v3beta1.SentimentAnalysisResult
	nil,                                         // 21: google.cloud.dialogflow.cx.v3beta1.QueryParameters.WebhookHeadersEntry
	(*OutputAudioConfig)(nil),                   // 22: google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	(*SpeechWordInfo)(nil),                      // 23: google.cloud.dialogflow.cx.v3beta1.SpeechWordInfo
	(*durationpb.Duration)(nil),                 // 24: google.protobuf.Duration
	(*latlng.LatLng)(nil),                       // 25: google.type.LatLng
	(*SessionEntityType)(nil),                   // 26: google.cloud.dialogflow.cx.v3beta1.SessionEntityType
	(*structpb.Struct)(nil),                     // 27: google.protobuf.Struct
	(*ResponseMessage)(nil),                     // 28: google.cloud.dialogflow.cx.v3beta1.ResponseMessage
	(*status.Status)(nil),                       // 29: google.rpc.Status
	(*Page)(nil),                                // 30: google.cloud.dialogflow.cx.v3beta1.Page
	(*Intent)(nil),                              // 31: google.cloud.dialogflow.cx.v3beta1.Intent
	(*InputAudioConfig)(nil),                    // 32: google.cloud.dialogflow.cx.v3beta1.InputAudioConfig
}
var file_google_cloud_dialogflow_cx_v3beta1_session_proto_depIdxs = []int32{
	7,  // 0: google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.query_params:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryParameters
	8,  // 1: google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.query_input:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryInput
	22, // 2: google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.output_audio_config:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	9,  // 3: google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.query_result:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryResult
	22, // 4: google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.output_audio_config:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	7,  // 5: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.query_params:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryParameters
	8,  // 6: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.query_input:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryInput
	22, // 7: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest.output_audio_config:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	6,  // 8: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse.recognition_result:type_name -> google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult
	3,  // 9: google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse.detect_intent_response:type_name -> google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
	0,  // 10: google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.message_type:type_name -> google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.MessageType
	23, // 11: google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.speech_word_info:type_name -> google.cloud.dialogflow.cx.v3beta1.SpeechWordInfo
	24, // 12: google.cloud.dialogflow.cx.v3beta1.StreamingRecognitionResult.speech_end_offset:type_name -> google.protobuf.Duration
	25, // 13: google.cloud.dialogflow.cx.v3beta1.QueryParameters.geo_location:type_name -> google.type.LatLng
	26, // 14: google.cloud.dialogflow.cx.v3beta1.QueryParameters.session_entity_types:type_name -> google.cloud.dialogflow.cx.v3beta1.SessionEntityType
	27, // 15: google.cloud.dialogflow.cx.v3beta1.QueryParameters.payload:type_name -> google.protobuf.Struct
	27, // 16: google.cloud.dialogflow.cx.v3beta1.QueryParameters.parameters:type_name -> google.protobuf.Struct
	21, // 17: google.cloud.dialogflow.cx.v3beta1.QueryParameters.webhook_headers:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryParameters.WebhookHeadersEntry
	10, // 18: google.cloud.dialogflow.cx.v3beta1.QueryInput.text:type_name -> google.cloud.dialogflow.cx.v3beta1.TextInput
	11, // 19: google.cloud.dialogflow.cx.v3beta1.QueryInput.intent:type_name -> google.cloud.dialogflow.cx.v3beta1.IntentInput
	12, // 20: google.cloud.dialogflow.cx.v3beta1.QueryInput.audio:type_name -> google.cloud.dialogflow.cx.v3beta1.AudioInput
	13, // 21: google.cloud.dialogflow.cx.v3beta1.QueryInput.event:type_name -> google.cloud.dialogflow.cx.v3beta1.EventInput
	14, // 22: google.cloud.dialogflow.cx.v3beta1.QueryInput.dtmf:type_name -> google.cloud.dialogflow.cx.v3beta1.DtmfInput
	27, // 23: google.cloud.dialogflow.cx.v3beta1.QueryResult.parameters:type_name -> google.protobuf.Struct
	28, // 24: google.cloud.dialogflow.cx.v3beta1.QueryResult.response_messages:type_name -> google.cloud.dialogflow.cx.v3beta1.ResponseMessage
	29, // 25: google.cloud.dialogflow.cx.v3beta1.QueryResult.webhook_statuses:type_name -> google.rpc.Status
	27, // 26: google.cloud.dialogflow.cx.v3beta1.QueryResult.webhook_payloads:type_name -> google.protobuf.Struct
	30, // 27: google.cloud.dialogflow.cx.v3beta1.QueryResult.current_page:type_name -> google.cloud.dialogflow.cx.v3beta1.Page
	31, // 28: google.cloud.dialogflow.cx.v3beta1.QueryResult.intent:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent
	15, // 29: google.cloud.dialogflow.cx.v3beta1.QueryResult.match:type_name -> google.cloud.dialogflow.cx.v3beta1.Match
	27, // 30: google.cloud.dialogflow.cx.v3beta1.QueryResult.diagnostic_info:type_name -> google.protobuf.Struct
	20, // 31: google.cloud.dialogflow.cx.v3beta1.QueryResult.sentiment_analysis_result:type_name -> google.cloud.dialogflow.cx.v3beta1.SentimentAnalysisResult
	32, // 32: google.cloud.dialogflow.cx.v3beta1.AudioInput.config:type_name -> google.cloud.dialogflow.cx.v3beta1.InputAudioConfig
	31, // 33: google.cloud.dialogflow.cx.v3beta1.Match.intent:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent
	27, // 34: google.cloud.dialogflow.cx.v3beta1.Match.parameters:type_name -> google.protobuf.Struct
	1,  // 35: google.cloud.dialogflow.cx.v3beta1.Match.match_type:type_name -> google.cloud.dialogflow.cx.v3beta1.Match.MatchType
	7,  // 36: google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest.query_params:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryParameters
	8,  // 37: google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest.query_input:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryInput
	15, // 38: google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.matches:type_name -> google.cloud.dialogflow.cx.v3beta1.Match
	30, // 39: google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse.current_page:type_name -> google.cloud.dialogflow.cx.v3beta1.Page
	16, // 40: google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest.match_intent_request:type_name -> google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest
	15, // 41: google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest.match:type_name -> google.cloud.dialogflow.cx.v3beta1.Match
	22, // 42: google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest.output_audio_config:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	9,  // 43: google.cloud.dialogflow.cx.v3beta1.FulfillIntentResponse.query_result:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryResult
	22, // 44: google.cloud.dialogflow.cx.v3beta1.FulfillIntentResponse.output_audio_config:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputAudioConfig
	2,  // 45: google.cloud.dialogflow.cx.v3beta1.Sessions.DetectIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest
	4,  // 46: google.cloud.dialogflow.cx.v3beta1.Sessions.StreamingDetectIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest
	16, // 47: google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest
	18, // 48: google.cloud.dialogflow.cx.v3beta1.Sessions.FulfillIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest
	3,  // 49: google.cloud.dialogflow.cx.v3beta1.Sessions.DetectIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
	5,  // 50: google.cloud.dialogflow.cx.v3beta1.Sessions.StreamingDetectIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse
	17, // 51: google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse
	19, // 52: google.cloud.dialogflow.cx.v3beta1.Sessions.FulfillIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.FulfillIntentResponse
	49, // [49:53] is the sub-list for method output_type
	45, // [45:49] is the sub-list for method input_type
	45, // [45:45] is the sub-list for extension type_name
	45, // [45:45] is the sub-list for extension extendee
	0,  // [0:45] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_session_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_session_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_session_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_audio_config_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_flow_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_response_message_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_session_entity_type_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectIntentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingDetectIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingDetectIntentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingRecognitionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DtmfInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Match); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MatchIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MatchIntentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FulfillIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FulfillIntentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SentimentAnalysisResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*StreamingDetectIntentResponse_RecognitionResult)(nil),
		(*StreamingDetectIntentResponse_DetectIntentResponse)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*QueryInput_Text)(nil),
		(*QueryInput_Intent)(nil),
		(*QueryInput_Audio)(nil),
		(*QueryInput_Event)(nil),
		(*QueryInput_Dtmf)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*QueryResult_Text)(nil),
		(*QueryResult_TriggerIntent)(nil),
		(*QueryResult_Transcript)(nil),
		(*QueryResult_TriggerEvent)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*MatchIntentResponse_Text)(nil),
		(*MatchIntentResponse_TriggerIntent)(nil),
		(*MatchIntentResponse_Transcript)(nil),
		(*MatchIntentResponse_TriggerEvent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_session_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_session_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_session_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_session_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_session_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SessionsClient is the client API for Sessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SessionsClient interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause session
	// entity types to be updated, which in turn might affect results of future
	// queries.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error)
	// Returns preliminary intent match results, doesn't change the session
	// status.
	MatchIntent(ctx context.Context, in *MatchIntentRequest, opts ...grpc.CallOption) (*MatchIntentResponse, error)
	// Fulfills a matched intent returned by [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent].
	// Must be called after [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent], with input from
	// [MatchIntentResponse][google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse]. Otherwise, the behavior is undefined.
	FulfillIntent(ctx context.Context, in *FulfillIntentRequest, opts ...grpc.CallOption) (*FulfillIntentResponse, error)
}

type sessionsClient struct {
	cc grpc.ClientConnInterface
}

func NewSessionsClient(cc grpc.ClientConnInterface) SessionsClient {
	return &sessionsClient{cc}
}

func (c *sessionsClient) DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error) {
	out := new(DetectIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Sessions/DetectIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Sessions_serviceDesc.Streams[0], "/google.cloud.dialogflow.cx.v3beta1.Sessions/StreamingDetectIntent", opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsStreamingDetectIntentClient{stream}
	return x, nil
}

type Sessions_StreamingDetectIntentClient interface {
	Send(*StreamingDetectIntentRequest) error
	Recv() (*StreamingDetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsStreamingDetectIntentClient) Send(m *StreamingDetectIntentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentClient) Recv() (*StreamingDetectIntentResponse, error) {
	m := new(StreamingDetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *sessionsClient) MatchIntent(ctx context.Context, in *MatchIntentRequest, opts ...grpc.CallOption) (*MatchIntentResponse, error) {
	out := new(MatchIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Sessions/MatchIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) FulfillIntent(ctx context.Context, in *FulfillIntentRequest, opts ...grpc.CallOption) (*FulfillIntentResponse, error) {
	out := new(FulfillIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Sessions/FulfillIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SessionsServer is the server API for Sessions service.
type SessionsServer interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause session
	// entity types to be updated, which in turn might affect results of future
	// queries.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
	StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error
	// Returns preliminary intent match results, doesn't change the session
	// status.
	MatchIntent(context.Context, *MatchIntentRequest) (*MatchIntentResponse, error)
	// Fulfills a matched intent returned by [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent].
	// Must be called after [MatchIntent][google.cloud.dialogflow.cx.v3beta1.Sessions.MatchIntent], with input from
	// [MatchIntentResponse][google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse]. Otherwise, the behavior is undefined.
	FulfillIntent(context.Context, *FulfillIntentRequest) (*FulfillIntentResponse, error)
}

// UnimplementedSessionsServer can be embedded to have forward compatible implementations.
type UnimplementedSessionsServer struct {
}

func (*UnimplementedSessionsServer) DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DetectIntent not implemented")
}
func (*UnimplementedSessionsServer) StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamingDetectIntent not implemented")
}
func (*UnimplementedSessionsServer) MatchIntent(context.Context, *MatchIntentRequest) (*MatchIntentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MatchIntent not implemented")
}
func (*UnimplementedSessionsServer) FulfillIntent(context.Context, *FulfillIntentRequest) (*FulfillIntentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FulfillIntent not implemented")
}

func RegisterSessionsServer(s *grpc.Server, srv SessionsServer) {
	s.RegisterService(&_Sessions_serviceDesc, srv)
}

func _Sessions_DetectIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).DetectIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Sessions/DetectIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).DetectIntent(ctx, req.(*DetectIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_StreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SessionsServer).StreamingDetectIntent(&sessionsStreamingDetectIntentServer{stream})
}

type Sessions_StreamingDetectIntentServer interface {
	Send(*StreamingDetectIntentResponse) error
	Recv() (*StreamingDetectIntentRequest, error)
	grpc.ServerStream
}

type sessionsStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsStreamingDetectIntentServer) Send(m *StreamingDetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentServer) Recv() (*StreamingDetectIntentRequest, error) {
	m := new(StreamingDetectIntentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Sessions_MatchIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MatchIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).MatchIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Sessions/MatchIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).MatchIntent(ctx, req.(*MatchIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_FulfillIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FulfillIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).FulfillIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Sessions/FulfillIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).FulfillIntent(ctx, req.(*FulfillIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Sessions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Sessions",
	HandlerType: (*SessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectIntent",
			Handler:    _Sessions_DetectIntent_Handler,
		},
		{
			MethodName: "MatchIntent",
			Handler:    _Sessions_MatchIntent_Handler,
		},
		{
			MethodName: "FulfillIntent",
			Handler:    _Sessions_FulfillIntent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingDetectIntent",
			Handler:       _Sessions_StreamingDetectIntent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/session.proto",
}
