// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/iam/admin/v1/iam.proto

package admin

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Supported key algorithms.
type ServiceAccountKeyAlgorithm int32

const (
	// An unspecified key algorithm.
	ServiceAccountKeyAlgorithm_KEY_ALG_UNSPECIFIED ServiceAccountKeyAlgorithm = 0
	// 1k RSA Key.
	ServiceAccountKeyAlgorithm_KEY_ALG_RSA_1024 ServiceAccountKeyAlgorithm = 1
	// 2k RSA Key.
	ServiceAccountKeyAlgorithm_KEY_ALG_RSA_2048 ServiceAccountKeyAlgorithm = 2
)

// Enum value maps for ServiceAccountKeyAlgorithm.
var (
	ServiceAccountKeyAlgorithm_name = map[int32]string{
		0: "KEY_ALG_UNSPECIFIED",
		1: "KEY_ALG_RSA_1024",
		2: "KEY_ALG_RSA_2048",
	}
	ServiceAccountKeyAlgorithm_value = map[string]int32{
		"KEY_ALG_UNSPECIFIED": 0,
		"KEY_ALG_RSA_1024":    1,
		"KEY_ALG_RSA_2048":    2,
	}
)

func (x ServiceAccountKeyAlgorithm) Enum() *ServiceAccountKeyAlgorithm {
	p := new(ServiceAccountKeyAlgorithm)
	*p = x
	return p
}

func (x ServiceAccountKeyAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceAccountKeyAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_admin_v1_iam_proto_enumTypes[0].Descriptor()
}

func (ServiceAccountKeyAlgorithm) Type() protoreflect.EnumType {
	return &file_google_iam_admin_v1_iam_proto_enumTypes[0]
}

func (x ServiceAccountKeyAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceAccountKeyAlgorithm.Descriptor instead.
func (ServiceAccountKeyAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{0}
}

// Supported private key output formats.
type ServiceAccountPrivateKeyType int32

const (
	// Unspecified. Equivalent to `TYPE_GOOGLE_CREDENTIALS_FILE`.
	ServiceAccountPrivateKeyType_TYPE_UNSPECIFIED ServiceAccountPrivateKeyType = 0
	// PKCS12 format.
	// The password for the PKCS12 file is `notasecret`.
	// For more information, see https://tools.ietf.org/html/rfc7292.
	ServiceAccountPrivateKeyType_TYPE_PKCS12_FILE ServiceAccountPrivateKeyType = 1
	// Google Credentials File format.
	ServiceAccountPrivateKeyType_TYPE_GOOGLE_CREDENTIALS_FILE ServiceAccountPrivateKeyType = 2
)

// Enum value maps for ServiceAccountPrivateKeyType.
var (
	ServiceAccountPrivateKeyType_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TYPE_PKCS12_FILE",
		2: "TYPE_GOOGLE_CREDENTIALS_FILE",
	}
	ServiceAccountPrivateKeyType_value = map[string]int32{
		"TYPE_UNSPECIFIED":             0,
		"TYPE_PKCS12_FILE":             1,
		"TYPE_GOOGLE_CREDENTIALS_FILE": 2,
	}
)

func (x ServiceAccountPrivateKeyType) Enum() *ServiceAccountPrivateKeyType {
	p := new(ServiceAccountPrivateKeyType)
	*p = x
	return p
}

func (x ServiceAccountPrivateKeyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceAccountPrivateKeyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_admin_v1_iam_proto_enumTypes[1].Descriptor()
}

func (ServiceAccountPrivateKeyType) Type() protoreflect.EnumType {
	return &file_google_iam_admin_v1_iam_proto_enumTypes[1]
}

func (x ServiceAccountPrivateKeyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceAccountPrivateKeyType.Descriptor instead.
func (ServiceAccountPrivateKeyType) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{1}
}

// Supported public key output formats.
type ServiceAccountPublicKeyType int32

const (
	// Unspecified. Returns nothing here.
	ServiceAccountPublicKeyType_TYPE_NONE ServiceAccountPublicKeyType = 0
	// X509 PEM format.
	ServiceAccountPublicKeyType_TYPE_X509_PEM_FILE ServiceAccountPublicKeyType = 1
	// Raw public key.
	ServiceAccountPublicKeyType_TYPE_RAW_PUBLIC_KEY ServiceAccountPublicKeyType = 2
)

// Enum value maps for ServiceAccountPublicKeyType.
var (
	ServiceAccountPublicKeyType_name = map[int32]string{
		0: "TYPE_NONE",
		1: "TYPE_X509_PEM_FILE",
		2: "TYPE_RAW_PUBLIC_KEY",
	}
	ServiceAccountPublicKeyType_value = map[string]int32{
		"TYPE_NONE":           0,
		"TYPE_X509_PEM_FILE":  1,
		"TYPE_RAW_PUBLIC_KEY": 2,
	}
)

func (x ServiceAccountPublicKeyType) Enum() *ServiceAccountPublicKeyType {
	p := new(ServiceAccountPublicKeyType)
	*p = x
	return p
}

func (x ServiceAccountPublicKeyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceAccountPublicKeyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_admin_v1_iam_proto_enumTypes[2].Descriptor()
}

func (ServiceAccountPublicKeyType) Type() protoreflect.EnumType {
	return &file_google_iam_admin_v1_iam_proto_enumTypes[2]
}

func (x ServiceAccountPublicKeyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceAccountPublicKeyType.Descriptor instead.
func (ServiceAccountPublicKeyType) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{2}
}

// A view for Role objects.
type RoleView int32

const (
	// Omits the `included_permissions` field.
	// This is the default value.
	RoleView_BASIC RoleView = 0
	// Returns all fields.
	RoleView_FULL RoleView = 1
)

// Enum value maps for RoleView.
var (
	RoleView_name = map[int32]string{
		0: "BASIC",
		1: "FULL",
	}
	RoleView_value = map[string]int32{
		"BASIC": 0,
		"FULL":  1,
	}
)

func (x RoleView) Enum() *RoleView {
	p := new(RoleView)
	*p = x
	return p
}

func (x RoleView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RoleView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_admin_v1_iam_proto_enumTypes[3].Descriptor()
}

func (RoleView) Type() protoreflect.EnumType {
	return &file_google_iam_admin_v1_iam_proto_enumTypes[3]
}

func (x RoleView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RoleView.Descriptor instead.
func (RoleView) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{3}
}

// `KeyType` filters to selectively retrieve certain varieties
// of keys.
type ListServiceAccountKeysRequest_KeyType int32

const (
	// Unspecified key type. The presence of this in the
	// message will immediately result in an error.
	ListServiceAccountKeysRequest_KEY_TYPE_UNSPECIFIED ListServiceAccountKeysRequest_KeyType = 0
	// User-managed keys (managed and rotated by the user).
	ListServiceAccountKeysRequest_USER_MANAGED ListServiceAccountKeysRequest_KeyType = 1
	// System-managed keys (managed and rotated by Google).
	ListServiceAccountKeysRequest_SYSTEM_MANAGED ListServiceAccountKeysRequest_KeyType = 2
)

// Enum value maps for ListServiceAccountKeysRequest_KeyType.
var (
	ListServiceAccountKeysRequest_KeyType_name = map[int32]string{
		0: "KEY_TYPE_UNSPECIFIED",
		1: "USER_MANAGED",
		2: "SYSTEM_MANAGED",
	}
	ListServiceAccountKeysRequest_KeyType_value = map[string]int32{
		"KEY_TYPE_UNSPECIFIED": 0,
		"USER_MANAGED":         1,
		"SYSTEM_MANAGED":       2,
	}
)

func (x ListServiceAccountKeysRequest_KeyType) Enum() *ListServiceAccountKeysRequest_KeyType {
	p := new(ListServiceAccountKeysRequest_KeyType)
	*p = x
	return p
}

func (x ListServiceAccountKeysRequest_KeyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListServiceAccountKeysRequest_KeyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_admin_v1_iam_proto_enumTypes[4].Descriptor()
}

func (ListServiceAccountKeysRequest_KeyType) Type() protoreflect.EnumType {
	return &file_google_iam_admin_v1_iam_proto_enumTypes[4]
}

func (x ListServiceAccountKeysRequest_KeyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListServiceAccountKeysRequest_KeyType.Descriptor instead.
func (ListServiceAccountKeysRequest_KeyType) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{6, 0}
}

// A stage representing a role's lifecycle phase.
type Role_RoleLaunchStage int32

const (
	// The user has indicated this role is currently in an Alpha phase. If this
	// launch stage is selected, the `stage` field will not be included when
	// requesting the definition for a given role.
	Role_ALPHA Role_RoleLaunchStage = 0
	// The user has indicated this role is currently in a Beta phase.
	Role_BETA Role_RoleLaunchStage = 1
	// The user has indicated this role is generally available.
	Role_GA Role_RoleLaunchStage = 2
	// The user has indicated this role is being deprecated.
	Role_DEPRECATED Role_RoleLaunchStage = 4
	// This role is disabled and will not contribute permissions to any members
	// it is granted to in policies.
	Role_DISABLED Role_RoleLaunchStage = 5
	// The user has indicated this role is currently in an EAP phase.
	Role_EAP Role_RoleLaunchStage = 6
)

// Enum value maps for Role_RoleLaunchStage.
var (
	Role_RoleLaunchStage_name = map[int32]string{
		0: "ALPHA",
		1: "BETA",
		2: "GA",
		4: "DEPRECATED",
		5: "DISABLED",
		6: "EAP",
	}
	Role_RoleLaunchStage_value = map[string]int32{
		"ALPHA":      0,
		"BETA":       1,
		"GA":         2,
		"DEPRECATED": 4,
		"DISABLED":   5,
		"EAP":        6,
	}
)

func (x Role_RoleLaunchStage) Enum() *Role_RoleLaunchStage {
	p := new(Role_RoleLaunchStage)
	*p = x
	return p
}

func (x Role_RoleLaunchStage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Role_RoleLaunchStage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_admin_v1_iam_proto_enumTypes[5].Descriptor()
}

func (Role_RoleLaunchStage) Type() protoreflect.EnumType {
	return &file_google_iam_admin_v1_iam_proto_enumTypes[5]
}

func (x Role_RoleLaunchStage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Role_RoleLaunchStage.Descriptor instead.
func (Role_RoleLaunchStage) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{16, 0}
}

// A stage representing a permission's lifecycle phase.
type Permission_PermissionLaunchStage int32

const (
	// The permission is currently in an alpha phase.
	Permission_ALPHA Permission_PermissionLaunchStage = 0
	// The permission is currently in a beta phase.
	Permission_BETA Permission_PermissionLaunchStage = 1
	// The permission is generally available.
	Permission_GA Permission_PermissionLaunchStage = 2
	// The permission is being deprecated.
	Permission_DEPRECATED Permission_PermissionLaunchStage = 3
)

// Enum value maps for Permission_PermissionLaunchStage.
var (
	Permission_PermissionLaunchStage_name = map[int32]string{
		0: "ALPHA",
		1: "BETA",
		2: "GA",
		3: "DEPRECATED",
	}
	Permission_PermissionLaunchStage_value = map[string]int32{
		"ALPHA":      0,
		"BETA":       1,
		"GA":         2,
		"DEPRECATED": 3,
	}
)

func (x Permission_PermissionLaunchStage) Enum() *Permission_PermissionLaunchStage {
	p := new(Permission_PermissionLaunchStage)
	*p = x
	return p
}

func (x Permission_PermissionLaunchStage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Permission_PermissionLaunchStage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_admin_v1_iam_proto_enumTypes[6].Descriptor()
}

func (Permission_PermissionLaunchStage) Type() protoreflect.EnumType {
	return &file_google_iam_admin_v1_iam_proto_enumTypes[6]
}

func (x Permission_PermissionLaunchStage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Permission_PermissionLaunchStage.Descriptor instead.
func (Permission_PermissionLaunchStage) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{26, 0}
}

// The state of the permission with regards to custom roles.
type Permission_CustomRolesSupportLevel int32

const (
	// Permission is fully supported for custom role use.
	Permission_SUPPORTED Permission_CustomRolesSupportLevel = 0
	// Permission is being tested to check custom role compatibility.
	Permission_TESTING Permission_CustomRolesSupportLevel = 1
	// Permission is not supported for custom role use.
	Permission_NOT_SUPPORTED Permission_CustomRolesSupportLevel = 2
)

// Enum value maps for Permission_CustomRolesSupportLevel.
var (
	Permission_CustomRolesSupportLevel_name = map[int32]string{
		0: "SUPPORTED",
		1: "TESTING",
		2: "NOT_SUPPORTED",
	}
	Permission_CustomRolesSupportLevel_value = map[string]int32{
		"SUPPORTED":     0,
		"TESTING":       1,
		"NOT_SUPPORTED": 2,
	}
)

func (x Permission_CustomRolesSupportLevel) Enum() *Permission_CustomRolesSupportLevel {
	p := new(Permission_CustomRolesSupportLevel)
	*p = x
	return p
}

func (x Permission_CustomRolesSupportLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Permission_CustomRolesSupportLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_admin_v1_iam_proto_enumTypes[7].Descriptor()
}

func (Permission_CustomRolesSupportLevel) Type() protoreflect.EnumType {
	return &file_google_iam_admin_v1_iam_proto_enumTypes[7]
}

func (x Permission_CustomRolesSupportLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Permission_CustomRolesSupportLevel.Descriptor instead.
func (Permission_CustomRolesSupportLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{26, 1}
}

// A service account in the Identity and Access Management API.
//
// To create a service account, specify the `project_id` and the `account_id`
// for the account.  The `account_id` is unique within the project, and is used
// to generate the service account email address and a stable
// `unique_id`.
//
// If the account already exists, the account's resource name is returned
// in the format of projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}. The caller
// can use the name in other methods to access the account.
//
// All other methods can identify the service account using the format
// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
// the account. The `ACCOUNT` value can be the `email` address or the
// `unique_id` of the service account.
type ServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	//
	// Requests using `-` as a wildcard for the `PROJECT_ID` will infer the
	// project from the `account` and the `ACCOUNT` value can be the `email`
	// address or the `unique_id` of the service account.
	//
	// In responses the resource name will always be in the format
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// @OutputOnly The id of the project that owns the service account.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// @OutputOnly The unique and stable id of the service account.
	UniqueId string `protobuf:"bytes,4,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
	// @OutputOnly The email address of the service account.
	Email string `protobuf:"bytes,5,opt,name=email,proto3" json:"email,omitempty"`
	// Optional. A user-specified name for the service account.
	// Must be less than or equal to 100 UTF-8 bytes.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Note: `etag` is an inoperable legacy field that is only returned
	// for backwards compatibility.
	Etag []byte `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	// @OutputOnly. The OAuth2 client id for the service account.
	// This is used in conjunction with the OAuth2 clientconfig API to make
	// three legged OAuth2 (3LO) flows to access the data of Google users.
	Oauth2ClientId string `protobuf:"bytes,9,opt,name=oauth2_client_id,json=oauth2ClientId,proto3" json:"oauth2_client_id,omitempty"`
}

func (x *ServiceAccount) Reset() {
	*x = ServiceAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccount) ProtoMessage() {}

func (x *ServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccount.ProtoReflect.Descriptor instead.
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{0}
}

func (x *ServiceAccount) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceAccount) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ServiceAccount) GetUniqueId() string {
	if x != nil {
		return x.UniqueId
	}
	return ""
}

func (x *ServiceAccount) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ServiceAccount) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ServiceAccount) GetEtag() []byte {
	if x != nil {
		return x.Etag
	}
	return nil
}

func (x *ServiceAccount) GetOauth2ClientId() string {
	if x != nil {
		return x.Oauth2ClientId
	}
	return ""
}

// The service account create request.
type CreateServiceAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the project associated with the service
	// accounts, such as `projects/my-project-123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The account id that is used to generate the service account
	// email address and a stable unique id. It is unique within a project,
	// must be 6-30 characters long, and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])` to comply with RFC1035.
	AccountId string `protobuf:"bytes,2,opt,name=account_id,json=accountId,proto3" json:"account_id,omitempty"`
	// The [ServiceAccount][google.iam.admin.v1.ServiceAccount] resource to
	// create. Currently, only the following values are user assignable:
	// `display_name` and `description`.
	ServiceAccount *ServiceAccount `protobuf:"bytes,3,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *CreateServiceAccountRequest) Reset() {
	*x = CreateServiceAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateServiceAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateServiceAccountRequest) ProtoMessage() {}

func (x *CreateServiceAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateServiceAccountRequest.ProtoReflect.Descriptor instead.
func (*CreateServiceAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{1}
}

func (x *CreateServiceAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateServiceAccountRequest) GetAccountId() string {
	if x != nil {
		return x.AccountId
	}
	return ""
}

func (x *CreateServiceAccountRequest) GetServiceAccount() *ServiceAccount {
	if x != nil {
		return x.ServiceAccount
	}
	return nil
}

// The service account list request.
type ListServiceAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the project associated with the service
	// accounts, such as `projects/my-project-123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional limit on the number of service accounts to include in the
	// response. Further accounts can subsequently be obtained by including the
	// [ListServiceAccountsResponse.next_page_token][google.iam.admin.v1.ListServiceAccountsResponse.next_page_token]
	// in a subsequent request.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token returned in an earlier
	// [ListServiceAccountsResponse.next_page_token][google.iam.admin.v1.ListServiceAccountsResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListServiceAccountsRequest) Reset() {
	*x = ListServiceAccountsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServiceAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceAccountsRequest) ProtoMessage() {}

func (x *ListServiceAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceAccountsRequest.ProtoReflect.Descriptor instead.
func (*ListServiceAccountsRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{2}
}

func (x *ListServiceAccountsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListServiceAccountsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServiceAccountsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The service account list response.
type ListServiceAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching service accounts.
	Accounts []*ServiceAccount `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
	// To retrieve the next page of results, set
	// [ListServiceAccountsRequest.page_token][google.iam.admin.v1.ListServiceAccountsRequest.page_token]
	// to this value.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListServiceAccountsResponse) Reset() {
	*x = ListServiceAccountsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServiceAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceAccountsResponse) ProtoMessage() {}

func (x *ListServiceAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceAccountsResponse.ProtoReflect.Descriptor instead.
func (*ListServiceAccountsResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{3}
}

func (x *ListServiceAccountsResponse) GetAccounts() []*ServiceAccount {
	if x != nil {
		return x.Accounts
	}
	return nil
}

func (x *ListServiceAccountsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The service account get request.
type GetServiceAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServiceAccountRequest) Reset() {
	*x = GetServiceAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServiceAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceAccountRequest) ProtoMessage() {}

func (x *GetServiceAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceAccountRequest.ProtoReflect.Descriptor instead.
func (*GetServiceAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{4}
}

func (x *GetServiceAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The service account delete request.
type DeleteServiceAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteServiceAccountRequest) Reset() {
	*x = DeleteServiceAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteServiceAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteServiceAccountRequest) ProtoMessage() {}

func (x *DeleteServiceAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteServiceAccountRequest.ProtoReflect.Descriptor instead.
func (*DeleteServiceAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteServiceAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The service account keys list request.
type ListServiceAccountKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	//
	// Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filters the types of keys the user wants to include in the list
	// response. Duplicate key types are not allowed. If no key type
	// is provided, all keys are returned.
	KeyTypes []ListServiceAccountKeysRequest_KeyType `protobuf:"varint,2,rep,packed,name=key_types,json=keyTypes,proto3,enum=google.iam.admin.v1.ListServiceAccountKeysRequest_KeyType" json:"key_types,omitempty"`
}

func (x *ListServiceAccountKeysRequest) Reset() {
	*x = ListServiceAccountKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServiceAccountKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceAccountKeysRequest) ProtoMessage() {}

func (x *ListServiceAccountKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceAccountKeysRequest.ProtoReflect.Descriptor instead.
func (*ListServiceAccountKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{6}
}

func (x *ListServiceAccountKeysRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListServiceAccountKeysRequest) GetKeyTypes() []ListServiceAccountKeysRequest_KeyType {
	if x != nil {
		return x.KeyTypes
	}
	return nil
}

// The service account keys list response.
type ListServiceAccountKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The public keys for the service account.
	Keys []*ServiceAccountKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *ListServiceAccountKeysResponse) Reset() {
	*x = ListServiceAccountKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServiceAccountKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServiceAccountKeysResponse) ProtoMessage() {}

func (x *ListServiceAccountKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServiceAccountKeysResponse.ProtoReflect.Descriptor instead.
func (*ListServiceAccountKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{7}
}

func (x *ListServiceAccountKeysResponse) GetKeys() []*ServiceAccountKey {
	if x != nil {
		return x.Keys
	}
	return nil
}

// The service account key get by id request.
type GetServiceAccountKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the service account key in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
	//
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The output format of the public key requested.
	// X509_PEM is the default output format.
	PublicKeyType ServiceAccountPublicKeyType `protobuf:"varint,2,opt,name=public_key_type,json=publicKeyType,proto3,enum=google.iam.admin.v1.ServiceAccountPublicKeyType" json:"public_key_type,omitempty"`
}

func (x *GetServiceAccountKeyRequest) Reset() {
	*x = GetServiceAccountKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServiceAccountKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServiceAccountKeyRequest) ProtoMessage() {}

func (x *GetServiceAccountKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServiceAccountKeyRequest.ProtoReflect.Descriptor instead.
func (*GetServiceAccountKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{8}
}

func (x *GetServiceAccountKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetServiceAccountKeyRequest) GetPublicKeyType() ServiceAccountPublicKeyType {
	if x != nil {
		return x.PublicKeyType
	}
	return ServiceAccountPublicKeyType_TYPE_NONE
}

// Represents a service account key.
//
// A service account has two sets of key-pairs: user-managed, and
// system-managed.
//
// User-managed key-pairs can be created and deleted by users.  Users are
// responsible for rotating these keys periodically to ensure security of
// their service accounts.  Users retain the private key of these key-pairs,
// and Google retains ONLY the public key.
//
// System-managed keys are automatically rotated by Google, and are used for
// signing for a maximum of two weeks. The rotation process is probabilistic,
// and usage of the new key will gradually ramp up and down over the key's
// lifetime. We recommend caching the public key set for a service account for
// no more than 24 hours to ensure you have access to the latest keys.
//
// Public keys for all service accounts are also published at the OAuth2
// Service Account API.
type ServiceAccountKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the service account key in the following format
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The output format for the private key.
	// Only provided in `CreateServiceAccountKey` responses, not
	// in `GetServiceAccountKey` or `ListServiceAccountKey` responses.
	//
	// Google never exposes system-managed private keys, and never retains
	// user-managed private keys.
	PrivateKeyType ServiceAccountPrivateKeyType `protobuf:"varint,2,opt,name=private_key_type,json=privateKeyType,proto3,enum=google.iam.admin.v1.ServiceAccountPrivateKeyType" json:"private_key_type,omitempty"`
	// Specifies the algorithm (and possibly key size) for the key.
	KeyAlgorithm ServiceAccountKeyAlgorithm `protobuf:"varint,8,opt,name=key_algorithm,json=keyAlgorithm,proto3,enum=google.iam.admin.v1.ServiceAccountKeyAlgorithm" json:"key_algorithm,omitempty"`
	// The private key data. Only provided in `CreateServiceAccountKey`
	// responses. Make sure to keep the private key data secure because it
	// allows for the assertion of the service account identity.
	// When base64 decoded, the private key data can be used to authenticate with
	// Google API client libraries and with
	// <a href="/sdk/gcloud/reference/auth/activate-service-account">gcloud
	// auth activate-service-account</a>.
	PrivateKeyData []byte `protobuf:"bytes,3,opt,name=private_key_data,json=privateKeyData,proto3" json:"private_key_data,omitempty"`
	// The public key data. Only provided in `GetServiceAccountKey` responses.
	PublicKeyData []byte `protobuf:"bytes,7,opt,name=public_key_data,json=publicKeyData,proto3" json:"public_key_data,omitempty"`
	// The key can be used after this timestamp.
	ValidAfterTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=valid_after_time,json=validAfterTime,proto3" json:"valid_after_time,omitempty"`
	// The key can be used before this timestamp.
	// For system-managed key pairs, this timestamp is the end time for the
	// private key signing operation. The public key could still be used
	// for verification for a few hours after this time.
	ValidBeforeTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=valid_before_time,json=validBeforeTime,proto3" json:"valid_before_time,omitempty"`
}

func (x *ServiceAccountKey) Reset() {
	*x = ServiceAccountKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccountKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccountKey) ProtoMessage() {}

func (x *ServiceAccountKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccountKey.ProtoReflect.Descriptor instead.
func (*ServiceAccountKey) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{9}
}

func (x *ServiceAccountKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceAccountKey) GetPrivateKeyType() ServiceAccountPrivateKeyType {
	if x != nil {
		return x.PrivateKeyType
	}
	return ServiceAccountPrivateKeyType_TYPE_UNSPECIFIED
}

func (x *ServiceAccountKey) GetKeyAlgorithm() ServiceAccountKeyAlgorithm {
	if x != nil {
		return x.KeyAlgorithm
	}
	return ServiceAccountKeyAlgorithm_KEY_ALG_UNSPECIFIED
}

func (x *ServiceAccountKey) GetPrivateKeyData() []byte {
	if x != nil {
		return x.PrivateKeyData
	}
	return nil
}

func (x *ServiceAccountKey) GetPublicKeyData() []byte {
	if x != nil {
		return x.PublicKeyData
	}
	return nil
}

func (x *ServiceAccountKey) GetValidAfterTime() *timestamp.Timestamp {
	if x != nil {
		return x.ValidAfterTime
	}
	return nil
}

func (x *ServiceAccountKey) GetValidBeforeTime() *timestamp.Timestamp {
	if x != nil {
		return x.ValidBeforeTime
	}
	return nil
}

// The service account key create request.
type CreateServiceAccountKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The output format of the private key. The default value is
	// `TYPE_GOOGLE_CREDENTIALS_FILE`, which is the Google Credentials File
	// format.
	PrivateKeyType ServiceAccountPrivateKeyType `protobuf:"varint,2,opt,name=private_key_type,json=privateKeyType,proto3,enum=google.iam.admin.v1.ServiceAccountPrivateKeyType" json:"private_key_type,omitempty"`
	// Which type of key and algorithm to use for the key.
	// The default is currently a 2K RSA key.  However this may change in the
	// future.
	KeyAlgorithm ServiceAccountKeyAlgorithm `protobuf:"varint,3,opt,name=key_algorithm,json=keyAlgorithm,proto3,enum=google.iam.admin.v1.ServiceAccountKeyAlgorithm" json:"key_algorithm,omitempty"`
}

func (x *CreateServiceAccountKeyRequest) Reset() {
	*x = CreateServiceAccountKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateServiceAccountKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateServiceAccountKeyRequest) ProtoMessage() {}

func (x *CreateServiceAccountKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateServiceAccountKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateServiceAccountKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{10}
}

func (x *CreateServiceAccountKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateServiceAccountKeyRequest) GetPrivateKeyType() ServiceAccountPrivateKeyType {
	if x != nil {
		return x.PrivateKeyType
	}
	return ServiceAccountPrivateKeyType_TYPE_UNSPECIFIED
}

func (x *CreateServiceAccountKeyRequest) GetKeyAlgorithm() ServiceAccountKeyAlgorithm {
	if x != nil {
		return x.KeyAlgorithm
	}
	return ServiceAccountKeyAlgorithm_KEY_ALG_UNSPECIFIED
}

// The service account key delete request.
type DeleteServiceAccountKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the service account key in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteServiceAccountKeyRequest) Reset() {
	*x = DeleteServiceAccountKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteServiceAccountKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteServiceAccountKeyRequest) ProtoMessage() {}

func (x *DeleteServiceAccountKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteServiceAccountKeyRequest.ProtoReflect.Descriptor instead.
func (*DeleteServiceAccountKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteServiceAccountKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The service account sign blob request.
type SignBlobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The bytes to sign.
	BytesToSign []byte `protobuf:"bytes,2,opt,name=bytes_to_sign,json=bytesToSign,proto3" json:"bytes_to_sign,omitempty"`
}

func (x *SignBlobRequest) Reset() {
	*x = SignBlobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignBlobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignBlobRequest) ProtoMessage() {}

func (x *SignBlobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignBlobRequest.ProtoReflect.Descriptor instead.
func (*SignBlobRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{12}
}

func (x *SignBlobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SignBlobRequest) GetBytesToSign() []byte {
	if x != nil {
		return x.BytesToSign
	}
	return nil
}

// The service account sign blob response.
type SignBlobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the key used to sign the blob.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// The signed blob.
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *SignBlobResponse) Reset() {
	*x = SignBlobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignBlobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignBlobResponse) ProtoMessage() {}

func (x *SignBlobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignBlobResponse.ProtoReflect.Descriptor instead.
func (*SignBlobResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{13}
}

func (x *SignBlobResponse) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

func (x *SignBlobResponse) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

// The service account sign JWT request.
type SignJwtRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The JWT payload to sign, a JSON JWT Claim set.
	Payload string `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *SignJwtRequest) Reset() {
	*x = SignJwtRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignJwtRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignJwtRequest) ProtoMessage() {}

func (x *SignJwtRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignJwtRequest.ProtoReflect.Descriptor instead.
func (*SignJwtRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{14}
}

func (x *SignJwtRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SignJwtRequest) GetPayload() string {
	if x != nil {
		return x.Payload
	}
	return ""
}

// The service account sign JWT response.
type SignJwtResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the key used to sign the JWT.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// The signed JWT.
	SignedJwt string `protobuf:"bytes,2,opt,name=signed_jwt,json=signedJwt,proto3" json:"signed_jwt,omitempty"`
}

func (x *SignJwtResponse) Reset() {
	*x = SignJwtResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignJwtResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignJwtResponse) ProtoMessage() {}

func (x *SignJwtResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignJwtResponse.ProtoReflect.Descriptor instead.
func (*SignJwtResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{15}
}

func (x *SignJwtResponse) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

func (x *SignJwtResponse) GetSignedJwt() string {
	if x != nil {
		return x.SignedJwt
	}
	return ""
}

// A role in the Identity and Access Management API.
type Role struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the role.
	//
	// When Role is used in CreateRole, the role name must not be set.
	//
	// When Role is used in output and other input such as UpdateRole, the role
	// name is the complete path, e.g., roles/logging.viewer for predefined roles
	// and organizations/{ORGANIZATION_ID}/roles/logging.viewer for custom roles.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A human-readable title for the role.  Typically this
	// is limited to 100 UTF-8 bytes.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. A human-readable description for the role.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The names of the permissions this role grants when bound in an IAM policy.
	IncludedPermissions []string `protobuf:"bytes,7,rep,name=included_permissions,json=includedPermissions,proto3" json:"included_permissions,omitempty"`
	// The current launch stage of the role. If the `ALPHA` launch stage has been
	// selected for a role, the `stage` field will not be included in the
	// returned definition for the role.
	Stage Role_RoleLaunchStage `protobuf:"varint,8,opt,name=stage,proto3,enum=google.iam.admin.v1.Role_RoleLaunchStage" json:"stage,omitempty"`
	// Used to perform a consistent read-modify-write.
	Etag []byte `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// The current deleted state of the role. This field is read only.
	// It will be ignored in calls to CreateRole and UpdateRole.
	Deleted bool `protobuf:"varint,11,opt,name=deleted,proto3" json:"deleted,omitempty"`
}

func (x *Role) Reset() {
	*x = Role{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Role) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Role) ProtoMessage() {}

func (x *Role) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Role.ProtoReflect.Descriptor instead.
func (*Role) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{16}
}

func (x *Role) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Role) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Role) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Role) GetIncludedPermissions() []string {
	if x != nil {
		return x.IncludedPermissions
	}
	return nil
}

func (x *Role) GetStage() Role_RoleLaunchStage {
	if x != nil {
		return x.Stage
	}
	return Role_ALPHA
}

func (x *Role) GetEtag() []byte {
	if x != nil {
		return x.Etag
	}
	return nil
}

func (x *Role) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

// The grantable role query request.
type QueryGrantableRolesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name to query from the list of grantable roles.
	//
	// The name follows the Google Cloud Platform resource format.
	// For example, a Cloud Platform project with id `my-project` will be named
	// `//cloudresourcemanager.googleapis.com/projects/my-project`.
	FullResourceName string   `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	View             RoleView `protobuf:"varint,2,opt,name=view,proto3,enum=google.iam.admin.v1.RoleView" json:"view,omitempty"`
	// Optional limit on the number of roles to include in the response.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token returned in an earlier
	// QueryGrantableRolesResponse.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *QueryGrantableRolesRequest) Reset() {
	*x = QueryGrantableRolesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryGrantableRolesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryGrantableRolesRequest) ProtoMessage() {}

func (x *QueryGrantableRolesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryGrantableRolesRequest.ProtoReflect.Descriptor instead.
func (*QueryGrantableRolesRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{17}
}

func (x *QueryGrantableRolesRequest) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *QueryGrantableRolesRequest) GetView() RoleView {
	if x != nil {
		return x.View
	}
	return RoleView_BASIC
}

func (x *QueryGrantableRolesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *QueryGrantableRolesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The grantable role query response.
type QueryGrantableRolesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching roles.
	Roles []*Role `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	// To retrieve the next page of results, set
	// `QueryGrantableRolesRequest.page_token` to this value.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *QueryGrantableRolesResponse) Reset() {
	*x = QueryGrantableRolesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryGrantableRolesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryGrantableRolesResponse) ProtoMessage() {}

func (x *QueryGrantableRolesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryGrantableRolesResponse.ProtoReflect.Descriptor instead.
func (*QueryGrantableRolesResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{18}
}

func (x *QueryGrantableRolesResponse) GetRoles() []*Role {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *QueryGrantableRolesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get all roles defined under a resource.
type ListRolesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `parent` parameter's value depends on the target resource for the
	// request, namely
	// [`roles`](/iam/reference/rest/v1/roles),
	// [`projects`](/iam/reference/rest/v1/projects.roles), or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `parent` value format is described below:
	//
	// * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string.
	//   This method doesn't require a resource; it simply returns all
	//   [predefined roles](/iam/docs/understanding-roles#predefined_roles) in
	//   Cloud IAM. Example request URL:
	//   `https://iam.googleapis.com/v1/roles`
	//
	// * [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
	//   `projects/{PROJECT_ID}`. This method lists all project-level
	//   [custom roles](/iam/docs/understanding-custom-roles).
	//   Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles`
	//
	// * [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
	//   `organizations/{ORGANIZATION_ID}`. This method lists all
	//   organization-level [custom roles](/iam/docs/understanding-custom-roles).
	//   Example request URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of roles to include in the response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token returned in an earlier ListRolesResponse.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional view for the returned Role objects. When `FULL` is specified,
	// the `includedPermissions` field is returned, which includes a list of all
	// permissions in the role. The default value is `BASIC`, which does not
	// return the `includedPermissions` field.
	View RoleView `protobuf:"varint,4,opt,name=view,proto3,enum=google.iam.admin.v1.RoleView" json:"view,omitempty"`
	// Include Roles that have been deleted.
	ShowDeleted bool `protobuf:"varint,6,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListRolesRequest) Reset() {
	*x = ListRolesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRolesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRolesRequest) ProtoMessage() {}

func (x *ListRolesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRolesRequest.ProtoReflect.Descriptor instead.
func (*ListRolesRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{19}
}

func (x *ListRolesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRolesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRolesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRolesRequest) GetView() RoleView {
	if x != nil {
		return x.View
	}
	return RoleView_BASIC
}

func (x *ListRolesRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// The response containing the roles defined under a resource.
type ListRolesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Roles defined on this resource.
	Roles []*Role `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	// To retrieve the next page of results, set
	// `ListRolesRequest.page_token` to this value.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRolesResponse) Reset() {
	*x = ListRolesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRolesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRolesResponse) ProtoMessage() {}

func (x *ListRolesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRolesResponse.ProtoReflect.Descriptor instead.
func (*ListRolesResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{20}
}

func (x *ListRolesResponse) GetRoles() []*Role {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *ListRolesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get the definition of an existing role.
type GetRoleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `name` parameter's value depends on the target resource for the
	// request, namely
	// [`roles`](/iam/reference/rest/v1/roles),
	// [`projects`](/iam/reference/rest/v1/projects.roles), or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `name` value format is described below:
	//
	// * [`roles.get()`](/iam/reference/rest/v1/roles/get): `roles/{ROLE_NAME}`.
	//   This method returns results from all
	//   [predefined roles](/iam/docs/understanding-roles#predefined_roles) in
	//   Cloud IAM. Example request URL:
	//   `https://iam.googleapis.com/v1/roles/{ROLE_NAME}`
	//
	// * [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
	//   `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only
	//   [custom roles](/iam/docs/understanding-custom-roles) that have been
	//   created at the project level. Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// * [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
	//   `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method
	//   returns only [custom roles](/iam/docs/understanding-custom-roles) that
	//   have been created at the organization level. Example request URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRoleRequest) Reset() {
	*x = GetRoleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRoleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRoleRequest) ProtoMessage() {}

func (x *GetRoleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRoleRequest.ProtoReflect.Descriptor instead.
func (*GetRoleRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{21}
}

func (x *GetRoleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to create a new role.
type CreateRoleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `parent` parameter's value depends on the target resource for the
	// request, namely
	// [`projects`](/iam/reference/rest/v1/projects.roles) or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `parent` value format is described below:
	//
	// * [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create):
	//   `projects/{PROJECT_ID}`. This method creates project-level
	//   [custom roles](/iam/docs/understanding-custom-roles).
	//   Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles`
	//
	// * [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
	//   `organizations/{ORGANIZATION_ID}`. This method creates organization-level
	//   [custom roles](/iam/docs/understanding-custom-roles). Example request
	//   URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The role ID to use for this role.
	RoleId string `protobuf:"bytes,2,opt,name=role_id,json=roleId,proto3" json:"role_id,omitempty"`
	// The Role resource to create.
	Role *Role `protobuf:"bytes,3,opt,name=role,proto3" json:"role,omitempty"`
}

func (x *CreateRoleRequest) Reset() {
	*x = CreateRoleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRoleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRoleRequest) ProtoMessage() {}

func (x *CreateRoleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRoleRequest.ProtoReflect.Descriptor instead.
func (*CreateRoleRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{22}
}

func (x *CreateRoleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRoleRequest) GetRoleId() string {
	if x != nil {
		return x.RoleId
	}
	return ""
}

func (x *CreateRoleRequest) GetRole() *Role {
	if x != nil {
		return x.Role
	}
	return nil
}

// The request to update a role.
type UpdateRoleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `name` parameter's value depends on the target resource for the
	// request, namely
	// [`projects`](/iam/reference/rest/v1/projects.roles) or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `name` value format is described below:
	//
	// * [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
	//   `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only
	//   [custom roles](/iam/docs/understanding-custom-roles) that have been
	//   created at the project level. Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// * [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
	//   `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method
	//   updates only [custom roles](/iam/docs/understanding-custom-roles) that
	//   have been created at the organization level. Example request URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The updated role.
	Role *Role `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	// A mask describing which fields in the Role have changed.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateRoleRequest) Reset() {
	*x = UpdateRoleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRoleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRoleRequest) ProtoMessage() {}

func (x *UpdateRoleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRoleRequest.ProtoReflect.Descriptor instead.
func (*UpdateRoleRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{23}
}

func (x *UpdateRoleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateRoleRequest) GetRole() *Role {
	if x != nil {
		return x.Role
	}
	return nil
}

func (x *UpdateRoleRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to delete an existing role.
type DeleteRoleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `name` parameter's value depends on the target resource for the
	// request, namely
	// [`projects`](/iam/reference/rest/v1/projects.roles) or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `name` value format is described below:
	//
	// * [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
	//   `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only
	//   [custom roles](/iam/docs/understanding-custom-roles) that have been
	//   created at the project level. Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// * [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
	//   `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method
	//   deletes only [custom roles](/iam/docs/understanding-custom-roles) that
	//   have been created at the organization level. Example request URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Used to perform a consistent read-modify-write.
	Etag []byte `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteRoleRequest) Reset() {
	*x = DeleteRoleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRoleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRoleRequest) ProtoMessage() {}

func (x *DeleteRoleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRoleRequest.ProtoReflect.Descriptor instead.
func (*DeleteRoleRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{24}
}

func (x *DeleteRoleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRoleRequest) GetEtag() []byte {
	if x != nil {
		return x.Etag
	}
	return nil
}

// The request to undelete an existing role.
type UndeleteRoleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `name` parameter's value depends on the target resource for the
	// request, namely
	// [`projects`](/iam/reference/rest/v1/projects.roles) or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `name` value format is described below:
	//
	// * [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
	//   `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes
	//   only [custom roles](/iam/docs/understanding-custom-roles) that have been
	//   created at the project level. Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// * [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
	//   `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method
	//   undeletes only [custom roles](/iam/docs/understanding-custom-roles) that
	//   have been created at the organization level. Example request URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Used to perform a consistent read-modify-write.
	Etag []byte `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *UndeleteRoleRequest) Reset() {
	*x = UndeleteRoleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeleteRoleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeleteRoleRequest) ProtoMessage() {}

func (x *UndeleteRoleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeleteRoleRequest.ProtoReflect.Descriptor instead.
func (*UndeleteRoleRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{25}
}

func (x *UndeleteRoleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UndeleteRoleRequest) GetEtag() []byte {
	if x != nil {
		return x.Etag
	}
	return nil
}

// A permission which can be included by a role.
type Permission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this Permission.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The title of this Permission.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// A brief description of what this Permission is used for.
	// This permission can ONLY be used in predefined roles.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// This permission can ONLY be used in predefined roles.
	OnlyInPredefinedRoles bool `protobuf:"varint,4,opt,name=only_in_predefined_roles,json=onlyInPredefinedRoles,proto3" json:"only_in_predefined_roles,omitempty"`
	// The current launch stage of the permission.
	Stage Permission_PermissionLaunchStage `protobuf:"varint,5,opt,name=stage,proto3,enum=google.iam.admin.v1.Permission_PermissionLaunchStage" json:"stage,omitempty"`
	// The current custom role support level.
	CustomRolesSupportLevel Permission_CustomRolesSupportLevel `protobuf:"varint,6,opt,name=custom_roles_support_level,json=customRolesSupportLevel,proto3,enum=google.iam.admin.v1.Permission_CustomRolesSupportLevel" json:"custom_roles_support_level,omitempty"`
}

func (x *Permission) Reset() {
	*x = Permission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Permission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Permission) ProtoMessage() {}

func (x *Permission) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Permission.ProtoReflect.Descriptor instead.
func (*Permission) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{26}
}

func (x *Permission) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Permission) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Permission) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Permission) GetOnlyInPredefinedRoles() bool {
	if x != nil {
		return x.OnlyInPredefinedRoles
	}
	return false
}

func (x *Permission) GetStage() Permission_PermissionLaunchStage {
	if x != nil {
		return x.Stage
	}
	return Permission_ALPHA
}

func (x *Permission) GetCustomRolesSupportLevel() Permission_CustomRolesSupportLevel {
	if x != nil {
		return x.CustomRolesSupportLevel
	}
	return Permission_SUPPORTED
}

// A request to get permissions which can be tested on a resource.
type QueryTestablePermissionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name to query from the list of testable
	// permissions.
	//
	// The name follows the Google Cloud Platform resource format.
	// For example, a Cloud Platform project with id `my-project` will be named
	// `//cloudresourcemanager.googleapis.com/projects/my-project`.
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// Optional limit on the number of permissions to include in the response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token returned in an earlier
	// QueryTestablePermissionsRequest.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *QueryTestablePermissionsRequest) Reset() {
	*x = QueryTestablePermissionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryTestablePermissionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryTestablePermissionsRequest) ProtoMessage() {}

func (x *QueryTestablePermissionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryTestablePermissionsRequest.ProtoReflect.Descriptor instead.
func (*QueryTestablePermissionsRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{27}
}

func (x *QueryTestablePermissionsRequest) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *QueryTestablePermissionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *QueryTestablePermissionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response containing permissions which can be tested on a resource.
type QueryTestablePermissionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Permissions testable on the requested resource.
	Permissions []*Permission `protobuf:"bytes,1,rep,name=permissions,proto3" json:"permissions,omitempty"`
	// To retrieve the next page of results, set
	// `QueryTestableRolesRequest.page_token` to this value.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *QueryTestablePermissionsResponse) Reset() {
	*x = QueryTestablePermissionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_iam_admin_v1_iam_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryTestablePermissionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryTestablePermissionsResponse) ProtoMessage() {}

func (x *QueryTestablePermissionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_admin_v1_iam_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryTestablePermissionsResponse.ProtoReflect.Descriptor instead.
func (*QueryTestablePermissionsResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_admin_v1_iam_proto_rawDescGZIP(), []int{28}
}

func (x *QueryTestablePermissionsResponse) GetPermissions() []*Permission {
	if x != nil {
		return x.Permissions
	}
	return nil
}

func (x *QueryTestablePermissionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_iam_admin_v1_iam_proto protoreflect.FileDescriptor

var file_google_iam_admin_v1_iam_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xb5, 0x02, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x6e, 0x69,
	0x71, 0x75, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x6e,
	0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x12, 0x28, 0x0a, 0x10, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x5f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f,
	0x61, 0x75, 0x74, 0x68, 0x32, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x3a, 0x5c, 0xea,
	0x41, 0x59, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x22, 0xd8, 0x01, 0x0a, 0x1b,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x4c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xa1, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x86, 0x01, 0x0a, 0x1b, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x59, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5c,
	0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x82, 0x02, 0x0a,
	0x1d, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a,
	0x09, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x6b, 0x65,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x49, 0x0a, 0x07, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x18, 0x0a, 0x14, 0x4b, 0x45, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x55,
	0x53, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10, 0x01, 0x12, 0x12, 0x0a,
	0x0e, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10,
	0x02, 0x22, 0x5c, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x22,
	0xab, 0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x32, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x18, 0x0a, 0x16, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0x98, 0x04,
	0x0a, 0x11, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x4b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x54, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x5f, 0x61, 0x6c, 0x67, 0x6f,
	0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x4b, 0x65, 0x79, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x0c, 0x6b, 0x65,
	0x79, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x28, 0x0a, 0x10, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x44, 0x61, 0x74, 0x61, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x44, 0x61, 0x74, 0x61, 0x12, 0x44, 0x0a, 0x10,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x41, 0x66, 0x74, 0x65, 0x72, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x46, 0x0a, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x62, 0x65, 0x66, 0x6f,
	0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x5c, 0xea, 0x41, 0x59, 0x0a,
	0x16, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x6b, 0x65,
	0x79, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x7d, 0x22, 0x92, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x54, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x5f, 0x61,
	0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52,
	0x0c, 0x6b, 0x65, 0x79, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x22, 0x54, 0x0a,
	0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x32, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x18, 0x0a, 0x16, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x79, 0x0a, 0x0f, 0x53, 0x69, 0x67, 0x6e, 0x42, 0x6c, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x69, 0x61,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x74,
	0x6f, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x54, 0x6f, 0x53, 0x69, 0x67, 0x6e, 0x22, 0x47,
	0x0a, 0x10, 0x53, 0x69, 0x67, 0x6e, 0x42, 0x6c, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69, 0x67,
	0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x6e, 0x0a, 0x0e, 0x53, 0x69, 0x67, 0x6e, 0x4a,
	0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x47, 0x0a, 0x0f, 0x53, 0x69, 0x67, 0x6e, 0x4a,
	0x77, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6b, 0x65,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6a, 0x77, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4a, 0x77, 0x74,
	0x22, 0xcb, 0x02, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x14, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x64, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x67,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f,
	0x6c, 0x65, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x53, 0x74, 0x61,
	0x67, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x18, 0x0a,
	0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x55, 0x0a, 0x0f, 0x52, 0x6f, 0x6c, 0x65, 0x4c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c,
	0x50, 0x48, 0x41, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x45, 0x54, 0x41, 0x10, 0x01, 0x12,
	0x06, 0x0a, 0x02, 0x47, 0x41, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x50, 0x52, 0x45,
	0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x07, 0x0a, 0x03, 0x45, 0x41, 0x50, 0x10, 0x06, 0x22, 0xbe,
	0x01, 0x0a, 0x1a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a,
	0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x31, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x76, 0x0a, 0x1b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f,
	0x0a, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc4, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xfa, 0x41,
	0x03, 0x0a, 0x01, 0x2a, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x31, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x21, 0x0a, 0x0c, 0x73,
	0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x6c,
	0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x05, 0x72,
	0x6f, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x2c, 0x0a, 0x0e,
	0x47, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xfa, 0x41,
	0x03, 0x0a, 0x01, 0x2a, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7b, 0x0a, 0x11, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x06, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x17, 0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x72, 0x6f, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x2d, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c,
	0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x22, 0x9b, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xfa, 0x41, 0x03,
	0x0a, 0x01, 0x2a, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x04, 0x72, 0x6f, 0x6c,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f,
	0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x43, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x6f, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x45, 0x0a, 0x13, 0x55, 0x6e,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x06, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x22, 0xe4, 0x03, 0x0a, 0x0a, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x18,
	0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x69, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e,
	0x65, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15,
	0x6f, 0x6e, 0x6c, 0x79, 0x49, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x53, 0x74, 0x61, 0x67, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x67, 0x65, 0x12, 0x74, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x6f, 0x6c,
	0x65, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x6f,
	0x6c, 0x65, 0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52,
	0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x44, 0x0a, 0x15, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x53, 0x74, 0x61, 0x67,
	0x65, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x50, 0x48, 0x41, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x42, 0x45, 0x54, 0x41, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x47, 0x41, 0x10, 0x02, 0x12, 0x0e,
	0x0a, 0x0a, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x03, 0x22, 0x48,
	0x0a, 0x17, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x45, 0x53, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x02, 0x22, 0x8b, 0x01, 0x0a, 0x1f, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x54, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2c, 0x0a, 0x12,
	0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x20, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x54, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x0b, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2a, 0x61, 0x0a, 0x1a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x41, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x12, 0x17, 0x0a, 0x13, 0x4b, 0x45, 0x59, 0x5f, 0x41, 0x4c, 0x47, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a,
	0x10, 0x4b, 0x45, 0x59, 0x5f, 0x41, 0x4c, 0x47, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x31, 0x30, 0x32,
	0x34, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x4b, 0x45, 0x59, 0x5f, 0x41, 0x4c, 0x47, 0x5f, 0x52,
	0x53, 0x41, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x10, 0x02, 0x2a, 0x6c, 0x0a, 0x1c, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x32, 0x5f, 0x46,
	0x49, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x47, 0x4f,
	0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x53,
	0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x02, 0x2a, 0x5d, 0x0a, 0x1b, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b,
	0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e,
	0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x58, 0x35,
	0x30, 0x39, 0x5f, 0x50, 0x45, 0x4d, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x17, 0x0a,
	0x13, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x41, 0x57, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43,
	0x5f, 0x4b, 0x45, 0x59, 0x10, 0x02, 0x2a, 0x1f, 0x0a, 0x08, 0x52, 0x6f, 0x6c, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x01, 0x32, 0x84, 0x1f, 0x0a, 0x03, 0x49, 0x41, 0x4d, 0x12,
	0xae, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x9f, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x36, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xc1, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x94, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2c, 0x1a, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x12, 0x98, 0x01,
	0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x36, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x2a, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc8, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b,
	0x65, 0x79, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6b, 0x65,
	0x79, 0x73, 0xda, 0x41, 0x0e, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x12, 0xbf, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x14, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x12, 0xd5, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65,
	0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x22, 0x5d,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6b, 0x65, 0x79, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x23, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c,
	0x6b, 0x65, 0x79, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0xa5, 0x01,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa9, 0x01, 0x0a, 0x08, 0x53, 0x69, 0x67, 0x6e, 0x42, 0x6c,
	0x6f, 0x62, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x42, 0x6c, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x69, 0x67, 0x6e, 0x42, 0x6c, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x69, 0x67, 0x6e, 0x42, 0x6c, 0x6f, 0x62, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x12, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x67,
	0x6e, 0x12, 0x9f, 0x01, 0x0a, 0x07, 0x53, 0x69, 0x67, 0x6e, 0x4a, 0x77, 0x74, 0x12, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x4a, 0x77, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x4a, 0x77, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34,
	0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x69, 0x67, 0x6e, 0x4a, 0x77,
	0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0c, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x96, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22,
	0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0xa0, 0x01, 0x0a,
	0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0xcb, 0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x60, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x43, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2c, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xb7, 0x01,
	0x0a, 0x13, 0x51, 0x75, 0x65, 0x72, 0x79, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22,
	0x22, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x3a, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb4, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12, 0x09, 0x2f, 0x76,
	0x31, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x5a, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x5a, 0x1f, 0x12,
	0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0xac,
	0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x22, 0x61, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x5b, 0x12, 0x12, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x72, 0x6f,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x1f, 0x12, 0x1d,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa2, 0x01,
	0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x22,
	0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x22, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x22,
	0x22, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x3a,
	0x01, 0x2a, 0x12, 0xa8, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x6c,
	0x65, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x6f,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x6f, 0x6c, 0x65, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x32, 0x22, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x5a, 0x25, 0x32, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x6f, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x9c, 0x01,
	0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x22,
	0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x2a, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x1f, 0x2a, 0x1d, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01, 0x0a,
	0x0c, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x6f, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f,
	0x6c, 0x65, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75,
	0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x2b, 0x22, 0x26, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xbc, 0x01, 0x0a, 0x18, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x54, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x54, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x54, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x1a, 0x46, 0xca, 0x41, 0x12, 0x69, 0x61, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x62,
	0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x08, 0x49, 0x61, 0x6d, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x69, 0x61, 0x6d,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0xf8,
	0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_iam_admin_v1_iam_proto_rawDescOnce sync.Once
	file_google_iam_admin_v1_iam_proto_rawDescData = file_google_iam_admin_v1_iam_proto_rawDesc
)

func file_google_iam_admin_v1_iam_proto_rawDescGZIP() []byte {
	file_google_iam_admin_v1_iam_proto_rawDescOnce.Do(func() {
		file_google_iam_admin_v1_iam_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_iam_admin_v1_iam_proto_rawDescData)
	})
	return file_google_iam_admin_v1_iam_proto_rawDescData
}

var file_google_iam_admin_v1_iam_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_iam_admin_v1_iam_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_google_iam_admin_v1_iam_proto_goTypes = []interface{}{
	(ServiceAccountKeyAlgorithm)(0),            // 0: google.iam.admin.v1.ServiceAccountKeyAlgorithm
	(ServiceAccountPrivateKeyType)(0),          // 1: google.iam.admin.v1.ServiceAccountPrivateKeyType
	(ServiceAccountPublicKeyType)(0),           // 2: google.iam.admin.v1.ServiceAccountPublicKeyType
	(RoleView)(0),                              // 3: google.iam.admin.v1.RoleView
	(ListServiceAccountKeysRequest_KeyType)(0), // 4: google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType
	(Role_RoleLaunchStage)(0),                  // 5: google.iam.admin.v1.Role.RoleLaunchStage
	(Permission_PermissionLaunchStage)(0),      // 6: google.iam.admin.v1.Permission.PermissionLaunchStage
	(Permission_CustomRolesSupportLevel)(0),    // 7: google.iam.admin.v1.Permission.CustomRolesSupportLevel
	(*ServiceAccount)(nil),                     // 8: google.iam.admin.v1.ServiceAccount
	(*CreateServiceAccountRequest)(nil),        // 9: google.iam.admin.v1.CreateServiceAccountRequest
	(*ListServiceAccountsRequest)(nil),         // 10: google.iam.admin.v1.ListServiceAccountsRequest
	(*ListServiceAccountsResponse)(nil),        // 11: google.iam.admin.v1.ListServiceAccountsResponse
	(*GetServiceAccountRequest)(nil),           // 12: google.iam.admin.v1.GetServiceAccountRequest
	(*DeleteServiceAccountRequest)(nil),        // 13: google.iam.admin.v1.DeleteServiceAccountRequest
	(*ListServiceAccountKeysRequest)(nil),      // 14: google.iam.admin.v1.ListServiceAccountKeysRequest
	(*ListServiceAccountKeysResponse)(nil),     // 15: google.iam.admin.v1.ListServiceAccountKeysResponse
	(*GetServiceAccountKeyRequest)(nil),        // 16: google.iam.admin.v1.GetServiceAccountKeyRequest
	(*ServiceAccountKey)(nil),                  // 17: google.iam.admin.v1.ServiceAccountKey
	(*CreateServiceAccountKeyRequest)(nil),     // 18: google.iam.admin.v1.CreateServiceAccountKeyRequest
	(*DeleteServiceAccountKeyRequest)(nil),     // 19: google.iam.admin.v1.DeleteServiceAccountKeyRequest
	(*SignBlobRequest)(nil),                    // 20: google.iam.admin.v1.SignBlobRequest
	(*SignBlobResponse)(nil),                   // 21: google.iam.admin.v1.SignBlobResponse
	(*SignJwtRequest)(nil),                     // 22: google.iam.admin.v1.SignJwtRequest
	(*SignJwtResponse)(nil),                    // 23: google.iam.admin.v1.SignJwtResponse
	(*Role)(nil),                               // 24: google.iam.admin.v1.Role
	(*QueryGrantableRolesRequest)(nil),         // 25: google.iam.admin.v1.QueryGrantableRolesRequest
	(*QueryGrantableRolesResponse)(nil),        // 26: google.iam.admin.v1.QueryGrantableRolesResponse
	(*ListRolesRequest)(nil),                   // 27: google.iam.admin.v1.ListRolesRequest
	(*ListRolesResponse)(nil),                  // 28: google.iam.admin.v1.ListRolesResponse
	(*GetRoleRequest)(nil),                     // 29: google.iam.admin.v1.GetRoleRequest
	(*CreateRoleRequest)(nil),                  // 30: google.iam.admin.v1.CreateRoleRequest
	(*UpdateRoleRequest)(nil),                  // 31: google.iam.admin.v1.UpdateRoleRequest
	(*DeleteRoleRequest)(nil),                  // 32: google.iam.admin.v1.DeleteRoleRequest
	(*UndeleteRoleRequest)(nil),                // 33: google.iam.admin.v1.UndeleteRoleRequest
	(*Permission)(nil),                         // 34: google.iam.admin.v1.Permission
	(*QueryTestablePermissionsRequest)(nil),    // 35: google.iam.admin.v1.QueryTestablePermissionsRequest
	(*QueryTestablePermissionsResponse)(nil),   // 36: google.iam.admin.v1.QueryTestablePermissionsResponse
	(*timestamp.Timestamp)(nil),                // 37: google.protobuf.Timestamp
	(*field_mask.FieldMask)(nil),               // 38: google.protobuf.FieldMask
	(*v1.GetIamPolicyRequest)(nil),             // 39: google.iam.v1.GetIamPolicyRequest
	(*v1.SetIamPolicyRequest)(nil),             // 40: google.iam.v1.SetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),       // 41: google.iam.v1.TestIamPermissionsRequest
	(*empty.Empty)(nil),                        // 42: google.protobuf.Empty
	(*v1.Policy)(nil),                          // 43: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil),      // 44: google.iam.v1.TestIamPermissionsResponse
}
var file_google_iam_admin_v1_iam_proto_depIdxs = []int32{
	8,  // 0: google.iam.admin.v1.CreateServiceAccountRequest.service_account:type_name -> google.iam.admin.v1.ServiceAccount
	8,  // 1: google.iam.admin.v1.ListServiceAccountsResponse.accounts:type_name -> google.iam.admin.v1.ServiceAccount
	4,  // 2: google.iam.admin.v1.ListServiceAccountKeysRequest.key_types:type_name -> google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType
	17, // 3: google.iam.admin.v1.ListServiceAccountKeysResponse.keys:type_name -> google.iam.admin.v1.ServiceAccountKey
	2,  // 4: google.iam.admin.v1.GetServiceAccountKeyRequest.public_key_type:type_name -> google.iam.admin.v1.ServiceAccountPublicKeyType
	1,  // 5: google.iam.admin.v1.ServiceAccountKey.private_key_type:type_name -> google.iam.admin.v1.ServiceAccountPrivateKeyType
	0,  // 6: google.iam.admin.v1.ServiceAccountKey.key_algorithm:type_name -> google.iam.admin.v1.ServiceAccountKeyAlgorithm
	37, // 7: google.iam.admin.v1.ServiceAccountKey.valid_after_time:type_name -> google.protobuf.Timestamp
	37, // 8: google.iam.admin.v1.ServiceAccountKey.valid_before_time:type_name -> google.protobuf.Timestamp
	1,  // 9: google.iam.admin.v1.CreateServiceAccountKeyRequest.private_key_type:type_name -> google.iam.admin.v1.ServiceAccountPrivateKeyType
	0,  // 10: google.iam.admin.v1.CreateServiceAccountKeyRequest.key_algorithm:type_name -> google.iam.admin.v1.ServiceAccountKeyAlgorithm
	5,  // 11: google.iam.admin.v1.Role.stage:type_name -> google.iam.admin.v1.Role.RoleLaunchStage
	3,  // 12: google.iam.admin.v1.QueryGrantableRolesRequest.view:type_name -> google.iam.admin.v1.RoleView
	24, // 13: google.iam.admin.v1.QueryGrantableRolesResponse.roles:type_name -> google.iam.admin.v1.Role
	3,  // 14: google.iam.admin.v1.ListRolesRequest.view:type_name -> google.iam.admin.v1.RoleView
	24, // 15: google.iam.admin.v1.ListRolesResponse.roles:type_name -> google.iam.admin.v1.Role
	24, // 16: google.iam.admin.v1.CreateRoleRequest.role:type_name -> google.iam.admin.v1.Role
	24, // 17: google.iam.admin.v1.UpdateRoleRequest.role:type_name -> google.iam.admin.v1.Role
	38, // 18: google.iam.admin.v1.UpdateRoleRequest.update_mask:type_name -> google.protobuf.FieldMask
	6,  // 19: google.iam.admin.v1.Permission.stage:type_name -> google.iam.admin.v1.Permission.PermissionLaunchStage
	7,  // 20: google.iam.admin.v1.Permission.custom_roles_support_level:type_name -> google.iam.admin.v1.Permission.CustomRolesSupportLevel
	34, // 21: google.iam.admin.v1.QueryTestablePermissionsResponse.permissions:type_name -> google.iam.admin.v1.Permission
	10, // 22: google.iam.admin.v1.IAM.ListServiceAccounts:input_type -> google.iam.admin.v1.ListServiceAccountsRequest
	12, // 23: google.iam.admin.v1.IAM.GetServiceAccount:input_type -> google.iam.admin.v1.GetServiceAccountRequest
	9,  // 24: google.iam.admin.v1.IAM.CreateServiceAccount:input_type -> google.iam.admin.v1.CreateServiceAccountRequest
	8,  // 25: google.iam.admin.v1.IAM.UpdateServiceAccount:input_type -> google.iam.admin.v1.ServiceAccount
	13, // 26: google.iam.admin.v1.IAM.DeleteServiceAccount:input_type -> google.iam.admin.v1.DeleteServiceAccountRequest
	14, // 27: google.iam.admin.v1.IAM.ListServiceAccountKeys:input_type -> google.iam.admin.v1.ListServiceAccountKeysRequest
	16, // 28: google.iam.admin.v1.IAM.GetServiceAccountKey:input_type -> google.iam.admin.v1.GetServiceAccountKeyRequest
	18, // 29: google.iam.admin.v1.IAM.CreateServiceAccountKey:input_type -> google.iam.admin.v1.CreateServiceAccountKeyRequest
	19, // 30: google.iam.admin.v1.IAM.DeleteServiceAccountKey:input_type -> google.iam.admin.v1.DeleteServiceAccountKeyRequest
	20, // 31: google.iam.admin.v1.IAM.SignBlob:input_type -> google.iam.admin.v1.SignBlobRequest
	22, // 32: google.iam.admin.v1.IAM.SignJwt:input_type -> google.iam.admin.v1.SignJwtRequest
	39, // 33: google.iam.admin.v1.IAM.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	40, // 34: google.iam.admin.v1.IAM.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	41, // 35: google.iam.admin.v1.IAM.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	25, // 36: google.iam.admin.v1.IAM.QueryGrantableRoles:input_type -> google.iam.admin.v1.QueryGrantableRolesRequest
	27, // 37: google.iam.admin.v1.IAM.ListRoles:input_type -> google.iam.admin.v1.ListRolesRequest
	29, // 38: google.iam.admin.v1.IAM.GetRole:input_type -> google.iam.admin.v1.GetRoleRequest
	30, // 39: google.iam.admin.v1.IAM.CreateRole:input_type -> google.iam.admin.v1.CreateRoleRequest
	31, // 40: google.iam.admin.v1.IAM.UpdateRole:input_type -> google.iam.admin.v1.UpdateRoleRequest
	32, // 41: google.iam.admin.v1.IAM.DeleteRole:input_type -> google.iam.admin.v1.DeleteRoleRequest
	33, // 42: google.iam.admin.v1.IAM.UndeleteRole:input_type -> google.iam.admin.v1.UndeleteRoleRequest
	35, // 43: google.iam.admin.v1.IAM.QueryTestablePermissions:input_type -> google.iam.admin.v1.QueryTestablePermissionsRequest
	11, // 44: google.iam.admin.v1.IAM.ListServiceAccounts:output_type -> google.iam.admin.v1.ListServiceAccountsResponse
	8,  // 45: google.iam.admin.v1.IAM.GetServiceAccount:output_type -> google.iam.admin.v1.ServiceAccount
	8,  // 46: google.iam.admin.v1.IAM.CreateServiceAccount:output_type -> google.iam.admin.v1.ServiceAccount
	8,  // 47: google.iam.admin.v1.IAM.UpdateServiceAccount:output_type -> google.iam.admin.v1.ServiceAccount
	42, // 48: google.iam.admin.v1.IAM.DeleteServiceAccount:output_type -> google.protobuf.Empty
	15, // 49: google.iam.admin.v1.IAM.ListServiceAccountKeys:output_type -> google.iam.admin.v1.ListServiceAccountKeysResponse
	17, // 50: google.iam.admin.v1.IAM.GetServiceAccountKey:output_type -> google.iam.admin.v1.ServiceAccountKey
	17, // 51: google.iam.admin.v1.IAM.CreateServiceAccountKey:output_type -> google.iam.admin.v1.ServiceAccountKey
	42, // 52: google.iam.admin.v1.IAM.DeleteServiceAccountKey:output_type -> google.protobuf.Empty
	21, // 53: google.iam.admin.v1.IAM.SignBlob:output_type -> google.iam.admin.v1.SignBlobResponse
	23, // 54: google.iam.admin.v1.IAM.SignJwt:output_type -> google.iam.admin.v1.SignJwtResponse
	43, // 55: google.iam.admin.v1.IAM.GetIamPolicy:output_type -> google.iam.v1.Policy
	43, // 56: google.iam.admin.v1.IAM.SetIamPolicy:output_type -> google.iam.v1.Policy
	44, // 57: google.iam.admin.v1.IAM.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	26, // 58: google.iam.admin.v1.IAM.QueryGrantableRoles:output_type -> google.iam.admin.v1.QueryGrantableRolesResponse
	28, // 59: google.iam.admin.v1.IAM.ListRoles:output_type -> google.iam.admin.v1.ListRolesResponse
	24, // 60: google.iam.admin.v1.IAM.GetRole:output_type -> google.iam.admin.v1.Role
	24, // 61: google.iam.admin.v1.IAM.CreateRole:output_type -> google.iam.admin.v1.Role
	24, // 62: google.iam.admin.v1.IAM.UpdateRole:output_type -> google.iam.admin.v1.Role
	24, // 63: google.iam.admin.v1.IAM.DeleteRole:output_type -> google.iam.admin.v1.Role
	24, // 64: google.iam.admin.v1.IAM.UndeleteRole:output_type -> google.iam.admin.v1.Role
	36, // 65: google.iam.admin.v1.IAM.QueryTestablePermissions:output_type -> google.iam.admin.v1.QueryTestablePermissionsResponse
	44, // [44:66] is the sub-list for method output_type
	22, // [22:44] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_iam_admin_v1_iam_proto_init() }
func file_google_iam_admin_v1_iam_proto_init() {
	if File_google_iam_admin_v1_iam_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_iam_admin_v1_iam_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateServiceAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServiceAccountsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServiceAccountsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServiceAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteServiceAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServiceAccountKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServiceAccountKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServiceAccountKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccountKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateServiceAccountKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteServiceAccountKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignBlobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignBlobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignJwtRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignJwtResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Role); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryGrantableRolesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryGrantableRolesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRolesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRolesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRoleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRoleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRoleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRoleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeleteRoleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Permission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryTestablePermissionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_iam_admin_v1_iam_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryTestablePermissionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_iam_admin_v1_iam_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_iam_admin_v1_iam_proto_goTypes,
		DependencyIndexes: file_google_iam_admin_v1_iam_proto_depIdxs,
		EnumInfos:         file_google_iam_admin_v1_iam_proto_enumTypes,
		MessageInfos:      file_google_iam_admin_v1_iam_proto_msgTypes,
	}.Build()
	File_google_iam_admin_v1_iam_proto = out.File
	file_google_iam_admin_v1_iam_proto_rawDesc = nil
	file_google_iam_admin_v1_iam_proto_goTypes = nil
	file_google_iam_admin_v1_iam_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IAMClient is the client API for IAM service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IAMClient interface {
	// Lists [ServiceAccounts][google.iam.admin.v1.ServiceAccount] for a project.
	ListServiceAccounts(ctx context.Context, in *ListServiceAccountsRequest, opts ...grpc.CallOption) (*ListServiceAccountsResponse, error)
	// Gets a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	GetServiceAccount(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Creates a [ServiceAccount][google.iam.admin.v1.ServiceAccount]
	// and returns it.
	CreateServiceAccount(ctx context.Context, in *CreateServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Updates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Currently, only the following fields are updatable:
	// `display_name` and `description`.
	UpdateServiceAccount(ctx context.Context, in *ServiceAccount, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Deletes a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	DeleteServiceAccount(ctx context.Context, in *DeleteServiceAccountRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists [ServiceAccountKeys][google.iam.admin.v1.ServiceAccountKey].
	ListServiceAccountKeys(ctx context.Context, in *ListServiceAccountKeysRequest, opts ...grpc.CallOption) (*ListServiceAccountKeysResponse, error)
	// Gets the [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// by key id.
	GetServiceAccountKey(ctx context.Context, in *GetServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error)
	// Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// and returns it.
	CreateServiceAccountKey(ctx context.Context, in *CreateServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error)
	// Deletes a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
	DeleteServiceAccountKey(ctx context.Context, in *DeleteServiceAccountKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Signs a blob using a service account's system-managed private key.
	SignBlob(ctx context.Context, in *SignBlobRequest, opts ...grpc.CallOption) (*SignBlobResponse, error)
	// Signs a JWT using a service account's system-managed private key.
	//
	// If no expiry time (`exp`) is provided in the `SignJwtRequest`, IAM sets an
	// an expiry time of one hour by default. If you request an expiry time of
	// more than one hour, the request will fail.
	SignJwt(ctx context.Context, in *SignJwtRequest, opts ...grpc.CallOption) (*SignJwtResponse, error)
	// Returns the Cloud IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Note: Service accounts are both
	// [resources and
	// identities](/iam/docs/service-accounts#service_account_permissions). This
	// method treats the service account as a resource. It returns the Cloud IAM
	// policy that reflects what members have access to the service account.
	//
	// This method does not return what resources the service account has access
	// to. To see if a service account has access to a resource, call the
	// `getIamPolicy` method on the target resource. For example, to view grants
	// for a project, call the
	// [projects.getIamPolicy](/resource-manager/reference/rest/v1/projects/getIamPolicy)
	// method.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the Cloud IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Note: Service accounts are both
	// [resources and
	// identities](/iam/docs/service-accounts#service_account_permissions). This
	// method treats the service account as a resource. Use it to grant members
	// access to the service account, such as when they need to impersonate it.
	//
	// This method does not grant the service account access to other resources,
	// such as projects. To grant a service account access to resources, include
	// the service account in the Cloud IAM policy for the desired resource, then
	// call the appropriate `setIamPolicy` method on the target resource. For
	// example, to grant a service account access to a project, call the
	// [projects.setIamPolicy](/resource-manager/reference/rest/v1/projects/setIamPolicy)
	// method.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Tests the specified permissions against the IAM access control policy
	// for a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Queries roles that can be granted on a particular resource.
	// A role is grantable if it can be used as the role in a binding for a policy
	// for that resource.
	QueryGrantableRoles(ctx context.Context, in *QueryGrantableRolesRequest, opts ...grpc.CallOption) (*QueryGrantableRolesResponse, error)
	// Lists the Roles defined on a resource.
	ListRoles(ctx context.Context, in *ListRolesRequest, opts ...grpc.CallOption) (*ListRolesResponse, error)
	// Gets a Role definition.
	GetRole(ctx context.Context, in *GetRoleRequest, opts ...grpc.CallOption) (*Role, error)
	// Creates a new Role.
	CreateRole(ctx context.Context, in *CreateRoleRequest, opts ...grpc.CallOption) (*Role, error)
	// Updates a Role definition.
	UpdateRole(ctx context.Context, in *UpdateRoleRequest, opts ...grpc.CallOption) (*Role, error)
	// Soft deletes a role. The role is suspended and cannot be used to create new
	// IAM Policy Bindings.
	// The Role will not be included in `ListRoles()` unless `show_deleted` is set
	// in the `ListRolesRequest`. The Role contains the deleted boolean set.
	// Existing Bindings remains, but are inactive. The Role can be undeleted
	// within 7 days. After 7 days the Role is deleted and all Bindings associated
	// with the role are removed.
	DeleteRole(ctx context.Context, in *DeleteRoleRequest, opts ...grpc.CallOption) (*Role, error)
	// Undelete a Role, bringing it back in its previous state.
	UndeleteRole(ctx context.Context, in *UndeleteRoleRequest, opts ...grpc.CallOption) (*Role, error)
	// Lists the permissions testable on a resource.
	// A permission is testable if it can be tested for an identity on a resource.
	QueryTestablePermissions(ctx context.Context, in *QueryTestablePermissionsRequest, opts ...grpc.CallOption) (*QueryTestablePermissionsResponse, error)
}

type iAMClient struct {
	cc grpc.ClientConnInterface
}

func NewIAMClient(cc grpc.ClientConnInterface) IAMClient {
	return &iAMClient{cc}
}

func (c *iAMClient) ListServiceAccounts(ctx context.Context, in *ListServiceAccountsRequest, opts ...grpc.CallOption) (*ListServiceAccountsResponse, error) {
	out := new(ListServiceAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/ListServiceAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetServiceAccount(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) CreateServiceAccount(ctx context.Context, in *CreateServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/CreateServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) UpdateServiceAccount(ctx context.Context, in *ServiceAccount, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/UpdateServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) DeleteServiceAccount(ctx context.Context, in *DeleteServiceAccountRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/DeleteServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) ListServiceAccountKeys(ctx context.Context, in *ListServiceAccountKeysRequest, opts ...grpc.CallOption) (*ListServiceAccountKeysResponse, error) {
	out := new(ListServiceAccountKeysResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/ListServiceAccountKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetServiceAccountKey(ctx context.Context, in *GetServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error) {
	out := new(ServiceAccountKey)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetServiceAccountKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) CreateServiceAccountKey(ctx context.Context, in *CreateServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error) {
	out := new(ServiceAccountKey)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/CreateServiceAccountKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) DeleteServiceAccountKey(ctx context.Context, in *DeleteServiceAccountKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/DeleteServiceAccountKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) SignBlob(ctx context.Context, in *SignBlobRequest, opts ...grpc.CallOption) (*SignBlobResponse, error) {
	out := new(SignBlobResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/SignBlob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) SignJwt(ctx context.Context, in *SignJwtRequest, opts ...grpc.CallOption) (*SignJwtResponse, error) {
	out := new(SignJwtResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/SignJwt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) QueryGrantableRoles(ctx context.Context, in *QueryGrantableRolesRequest, opts ...grpc.CallOption) (*QueryGrantableRolesResponse, error) {
	out := new(QueryGrantableRolesResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/QueryGrantableRoles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) ListRoles(ctx context.Context, in *ListRolesRequest, opts ...grpc.CallOption) (*ListRolesResponse, error) {
	out := new(ListRolesResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/ListRoles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetRole(ctx context.Context, in *GetRoleRequest, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) CreateRole(ctx context.Context, in *CreateRoleRequest, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/CreateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) UpdateRole(ctx context.Context, in *UpdateRoleRequest, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/UpdateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) DeleteRole(ctx context.Context, in *DeleteRoleRequest, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/DeleteRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) UndeleteRole(ctx context.Context, in *UndeleteRoleRequest, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/UndeleteRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) QueryTestablePermissions(ctx context.Context, in *QueryTestablePermissionsRequest, opts ...grpc.CallOption) (*QueryTestablePermissionsResponse, error) {
	out := new(QueryTestablePermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/QueryTestablePermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IAMServer is the server API for IAM service.
type IAMServer interface {
	// Lists [ServiceAccounts][google.iam.admin.v1.ServiceAccount] for a project.
	ListServiceAccounts(context.Context, *ListServiceAccountsRequest) (*ListServiceAccountsResponse, error)
	// Gets a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	GetServiceAccount(context.Context, *GetServiceAccountRequest) (*ServiceAccount, error)
	// Creates a [ServiceAccount][google.iam.admin.v1.ServiceAccount]
	// and returns it.
	CreateServiceAccount(context.Context, *CreateServiceAccountRequest) (*ServiceAccount, error)
	// Updates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Currently, only the following fields are updatable:
	// `display_name` and `description`.
	UpdateServiceAccount(context.Context, *ServiceAccount) (*ServiceAccount, error)
	// Deletes a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	DeleteServiceAccount(context.Context, *DeleteServiceAccountRequest) (*empty.Empty, error)
	// Lists [ServiceAccountKeys][google.iam.admin.v1.ServiceAccountKey].
	ListServiceAccountKeys(context.Context, *ListServiceAccountKeysRequest) (*ListServiceAccountKeysResponse, error)
	// Gets the [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// by key id.
	GetServiceAccountKey(context.Context, *GetServiceAccountKeyRequest) (*ServiceAccountKey, error)
	// Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// and returns it.
	CreateServiceAccountKey(context.Context, *CreateServiceAccountKeyRequest) (*ServiceAccountKey, error)
	// Deletes a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
	DeleteServiceAccountKey(context.Context, *DeleteServiceAccountKeyRequest) (*empty.Empty, error)
	// Signs a blob using a service account's system-managed private key.
	SignBlob(context.Context, *SignBlobRequest) (*SignBlobResponse, error)
	// Signs a JWT using a service account's system-managed private key.
	//
	// If no expiry time (`exp`) is provided in the `SignJwtRequest`, IAM sets an
	// an expiry time of one hour by default. If you request an expiry time of
	// more than one hour, the request will fail.
	SignJwt(context.Context, *SignJwtRequest) (*SignJwtResponse, error)
	// Returns the Cloud IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Note: Service accounts are both
	// [resources and
	// identities](/iam/docs/service-accounts#service_account_permissions). This
	// method treats the service account as a resource. It returns the Cloud IAM
	// policy that reflects what members have access to the service account.
	//
	// This method does not return what resources the service account has access
	// to. To see if a service account has access to a resource, call the
	// `getIamPolicy` method on the target resource. For example, to view grants
	// for a project, call the
	// [projects.getIamPolicy](/resource-manager/reference/rest/v1/projects/getIamPolicy)
	// method.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the Cloud IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Note: Service accounts are both
	// [resources and
	// identities](/iam/docs/service-accounts#service_account_permissions). This
	// method treats the service account as a resource. Use it to grant members
	// access to the service account, such as when they need to impersonate it.
	//
	// This method does not grant the service account access to other resources,
	// such as projects. To grant a service account access to resources, include
	// the service account in the Cloud IAM policy for the desired resource, then
	// call the appropriate `setIamPolicy` method on the target resource. For
	// example, to grant a service account access to a project, call the
	// [projects.setIamPolicy](/resource-manager/reference/rest/v1/projects/setIamPolicy)
	// method.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Tests the specified permissions against the IAM access control policy
	// for a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Queries roles that can be granted on a particular resource.
	// A role is grantable if it can be used as the role in a binding for a policy
	// for that resource.
	QueryGrantableRoles(context.Context, *QueryGrantableRolesRequest) (*QueryGrantableRolesResponse, error)
	// Lists the Roles defined on a resource.
	ListRoles(context.Context, *ListRolesRequest) (*ListRolesResponse, error)
	// Gets a Role definition.
	GetRole(context.Context, *GetRoleRequest) (*Role, error)
	// Creates a new Role.
	CreateRole(context.Context, *CreateRoleRequest) (*Role, error)
	// Updates a Role definition.
	UpdateRole(context.Context, *UpdateRoleRequest) (*Role, error)
	// Soft deletes a role. The role is suspended and cannot be used to create new
	// IAM Policy Bindings.
	// The Role will not be included in `ListRoles()` unless `show_deleted` is set
	// in the `ListRolesRequest`. The Role contains the deleted boolean set.
	// Existing Bindings remains, but are inactive. The Role can be undeleted
	// within 7 days. After 7 days the Role is deleted and all Bindings associated
	// with the role are removed.
	DeleteRole(context.Context, *DeleteRoleRequest) (*Role, error)
	// Undelete a Role, bringing it back in its previous state.
	UndeleteRole(context.Context, *UndeleteRoleRequest) (*Role, error)
	// Lists the permissions testable on a resource.
	// A permission is testable if it can be tested for an identity on a resource.
	QueryTestablePermissions(context.Context, *QueryTestablePermissionsRequest) (*QueryTestablePermissionsResponse, error)
}

// UnimplementedIAMServer can be embedded to have forward compatible implementations.
type UnimplementedIAMServer struct {
}

func (*UnimplementedIAMServer) ListServiceAccounts(context.Context, *ListServiceAccountsRequest) (*ListServiceAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceAccounts not implemented")
}
func (*UnimplementedIAMServer) GetServiceAccount(context.Context, *GetServiceAccountRequest) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceAccount not implemented")
}
func (*UnimplementedIAMServer) CreateServiceAccount(context.Context, *CreateServiceAccountRequest) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServiceAccount not implemented")
}
func (*UnimplementedIAMServer) UpdateServiceAccount(context.Context, *ServiceAccount) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateServiceAccount not implemented")
}
func (*UnimplementedIAMServer) DeleteServiceAccount(context.Context, *DeleteServiceAccountRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServiceAccount not implemented")
}
func (*UnimplementedIAMServer) ListServiceAccountKeys(context.Context, *ListServiceAccountKeysRequest) (*ListServiceAccountKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceAccountKeys not implemented")
}
func (*UnimplementedIAMServer) GetServiceAccountKey(context.Context, *GetServiceAccountKeyRequest) (*ServiceAccountKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceAccountKey not implemented")
}
func (*UnimplementedIAMServer) CreateServiceAccountKey(context.Context, *CreateServiceAccountKeyRequest) (*ServiceAccountKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServiceAccountKey not implemented")
}
func (*UnimplementedIAMServer) DeleteServiceAccountKey(context.Context, *DeleteServiceAccountKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServiceAccountKey not implemented")
}
func (*UnimplementedIAMServer) SignBlob(context.Context, *SignBlobRequest) (*SignBlobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignBlob not implemented")
}
func (*UnimplementedIAMServer) SignJwt(context.Context, *SignJwtRequest) (*SignJwtResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignJwt not implemented")
}
func (*UnimplementedIAMServer) GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedIAMServer) SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedIAMServer) TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedIAMServer) QueryGrantableRoles(context.Context, *QueryGrantableRolesRequest) (*QueryGrantableRolesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryGrantableRoles not implemented")
}
func (*UnimplementedIAMServer) ListRoles(context.Context, *ListRolesRequest) (*ListRolesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRoles not implemented")
}
func (*UnimplementedIAMServer) GetRole(context.Context, *GetRoleRequest) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRole not implemented")
}
func (*UnimplementedIAMServer) CreateRole(context.Context, *CreateRoleRequest) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRole not implemented")
}
func (*UnimplementedIAMServer) UpdateRole(context.Context, *UpdateRoleRequest) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRole not implemented")
}
func (*UnimplementedIAMServer) DeleteRole(context.Context, *DeleteRoleRequest) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRole not implemented")
}
func (*UnimplementedIAMServer) UndeleteRole(context.Context, *UndeleteRoleRequest) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteRole not implemented")
}
func (*UnimplementedIAMServer) QueryTestablePermissions(context.Context, *QueryTestablePermissionsRequest) (*QueryTestablePermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryTestablePermissions not implemented")
}

func RegisterIAMServer(s *grpc.Server, srv IAMServer) {
	s.RegisterService(&_IAM_serviceDesc, srv)
}

func _IAM_ListServiceAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).ListServiceAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/ListServiceAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).ListServiceAccounts(ctx, req.(*ListServiceAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetServiceAccount(ctx, req.(*GetServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_CreateServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).CreateServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/CreateServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).CreateServiceAccount(ctx, req.(*CreateServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_UpdateServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ServiceAccount)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).UpdateServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/UpdateServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).UpdateServiceAccount(ctx, req.(*ServiceAccount))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_DeleteServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).DeleteServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/DeleteServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).DeleteServiceAccount(ctx, req.(*DeleteServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_ListServiceAccountKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceAccountKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).ListServiceAccountKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/ListServiceAccountKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).ListServiceAccountKeys(ctx, req.(*ListServiceAccountKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetServiceAccountKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceAccountKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetServiceAccountKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetServiceAccountKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetServiceAccountKey(ctx, req.(*GetServiceAccountKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_CreateServiceAccountKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceAccountKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).CreateServiceAccountKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/CreateServiceAccountKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).CreateServiceAccountKey(ctx, req.(*CreateServiceAccountKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_DeleteServiceAccountKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceAccountKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).DeleteServiceAccountKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/DeleteServiceAccountKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).DeleteServiceAccountKey(ctx, req.(*DeleteServiceAccountKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_SignBlob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignBlobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).SignBlob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/SignBlob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).SignBlob(ctx, req.(*SignBlobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_SignJwt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignJwtRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).SignJwt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/SignJwt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).SignJwt(ctx, req.(*SignJwtRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_QueryGrantableRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryGrantableRolesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).QueryGrantableRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/QueryGrantableRoles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).QueryGrantableRoles(ctx, req.(*QueryGrantableRolesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_ListRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRolesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).ListRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/ListRoles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).ListRoles(ctx, req.(*ListRolesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetRole(ctx, req.(*GetRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_CreateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).CreateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/CreateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).CreateRole(ctx, req.(*CreateRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_UpdateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).UpdateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/UpdateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).UpdateRole(ctx, req.(*UpdateRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_DeleteRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).DeleteRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/DeleteRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).DeleteRole(ctx, req.(*DeleteRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_UndeleteRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).UndeleteRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/UndeleteRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).UndeleteRole(ctx, req.(*UndeleteRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_QueryTestablePermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryTestablePermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).QueryTestablePermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/QueryTestablePermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).QueryTestablePermissions(ctx, req.(*QueryTestablePermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IAM_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.admin.v1.IAM",
	HandlerType: (*IAMServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServiceAccounts",
			Handler:    _IAM_ListServiceAccounts_Handler,
		},
		{
			MethodName: "GetServiceAccount",
			Handler:    _IAM_GetServiceAccount_Handler,
		},
		{
			MethodName: "CreateServiceAccount",
			Handler:    _IAM_CreateServiceAccount_Handler,
		},
		{
			MethodName: "UpdateServiceAccount",
			Handler:    _IAM_UpdateServiceAccount_Handler,
		},
		{
			MethodName: "DeleteServiceAccount",
			Handler:    _IAM_DeleteServiceAccount_Handler,
		},
		{
			MethodName: "ListServiceAccountKeys",
			Handler:    _IAM_ListServiceAccountKeys_Handler,
		},
		{
			MethodName: "GetServiceAccountKey",
			Handler:    _IAM_GetServiceAccountKey_Handler,
		},
		{
			MethodName: "CreateServiceAccountKey",
			Handler:    _IAM_CreateServiceAccountKey_Handler,
		},
		{
			MethodName: "DeleteServiceAccountKey",
			Handler:    _IAM_DeleteServiceAccountKey_Handler,
		},
		{
			MethodName: "SignBlob",
			Handler:    _IAM_SignBlob_Handler,
		},
		{
			MethodName: "SignJwt",
			Handler:    _IAM_SignJwt_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _IAM_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _IAM_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _IAM_TestIamPermissions_Handler,
		},
		{
			MethodName: "QueryGrantableRoles",
			Handler:    _IAM_QueryGrantableRoles_Handler,
		},
		{
			MethodName: "ListRoles",
			Handler:    _IAM_ListRoles_Handler,
		},
		{
			MethodName: "GetRole",
			Handler:    _IAM_GetRole_Handler,
		},
		{
			MethodName: "CreateRole",
			Handler:    _IAM_CreateRole_Handler,
		},
		{
			MethodName: "UpdateRole",
			Handler:    _IAM_UpdateRole_Handler,
		},
		{
			MethodName: "DeleteRole",
			Handler:    _IAM_DeleteRole_Handler,
		},
		{
			MethodName: "UndeleteRole",
			Handler:    _IAM_UndeleteRole_Handler,
		},
		{
			MethodName: "QueryTestablePermissions",
			Handler:    _IAM_QueryTestablePermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/iam/admin/v1/iam.proto",
}
