// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v3/services/keyword_plan_service.proto

package services

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for [KeywordPlanService.GetKeywordPlan][google.ads.googleads.v3.services.KeywordPlanService.GetKeywordPlan].
type GetKeywordPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the plan to fetch.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *GetKeywordPlanRequest) Reset() {
	*x = GetKeywordPlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetKeywordPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetKeywordPlanRequest) ProtoMessage() {}

func (x *GetKeywordPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetKeywordPlanRequest.ProtoReflect.Descriptor instead.
func (*GetKeywordPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetKeywordPlanRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [KeywordPlanService.MutateKeywordPlans][google.ads.googleads.v3.services.KeywordPlanService.MutateKeywordPlans].
type MutateKeywordPlansRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer whose keyword plans are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual keyword plans.
	Operations []*KeywordPlanOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *MutateKeywordPlansRequest) Reset() {
	*x = MutateKeywordPlansRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateKeywordPlansRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateKeywordPlansRequest) ProtoMessage() {}

func (x *MutateKeywordPlansRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateKeywordPlansRequest.ProtoReflect.Descriptor instead.
func (*MutateKeywordPlansRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{1}
}

func (x *MutateKeywordPlansRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *MutateKeywordPlansRequest) GetOperations() []*KeywordPlanOperation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *MutateKeywordPlansRequest) GetPartialFailure() bool {
	if x != nil {
		return x.PartialFailure
	}
	return false
}

func (x *MutateKeywordPlansRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on a keyword plan.
type KeywordPlanOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The FieldMask that determines which resource fields are modified in an
	// update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are assignable to Operation:
	//	*KeywordPlanOperation_Create
	//	*KeywordPlanOperation_Update
	//	*KeywordPlanOperation_Remove
	Operation isKeywordPlanOperation_Operation `protobuf_oneof:"operation"`
}

func (x *KeywordPlanOperation) Reset() {
	*x = KeywordPlanOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanOperation) ProtoMessage() {}

func (x *KeywordPlanOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanOperation.ProtoReflect.Descriptor instead.
func (*KeywordPlanOperation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{2}
}

func (x *KeywordPlanOperation) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (m *KeywordPlanOperation) GetOperation() isKeywordPlanOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *KeywordPlanOperation) GetCreate() *resources.KeywordPlan {
	if x, ok := x.GetOperation().(*KeywordPlanOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (x *KeywordPlanOperation) GetUpdate() *resources.KeywordPlan {
	if x, ok := x.GetOperation().(*KeywordPlanOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (x *KeywordPlanOperation) GetRemove() string {
	if x, ok := x.GetOperation().(*KeywordPlanOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

type isKeywordPlanOperation_Operation interface {
	isKeywordPlanOperation_Operation()
}

type KeywordPlanOperation_Create struct {
	// Create operation: No resource name is expected for the new keyword plan.
	Create *resources.KeywordPlan `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type KeywordPlanOperation_Update struct {
	// Update operation: The keyword plan is expected to have a valid resource
	// name.
	Update *resources.KeywordPlan `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type KeywordPlanOperation_Remove struct {
	// Remove operation: A resource name for the removed keyword plan is
	// expected in this format:
	//
	// `customers/{customer_id}/keywordPlans/{keyword_plan_id}`
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*KeywordPlanOperation_Create) isKeywordPlanOperation_Operation() {}

func (*KeywordPlanOperation_Update) isKeywordPlanOperation_Operation() {}

func (*KeywordPlanOperation_Remove) isKeywordPlanOperation_Operation() {}

// Response message for a keyword plan mutate.
type MutateKeywordPlansResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results []*MutateKeywordPlansResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *MutateKeywordPlansResponse) Reset() {
	*x = MutateKeywordPlansResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateKeywordPlansResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateKeywordPlansResponse) ProtoMessage() {}

func (x *MutateKeywordPlansResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateKeywordPlansResponse.ProtoReflect.Descriptor instead.
func (*MutateKeywordPlansResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{3}
}

func (x *MutateKeywordPlansResponse) GetPartialFailureError() *status.Status {
	if x != nil {
		return x.PartialFailureError
	}
	return nil
}

func (x *MutateKeywordPlansResponse) GetResults() []*MutateKeywordPlansResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// The result for the keyword plan mutate.
type MutateKeywordPlansResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returned for successful operations.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *MutateKeywordPlansResult) Reset() {
	*x = MutateKeywordPlansResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateKeywordPlansResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateKeywordPlansResult) ProtoMessage() {}

func (x *MutateKeywordPlansResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateKeywordPlansResult.ProtoReflect.Descriptor instead.
func (*MutateKeywordPlansResult) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{4}
}

func (x *MutateKeywordPlansResult) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [KeywordPlanService.GenerateForecastMetrics][google.ads.googleads.v3.services.KeywordPlanService.GenerateForecastMetrics].
type GenerateForecastMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the keyword plan to be forecasted.
	KeywordPlan string `protobuf:"bytes,1,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
}

func (x *GenerateForecastMetricsRequest) Reset() {
	*x = GenerateForecastMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateForecastMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateForecastMetricsRequest) ProtoMessage() {}

func (x *GenerateForecastMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateForecastMetricsRequest.ProtoReflect.Descriptor instead.
func (*GenerateForecastMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{5}
}

func (x *GenerateForecastMetricsRequest) GetKeywordPlan() string {
	if x != nil {
		return x.KeywordPlan
	}
	return ""
}

// Response message for [KeywordPlanService.GenerateForecastMetrics][google.ads.googleads.v3.services.KeywordPlanService.GenerateForecastMetrics].
type GenerateForecastMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of campaign forecasts.
	// One maximum.
	CampaignForecasts []*KeywordPlanCampaignForecast `protobuf:"bytes,1,rep,name=campaign_forecasts,json=campaignForecasts,proto3" json:"campaign_forecasts,omitempty"`
	// List of ad group forecasts.
	AdGroupForecasts []*KeywordPlanAdGroupForecast `protobuf:"bytes,2,rep,name=ad_group_forecasts,json=adGroupForecasts,proto3" json:"ad_group_forecasts,omitempty"`
	// List of keyword forecasts.
	KeywordForecasts []*KeywordPlanKeywordForecast `protobuf:"bytes,3,rep,name=keyword_forecasts,json=keywordForecasts,proto3" json:"keyword_forecasts,omitempty"`
}

func (x *GenerateForecastMetricsResponse) Reset() {
	*x = GenerateForecastMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateForecastMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateForecastMetricsResponse) ProtoMessage() {}

func (x *GenerateForecastMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateForecastMetricsResponse.ProtoReflect.Descriptor instead.
func (*GenerateForecastMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{6}
}

func (x *GenerateForecastMetricsResponse) GetCampaignForecasts() []*KeywordPlanCampaignForecast {
	if x != nil {
		return x.CampaignForecasts
	}
	return nil
}

func (x *GenerateForecastMetricsResponse) GetAdGroupForecasts() []*KeywordPlanAdGroupForecast {
	if x != nil {
		return x.AdGroupForecasts
	}
	return nil
}

func (x *GenerateForecastMetricsResponse) GetKeywordForecasts() []*KeywordPlanKeywordForecast {
	if x != nil {
		return x.KeywordForecasts
	}
	return nil
}

// A campaign forecast.
type KeywordPlanCampaignForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Keyword Plan campaign related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanCampaigns/{keyword_plan_campaign_id}`
	KeywordPlanCampaign *wrappers.StringValue `protobuf:"bytes,1,opt,name=keyword_plan_campaign,json=keywordPlanCampaign,proto3" json:"keyword_plan_campaign,omitempty"`
	// The forecast for the Keyword Plan campaign.
	CampaignForecast *ForecastMetrics `protobuf:"bytes,2,opt,name=campaign_forecast,json=campaignForecast,proto3" json:"campaign_forecast,omitempty"`
}

func (x *KeywordPlanCampaignForecast) Reset() {
	*x = KeywordPlanCampaignForecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanCampaignForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanCampaignForecast) ProtoMessage() {}

func (x *KeywordPlanCampaignForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanCampaignForecast.ProtoReflect.Descriptor instead.
func (*KeywordPlanCampaignForecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{7}
}

func (x *KeywordPlanCampaignForecast) GetKeywordPlanCampaign() *wrappers.StringValue {
	if x != nil {
		return x.KeywordPlanCampaign
	}
	return nil
}

func (x *KeywordPlanCampaignForecast) GetCampaignForecast() *ForecastMetrics {
	if x != nil {
		return x.CampaignForecast
	}
	return nil
}

// An ad group forecast.
type KeywordPlanAdGroupForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Keyword Plan ad group related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanAdGroups/{keyword_plan_ad_group_id}`
	KeywordPlanAdGroup *wrappers.StringValue `protobuf:"bytes,1,opt,name=keyword_plan_ad_group,json=keywordPlanAdGroup,proto3" json:"keyword_plan_ad_group,omitempty"`
	// The forecast for the Keyword Plan ad group.
	AdGroupForecast *ForecastMetrics `protobuf:"bytes,2,opt,name=ad_group_forecast,json=adGroupForecast,proto3" json:"ad_group_forecast,omitempty"`
}

func (x *KeywordPlanAdGroupForecast) Reset() {
	*x = KeywordPlanAdGroupForecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanAdGroupForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanAdGroupForecast) ProtoMessage() {}

func (x *KeywordPlanAdGroupForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanAdGroupForecast.ProtoReflect.Descriptor instead.
func (*KeywordPlanAdGroupForecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{8}
}

func (x *KeywordPlanAdGroupForecast) GetKeywordPlanAdGroup() *wrappers.StringValue {
	if x != nil {
		return x.KeywordPlanAdGroup
	}
	return nil
}

func (x *KeywordPlanAdGroupForecast) GetAdGroupForecast() *ForecastMetrics {
	if x != nil {
		return x.AdGroupForecast
	}
	return nil
}

// A keyword forecast.
type KeywordPlanKeywordForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Keyword Plan keyword related to the forecast.
	//
	// `customers/{customer_id}/keywordPlanAdGroupKeywords/{keyword_plan_ad_group_keyword_id}`
	KeywordPlanAdGroupKeyword *wrappers.StringValue `protobuf:"bytes,1,opt,name=keyword_plan_ad_group_keyword,json=keywordPlanAdGroupKeyword,proto3" json:"keyword_plan_ad_group_keyword,omitempty"`
	// The forecast for the Keyword Plan keyword.
	KeywordForecast *ForecastMetrics `protobuf:"bytes,2,opt,name=keyword_forecast,json=keywordForecast,proto3" json:"keyword_forecast,omitempty"`
}

func (x *KeywordPlanKeywordForecast) Reset() {
	*x = KeywordPlanKeywordForecast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanKeywordForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanKeywordForecast) ProtoMessage() {}

func (x *KeywordPlanKeywordForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanKeywordForecast.ProtoReflect.Descriptor instead.
func (*KeywordPlanKeywordForecast) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{9}
}

func (x *KeywordPlanKeywordForecast) GetKeywordPlanAdGroupKeyword() *wrappers.StringValue {
	if x != nil {
		return x.KeywordPlanAdGroupKeyword
	}
	return nil
}

func (x *KeywordPlanKeywordForecast) GetKeywordForecast() *ForecastMetrics {
	if x != nil {
		return x.KeywordForecast
	}
	return nil
}

// Forecast metrics.
type ForecastMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Impressions
	Impressions *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// Ctr
	Ctr *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=ctr,proto3" json:"ctr,omitempty"`
	// AVG cpc
	AverageCpc *wrappers.Int64Value `protobuf:"bytes,3,opt,name=average_cpc,json=averageCpc,proto3" json:"average_cpc,omitempty"`
	// Clicks
	Clicks *wrappers.DoubleValue `protobuf:"bytes,5,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// Cost
	CostMicros *wrappers.Int64Value `protobuf:"bytes,6,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
}

func (x *ForecastMetrics) Reset() {
	*x = ForecastMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForecastMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForecastMetrics) ProtoMessage() {}

func (x *ForecastMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForecastMetrics.ProtoReflect.Descriptor instead.
func (*ForecastMetrics) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{10}
}

func (x *ForecastMetrics) GetImpressions() *wrappers.DoubleValue {
	if x != nil {
		return x.Impressions
	}
	return nil
}

func (x *ForecastMetrics) GetCtr() *wrappers.DoubleValue {
	if x != nil {
		return x.Ctr
	}
	return nil
}

func (x *ForecastMetrics) GetAverageCpc() *wrappers.Int64Value {
	if x != nil {
		return x.AverageCpc
	}
	return nil
}

func (x *ForecastMetrics) GetClicks() *wrappers.DoubleValue {
	if x != nil {
		return x.Clicks
	}
	return nil
}

func (x *ForecastMetrics) GetCostMicros() *wrappers.Int64Value {
	if x != nil {
		return x.CostMicros
	}
	return nil
}

// Request message for [KeywordPlanService.GenerateHistoricalMetrics][google.ads.googleads.v3.services.KeywordPlanService.GenerateHistoricalMetrics].
type GenerateHistoricalMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the keyword plan of which historical metrics are
	// requested.
	KeywordPlan string `protobuf:"bytes,1,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
}

func (x *GenerateHistoricalMetricsRequest) Reset() {
	*x = GenerateHistoricalMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateHistoricalMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateHistoricalMetricsRequest) ProtoMessage() {}

func (x *GenerateHistoricalMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateHistoricalMetricsRequest.ProtoReflect.Descriptor instead.
func (*GenerateHistoricalMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{11}
}

func (x *GenerateHistoricalMetricsRequest) GetKeywordPlan() string {
	if x != nil {
		return x.KeywordPlan
	}
	return ""
}

// Response message for [KeywordPlanService.GenerateHistoricalMetrics][google.ads.googleads.v3.services.KeywordPlanService.GenerateHistoricalMetrics].
type GenerateHistoricalMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of keyword historical metrics.
	Metrics []*KeywordPlanKeywordHistoricalMetrics `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *GenerateHistoricalMetricsResponse) Reset() {
	*x = GenerateHistoricalMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateHistoricalMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateHistoricalMetricsResponse) ProtoMessage() {}

func (x *GenerateHistoricalMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateHistoricalMetricsResponse.ProtoReflect.Descriptor instead.
func (*GenerateHistoricalMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{12}
}

func (x *GenerateHistoricalMetricsResponse) GetMetrics() []*KeywordPlanKeywordHistoricalMetrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// A keyword historical metrics.
type KeywordPlanKeywordHistoricalMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text of the query associated with one or more ad_group_keywords in the
	// plan.
	//
	// Note that we de-dupe your keywords list, eliminating close variants before
	// returning the plan's keywords as text. For example, if your plan originally
	// contained the keywords 'car' and 'cars', the returned search query will
	// only contain 'car'.
	SearchQuery *wrappers.StringValue `protobuf:"bytes,1,opt,name=search_query,json=searchQuery,proto3" json:"search_query,omitempty"`
	// The historical metrics for the query associated with one or more
	// ad_group_keywords in the plan.
	KeywordMetrics *common.KeywordPlanHistoricalMetrics `protobuf:"bytes,2,opt,name=keyword_metrics,json=keywordMetrics,proto3" json:"keyword_metrics,omitempty"`
}

func (x *KeywordPlanKeywordHistoricalMetrics) Reset() {
	*x = KeywordPlanKeywordHistoricalMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeywordPlanKeywordHistoricalMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeywordPlanKeywordHistoricalMetrics) ProtoMessage() {}

func (x *KeywordPlanKeywordHistoricalMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeywordPlanKeywordHistoricalMetrics.ProtoReflect.Descriptor instead.
func (*KeywordPlanKeywordHistoricalMetrics) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP(), []int{13}
}

func (x *KeywordPlanKeywordHistoricalMetrics) GetSearchQuery() *wrappers.StringValue {
	if x != nil {
		return x.SearchQuery
	}
	return nil
}

func (x *KeywordPlanKeywordHistoricalMetrics) GetKeywordMetrics() *common.KeywordPlanHistoricalMetrics {
	if x != nil {
		return x.KeywordMetrics
	}
	return nil
}

var File_google_ads_googleads_v3_services_keyword_plan_service_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a,
	0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
	0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x33, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63,
	0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x6a, 0x0a,
	0x15, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xec, 0x01, 0x0a, 0x19, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x5b, 0x0a,
	0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x8e, 0x02, 0x0a, 0x14, 0x4b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x48,
	0x0a, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x48, 0x00,
	0x52, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0x48, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x18, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x42, 0x0b, 0x0a, 0x09,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xba, 0x01, 0x0a, 0x1a, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x15, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x13, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x54, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x3f, 0x0a, 0x18, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x48, 0x0a, 0x1e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61,
	0x6e, 0x22, 0xe6, 0x02, 0x0a, 0x1f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6c, 0x0a, 0x12, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e,
	0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x52, 0x11, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x73, 0x74, 0x73, 0x12, 0x6a, 0x0a, 0x12, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x10, 0x61,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x12,
	0x69, 0x0a, 0x11, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x52, 0x10, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72,
	0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x73, 0x22, 0xcf, 0x01, 0x0a, 0x1b, 0x4b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x15, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x50, 0x6c, 0x61, 0x6e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x12, 0x5e, 0x0a, 0x11,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x10, 0x63, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x22, 0xcc, 0x01, 0x0a,
	0x1a, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x64, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x15, 0x6b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x61, 0x64, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72,
	0x64, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x5d, 0x0a, 0x11,
	0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x0f, 0x61, 0x64, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x22, 0xda, 0x01, 0x0a, 0x1a,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x1d, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x61, 0x64, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x19, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x64, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x5c, 0x0a, 0x10, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x0f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x22, 0xb3, 0x02, 0x0a, 0x0f, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x3e, 0x0a, 0x0b,
	0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x03,
	0x63, 0x74, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x63, 0x74, 0x72, 0x12, 0x3c, 0x0a, 0x0b,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x70, 0x63, 0x12, 0x34, 0x0a, 0x06, 0x63, 0x6c,
	0x69, 0x63, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73,
	0x12, 0x3c, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x22, 0x4a,
	0x0a, 0x20, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72,
	0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x22, 0x84, 0x01, 0x0a, 0x21, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61,
	0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5f, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61,
	0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x22, 0xcd, 0x01, 0x0a, 0x23, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61,
	0x6e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63,
	0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x3f, 0x0a, 0x0c, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x65, 0x0a, 0x0f, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x52, 0x0e, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x32, 0xea, 0x07, 0x0a, 0x12, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc1, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47,
	0x65, 0x74, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x50, 0x6c, 0x61, 0x6e, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76,
	0x33, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe6, 0x01, 0x0a,
	0x12, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c,
	0x61, 0x6e, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72,
	0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x31, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x3d, 0x2a, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x3a, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x16, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xff, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x22, 0x45,
	0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0c, 0x6b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x12, 0x87, 0x02, 0x0a, 0x19, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x61,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x22, 0x47, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x0c, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x1a, 0x1b, 0xca, 0x41, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0xfe,
	0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x42, 0x17, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x50, 0x6c, 0x61, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xa2, 0x02, 0x03, 0x47,
	0x41, 0x41, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x33, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41,
	0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x33, 0x5c,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64,
	0x73, 0x3a, 0x3a, 0x56, 0x33, 0x3a, 0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescData = file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDesc
)

func file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescData)
	})
	return file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDescData
}

var file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_ads_googleads_v3_services_keyword_plan_service_proto_goTypes = []interface{}{
	(*GetKeywordPlanRequest)(nil),               // 0: google.ads.googleads.v3.services.GetKeywordPlanRequest
	(*MutateKeywordPlansRequest)(nil),           // 1: google.ads.googleads.v3.services.MutateKeywordPlansRequest
	(*KeywordPlanOperation)(nil),                // 2: google.ads.googleads.v3.services.KeywordPlanOperation
	(*MutateKeywordPlansResponse)(nil),          // 3: google.ads.googleads.v3.services.MutateKeywordPlansResponse
	(*MutateKeywordPlansResult)(nil),            // 4: google.ads.googleads.v3.services.MutateKeywordPlansResult
	(*GenerateForecastMetricsRequest)(nil),      // 5: google.ads.googleads.v3.services.GenerateForecastMetricsRequest
	(*GenerateForecastMetricsResponse)(nil),     // 6: google.ads.googleads.v3.services.GenerateForecastMetricsResponse
	(*KeywordPlanCampaignForecast)(nil),         // 7: google.ads.googleads.v3.services.KeywordPlanCampaignForecast
	(*KeywordPlanAdGroupForecast)(nil),          // 8: google.ads.googleads.v3.services.KeywordPlanAdGroupForecast
	(*KeywordPlanKeywordForecast)(nil),          // 9: google.ads.googleads.v3.services.KeywordPlanKeywordForecast
	(*ForecastMetrics)(nil),                     // 10: google.ads.googleads.v3.services.ForecastMetrics
	(*GenerateHistoricalMetricsRequest)(nil),    // 11: google.ads.googleads.v3.services.GenerateHistoricalMetricsRequest
	(*GenerateHistoricalMetricsResponse)(nil),   // 12: google.ads.googleads.v3.services.GenerateHistoricalMetricsResponse
	(*KeywordPlanKeywordHistoricalMetrics)(nil), // 13: google.ads.googleads.v3.services.KeywordPlanKeywordHistoricalMetrics
	(*field_mask.FieldMask)(nil),                // 14: google.protobuf.FieldMask
	(*resources.KeywordPlan)(nil),               // 15: google.ads.googleads.v3.resources.KeywordPlan
	(*status.Status)(nil),                       // 16: google.rpc.Status
	(*wrappers.StringValue)(nil),                // 17: google.protobuf.StringValue
	(*wrappers.DoubleValue)(nil),                // 18: google.protobuf.DoubleValue
	(*wrappers.Int64Value)(nil),                 // 19: google.protobuf.Int64Value
	(*common.KeywordPlanHistoricalMetrics)(nil), // 20: google.ads.googleads.v3.common.KeywordPlanHistoricalMetrics
}
var file_google_ads_googleads_v3_services_keyword_plan_service_proto_depIdxs = []int32{
	2,  // 0: google.ads.googleads.v3.services.MutateKeywordPlansRequest.operations:type_name -> google.ads.googleads.v3.services.KeywordPlanOperation
	14, // 1: google.ads.googleads.v3.services.KeywordPlanOperation.update_mask:type_name -> google.protobuf.FieldMask
	15, // 2: google.ads.googleads.v3.services.KeywordPlanOperation.create:type_name -> google.ads.googleads.v3.resources.KeywordPlan
	15, // 3: google.ads.googleads.v3.services.KeywordPlanOperation.update:type_name -> google.ads.googleads.v3.resources.KeywordPlan
	16, // 4: google.ads.googleads.v3.services.MutateKeywordPlansResponse.partial_failure_error:type_name -> google.rpc.Status
	4,  // 5: google.ads.googleads.v3.services.MutateKeywordPlansResponse.results:type_name -> google.ads.googleads.v3.services.MutateKeywordPlansResult
	7,  // 6: google.ads.googleads.v3.services.GenerateForecastMetricsResponse.campaign_forecasts:type_name -> google.ads.googleads.v3.services.KeywordPlanCampaignForecast
	8,  // 7: google.ads.googleads.v3.services.GenerateForecastMetricsResponse.ad_group_forecasts:type_name -> google.ads.googleads.v3.services.KeywordPlanAdGroupForecast
	9,  // 8: google.ads.googleads.v3.services.GenerateForecastMetricsResponse.keyword_forecasts:type_name -> google.ads.googleads.v3.services.KeywordPlanKeywordForecast
	17, // 9: google.ads.googleads.v3.services.KeywordPlanCampaignForecast.keyword_plan_campaign:type_name -> google.protobuf.StringValue
	10, // 10: google.ads.googleads.v3.services.KeywordPlanCampaignForecast.campaign_forecast:type_name -> google.ads.googleads.v3.services.ForecastMetrics
	17, // 11: google.ads.googleads.v3.services.KeywordPlanAdGroupForecast.keyword_plan_ad_group:type_name -> google.protobuf.StringValue
	10, // 12: google.ads.googleads.v3.services.KeywordPlanAdGroupForecast.ad_group_forecast:type_name -> google.ads.googleads.v3.services.ForecastMetrics
	17, // 13: google.ads.googleads.v3.services.KeywordPlanKeywordForecast.keyword_plan_ad_group_keyword:type_name -> google.protobuf.StringValue
	10, // 14: google.ads.googleads.v3.services.KeywordPlanKeywordForecast.keyword_forecast:type_name -> google.ads.googleads.v3.services.ForecastMetrics
	18, // 15: google.ads.googleads.v3.services.ForecastMetrics.impressions:type_name -> google.protobuf.DoubleValue
	18, // 16: google.ads.googleads.v3.services.ForecastMetrics.ctr:type_name -> google.protobuf.DoubleValue
	19, // 17: google.ads.googleads.v3.services.ForecastMetrics.average_cpc:type_name -> google.protobuf.Int64Value
	18, // 18: google.ads.googleads.v3.services.ForecastMetrics.clicks:type_name -> google.protobuf.DoubleValue
	19, // 19: google.ads.googleads.v3.services.ForecastMetrics.cost_micros:type_name -> google.protobuf.Int64Value
	13, // 20: google.ads.googleads.v3.services.GenerateHistoricalMetricsResponse.metrics:type_name -> google.ads.googleads.v3.services.KeywordPlanKeywordHistoricalMetrics
	17, // 21: google.ads.googleads.v3.services.KeywordPlanKeywordHistoricalMetrics.search_query:type_name -> google.protobuf.StringValue
	20, // 22: google.ads.googleads.v3.services.KeywordPlanKeywordHistoricalMetrics.keyword_metrics:type_name -> google.ads.googleads.v3.common.KeywordPlanHistoricalMetrics
	0,  // 23: google.ads.googleads.v3.services.KeywordPlanService.GetKeywordPlan:input_type -> google.ads.googleads.v3.services.GetKeywordPlanRequest
	1,  // 24: google.ads.googleads.v3.services.KeywordPlanService.MutateKeywordPlans:input_type -> google.ads.googleads.v3.services.MutateKeywordPlansRequest
	5,  // 25: google.ads.googleads.v3.services.KeywordPlanService.GenerateForecastMetrics:input_type -> google.ads.googleads.v3.services.GenerateForecastMetricsRequest
	11, // 26: google.ads.googleads.v3.services.KeywordPlanService.GenerateHistoricalMetrics:input_type -> google.ads.googleads.v3.services.GenerateHistoricalMetricsRequest
	15, // 27: google.ads.googleads.v3.services.KeywordPlanService.GetKeywordPlan:output_type -> google.ads.googleads.v3.resources.KeywordPlan
	3,  // 28: google.ads.googleads.v3.services.KeywordPlanService.MutateKeywordPlans:output_type -> google.ads.googleads.v3.services.MutateKeywordPlansResponse
	6,  // 29: google.ads.googleads.v3.services.KeywordPlanService.GenerateForecastMetrics:output_type -> google.ads.googleads.v3.services.GenerateForecastMetricsResponse
	12, // 30: google.ads.googleads.v3.services.KeywordPlanService.GenerateHistoricalMetrics:output_type -> google.ads.googleads.v3.services.GenerateHistoricalMetricsResponse
	27, // [27:31] is the sub-list for method output_type
	23, // [23:27] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v3_services_keyword_plan_service_proto_init() }
func file_google_ads_googleads_v3_services_keyword_plan_service_proto_init() {
	if File_google_ads_googleads_v3_services_keyword_plan_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetKeywordPlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateKeywordPlansRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateKeywordPlansResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateKeywordPlansResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateForecastMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateForecastMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanCampaignForecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanAdGroupForecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanKeywordForecast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForecastMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateHistoricalMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateHistoricalMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeywordPlanKeywordHistoricalMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*KeywordPlanOperation_Create)(nil),
		(*KeywordPlanOperation_Update)(nil),
		(*KeywordPlanOperation_Remove)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ads_googleads_v3_services_keyword_plan_service_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v3_services_keyword_plan_service_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v3_services_keyword_plan_service_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v3_services_keyword_plan_service_proto = out.File
	file_google_ads_googleads_v3_services_keyword_plan_service_proto_rawDesc = nil
	file_google_ads_googleads_v3_services_keyword_plan_service_proto_goTypes = nil
	file_google_ads_googleads_v3_services_keyword_plan_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// KeywordPlanServiceClient is the client API for KeywordPlanService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KeywordPlanServiceClient interface {
	// Returns the requested plan in full detail.
	GetKeywordPlan(ctx context.Context, in *GetKeywordPlanRequest, opts ...grpc.CallOption) (*resources.KeywordPlan, error)
	// Creates, updates, or removes keyword plans. Operation statuses are
	// returned.
	MutateKeywordPlans(ctx context.Context, in *MutateKeywordPlansRequest, opts ...grpc.CallOption) (*MutateKeywordPlansResponse, error)
	// Returns the requested Keyword Plan forecasts.
	GenerateForecastMetrics(ctx context.Context, in *GenerateForecastMetricsRequest, opts ...grpc.CallOption) (*GenerateForecastMetricsResponse, error)
	// Returns the requested Keyword Plan historical metrics.
	GenerateHistoricalMetrics(ctx context.Context, in *GenerateHistoricalMetricsRequest, opts ...grpc.CallOption) (*GenerateHistoricalMetricsResponse, error)
}

type keywordPlanServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewKeywordPlanServiceClient(cc grpc.ClientConnInterface) KeywordPlanServiceClient {
	return &keywordPlanServiceClient{cc}
}

func (c *keywordPlanServiceClient) GetKeywordPlan(ctx context.Context, in *GetKeywordPlanRequest, opts ...grpc.CallOption) (*resources.KeywordPlan, error) {
	out := new(resources.KeywordPlan)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.KeywordPlanService/GetKeywordPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) MutateKeywordPlans(ctx context.Context, in *MutateKeywordPlansRequest, opts ...grpc.CallOption) (*MutateKeywordPlansResponse, error) {
	out := new(MutateKeywordPlansResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.KeywordPlanService/MutateKeywordPlans", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) GenerateForecastMetrics(ctx context.Context, in *GenerateForecastMetricsRequest, opts ...grpc.CallOption) (*GenerateForecastMetricsResponse, error) {
	out := new(GenerateForecastMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.KeywordPlanService/GenerateForecastMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keywordPlanServiceClient) GenerateHistoricalMetrics(ctx context.Context, in *GenerateHistoricalMetricsRequest, opts ...grpc.CallOption) (*GenerateHistoricalMetricsResponse, error) {
	out := new(GenerateHistoricalMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.KeywordPlanService/GenerateHistoricalMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeywordPlanServiceServer is the server API for KeywordPlanService service.
type KeywordPlanServiceServer interface {
	// Returns the requested plan in full detail.
	GetKeywordPlan(context.Context, *GetKeywordPlanRequest) (*resources.KeywordPlan, error)
	// Creates, updates, or removes keyword plans. Operation statuses are
	// returned.
	MutateKeywordPlans(context.Context, *MutateKeywordPlansRequest) (*MutateKeywordPlansResponse, error)
	// Returns the requested Keyword Plan forecasts.
	GenerateForecastMetrics(context.Context, *GenerateForecastMetricsRequest) (*GenerateForecastMetricsResponse, error)
	// Returns the requested Keyword Plan historical metrics.
	GenerateHistoricalMetrics(context.Context, *GenerateHistoricalMetricsRequest) (*GenerateHistoricalMetricsResponse, error)
}

// UnimplementedKeywordPlanServiceServer can be embedded to have forward compatible implementations.
type UnimplementedKeywordPlanServiceServer struct {
}

func (*UnimplementedKeywordPlanServiceServer) GetKeywordPlan(context.Context, *GetKeywordPlanRequest) (*resources.KeywordPlan, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetKeywordPlan not implemented")
}
func (*UnimplementedKeywordPlanServiceServer) MutateKeywordPlans(context.Context, *MutateKeywordPlansRequest) (*MutateKeywordPlansResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateKeywordPlans not implemented")
}
func (*UnimplementedKeywordPlanServiceServer) GenerateForecastMetrics(context.Context, *GenerateForecastMetricsRequest) (*GenerateForecastMetricsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GenerateForecastMetrics not implemented")
}
func (*UnimplementedKeywordPlanServiceServer) GenerateHistoricalMetrics(context.Context, *GenerateHistoricalMetricsRequest) (*GenerateHistoricalMetricsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GenerateHistoricalMetrics not implemented")
}

func RegisterKeywordPlanServiceServer(s *grpc.Server, srv KeywordPlanServiceServer) {
	s.RegisterService(&_KeywordPlanService_serviceDesc, srv)
}

func _KeywordPlanService_GetKeywordPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeywordPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GetKeywordPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.KeywordPlanService/GetKeywordPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GetKeywordPlan(ctx, req.(*GetKeywordPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_MutateKeywordPlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateKeywordPlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).MutateKeywordPlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.KeywordPlanService/MutateKeywordPlans",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).MutateKeywordPlans(ctx, req.(*MutateKeywordPlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_GenerateForecastMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateForecastMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GenerateForecastMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.KeywordPlanService/GenerateForecastMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GenerateForecastMetrics(ctx, req.(*GenerateForecastMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeywordPlanService_GenerateHistoricalMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateHistoricalMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeywordPlanServiceServer).GenerateHistoricalMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.KeywordPlanService/GenerateHistoricalMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeywordPlanServiceServer).GenerateHistoricalMetrics(ctx, req.(*GenerateHistoricalMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _KeywordPlanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.KeywordPlanService",
	HandlerType: (*KeywordPlanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetKeywordPlan",
			Handler:    _KeywordPlanService_GetKeywordPlan_Handler,
		},
		{
			MethodName: "MutateKeywordPlans",
			Handler:    _KeywordPlanService_MutateKeywordPlans_Handler,
		},
		{
			MethodName: "GenerateForecastMetrics",
			Handler:    _KeywordPlanService_GenerateForecastMetrics_Handler,
		},
		{
			MethodName: "GenerateHistoricalMetrics",
			Handler:    _KeywordPlanService_GenerateHistoricalMetrics_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/keyword_plan_service.proto",
}
