// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/billing/v1/cloud_catalog.proto

package billing

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	money "google.golang.org/genproto/googleapis/type/money"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The level at which usage is aggregated to compute cost.
// Example: "ACCOUNT" aggregation level indicates that usage for tiered
// pricing is aggregated across all projects in a single account.
type AggregationInfo_AggregationLevel int32

const (
	AggregationInfo_AGGREGATION_LEVEL_UNSPECIFIED AggregationInfo_AggregationLevel = 0
	AggregationInfo_ACCOUNT                       AggregationInfo_AggregationLevel = 1
	AggregationInfo_PROJECT                       AggregationInfo_AggregationLevel = 2
)

var AggregationInfo_AggregationLevel_name = map[int32]string{
	0: "AGGREGATION_LEVEL_UNSPECIFIED",
	1: "ACCOUNT",
	2: "PROJECT",
}

var AggregationInfo_AggregationLevel_value = map[string]int32{
	"AGGREGATION_LEVEL_UNSPECIFIED": 0,
	"ACCOUNT":                       1,
	"PROJECT":                       2,
}

func (x AggregationInfo_AggregationLevel) String() string {
	return proto.EnumName(AggregationInfo_AggregationLevel_name, int32(x))
}

func (AggregationInfo_AggregationLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{5, 0}
}

// The interval at which usage is aggregated to compute cost.
// Example: "MONTHLY" aggregation interval indicates that usage for tiered
// pricing is aggregated every month.
type AggregationInfo_AggregationInterval int32

const (
	AggregationInfo_AGGREGATION_INTERVAL_UNSPECIFIED AggregationInfo_AggregationInterval = 0
	AggregationInfo_DAILY                            AggregationInfo_AggregationInterval = 1
	AggregationInfo_MONTHLY                          AggregationInfo_AggregationInterval = 2
)

var AggregationInfo_AggregationInterval_name = map[int32]string{
	0: "AGGREGATION_INTERVAL_UNSPECIFIED",
	1: "DAILY",
	2: "MONTHLY",
}

var AggregationInfo_AggregationInterval_value = map[string]int32{
	"AGGREGATION_INTERVAL_UNSPECIFIED": 0,
	"DAILY":                            1,
	"MONTHLY":                          2,
}

func (x AggregationInfo_AggregationInterval) String() string {
	return proto.EnumName(AggregationInfo_AggregationInterval_name, int32(x))
}

func (AggregationInfo_AggregationInterval) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{5, 1}
}

// Encapsulates a single service in Google Cloud Platform.
type Service struct {
	// The resource name for the service.
	// Example: "services/DA34-426B-A397"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The identifier for the service.
	// Example: "DA34-426B-A397"
	ServiceId string `protobuf:"bytes,2,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	// A human readable display name for this service.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The business under which the service is offered.
	// Ex. "businessEntities/GCP", "businessEntities/Maps"
	BusinessEntityName   string   `protobuf:"bytes,4,opt,name=business_entity_name,json=businessEntityName,proto3" json:"business_entity_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{0}
}

func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (m *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(m, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Service) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *Service) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Service) GetBusinessEntityName() string {
	if m != nil {
		return m.BusinessEntityName
	}
	return ""
}

// Encapsulates a single SKU in Google Cloud Platform
type Sku struct {
	// The resource name for the SKU.
	// Example: "services/DA34-426B-A397/skus/AA95-CD31-42FE"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The identifier for the SKU.
	// Example: "AA95-CD31-42FE"
	SkuId string `protobuf:"bytes,2,opt,name=sku_id,json=skuId,proto3" json:"sku_id,omitempty"`
	// A human readable description of the SKU, has a maximum length of 256
	// characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The category hierarchy of this SKU, purely for organizational purpose.
	Category *Category `protobuf:"bytes,4,opt,name=category,proto3" json:"category,omitempty"`
	// List of service regions this SKU is offered at.
	// Example: "asia-east1"
	// Service regions can be found at https://cloud.google.com/about/locations/
	ServiceRegions []string `protobuf:"bytes,5,rep,name=service_regions,json=serviceRegions,proto3" json:"service_regions,omitempty"`
	// A timeline of pricing info for this SKU in chronological order.
	PricingInfo []*PricingInfo `protobuf:"bytes,6,rep,name=pricing_info,json=pricingInfo,proto3" json:"pricing_info,omitempty"`
	// Identifies the service provider.
	// This is 'Google' for first party services in Google Cloud Platform.
	ServiceProviderName  string   `protobuf:"bytes,7,opt,name=service_provider_name,json=serviceProviderName,proto3" json:"service_provider_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Sku) Reset()         { *m = Sku{} }
func (m *Sku) String() string { return proto.CompactTextString(m) }
func (*Sku) ProtoMessage()    {}
func (*Sku) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{1}
}

func (m *Sku) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Sku.Unmarshal(m, b)
}
func (m *Sku) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Sku.Marshal(b, m, deterministic)
}
func (m *Sku) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sku.Merge(m, src)
}
func (m *Sku) XXX_Size() int {
	return xxx_messageInfo_Sku.Size(m)
}
func (m *Sku) XXX_DiscardUnknown() {
	xxx_messageInfo_Sku.DiscardUnknown(m)
}

var xxx_messageInfo_Sku proto.InternalMessageInfo

func (m *Sku) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Sku) GetSkuId() string {
	if m != nil {
		return m.SkuId
	}
	return ""
}

func (m *Sku) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Sku) GetCategory() *Category {
	if m != nil {
		return m.Category
	}
	return nil
}

func (m *Sku) GetServiceRegions() []string {
	if m != nil {
		return m.ServiceRegions
	}
	return nil
}

func (m *Sku) GetPricingInfo() []*PricingInfo {
	if m != nil {
		return m.PricingInfo
	}
	return nil
}

func (m *Sku) GetServiceProviderName() string {
	if m != nil {
		return m.ServiceProviderName
	}
	return ""
}

// Represents the category hierarchy of a SKU.
type Category struct {
	// The display name of the service this SKU belongs to.
	ServiceDisplayName string `protobuf:"bytes,1,opt,name=service_display_name,json=serviceDisplayName,proto3" json:"service_display_name,omitempty"`
	// The type of product the SKU refers to.
	// Example: "Compute", "Storage", "Network", "ApplicationServices" etc.
	ResourceFamily string `protobuf:"bytes,2,opt,name=resource_family,json=resourceFamily,proto3" json:"resource_family,omitempty"`
	// A group classification for related SKUs.
	// Example: "RAM", "GPU", "Prediction", "Ops", "GoogleEgress" etc.
	ResourceGroup string `protobuf:"bytes,3,opt,name=resource_group,json=resourceGroup,proto3" json:"resource_group,omitempty"`
	// Represents how the SKU is consumed.
	// Example: "OnDemand", "Preemptible", "Commit1Mo", "Commit1Yr" etc.
	UsageType            string   `protobuf:"bytes,4,opt,name=usage_type,json=usageType,proto3" json:"usage_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Category) Reset()         { *m = Category{} }
func (m *Category) String() string { return proto.CompactTextString(m) }
func (*Category) ProtoMessage()    {}
func (*Category) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{2}
}

func (m *Category) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Category.Unmarshal(m, b)
}
func (m *Category) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Category.Marshal(b, m, deterministic)
}
func (m *Category) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Category.Merge(m, src)
}
func (m *Category) XXX_Size() int {
	return xxx_messageInfo_Category.Size(m)
}
func (m *Category) XXX_DiscardUnknown() {
	xxx_messageInfo_Category.DiscardUnknown(m)
}

var xxx_messageInfo_Category proto.InternalMessageInfo

func (m *Category) GetServiceDisplayName() string {
	if m != nil {
		return m.ServiceDisplayName
	}
	return ""
}

func (m *Category) GetResourceFamily() string {
	if m != nil {
		return m.ResourceFamily
	}
	return ""
}

func (m *Category) GetResourceGroup() string {
	if m != nil {
		return m.ResourceGroup
	}
	return ""
}

func (m *Category) GetUsageType() string {
	if m != nil {
		return m.UsageType
	}
	return ""
}

// Represents the pricing information for a SKU at a single point of time.
type PricingInfo struct {
	// The timestamp from which this pricing was effective within the requested
	// time range. This is guaranteed to be greater than or equal to the
	// start_time field in the request and less than the end_time field in the
	// request. If a time range was not specified in the request this field will
	// be equivalent to a time within the last 12 hours, indicating the latest
	// pricing info.
	EffectiveTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=effective_time,json=effectiveTime,proto3" json:"effective_time,omitempty"`
	// An optional human readable summary of the pricing information, has a
	// maximum length of 256 characters.
	Summary string `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	// Expresses the pricing formula. See `PricingExpression` for an example.
	PricingExpression *PricingExpression `protobuf:"bytes,3,opt,name=pricing_expression,json=pricingExpression,proto3" json:"pricing_expression,omitempty"`
	// Aggregation Info. This can be left unspecified if the pricing expression
	// doesn't require aggregation.
	AggregationInfo *AggregationInfo `protobuf:"bytes,4,opt,name=aggregation_info,json=aggregationInfo,proto3" json:"aggregation_info,omitempty"`
	// Conversion rate used for currency conversion, from USD to the currency
	// specified in the request. This includes any surcharge collected for billing
	// in non USD currency. If a currency is not specified in the request this
	// defaults to 1.0.
	// Example: USD * currency_conversion_rate = JPY
	CurrencyConversionRate float64  `protobuf:"fixed64,5,opt,name=currency_conversion_rate,json=currencyConversionRate,proto3" json:"currency_conversion_rate,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *PricingInfo) Reset()         { *m = PricingInfo{} }
func (m *PricingInfo) String() string { return proto.CompactTextString(m) }
func (*PricingInfo) ProtoMessage()    {}
func (*PricingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{3}
}

func (m *PricingInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PricingInfo.Unmarshal(m, b)
}
func (m *PricingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PricingInfo.Marshal(b, m, deterministic)
}
func (m *PricingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PricingInfo.Merge(m, src)
}
func (m *PricingInfo) XXX_Size() int {
	return xxx_messageInfo_PricingInfo.Size(m)
}
func (m *PricingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_PricingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_PricingInfo proto.InternalMessageInfo

func (m *PricingInfo) GetEffectiveTime() *timestamp.Timestamp {
	if m != nil {
		return m.EffectiveTime
	}
	return nil
}

func (m *PricingInfo) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *PricingInfo) GetPricingExpression() *PricingExpression {
	if m != nil {
		return m.PricingExpression
	}
	return nil
}

func (m *PricingInfo) GetAggregationInfo() *AggregationInfo {
	if m != nil {
		return m.AggregationInfo
	}
	return nil
}

func (m *PricingInfo) GetCurrencyConversionRate() float64 {
	if m != nil {
		return m.CurrencyConversionRate
	}
	return 0
}

// Expresses a mathematical pricing formula. For Example:-
//
// `usage_unit: GBy`
// `tiered_rates:`
//    `[start_usage_amount: 20, unit_price: $10]`
//    `[start_usage_amount: 100, unit_price: $5]`
//
// The above expresses a pricing formula where the first 20GB is free, the
// next 80GB is priced at $10 per GB followed by $5 per GB for additional
// usage.
type PricingExpression struct {
	// The short hand for unit of usage this pricing is specified in.
	// Example: usage_unit of "GiBy" means that usage is specified in "Gibi Byte".
	UsageUnit string `protobuf:"bytes,1,opt,name=usage_unit,json=usageUnit,proto3" json:"usage_unit,omitempty"`
	// The unit of usage in human readable form.
	// Example: "gibi byte".
	UsageUnitDescription string `protobuf:"bytes,4,opt,name=usage_unit_description,json=usageUnitDescription,proto3" json:"usage_unit_description,omitempty"`
	// The base unit for the SKU which is the unit used in usage exports.
	// Example: "By"
	BaseUnit string `protobuf:"bytes,5,opt,name=base_unit,json=baseUnit,proto3" json:"base_unit,omitempty"`
	// The base unit in human readable form.
	// Example: "byte".
	BaseUnitDescription string `protobuf:"bytes,6,opt,name=base_unit_description,json=baseUnitDescription,proto3" json:"base_unit_description,omitempty"`
	// Conversion factor for converting from price per usage_unit to price per
	// base_unit, and start_usage_amount to start_usage_amount in base_unit.
	// unit_price / base_unit_conversion_factor = price per base_unit.
	// start_usage_amount * base_unit_conversion_factor = start_usage_amount in
	// base_unit.
	BaseUnitConversionFactor float64 `protobuf:"fixed64,7,opt,name=base_unit_conversion_factor,json=baseUnitConversionFactor,proto3" json:"base_unit_conversion_factor,omitempty"`
	// The recommended quantity of units for displaying pricing info. When
	// displaying pricing info it is recommended to display:
	// (unit_price * display_quantity) per display_quantity usage_unit.
	// This field does not affect the pricing formula and is for display purposes
	// only.
	// Example: If the unit_price is "0.0001 USD", the usage_unit is "GB" and
	// the display_quantity is "1000" then the recommended way of displaying the
	// pricing info is "0.10 USD per 1000 GB"
	DisplayQuantity float64 `protobuf:"fixed64,2,opt,name=display_quantity,json=displayQuantity,proto3" json:"display_quantity,omitempty"`
	// The list of tiered rates for this pricing. The total cost is computed by
	// applying each of the tiered rates on usage. This repeated list is sorted
	// by ascending order of start_usage_amount.
	TieredRates          []*PricingExpression_TierRate `protobuf:"bytes,3,rep,name=tiered_rates,json=tieredRates,proto3" json:"tiered_rates,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *PricingExpression) Reset()         { *m = PricingExpression{} }
func (m *PricingExpression) String() string { return proto.CompactTextString(m) }
func (*PricingExpression) ProtoMessage()    {}
func (*PricingExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{4}
}

func (m *PricingExpression) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PricingExpression.Unmarshal(m, b)
}
func (m *PricingExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PricingExpression.Marshal(b, m, deterministic)
}
func (m *PricingExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PricingExpression.Merge(m, src)
}
func (m *PricingExpression) XXX_Size() int {
	return xxx_messageInfo_PricingExpression.Size(m)
}
func (m *PricingExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_PricingExpression.DiscardUnknown(m)
}

var xxx_messageInfo_PricingExpression proto.InternalMessageInfo

func (m *PricingExpression) GetUsageUnit() string {
	if m != nil {
		return m.UsageUnit
	}
	return ""
}

func (m *PricingExpression) GetUsageUnitDescription() string {
	if m != nil {
		return m.UsageUnitDescription
	}
	return ""
}

func (m *PricingExpression) GetBaseUnit() string {
	if m != nil {
		return m.BaseUnit
	}
	return ""
}

func (m *PricingExpression) GetBaseUnitDescription() string {
	if m != nil {
		return m.BaseUnitDescription
	}
	return ""
}

func (m *PricingExpression) GetBaseUnitConversionFactor() float64 {
	if m != nil {
		return m.BaseUnitConversionFactor
	}
	return 0
}

func (m *PricingExpression) GetDisplayQuantity() float64 {
	if m != nil {
		return m.DisplayQuantity
	}
	return 0
}

func (m *PricingExpression) GetTieredRates() []*PricingExpression_TierRate {
	if m != nil {
		return m.TieredRates
	}
	return nil
}

// The price rate indicating starting usage and its corresponding price.
type PricingExpression_TierRate struct {
	// Usage is priced at this rate only after this amount.
	// Example: start_usage_amount of 10 indicates that the usage will be priced
	// at the unit_price after the first 10 usage_units.
	StartUsageAmount float64 `protobuf:"fixed64,1,opt,name=start_usage_amount,json=startUsageAmount,proto3" json:"start_usage_amount,omitempty"`
	// The price per unit of usage.
	// Example: unit_price of amount $10 indicates that each unit will cost $10.
	UnitPrice            *money.Money `protobuf:"bytes,2,opt,name=unit_price,json=unitPrice,proto3" json:"unit_price,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PricingExpression_TierRate) Reset()         { *m = PricingExpression_TierRate{} }
func (m *PricingExpression_TierRate) String() string { return proto.CompactTextString(m) }
func (*PricingExpression_TierRate) ProtoMessage()    {}
func (*PricingExpression_TierRate) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{4, 0}
}

func (m *PricingExpression_TierRate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PricingExpression_TierRate.Unmarshal(m, b)
}
func (m *PricingExpression_TierRate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PricingExpression_TierRate.Marshal(b, m, deterministic)
}
func (m *PricingExpression_TierRate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PricingExpression_TierRate.Merge(m, src)
}
func (m *PricingExpression_TierRate) XXX_Size() int {
	return xxx_messageInfo_PricingExpression_TierRate.Size(m)
}
func (m *PricingExpression_TierRate) XXX_DiscardUnknown() {
	xxx_messageInfo_PricingExpression_TierRate.DiscardUnknown(m)
}

var xxx_messageInfo_PricingExpression_TierRate proto.InternalMessageInfo

func (m *PricingExpression_TierRate) GetStartUsageAmount() float64 {
	if m != nil {
		return m.StartUsageAmount
	}
	return 0
}

func (m *PricingExpression_TierRate) GetUnitPrice() *money.Money {
	if m != nil {
		return m.UnitPrice
	}
	return nil
}

// Represents the aggregation level and interval for pricing of a single SKU.
type AggregationInfo struct {
	AggregationLevel    AggregationInfo_AggregationLevel    `protobuf:"varint,1,opt,name=aggregation_level,json=aggregationLevel,proto3,enum=google.cloud.billing.v1.AggregationInfo_AggregationLevel" json:"aggregation_level,omitempty"`
	AggregationInterval AggregationInfo_AggregationInterval `protobuf:"varint,2,opt,name=aggregation_interval,json=aggregationInterval,proto3,enum=google.cloud.billing.v1.AggregationInfo_AggregationInterval" json:"aggregation_interval,omitempty"`
	// The number of intervals to aggregate over.
	// Example: If aggregation_level is "DAILY" and aggregation_count is 14,
	// aggregation will be over 14 days.
	AggregationCount     int32    `protobuf:"varint,3,opt,name=aggregation_count,json=aggregationCount,proto3" json:"aggregation_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AggregationInfo) Reset()         { *m = AggregationInfo{} }
func (m *AggregationInfo) String() string { return proto.CompactTextString(m) }
func (*AggregationInfo) ProtoMessage()    {}
func (*AggregationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{5}
}

func (m *AggregationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AggregationInfo.Unmarshal(m, b)
}
func (m *AggregationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AggregationInfo.Marshal(b, m, deterministic)
}
func (m *AggregationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AggregationInfo.Merge(m, src)
}
func (m *AggregationInfo) XXX_Size() int {
	return xxx_messageInfo_AggregationInfo.Size(m)
}
func (m *AggregationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AggregationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AggregationInfo proto.InternalMessageInfo

func (m *AggregationInfo) GetAggregationLevel() AggregationInfo_AggregationLevel {
	if m != nil {
		return m.AggregationLevel
	}
	return AggregationInfo_AGGREGATION_LEVEL_UNSPECIFIED
}

func (m *AggregationInfo) GetAggregationInterval() AggregationInfo_AggregationInterval {
	if m != nil {
		return m.AggregationInterval
	}
	return AggregationInfo_AGGREGATION_INTERVAL_UNSPECIFIED
}

func (m *AggregationInfo) GetAggregationCount() int32 {
	if m != nil {
		return m.AggregationCount
	}
	return 0
}

// Request message for `ListServices`.
type ListServicesRequest struct {
	// Requested page size. Defaults to 5000.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results to return. This should be a
	// `next_page_token` value returned from a previous `ListServices`
	// call. If unspecified, the first page of results is returned.
	PageToken            string   `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServicesRequest) Reset()         { *m = ListServicesRequest{} }
func (m *ListServicesRequest) String() string { return proto.CompactTextString(m) }
func (*ListServicesRequest) ProtoMessage()    {}
func (*ListServicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{6}
}

func (m *ListServicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServicesRequest.Unmarshal(m, b)
}
func (m *ListServicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServicesRequest.Marshal(b, m, deterministic)
}
func (m *ListServicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServicesRequest.Merge(m, src)
}
func (m *ListServicesRequest) XXX_Size() int {
	return xxx_messageInfo_ListServicesRequest.Size(m)
}
func (m *ListServicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServicesRequest proto.InternalMessageInfo

func (m *ListServicesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServicesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for `ListServices`.
type ListServicesResponse struct {
	// A list of services.
	Services []*Service `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	// A token to retrieve the next page of results. To retrieve the next page,
	// call `ListServices` again with the `page_token` field set to this
	// value. This field is empty if there are no more results to retrieve.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServicesResponse) Reset()         { *m = ListServicesResponse{} }
func (m *ListServicesResponse) String() string { return proto.CompactTextString(m) }
func (*ListServicesResponse) ProtoMessage()    {}
func (*ListServicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{7}
}

func (m *ListServicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServicesResponse.Unmarshal(m, b)
}
func (m *ListServicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServicesResponse.Marshal(b, m, deterministic)
}
func (m *ListServicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServicesResponse.Merge(m, src)
}
func (m *ListServicesResponse) XXX_Size() int {
	return xxx_messageInfo_ListServicesResponse.Size(m)
}
func (m *ListServicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServicesResponse proto.InternalMessageInfo

func (m *ListServicesResponse) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *ListServicesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for `ListSkus`.
type ListSkusRequest struct {
	// The name of the service.
	// Example: "services/DA34-426B-A397"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional inclusive start time of the time range for which the pricing
	// versions will be returned. Timestamps in the future are not allowed.
	// The time range has to be within a single calendar month in
	// America/Los_Angeles timezone. Time range as a whole is optional. If not
	// specified, the latest pricing will be returned (up to 12 hours old at
	// most).
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional exclusive end time of the time range for which the pricing
	// versions will be returned. Timestamps in the future are not allowed.
	// The time range has to be within a single calendar month in
	// America/Los_Angeles timezone. Time range as a whole is optional. If not
	// specified, the latest pricing will be returned (up to 12 hours old at
	// most).
	EndTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The ISO 4217 currency code for the pricing info in the response proto.
	// Will use the conversion rate as of start_time.
	// Optional. If not specified USD will be used.
	CurrencyCode string `protobuf:"bytes,4,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Requested page size. Defaults to 5000.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results to return. This should be a
	// `next_page_token` value returned from a previous `ListSkus`
	// call. If unspecified, the first page of results is returned.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSkusRequest) Reset()         { *m = ListSkusRequest{} }
func (m *ListSkusRequest) String() string { return proto.CompactTextString(m) }
func (*ListSkusRequest) ProtoMessage()    {}
func (*ListSkusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{8}
}

func (m *ListSkusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSkusRequest.Unmarshal(m, b)
}
func (m *ListSkusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSkusRequest.Marshal(b, m, deterministic)
}
func (m *ListSkusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSkusRequest.Merge(m, src)
}
func (m *ListSkusRequest) XXX_Size() int {
	return xxx_messageInfo_ListSkusRequest.Size(m)
}
func (m *ListSkusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSkusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSkusRequest proto.InternalMessageInfo

func (m *ListSkusRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSkusRequest) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ListSkusRequest) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *ListSkusRequest) GetCurrencyCode() string {
	if m != nil {
		return m.CurrencyCode
	}
	return ""
}

func (m *ListSkusRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSkusRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for `ListSkus`.
type ListSkusResponse struct {
	// The list of public SKUs of the given service.
	Skus []*Sku `protobuf:"bytes,1,rep,name=skus,proto3" json:"skus,omitempty"`
	// A token to retrieve the next page of results. To retrieve the next page,
	// call `ListSkus` again with the `page_token` field set to this
	// value. This field is empty if there are no more results to retrieve.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSkusResponse) Reset()         { *m = ListSkusResponse{} }
func (m *ListSkusResponse) String() string { return proto.CompactTextString(m) }
func (*ListSkusResponse) ProtoMessage()    {}
func (*ListSkusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ca652323baa1561, []int{9}
}

func (m *ListSkusResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSkusResponse.Unmarshal(m, b)
}
func (m *ListSkusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSkusResponse.Marshal(b, m, deterministic)
}
func (m *ListSkusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSkusResponse.Merge(m, src)
}
func (m *ListSkusResponse) XXX_Size() int {
	return xxx_messageInfo_ListSkusResponse.Size(m)
}
func (m *ListSkusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSkusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSkusResponse proto.InternalMessageInfo

func (m *ListSkusResponse) GetSkus() []*Sku {
	if m != nil {
		return m.Skus
	}
	return nil
}

func (m *ListSkusResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.billing.v1.AggregationInfo_AggregationLevel", AggregationInfo_AggregationLevel_name, AggregationInfo_AggregationLevel_value)
	proto.RegisterEnum("google.cloud.billing.v1.AggregationInfo_AggregationInterval", AggregationInfo_AggregationInterval_name, AggregationInfo_AggregationInterval_value)
	proto.RegisterType((*Service)(nil), "google.cloud.billing.v1.Service")
	proto.RegisterType((*Sku)(nil), "google.cloud.billing.v1.Sku")
	proto.RegisterType((*Category)(nil), "google.cloud.billing.v1.Category")
	proto.RegisterType((*PricingInfo)(nil), "google.cloud.billing.v1.PricingInfo")
	proto.RegisterType((*PricingExpression)(nil), "google.cloud.billing.v1.PricingExpression")
	proto.RegisterType((*PricingExpression_TierRate)(nil), "google.cloud.billing.v1.PricingExpression.TierRate")
	proto.RegisterType((*AggregationInfo)(nil), "google.cloud.billing.v1.AggregationInfo")
	proto.RegisterType((*ListServicesRequest)(nil), "google.cloud.billing.v1.ListServicesRequest")
	proto.RegisterType((*ListServicesResponse)(nil), "google.cloud.billing.v1.ListServicesResponse")
	proto.RegisterType((*ListSkusRequest)(nil), "google.cloud.billing.v1.ListSkusRequest")
	proto.RegisterType((*ListSkusResponse)(nil), "google.cloud.billing.v1.ListSkusResponse")
}

func init() {
	proto.RegisterFile("google/cloud/billing/v1/cloud_catalog.proto", fileDescriptor_4ca652323baa1561)
}

var fileDescriptor_4ca652323baa1561 = []byte{
	// 1362 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0xcb, 0x6e, 0xdb, 0xc6,
	0x1a, 0x3e, 0x94, 0x22, 0x5b, 0xfa, 0xe5, 0x8b, 0x3c, 0x76, 0x12, 0x41, 0x4e, 0xce, 0x51, 0x74,
	0x72, 0x4e, 0x9c, 0x9b, 0x18, 0x2b, 0x2d, 0xd0, 0xb4, 0x49, 0x01, 0x45, 0x56, 0x54, 0x15, 0x8a,
	0xad, 0xd0, 0xb2, 0x81, 0x74, 0x43, 0x8c, 0xa9, 0x11, 0x43, 0x88, 0x22, 0x19, 0xce, 0x50, 0x89,
	0xd2, 0x76, 0xd1, 0x02, 0x7d, 0x80, 0xa2, 0x40, 0x1f, 0xa0, 0xcb, 0xf6, 0x01, 0xba, 0xea, 0x0b,
	0x74, 0xd9, 0xf6, 0x11, 0xba, 0x28, 0xd0, 0x57, 0xe8, 0xa2, 0x98, 0xe1, 0x8c, 0x6e, 0x8e, 0x12,
	0xa3, 0x3b, 0xf1, 0xfb, 0xaf, 0xf3, 0xfd, 0xdf, 0xfc, 0xa4, 0xe0, 0xa6, 0xed, 0xfb, 0xb6, 0x4b,
	0x74, 0xcb, 0xf5, 0xa3, 0xae, 0x7e, 0xe2, 0xb8, 0xae, 0xe3, 0xd9, 0xfa, 0x70, 0x37, 0x06, 0x4c,
	0x0b, 0x33, 0xec, 0xfa, 0x76, 0x39, 0x08, 0x7d, 0xe6, 0xa3, 0x8b, 0xb1, 0x73, 0x59, 0xd8, 0xca,
	0xd2, 0xb9, 0x3c, 0xdc, 0x2d, 0x5c, 0x92, 0x59, 0x70, 0xe0, 0xe8, 0xd8, 0xf3, 0x7c, 0x86, 0x99,
	0xe3, 0x7b, 0x34, 0x0e, 0x2b, 0xfc, 0x47, 0x5a, 0xc5, 0xd3, 0x49, 0xd4, 0xd3, 0x99, 0x33, 0x20,
	0x94, 0xe1, 0x41, 0x20, 0x1d, 0x64, 0x5e, 0x9d, 0x8d, 0x02, 0xa2, 0x0f, 0x7c, 0x8f, 0x8c, 0xe6,
	0x0c, 0x3c, 0xaf, 0xe5, 0x3a, 0xc4, 0x63, 0xb1, 0xa1, 0xf4, 0xb5, 0x06, 0xcb, 0x87, 0x24, 0x1c,
	0x3a, 0x16, 0x41, 0x08, 0xce, 0x79, 0x78, 0x40, 0xf2, 0x5a, 0x51, 0xdb, 0xc9, 0x18, 0xe2, 0x37,
	0xba, 0x0c, 0x40, 0x63, 0xb3, 0xe9, 0x74, 0xf3, 0x09, 0x61, 0xc9, 0x48, 0xa4, 0xd9, 0x45, 0x57,
	0x60, 0xa5, 0xeb, 0xd0, 0xc0, 0xc5, 0x23, 0x53, 0x84, 0x26, 0x85, 0x43, 0x56, 0x62, 0xfb, 0x3c,
	0xc3, 0x1d, 0xd8, 0x3a, 0x89, 0xa8, 0xe3, 0x11, 0x4a, 0x4d, 0xe2, 0x31, 0x87, 0x49, 0xd7, 0x73,
	0xc2, 0x15, 0x29, 0x5b, 0x5d, 0x98, 0x78, 0x44, 0xe9, 0xc7, 0x04, 0x24, 0x0f, 0xfb, 0xd1, 0x6b,
	0xfb, 0x39, 0x0f, 0x4b, 0xb4, 0x1f, 0x4d, 0x7a, 0x49, 0xd1, 0x7e, 0xd4, 0xec, 0xa2, 0x22, 0x64,
	0xbb, 0x84, 0x5a, 0xa1, 0x13, 0x70, 0xbe, 0xc6, 0x6d, 0x4c, 0x20, 0xf4, 0x00, 0xd2, 0x16, 0x66,
	0xc4, 0xf6, 0xc3, 0x91, 0x28, 0x9d, 0xad, 0x5c, 0x29, 0x2f, 0x98, 0x42, 0xb9, 0x26, 0x1d, 0x8d,
	0x71, 0x08, 0xba, 0x06, 0xeb, 0x8a, 0x87, 0x90, 0xd8, 0x7c, 0x26, 0xf9, 0x54, 0x31, 0xb9, 0x93,
	0x31, 0xd6, 0x24, 0x6c, 0xc4, 0x28, 0x6a, 0xc0, 0x4a, 0x10, 0x3a, 0x96, 0xe3, 0xd9, 0xa6, 0xe3,
	0xf5, 0xfc, 0xfc, 0x52, 0x31, 0xb9, 0x93, 0xad, 0x5c, 0x5d, 0x58, 0xab, 0x1d, 0x3b, 0x37, 0xbd,
	0x9e, 0x6f, 0x64, 0x83, 0xc9, 0x03, 0xaa, 0xc0, 0x79, 0x55, 0x31, 0x08, 0xfd, 0xa1, 0xd3, 0x25,
	0x61, 0x4c, 0xdc, 0xb2, 0x38, 0xdc, 0xa6, 0x34, 0xb6, 0xa5, 0x4d, 0x30, 0xf7, 0x83, 0x06, 0x69,
	0xd5, 0x3c, 0x27, 0x5e, 0x25, 0x98, 0x99, 0x51, 0x4c, 0x27, 0x92, 0xb6, 0xbd, 0xa9, 0x51, 0x5d,
	0x83, 0xf5, 0x90, 0x50, 0x3f, 0x0a, 0x2d, 0x62, 0xf6, 0xf0, 0xc0, 0x71, 0x47, 0x92, 0xe5, 0x35,
	0x05, 0x3f, 0x12, 0x28, 0xfa, 0x1f, 0x8c, 0x11, 0xd3, 0x0e, 0xfd, 0x28, 0x90, 0x8c, 0xaf, 0x2a,
	0xb4, 0xc1, 0x41, 0x2e, 0x9e, 0x88, 0x62, 0x9b, 0x98, 0x5c, 0x8f, 0x72, 0xe0, 0x19, 0x81, 0x74,
	0x46, 0x01, 0x29, 0xfd, 0x96, 0x80, 0xec, 0xd4, 0xf1, 0x51, 0x15, 0xd6, 0x48, 0xaf, 0x47, 0x2c,
	0xe6, 0x0c, 0x89, 0xc9, 0xa5, 0x2d, 0x5a, 0xcd, 0x56, 0x0a, 0x8a, 0x3c, 0xa5, 0xfb, 0x72, 0x47,
	0xe9, 0xde, 0x58, 0x1d, 0x47, 0x70, 0x0c, 0xe5, 0x61, 0x99, 0x46, 0x83, 0x01, 0x0e, 0x55, 0xe7,
	0xea, 0x11, 0x3d, 0x05, 0xa4, 0xe6, 0x42, 0x5e, 0x06, 0x21, 0xa1, 0x54, 0x09, 0x25, 0x5b, 0xb9,
	0xf1, 0xb6, 0xe9, 0xd4, 0xc7, 0x11, 0xc6, 0x46, 0x30, 0x0f, 0xa1, 0x43, 0xc8, 0x61, 0xdb, 0x0e,
	0x89, 0x2d, 0x2e, 0x6b, 0x3c, 0xf6, 0x58, 0x62, 0x3b, 0x0b, 0x13, 0x57, 0x27, 0x01, 0x62, 0xf4,
	0xeb, 0x78, 0x16, 0x40, 0xef, 0x41, 0xde, 0x8a, 0xc2, 0x90, 0x78, 0xd6, 0xc8, 0xb4, 0x7c, 0x6f,
	0x48, 0x42, 0x5e, 0xcb, 0x0c, 0x31, 0x23, 0xf9, 0x54, 0x51, 0xdb, 0xd1, 0x8c, 0x0b, 0xca, 0x5e,
	0x1b, 0x9b, 0x0d, 0xcc, 0x48, 0xe9, 0x8f, 0x24, 0x6c, 0x9c, 0xea, 0x7b, 0x32, 0x8b, 0xc8, 0x73,
	0x98, 0xd4, 0x40, 0x3c, 0x8b, 0x23, 0xcf, 0x61, 0xe8, 0x1d, 0xb8, 0x30, 0x31, 0x9b, 0xd3, 0x77,
	0x29, 0x1e, 0xdb, 0xd6, 0xd8, 0x75, 0x6f, 0xea, 0x52, 0x6d, 0x43, 0xe6, 0x04, 0x53, 0x99, 0x33,
	0x25, 0x1c, 0xd3, 0x1c, 0x10, 0x29, 0x2b, 0x70, 0x7e, 0x6c, 0x9c, 0xc9, 0xb8, 0x14, 0x0b, 0x58,
	0x39, 0xee, 0xcd, 0xdc, 0xd2, 0xed, 0x49, 0xcc, 0xd4, 0xb1, 0x7b, 0xd8, 0x62, 0x7e, 0x28, 0xa4,
	0xaf, 0x19, 0x79, 0x15, 0x39, 0x39, 0xf8, 0x23, 0x61, 0x47, 0xd7, 0x21, 0xa7, 0xa4, 0xfe, 0x3c,
	0xc2, 0x62, 0xa3, 0x08, 0x1d, 0x68, 0xc6, 0xba, 0xc4, 0x9f, 0x48, 0x18, 0x1d, 0xc3, 0x0a, 0x73,
	0x48, 0x48, 0xba, 0x82, 0x52, 0x9a, 0x4f, 0x8a, 0x7b, 0x7a, 0xf7, 0xec, 0x4a, 0x28, 0x77, 0x1c,
	0x12, 0x72, 0xc2, 0x8d, 0x6c, 0x9c, 0x88, 0xff, 0xa6, 0x85, 0x3e, 0xa4, 0x95, 0x01, 0xdd, 0x02,
	0x44, 0x19, 0x0e, 0x99, 0x19, 0x53, 0x8b, 0x07, 0x7e, 0xe4, 0xc5, 0xdc, 0x6b, 0x46, 0x4e, 0x58,
	0x8e, 0xb8, 0xa1, 0x2a, 0x70, 0xb4, 0x0b, 0x20, 0x8e, 0xcd, 0x05, 0x46, 0x44, 0xdb, 0xd9, 0x0a,
	0x52, 0xfd, 0xf0, 0x1b, 0x54, 0x7e, 0xcc, 0x37, 0xba, 0x91, 0xe1, 0x5e, 0xbc, 0x1d, 0x52, 0xfa,
	0x29, 0x09, 0xeb, 0x73, 0x4a, 0x42, 0x3d, 0xd8, 0x98, 0x56, 0xa3, 0x4b, 0x86, 0xc4, 0x15, 0x35,
	0xd7, 0x2a, 0xf7, 0xce, 0x2a, 0xc7, 0xe9, 0xe7, 0x16, 0x4f, 0x60, 0x4c, 0x2b, 0x5c, 0x20, 0xc8,
	0x87, 0xad, 0x59, 0xd5, 0x33, 0x12, 0x0e, 0xb1, 0x2b, 0x1a, 0x5f, 0xab, 0xdc, 0xff, 0x27, 0xa5,
	0x9a, 0x32, 0x87, 0xb1, 0x89, 0x4f, 0x83, 0xe8, 0xe6, 0xec, 0xc1, 0x2c, 0x41, 0x26, 0xbf, 0xc0,
	0xa9, 0x99, 0xee, 0x6a, 0x1c, 0x2f, 0x1d, 0x40, 0x6e, 0xfe, 0x0c, 0xe8, 0x0a, 0x5c, 0xae, 0x36,
	0x1a, 0x46, 0xbd, 0x51, 0xed, 0x34, 0x0f, 0xf6, 0xcd, 0x56, 0xfd, 0xb8, 0xde, 0x32, 0x8f, 0xf6,
	0x0f, 0xdb, 0xf5, 0x5a, 0xf3, 0x51, 0xb3, 0xbe, 0x97, 0xfb, 0x17, 0xca, 0xc2, 0x72, 0xb5, 0x56,
	0x3b, 0x38, 0xda, 0xef, 0xe4, 0x34, 0xfe, 0xd0, 0x36, 0x0e, 0x3e, 0xae, 0xd7, 0x3a, 0xb9, 0x44,
	0xe9, 0x10, 0x36, 0x5f, 0xd3, 0x29, 0xba, 0x0a, 0xc5, 0xe9, 0x9c, 0xcd, 0xfd, 0x4e, 0xdd, 0x38,
	0xae, 0xce, 0xa7, 0xcd, 0x40, 0x6a, 0xaf, 0xda, 0x6c, 0x3d, 0x8d, 0x93, 0x3e, 0x3e, 0xd8, 0xef,
	0x7c, 0xd4, 0x7a, 0x9a, 0x4b, 0x94, 0x9e, 0xc0, 0x66, 0xcb, 0xa1, 0x4c, 0xbe, 0x80, 0xa9, 0x41,
	0x9e, 0x47, 0x84, 0x32, 0x7e, 0xad, 0x02, 0x2e, 0x18, 0xea, 0xbc, 0x8a, 0x77, 0x60, 0xca, 0x48,
	0x73, 0xe0, 0xd0, 0x79, 0x25, 0xde, 0xc8, 0xc2, 0xc8, 0xfc, 0x3e, 0xf1, 0xd4, 0x1b, 0x99, 0x23,
	0x1d, 0x0e, 0x94, 0x3e, 0x83, 0xad, 0xd9, 0x94, 0x34, 0xf0, 0x3d, 0x4a, 0xd0, 0x7d, 0x48, 0xcb,
	0x8d, 0x4f, 0xf3, 0x9a, 0xd0, 0x7a, 0x71, 0xe1, 0x88, 0x64, 0xb0, 0x31, 0x8e, 0x40, 0xff, 0x87,
	0x75, 0x8f, 0xbc, 0x64, 0xe6, 0xa9, 0xca, 0xab, 0x1c, 0x6e, 0x8f, 0xab, 0xff, 0xa5, 0xc1, 0xba,
	0x28, 0xdf, 0x8f, 0xc6, 0xa7, 0xb9, 0x00, 0x4b, 0x01, 0x0e, 0x89, 0xa7, 0xb6, 0x8e, 0x7c, 0x42,
	0xf7, 0x00, 0xe2, 0xdb, 0x21, 0x56, 0x7d, 0xe2, 0xad, 0xab, 0x3e, 0x23, 0xbc, 0xc5, 0x9a, 0x7f,
	0x17, 0xd2, 0xc4, 0xeb, 0xc6, 0x81, 0xc9, 0xb7, 0x06, 0x2e, 0x13, 0xaf, 0x2b, 0xc2, 0xfe, 0x0b,
	0xab, 0x53, 0x3b, 0xb5, 0xab, 0x5e, 0x49, 0x2b, 0x93, 0x45, 0xda, 0x25, 0xb3, 0xe4, 0xa7, 0xde,
	0x48, 0xfe, 0xd2, 0x3c, 0xf9, 0x2e, 0xe4, 0x26, 0xa7, 0x97, 0xc4, 0xdf, 0x81, 0x73, 0xb4, 0x1f,
	0x29, 0xd2, 0x2f, 0x2d, 0x26, 0xbd, 0x1f, 0x19, 0xc2, 0xf3, 0xac, 0x64, 0x57, 0xfe, 0x4c, 0xc0,
	0x4a, 0x8d, 0xa7, 0xa9, 0xc5, 0x1f, 0x97, 0xe8, 0x0b, 0x0d, 0x56, 0xa6, 0x87, 0x8f, 0x6e, 0x2d,
	0xac, 0xf6, 0x1a, 0xd9, 0x15, 0x6e, 0x9f, 0xd1, 0x3b, 0x3e, 0x58, 0x69, 0xeb, 0xcb, 0x5f, 0x7f,
	0xff, 0x26, 0xb1, 0x86, 0x56, 0xf8, 0x57, 0xee, 0x58, 0x29, 0x5f, 0x69, 0x90, 0x56, 0x1c, 0xa0,
	0x9d, 0x37, 0x67, 0x9c, 0x88, 0xa4, 0x70, 0xfd, 0x0c, 0x9e, 0xb2, 0xee, 0x55, 0x51, 0xf7, 0xdf,
	0xe8, 0x12, 0xaf, 0xfb, 0x69, 0x2c, 0xa6, 0x07, 0xaa, 0xbe, 0x7e, 0xe3, 0x73, 0x9d, 0x93, 0x58,
	0x38, 0xf8, 0xb9, 0xba, 0x2d, 0x72, 0xa9, 0x54, 0x71, 0x7e, 0x1c, 0x38, 0xb4, 0x6c, 0xf9, 0x83,
	0x5f, 0xaa, 0xe5, 0x67, 0x8c, 0x05, 0xf4, 0x7d, 0x5d, 0x7f, 0xf1, 0xe2, 0xc5, 0x9c, 0x51, 0xc7,
	0x11, 0x7b, 0x16, 0x7f, 0xb8, 0xdf, 0x0e, 0x5c, 0xcc, 0x7a, 0x7e, 0x38, 0x78, 0xf8, 0xad, 0x06,
	0xdb, 0x96, 0x3f, 0x58, 0xd4, 0xe7, 0xc3, 0x8d, 0xe9, 0x51, 0xb4, 0xb9, 0x0a, 0xdb, 0xda, 0x27,
	0x1f, 0x4a, 0x6f, 0xdb, 0x77, 0xb1, 0x67, 0x97, 0xfd, 0xd0, 0xd6, 0x6d, 0xe2, 0x09, 0x8d, 0xea,
	0x93, 0x9a, 0xa7, 0xfe, 0x34, 0x7c, 0x20, 0x7f, 0x7e, 0x97, 0x58, 0xae, 0xb5, 0xf6, 0x6a, 0x9d,
	0x56, 0xe3, 0xfb, 0xc4, 0xc5, 0x46, 0x9c, 0x4a, 0x94, 0x29, 0x3f, 0x94, 0x85, 0x8f, 0x77, 0x4f,
	0x96, 0x44, 0xba, 0xbb, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff, 0x3f, 0xab, 0xb9, 0x24, 0x82, 0x0c,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CloudCatalogClient is the client API for CloudCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudCatalogClient interface {
	// Lists all public cloud services.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Lists all publicly available SKUs for a given cloud service.
	ListSkus(ctx context.Context, in *ListSkusRequest, opts ...grpc.CallOption) (*ListSkusResponse, error)
}

type cloudCatalogClient struct {
	cc *grpc.ClientConn
}

func NewCloudCatalogClient(cc *grpc.ClientConn) CloudCatalogClient {
	return &cloudCatalogClient{cc}
}

func (c *cloudCatalogClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudCatalog/ListServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudCatalogClient) ListSkus(ctx context.Context, in *ListSkusRequest, opts ...grpc.CallOption) (*ListSkusResponse, error) {
	out := new(ListSkusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudCatalog/ListSkus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudCatalogServer is the server API for CloudCatalog service.
type CloudCatalogServer interface {
	// Lists all public cloud services.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Lists all publicly available SKUs for a given cloud service.
	ListSkus(context.Context, *ListSkusRequest) (*ListSkusResponse, error)
}

// UnimplementedCloudCatalogServer can be embedded to have forward compatible implementations.
type UnimplementedCloudCatalogServer struct {
}

func (*UnimplementedCloudCatalogServer) ListServices(ctx context.Context, req *ListServicesRequest) (*ListServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServices not implemented")
}
func (*UnimplementedCloudCatalogServer) ListSkus(ctx context.Context, req *ListSkusRequest) (*ListSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSkus not implemented")
}

func RegisterCloudCatalogServer(s *grpc.Server, srv CloudCatalogServer) {
	s.RegisterService(&_CloudCatalog_serviceDesc, srv)
}

func _CloudCatalog_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudCatalogServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudCatalog/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudCatalogServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudCatalog_ListSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudCatalogServer).ListSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudCatalog/ListSkus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudCatalogServer).ListSkus(ctx, req.(*ListSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudCatalog_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.billing.v1.CloudCatalog",
	HandlerType: (*CloudCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServices",
			Handler:    _CloudCatalog_ListServices_Handler,
		},
		{
			MethodName: "ListSkus",
			Handler:    _CloudCatalog_ListSkus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/billing/v1/cloud_catalog.proto",
}
