/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import net.sf.gogui.utils.ErrorMessage;

public class Table {
    private boolean m_propertiesRead;
    private int m_lineNumber;
    private int m_numberColumns;
    private final Properties m_properties = new Properties();
    private final ArrayList m_columnTitles;
    private ArrayList m_lastRow;
    private final ArrayList m_rows = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Table() {
        this.m_columnTitles = new ArrayList();
        this.m_numberColumns = 0;
    }

    public Table(ArrayList arrayList) {
        this.m_columnTitles = arrayList;
        this.m_numberColumns = arrayList.size();
    }

    public String get(int n, int n2) {
        return (String)this.getRow(n2).get(n);
    }

    public String get(String string, int n) {
        return this.get(this.getColumnIndex(string), n);
    }

    public int getColumnIndex(String string) {
        for (int i = 0; i < this.m_numberColumns; ++i) {
            String string2 = this.getColumnTitle(i);
            if (!string2.equals(string)) continue;
            return i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public String getColumnTitle(int n) {
        return (String)this.m_columnTitles.get(n);
    }

    public ArrayList getColumnTitles() {
        return (ArrayList)this.m_columnTitles.clone();
    }

    public int getNumberColumns() {
        return this.m_columnTitles.size();
    }

    public int getNumberRows() {
        return this.m_rows.size();
    }

    public String getProperty(String string, String string2) {
        return this.m_properties.getProperty(string, string2);
    }

    public void read(File file) throws Exception {
        this.read(new FileReader(file));
    }

    public void read(Reader reader) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.m_lineNumber = 0;
        this.m_propertiesRead = false;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            ++this.m_lineNumber;
            this.handleLine(string);
        }
        bufferedReader.close();
    }

    public void save(Writer writer) throws IOException {
        this.save(writer, true);
    }

    public void save(Writer writer, boolean bl) throws IOException {
        if (bl) {
            Enumeration<?> enumeration;
            Enumeration<?> enumeration2 = enumeration = this.m_properties.propertyNames();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                writer.write("# " + string + ": " + this.m_properties.get(string) + "\n");
            }
            writer.write("#\n#");
            for (int i = 0; i < this.m_numberColumns; ++i) {
                writer.write(this.getColumnTitle(i));
                if (i < this.m_numberColumns - 1) {
                    writer.write(9);
                    continue;
                }
                writer.write(10);
            }
        }
        for (int i = 0; i < this.m_rows.size(); ++i) {
            ArrayList arrayList = (ArrayList)this.m_rows.get(i);
            for (int j = 0; j < this.m_numberColumns; ++j) {
                String string = (String)arrayList.get(j);
                if (string != null) {
                    writer.write(string);
                }
                if (j < this.m_numberColumns - 1) {
                    writer.write(9);
                    continue;
                }
                writer.write(10);
            }
        }
    }

    public void set(int n, String string) {
        if (!$assertionsDisabled && this.m_lastRow.get(n) != null) {
            throw new AssertionError();
        }
        this.m_lastRow.set(n, string);
    }

    public void set(String string, int n) {
        this.set(string, Integer.toString(n));
    }

    public void set(String string, double d) {
        this.set(string, Double.toString(d));
    }

    public void set(String string, String string2) {
        this.set(this.getColumnIndex(string), string2);
    }

    public Object setProperty(String string, String string2) {
        return this.m_properties.setProperty(string, string2);
    }

    public void startRow() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.m_numberColumns);
        for (int i = 0; i < this.m_numberColumns; ++i) {
            arrayList.add(null);
        }
        this.m_rows.add(arrayList);
        this.m_lastRow = arrayList;
    }

    private void addColumnTitle(String string) {
        this.m_columnTitles.add(string);
        ++this.m_numberColumns;
    }

    private ArrayList getRow(int n) {
        return (ArrayList)this.m_rows.get(n);
    }

    private void handleComment(String string) {
        string = string.trim();
        if (this.m_propertiesRead) {
            String[] stringArray = string.split("\\t");
            for (int i = 0; i < stringArray.length; ++i) {
                this.addColumnTitle(stringArray[i]);
            }
            return;
        }
        if (string.equals("")) {
            this.m_propertiesRead = true;
            return;
        }
        int n = string.indexOf(58);
        if (n < 0) {
            System.err.println("Invalid line " + this.m_lineNumber + ": " + string);
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        this.setProperty(string2, string3);
    }

    private void handleLine(String string) throws ErrorMessage {
        if ((string = string.trim()).startsWith("#")) {
            this.handleComment(string.substring(1));
            return;
        }
        String[] stringArray = string.split("\\t");
        if (stringArray.length > this.getNumberColumns()) {
            throw new ErrorMessage("Invalid line " + this.m_lineNumber + ": " + string);
        }
        this.startRow();
        for (int i = 0; i < stringArray.length; ++i) {
            this.set(i, stringArray[i]);
        }
    }

    static {
        $assertionsDisabled = !Table.class.desiredAssertionStatus();
    }
}

