/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.sf.gogui.game.Node;
import net.sf.gogui.gui.GuiTextPane;
import net.sf.gogui.gui.GuiUtils;

public class Comment
extends JScrollPane
implements DocumentListener {
    private boolean m_duringSetText;
    private static final long serialVersionUID = 0L;
    private final GuiTextPane m_textPane;
    private final Listener m_listener;
    private Node m_node;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Comment(Listener listener, boolean bl) {
        this.m_listener = listener;
        this.m_textPane = new GuiTextPane(bl);
        Comment.setFocusTraversalKeys(this.m_textPane);
        this.m_textPane.addStyle("marked", Color.white, Color.decode("#38d878"), false);
        int n = GuiUtils.getDefaultMonoFontSize();
        this.setPreferredSize(new Dimension(20 * n, 10 * n));
        this.m_textPane.getDocument().addDocumentListener(this);
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                if (Comment.this.m_listener == null) {
                    return;
                }
                JTextComponent jTextComponent = Comment.this.m_textPane.get();
                Comment.this.m_listener.textSelected(jTextComponent.getSelectedText());
            }
        };
        this.m_textPane.get().addCaretListener(caretListener);
        this.setViewportView(this.m_textPane.get());
        this.setHorizontalScrollBarPolicy(31);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.copyContentToNode();
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public String getSelectedText() {
        return this.m_textPane.get().getSelectedText();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.copyContentToNode();
    }

    public void markAll(Pattern pattern) {
        block4: {
            Document document = this.m_textPane.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                Matcher matcher = pattern.matcher(string);
                boolean bl = true;
                while (matcher.find()) {
                    int n = matcher.start();
                    int n2 = matcher.end();
                    if (bl) {
                        this.m_textPane.setStyle(0, document.getLength(), null);
                        this.m_textPane.get().setCaretPosition(n);
                        bl = false;
                    }
                    this.m_textPane.setStyle(n, n2 - n, "marked");
                }
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.copyContentToNode();
    }

    public void setFontFixed(boolean bl) {
        if (bl) {
            GuiUtils.setMonospacedFont(this.m_textPane.get());
        } else {
            this.m_textPane.get().setFont(UIManager.getFont("TextArea.font"));
        }
        this.m_textPane.get().repaint();
    }

    public void setNode(Node node) {
        this.m_node = node;
        String string = node.getComment();
        if (string == null) {
            string = "";
        }
        this.m_duringSetText = true;
        this.m_textPane.get().setText(string);
        this.m_textPane.get().setCaretPosition(0);
        this.m_duringSetText = false;
        this.copyContentToNode();
    }

    private void copyContentToNode() {
        if (this.m_duringSetText) {
            return;
        }
        String string = this.m_textPane.get().getText().trim();
        if (this.m_node == null) {
            return;
        }
        String string2 = this.m_node.getComment();
        string2 = string2 == null ? "" : string2.trim();
        if (!string2.equals(string)) {
            this.m_node.setComment(string);
            this.m_listener.changed();
        }
    }

    private static void setFocusTraversalKeys(GuiTextPane guiTextPane) {
        int n = 0;
        TreeSet<AWTKeyStroke> treeSet = new TreeSet<AWTKeyStroke>();
        treeSet.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        guiTextPane.get().setFocusTraversalKeys(n, treeSet);
    }

    static {
        $assertionsDisabled = !Comment.class.desiredAssertionStatus();
    }

    public static interface Listener {
        public void changed();

        public void textSelected(String var1);
    }
}

