// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListContainerScanRecipesRequest wrapper for the ListContainerScanRecipes operation
//
// # See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListContainerScanRecipes.go.html to see an example of how to use ListContainerScanRecipesRequest.
type ListContainerScanRecipesRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// A filter to return only resources whose lifecycleState matches the given lifecycleState.
	LifecycleState ListContainerScanRecipesLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListContainerScanRecipesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.
	SortBy ListContainerScanRecipesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListContainerScanRecipesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListContainerScanRecipesRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListContainerScanRecipesRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListContainerScanRecipesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListContainerScanRecipesRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListContainerScanRecipesLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetListContainerScanRecipesLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListContainerScanRecipesSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListContainerScanRecipesSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListContainerScanRecipesSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListContainerScanRecipesSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListContainerScanRecipesResponse wrapper for the ListContainerScanRecipes operation
type ListContainerScanRecipesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of ContainerScanRecipeSummaryCollection instances
	ContainerScanRecipeSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListContainerScanRecipesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListContainerScanRecipesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListContainerScanRecipesLifecycleStateEnum Enum with underlying type: string
type ListContainerScanRecipesLifecycleStateEnum string

// Set of constants representing the allowable values for ListContainerScanRecipesLifecycleStateEnum
const (
	ListContainerScanRecipesLifecycleStateCreating ListContainerScanRecipesLifecycleStateEnum = "CREATING"
	ListContainerScanRecipesLifecycleStateUpdating ListContainerScanRecipesLifecycleStateEnum = "UPDATING"
	ListContainerScanRecipesLifecycleStateActive   ListContainerScanRecipesLifecycleStateEnum = "ACTIVE"
	ListContainerScanRecipesLifecycleStateDeleting ListContainerScanRecipesLifecycleStateEnum = "DELETING"
	ListContainerScanRecipesLifecycleStateDeleted  ListContainerScanRecipesLifecycleStateEnum = "DELETED"
	ListContainerScanRecipesLifecycleStateFailed   ListContainerScanRecipesLifecycleStateEnum = "FAILED"
)

var mappingListContainerScanRecipesLifecycleStateEnum = map[string]ListContainerScanRecipesLifecycleStateEnum{
	"CREATING": ListContainerScanRecipesLifecycleStateCreating,
	"UPDATING": ListContainerScanRecipesLifecycleStateUpdating,
	"ACTIVE":   ListContainerScanRecipesLifecycleStateActive,
	"DELETING": ListContainerScanRecipesLifecycleStateDeleting,
	"DELETED":  ListContainerScanRecipesLifecycleStateDeleted,
	"FAILED":   ListContainerScanRecipesLifecycleStateFailed,
}

var mappingListContainerScanRecipesLifecycleStateEnumLowerCase = map[string]ListContainerScanRecipesLifecycleStateEnum{
	"creating": ListContainerScanRecipesLifecycleStateCreating,
	"updating": ListContainerScanRecipesLifecycleStateUpdating,
	"active":   ListContainerScanRecipesLifecycleStateActive,
	"deleting": ListContainerScanRecipesLifecycleStateDeleting,
	"deleted":  ListContainerScanRecipesLifecycleStateDeleted,
	"failed":   ListContainerScanRecipesLifecycleStateFailed,
}

// GetListContainerScanRecipesLifecycleStateEnumValues Enumerates the set of values for ListContainerScanRecipesLifecycleStateEnum
func GetListContainerScanRecipesLifecycleStateEnumValues() []ListContainerScanRecipesLifecycleStateEnum {
	values := make([]ListContainerScanRecipesLifecycleStateEnum, 0)
	for _, v := range mappingListContainerScanRecipesLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetListContainerScanRecipesLifecycleStateEnumStringValues Enumerates the set of values in String for ListContainerScanRecipesLifecycleStateEnum
func GetListContainerScanRecipesLifecycleStateEnumStringValues() []string {
	return []string{
		"CREATING",
		"UPDATING",
		"ACTIVE",
		"DELETING",
		"DELETED",
		"FAILED",
	}
}

// GetMappingListContainerScanRecipesLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListContainerScanRecipesLifecycleStateEnum(val string) (ListContainerScanRecipesLifecycleStateEnum, bool) {
	enum, ok := mappingListContainerScanRecipesLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListContainerScanRecipesSortOrderEnum Enum with underlying type: string
type ListContainerScanRecipesSortOrderEnum string

// Set of constants representing the allowable values for ListContainerScanRecipesSortOrderEnum
const (
	ListContainerScanRecipesSortOrderAsc  ListContainerScanRecipesSortOrderEnum = "ASC"
	ListContainerScanRecipesSortOrderDesc ListContainerScanRecipesSortOrderEnum = "DESC"
)

var mappingListContainerScanRecipesSortOrderEnum = map[string]ListContainerScanRecipesSortOrderEnum{
	"ASC":  ListContainerScanRecipesSortOrderAsc,
	"DESC": ListContainerScanRecipesSortOrderDesc,
}

var mappingListContainerScanRecipesSortOrderEnumLowerCase = map[string]ListContainerScanRecipesSortOrderEnum{
	"asc":  ListContainerScanRecipesSortOrderAsc,
	"desc": ListContainerScanRecipesSortOrderDesc,
}

// GetListContainerScanRecipesSortOrderEnumValues Enumerates the set of values for ListContainerScanRecipesSortOrderEnum
func GetListContainerScanRecipesSortOrderEnumValues() []ListContainerScanRecipesSortOrderEnum {
	values := make([]ListContainerScanRecipesSortOrderEnum, 0)
	for _, v := range mappingListContainerScanRecipesSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListContainerScanRecipesSortOrderEnumStringValues Enumerates the set of values in String for ListContainerScanRecipesSortOrderEnum
func GetListContainerScanRecipesSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListContainerScanRecipesSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListContainerScanRecipesSortOrderEnum(val string) (ListContainerScanRecipesSortOrderEnum, bool) {
	enum, ok := mappingListContainerScanRecipesSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListContainerScanRecipesSortByEnum Enum with underlying type: string
type ListContainerScanRecipesSortByEnum string

// Set of constants representing the allowable values for ListContainerScanRecipesSortByEnum
const (
	ListContainerScanRecipesSortByTimecreated ListContainerScanRecipesSortByEnum = "timeCreated"
	ListContainerScanRecipesSortByDisplayname ListContainerScanRecipesSortByEnum = "displayName"
)

var mappingListContainerScanRecipesSortByEnum = map[string]ListContainerScanRecipesSortByEnum{
	"timeCreated": ListContainerScanRecipesSortByTimecreated,
	"displayName": ListContainerScanRecipesSortByDisplayname,
}

var mappingListContainerScanRecipesSortByEnumLowerCase = map[string]ListContainerScanRecipesSortByEnum{
	"timecreated": ListContainerScanRecipesSortByTimecreated,
	"displayname": ListContainerScanRecipesSortByDisplayname,
}

// GetListContainerScanRecipesSortByEnumValues Enumerates the set of values for ListContainerScanRecipesSortByEnum
func GetListContainerScanRecipesSortByEnumValues() []ListContainerScanRecipesSortByEnum {
	values := make([]ListContainerScanRecipesSortByEnum, 0)
	for _, v := range mappingListContainerScanRecipesSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListContainerScanRecipesSortByEnumStringValues Enumerates the set of values in String for ListContainerScanRecipesSortByEnum
func GetListContainerScanRecipesSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"displayName",
	}
}

// GetMappingListContainerScanRecipesSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListContainerScanRecipesSortByEnum(val string) (ListContainerScanRecipesSortByEnum, bool) {
	enum, ok := mappingListContainerScanRecipesSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
