// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Application Dependency Management API
//
// Use the Application Dependency Management API to create knowledge bases and vulnerability audits.  For more information, see ADM (https://docs.cloud.oracle.com/Content/application-dependency-management/home.htm).
//

package adm

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// VulnerabilityAuditSource vulnerability audit source.
type VulnerabilityAuditSource interface {
}

type vulnerabilityauditsource struct {
	JsonData []byte
	Type     string `json:"type"`
}

// UnmarshalJSON unmarshals json
func (m *vulnerabilityauditsource) UnmarshalJSON(data []byte) error {
	m.JsonData = data
	type Unmarshalervulnerabilityauditsource vulnerabilityauditsource
	s := struct {
		Model Unmarshalervulnerabilityauditsource
	}{}
	err := json.Unmarshal(data, &s.Model)
	if err != nil {
		return err
	}
	m.Type = s.Model.Type

	return err
}

// UnmarshalPolymorphicJSON unmarshals polymorphic json
func (m *vulnerabilityauditsource) UnmarshalPolymorphicJSON(data []byte) (interface{}, error) {

	if data == nil || string(data) == "null" {
		return nil, nil
	}

	var err error
	switch m.Type {
	case "UNKNOWN":
		mm := UnknownSourceVulnerabilityAuditSource{}
		err = json.Unmarshal(data, &mm)
		return mm, err
	case "OCI_RESOURCE":
		mm := OciResourceVulnerabilityAuditSource{}
		err = json.Unmarshal(data, &mm)
		return mm, err
	case "EXTERNAL_RESOURCE":
		mm := ExternalResourceVulnerabilityAuditSource{}
		err = json.Unmarshal(data, &mm)
		return mm, err
	default:
		common.Logf("Recieved unsupported enum value for VulnerabilityAuditSource: %s.", m.Type)
		return *m, nil
	}
}

func (m vulnerabilityauditsource) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m vulnerabilityauditsource) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// VulnerabilityAuditSourceTypeEnum Enum with underlying type: string
type VulnerabilityAuditSourceTypeEnum string

// Set of constants representing the allowable values for VulnerabilityAuditSourceTypeEnum
const (
	VulnerabilityAuditSourceTypeExternalResource VulnerabilityAuditSourceTypeEnum = "EXTERNAL_RESOURCE"
	VulnerabilityAuditSourceTypeOciResource      VulnerabilityAuditSourceTypeEnum = "OCI_RESOURCE"
	VulnerabilityAuditSourceTypeUnknown          VulnerabilityAuditSourceTypeEnum = "UNKNOWN"
)

var mappingVulnerabilityAuditSourceTypeEnum = map[string]VulnerabilityAuditSourceTypeEnum{
	"EXTERNAL_RESOURCE": VulnerabilityAuditSourceTypeExternalResource,
	"OCI_RESOURCE":      VulnerabilityAuditSourceTypeOciResource,
	"UNKNOWN":           VulnerabilityAuditSourceTypeUnknown,
}

var mappingVulnerabilityAuditSourceTypeEnumLowerCase = map[string]VulnerabilityAuditSourceTypeEnum{
	"external_resource": VulnerabilityAuditSourceTypeExternalResource,
	"oci_resource":      VulnerabilityAuditSourceTypeOciResource,
	"unknown":           VulnerabilityAuditSourceTypeUnknown,
}

// GetVulnerabilityAuditSourceTypeEnumValues Enumerates the set of values for VulnerabilityAuditSourceTypeEnum
func GetVulnerabilityAuditSourceTypeEnumValues() []VulnerabilityAuditSourceTypeEnum {
	values := make([]VulnerabilityAuditSourceTypeEnum, 0)
	for _, v := range mappingVulnerabilityAuditSourceTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilityAuditSourceTypeEnumStringValues Enumerates the set of values in String for VulnerabilityAuditSourceTypeEnum
func GetVulnerabilityAuditSourceTypeEnumStringValues() []string {
	return []string{
		"EXTERNAL_RESOURCE",
		"OCI_RESOURCE",
		"UNKNOWN",
	}
}

// GetMappingVulnerabilityAuditSourceTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilityAuditSourceTypeEnum(val string) (VulnerabilityAuditSourceTypeEnum, bool) {
	enum, ok := mappingVulnerabilityAuditSourceTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
