// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Application Dependency Management API
//
// Use the Application Dependency Management API to create knowledge bases and vulnerability audits.  For more information, see ADM (https://docs.cloud.oracle.com/Content/application-dependency-management/home.htm).
//

package adm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// VulnerabilityAuditConfiguration Configuration for a vulnerability audit.
// A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`.
// type: object
type VulnerabilityAuditConfiguration struct {

	// A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
	MaxPermissibleCvssV2Score *float32 `mandatory:"false" json:"maxPermissibleCvssV2Score"`

	// A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
	MaxPermissibleCvssV3Score *float32 `mandatory:"false" json:"maxPermissibleCvssV3Score"`

	// A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleSeverity.
	MaxPermissibleSeverity ConfigSeverityEnum `mandatory:"false" json:"maxPermissibleSeverity,omitempty"`

	// A vulnerable application dependency is ignored if its name matches any of the items in `exclusions`.
	// An asterisk (*) in the dependency pattern acts as a wildcard and matches zero or more characters.
	Exclusions []string `mandatory:"false" json:"exclusions"`
}

func (m VulnerabilityAuditConfiguration) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m VulnerabilityAuditConfiguration) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingConfigSeverityEnum(string(m.MaxPermissibleSeverity)); !ok && m.MaxPermissibleSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for MaxPermissibleSeverity: %s. Supported values are: %s.", m.MaxPermissibleSeverity, strings.Join(GetConfigSeverityEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
