// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// HostAgentScanResultSortByEnum Enum with underlying type: string
type HostAgentScanResultSortByEnum string

// Set of constants representing the allowable values for HostAgentScanResultSortByEnum
const (
	HostAgentScanResultSortByTimeStarted            HostAgentScanResultSortByEnum = "timeStarted"
	HostAgentScanResultSortByTimeFinished           HostAgentScanResultSortByEnum = "timeFinished"
	HostAgentScanResultSortByProblemCount           HostAgentScanResultSortByEnum = "problemCount"
	HostAgentScanResultSortByHighestProblemSeverity HostAgentScanResultSortByEnum = "highestProblemSeverity"
	HostAgentScanResultSortByTimeCompleted          HostAgentScanResultSortByEnum = "timeCompleted"
)

var mappingHostAgentScanResultSortByEnum = map[string]HostAgentScanResultSortByEnum{
	"timeStarted":            HostAgentScanResultSortByTimeStarted,
	"timeFinished":           HostAgentScanResultSortByTimeFinished,
	"problemCount":           HostAgentScanResultSortByProblemCount,
	"highestProblemSeverity": HostAgentScanResultSortByHighestProblemSeverity,
	"timeCompleted":          HostAgentScanResultSortByTimeCompleted,
}

var mappingHostAgentScanResultSortByEnumLowerCase = map[string]HostAgentScanResultSortByEnum{
	"timestarted":            HostAgentScanResultSortByTimeStarted,
	"timefinished":           HostAgentScanResultSortByTimeFinished,
	"problemcount":           HostAgentScanResultSortByProblemCount,
	"highestproblemseverity": HostAgentScanResultSortByHighestProblemSeverity,
	"timecompleted":          HostAgentScanResultSortByTimeCompleted,
}

// GetHostAgentScanResultSortByEnumValues Enumerates the set of values for HostAgentScanResultSortByEnum
func GetHostAgentScanResultSortByEnumValues() []HostAgentScanResultSortByEnum {
	values := make([]HostAgentScanResultSortByEnum, 0)
	for _, v := range mappingHostAgentScanResultSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetHostAgentScanResultSortByEnumStringValues Enumerates the set of values in String for HostAgentScanResultSortByEnum
func GetHostAgentScanResultSortByEnumStringValues() []string {
	return []string{
		"timeStarted",
		"timeFinished",
		"problemCount",
		"highestProblemSeverity",
		"timeCompleted",
	}
}

// GetMappingHostAgentScanResultSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingHostAgentScanResultSortByEnum(val string) (HostAgentScanResultSortByEnum, bool) {
	enum, ok := mappingHostAgentScanResultSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
