// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: trace/v1/trace.proto

package v1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	v11 "github.com/jaegertracing/jaeger/proto-gen/otel/common/v1"
	v1 "github.com/jaegertracing/jaeger/proto-gen/otel/resource/v1"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// SpanKind is the type of span. Can be used to specify additional relationships between spans
// in addition to a parent/child relationship.
type Span_SpanKind int32

const (
	// Unspecified. Do NOT use as default.
	// Implementations MAY assume SpanKind to be INTERNAL when receiving UNSPECIFIED.
	Span_SPAN_KIND_UNSPECIFIED Span_SpanKind = 0
	// Indicates that the span represents an internal operation within an application,
	// as opposed to an operation happening at the boundaries. Default value.
	Span_SPAN_KIND_INTERNAL Span_SpanKind = 1
	// Indicates that the span covers server-side handling of an RPC or other
	// remote network request.
	Span_SPAN_KIND_SERVER Span_SpanKind = 2
	// Indicates that the span describes a request to some remote service.
	Span_SPAN_KIND_CLIENT Span_SpanKind = 3
	// Indicates that the span describes a producer sending a message to a broker.
	// Unlike CLIENT and SERVER, there is often no direct critical path latency relationship
	// between producer and consumer spans. A PRODUCER span ends when the message was accepted
	// by the broker while the logical processing of the message might span a much longer time.
	Span_SPAN_KIND_PRODUCER Span_SpanKind = 4
	// Indicates that the span describes consumer receiving a message from a broker.
	// Like the PRODUCER kind, there is often no direct critical path latency relationship
	// between producer and consumer spans.
	Span_SPAN_KIND_CONSUMER Span_SpanKind = 5
)

var Span_SpanKind_name = map[int32]string{
	0: "SPAN_KIND_UNSPECIFIED",
	1: "SPAN_KIND_INTERNAL",
	2: "SPAN_KIND_SERVER",
	3: "SPAN_KIND_CLIENT",
	4: "SPAN_KIND_PRODUCER",
	5: "SPAN_KIND_CONSUMER",
}

var Span_SpanKind_value = map[string]int32{
	"SPAN_KIND_UNSPECIFIED": 0,
	"SPAN_KIND_INTERNAL":    1,
	"SPAN_KIND_SERVER":      2,
	"SPAN_KIND_CLIENT":      3,
	"SPAN_KIND_PRODUCER":    4,
	"SPAN_KIND_CONSUMER":    5,
}

func (x Span_SpanKind) String() string {
	return proto.EnumName(Span_SpanKind_name, int32(x))
}

func (Span_SpanKind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a52825641200f25e, []int{3, 0}
}

// For the semantics of status codes see
// https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/api.md#set-status
type Status_StatusCode int32

const (
	// The default status.
	Status_STATUS_CODE_UNSET Status_StatusCode = 0
	// The Span has been validated by an Application developers or Operator to have
	// completed successfully.
	Status_STATUS_CODE_OK Status_StatusCode = 1
	// The Span contains an error.
	Status_STATUS_CODE_ERROR Status_StatusCode = 2
)

var Status_StatusCode_name = map[int32]string{
	0: "STATUS_CODE_UNSET",
	1: "STATUS_CODE_OK",
	2: "STATUS_CODE_ERROR",
}

var Status_StatusCode_value = map[string]int32{
	"STATUS_CODE_UNSET": 0,
	"STATUS_CODE_OK":    1,
	"STATUS_CODE_ERROR": 2,
}

func (x Status_StatusCode) String() string {
	return proto.EnumName(Status_StatusCode_name, int32(x))
}

func (Status_StatusCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a52825641200f25e, []int{4, 0}
}

// TracesData represents the traces data that can be stored in a persistent storage,
// OR can be embedded by other protocols that transfer OTLP traces data but do
// not implement the OTLP protocol.
//
// The main difference between this message and collector protocol is that
// in this message there will not be any "control" or "metadata" specific to
// OTLP protocol.
//
// When new fields are added into this message, the OTLP request MUST be updated
// as well.
type TracesData struct {
	// An array of ResourceSpans.
	// For data coming from a single resource this array will typically contain
	// one element. Intermediary nodes that receive data from multiple origins
	// typically batch the data before forwarding further and in that case this
	// array will contain multiple elements.
	ResourceSpans        []*ResourceSpans `protobuf:"bytes,1,rep,name=resource_spans,json=resourceSpans,proto3" json:"resource_spans,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *TracesData) Reset()         { *m = TracesData{} }
func (m *TracesData) String() string { return proto.CompactTextString(m) }
func (*TracesData) ProtoMessage()    {}
func (*TracesData) Descriptor() ([]byte, []int) {
	return fileDescriptor_a52825641200f25e, []int{0}
}
func (m *TracesData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TracesData.Unmarshal(m, b)
}
func (m *TracesData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TracesData.Marshal(b, m, deterministic)
}
func (m *TracesData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TracesData.Merge(m, src)
}
func (m *TracesData) XXX_Size() int {
	return xxx_messageInfo_TracesData.Size(m)
}
func (m *TracesData) XXX_DiscardUnknown() {
	xxx_messageInfo_TracesData.DiscardUnknown(m)
}

var xxx_messageInfo_TracesData proto.InternalMessageInfo

func (m *TracesData) GetResourceSpans() []*ResourceSpans {
	if m != nil {
		return m.ResourceSpans
	}
	return nil
}

// A collection of InstrumentationLibrarySpans from a Resource.
type ResourceSpans struct {
	// The resource for the spans in this message.
	// If this field is not set then no resource info is known.
	Resource *v1.Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// A list of InstrumentationLibrarySpans that originate from a resource.
	InstrumentationLibrarySpans []*InstrumentationLibrarySpans `protobuf:"bytes,2,rep,name=instrumentation_library_spans,json=instrumentationLibrarySpans,proto3" json:"instrumentation_library_spans,omitempty"`
	// This schema_url applies to the data in the "resource" field. It does not apply
	// to the data in the "instrumentation_library_spans" field which have their own
	// schema_url field.
	SchemaUrl            string   `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourceSpans) Reset()         { *m = ResourceSpans{} }
func (m *ResourceSpans) String() string { return proto.CompactTextString(m) }
func (*ResourceSpans) ProtoMessage()    {}
func (*ResourceSpans) Descriptor() ([]byte, []int) {
	return fileDescriptor_a52825641200f25e, []int{1}
}
func (m *ResourceSpans) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceSpans.Unmarshal(m, b)
}
func (m *ResourceSpans) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceSpans.Marshal(b, m, deterministic)
}
func (m *ResourceSpans) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceSpans.Merge(m, src)
}
func (m *ResourceSpans) XXX_Size() int {
	return xxx_messageInfo_ResourceSpans.Size(m)
}
func (m *ResourceSpans) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceSpans.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceSpans proto.InternalMessageInfo

func (m *ResourceSpans) GetResource() *v1.Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *ResourceSpans) GetInstrumentationLibrarySpans() []*InstrumentationLibrarySpans {
	if m != nil {
		return m.InstrumentationLibrarySpans
	}
	return nil
}

func (m *ResourceSpans) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// A collection of Spans produced by an InstrumentationLibrary.
type InstrumentationLibrarySpans struct {
	// The instrumentation library information for the spans in this message.
	// Semantically when InstrumentationLibrary isn't set, it is equivalent with
	// an empty instrumentation library name (unknown).
	InstrumentationLibrary *v11.InstrumentationLibrary `protobuf:"bytes,1,opt,name=instrumentation_library,json=instrumentationLibrary,proto3" json:"instrumentation_library,omitempty"`
	// A list of Spans that originate from an instrumentation library.
	Spans []*Span `protobuf:"bytes,2,rep,name=spans,proto3" json:"spans,omitempty"`
	// This schema_url applies to all spans and span events in the "spans" field.
	SchemaUrl            string   `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstrumentationLibrarySpans) Reset()         { *m = InstrumentationLibrarySpans{} }
func (m *InstrumentationLibrarySpans) String() string { return proto.CompactTextString(m) }
func (*InstrumentationLibrarySpans) ProtoMessage()    {}
func (*InstrumentationLibrarySpans) Descriptor() ([]byte, []int) {
	return fileDescriptor_a52825641200f25e, []int{2}
}
func (m *InstrumentationLibrarySpans) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstrumentationLibrarySpans.Unmarshal(m, b)
}
func (m *InstrumentationLibrarySpans) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstrumentationLibrarySpans.Marshal(b, m, deterministic)
}
func (m *InstrumentationLibrarySpans) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstrumentationLibrarySpans.Merge(m, src)
}
func (m *InstrumentationLibrarySpans) XXX_Size() int {
	return xxx_messageInfo_InstrumentationLibrarySpans.Size(m)
}
func (m *InstrumentationLibrarySpans) XXX_DiscardUnknown() {
	xxx_messageInfo_InstrumentationLibrarySpans.DiscardUnknown(m)
}

var xxx_messageInfo_InstrumentationLibrarySpans proto.InternalMessageInfo

func (m *InstrumentationLibrarySpans) GetInstrumentationLibrary() *v11.InstrumentationLibrary {
	if m != nil {
		return m.InstrumentationLibrary
	}
	return nil
}

func (m *InstrumentationLibrarySpans) GetSpans() []*Span {
	if m != nil {
		return m.Spans
	}
	return nil
}

func (m *InstrumentationLibrarySpans) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// Span represents a single operation within a trace. Spans can be
// nested to form a trace tree. Spans may also be linked to other spans
// from the same or different trace and form graphs. Often, a trace
// contains a root span that describes the end-to-end latency, and one
// or more subspans for its sub-operations. A trace can also contain
// multiple root spans, or none at all. Spans do not need to be
// contiguous - there may be gaps or overlaps between spans in a trace.
//
// The next available field id is 17.
type Span struct {
	// A unique identifier for a trace. All spans from the same trace share
	// the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes
	// is considered invalid.
	//
	// This field is semantically required. Receiver should generate new
	// random trace_id if empty or invalid trace_id was received.
	//
	// This field is required.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for a span within a trace, assigned when the span
	// is created. The ID is an 8-byte array. An ID with all zeroes is considered
	// invalid.
	//
	// This field is semantically required. Receiver should generate new
	// random span_id if empty or invalid span_id was received.
	//
	// This field is required.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// trace_state conveys information about request position in multiple distributed tracing graphs.
	// It is a trace_state in w3c-trace-context format: https://www.w3.org/TR/trace-context/#tracestate-header
	// See also https://github.com/w3c/distributed-tracing for more details about this field.
	TraceState string `protobuf:"bytes,3,opt,name=trace_state,json=traceState,proto3" json:"trace_state,omitempty"`
	// The `span_id` of this span's parent span. If this is a root span, then this
	// field must be empty. The ID is an 8-byte array.
	ParentSpanId []byte `protobuf:"bytes,4,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// A description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name at the same call point in an application.
	// This makes it easier to correlate spans in different traces.
	//
	// This field is semantically required to be set to non-empty string.
	// Empty value is equivalent to an unknown span name.
	//
	// This field is required.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Distinguishes between spans generated in a particular context. For example,
	// two spans with the same name may be distinguished using `CLIENT` (caller)
	// and `SERVER` (callee) to identify queueing latency associated with the span.
	Kind Span_SpanKind `protobuf:"varint,6,opt,name=kind,proto3,enum=jaeger.trace.v1.Span_SpanKind" json:"kind,omitempty"`
	// start_time_unix_nano is the start time of the span. On the client side, this is the time
	// kept by the local machine where the span execution starts. On the server side, this
	// is the time when the server's application handler starts running.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// This field is semantically required and it is expected that end_time >= start_time.
	StartTimeUnixNano uint64 `protobuf:"fixed64,7,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// end_time_unix_nano is the end time of the span. On the client side, this is the time
	// kept by the local machine where the span execution ends. On the server side, this
	// is the time when the server application handler stops running.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// This field is semantically required and it is expected that end_time >= start_time.
	EndTimeUnixNano uint64 `protobuf:"fixed64,8,opt,name=end_time_unix_nano,json=endTimeUnixNano,proto3" json:"end_time_unix_nano,omitempty"`
	// attributes is a collection of key/value pairs. Note, global attributes
	// like server name can be set using the resource API. Examples of attributes:
	//
	//     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
	//     "/http/server_latency": 300
	//     "abc.com/myattribute": true
	//     "abc.com/score": 10.239
	//
	// The OpenTelemetry API specification further restricts the allowed value types:
	// https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/common/common.md#attributes
	// Attribute keys MUST be unique (it is not allowed to have more than one
	// attribute with the same key).
	Attributes []*v11.KeyValue `protobuf:"bytes,9,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// dropped_attributes_count is the number of attributes that were discarded. Attributes
	// can be discarded because their keys are too long or because there are too many
	// attributes. If this value is 0, then no attributes were dropped.
	DroppedAttributesCount uint32 `protobuf:"varint,10,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
	// events is a collection of Event items.
	Events []*Span_Event `protobuf:"bytes,11,rep,name=events,proto3" json:"events,omitempty"`
	// dropped_events_count is the number of dropped events. If the value is 0, then no
	// events were dropped.
	DroppedEventsCount uint32 `protobuf:"varint,12,opt,name=dropped_events_count,json=droppedEventsCount,proto3" json:"dropped_events_count,omitempty"`
	// links is a collection of Links, which are references from this span to a span
	// in the same or different trace.
	Links []*Span_Link `protobuf:"bytes,13,rep,name=links,proto3" json:"links,omitempty"`
	// dropped_links_count is the number of dropped links after the maximum size was
	// enforced. If this value is 0, then no links were dropped.
	DroppedLinksCount uint32 `protobuf:"varint,14,opt,name=dropped_links_count,json=droppedLinksCount,proto3" json:"dropped_links_count,omitempty"`
	// An optional final status for this span. Semantically when Status isn't set, it means
	// span's status code is unset, i.e. assume STATUS_CODE_UNSET (code = 0).
	Status               *Status  `protobuf:"bytes,15,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Span) Reset()         { *m = Span{} }
func (m *Span) String() string { return proto.CompactTextString(m) }
func (*Span) ProtoMessage()    {}
func (*Span) Descriptor() ([]byte, []int) {
	return fileDescriptor_a52825641200f25e, []int{3}
}
func (m *Span) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span.Unmarshal(m, b)
}
func (m *Span) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span.Marshal(b, m, deterministic)
}
func (m *Span) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span.Merge(m, src)
}
func (m *Span) XXX_Size() int {
	return xxx_messageInfo_Span.Size(m)
}
func (m *Span) XXX_DiscardUnknown() {
	xxx_messageInfo_Span.DiscardUnknown(m)
}

var xxx_messageInfo_Span proto.InternalMessageInfo

func (m *Span) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *Span) GetSpanId() []byte {
	if m != nil {
		return m.SpanId
	}
	return nil
}

func (m *Span) GetTraceState() string {
	if m != nil {
		return m.TraceState
	}
	return ""
}

func (m *Span) GetParentSpanId() []byte {
	if m != nil {
		return m.ParentSpanId
	}
	return nil
}

func (m *Span) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Span) GetKind() Span_SpanKind {
	if m != nil {
		return m.Kind
	}
	return Span_SPAN_KIND_UNSPECIFIED
}

func (m *Span) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *Span) GetEndTimeUnixNano() uint64 {
	if m != nil {
		return m.EndTimeUnixNano
	}
	return 0
}

func (m *Span) GetAttributes() []*v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

func (m *Span) GetEvents() []*Span_Event {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *Span) GetDroppedEventsCount() uint32 {
	if m != nil {
		return m.DroppedEventsCount
	}
	return 0
}

func (m *Span) GetLinks() []*Span_Link {
	if m != nil {
		return m.Links
	}
	return nil
}

func (m *Span) GetDroppedLinksCount() uint32 {
	if m != nil {
		return m.DroppedLinksCount
	}
	return 0
}

func (m *Span) GetStatus() *Status {
	if m != nil {
		return m.Status
	}
	return nil
}

// Event is a time-stamped annotation of the span, consisting of user-supplied
// text description and key-value pairs.
type Span_Event struct {
	// time_unix_nano is the time the event occurred.
	TimeUnixNano uint64 `protobuf:"fixed64,1,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// name of the event.
	// This field is semantically required to be set to non-empty string.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// attributes is a collection of attribute key/value pairs on the event.
	// Attribute keys MUST be unique (it is not allowed to have more than one
	// attribute with the same key).
	Attributes []*v11.KeyValue `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// dropped_attributes_count is the number of dropped attributes. If the value is 0,
	// then no attributes were dropped.
	DroppedAttributesCount uint32   `protobuf:"varint,4,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *Span_Event) Reset()         { *m = Span_Event{} }
func (m *Span_Event) String() string { return proto.CompactTextString(m) }
func (*Span_Event) ProtoMessage()    {}
func (*Span_Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_a52825641200f25e, []int{3, 0}
}
func (m *Span_Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_Event.Unmarshal(m, b)
}
func (m *Span_Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_Event.Marshal(b, m, deterministic)
}
func (m *Span_Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_Event.Merge(m, src)
}
func (m *Span_Event) XXX_Size() int {
	return xxx_messageInfo_Span_Event.Size(m)
}
func (m *Span_Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Span_Event proto.InternalMessageInfo

func (m *Span_Event) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *Span_Event) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Span_Event) GetAttributes() []*v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span_Event) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

// A pointer from the current span to another span in the same trace or in a
// different trace. For example, this can be used in batching operations,
// where a single batch handler processes multiple requests from different
// traces or when the handler receives a request from a different project.
type Span_Link struct {
	// A unique identifier of a trace that this linked span is part of. The ID is a
	// 16-byte array.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for the linked span. The ID is an 8-byte array.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// The trace_state associated with the link.
	TraceState string `protobuf:"bytes,3,opt,name=trace_state,json=traceState,proto3" json:"trace_state,omitempty"`
	// attributes is a collection of attribute key/value pairs on the link.
	// Attribute keys MUST be unique (it is not allowed to have more than one
	// attribute with the same key).
	Attributes []*v11.KeyValue `protobuf:"bytes,4,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// dropped_attributes_count is the number of dropped attributes. If the value is 0,
	// then no attributes were dropped.
	DroppedAttributesCount uint32   `protobuf:"varint,5,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *Span_Link) Reset()         { *m = Span_Link{} }
func (m *Span_Link) String() string { return proto.CompactTextString(m) }
func (*Span_Link) ProtoMessage()    {}
func (*Span_Link) Descriptor() ([]byte, []int) {
	return fileDescriptor_a52825641200f25e, []int{3, 1}
}
func (m *Span_Link) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Span_Link.Unmarshal(m, b)
}
func (m *Span_Link) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Span_Link.Marshal(b, m, deterministic)
}
func (m *Span_Link) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span_Link.Merge(m, src)
}
func (m *Span_Link) XXX_Size() int {
	return xxx_messageInfo_Span_Link.Size(m)
}
func (m *Span_Link) XXX_DiscardUnknown() {
	xxx_messageInfo_Span_Link.DiscardUnknown(m)
}

var xxx_messageInfo_Span_Link proto.InternalMessageInfo

func (m *Span_Link) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *Span_Link) GetSpanId() []byte {
	if m != nil {
		return m.SpanId
	}
	return nil
}

func (m *Span_Link) GetTraceState() string {
	if m != nil {
		return m.TraceState
	}
	return ""
}

func (m *Span_Link) GetAttributes() []*v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span_Link) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

// The Status type defines a logical error model that is suitable for different
// programming environments, including REST APIs and RPC APIs.
type Status struct {
	// A developer-facing human readable error message.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// The status code.
	Code                 Status_StatusCode `protobuf:"varint,3,opt,name=code,proto3,enum=jaeger.trace.v1.Status_StatusCode" json:"code,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Status) Reset()         { *m = Status{} }
func (m *Status) String() string { return proto.CompactTextString(m) }
func (*Status) ProtoMessage()    {}
func (*Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_a52825641200f25e, []int{4}
}
func (m *Status) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Status.Unmarshal(m, b)
}
func (m *Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Status.Marshal(b, m, deterministic)
}
func (m *Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Status.Merge(m, src)
}
func (m *Status) XXX_Size() int {
	return xxx_messageInfo_Status.Size(m)
}
func (m *Status) XXX_DiscardUnknown() {
	xxx_messageInfo_Status.DiscardUnknown(m)
}

var xxx_messageInfo_Status proto.InternalMessageInfo

func (m *Status) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Status) GetCode() Status_StatusCode {
	if m != nil {
		return m.Code
	}
	return Status_STATUS_CODE_UNSET
}

func init() {
	proto.RegisterEnum("jaeger.trace.v1.Span_SpanKind", Span_SpanKind_name, Span_SpanKind_value)
	proto.RegisterEnum("jaeger.trace.v1.Status_StatusCode", Status_StatusCode_name, Status_StatusCode_value)
	proto.RegisterType((*TracesData)(nil), "jaeger.trace.v1.TracesData")
	proto.RegisterType((*ResourceSpans)(nil), "jaeger.trace.v1.ResourceSpans")
	proto.RegisterType((*InstrumentationLibrarySpans)(nil), "jaeger.trace.v1.InstrumentationLibrarySpans")
	proto.RegisterType((*Span)(nil), "jaeger.trace.v1.Span")
	proto.RegisterType((*Span_Event)(nil), "jaeger.trace.v1.Span.Event")
	proto.RegisterType((*Span_Link)(nil), "jaeger.trace.v1.Span.Link")
	proto.RegisterType((*Status)(nil), "jaeger.trace.v1.Status")
}

func init() { proto.RegisterFile("trace/v1/trace.proto", fileDescriptor_a52825641200f25e) }

var fileDescriptor_a52825641200f25e = []byte{
	// 874 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0x4d, 0x6f, 0xe3, 0x36,
	0x10, 0x5d, 0x3a, 0xb2, 0xe3, 0x4c, 0x12, 0x47, 0x61, 0xf3, 0xa1, 0x75, 0xba, 0x5d, 0xc3, 0xe8,
	0xc1, 0xc0, 0xb6, 0xf6, 0x6e, 0x16, 0x68, 0x17, 0xbd, 0x65, 0x6d, 0x15, 0x70, 0x93, 0xca, 0x06,
	0x65, 0xef, 0xa1, 0x17, 0x81, 0xb1, 0x08, 0x87, 0x8d, 0x45, 0x19, 0x12, 0x15, 0x6c, 0x7e, 0x4a,
	0xff, 0x45, 0x6f, 0x3d, 0xf7, 0xde, 0x4b, 0xaf, 0xfd, 0x35, 0x05, 0x49, 0x29, 0xb1, 0xf2, 0xd5,
	0x4b, 0x7a, 0x49, 0xc8, 0xf7, 0xde, 0xcc, 0xbc, 0xd1, 0x8c, 0x20, 0xc3, 0x9e, 0x4c, 0xe8, 0x8c,
	0xf5, 0xae, 0xde, 0xf5, 0xf4, 0xa1, 0xbb, 0x4c, 0x62, 0x19, 0xe3, 0x9d, 0x5f, 0x29, 0x9b, 0xb3,
	0xa4, 0x6b, 0xb0, 0xab, 0x77, 0xcd, 0x83, 0x59, 0x1c, 0x45, 0xb1, 0x50, 0x3a, 0x73, 0x32, 0xc2,
	0x66, 0x33, 0x61, 0x69, 0x9c, 0x25, 0x26, 0x43, 0x71, 0x36, 0x5c, 0xdb, 0x07, 0x98, 0xa8, 0xf8,
	0x74, 0x40, 0x25, 0xc5, 0x2e, 0x34, 0x0a, 0x3e, 0x48, 0x97, 0x54, 0xa4, 0x0e, 0x6a, 0xad, 0x75,
	0x36, 0x8f, 0xbf, 0xea, 0xde, 0xa9, 0xd5, 0x25, 0xb9, 0xcc, 0x57, 0x2a, 0xb2, 0x9d, 0xac, 0x5e,
	0xdb, 0xff, 0x20, 0xd8, 0x2e, 0x09, 0xf0, 0x07, 0xa8, 0x17, 0x12, 0x07, 0xb5, 0x50, 0x67, 0xf3,
	0xf8, 0xcb, 0x22, 0xe5, 0x8d, 0xa1, 0x95, 0xac, 0xe4, 0x46, 0x8d, 0x97, 0xf0, 0x8a, 0x8b, 0x54,
	0x26, 0x59, 0xc4, 0x84, 0xa4, 0x92, 0xc7, 0x22, 0x58, 0xf0, 0xf3, 0x84, 0x26, 0xd7, 0xb9, 0xc3,
	0x8a, 0x76, 0xf8, 0xcd, 0x3d, 0x87, 0xc3, 0x72, 0xd4, 0x99, 0x09, 0x32, 0x7e, 0x8f, 0xf8, 0xe3,
	0x24, 0x7e, 0x05, 0x90, 0xce, 0x2e, 0x58, 0x44, 0x83, 0x2c, 0x59, 0x38, 0x6b, 0x2d, 0xd4, 0xd9,
	0x20, 0x1b, 0x06, 0x99, 0x26, 0x8b, 0xf6, 0x5f, 0x08, 0x8e, 0x9e, 0xc8, 0x8d, 0x29, 0x1c, 0x3e,
	0x62, 0x38, 0xef, 0xbc, 0x53, 0x58, 0xcd, 0x87, 0xf4, 0xa8, 0x57, 0x72, 0xf0, 0xb0, 0x4d, 0xfc,
	0x06, 0xaa, 0xab, 0xbd, 0xef, 0xdf, 0xeb, 0x5d, 0x39, 0x21, 0x46, 0xf3, 0x5f, 0xed, 0xfc, 0xb9,
	0x01, 0x96, 0x92, 0xe3, 0x97, 0x50, 0xd7, 0xf1, 0x01, 0x0f, 0xb5, 0xd1, 0x2d, 0xb2, 0xae, 0xef,
	0xc3, 0x10, 0x1f, 0xc2, 0xba, 0xca, 0xa5, 0x98, 0x8a, 0x66, 0x6a, 0xea, 0x3a, 0x0c, 0xf1, 0x6b,
	0xd8, 0x34, 0x31, 0xa9, 0xa4, 0x92, 0xe5, 0xc9, 0x41, 0x43, 0xbe, 0x42, 0xf0, 0xd7, 0xd0, 0x58,
	0xd2, 0x84, 0x09, 0x19, 0x14, 0x09, 0x2c, 0x9d, 0x60, 0xcb, 0xa0, 0xbe, 0x49, 0x83, 0xc1, 0x12,
	0x34, 0x62, 0x4e, 0x55, 0xc7, 0xeb, 0x33, 0x3e, 0x06, 0xeb, 0x92, 0x8b, 0xd0, 0xa9, 0xb5, 0x50,
	0xa7, 0xf1, 0xc0, 0x02, 0xaa, 0x50, 0xfd, 0xe7, 0x94, 0x8b, 0x90, 0x68, 0x2d, 0xee, 0xc1, 0x5e,
	0x2a, 0x69, 0x22, 0x03, 0xc9, 0x23, 0x16, 0x64, 0x82, 0x7f, 0x0e, 0x04, 0x15, 0xb1, 0xb3, 0xde,
	0x42, 0x9d, 0x1a, 0xd9, 0xd5, 0xdc, 0x84, 0x47, 0x6c, 0x2a, 0xf8, 0x67, 0x8f, 0x8a, 0x18, 0xbf,
	0x01, 0xcc, 0x44, 0x78, 0x57, 0x5e, 0xd7, 0xf2, 0x1d, 0x26, 0xc2, 0x92, 0xf8, 0x07, 0x00, 0x2a,
	0x65, 0xc2, 0xcf, 0x33, 0xc9, 0x52, 0x67, 0x43, 0x3f, 0xfa, 0xe6, 0xfd, 0x59, 0x9e, 0xb2, 0xeb,
	0x4f, 0x74, 0x91, 0x31, 0xb2, 0xa2, 0xc6, 0x1f, 0xc0, 0x09, 0x93, 0x78, 0xb9, 0x64, 0x61, 0x70,
	0x8b, 0x06, 0xb3, 0x38, 0x13, 0xd2, 0x81, 0x16, 0xea, 0x6c, 0x93, 0x83, 0x9c, 0x3f, 0xb9, 0xa1,
	0xfb, 0x8a, 0xc5, 0xef, 0xa1, 0xc6, 0xae, 0x98, 0x90, 0xa9, 0xb3, 0xa9, 0x2b, 0x1e, 0x3d, 0xfc,
	0x24, 0x5c, 0xa5, 0x21, 0xb9, 0x14, 0xbf, 0x85, 0xbd, 0xa2, 0x9c, 0x41, 0xf2, 0x52, 0x5b, 0xba,
	0x14, 0xce, 0x39, 0x1d, 0x93, 0x97, 0x79, 0x0b, 0xd5, 0x05, 0x17, 0x97, 0xa9, 0xb3, 0x5d, 0xee,
	0xab, 0x5c, 0xe5, 0x8c, 0x8b, 0x4b, 0x62, 0x84, 0xb8, 0x0b, 0x5f, 0x14, 0x35, 0x34, 0x90, 0x97,
	0x68, 0xe8, 0x12, 0xbb, 0x39, 0xa5, 0x02, 0xf2, 0x0a, 0x3d, 0xa8, 0xa9, 0x2d, 0xc9, 0x52, 0x67,
	0x47, 0xbf, 0x06, 0x87, 0xf7, 0x4b, 0x68, 0x9a, 0xe4, 0xb2, 0xe6, 0x1f, 0x08, 0xaa, 0xda, 0xa2,
	0xda, 0xa2, 0x3b, 0x23, 0x42, 0x7a, 0x44, 0x5b, 0x72, 0x75, 0x3e, 0xc5, 0x16, 0x55, 0x56, 0xb6,
	0xa8, 0x3c, 0xb3, 0xb5, 0x67, 0x9b, 0x99, 0xf5, 0xd4, 0xcc, 0x9a, 0x7f, 0x23, 0xb0, 0x54, 0xe7,
	0xff, 0xcf, 0x3b, 0x55, 0xee, 0xc9, 0x7a, 0xb6, 0x9e, 0xaa, 0x4f, 0xf5, 0xd4, 0xfe, 0x0d, 0x41,
	0xbd, 0x78, 0xdd, 0xf0, 0x4b, 0xd8, 0xf7, 0xc7, 0x27, 0x5e, 0x70, 0x3a, 0xf4, 0x06, 0xc1, 0xd4,
	0xf3, 0xc7, 0x6e, 0x7f, 0xf8, 0xe3, 0xd0, 0x1d, 0xd8, 0x2f, 0xf0, 0x01, 0xe0, 0x5b, 0x6a, 0xe8,
	0x4d, 0x5c, 0xe2, 0x9d, 0x9c, 0xd9, 0x08, 0xef, 0x81, 0x7d, 0x8b, 0xfb, 0x2e, 0xf9, 0xe4, 0x12,
	0xbb, 0x52, 0x46, 0xfb, 0x67, 0x43, 0xd7, 0x9b, 0xd8, 0x6b, 0xe5, 0x1c, 0x63, 0x32, 0x1a, 0x4c,
	0xfb, 0x2e, 0xb1, 0xad, 0x32, 0xde, 0x1f, 0x79, 0xfe, 0xf4, 0x67, 0x97, 0xd8, 0xd5, 0xf6, 0xef,
	0x08, 0x6a, 0x66, 0x79, 0xb0, 0x03, 0xeb, 0x11, 0x4b, 0x53, 0x3a, 0x2f, 0xf6, 0xa0, 0xb8, 0xe2,
	0xef, 0xc0, 0x9a, 0xc5, 0xa1, 0x79, 0xa0, 0x8d, 0xe3, 0xf6, 0x23, 0xdb, 0x97, 0xff, 0xeb, 0xc7,
	0x21, 0x23, 0x5a, 0xdf, 0xf6, 0x00, 0x6e, 0x31, 0xbc, 0x0f, 0xbb, 0xfe, 0xe4, 0x64, 0x32, 0xf5,
	0x83, 0xfe, 0x68, 0xe0, 0xaa, 0xde, 0xdd, 0x89, 0xfd, 0x02, 0x63, 0x68, 0xac, 0xc2, 0xa3, 0x53,
	0x1b, 0xdd, 0x95, 0xba, 0x84, 0x8c, 0x88, 0x5d, 0xf9, 0xc9, 0xaa, 0x23, 0xbb, 0xf2, 0xf1, 0x02,
	0x5e, 0xf3, 0xb8, 0x1b, 0x2f, 0x99, 0x90, 0x6c, 0xc1, 0x22, 0x26, 0x93, 0x6b, 0xf3, 0x45, 0xbe,
	0x31, 0xf4, 0xd1, 0x7c, 0x98, 0xc7, 0x0a, 0x1c, 0xa3, 0x5f, 0xbe, 0x9f, 0x73, 0x79, 0x91, 0x9d,
	0xab, 0x01, 0xf7, 0x8c, 0x75, 0x25, 0xe4, 0x62, 0x9e, 0xdf, 0x7a, 0x3a, 0xfa, 0xdb, 0x39, 0x13,
	0xbd, 0x58, 0xb2, 0x45, 0xaf, 0xf8, 0xc9, 0x70, 0x5e, 0xd3, 0xc4, 0xfb, 0x7f, 0x03, 0x00, 0x00,
	0xff, 0xff, 0x27, 0xd9, 0xff, 0x6c, 0x45, 0x08, 0x00, 0x00,
}
