// Code generated by go-swagger; DO NOT EDIT.

package signed_in_user

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// StarDashboardReader is a Reader for the StarDashboard structure.
type StarDashboardReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StarDashboardReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStarDashboardOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewStarDashboardBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewStarDashboardUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewStarDashboardForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewStarDashboardInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /user/stars/dashboard/{dashboard_id}] starDashboard", response, response.Code())
	}
}

// NewStarDashboardOK creates a StarDashboardOK with default headers values
func NewStarDashboardOK() *StarDashboardOK {
	return &StarDashboardOK{}
}

/*
StarDashboardOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type StarDashboardOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this star dashboard Ok response has a 2xx status code
func (o *StarDashboardOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this star dashboard Ok response has a 3xx status code
func (o *StarDashboardOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this star dashboard Ok response has a 4xx status code
func (o *StarDashboardOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this star dashboard Ok response has a 5xx status code
func (o *StarDashboardOK) IsServerError() bool {
	return false
}

// IsCode returns true when this star dashboard Ok response a status code equal to that given
func (o *StarDashboardOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the star dashboard Ok response
func (o *StarDashboardOK) Code() int {
	return 200
}

func (o *StarDashboardOK) Error() string {
	return fmt.Sprintf("[POST /user/stars/dashboard/{dashboard_id}][%d] starDashboardOk  %+v", 200, o.Payload)
}

func (o *StarDashboardOK) String() string {
	return fmt.Sprintf("[POST /user/stars/dashboard/{dashboard_id}][%d] starDashboardOk  %+v", 200, o.Payload)
}

func (o *StarDashboardOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *StarDashboardOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStarDashboardBadRequest creates a StarDashboardBadRequest with default headers values
func NewStarDashboardBadRequest() *StarDashboardBadRequest {
	return &StarDashboardBadRequest{}
}

/*
StarDashboardBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type StarDashboardBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this star dashboard bad request response has a 2xx status code
func (o *StarDashboardBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this star dashboard bad request response has a 3xx status code
func (o *StarDashboardBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this star dashboard bad request response has a 4xx status code
func (o *StarDashboardBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this star dashboard bad request response has a 5xx status code
func (o *StarDashboardBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this star dashboard bad request response a status code equal to that given
func (o *StarDashboardBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the star dashboard bad request response
func (o *StarDashboardBadRequest) Code() int {
	return 400
}

func (o *StarDashboardBadRequest) Error() string {
	return fmt.Sprintf("[POST /user/stars/dashboard/{dashboard_id}][%d] starDashboardBadRequest  %+v", 400, o.Payload)
}

func (o *StarDashboardBadRequest) String() string {
	return fmt.Sprintf("[POST /user/stars/dashboard/{dashboard_id}][%d] starDashboardBadRequest  %+v", 400, o.Payload)
}

func (o *StarDashboardBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *StarDashboardBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStarDashboardUnauthorized creates a StarDashboardUnauthorized with default headers values
func NewStarDashboardUnauthorized() *StarDashboardUnauthorized {
	return &StarDashboardUnauthorized{}
}

/*
StarDashboardUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type StarDashboardUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this star dashboard unauthorized response has a 2xx status code
func (o *StarDashboardUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this star dashboard unauthorized response has a 3xx status code
func (o *StarDashboardUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this star dashboard unauthorized response has a 4xx status code
func (o *StarDashboardUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this star dashboard unauthorized response has a 5xx status code
func (o *StarDashboardUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this star dashboard unauthorized response a status code equal to that given
func (o *StarDashboardUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the star dashboard unauthorized response
func (o *StarDashboardUnauthorized) Code() int {
	return 401
}

func (o *StarDashboardUnauthorized) Error() string {
	return fmt.Sprintf("[POST /user/stars/dashboard/{dashboard_id}][%d] starDashboardUnauthorized  %+v", 401, o.Payload)
}

func (o *StarDashboardUnauthorized) String() string {
	return fmt.Sprintf("[POST /user/stars/dashboard/{dashboard_id}][%d] starDashboardUnauthorized  %+v", 401, o.Payload)
}

func (o *StarDashboardUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *StarDashboardUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStarDashboardForbidden creates a StarDashboardForbidden with default headers values
func NewStarDashboardForbidden() *StarDashboardForbidden {
	return &StarDashboardForbidden{}
}

/*
StarDashboardForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type StarDashboardForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this star dashboard forbidden response has a 2xx status code
func (o *StarDashboardForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this star dashboard forbidden response has a 3xx status code
func (o *StarDashboardForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this star dashboard forbidden response has a 4xx status code
func (o *StarDashboardForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this star dashboard forbidden response has a 5xx status code
func (o *StarDashboardForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this star dashboard forbidden response a status code equal to that given
func (o *StarDashboardForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the star dashboard forbidden response
func (o *StarDashboardForbidden) Code() int {
	return 403
}

func (o *StarDashboardForbidden) Error() string {
	return fmt.Sprintf("[POST /user/stars/dashboard/{dashboard_id}][%d] starDashboardForbidden  %+v", 403, o.Payload)
}

func (o *StarDashboardForbidden) String() string {
	return fmt.Sprintf("[POST /user/stars/dashboard/{dashboard_id}][%d] starDashboardForbidden  %+v", 403, o.Payload)
}

func (o *StarDashboardForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *StarDashboardForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStarDashboardInternalServerError creates a StarDashboardInternalServerError with default headers values
func NewStarDashboardInternalServerError() *StarDashboardInternalServerError {
	return &StarDashboardInternalServerError{}
}

/*
StarDashboardInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type StarDashboardInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this star dashboard internal server error response has a 2xx status code
func (o *StarDashboardInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this star dashboard internal server error response has a 3xx status code
func (o *StarDashboardInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this star dashboard internal server error response has a 4xx status code
func (o *StarDashboardInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this star dashboard internal server error response has a 5xx status code
func (o *StarDashboardInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this star dashboard internal server error response a status code equal to that given
func (o *StarDashboardInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the star dashboard internal server error response
func (o *StarDashboardInternalServerError) Code() int {
	return 500
}

func (o *StarDashboardInternalServerError) Error() string {
	return fmt.Sprintf("[POST /user/stars/dashboard/{dashboard_id}][%d] starDashboardInternalServerError  %+v", 500, o.Payload)
}

func (o *StarDashboardInternalServerError) String() string {
	return fmt.Sprintf("[POST /user/stars/dashboard/{dashboard_id}][%d] starDashboardInternalServerError  %+v", 500, o.Payload)
}

func (o *StarDashboardInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *StarDashboardInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
