// Code generated by go-swagger; DO NOT EDIT.

package reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SendReportReader is a Reader for the SendReport structure.
type SendReportReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SendReportReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSendReportOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewSendReportBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewSendReportUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSendReportForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewSendReportNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSendReportInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /reports/email] sendReport", response, response.Code())
	}
}

// NewSendReportOK creates a SendReportOK with default headers values
func NewSendReportOK() *SendReportOK {
	return &SendReportOK{}
}

/*
SendReportOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type SendReportOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this send report Ok response has a 2xx status code
func (o *SendReportOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this send report Ok response has a 3xx status code
func (o *SendReportOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this send report Ok response has a 4xx status code
func (o *SendReportOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this send report Ok response has a 5xx status code
func (o *SendReportOK) IsServerError() bool {
	return false
}

// IsCode returns true when this send report Ok response a status code equal to that given
func (o *SendReportOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the send report Ok response
func (o *SendReportOK) Code() int {
	return 200
}

func (o *SendReportOK) Error() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportOk  %+v", 200, o.Payload)
}

func (o *SendReportOK) String() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportOk  %+v", 200, o.Payload)
}

func (o *SendReportOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *SendReportOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSendReportBadRequest creates a SendReportBadRequest with default headers values
func NewSendReportBadRequest() *SendReportBadRequest {
	return &SendReportBadRequest{}
}

/*
SendReportBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type SendReportBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this send report bad request response has a 2xx status code
func (o *SendReportBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this send report bad request response has a 3xx status code
func (o *SendReportBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this send report bad request response has a 4xx status code
func (o *SendReportBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this send report bad request response has a 5xx status code
func (o *SendReportBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this send report bad request response a status code equal to that given
func (o *SendReportBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the send report bad request response
func (o *SendReportBadRequest) Code() int {
	return 400
}

func (o *SendReportBadRequest) Error() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportBadRequest  %+v", 400, o.Payload)
}

func (o *SendReportBadRequest) String() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportBadRequest  %+v", 400, o.Payload)
}

func (o *SendReportBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SendReportBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSendReportUnauthorized creates a SendReportUnauthorized with default headers values
func NewSendReportUnauthorized() *SendReportUnauthorized {
	return &SendReportUnauthorized{}
}

/*
SendReportUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type SendReportUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this send report unauthorized response has a 2xx status code
func (o *SendReportUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this send report unauthorized response has a 3xx status code
func (o *SendReportUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this send report unauthorized response has a 4xx status code
func (o *SendReportUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this send report unauthorized response has a 5xx status code
func (o *SendReportUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this send report unauthorized response a status code equal to that given
func (o *SendReportUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the send report unauthorized response
func (o *SendReportUnauthorized) Code() int {
	return 401
}

func (o *SendReportUnauthorized) Error() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportUnauthorized  %+v", 401, o.Payload)
}

func (o *SendReportUnauthorized) String() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportUnauthorized  %+v", 401, o.Payload)
}

func (o *SendReportUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SendReportUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSendReportForbidden creates a SendReportForbidden with default headers values
func NewSendReportForbidden() *SendReportForbidden {
	return &SendReportForbidden{}
}

/*
SendReportForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type SendReportForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this send report forbidden response has a 2xx status code
func (o *SendReportForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this send report forbidden response has a 3xx status code
func (o *SendReportForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this send report forbidden response has a 4xx status code
func (o *SendReportForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this send report forbidden response has a 5xx status code
func (o *SendReportForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this send report forbidden response a status code equal to that given
func (o *SendReportForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the send report forbidden response
func (o *SendReportForbidden) Code() int {
	return 403
}

func (o *SendReportForbidden) Error() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportForbidden  %+v", 403, o.Payload)
}

func (o *SendReportForbidden) String() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportForbidden  %+v", 403, o.Payload)
}

func (o *SendReportForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SendReportForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSendReportNotFound creates a SendReportNotFound with default headers values
func NewSendReportNotFound() *SendReportNotFound {
	return &SendReportNotFound{}
}

/*
SendReportNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type SendReportNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this send report not found response has a 2xx status code
func (o *SendReportNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this send report not found response has a 3xx status code
func (o *SendReportNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this send report not found response has a 4xx status code
func (o *SendReportNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this send report not found response has a 5xx status code
func (o *SendReportNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this send report not found response a status code equal to that given
func (o *SendReportNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the send report not found response
func (o *SendReportNotFound) Code() int {
	return 404
}

func (o *SendReportNotFound) Error() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportNotFound  %+v", 404, o.Payload)
}

func (o *SendReportNotFound) String() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportNotFound  %+v", 404, o.Payload)
}

func (o *SendReportNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SendReportNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSendReportInternalServerError creates a SendReportInternalServerError with default headers values
func NewSendReportInternalServerError() *SendReportInternalServerError {
	return &SendReportInternalServerError{}
}

/*
SendReportInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SendReportInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this send report internal server error response has a 2xx status code
func (o *SendReportInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this send report internal server error response has a 3xx status code
func (o *SendReportInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this send report internal server error response has a 4xx status code
func (o *SendReportInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this send report internal server error response has a 5xx status code
func (o *SendReportInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this send report internal server error response a status code equal to that given
func (o *SendReportInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the send report internal server error response
func (o *SendReportInternalServerError) Code() int {
	return 500
}

func (o *SendReportInternalServerError) Error() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportInternalServerError  %+v", 500, o.Payload)
}

func (o *SendReportInternalServerError) String() string {
	return fmt.Sprintf("[POST /reports/email][%d] sendReportInternalServerError  %+v", 500, o.Payload)
}

func (o *SendReportInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SendReportInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
