package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindUser invokes the vcs.UnbindUser API synchronously
func (client *Client) UnbindUser(request *UnbindUserRequest) (response *UnbindUserResponse, err error) {
	response = CreateUnbindUserResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindUserWithChan invokes the vcs.UnbindUser API asynchronously
func (client *Client) UnbindUserWithChan(request *UnbindUserRequest) (<-chan *UnbindUserResponse, <-chan error) {
	responseChan := make(chan *UnbindUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindUserWithCallback invokes the vcs.UnbindUser API asynchronously
func (client *Client) UnbindUserWithCallback(request *UnbindUserRequest, callback func(response *UnbindUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindUserResponse
		var err error
		defer close(result)
		response, err = client.UnbindUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindUserRequest is the request struct for api UnbindUser
type UnbindUserRequest struct {
	*requests.RpcRequest
	IsvSubId string           `position:"Body" name:"IsvSubId"`
	CorpId   string           `position:"Body" name:"CorpId"`
	UserId   requests.Integer `position:"Body" name:"UserId"`
}

// UnbindUserResponse is the response struct for api UnbindUser
type UnbindUserResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      bool   `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnbindUserRequest creates a request to invoke UnbindUser API
func CreateUnbindUserRequest() (request *UnbindUserRequest) {
	request = &UnbindUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "UnbindUser", "", "")
	request.Method = requests.POST
	return
}

// CreateUnbindUserResponse creates a response to parse from UnbindUser response
func CreateUnbindUserResponse() (response *UnbindUserResponse) {
	response = &UnbindUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
