package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PredictMTModelByDoc invokes the nlp_automl.PredictMTModelByDoc API synchronously
func (client *Client) PredictMTModelByDoc(request *PredictMTModelByDocRequest) (response *PredictMTModelByDocResponse, err error) {
	response = CreatePredictMTModelByDocResponse()
	err = client.DoAction(request, response)
	return
}

// PredictMTModelByDocWithChan invokes the nlp_automl.PredictMTModelByDoc API asynchronously
func (client *Client) PredictMTModelByDocWithChan(request *PredictMTModelByDocRequest) (<-chan *PredictMTModelByDocResponse, <-chan error) {
	responseChan := make(chan *PredictMTModelByDocResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PredictMTModelByDoc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PredictMTModelByDocWithCallback invokes the nlp_automl.PredictMTModelByDoc API asynchronously
func (client *Client) PredictMTModelByDocWithCallback(request *PredictMTModelByDocRequest, callback func(response *PredictMTModelByDocResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PredictMTModelByDocResponse
		var err error
		defer close(result)
		response, err = client.PredictMTModelByDoc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PredictMTModelByDocRequest is the request struct for api PredictMTModelByDoc
type PredictMTModelByDocRequest struct {
	*requests.RpcRequest
	FileType     string           `position:"Query" name:"FileType"`
	Product      string           `position:"Query" name:"Product"`
	ModelId      requests.Integer `position:"Query" name:"ModelId"`
	FileContent  string           `position:"Body" name:"FileContent"`
	NeedXLIFF    requests.Boolean `position:"Query" name:"NeedXLIFF"`
	ModelVersion string           `position:"Query" name:"ModelVersion"`
}

// PredictMTModelByDocResponse is the response struct for api PredictMTModelByDoc
type PredictMTModelByDocResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	DocId     string `json:"DocId" xml:"DocId"`
}

// CreatePredictMTModelByDocRequest creates a request to invoke PredictMTModelByDoc API
func CreatePredictMTModelByDocRequest() (request *PredictMTModelByDocRequest) {
	request = &PredictMTModelByDocRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-07-01", "PredictMTModelByDoc", "nlpautoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePredictMTModelByDocResponse creates a response to parse from PredictMTModelByDoc response
func CreatePredictMTModelByDocResponse() (response *PredictMTModelByDocResponse) {
	response = &PredictMTModelByDocResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
