package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExtendfiles invokes the elasticsearch.ListExtendfiles API synchronously
func (client *Client) ListExtendfiles(request *ListExtendfilesRequest) (response *ListExtendfilesResponse, err error) {
	response = CreateListExtendfilesResponse()
	err = client.DoAction(request, response)
	return
}

// ListExtendfilesWithChan invokes the elasticsearch.ListExtendfiles API asynchronously
func (client *Client) ListExtendfilesWithChan(request *ListExtendfilesRequest) (<-chan *ListExtendfilesResponse, <-chan error) {
	responseChan := make(chan *ListExtendfilesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExtendfiles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExtendfilesWithCallback invokes the elasticsearch.ListExtendfiles API asynchronously
func (client *Client) ListExtendfilesWithCallback(request *ListExtendfilesRequest, callback func(response *ListExtendfilesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExtendfilesResponse
		var err error
		defer close(result)
		response, err = client.ListExtendfiles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExtendfilesRequest is the request struct for api ListExtendfiles
type ListExtendfilesRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListExtendfilesResponse is the response struct for api ListExtendfiles
type ListExtendfilesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListExtendfilesRequest creates a request to invoke ListExtendfiles API
func CreateListExtendfilesRequest() (request *ListExtendfilesRequest) {
	request = &ListExtendfilesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListExtendfiles", "/openapi/logstashes/[InstanceId]/extendfiles", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListExtendfilesResponse creates a response to parse from ListExtendfiles response
func CreateListExtendfilesResponse() (response *ListExtendfilesResponse) {
	response = &ListExtendfilesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
