#!/bin/sh

# Generate the `help.md` file from the `rq` command.

set -e
set -u
cd "$(dirname "$0")/.."

if [ ! -x "./rq" ] ; then
	echo "FATAL: ./rq not en executable, did you forget to run 'make' first?" 1>&2
	exit 1
fi

printf '# `rq --help`\n'
printf '\n'
printf '*[back to index](./README.md)*\n'
printf '\n'
printf '```\n'
./rq --help
printf '```\n'

printf '\n'
printf '## `rq query --help`\n'
printf '\n'
printf '```\n'
./rq query --help
printf '```\n'

printf '\n'
printf '## `rq script --help`\n'
printf '\n'
printf '```\n'
./rq script --help
printf '```\n'

printf '\n'
printf '## `rq version --help`\n'
printf '\n'
printf '```\n'
./rq version --help
printf '```\n'

printf '\n'
printf '## `rq list-formats --help`\n'
printf '\n'
printf '```\n'
./rq list-formats --help
printf '```\n'

printf '\n'
printf '## `rq list-formats`\n'
printf '\n'
printf '```\n'
./rq list-formats
printf '```\n'

printf '\n'
printf '## `rq install-completions --help`\n'
printf '\n'
printf '```\n'
./rq install-completions --help
printf '```\n'
