/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.BasicClock;
import com.sun.media.Log;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.renderer.audio.device.SunAudioOutput;
import javax.media.ClockStoppedException;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.ResourceUnavailableException;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.format.AudioFormat;
import sun.audio.AudioPlayer;

public class SunAudioRenderer
extends AudioRenderer {
    static String NAME = "SunAudio Renderer";
    public static String vendor = null;
    public static String version = null;
    public static boolean runningOnMac = false;
    public static boolean useSystemTime = false;
    private BasicClock clock = null;
    private long startMediaTime = 0L;
    public static long DEVICE_LATENCY;

    public SunAudioRenderer() {
        if (useSystemTime) {
            this.timeBase = new SystemTimeBase();
            this.clock = new BasicClock();
        }
        this.supportedFormats = new Format[1];
        this.supportedFormats[0] = new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1);
        this.gainControl = new MCA(this);
    }

    public String getName() {
        return NAME;
    }

    public void open() throws ResourceUnavailableException {
        if (!SunAudioRenderer.grabDevice()) {
            throw new ResourceUnavailableException("AudioRenderer: Failed to initialize audio device.");
        }
    }

    public void close() {
        super.close();
    }

    protected AudioOutput createDevice(AudioFormat format) {
        return new SunAudioOutput();
    }

    private static synchronized boolean grabDevice() {
        if (runningOnMac && !AudioPlayer.player.isAlive()) {
            System.out.println("Audio device is busy");
            return false;
        }
        return true;
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        if (useSystemTime) {
            if (!(master instanceof SystemTimeBase)) {
                Log.warning("AudioRenderer cannot be controlled by time bases other than its own: " + master);
            }
            this.clock.setTimeBase(master);
        } else {
            super.setTimeBase(master);
        }
    }

    public void syncStart(Time at) {
        super.syncStart(at);
        if (useSystemTime) {
            this.clock.syncStart(at);
        }
    }

    public void stop() {
        super.stop();
        if (useSystemTime) {
            this.clock.stop();
        }
    }

    public void setStopTime(Time t) {
        if (useSystemTime) {
            this.clock.setStopTime(t);
        } else {
            super.setStopTime(t);
        }
    }

    public Time getStopTime() {
        if (useSystemTime) {
            return this.clock.getStopTime();
        }
        return super.getStopTime();
    }

    public void setMediaTime(Time now) {
        if (useSystemTime) {
            this.clock.setMediaTime(now);
            this.startMediaTime = now.getNanoseconds();
        } else {
            super.setMediaTime(now);
        }
    }

    public Time getMediaTime() {
        return useSystemTime ? this.clock.getMediaTime() : super.getMediaTime();
    }

    public long getMediaNanoseconds() {
        if (useSystemTime) {
            long t = this.clock.getMediaNanoseconds();
            if (t - this.startMediaTime < DEVICE_LATENCY) {
                return this.startMediaTime;
            }
            return t - DEVICE_LATENCY;
        }
        return super.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return useSystemTime ? this.clock.getSyncTime() : super.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return useSystemTime ? this.clock.getTimeBase() : super.getTimeBase();
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return useSystemTime ? this.clock.mapToTimeBase(t) : super.mapToTimeBase(t);
    }

    public float getRate() {
        return useSystemTime ? this.clock.getRate() : super.getRate();
    }

    public float setRate(float factor) {
        return super.setRate(1.0f);
    }

    static {
        try {
            vendor = System.getProperty("java.vendor");
            version = System.getProperty("java.version");
            if (vendor != null && (vendor = vendor.toUpperCase()).startsWith("APPLE") && version.startsWith("1.1")) {
                runningOnMac = true;
                useSystemTime = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DEVICE_LATENCY = runningOnMac ? 7000000000L : 0L;
    }

    class MCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected MCA(AudioRenderer r) {
            super(false);
            this.renderer = r;
        }

        public void setMute(boolean mute) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(mute);
            }
            super.setMute(mute);
        }

        public float getLevel() {
            return -1.0f;
        }
    }
}

