/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.ErrorPattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternBuilder;
import com.thaiopensource.relaxng.impl.PatternInterner;
import com.thaiopensource.relaxng.impl.TextPattern;
import com.thaiopensource.relaxng.impl.UnexpandedNotAllowedPattern;
import com.thaiopensource.relaxng.impl.ValuePattern;
import org.relaxng.datatype.Datatype;
import org.xml.sax.Locator;

public class SchemaPatternBuilder
extends PatternBuilder {
    private boolean idTypes;
    private final UnexpandedNotAllowedPattern unexpandedNotAllowed = new UnexpandedNotAllowedPattern();
    private final TextPattern text = new TextPattern();
    private final PatternInterner schemaInterner = new PatternInterner();

    public boolean hasIdTypes() {
        return this.idTypes;
    }

    Pattern makeElement(NameClass nameClass, Pattern content, Locator loc) {
        ElementPattern p = new ElementPattern(nameClass, content, loc);
        return this.schemaInterner.intern(p);
    }

    Pattern makeAttribute(NameClass nameClass, Pattern value, Locator loc) {
        if (value == this.notAllowed) {
            return value;
        }
        AttributePattern p = new AttributePattern(nameClass, value, loc);
        return this.schemaInterner.intern(p);
    }

    Pattern makeData(Datatype dt) {
        this.noteDatatype(dt);
        DataPattern p = new DataPattern(dt);
        return this.schemaInterner.intern(p);
    }

    Pattern makeDataExcept(Datatype dt, Pattern except, Locator loc) {
        this.noteDatatype(dt);
        DataExceptPattern p = new DataExceptPattern(dt, except, loc);
        return this.schemaInterner.intern(p);
    }

    Pattern makeValue(Datatype dt, Object obj) {
        this.noteDatatype(dt);
        ValuePattern p = new ValuePattern(dt, obj);
        return this.schemaInterner.intern(p);
    }

    Pattern makeText() {
        return this.text;
    }

    Pattern makeOneOrMore(Pattern p) {
        if (p == this.text) {
            return p;
        }
        return super.makeOneOrMore(p);
    }

    Pattern makeUnexpandedNotAllowed() {
        return this.unexpandedNotAllowed;
    }

    Pattern makeError() {
        ErrorPattern p = new ErrorPattern();
        return this.schemaInterner.intern(p);
    }

    Pattern makeChoice(Pattern p1, Pattern p2) {
        if (p1 == this.notAllowed || p1 == p2) {
            return p2;
        }
        if (p2 == this.notAllowed) {
            return p1;
        }
        return super.makeChoice(p1, p2);
    }

    Pattern makeList(Pattern p, Locator loc) {
        if (p == this.notAllowed) {
            return p;
        }
        ListPattern p1 = new ListPattern(p, loc);
        return this.schemaInterner.intern(p1);
    }

    Pattern makeMixed(Pattern p) {
        return this.makeInterleave(this.text, p);
    }

    private void noteDatatype(Datatype dt) {
        if (dt.getIdType() != 0) {
            this.idTypes = true;
        }
    }
}

