// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/pubsublite/v1/subscriber.proto

package pubsublitepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A special target in the partition that takes no other parameters.
type SeekRequest_NamedTarget int32

const (
	// Default value. This value is unused.
	SeekRequest_NAMED_TARGET_UNSPECIFIED SeekRequest_NamedTarget = 0
	// A target corresponding to the most recently published message in the
	// partition.
	SeekRequest_HEAD SeekRequest_NamedTarget = 1
	// A target corresponding to the committed cursor for the given subscription
	// and topic partition.
	SeekRequest_COMMITTED_CURSOR SeekRequest_NamedTarget = 2
)

// Enum value maps for SeekRequest_NamedTarget.
var (
	SeekRequest_NamedTarget_name = map[int32]string{
		0: "NAMED_TARGET_UNSPECIFIED",
		1: "HEAD",
		2: "COMMITTED_CURSOR",
	}
	SeekRequest_NamedTarget_value = map[string]int32{
		"NAMED_TARGET_UNSPECIFIED": 0,
		"HEAD":                     1,
		"COMMITTED_CURSOR":         2,
	}
)

func (x SeekRequest_NamedTarget) Enum() *SeekRequest_NamedTarget {
	p := new(SeekRequest_NamedTarget)
	*p = x
	return p
}

func (x SeekRequest_NamedTarget) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SeekRequest_NamedTarget) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_pubsublite_v1_subscriber_proto_enumTypes[0].Descriptor()
}

func (SeekRequest_NamedTarget) Type() protoreflect.EnumType {
	return &file_google_cloud_pubsublite_v1_subscriber_proto_enumTypes[0]
}

func (x SeekRequest_NamedTarget) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SeekRequest_NamedTarget.Descriptor instead.
func (SeekRequest_NamedTarget) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{2, 0}
}

// The first request that must be sent on a newly-opened stream. The client must
// wait for the response before sending subsequent requests on the stream.
type InitialSubscribeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The subscription from which to receive messages.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// The partition from which to receive messages. Partitions are zero indexed,
	// so `partition` must be in the range [0, topic.num_partitions).
	Partition int64 `protobuf:"varint,2,opt,name=partition,proto3" json:"partition,omitempty"`
	// Optional. Initial target location within the message backlog. If not set,
	// messages will be delivered from the commit cursor for the given
	// subscription and partition.
	InitialLocation *SeekRequest `protobuf:"bytes,4,opt,name=initial_location,json=initialLocation,proto3" json:"initial_location,omitempty"`
}

func (x *InitialSubscribeRequest) Reset() {
	*x = InitialSubscribeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitialSubscribeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitialSubscribeRequest) ProtoMessage() {}

func (x *InitialSubscribeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitialSubscribeRequest.ProtoReflect.Descriptor instead.
func (*InitialSubscribeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{0}
}

func (x *InitialSubscribeRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *InitialSubscribeRequest) GetPartition() int64 {
	if x != nil {
		return x.Partition
	}
	return 0
}

func (x *InitialSubscribeRequest) GetInitialLocation() *SeekRequest {
	if x != nil {
		return x.InitialLocation
	}
	return nil
}

// Response to an InitialSubscribeRequest.
type InitialSubscribeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The cursor from which the subscriber will start receiving messages once
	// flow control tokens become available.
	Cursor *Cursor `protobuf:"bytes,1,opt,name=cursor,proto3" json:"cursor,omitempty"`
}

func (x *InitialSubscribeResponse) Reset() {
	*x = InitialSubscribeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitialSubscribeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitialSubscribeResponse) ProtoMessage() {}

func (x *InitialSubscribeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitialSubscribeResponse.ProtoReflect.Descriptor instead.
func (*InitialSubscribeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{1}
}

func (x *InitialSubscribeResponse) GetCursor() *Cursor {
	if x != nil {
		return x.Cursor
	}
	return nil
}

// Request to update the stream's delivery cursor based on the given target.
// Resets the server available tokens to 0. SeekRequests past head result in
// stream breakage.
//
// SeekRequests may not be sent while another SeekRequest is outstanding (i.e.,
// has not received a SeekResponse) on the same stream.
type SeekRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target to seek to. Must be set.
	//
	// Types that are assignable to Target:
	//
	//	*SeekRequest_NamedTarget_
	//	*SeekRequest_Cursor
	Target isSeekRequest_Target `protobuf_oneof:"target"`
}

func (x *SeekRequest) Reset() {
	*x = SeekRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SeekRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SeekRequest) ProtoMessage() {}

func (x *SeekRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SeekRequest.ProtoReflect.Descriptor instead.
func (*SeekRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{2}
}

func (m *SeekRequest) GetTarget() isSeekRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *SeekRequest) GetNamedTarget() SeekRequest_NamedTarget {
	if x, ok := x.GetTarget().(*SeekRequest_NamedTarget_); ok {
		return x.NamedTarget
	}
	return SeekRequest_NAMED_TARGET_UNSPECIFIED
}

func (x *SeekRequest) GetCursor() *Cursor {
	if x, ok := x.GetTarget().(*SeekRequest_Cursor); ok {
		return x.Cursor
	}
	return nil
}

type isSeekRequest_Target interface {
	isSeekRequest_Target()
}

type SeekRequest_NamedTarget_ struct {
	// A named target.
	NamedTarget SeekRequest_NamedTarget `protobuf:"varint,1,opt,name=named_target,json=namedTarget,proto3,enum=google.cloud.pubsublite.v1.SeekRequest_NamedTarget,oneof"`
}

type SeekRequest_Cursor struct {
	// A target corresponding to the cursor, pointing to anywhere in the
	// topic partition.
	Cursor *Cursor `protobuf:"bytes,2,opt,name=cursor,proto3,oneof"`
}

func (*SeekRequest_NamedTarget_) isSeekRequest_Target() {}

func (*SeekRequest_Cursor) isSeekRequest_Target() {}

// Response to a SeekRequest.
type SeekResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new delivery cursor for the current stream.
	Cursor *Cursor `protobuf:"bytes,1,opt,name=cursor,proto3" json:"cursor,omitempty"`
}

func (x *SeekResponse) Reset() {
	*x = SeekResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SeekResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SeekResponse) ProtoMessage() {}

func (x *SeekResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SeekResponse.ProtoReflect.Descriptor instead.
func (*SeekResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{3}
}

func (x *SeekResponse) GetCursor() *Cursor {
	if x != nil {
		return x.Cursor
	}
	return nil
}

// Request to grant tokens to the server, requesting delivery of messages when
// they become available.
type FlowControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of message tokens to grant. Must be greater than or equal to 0.
	AllowedMessages int64 `protobuf:"varint,1,opt,name=allowed_messages,json=allowedMessages,proto3" json:"allowed_messages,omitempty"`
	// The number of byte tokens to grant. Must be greater than or equal to 0.
	AllowedBytes int64 `protobuf:"varint,2,opt,name=allowed_bytes,json=allowedBytes,proto3" json:"allowed_bytes,omitempty"`
}

func (x *FlowControlRequest) Reset() {
	*x = FlowControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FlowControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowControlRequest) ProtoMessage() {}

func (x *FlowControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowControlRequest.ProtoReflect.Descriptor instead.
func (*FlowControlRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{4}
}

func (x *FlowControlRequest) GetAllowedMessages() int64 {
	if x != nil {
		return x.AllowedMessages
	}
	return 0
}

func (x *FlowControlRequest) GetAllowedBytes() int64 {
	if x != nil {
		return x.AllowedBytes
	}
	return 0
}

// A request sent from the client to the server on a stream.
type SubscribeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of request this is.
	//
	// Types that are assignable to Request:
	//
	//	*SubscribeRequest_Initial
	//	*SubscribeRequest_Seek
	//	*SubscribeRequest_FlowControl
	Request isSubscribeRequest_Request `protobuf_oneof:"request"`
}

func (x *SubscribeRequest) Reset() {
	*x = SubscribeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeRequest) ProtoMessage() {}

func (x *SubscribeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeRequest.ProtoReflect.Descriptor instead.
func (*SubscribeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{5}
}

func (m *SubscribeRequest) GetRequest() isSubscribeRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *SubscribeRequest) GetInitial() *InitialSubscribeRequest {
	if x, ok := x.GetRequest().(*SubscribeRequest_Initial); ok {
		return x.Initial
	}
	return nil
}

func (x *SubscribeRequest) GetSeek() *SeekRequest {
	if x, ok := x.GetRequest().(*SubscribeRequest_Seek); ok {
		return x.Seek
	}
	return nil
}

func (x *SubscribeRequest) GetFlowControl() *FlowControlRequest {
	if x, ok := x.GetRequest().(*SubscribeRequest_FlowControl); ok {
		return x.FlowControl
	}
	return nil
}

type isSubscribeRequest_Request interface {
	isSubscribeRequest_Request()
}

type SubscribeRequest_Initial struct {
	// Initial request on the stream.
	Initial *InitialSubscribeRequest `protobuf:"bytes,1,opt,name=initial,proto3,oneof"`
}

type SubscribeRequest_Seek struct {
	// Request to update the stream's delivery cursor.
	Seek *SeekRequest `protobuf:"bytes,2,opt,name=seek,proto3,oneof"`
}

type SubscribeRequest_FlowControl struct {
	// Request to grant tokens to the server,
	FlowControl *FlowControlRequest `protobuf:"bytes,3,opt,name=flow_control,json=flowControl,proto3,oneof"`
}

func (*SubscribeRequest_Initial) isSubscribeRequest_Request() {}

func (*SubscribeRequest_Seek) isSubscribeRequest_Request() {}

func (*SubscribeRequest_FlowControl) isSubscribeRequest_Request() {}

// Response containing a list of messages. Upon delivering a MessageResponse to
// the client, the server:
//   - Updates the stream's delivery cursor to one greater than the cursor of the
//     last message in the list.
//   - Subtracts the total number of bytes and messages from the tokens available
//     to the server.
type MessageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Messages from the topic partition.
	Messages []*SequencedMessage `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
}

func (x *MessageResponse) Reset() {
	*x = MessageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageResponse) ProtoMessage() {}

func (x *MessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageResponse.ProtoReflect.Descriptor instead.
func (*MessageResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{6}
}

func (x *MessageResponse) GetMessages() []*SequencedMessage {
	if x != nil {
		return x.Messages
	}
	return nil
}

// Response to SubscribeRequest.
type SubscribeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of response this is.
	//
	// Types that are assignable to Response:
	//
	//	*SubscribeResponse_Initial
	//	*SubscribeResponse_Seek
	//	*SubscribeResponse_Messages
	Response isSubscribeResponse_Response `protobuf_oneof:"response"`
}

func (x *SubscribeResponse) Reset() {
	*x = SubscribeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeResponse) ProtoMessage() {}

func (x *SubscribeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeResponse.ProtoReflect.Descriptor instead.
func (*SubscribeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{7}
}

func (m *SubscribeResponse) GetResponse() isSubscribeResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *SubscribeResponse) GetInitial() *InitialSubscribeResponse {
	if x, ok := x.GetResponse().(*SubscribeResponse_Initial); ok {
		return x.Initial
	}
	return nil
}

func (x *SubscribeResponse) GetSeek() *SeekResponse {
	if x, ok := x.GetResponse().(*SubscribeResponse_Seek); ok {
		return x.Seek
	}
	return nil
}

func (x *SubscribeResponse) GetMessages() *MessageResponse {
	if x, ok := x.GetResponse().(*SubscribeResponse_Messages); ok {
		return x.Messages
	}
	return nil
}

type isSubscribeResponse_Response interface {
	isSubscribeResponse_Response()
}

type SubscribeResponse_Initial struct {
	// Initial response on the stream.
	Initial *InitialSubscribeResponse `protobuf:"bytes,1,opt,name=initial,proto3,oneof"`
}

type SubscribeResponse_Seek struct {
	// Response to a Seek operation.
	Seek *SeekResponse `protobuf:"bytes,2,opt,name=seek,proto3,oneof"`
}

type SubscribeResponse_Messages struct {
	// Response containing messages from the topic partition.
	Messages *MessageResponse `protobuf:"bytes,3,opt,name=messages,proto3,oneof"`
}

func (*SubscribeResponse_Initial) isSubscribeResponse_Response() {}

func (*SubscribeResponse_Seek) isSubscribeResponse_Response() {}

func (*SubscribeResponse_Messages) isSubscribeResponse_Response() {}

// The first request that must be sent on a newly-opened stream. The client must
// wait for the response before sending subsequent requests on the stream.
type InitialPartitionAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The subscription name. Structured like:
	// projects/<project number>/locations/<zone name>/subscriptions/<subscription
	// id>
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// An opaque, unique client identifier. This field must be exactly 16 bytes
	// long and is interpreted as an unsigned 128 bit integer. Other size values
	// will be rejected and the stream will be failed with a non-retryable error.
	//
	// This field is large enough to fit a uuid from standard uuid algorithms like
	// uuid1 or uuid4, which should be used to generate this number. The same
	// identifier should be reused following disconnections with retryable stream
	// errors.
	ClientId []byte `protobuf:"bytes,2,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
}

func (x *InitialPartitionAssignmentRequest) Reset() {
	*x = InitialPartitionAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitialPartitionAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitialPartitionAssignmentRequest) ProtoMessage() {}

func (x *InitialPartitionAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitialPartitionAssignmentRequest.ProtoReflect.Descriptor instead.
func (*InitialPartitionAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{8}
}

func (x *InitialPartitionAssignmentRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *InitialPartitionAssignmentRequest) GetClientId() []byte {
	if x != nil {
		return x.ClientId
	}
	return nil
}

// PartitionAssignments should not race with acknowledgements. There
// should be exactly one unacknowledged PartitionAssignment at a time. If not,
// the client must break the stream.
type PartitionAssignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of partition numbers this subscriber is assigned to.
	Partitions []int64 `protobuf:"varint,1,rep,packed,name=partitions,proto3" json:"partitions,omitempty"`
}

func (x *PartitionAssignment) Reset() {
	*x = PartitionAssignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionAssignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionAssignment) ProtoMessage() {}

func (x *PartitionAssignment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionAssignment.ProtoReflect.Descriptor instead.
func (*PartitionAssignment) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{9}
}

func (x *PartitionAssignment) GetPartitions() []int64 {
	if x != nil {
		return x.Partitions
	}
	return nil
}

// Acknowledge receipt and handling of the previous assignment.
// If not sent within a short period after receiving the assignment,
// partitions may remain unassigned for a period of time until the
// client is known to be inactive, after which time the server will break the
// stream.
type PartitionAssignmentAck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PartitionAssignmentAck) Reset() {
	*x = PartitionAssignmentAck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionAssignmentAck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionAssignmentAck) ProtoMessage() {}

func (x *PartitionAssignmentAck) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionAssignmentAck.ProtoReflect.Descriptor instead.
func (*PartitionAssignmentAck) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{10}
}

// A request on the PartitionAssignment stream.
type PartitionAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of request this is.
	//
	// Types that are assignable to Request:
	//
	//	*PartitionAssignmentRequest_Initial
	//	*PartitionAssignmentRequest_Ack
	Request isPartitionAssignmentRequest_Request `protobuf_oneof:"request"`
}

func (x *PartitionAssignmentRequest) Reset() {
	*x = PartitionAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionAssignmentRequest) ProtoMessage() {}

func (x *PartitionAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionAssignmentRequest.ProtoReflect.Descriptor instead.
func (*PartitionAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP(), []int{11}
}

func (m *PartitionAssignmentRequest) GetRequest() isPartitionAssignmentRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *PartitionAssignmentRequest) GetInitial() *InitialPartitionAssignmentRequest {
	if x, ok := x.GetRequest().(*PartitionAssignmentRequest_Initial); ok {
		return x.Initial
	}
	return nil
}

func (x *PartitionAssignmentRequest) GetAck() *PartitionAssignmentAck {
	if x, ok := x.GetRequest().(*PartitionAssignmentRequest_Ack); ok {
		return x.Ack
	}
	return nil
}

type isPartitionAssignmentRequest_Request interface {
	isPartitionAssignmentRequest_Request()
}

type PartitionAssignmentRequest_Initial struct {
	// Initial request on the stream.
	Initial *InitialPartitionAssignmentRequest `protobuf:"bytes,1,opt,name=initial,proto3,oneof"`
}

type PartitionAssignmentRequest_Ack struct {
	// Acknowledgement of a partition assignment.
	Ack *PartitionAssignmentAck `protobuf:"bytes,2,opt,name=ack,proto3,oneof"`
}

func (*PartitionAssignmentRequest_Initial) isPartitionAssignmentRequest_Request() {}

func (*PartitionAssignmentRequest_Ack) isPartitionAssignmentRequest_Request() {}

var File_google_cloud_pubsublite_v1_subscriber_proto protoreflect.FileDescriptor

var file_google_cloud_pubsublite_v1_subscriber_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb4, 0x01, 0x0a, 0x17, 0x49,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x10, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x65, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x56, 0x0a, 0x18, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a,
	0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f,
	0x72, 0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x22, 0xfc, 0x01, 0x0a, 0x0b, 0x53, 0x65,
	0x65, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0c, 0x6e, 0x61, 0x6d,
	0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x65,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f,
	0x72, 0x22, 0x4b, 0x0a, 0x0b, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x1c, 0x0a, 0x18, 0x4e, 0x41, 0x4d, 0x45, 0x44, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08,
	0x0a, 0x04, 0x48, 0x45, 0x41, 0x44, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4d, 0x4d,
	0x49, 0x54, 0x54, 0x45, 0x44, 0x5f, 0x43, 0x55, 0x52, 0x53, 0x4f, 0x52, 0x10, 0x02, 0x42, 0x08,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x4a, 0x0a, 0x0c, 0x53, 0x65, 0x65, 0x6b,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x06, 0x63, 0x75, 0x72, 0x73,
	0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69,
	0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x63, 0x75,
	0x72, 0x73, 0x6f, 0x72, 0x22, 0x64, 0x0a, 0x12, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x82, 0x02, 0x0a, 0x10, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4f, 0x0a, 0x07, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c,
	0x12, 0x3d, 0x0a, 0x04, 0x73, 0x65, 0x65, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x65, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x04, 0x73, 0x65, 0x65, 0x6b, 0x12,
	0x53, 0x0a, 0x0c, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22,
	0x5b, 0x0a, 0x0f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x52, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x22, 0xfc, 0x01, 0x0a,
	0x11, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x50, 0x0a, 0x07, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x07, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x12, 0x3e, 0x0a, 0x04, 0x73, 0x65, 0x65, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x65, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x04,
	0x73, 0x65, 0x65, 0x6b, 0x12, 0x49, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x42,
	0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x64, 0x0a, 0x21, 0x49,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x22, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x22, 0x35, 0x0a, 0x13, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0a, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x18, 0x0a, 0x16, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x41,
	0x63, 0x6b, 0x22, 0xca, 0x01, 0x0a, 0x1a, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x59, 0x0a, 0x07, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x07, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x46, 0x0a, 0x03,
	0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c,
	0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x6b, 0x48, 0x00, 0x52,
	0x03, 0x61, 0x63, 0x6b, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x32,
	0xd2, 0x01, 0x0a, 0x11, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x6e, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x62, 0x65, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x28, 0x01, 0x30, 0x01, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x32, 0xef, 0x01, 0x0a, 0x1a, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x81, 0x01, 0x0a, 0x10, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69,
	0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd3, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42, 0x0f, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65,
	0x70, 0x62, 0x3b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x70, 0x62, 0xf8,
	0x01, 0x01, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4c, 0x69, 0x74, 0x65, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50,
	0x75, 0x62, 0x53, 0x75, 0x62, 0x4c, 0x69, 0x74, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x50, 0x75,
	0x62, 0x53, 0x75, 0x62, 0x4c, 0x69, 0x74, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_pubsublite_v1_subscriber_proto_rawDescOnce sync.Once
	file_google_cloud_pubsublite_v1_subscriber_proto_rawDescData = file_google_cloud_pubsublite_v1_subscriber_proto_rawDesc
)

func file_google_cloud_pubsublite_v1_subscriber_proto_rawDescGZIP() []byte {
	file_google_cloud_pubsublite_v1_subscriber_proto_rawDescOnce.Do(func() {
		file_google_cloud_pubsublite_v1_subscriber_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_pubsublite_v1_subscriber_proto_rawDescData)
	})
	return file_google_cloud_pubsublite_v1_subscriber_proto_rawDescData
}

var file_google_cloud_pubsublite_v1_subscriber_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_pubsublite_v1_subscriber_proto_goTypes = []interface{}{
	(SeekRequest_NamedTarget)(0),              // 0: google.cloud.pubsublite.v1.SeekRequest.NamedTarget
	(*InitialSubscribeRequest)(nil),           // 1: google.cloud.pubsublite.v1.InitialSubscribeRequest
	(*InitialSubscribeResponse)(nil),          // 2: google.cloud.pubsublite.v1.InitialSubscribeResponse
	(*SeekRequest)(nil),                       // 3: google.cloud.pubsublite.v1.SeekRequest
	(*SeekResponse)(nil),                      // 4: google.cloud.pubsublite.v1.SeekResponse
	(*FlowControlRequest)(nil),                // 5: google.cloud.pubsublite.v1.FlowControlRequest
	(*SubscribeRequest)(nil),                  // 6: google.cloud.pubsublite.v1.SubscribeRequest
	(*MessageResponse)(nil),                   // 7: google.cloud.pubsublite.v1.MessageResponse
	(*SubscribeResponse)(nil),                 // 8: google.cloud.pubsublite.v1.SubscribeResponse
	(*InitialPartitionAssignmentRequest)(nil), // 9: google.cloud.pubsublite.v1.InitialPartitionAssignmentRequest
	(*PartitionAssignment)(nil),               // 10: google.cloud.pubsublite.v1.PartitionAssignment
	(*PartitionAssignmentAck)(nil),            // 11: google.cloud.pubsublite.v1.PartitionAssignmentAck
	(*PartitionAssignmentRequest)(nil),        // 12: google.cloud.pubsublite.v1.PartitionAssignmentRequest
	(*Cursor)(nil),                            // 13: google.cloud.pubsublite.v1.Cursor
	(*SequencedMessage)(nil),                  // 14: google.cloud.pubsublite.v1.SequencedMessage
}
var file_google_cloud_pubsublite_v1_subscriber_proto_depIdxs = []int32{
	3,  // 0: google.cloud.pubsublite.v1.InitialSubscribeRequest.initial_location:type_name -> google.cloud.pubsublite.v1.SeekRequest
	13, // 1: google.cloud.pubsublite.v1.InitialSubscribeResponse.cursor:type_name -> google.cloud.pubsublite.v1.Cursor
	0,  // 2: google.cloud.pubsublite.v1.SeekRequest.named_target:type_name -> google.cloud.pubsublite.v1.SeekRequest.NamedTarget
	13, // 3: google.cloud.pubsublite.v1.SeekRequest.cursor:type_name -> google.cloud.pubsublite.v1.Cursor
	13, // 4: google.cloud.pubsublite.v1.SeekResponse.cursor:type_name -> google.cloud.pubsublite.v1.Cursor
	1,  // 5: google.cloud.pubsublite.v1.SubscribeRequest.initial:type_name -> google.cloud.pubsublite.v1.InitialSubscribeRequest
	3,  // 6: google.cloud.pubsublite.v1.SubscribeRequest.seek:type_name -> google.cloud.pubsublite.v1.SeekRequest
	5,  // 7: google.cloud.pubsublite.v1.SubscribeRequest.flow_control:type_name -> google.cloud.pubsublite.v1.FlowControlRequest
	14, // 8: google.cloud.pubsublite.v1.MessageResponse.messages:type_name -> google.cloud.pubsublite.v1.SequencedMessage
	2,  // 9: google.cloud.pubsublite.v1.SubscribeResponse.initial:type_name -> google.cloud.pubsublite.v1.InitialSubscribeResponse
	4,  // 10: google.cloud.pubsublite.v1.SubscribeResponse.seek:type_name -> google.cloud.pubsublite.v1.SeekResponse
	7,  // 11: google.cloud.pubsublite.v1.SubscribeResponse.messages:type_name -> google.cloud.pubsublite.v1.MessageResponse
	9,  // 12: google.cloud.pubsublite.v1.PartitionAssignmentRequest.initial:type_name -> google.cloud.pubsublite.v1.InitialPartitionAssignmentRequest
	11, // 13: google.cloud.pubsublite.v1.PartitionAssignmentRequest.ack:type_name -> google.cloud.pubsublite.v1.PartitionAssignmentAck
	6,  // 14: google.cloud.pubsublite.v1.SubscriberService.Subscribe:input_type -> google.cloud.pubsublite.v1.SubscribeRequest
	12, // 15: google.cloud.pubsublite.v1.PartitionAssignmentService.AssignPartitions:input_type -> google.cloud.pubsublite.v1.PartitionAssignmentRequest
	8,  // 16: google.cloud.pubsublite.v1.SubscriberService.Subscribe:output_type -> google.cloud.pubsublite.v1.SubscribeResponse
	10, // 17: google.cloud.pubsublite.v1.PartitionAssignmentService.AssignPartitions:output_type -> google.cloud.pubsublite.v1.PartitionAssignment
	16, // [16:18] is the sub-list for method output_type
	14, // [14:16] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_pubsublite_v1_subscriber_proto_init() }
func file_google_cloud_pubsublite_v1_subscriber_proto_init() {
	if File_google_cloud_pubsublite_v1_subscriber_proto != nil {
		return
	}
	file_google_cloud_pubsublite_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitialSubscribeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitialSubscribeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SeekRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SeekResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FlowControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitialPartitionAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionAssignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionAssignmentAck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*SeekRequest_NamedTarget_)(nil),
		(*SeekRequest_Cursor)(nil),
	}
	file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*SubscribeRequest_Initial)(nil),
		(*SubscribeRequest_Seek)(nil),
		(*SubscribeRequest_FlowControl)(nil),
	}
	file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*SubscribeResponse_Initial)(nil),
		(*SubscribeResponse_Seek)(nil),
		(*SubscribeResponse_Messages)(nil),
	}
	file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*PartitionAssignmentRequest_Initial)(nil),
		(*PartitionAssignmentRequest_Ack)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_pubsublite_v1_subscriber_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_google_cloud_pubsublite_v1_subscriber_proto_goTypes,
		DependencyIndexes: file_google_cloud_pubsublite_v1_subscriber_proto_depIdxs,
		EnumInfos:         file_google_cloud_pubsublite_v1_subscriber_proto_enumTypes,
		MessageInfos:      file_google_cloud_pubsublite_v1_subscriber_proto_msgTypes,
	}.Build()
	File_google_cloud_pubsublite_v1_subscriber_proto = out.File
	file_google_cloud_pubsublite_v1_subscriber_proto_rawDesc = nil
	file_google_cloud_pubsublite_v1_subscriber_proto_goTypes = nil
	file_google_cloud_pubsublite_v1_subscriber_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SubscriberServiceClient is the client API for SubscriberService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SubscriberServiceClient interface {
	// Establishes a stream with the server for receiving messages.
	Subscribe(ctx context.Context, opts ...grpc.CallOption) (SubscriberService_SubscribeClient, error)
}

type subscriberServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSubscriberServiceClient(cc grpc.ClientConnInterface) SubscriberServiceClient {
	return &subscriberServiceClient{cc}
}

func (c *subscriberServiceClient) Subscribe(ctx context.Context, opts ...grpc.CallOption) (SubscriberService_SubscribeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SubscriberService_serviceDesc.Streams[0], "/google.cloud.pubsublite.v1.SubscriberService/Subscribe", opts...)
	if err != nil {
		return nil, err
	}
	x := &subscriberServiceSubscribeClient{stream}
	return x, nil
}

type SubscriberService_SubscribeClient interface {
	Send(*SubscribeRequest) error
	Recv() (*SubscribeResponse, error)
	grpc.ClientStream
}

type subscriberServiceSubscribeClient struct {
	grpc.ClientStream
}

func (x *subscriberServiceSubscribeClient) Send(m *SubscribeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *subscriberServiceSubscribeClient) Recv() (*SubscribeResponse, error) {
	m := new(SubscribeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SubscriberServiceServer is the server API for SubscriberService service.
type SubscriberServiceServer interface {
	// Establishes a stream with the server for receiving messages.
	Subscribe(SubscriberService_SubscribeServer) error
}

// UnimplementedSubscriberServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSubscriberServiceServer struct {
}

func (*UnimplementedSubscriberServiceServer) Subscribe(SubscriberService_SubscribeServer) error {
	return status.Errorf(codes.Unimplemented, "method Subscribe not implemented")
}

func RegisterSubscriberServiceServer(s *grpc.Server, srv SubscriberServiceServer) {
	s.RegisterService(&_SubscriberService_serviceDesc, srv)
}

func _SubscriberService_Subscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SubscriberServiceServer).Subscribe(&subscriberServiceSubscribeServer{stream})
}

type SubscriberService_SubscribeServer interface {
	Send(*SubscribeResponse) error
	Recv() (*SubscribeRequest, error)
	grpc.ServerStream
}

type subscriberServiceSubscribeServer struct {
	grpc.ServerStream
}

func (x *subscriberServiceSubscribeServer) Send(m *SubscribeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *subscriberServiceSubscribeServer) Recv() (*SubscribeRequest, error) {
	m := new(SubscribeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _SubscriberService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.pubsublite.v1.SubscriberService",
	HandlerType: (*SubscriberServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Subscribe",
			Handler:       _SubscriberService_Subscribe_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/pubsublite/v1/subscriber.proto",
}

// PartitionAssignmentServiceClient is the client API for PartitionAssignmentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PartitionAssignmentServiceClient interface {
	// Assign partitions for this client to handle for the specified subscription.
	//
	// The client must send an InitialPartitionAssignmentRequest first.
	// The server will then send at most one unacknowledged PartitionAssignment
	// outstanding on the stream at a time.
	// The client should send a PartitionAssignmentAck after updating the
	// partitions it is connected to to reflect the new assignment.
	AssignPartitions(ctx context.Context, opts ...grpc.CallOption) (PartitionAssignmentService_AssignPartitionsClient, error)
}

type partitionAssignmentServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPartitionAssignmentServiceClient(cc grpc.ClientConnInterface) PartitionAssignmentServiceClient {
	return &partitionAssignmentServiceClient{cc}
}

func (c *partitionAssignmentServiceClient) AssignPartitions(ctx context.Context, opts ...grpc.CallOption) (PartitionAssignmentService_AssignPartitionsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_PartitionAssignmentService_serviceDesc.Streams[0], "/google.cloud.pubsublite.v1.PartitionAssignmentService/AssignPartitions", opts...)
	if err != nil {
		return nil, err
	}
	x := &partitionAssignmentServiceAssignPartitionsClient{stream}
	return x, nil
}

type PartitionAssignmentService_AssignPartitionsClient interface {
	Send(*PartitionAssignmentRequest) error
	Recv() (*PartitionAssignment, error)
	grpc.ClientStream
}

type partitionAssignmentServiceAssignPartitionsClient struct {
	grpc.ClientStream
}

func (x *partitionAssignmentServiceAssignPartitionsClient) Send(m *PartitionAssignmentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *partitionAssignmentServiceAssignPartitionsClient) Recv() (*PartitionAssignment, error) {
	m := new(PartitionAssignment)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// PartitionAssignmentServiceServer is the server API for PartitionAssignmentService service.
type PartitionAssignmentServiceServer interface {
	// Assign partitions for this client to handle for the specified subscription.
	//
	// The client must send an InitialPartitionAssignmentRequest first.
	// The server will then send at most one unacknowledged PartitionAssignment
	// outstanding on the stream at a time.
	// The client should send a PartitionAssignmentAck after updating the
	// partitions it is connected to to reflect the new assignment.
	AssignPartitions(PartitionAssignmentService_AssignPartitionsServer) error
}

// UnimplementedPartitionAssignmentServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPartitionAssignmentServiceServer struct {
}

func (*UnimplementedPartitionAssignmentServiceServer) AssignPartitions(PartitionAssignmentService_AssignPartitionsServer) error {
	return status.Errorf(codes.Unimplemented, "method AssignPartitions not implemented")
}

func RegisterPartitionAssignmentServiceServer(s *grpc.Server, srv PartitionAssignmentServiceServer) {
	s.RegisterService(&_PartitionAssignmentService_serviceDesc, srv)
}

func _PartitionAssignmentService_AssignPartitions_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PartitionAssignmentServiceServer).AssignPartitions(&partitionAssignmentServiceAssignPartitionsServer{stream})
}

type PartitionAssignmentService_AssignPartitionsServer interface {
	Send(*PartitionAssignment) error
	Recv() (*PartitionAssignmentRequest, error)
	grpc.ServerStream
}

type partitionAssignmentServiceAssignPartitionsServer struct {
	grpc.ServerStream
}

func (x *partitionAssignmentServiceAssignPartitionsServer) Send(m *PartitionAssignment) error {
	return x.ServerStream.SendMsg(m)
}

func (x *partitionAssignmentServiceAssignPartitionsServer) Recv() (*PartitionAssignmentRequest, error) {
	m := new(PartitionAssignmentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _PartitionAssignmentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.pubsublite.v1.PartitionAssignmentService",
	HandlerType: (*PartitionAssignmentServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "AssignPartitions",
			Handler:       _PartitionAssignmentService_AssignPartitions_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/pubsublite/v1/subscriber.proto",
}
