// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/notebook_execution_job.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// NotebookExecutionJob represents an instance of a notebook execution.
type NotebookExecutionJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The input notebook.
	//
	// Types that are assignable to NotebookSource:
	//
	//	*NotebookExecutionJob_DataformRepositorySource_
	//	*NotebookExecutionJob_GcsNotebookSource_
	//	*NotebookExecutionJob_DirectNotebookSource_
	NotebookSource isNotebookExecutionJob_NotebookSource `protobuf_oneof:"notebook_source"`
	// The compute config to use for an execution job.
	//
	// Types that are assignable to EnvironmentSpec:
	//
	//	*NotebookExecutionJob_NotebookRuntimeTemplateResourceName
	EnvironmentSpec isNotebookExecutionJob_EnvironmentSpec `protobuf_oneof:"environment_spec"`
	// The location to store the notebook execution result.
	//
	// Types that are assignable to ExecutionSink:
	//
	//	*NotebookExecutionJob_GcsOutputUri
	ExecutionSink isNotebookExecutionJob_ExecutionSink `protobuf_oneof:"execution_sink"`
	// The identity to run the execution as.
	//
	// Types that are assignable to ExecutionIdentity:
	//
	//	*NotebookExecutionJob_ExecutionUser
	//	*NotebookExecutionJob_ServiceAccount
	ExecutionIdentity isNotebookExecutionJob_ExecutionIdentity `protobuf_oneof:"execution_identity"`
	// Output only. The resource name of this NotebookExecutionJob. Format:
	// `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The display name of the NotebookExecutionJob. The name can be up to 128
	// characters long and can consist of any UTF-8 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Max running time of the execution job in seconds (default 86400s / 24 hrs).
	ExecutionTimeout *durationpb.Duration `protobuf:"bytes,5,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
	// Output only. The Schedule resource name if this job is triggered by one.
	// Format:
	// `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
	ScheduleResourceName string `protobuf:"bytes,6,opt,name=schedule_resource_name,json=scheduleResourceName,proto3" json:"schedule_resource_name,omitempty"`
	// Output only. The state of the NotebookExecutionJob.
	JobState JobState `protobuf:"varint,10,opt,name=job_state,json=jobState,proto3,enum=google.cloud.aiplatform.v1beta1.JobState" json:"job_state,omitempty"`
	// Output only. Populated when the NotebookExecutionJob is completed. When
	// there is an error during notebook execution, the error details are
	// populated.
	Status *status.Status `protobuf:"bytes,11,opt,name=status,proto3" json:"status,omitempty"`
	// Output only. Timestamp when this NotebookExecutionJob was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this NotebookExecutionJob was most recently
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The labels with user-defined metadata to organize NotebookExecutionJobs.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	// System reserved label keys are prefixed with "aiplatform.googleapis.com/"
	// and are immutable.
	Labels map[string]string `protobuf:"bytes,19,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *NotebookExecutionJob) Reset() {
	*x = NotebookExecutionJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotebookExecutionJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotebookExecutionJob) ProtoMessage() {}

func (x *NotebookExecutionJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotebookExecutionJob.ProtoReflect.Descriptor instead.
func (*NotebookExecutionJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescGZIP(), []int{0}
}

func (m *NotebookExecutionJob) GetNotebookSource() isNotebookExecutionJob_NotebookSource {
	if m != nil {
		return m.NotebookSource
	}
	return nil
}

func (x *NotebookExecutionJob) GetDataformRepositorySource() *NotebookExecutionJob_DataformRepositorySource {
	if x, ok := x.GetNotebookSource().(*NotebookExecutionJob_DataformRepositorySource_); ok {
		return x.DataformRepositorySource
	}
	return nil
}

func (x *NotebookExecutionJob) GetGcsNotebookSource() *NotebookExecutionJob_GcsNotebookSource {
	if x, ok := x.GetNotebookSource().(*NotebookExecutionJob_GcsNotebookSource_); ok {
		return x.GcsNotebookSource
	}
	return nil
}

func (x *NotebookExecutionJob) GetDirectNotebookSource() *NotebookExecutionJob_DirectNotebookSource {
	if x, ok := x.GetNotebookSource().(*NotebookExecutionJob_DirectNotebookSource_); ok {
		return x.DirectNotebookSource
	}
	return nil
}

func (m *NotebookExecutionJob) GetEnvironmentSpec() isNotebookExecutionJob_EnvironmentSpec {
	if m != nil {
		return m.EnvironmentSpec
	}
	return nil
}

func (x *NotebookExecutionJob) GetNotebookRuntimeTemplateResourceName() string {
	if x, ok := x.GetEnvironmentSpec().(*NotebookExecutionJob_NotebookRuntimeTemplateResourceName); ok {
		return x.NotebookRuntimeTemplateResourceName
	}
	return ""
}

func (m *NotebookExecutionJob) GetExecutionSink() isNotebookExecutionJob_ExecutionSink {
	if m != nil {
		return m.ExecutionSink
	}
	return nil
}

func (x *NotebookExecutionJob) GetGcsOutputUri() string {
	if x, ok := x.GetExecutionSink().(*NotebookExecutionJob_GcsOutputUri); ok {
		return x.GcsOutputUri
	}
	return ""
}

func (m *NotebookExecutionJob) GetExecutionIdentity() isNotebookExecutionJob_ExecutionIdentity {
	if m != nil {
		return m.ExecutionIdentity
	}
	return nil
}

func (x *NotebookExecutionJob) GetExecutionUser() string {
	if x, ok := x.GetExecutionIdentity().(*NotebookExecutionJob_ExecutionUser); ok {
		return x.ExecutionUser
	}
	return ""
}

func (x *NotebookExecutionJob) GetServiceAccount() string {
	if x, ok := x.GetExecutionIdentity().(*NotebookExecutionJob_ServiceAccount); ok {
		return x.ServiceAccount
	}
	return ""
}

func (x *NotebookExecutionJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NotebookExecutionJob) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *NotebookExecutionJob) GetExecutionTimeout() *durationpb.Duration {
	if x != nil {
		return x.ExecutionTimeout
	}
	return nil
}

func (x *NotebookExecutionJob) GetScheduleResourceName() string {
	if x != nil {
		return x.ScheduleResourceName
	}
	return ""
}

func (x *NotebookExecutionJob) GetJobState() JobState {
	if x != nil {
		return x.JobState
	}
	return JobState_JOB_STATE_UNSPECIFIED
}

func (x *NotebookExecutionJob) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *NotebookExecutionJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *NotebookExecutionJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *NotebookExecutionJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isNotebookExecutionJob_NotebookSource interface {
	isNotebookExecutionJob_NotebookSource()
}

type NotebookExecutionJob_DataformRepositorySource_ struct {
	// The Dataform Repository pointing to a single file notebook repository.
	DataformRepositorySource *NotebookExecutionJob_DataformRepositorySource `protobuf:"bytes,3,opt,name=dataform_repository_source,json=dataformRepositorySource,proto3,oneof"`
}

type NotebookExecutionJob_GcsNotebookSource_ struct {
	// The Cloud Storage url pointing to the ipynb file. Format:
	// `gs://bucket/notebook_file.ipynb`
	GcsNotebookSource *NotebookExecutionJob_GcsNotebookSource `protobuf:"bytes,4,opt,name=gcs_notebook_source,json=gcsNotebookSource,proto3,oneof"`
}

type NotebookExecutionJob_DirectNotebookSource_ struct {
	// The contents of an input notebook file.
	DirectNotebookSource *NotebookExecutionJob_DirectNotebookSource `protobuf:"bytes,17,opt,name=direct_notebook_source,json=directNotebookSource,proto3,oneof"`
}

func (*NotebookExecutionJob_DataformRepositorySource_) isNotebookExecutionJob_NotebookSource() {}

func (*NotebookExecutionJob_GcsNotebookSource_) isNotebookExecutionJob_NotebookSource() {}

func (*NotebookExecutionJob_DirectNotebookSource_) isNotebookExecutionJob_NotebookSource() {}

type isNotebookExecutionJob_EnvironmentSpec interface {
	isNotebookExecutionJob_EnvironmentSpec()
}

type NotebookExecutionJob_NotebookRuntimeTemplateResourceName struct {
	// The NotebookRuntimeTemplate to source compute configuration from.
	NotebookRuntimeTemplateResourceName string `protobuf:"bytes,14,opt,name=notebook_runtime_template_resource_name,json=notebookRuntimeTemplateResourceName,proto3,oneof"`
}

func (*NotebookExecutionJob_NotebookRuntimeTemplateResourceName) isNotebookExecutionJob_EnvironmentSpec() {
}

type isNotebookExecutionJob_ExecutionSink interface {
	isNotebookExecutionJob_ExecutionSink()
}

type NotebookExecutionJob_GcsOutputUri struct {
	// The Cloud Storage location to upload the result to. Format:
	// `gs://bucket-name`
	GcsOutputUri string `protobuf:"bytes,8,opt,name=gcs_output_uri,json=gcsOutputUri,proto3,oneof"`
}

func (*NotebookExecutionJob_GcsOutputUri) isNotebookExecutionJob_ExecutionSink() {}

type isNotebookExecutionJob_ExecutionIdentity interface {
	isNotebookExecutionJob_ExecutionIdentity()
}

type NotebookExecutionJob_ExecutionUser struct {
	// The user email to run the execution as. Only supported by Colab runtimes.
	ExecutionUser string `protobuf:"bytes,9,opt,name=execution_user,json=executionUser,proto3,oneof"`
}

type NotebookExecutionJob_ServiceAccount struct {
	// The service account to run the execution as.
	ServiceAccount string `protobuf:"bytes,18,opt,name=service_account,json=serviceAccount,proto3,oneof"`
}

func (*NotebookExecutionJob_ExecutionUser) isNotebookExecutionJob_ExecutionIdentity() {}

func (*NotebookExecutionJob_ServiceAccount) isNotebookExecutionJob_ExecutionIdentity() {}

// The Dataform Repository containing the input notebook.
type NotebookExecutionJob_DataformRepositorySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Dataform Repository. Format:
	// `projects/{project_id}/locations/{location}/repositories/{repository_id}`
	DataformRepositoryResourceName string `protobuf:"bytes,1,opt,name=dataform_repository_resource_name,json=dataformRepositoryResourceName,proto3" json:"dataform_repository_resource_name,omitempty"`
	// The commit SHA to read repository with. If unset, the file will be read
	// at HEAD.
	CommitSha string `protobuf:"bytes,2,opt,name=commit_sha,json=commitSha,proto3" json:"commit_sha,omitempty"`
}

func (x *NotebookExecutionJob_DataformRepositorySource) Reset() {
	*x = NotebookExecutionJob_DataformRepositorySource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotebookExecutionJob_DataformRepositorySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotebookExecutionJob_DataformRepositorySource) ProtoMessage() {}

func (x *NotebookExecutionJob_DataformRepositorySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotebookExecutionJob_DataformRepositorySource.ProtoReflect.Descriptor instead.
func (*NotebookExecutionJob_DataformRepositorySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescGZIP(), []int{0, 0}
}

func (x *NotebookExecutionJob_DataformRepositorySource) GetDataformRepositoryResourceName() string {
	if x != nil {
		return x.DataformRepositoryResourceName
	}
	return ""
}

func (x *NotebookExecutionJob_DataformRepositorySource) GetCommitSha() string {
	if x != nil {
		return x.CommitSha
	}
	return ""
}

// The Cloud Storage uri for the input notebook.
type NotebookExecutionJob_GcsNotebookSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Storage uri pointing to the ipynb file. Format:
	// `gs://bucket/notebook_file.ipynb`
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The version of the Cloud Storage object to read. If unset, the current
	// version of the object is read. See
	// https://cloud.google.com/storage/docs/metadata#generation-number.
	Generation string `protobuf:"bytes,2,opt,name=generation,proto3" json:"generation,omitempty"`
}

func (x *NotebookExecutionJob_GcsNotebookSource) Reset() {
	*x = NotebookExecutionJob_GcsNotebookSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotebookExecutionJob_GcsNotebookSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotebookExecutionJob_GcsNotebookSource) ProtoMessage() {}

func (x *NotebookExecutionJob_GcsNotebookSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotebookExecutionJob_GcsNotebookSource.ProtoReflect.Descriptor instead.
func (*NotebookExecutionJob_GcsNotebookSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescGZIP(), []int{0, 1}
}

func (x *NotebookExecutionJob_GcsNotebookSource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *NotebookExecutionJob_GcsNotebookSource) GetGeneration() string {
	if x != nil {
		return x.Generation
	}
	return ""
}

// The content of the input notebook in ipynb format.
type NotebookExecutionJob_DirectNotebookSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The base64-encoded contents of the input notebook file.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *NotebookExecutionJob_DirectNotebookSource) Reset() {
	*x = NotebookExecutionJob_DirectNotebookSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotebookExecutionJob_DirectNotebookSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotebookExecutionJob_DirectNotebookSource) ProtoMessage() {}

func (x *NotebookExecutionJob_DirectNotebookSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotebookExecutionJob_DirectNotebookSource.ProtoReflect.Descriptor instead.
func (*NotebookExecutionJob_DirectNotebookSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescGZIP(), []int{0, 2}
}

func (x *NotebookExecutionJob_DirectNotebookSource) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6a, 0x6f, 0x62,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbd, 0x0e, 0x0a, 0x14, 0x4e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12,
	0x8e, 0x01, 0x0a, 0x1a, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x18, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x79, 0x0a, 0x13, 0x67, 0x63, 0x73, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x47, 0x63, 0x73, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x11, 0x67, 0x63, 0x73, 0x4e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x16,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x14, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x8e, 0x01, 0x0a, 0x27, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x36, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x48, 0x01, 0x52, 0x23, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x26, 0x0a, 0x0e, 0x67, 0x63, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x0c, 0x67, 0x63, 0x73,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x27, 0x0a, 0x0e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x03, 0x52, 0x0d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73,
	0x65, 0x72, 0x12, 0x29, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x0e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x11, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x12, 0x60, 0x0a, 0x16, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x14, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x09, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x2f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x13, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x1a, 0x84, 0x01, 0x0a, 0x18, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x49, 0x0a,
	0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x53, 0x68, 0x61, 0x1a, 0x45, 0x0a, 0x11, 0x47, 0x63, 0x73, 0x4e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1e,
	0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x30,
	0x0a, 0x14, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xb9, 0x01, 0xea, 0x41,
	0xb5, 0x01, 0x0a, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x12, 0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x2a, 0x15, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x73, 0x32, 0x14, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x42, 0x11, 0x0a, 0x0f, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x42, 0x10,
	0x0a, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x6e, 0x6b,
	0x42, 0x14, 0x0a, 0x12, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0xf0, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x19,
	0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74,
	0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_goTypes = []interface{}{
	(*NotebookExecutionJob)(nil),                          // 0: google.cloud.aiplatform.v1beta1.NotebookExecutionJob
	(*NotebookExecutionJob_DataformRepositorySource)(nil), // 1: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
	(*NotebookExecutionJob_GcsNotebookSource)(nil),        // 2: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
	(*NotebookExecutionJob_DirectNotebookSource)(nil),     // 3: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
	nil,                           // 4: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.LabelsEntry
	(*durationpb.Duration)(nil),   // 5: google.protobuf.Duration
	(JobState)(0),                 // 6: google.cloud.aiplatform.v1beta1.JobState
	(*status.Status)(nil),         // 7: google.rpc.Status
	(*timestamppb.Timestamp)(nil), // 8: google.protobuf.Timestamp
}
var file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_depIdxs = []int32{
	1, // 0: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.dataform_repository_source:type_name -> google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DataformRepositorySource
	2, // 1: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.gcs_notebook_source:type_name -> google.cloud.aiplatform.v1beta1.NotebookExecutionJob.GcsNotebookSource
	3, // 2: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.direct_notebook_source:type_name -> google.cloud.aiplatform.v1beta1.NotebookExecutionJob.DirectNotebookSource
	5, // 3: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.execution_timeout:type_name -> google.protobuf.Duration
	6, // 4: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.job_state:type_name -> google.cloud.aiplatform.v1beta1.JobState
	7, // 5: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.status:type_name -> google.rpc.Status
	8, // 6: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.create_time:type_name -> google.protobuf.Timestamp
	8, // 7: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.update_time:type_name -> google.protobuf.Timestamp
	4, // 8: google.cloud.aiplatform.v1beta1.NotebookExecutionJob.labels:type_name -> google.cloud.aiplatform.v1beta1.NotebookExecutionJob.LabelsEntry
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_init() }
func file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_job_state_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotebookExecutionJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotebookExecutionJob_DataformRepositorySource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotebookExecutionJob_GcsNotebookSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotebookExecutionJob_DirectNotebookSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*NotebookExecutionJob_DataformRepositorySource_)(nil),
		(*NotebookExecutionJob_GcsNotebookSource_)(nil),
		(*NotebookExecutionJob_DirectNotebookSource_)(nil),
		(*NotebookExecutionJob_NotebookRuntimeTemplateResourceName)(nil),
		(*NotebookExecutionJob_GcsOutputUri)(nil),
		(*NotebookExecutionJob_ExecutionUser)(nil),
		(*NotebookExecutionJob_ServiceAccount)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto = out.File
	file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_notebook_execution_job_proto_depIdxs = nil
}
