10 PRINT "PROGRAM FILE 167: EXCEPTION - EVALUATION OF NUMERIC"
20 PRINT "        EXPRESSIONS ACTING AS FUNCTION ARGUMENTS."
40 PRINT "    ANSI STANDARD 7.5, 8.4, 16.4"
50 PRINT
60 PRINT "THIS PROGRAM TESTS THAT THE RECOVERY PROCEDURES FOR"
70 PRINT "EXCEPTIONS OCCURRING DURING THE EVALUATION OF NUMERIC"
80 PRINT "EXPRESSIONS WORK PROPERLY IN CONTEXTS OTHER THAN SIMPLE"
90 PRINT "ASSIGNMENT OF THE EXPRESSION TO A VARIABLE. SPECIFICALLY,"
100 PRINT "EXPRESSIONS ARE USED AS ARGUMENTS TO FUNCTIONS."
120 PRINT
130 PRINT "SECTION 167.1: DIVISION BY ZERO IN AN ARGUMENT TO A"
140 PRINT "        USER-DEFINED FUNCTION."
150 PRINT
160 PRINT "TO PASS THIS TEST:"
170 PRINT
180 PRINT "    1) A MESSAGE IDENTIFYING THE EXCEPTION MUST BE"
190 PRINT "       DISPLAYED, AND"
200 PRINT
210 PRINT "    2) POSITIVE INFINITY MUST BE SUPPLIED AS THE VALUE"
220 PRINT "       OF THE ARGUMENT AND EXECUTION CONTINUES."
230 PRINT
240 PRINT "                   BEGIN TEST."
250 PRINT
260 DEF FNC(X)=LOG(X)/LOG(10)
270 LET A=5
280 LET B=0
290 PRINT "ABOUT TO EVALUATE FNC(5/0), WHERE FNC = COMMON LOG."
300 PRINT "EXCEPTION SHOULD BE REPORTED NOW:"
310 PRINT
320 LET C=FNC(A/B)
330 PRINT
340 PRINT "RESULT OF FNC(5/0) = ";C
350 PRINT
360 IF C >= 37.99 THEN 400
370 PRINT "*** TEST FAILED: RESULT < 38 ***"
380 GOTO 440
400 PRINT "IF EXCEPTION REPORTED, AND"
410 PRINT "   RESULT = COMMON LOG OF MACHINE INFINITY, THEN"
420 PRINT "*** TEST PASSED ***"
440 PRINT
450 PRINT "                    END TEST."
460 PRINT
1110 PRINT "SECTION 167.2: ZERO RAISED TO A NEGATIVE POWER IN AN"
1120 PRINT "        ARGUMENT TO AN IMPLEMENTATION-SUPPLIED FUNCTION."
1130 PRINT
1140 PRINT "TO PASS THIS TEST:"
1150 PRINT
1160 PRINT "    1) A MESSAGE IDENTIFYING THE EXCEPTION MUST BE"
1170 PRINT "       DISPLAYED, AND"
1180 PRINT
1190 PRINT "    2) POSITIVE INFINITY MUST BE SUPPLIED AS THE VALUE"
1200 PRINT "       OF THE ARGUMENT AND EXECUTION CONTINUES."
1210 PRINT
1220 PRINT "                   BEGIN TEST."
1230 PRINT
1250 LET A=-5
1260 LET B=0
1270 PRINT "ABOUT TO EVALUATE ATN(0^(-5))."
1280 PRINT "EXCEPTION SHOULD BE REPORTED NOW:"
1290 PRINT
1300 LET C=ATN(B^A)
1310 PRINT
1320 PRINT "RESULT OF ATN(0^(-5)) = ";C
1330 PRINT
1340 IF ABS(C-1.5708) <= .001 THEN 1370
1350 PRINT "*** TEST FAILED: RESULT <> PI/2 ***"
1360 GOTO 1400
1370 PRINT "IF EXCEPTION REPORTED, THEN"
1390 PRINT "*** TEST PASSED ***"
1400 PRINT
1410 PRINT "                    END TEST."
1420 PRINT
1440 PRINT "END PROGRAM 167"
1450 END
