10 PRINT "PROGRAM FILE 132: AVERAGE OF RANDOM NUMBERS APPROXIMATES 0.5"
15 PRINT "        AND 0 <= RND < 1."
20 PRINT "    ANSI STANDARD 8.4"
30 PRINT
40 PRINT "SECTION 132.1: AVERAGE OF RANDOM NUMBERS APPROXIMATES 0.5"
50 PRINT "        AND 0 <= RND < 1."
60 PRINT
70 PRINT "THIS PROGRAM TESTS WHETHER THE AVERAGE OF A SERIES OF RANDOM"
80 PRINT "NUMBERS IS SIGNIFICANTLY FAR FROM THE IDEAL OF 0.5. IF SO,"
90 PRINT "THIS RESULT INDICATES NON-UNIFORM DISTRIBUTION AND THE TEST"
100 PRINT "FAILS. ALSO, IF ANY OF THE NUMBERS IS OUTSIDE THE ALLOWABLE"
110 PRINT "RANGE, AN IMMEDIATE FAILURE IS REPORTED."
120 PRINT
130 PRINT "               BEGIN TEST"
140 PRINT
150 REM N=8754 BASED ON SIGNIFICANCE LEVEL OF .05 AND 0.1 CHANCE OF
160 REM NOT FINDING A DIFFERENCE OF AT LEAST .01 FROM STANDARD
170 REM AVERAGE OF 0.5, AND STANDARD DEVIATION OF 1/(2*SQR(3))
180 LET N=8754
190 LET S1=0
200 LET S2=0
210 FOR I=1 TO N
220   LET X=RND
230   IF X<0 THEN 490
240   IF X>=1 THEN 510
250   LET S1=S1+X
260   LET S2=S2+(X*X)
270 NEXT I
280 LET S = SQR((N*S2) - (S1*S1)) / N
290 LET X1=S1/N
300 PRINT ,"AVERAGE","STD. DEV."
310 PRINT "THEORETICAL:",.5,1/(2*SQR(3))
320 PRINT "ACTUAL:",X1,S
330 LET A1=ABS(X1-0.5)
340 REM 1.96 BASED ON SIGNIFICANCE LEVEL OF .05 AND INFINITE D.F
350 LET A2=(1.96*S)/SQR(N)
360 PRINT
370 PRINT "ALLOWABLE DEVIATION: ";A2
380 PRINT "ACTUAL DEVIATION:    ";A1
390 PRINT
400 IF A1>A2 THEN 430
410 PRINT "*** TEST PASSED ***"
420 GOTO 440
430 PRINT "*** TEST FAILED ***"
440 PRINT
450 PRINT "                END TEST"
460 PRINT
470 PRINT "END PROGRAM 132"
480 STOP
490 PRINT "RND#";I;" < 0: ";X
500 GOTO 430
510 PRINT "RND#";I;" >= 1: ";X
520 GOTO 430
530 END
