// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/registry/module/v1beta1/commit_service.proto

package modulev1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListCommitsRequest_Order int32

const (
	ListCommitsRequest_ORDER_UNSPECIFIED ListCommitsRequest_Order = 0
	// Order by create_time newest to oldest.
	ListCommitsRequest_ORDER_CREATE_TIME_DESC ListCommitsRequest_Order = 1
	// Order by create_time oldest to newest.
	ListCommitsRequest_ORDER_CREATE_TIME_ASC ListCommitsRequest_Order = 2
)

// Enum value maps for ListCommitsRequest_Order.
var (
	ListCommitsRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListCommitsRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListCommitsRequest_Order) Enum() *ListCommitsRequest_Order {
	p := new(ListCommitsRequest_Order)
	*p = x
	return p
}

func (x ListCommitsRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListCommitsRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1beta1_commit_service_proto_enumTypes[0].Descriptor()
}

func (ListCommitsRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1beta1_commit_service_proto_enumTypes[0]
}

func (x ListCommitsRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListCommitsRequest_Order.Descriptor instead.
func (ListCommitsRequest_Order) EnumDescriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_commit_service_proto_rawDescGZIP(), []int{2, 0}
}

type GetCommitsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// References to request a Commit for.
	//
	// See the documentation on ResourceRef for resource resolution details.
	//
	// Resolution is as follows:
	//   - If a Module is referenced, the Commit of the default Label is returned.
	//   - If a Label is referenced, the Commit of this Label is returned.
	//   - If a Commit is referenced, this Commit is returned.
	ResourceRefs []*ResourceRef `protobuf:"bytes,1,rep,name=resource_refs,json=resourceRefs,proto3" json:"resource_refs,omitempty"`
	// The DigestType to use for Digests returned on Commits.
	//
	// If this DigestType is not available, an error is returned.
	// Note that certain DigestTypes may be deprecated over time.
	//
	// If not set, the latest DigestType is used, currently B5.
	DigestType DigestType `protobuf:"varint,2,opt,name=digest_type,json=digestType,proto3,enum=buf.registry.module.v1beta1.DigestType" json:"digest_type,omitempty"`
}

func (x *GetCommitsRequest) Reset() {
	*x = GetCommitsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCommitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCommitsRequest) ProtoMessage() {}

func (x *GetCommitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCommitsRequest.ProtoReflect.Descriptor instead.
func (*GetCommitsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_commit_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetCommitsRequest) GetResourceRefs() []*ResourceRef {
	if x != nil {
		return x.ResourceRefs
	}
	return nil
}

func (x *GetCommitsRequest) GetDigestType() DigestType {
	if x != nil {
		return x.DigestType
	}
	return DigestType_DIGEST_TYPE_UNSPECIFIED
}

type GetCommitsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The found Commits in the same order as requested.
	Commits []*Commit `protobuf:"bytes,1,rep,name=commits,proto3" json:"commits,omitempty"`
}

func (x *GetCommitsResponse) Reset() {
	*x = GetCommitsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCommitsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCommitsResponse) ProtoMessage() {}

func (x *GetCommitsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCommitsResponse.ProtoReflect.Descriptor instead.
func (*GetCommitsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_commit_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetCommitsResponse) GetCommits() []*Commit {
	if x != nil {
		return x.Commits
	}
	return nil
}

type ListCommitsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The reference to list Commits for.
	//
	// See the documentation on Ref for resource resolution details.
	//
	// Once the resource is resolved, the following Commits are listed (subject to any additional filters in the request):
	//   - If a Module is referenced, all Commits for the Module are returned.
	//   - If a Label is referenced, the Commit the Label points to is returned.
	//     Use ListLabelHistory to get the history of Commits for a Label.
	//   - If a Commit is referenced, this Commit is returned.
	ResourceRef *ResourceRef `protobuf:"bytes,3,opt,name=resource_ref,json=resourceRef,proto3" json:"resource_ref,omitempty"`
	// The order to return the Commits.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListCommitsRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.module.v1beta1.ListCommitsRequest_Order" json:"order,omitempty"`
	// The DigestType to use for Digests returned on Commits.
	//
	// If this DigestType is not available, an error is returned.
	// Note that certain DigestTypes may be deprecated over time.
	//
	// If not set, the latest DigestType is used, currently B5.
	DigestType DigestType `protobuf:"varint,5,opt,name=digest_type,json=digestType,proto3,enum=buf.registry.module.v1beta1.DigestType" json:"digest_type,omitempty"`
	// Only return Commits with an id that contains this string using a case-insensitive comparison.
	IdQuery string `protobuf:"bytes,6,opt,name=id_query,json=idQuery,proto3" json:"id_query,omitempty"`
}

func (x *ListCommitsRequest) Reset() {
	*x = ListCommitsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCommitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCommitsRequest) ProtoMessage() {}

func (x *ListCommitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCommitsRequest.ProtoReflect.Descriptor instead.
func (*ListCommitsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_commit_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListCommitsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCommitsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCommitsRequest) GetResourceRef() *ResourceRef {
	if x != nil {
		return x.ResourceRef
	}
	return nil
}

func (x *ListCommitsRequest) GetOrder() ListCommitsRequest_Order {
	if x != nil {
		return x.Order
	}
	return ListCommitsRequest_ORDER_UNSPECIFIED
}

func (x *ListCommitsRequest) GetDigestType() DigestType {
	if x != nil {
		return x.DigestType
	}
	return DigestType_DIGEST_TYPE_UNSPECIFIED
}

func (x *ListCommitsRequest) GetIdQuery() string {
	if x != nil {
		return x.IdQuery
	}
	return ""
}

type ListCommitsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The listed Commits.
	Commits []*Commit `protobuf:"bytes,2,rep,name=commits,proto3" json:"commits,omitempty"`
}

func (x *ListCommitsResponse) Reset() {
	*x = ListCommitsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCommitsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCommitsResponse) ProtoMessage() {}

func (x *ListCommitsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCommitsResponse.ProtoReflect.Descriptor instead.
func (*ListCommitsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_commit_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListCommitsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCommitsResponse) GetCommits() []*Commit {
	if x != nil {
		return x.Commits
	}
	return nil
}

var File_buf_registry_module_v1beta1_commit_service_proto protoreflect.FileDescriptor

var file_buf_registry_module_v1beta1_commit_service_proto_rawDesc = []byte{
	0x0a, 0x30, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a,
	0x28, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x62, 0x75, 0x66, 0x2f, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc3, 0x01, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x5a, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72,
	0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x66, 0x42, 0x0b, 0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01,
	0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x73, 0x12, 0x52,
	0x0a, 0x0b, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x08, 0xba, 0x48,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x5d, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x42, 0x08,
	0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x73, 0x22, 0xdf, 0x03, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xba, 0x48, 0x05,
	0x2a, 0x03, 0x18, 0xfa, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x27, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0x80, 0x20, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x53, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01,
	0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x12, 0x55, 0x0a,
	0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x08, 0xba, 0x48, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x12, 0x52, 0x0a, 0x0b, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x08, 0xba, 0x48, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x08, 0x69, 0x64, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xba, 0x48, 0x04, 0x72,
	0x02, 0x18, 0x24, 0x52, 0x07, 0x69, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0x55, 0x0a, 0x05,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x15, 0x0a, 0x11, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16,
	0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x52, 0x44, 0x45,
	0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x41, 0x53,
	0x43, 0x10, 0x02, 0x22, 0x86, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0x80, 0x20, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3d, 0x0a,
	0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x32, 0xfa, 0x01, 0x0a,
	0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x72,
	0x0a, 0x0a, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x2e, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90,
	0x02, 0x01, 0x12, 0x75, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x73, 0x12, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x30, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42, 0x61, 0x5a, 0x5f, 0x62, 0x75, 0x66,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75,
	0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f,
	0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_registry_module_v1beta1_commit_service_proto_rawDescOnce sync.Once
	file_buf_registry_module_v1beta1_commit_service_proto_rawDescData = file_buf_registry_module_v1beta1_commit_service_proto_rawDesc
)

func file_buf_registry_module_v1beta1_commit_service_proto_rawDescGZIP() []byte {
	file_buf_registry_module_v1beta1_commit_service_proto_rawDescOnce.Do(func() {
		file_buf_registry_module_v1beta1_commit_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_registry_module_v1beta1_commit_service_proto_rawDescData)
	})
	return file_buf_registry_module_v1beta1_commit_service_proto_rawDescData
}

var file_buf_registry_module_v1beta1_commit_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_module_v1beta1_commit_service_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_buf_registry_module_v1beta1_commit_service_proto_goTypes = []any{
	(ListCommitsRequest_Order)(0), // 0: buf.registry.module.v1beta1.ListCommitsRequest.Order
	(*GetCommitsRequest)(nil),     // 1: buf.registry.module.v1beta1.GetCommitsRequest
	(*GetCommitsResponse)(nil),    // 2: buf.registry.module.v1beta1.GetCommitsResponse
	(*ListCommitsRequest)(nil),    // 3: buf.registry.module.v1beta1.ListCommitsRequest
	(*ListCommitsResponse)(nil),   // 4: buf.registry.module.v1beta1.ListCommitsResponse
	(*ResourceRef)(nil),           // 5: buf.registry.module.v1beta1.ResourceRef
	(DigestType)(0),               // 6: buf.registry.module.v1beta1.DigestType
	(*Commit)(nil),                // 7: buf.registry.module.v1beta1.Commit
}
var file_buf_registry_module_v1beta1_commit_service_proto_depIdxs = []int32{
	5, // 0: buf.registry.module.v1beta1.GetCommitsRequest.resource_refs:type_name -> buf.registry.module.v1beta1.ResourceRef
	6, // 1: buf.registry.module.v1beta1.GetCommitsRequest.digest_type:type_name -> buf.registry.module.v1beta1.DigestType
	7, // 2: buf.registry.module.v1beta1.GetCommitsResponse.commits:type_name -> buf.registry.module.v1beta1.Commit
	5, // 3: buf.registry.module.v1beta1.ListCommitsRequest.resource_ref:type_name -> buf.registry.module.v1beta1.ResourceRef
	0, // 4: buf.registry.module.v1beta1.ListCommitsRequest.order:type_name -> buf.registry.module.v1beta1.ListCommitsRequest.Order
	6, // 5: buf.registry.module.v1beta1.ListCommitsRequest.digest_type:type_name -> buf.registry.module.v1beta1.DigestType
	7, // 6: buf.registry.module.v1beta1.ListCommitsResponse.commits:type_name -> buf.registry.module.v1beta1.Commit
	1, // 7: buf.registry.module.v1beta1.CommitService.GetCommits:input_type -> buf.registry.module.v1beta1.GetCommitsRequest
	3, // 8: buf.registry.module.v1beta1.CommitService.ListCommits:input_type -> buf.registry.module.v1beta1.ListCommitsRequest
	2, // 9: buf.registry.module.v1beta1.CommitService.GetCommits:output_type -> buf.registry.module.v1beta1.GetCommitsResponse
	4, // 10: buf.registry.module.v1beta1.CommitService.ListCommits:output_type -> buf.registry.module.v1beta1.ListCommitsResponse
	9, // [9:11] is the sub-list for method output_type
	7, // [7:9] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1beta1_commit_service_proto_init() }
func file_buf_registry_module_v1beta1_commit_service_proto_init() {
	if File_buf_registry_module_v1beta1_commit_service_proto != nil {
		return
	}
	file_buf_registry_module_v1beta1_commit_proto_init()
	file_buf_registry_module_v1beta1_digest_proto_init()
	file_buf_registry_module_v1beta1_resource_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*GetCommitsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*GetCommitsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListCommitsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_commit_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListCommitsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_registry_module_v1beta1_commit_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_module_v1beta1_commit_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1beta1_commit_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_module_v1beta1_commit_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_module_v1beta1_commit_service_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1beta1_commit_service_proto = out.File
	file_buf_registry_module_v1beta1_commit_service_proto_rawDesc = nil
	file_buf_registry_module_v1beta1_commit_service_proto_goTypes = nil
	file_buf_registry_module_v1beta1_commit_service_proto_depIdxs = nil
}
