// Copyright 2023 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/validate/validate.proto

package validate

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	descriptorpb "google.golang.org/protobuf/types/descriptorpb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies how FieldConstraints.ignore behaves. See the documentation for
// FieldConstraints.required for definitions of "populated" and "nullable".
type Ignore int32

const (
	// Validation is only skipped if it's an unpopulated nullable fields.
	//
	// ```proto
	// syntax="proto3";
	//
	//	message Request {
	//	  // The uri rule applies to any value, including the empty string.
	//	  string foo = 1 [
	//	    (buf.validate.field).string.uri = true
	//	  ];
	//
	//	  // The uri rule only applies if the field is set, including if it's
	//	  // set to the empty string.
	//	  optional string bar = 2 [
	//	    (buf.validate.field).string.uri = true
	//	  ];
	//
	//	  // The min_items rule always applies, even if the list is empty.
	//	  repeated string baz = 3 [
	//	    (buf.validate.field).repeated.min_items = 3
	//	  ];
	//
	//	  // The custom CEL rule applies only if the field is set, including if
	//	  // it's the "zero" value of that message.
	//	  SomeMessage quux = 4 [
	//	    (buf.validate.field).cel = {/* ... */}
	//	  ];
	//	}
	//
	// ```
	Ignore_IGNORE_UNSPECIFIED Ignore = 0
	// Validation is skipped if the field is unpopulated. This rule is redundant
	// if the field is already nullable. This value is equivalent behavior to the
	// deprecated ignore_empty rule.
	//
	// ```proto
	// syntax="proto3
	//
	//	message Request {
	//	  // The uri rule applies only if the value is not the empty string.
	//	  string foo = 1 [
	//	    (buf.validate.field).string.uri = true,
	//	    (buf.validate.field).ignore = IGNORE_IF_UNPOPULATED
	//	  ];
	//
	//	  // IGNORE_IF_UNPOPULATED is equivalent to IGNORE_UNSPECIFIED in this
	//	  // case: the uri rule only applies if the field is set, including if
	//	  // it's set to the empty string.
	//	  optional string bar = 2 [
	//	    (buf.validate.field).string.uri = true,
	//	    (buf.validate.field).ignore = IGNORE_IF_UNPOPULATED
	//	  ];
	//
	//	  // The min_items rule only applies if the list has at least one item.
	//	  repeated string baz = 3 [
	//	    (buf.validate.field).repeated.min_items = 3,
	//	    (buf.validate.field).ignore = IGNORE_IF_UNPOPULATED
	//	  ];
	//
	//	  // IGNORE_IF_UNPOPULATED is equivalent to IGNORE_UNSPECIFIED in this
	//	  // case: the custom CEL rule applies only if the field is set, including
	//	  // if it's the "zero" value of that message.
	//	  SomeMessage quux = 4 [
	//	    (buf.validate.field).cel = {/* ... */},
	//	    (buf.validate.field).ignore = IGNORE_IF_UNPOPULATED
	//	  ];
	//	}
	//
	// ```
	Ignore_IGNORE_IF_UNPOPULATED Ignore = 1
	// Validation is skipped if the field is unpopulated or if it is a nullable
	// field populated with its default value. This is typically the zero or
	// empty value, but proto2 scalars support custom defaults. For messages, the
	// default is a non-null message with all its fields unpopulated.
	//
	// ```proto
	// syntax="proto3
	//
	//	message Request {
	//	  // IGNORE_IF_DEFAULT_VALUE is equivalent to IGNORE_IF_UNPOPULATED in
	//	  // this case; the uri rule applies only if the value is not the empty
	//	  // string.
	//	  string foo = 1 [
	//	    (buf.validate.field).string.uri = true,
	//	    (buf.validate.field).ignore = IGNORE_IF_DEFAULT_VALUE
	//	  ];
	//
	//	  // The uri rule only applies if the field is set to a value other than
	//	  // the empty string.
	//	  optional string bar = 2 [
	//	    (buf.validate.field).string.uri = true,
	//	    (buf.validate.field).ignore = IGNORE_IF_DEFAULT_VALUE
	//	  ];
	//
	//	  // IGNORE_IF_DEFAULT_VALUE is equivalent to IGNORE_IF_UNPOPULATED in
	//	  // this case; the min_items rule only applies if the list has at least
	//	  // one item.
	//	  repeated string baz = 3 [
	//	    (buf.validate.field).repeated.min_items = 3,
	//	    (buf.validate.field).ignore = IGNORE_IF_DEFAULT_VALUE
	//	  ];
	//
	//	  // The custom CEL rule only applies if the field is set to a value other
	//	  // than an empty message (i.e., fields are unpopulated).
	//	  SomeMessage quux = 4 [
	//	    (buf.validate.field).cel = {/* ... */},
	//	    (buf.validate.field).ignore = IGNORE_IF_DEFAULT_VALUE
	//	  ];
	//	}
	//
	// ```
	//
	// This rule is affected by proto2 custom default values:
	//
	// ```proto
	// syntax="proto2";
	//
	//	message Request {
	//	  // The gt rule only applies if the field is set and it's value is not
	//	  the default (i.e., not -42). The rule even applies if the field is set
	//	  to zero since the default value differs.
	//	  optional int32 value = 1 [
	//	    default = -42,
	//	    (buf.validate.field).int32.gt = 0,
	//	    (buf.validate.field).ignore = IGNORE_IF_DEFAULT_VALUE
	//	  ];
	//	}
	Ignore_IGNORE_IF_DEFAULT_VALUE Ignore = 2
	// The validation rules of this field will be skipped and not evaluated. This
	// is useful for situations that necessitate turning off the rules of a field
	// containing a message that may not make sense in the current context, or to
	// temporarily disable constraints during development.
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field's rules will always be ignored, including any validation's
	//	  // on value's fields.
	//	  MyOtherMessage value = 1 [
	//	    (buf.validate.field).ignore = IGNORE_ALWAYS];
	//	}
	//
	// ```
	Ignore_IGNORE_ALWAYS Ignore = 3
	// Deprecated: Use IGNORE_IF_UNPOPULATED instead. TODO: Remove this value pre-v1.
	//
	// Deprecated: Marked as deprecated in buf/validate/validate.proto.
	Ignore_IGNORE_EMPTY Ignore = 1
	// Deprecated: Use IGNORE_IF_DEFAULT_VALUE. TODO: Remove this value pre-v1.
	//
	// Deprecated: Marked as deprecated in buf/validate/validate.proto.
	Ignore_IGNORE_DEFAULT Ignore = 2
)

// Enum value maps for Ignore.
var (
	Ignore_name = map[int32]string{
		0: "IGNORE_UNSPECIFIED",
		1: "IGNORE_IF_UNPOPULATED",
		2: "IGNORE_IF_DEFAULT_VALUE",
		3: "IGNORE_ALWAYS",
		// Duplicate value: 1: "IGNORE_EMPTY",
		// Duplicate value: 2: "IGNORE_DEFAULT",
	}
	Ignore_value = map[string]int32{
		"IGNORE_UNSPECIFIED":      0,
		"IGNORE_IF_UNPOPULATED":   1,
		"IGNORE_IF_DEFAULT_VALUE": 2,
		"IGNORE_ALWAYS":           3,
		"IGNORE_EMPTY":            1,
		"IGNORE_DEFAULT":          2,
	}
)

func (x Ignore) Enum() *Ignore {
	p := new(Ignore)
	*p = x
	return p
}

func (x Ignore) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Ignore) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_validate_validate_proto_enumTypes[0].Descriptor()
}

func (Ignore) Type() protoreflect.EnumType {
	return &file_buf_validate_validate_proto_enumTypes[0]
}

func (x Ignore) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Ignore) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Ignore(num)
	return nil
}

// Deprecated: Use Ignore.Descriptor instead.
func (Ignore) EnumDescriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{0}
}

// WellKnownRegex contain some well-known patterns.
type KnownRegex int32

const (
	KnownRegex_KNOWN_REGEX_UNSPECIFIED KnownRegex = 0
	// HTTP header name as defined by [RFC 7230](https://tools.ietf.org/html/rfc7230#section-3.2).
	KnownRegex_KNOWN_REGEX_HTTP_HEADER_NAME KnownRegex = 1
	// HTTP header value as defined by [RFC 7230](https://tools.ietf.org/html/rfc7230#section-3.2.4).
	KnownRegex_KNOWN_REGEX_HTTP_HEADER_VALUE KnownRegex = 2
)

// Enum value maps for KnownRegex.
var (
	KnownRegex_name = map[int32]string{
		0: "KNOWN_REGEX_UNSPECIFIED",
		1: "KNOWN_REGEX_HTTP_HEADER_NAME",
		2: "KNOWN_REGEX_HTTP_HEADER_VALUE",
	}
	KnownRegex_value = map[string]int32{
		"KNOWN_REGEX_UNSPECIFIED":       0,
		"KNOWN_REGEX_HTTP_HEADER_NAME":  1,
		"KNOWN_REGEX_HTTP_HEADER_VALUE": 2,
	}
)

func (x KnownRegex) Enum() *KnownRegex {
	p := new(KnownRegex)
	*p = x
	return p
}

func (x KnownRegex) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KnownRegex) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_validate_validate_proto_enumTypes[1].Descriptor()
}

func (KnownRegex) Type() protoreflect.EnumType {
	return &file_buf_validate_validate_proto_enumTypes[1]
}

func (x KnownRegex) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *KnownRegex) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = KnownRegex(num)
	return nil
}

// Deprecated: Use KnownRegex.Descriptor instead.
func (KnownRegex) EnumDescriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{1}
}

// `Constraint` represents a validation rule written in the Common Expression
// Language (CEL) syntax. Each Constraint includes a unique identifier, an
// optional error message, and the CEL expression to evaluate. For more
// information on CEL, [see our documentation](https://github.com/bufbuild/protovalidate/blob/main/docs/cel.md).
//
// ```proto
//
//	message Foo {
//	  option (buf.validate.message).cel = {
//	    id: "foo.bar"
//	    message: "bar must be greater than 0"
//	    expression: "this.bar > 0"
//	  };
//	  int32 bar = 1;
//	}
//
// ```
type Constraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `id` is a string that serves as a machine-readable name for this Constraint.
	// It should be unique within its scope, which could be either a message or a field.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// `message` is an optional field that provides a human-readable error message
	// for this Constraint when the CEL expression evaluates to false. If a
	// non-empty message is provided, any strings resulting from the CEL
	// expression evaluation are ignored.
	Message *string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	// `expression` is the actual CEL expression that will be evaluated for
	// validation. This string must resolve to either a boolean or a string
	// value. If the expression evaluates to false or a non-empty string, the
	// validation is considered failed, and the message is rejected.
	Expression *string `protobuf:"bytes,3,opt,name=expression" json:"expression,omitempty"`
}

func (x *Constraint) Reset() {
	*x = Constraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Constraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Constraint) ProtoMessage() {}

func (x *Constraint) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Constraint.ProtoReflect.Descriptor instead.
func (*Constraint) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{0}
}

func (x *Constraint) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *Constraint) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

func (x *Constraint) GetExpression() string {
	if x != nil && x.Expression != nil {
		return *x.Expression
	}
	return ""
}

// MessageConstraints represents validation rules that are applied to the entire message.
// It includes disabling options and a list of Constraint messages representing Common Expression Language (CEL) validation rules.
type MessageConstraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `disabled` is a boolean flag that, when set to true, nullifies any validation rules for this message.
	// This includes any fields within the message that would otherwise support validation.
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // validation will be bypassed for this message
	//	  option (buf.validate.message).disabled = true;
	//	}
	//
	// ```
	Disabled *bool `protobuf:"varint,1,opt,name=disabled" json:"disabled,omitempty"`
	// `cel` is a repeated field of type Constraint. Each Constraint specifies a validation rule to be applied to this message.
	// These constraints are written in Common Expression Language (CEL) syntax. For more information on
	// CEL, [see our documentation](https://github.com/bufbuild/protovalidate/blob/main/docs/cel.md).
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field `foo` must be greater than 42.
	//	  option (buf.validate.message).cel = {
	//	    id: "my_message.value",
	//	    message: "value must be greater than 42",
	//	    expression: "this.foo > 42",
	//	  };
	//	  optional int32 foo = 1;
	//	}
	//
	// ```
	Cel []*Constraint `protobuf:"bytes,3,rep,name=cel" json:"cel,omitempty"`
}

func (x *MessageConstraints) Reset() {
	*x = MessageConstraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageConstraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageConstraints) ProtoMessage() {}

func (x *MessageConstraints) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageConstraints.ProtoReflect.Descriptor instead.
func (*MessageConstraints) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{1}
}

func (x *MessageConstraints) GetDisabled() bool {
	if x != nil && x.Disabled != nil {
		return *x.Disabled
	}
	return false
}

func (x *MessageConstraints) GetCel() []*Constraint {
	if x != nil {
		return x.Cel
	}
	return nil
}

// The `OneofConstraints` message type enables you to manage constraints for
// oneof fields in your protobuf messages.
type OneofConstraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If `required` is true, exactly one field of the oneof must be present. A
	// validation error is returned if no fields in the oneof are present. The
	// field itself may still be a default value; further constraints
	// should be placed on the fields themselves to ensure they are valid values,
	// such as `min_len` or `gt`.
	//
	// ```proto
	//
	//	message MyMessage {
	//	  oneof value {
	//	    // Either `a` or `b` must be set. If `a` is set, it must also be
	//	    // non-empty; whereas if `b` is set, it can still be an empty string.
	//	    option (buf.validate.oneof).required = true;
	//	    string a = 1 [(buf.validate.field).string.min_len = 1];
	//	    string b = 2;
	//	  }
	//	}
	//
	// ```
	Required *bool `protobuf:"varint,1,opt,name=required" json:"required,omitempty"`
}

func (x *OneofConstraints) Reset() {
	*x = OneofConstraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OneofConstraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OneofConstraints) ProtoMessage() {}

func (x *OneofConstraints) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OneofConstraints.ProtoReflect.Descriptor instead.
func (*OneofConstraints) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{2}
}

func (x *OneofConstraints) GetRequired() bool {
	if x != nil && x.Required != nil {
		return *x.Required
	}
	return false
}

// FieldConstraints encapsulates the rules for each type of field. Depending on
// the field, the correct set should be used to ensure proper validations.
type FieldConstraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `cel` is a repeated field used to represent a textual expression
	// in the Common Expression Language (CEL) syntax. For more information on
	// CEL, [see our documentation](https://github.com/bufbuild/protovalidate/blob/main/docs/cel.md).
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field `value` must be greater than 42.
	//	  optional int32 value = 1 [(buf.validate.field).cel = {
	//	    id: "my_message.value",
	//	    message: "value must be greater than 42",
	//	    expression: "this > 42",
	//	  }];
	//	}
	//
	// ```
	Cel []*Constraint `protobuf:"bytes,23,rep,name=cel" json:"cel,omitempty"`
	// If `required` is true, the field must be populated. A populated field can be
	// described as "serialized in the wire format," which includes:
	//
	// - the following "nullable" fields must be explicitly set to be considered populated:
	//   - singular message fields (whose fields may be unpopulated/default values)
	//   - member fields of a oneof (may be their default value)
	//   - proto3 optional fields (may be their default value)
	//   - proto2 scalar fields (both optional and required)
	//
	// - proto3 scalar fields must be non-zero to be considered populated
	// - repeated and map fields must be non-empty to be considered populated
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field `value` must be set to a non-null value.
	//	  optional MyOtherMessage value = 1 [(buf.validate.field).required = true];
	//	}
	//
	// ```
	Required *bool `protobuf:"varint,25,opt,name=required" json:"required,omitempty"`
	// Skip validation on the field if its value matches the specified criteria.
	// See Ignore enum for details.
	//
	// ```proto
	//
	//	message UpdateRequest {
	//	  // The uri rule only applies if the field is populated and not an empty
	//	  // string.
	//	  optional string url = 1 [
	//	    (buf.validate.field).ignore = IGNORE_IF_DEFAULT_VALUE,
	//	    (buf.validate.field).string.uri = true,
	//	  ];
	//	}
	//
	// ```
	Ignore *Ignore `protobuf:"varint,27,opt,name=ignore,enum=buf.validate.Ignore" json:"ignore,omitempty"`
	// Types that are assignable to Type:
	//
	//	*FieldConstraints_Float
	//	*FieldConstraints_Double
	//	*FieldConstraints_Int32
	//	*FieldConstraints_Int64
	//	*FieldConstraints_Uint32
	//	*FieldConstraints_Uint64
	//	*FieldConstraints_Sint32
	//	*FieldConstraints_Sint64
	//	*FieldConstraints_Fixed32
	//	*FieldConstraints_Fixed64
	//	*FieldConstraints_Sfixed32
	//	*FieldConstraints_Sfixed64
	//	*FieldConstraints_Bool
	//	*FieldConstraints_String_
	//	*FieldConstraints_Bytes
	//	*FieldConstraints_Enum
	//	*FieldConstraints_Repeated
	//	*FieldConstraints_Map
	//	*FieldConstraints_Any
	//	*FieldConstraints_Duration
	//	*FieldConstraints_Timestamp
	Type isFieldConstraints_Type `protobuf_oneof:"type"`
	// DEPRECATED: use ignore=IGNORE_ALWAYS instead. TODO: remove this field pre-v1.
	//
	// Deprecated: Marked as deprecated in buf/validate/validate.proto.
	Skipped *bool `protobuf:"varint,24,opt,name=skipped" json:"skipped,omitempty"`
	// DEPRECATED: use ignore=IGNORE_IF_UNPOPULATED instead. TODO: remove this field pre-v1.
	//
	// Deprecated: Marked as deprecated in buf/validate/validate.proto.
	IgnoreEmpty *bool `protobuf:"varint,26,opt,name=ignore_empty,json=ignoreEmpty" json:"ignore_empty,omitempty"`
}

func (x *FieldConstraints) Reset() {
	*x = FieldConstraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldConstraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldConstraints) ProtoMessage() {}

func (x *FieldConstraints) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldConstraints.ProtoReflect.Descriptor instead.
func (*FieldConstraints) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{3}
}

func (x *FieldConstraints) GetCel() []*Constraint {
	if x != nil {
		return x.Cel
	}
	return nil
}

func (x *FieldConstraints) GetRequired() bool {
	if x != nil && x.Required != nil {
		return *x.Required
	}
	return false
}

func (x *FieldConstraints) GetIgnore() Ignore {
	if x != nil && x.Ignore != nil {
		return *x.Ignore
	}
	return Ignore_IGNORE_UNSPECIFIED
}

func (m *FieldConstraints) GetType() isFieldConstraints_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *FieldConstraints) GetFloat() *FloatRules {
	if x, ok := x.GetType().(*FieldConstraints_Float); ok {
		return x.Float
	}
	return nil
}

func (x *FieldConstraints) GetDouble() *DoubleRules {
	if x, ok := x.GetType().(*FieldConstraints_Double); ok {
		return x.Double
	}
	return nil
}

func (x *FieldConstraints) GetInt32() *Int32Rules {
	if x, ok := x.GetType().(*FieldConstraints_Int32); ok {
		return x.Int32
	}
	return nil
}

func (x *FieldConstraints) GetInt64() *Int64Rules {
	if x, ok := x.GetType().(*FieldConstraints_Int64); ok {
		return x.Int64
	}
	return nil
}

func (x *FieldConstraints) GetUint32() *UInt32Rules {
	if x, ok := x.GetType().(*FieldConstraints_Uint32); ok {
		return x.Uint32
	}
	return nil
}

func (x *FieldConstraints) GetUint64() *UInt64Rules {
	if x, ok := x.GetType().(*FieldConstraints_Uint64); ok {
		return x.Uint64
	}
	return nil
}

func (x *FieldConstraints) GetSint32() *SInt32Rules {
	if x, ok := x.GetType().(*FieldConstraints_Sint32); ok {
		return x.Sint32
	}
	return nil
}

func (x *FieldConstraints) GetSint64() *SInt64Rules {
	if x, ok := x.GetType().(*FieldConstraints_Sint64); ok {
		return x.Sint64
	}
	return nil
}

func (x *FieldConstraints) GetFixed32() *Fixed32Rules {
	if x, ok := x.GetType().(*FieldConstraints_Fixed32); ok {
		return x.Fixed32
	}
	return nil
}

func (x *FieldConstraints) GetFixed64() *Fixed64Rules {
	if x, ok := x.GetType().(*FieldConstraints_Fixed64); ok {
		return x.Fixed64
	}
	return nil
}

func (x *FieldConstraints) GetSfixed32() *SFixed32Rules {
	if x, ok := x.GetType().(*FieldConstraints_Sfixed32); ok {
		return x.Sfixed32
	}
	return nil
}

func (x *FieldConstraints) GetSfixed64() *SFixed64Rules {
	if x, ok := x.GetType().(*FieldConstraints_Sfixed64); ok {
		return x.Sfixed64
	}
	return nil
}

func (x *FieldConstraints) GetBool() *BoolRules {
	if x, ok := x.GetType().(*FieldConstraints_Bool); ok {
		return x.Bool
	}
	return nil
}

func (x *FieldConstraints) GetString_() *StringRules {
	if x, ok := x.GetType().(*FieldConstraints_String_); ok {
		return x.String_
	}
	return nil
}

func (x *FieldConstraints) GetBytes() *BytesRules {
	if x, ok := x.GetType().(*FieldConstraints_Bytes); ok {
		return x.Bytes
	}
	return nil
}

func (x *FieldConstraints) GetEnum() *EnumRules {
	if x, ok := x.GetType().(*FieldConstraints_Enum); ok {
		return x.Enum
	}
	return nil
}

func (x *FieldConstraints) GetRepeated() *RepeatedRules {
	if x, ok := x.GetType().(*FieldConstraints_Repeated); ok {
		return x.Repeated
	}
	return nil
}

func (x *FieldConstraints) GetMap() *MapRules {
	if x, ok := x.GetType().(*FieldConstraints_Map); ok {
		return x.Map
	}
	return nil
}

func (x *FieldConstraints) GetAny() *AnyRules {
	if x, ok := x.GetType().(*FieldConstraints_Any); ok {
		return x.Any
	}
	return nil
}

func (x *FieldConstraints) GetDuration() *DurationRules {
	if x, ok := x.GetType().(*FieldConstraints_Duration); ok {
		return x.Duration
	}
	return nil
}

func (x *FieldConstraints) GetTimestamp() *TimestampRules {
	if x, ok := x.GetType().(*FieldConstraints_Timestamp); ok {
		return x.Timestamp
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/validate/validate.proto.
func (x *FieldConstraints) GetSkipped() bool {
	if x != nil && x.Skipped != nil {
		return *x.Skipped
	}
	return false
}

// Deprecated: Marked as deprecated in buf/validate/validate.proto.
func (x *FieldConstraints) GetIgnoreEmpty() bool {
	if x != nil && x.IgnoreEmpty != nil {
		return *x.IgnoreEmpty
	}
	return false
}

type isFieldConstraints_Type interface {
	isFieldConstraints_Type()
}

type FieldConstraints_Float struct {
	// Scalar Field Types
	Float *FloatRules `protobuf:"bytes,1,opt,name=float,oneof"`
}

type FieldConstraints_Double struct {
	Double *DoubleRules `protobuf:"bytes,2,opt,name=double,oneof"`
}

type FieldConstraints_Int32 struct {
	Int32 *Int32Rules `protobuf:"bytes,3,opt,name=int32,oneof"`
}

type FieldConstraints_Int64 struct {
	Int64 *Int64Rules `protobuf:"bytes,4,opt,name=int64,oneof"`
}

type FieldConstraints_Uint32 struct {
	Uint32 *UInt32Rules `protobuf:"bytes,5,opt,name=uint32,oneof"`
}

type FieldConstraints_Uint64 struct {
	Uint64 *UInt64Rules `protobuf:"bytes,6,opt,name=uint64,oneof"`
}

type FieldConstraints_Sint32 struct {
	Sint32 *SInt32Rules `protobuf:"bytes,7,opt,name=sint32,oneof"`
}

type FieldConstraints_Sint64 struct {
	Sint64 *SInt64Rules `protobuf:"bytes,8,opt,name=sint64,oneof"`
}

type FieldConstraints_Fixed32 struct {
	Fixed32 *Fixed32Rules `protobuf:"bytes,9,opt,name=fixed32,oneof"`
}

type FieldConstraints_Fixed64 struct {
	Fixed64 *Fixed64Rules `protobuf:"bytes,10,opt,name=fixed64,oneof"`
}

type FieldConstraints_Sfixed32 struct {
	Sfixed32 *SFixed32Rules `protobuf:"bytes,11,opt,name=sfixed32,oneof"`
}

type FieldConstraints_Sfixed64 struct {
	Sfixed64 *SFixed64Rules `protobuf:"bytes,12,opt,name=sfixed64,oneof"`
}

type FieldConstraints_Bool struct {
	Bool *BoolRules `protobuf:"bytes,13,opt,name=bool,oneof"`
}

type FieldConstraints_String_ struct {
	String_ *StringRules `protobuf:"bytes,14,opt,name=string,oneof"`
}

type FieldConstraints_Bytes struct {
	Bytes *BytesRules `protobuf:"bytes,15,opt,name=bytes,oneof"`
}

type FieldConstraints_Enum struct {
	// Complex Field Types
	Enum *EnumRules `protobuf:"bytes,16,opt,name=enum,oneof"`
}

type FieldConstraints_Repeated struct {
	Repeated *RepeatedRules `protobuf:"bytes,18,opt,name=repeated,oneof"`
}

type FieldConstraints_Map struct {
	Map *MapRules `protobuf:"bytes,19,opt,name=map,oneof"`
}

type FieldConstraints_Any struct {
	// Well-Known Field Types
	Any *AnyRules `protobuf:"bytes,20,opt,name=any,oneof"`
}

type FieldConstraints_Duration struct {
	Duration *DurationRules `protobuf:"bytes,21,opt,name=duration,oneof"`
}

type FieldConstraints_Timestamp struct {
	Timestamp *TimestampRules `protobuf:"bytes,22,opt,name=timestamp,oneof"`
}

func (*FieldConstraints_Float) isFieldConstraints_Type() {}

func (*FieldConstraints_Double) isFieldConstraints_Type() {}

func (*FieldConstraints_Int32) isFieldConstraints_Type() {}

func (*FieldConstraints_Int64) isFieldConstraints_Type() {}

func (*FieldConstraints_Uint32) isFieldConstraints_Type() {}

func (*FieldConstraints_Uint64) isFieldConstraints_Type() {}

func (*FieldConstraints_Sint32) isFieldConstraints_Type() {}

func (*FieldConstraints_Sint64) isFieldConstraints_Type() {}

func (*FieldConstraints_Fixed32) isFieldConstraints_Type() {}

func (*FieldConstraints_Fixed64) isFieldConstraints_Type() {}

func (*FieldConstraints_Sfixed32) isFieldConstraints_Type() {}

func (*FieldConstraints_Sfixed64) isFieldConstraints_Type() {}

func (*FieldConstraints_Bool) isFieldConstraints_Type() {}

func (*FieldConstraints_String_) isFieldConstraints_Type() {}

func (*FieldConstraints_Bytes) isFieldConstraints_Type() {}

func (*FieldConstraints_Enum) isFieldConstraints_Type() {}

func (*FieldConstraints_Repeated) isFieldConstraints_Type() {}

func (*FieldConstraints_Map) isFieldConstraints_Type() {}

func (*FieldConstraints_Any) isFieldConstraints_Type() {}

func (*FieldConstraints_Duration) isFieldConstraints_Type() {}

func (*FieldConstraints_Timestamp) isFieldConstraints_Type() {}

// PredefinedConstraints are custom constraints that can be re-used with
// multiple fields.
type PredefinedConstraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `cel` is a repeated field used to represent a textual expression
	// in the Common Expression Language (CEL) syntax. For more information on
	// CEL, [see our documentation](https://github.com/bufbuild/protovalidate/blob/main/docs/cel.md).
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field `value` must be greater than 42.
	//	  optional int32 value = 1 [(buf.validate.predefined).cel = {
	//	    id: "my_message.value",
	//	    message: "value must be greater than 42",
	//	    expression: "this > 42",
	//	  }];
	//	}
	//
	// ```
	Cel []*Constraint `protobuf:"bytes,1,rep,name=cel" json:"cel,omitempty"`
}

func (x *PredefinedConstraints) Reset() {
	*x = PredefinedConstraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PredefinedConstraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredefinedConstraints) ProtoMessage() {}

func (x *PredefinedConstraints) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredefinedConstraints.ProtoReflect.Descriptor instead.
func (*PredefinedConstraints) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{4}
}

func (x *PredefinedConstraints) GetCel() []*Constraint {
	if x != nil {
		return x.Cel
	}
	return nil
}

// FloatRules describes the constraints applied to `float` values. These
// rules may also be applied to the `google.protobuf.FloatValue` Well-Known-Type.
type FloatRules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must equal 42.0
	//	  float value = 1 [(buf.validate.field).float.const = 42.0];
	//	}
	//
	// ```
	Const *float32 `protobuf:"fixed32,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*FloatRules_Lt
	//	*FloatRules_Lte
	LessThan isFloatRules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*FloatRules_Gt
	//	*FloatRules_Gte
	GreaterThan isFloatRules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be in list [1.0, 2.0, 3.0]
	//	  repeated float value = 1 (buf.validate.field).float = { in: [1.0, 2.0, 3.0] };
	//	}
	//
	// ```
	In []float32 `protobuf:"fixed32,6,rep,name=in" json:"in,omitempty"`
	// `in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must not be in list [1.0, 2.0, 3.0]
	//	  repeated float value = 1 (buf.validate.field).float = { not_in: [1.0, 2.0, 3.0] };
	//	}
	//
	// ```
	NotIn []float32 `protobuf:"fixed32,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `finite` requires the field value to be finite. If the field value is
	// infinite or NaN, an error message is generated.
	Finite *bool `protobuf:"varint,8,opt,name=finite" json:"finite,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  float value = 1 [
	//	    (buf.validate.field).float.example = 1.0,
	//	    (buf.validate.field).float.example = "Infinity"
	//	  ];
	//	}
	//
	// ```
	Example []float32 `protobuf:"fixed32,9,rep,name=example" json:"example,omitempty"`
}

func (x *FloatRules) Reset() {
	*x = FloatRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FloatRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FloatRules) ProtoMessage() {}

func (x *FloatRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FloatRules.ProtoReflect.Descriptor instead.
func (*FloatRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{5}
}

func (x *FloatRules) GetConst() float32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *FloatRules) GetLessThan() isFloatRules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *FloatRules) GetLt() float32 {
	if x, ok := x.GetLessThan().(*FloatRules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *FloatRules) GetLte() float32 {
	if x, ok := x.GetLessThan().(*FloatRules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *FloatRules) GetGreaterThan() isFloatRules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *FloatRules) GetGt() float32 {
	if x, ok := x.GetGreaterThan().(*FloatRules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *FloatRules) GetGte() float32 {
	if x, ok := x.GetGreaterThan().(*FloatRules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *FloatRules) GetIn() []float32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *FloatRules) GetNotIn() []float32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *FloatRules) GetFinite() bool {
	if x != nil && x.Finite != nil {
		return *x.Finite
	}
	return false
}

func (x *FloatRules) GetExample() []float32 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isFloatRules_LessThan interface {
	isFloatRules_LessThan()
}

type FloatRules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be less than 10.0
	//	  float value = 1 [(buf.validate.field).float.lt = 10.0];
	//	}
	//
	// ```
	Lt float32 `protobuf:"fixed32,2,opt,name=lt,oneof"`
}

type FloatRules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be less than or equal to 10.0
	//	  float value = 1 [(buf.validate.field).float.lte = 10.0];
	//	}
	//
	// ```
	Lte float32 `protobuf:"fixed32,3,opt,name=lte,oneof"`
}

func (*FloatRules_Lt) isFloatRules_LessThan() {}

func (*FloatRules_Lte) isFloatRules_LessThan() {}

type isFloatRules_GreaterThan interface {
	isFloatRules_GreaterThan()
}

type FloatRules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be greater than 5.0 [float.gt]
	//	  float value = 1 [(buf.validate.field).float.gt = 5.0];
	//
	//	  // value must be greater than 5 and less than 10.0 [float.gt_lt]
	//	  float other_value = 2 [(buf.validate.field).float = { gt: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than 10 or less than 5.0 [float.gt_lt_exclusive]
	//	  float another_value = 3 [(buf.validate.field).float = { gt: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gt float32 `protobuf:"fixed32,4,opt,name=gt,oneof"`
}

type FloatRules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be greater than or equal to 5.0 [float.gte]
	//	  float value = 1 [(buf.validate.field).float.gte = 5.0];
	//
	//	  // value must be greater than or equal to 5.0 and less than 10.0 [float.gte_lt]
	//	  float other_value = 2 [(buf.validate.field).float = { gte: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than or equal to 10.0 or less than 5.0 [float.gte_lt_exclusive]
	//	  float another_value = 3 [(buf.validate.field).float = { gte: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gte float32 `protobuf:"fixed32,5,opt,name=gte,oneof"`
}

func (*FloatRules_Gt) isFloatRules_GreaterThan() {}

func (*FloatRules_Gte) isFloatRules_GreaterThan() {}

// DoubleRules describes the constraints applied to `double` values. These
// rules may also be applied to the `google.protobuf.DoubleValue` Well-Known-Type.
type DoubleRules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must equal 42.0
	//	  double value = 1 [(buf.validate.field).double.const = 42.0];
	//	}
	//
	// ```
	Const *float64 `protobuf:"fixed64,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*DoubleRules_Lt
	//	*DoubleRules_Lte
	LessThan isDoubleRules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*DoubleRules_Gt
	//	*DoubleRules_Gte
	GreaterThan isDoubleRules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be in list [1.0, 2.0, 3.0]
	//	  repeated double value = 1 (buf.validate.field).double = { in: [1.0, 2.0, 3.0] };
	//	}
	//
	// ```
	In []float64 `protobuf:"fixed64,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must not be in list [1.0, 2.0, 3.0]
	//	  repeated double value = 1 (buf.validate.field).double = { not_in: [1.0, 2.0, 3.0] };
	//	}
	//
	// ```
	NotIn []float64 `protobuf:"fixed64,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `finite` requires the field value to be finite. If the field value is
	// infinite or NaN, an error message is generated.
	Finite *bool `protobuf:"varint,8,opt,name=finite" json:"finite,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  double value = 1 [
	//	    (buf.validate.field).double.example = 1.0,
	//	    (buf.validate.field).double.example = "Infinity"
	//	  ];
	//	}
	//
	// ```
	Example []float64 `protobuf:"fixed64,9,rep,name=example" json:"example,omitempty"`
}

func (x *DoubleRules) Reset() {
	*x = DoubleRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleRules) ProtoMessage() {}

func (x *DoubleRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleRules.ProtoReflect.Descriptor instead.
func (*DoubleRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{6}
}

func (x *DoubleRules) GetConst() float64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *DoubleRules) GetLessThan() isDoubleRules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *DoubleRules) GetLt() float64 {
	if x, ok := x.GetLessThan().(*DoubleRules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *DoubleRules) GetLte() float64 {
	if x, ok := x.GetLessThan().(*DoubleRules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *DoubleRules) GetGreaterThan() isDoubleRules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *DoubleRules) GetGt() float64 {
	if x, ok := x.GetGreaterThan().(*DoubleRules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *DoubleRules) GetGte() float64 {
	if x, ok := x.GetGreaterThan().(*DoubleRules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *DoubleRules) GetIn() []float64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *DoubleRules) GetNotIn() []float64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *DoubleRules) GetFinite() bool {
	if x != nil && x.Finite != nil {
		return *x.Finite
	}
	return false
}

func (x *DoubleRules) GetExample() []float64 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isDoubleRules_LessThan interface {
	isDoubleRules_LessThan()
}

type DoubleRules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be less than 10.0
	//	  double value = 1 [(buf.validate.field).double.lt = 10.0];
	//	}
	//
	// ```
	Lt float64 `protobuf:"fixed64,2,opt,name=lt,oneof"`
}

type DoubleRules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified value
	// (field <= value). If the field value is greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be less than or equal to 10.0
	//	  double value = 1 [(buf.validate.field).double.lte = 10.0];
	//	}
	//
	// ```
	Lte float64 `protobuf:"fixed64,3,opt,name=lte,oneof"`
}

func (*DoubleRules_Lt) isDoubleRules_LessThan() {}

func (*DoubleRules_Lte) isDoubleRules_LessThan() {}

type isDoubleRules_GreaterThan interface {
	isDoubleRules_GreaterThan()
}

type DoubleRules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or `lte`,
	// the range is reversed, and the field value must be outside the specified
	// range. If the field value doesn't meet the required conditions, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be greater than 5.0 [double.gt]
	//	  double value = 1 [(buf.validate.field).double.gt = 5.0];
	//
	//	  // value must be greater than 5 and less than 10.0 [double.gt_lt]
	//	  double other_value = 2 [(buf.validate.field).double = { gt: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than 10 or less than 5.0 [double.gt_lt_exclusive]
	//	  double another_value = 3 [(buf.validate.field).double = { gt: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gt float64 `protobuf:"fixed64,4,opt,name=gt,oneof"`
}

type DoubleRules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be greater than or equal to 5.0 [double.gte]
	//	  double value = 1 [(buf.validate.field).double.gte = 5.0];
	//
	//	  // value must be greater than or equal to 5.0 and less than 10.0 [double.gte_lt]
	//	  double other_value = 2 [(buf.validate.field).double = { gte: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than or equal to 10.0 or less than 5.0 [double.gte_lt_exclusive]
	//	  double another_value = 3 [(buf.validate.field).double = { gte: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gte float64 `protobuf:"fixed64,5,opt,name=gte,oneof"`
}

func (*DoubleRules_Gt) isDoubleRules_GreaterThan() {}

func (*DoubleRules_Gte) isDoubleRules_GreaterThan() {}

// Int32Rules describes the constraints applied to `int32` values. These
// rules may also be applied to the `google.protobuf.Int32Value` Well-Known-Type.
type Int32Rules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must equal 42
	//	  int32 value = 1 [(buf.validate.field).int32.const = 42];
	//	}
	//
	// ```
	Const *int32 `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*Int32Rules_Lt
	//	*Int32Rules_Lte
	LessThan isInt32Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*Int32Rules_Gt
	//	*Int32Rules_Gte
	GreaterThan isInt32Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be in list [1, 2, 3]
	//	  repeated int32 value = 1 (buf.validate.field).int32 = { in: [1, 2, 3] };
	//	}
	//
	// ```
	In []int32 `protobuf:"varint,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must not be in list [1, 2, 3]
	//	  repeated int32 value = 1 (buf.validate.field).int32 = { not_in: [1, 2, 3] };
	//	}
	//
	// ```
	NotIn []int32 `protobuf:"varint,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  int32 value = 1 [
	//	    (buf.validate.field).int32.example = 1,
	//	    (buf.validate.field).int32.example = -10
	//	  ];
	//	}
	//
	// ```
	Example []int32 `protobuf:"varint,8,rep,name=example" json:"example,omitempty"`
}

func (x *Int32Rules) Reset() {
	*x = Int32Rules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Int32Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Int32Rules) ProtoMessage() {}

func (x *Int32Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Int32Rules.ProtoReflect.Descriptor instead.
func (*Int32Rules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{7}
}

func (x *Int32Rules) GetConst() int32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *Int32Rules) GetLessThan() isInt32Rules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *Int32Rules) GetLt() int32 {
	if x, ok := x.GetLessThan().(*Int32Rules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *Int32Rules) GetLte() int32 {
	if x, ok := x.GetLessThan().(*Int32Rules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *Int32Rules) GetGreaterThan() isInt32Rules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *Int32Rules) GetGt() int32 {
	if x, ok := x.GetGreaterThan().(*Int32Rules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *Int32Rules) GetGte() int32 {
	if x, ok := x.GetGreaterThan().(*Int32Rules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *Int32Rules) GetIn() []int32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *Int32Rules) GetNotIn() []int32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *Int32Rules) GetExample() []int32 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isInt32Rules_LessThan interface {
	isInt32Rules_LessThan()
}

type Int32Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field
	// < value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be less than 10
	//	  int32 value = 1 [(buf.validate.field).int32.lt = 10];
	//	}
	//
	// ```
	Lt int32 `protobuf:"varint,2,opt,name=lt,oneof"`
}

type Int32Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be less than or equal to 10
	//	  int32 value = 1 [(buf.validate.field).int32.lte = 10];
	//	}
	//
	// ```
	Lte int32 `protobuf:"varint,3,opt,name=lte,oneof"`
}

func (*Int32Rules_Lt) isInt32Rules_LessThan() {}

func (*Int32Rules_Lte) isInt32Rules_LessThan() {}

type isInt32Rules_GreaterThan interface {
	isInt32Rules_GreaterThan()
}

type Int32Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be greater than 5 [int32.gt]
	//	  int32 value = 1 [(buf.validate.field).int32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [int32.gt_lt]
	//	  int32 other_value = 2 [(buf.validate.field).int32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [int32.gt_lt_exclusive]
	//	  int32 another_value = 3 [(buf.validate.field).int32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int32 `protobuf:"varint,4,opt,name=gt,oneof"`
}

type Int32Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified value
	// (exclusive). If the value of `gte` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be greater than or equal to 5 [int32.gte]
	//	  int32 value = 1 [(buf.validate.field).int32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [int32.gte_lt]
	//	  int32 other_value = 2 [(buf.validate.field).int32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [int32.gte_lt_exclusive]
	//	  int32 another_value = 3 [(buf.validate.field).int32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int32 `protobuf:"varint,5,opt,name=gte,oneof"`
}

func (*Int32Rules_Gt) isInt32Rules_GreaterThan() {}

func (*Int32Rules_Gte) isInt32Rules_GreaterThan() {}

// Int64Rules describes the constraints applied to `int64` values. These
// rules may also be applied to the `google.protobuf.Int64Value` Well-Known-Type.
type Int64Rules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must equal 42
	//	  int64 value = 1 [(buf.validate.field).int64.const = 42];
	//	}
	//
	// ```
	Const *int64 `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*Int64Rules_Lt
	//	*Int64Rules_Lte
	LessThan isInt64Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*Int64Rules_Gt
	//	*Int64Rules_Gte
	GreaterThan isInt64Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be in list [1, 2, 3]
	//	  repeated int64 value = 1 (buf.validate.field).int64 = { in: [1, 2, 3] };
	//	}
	//
	// ```
	In []int64 `protobuf:"varint,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must not be in list [1, 2, 3]
	//	  repeated int64 value = 1 (buf.validate.field).int64 = { not_in: [1, 2, 3] };
	//	}
	//
	// ```
	NotIn []int64 `protobuf:"varint,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  int64 value = 1 [
	//	    (buf.validate.field).int64.example = 1,
	//	    (buf.validate.field).int64.example = -10
	//	  ];
	//	}
	//
	// ```
	Example []int64 `protobuf:"varint,9,rep,name=example" json:"example,omitempty"`
}

func (x *Int64Rules) Reset() {
	*x = Int64Rules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Int64Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Int64Rules) ProtoMessage() {}

func (x *Int64Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Int64Rules.ProtoReflect.Descriptor instead.
func (*Int64Rules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{8}
}

func (x *Int64Rules) GetConst() int64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *Int64Rules) GetLessThan() isInt64Rules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *Int64Rules) GetLt() int64 {
	if x, ok := x.GetLessThan().(*Int64Rules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *Int64Rules) GetLte() int64 {
	if x, ok := x.GetLessThan().(*Int64Rules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *Int64Rules) GetGreaterThan() isInt64Rules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *Int64Rules) GetGt() int64 {
	if x, ok := x.GetGreaterThan().(*Int64Rules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *Int64Rules) GetGte() int64 {
	if x, ok := x.GetGreaterThan().(*Int64Rules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *Int64Rules) GetIn() []int64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *Int64Rules) GetNotIn() []int64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *Int64Rules) GetExample() []int64 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isInt64Rules_LessThan interface {
	isInt64Rules_LessThan()
}

type Int64Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be less than 10
	//	  int64 value = 1 [(buf.validate.field).int64.lt = 10];
	//	}
	//
	// ```
	Lt int64 `protobuf:"varint,2,opt,name=lt,oneof"`
}

type Int64Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be less than or equal to 10
	//	  int64 value = 1 [(buf.validate.field).int64.lte = 10];
	//	}
	//
	// ```
	Lte int64 `protobuf:"varint,3,opt,name=lte,oneof"`
}

func (*Int64Rules_Lt) isInt64Rules_LessThan() {}

func (*Int64Rules_Lte) isInt64Rules_LessThan() {}

type isInt64Rules_GreaterThan interface {
	isInt64Rules_GreaterThan()
}

type Int64Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be greater than 5 [int64.gt]
	//	  int64 value = 1 [(buf.validate.field).int64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [int64.gt_lt]
	//	  int64 other_value = 2 [(buf.validate.field).int64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [int64.gt_lt_exclusive]
	//	  int64 another_value = 3 [(buf.validate.field).int64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int64 `protobuf:"varint,4,opt,name=gt,oneof"`
}

type Int64Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be greater than or equal to 5 [int64.gte]
	//	  int64 value = 1 [(buf.validate.field).int64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [int64.gte_lt]
	//	  int64 other_value = 2 [(buf.validate.field).int64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [int64.gte_lt_exclusive]
	//	  int64 another_value = 3 [(buf.validate.field).int64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int64 `protobuf:"varint,5,opt,name=gte,oneof"`
}

func (*Int64Rules_Gt) isInt64Rules_GreaterThan() {}

func (*Int64Rules_Gte) isInt64Rules_GreaterThan() {}

// UInt32Rules describes the constraints applied to `uint32` values. These
// rules may also be applied to the `google.protobuf.UInt32Value` Well-Known-Type.
type UInt32Rules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must equal 42
	//	  uint32 value = 1 [(buf.validate.field).uint32.const = 42];
	//	}
	//
	// ```
	Const *uint32 `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*UInt32Rules_Lt
	//	*UInt32Rules_Lte
	LessThan isUInt32Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*UInt32Rules_Gt
	//	*UInt32Rules_Gte
	GreaterThan isUInt32Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be in list [1, 2, 3]
	//	  repeated uint32 value = 1 (buf.validate.field).uint32 = { in: [1, 2, 3] };
	//	}
	//
	// ```
	In []uint32 `protobuf:"varint,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must not be in list [1, 2, 3]
	//	  repeated uint32 value = 1 (buf.validate.field).uint32 = { not_in: [1, 2, 3] };
	//	}
	//
	// ```
	NotIn []uint32 `protobuf:"varint,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  uint32 value = 1 [
	//	    (buf.validate.field).uint32.example = 1,
	//	    (buf.validate.field).uint32.example = 10
	//	  ];
	//	}
	//
	// ```
	Example []uint32 `protobuf:"varint,8,rep,name=example" json:"example,omitempty"`
}

func (x *UInt32Rules) Reset() {
	*x = UInt32Rules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UInt32Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UInt32Rules) ProtoMessage() {}

func (x *UInt32Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UInt32Rules.ProtoReflect.Descriptor instead.
func (*UInt32Rules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{9}
}

func (x *UInt32Rules) GetConst() uint32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *UInt32Rules) GetLessThan() isUInt32Rules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *UInt32Rules) GetLt() uint32 {
	if x, ok := x.GetLessThan().(*UInt32Rules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *UInt32Rules) GetLte() uint32 {
	if x, ok := x.GetLessThan().(*UInt32Rules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *UInt32Rules) GetGreaterThan() isUInt32Rules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *UInt32Rules) GetGt() uint32 {
	if x, ok := x.GetGreaterThan().(*UInt32Rules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *UInt32Rules) GetGte() uint32 {
	if x, ok := x.GetGreaterThan().(*UInt32Rules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *UInt32Rules) GetIn() []uint32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *UInt32Rules) GetNotIn() []uint32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *UInt32Rules) GetExample() []uint32 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isUInt32Rules_LessThan interface {
	isUInt32Rules_LessThan()
}

type UInt32Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be less than 10
	//	  uint32 value = 1 [(buf.validate.field).uint32.lt = 10];
	//	}
	//
	// ```
	Lt uint32 `protobuf:"varint,2,opt,name=lt,oneof"`
}

type UInt32Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be less than or equal to 10
	//	  uint32 value = 1 [(buf.validate.field).uint32.lte = 10];
	//	}
	//
	// ```
	Lte uint32 `protobuf:"varint,3,opt,name=lte,oneof"`
}

func (*UInt32Rules_Lt) isUInt32Rules_LessThan() {}

func (*UInt32Rules_Lte) isUInt32Rules_LessThan() {}

type isUInt32Rules_GreaterThan interface {
	isUInt32Rules_GreaterThan()
}

type UInt32Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be greater than 5 [uint32.gt]
	//	  uint32 value = 1 [(buf.validate.field).uint32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [uint32.gt_lt]
	//	  uint32 other_value = 2 [(buf.validate.field).uint32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [uint32.gt_lt_exclusive]
	//	  uint32 another_value = 3 [(buf.validate.field).uint32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt uint32 `protobuf:"varint,4,opt,name=gt,oneof"`
}

type UInt32Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be greater than or equal to 5 [uint32.gte]
	//	  uint32 value = 1 [(buf.validate.field).uint32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [uint32.gte_lt]
	//	  uint32 other_value = 2 [(buf.validate.field).uint32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [uint32.gte_lt_exclusive]
	//	  uint32 another_value = 3 [(buf.validate.field).uint32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte uint32 `protobuf:"varint,5,opt,name=gte,oneof"`
}

func (*UInt32Rules_Gt) isUInt32Rules_GreaterThan() {}

func (*UInt32Rules_Gte) isUInt32Rules_GreaterThan() {}

// UInt64Rules describes the constraints applied to `uint64` values. These
// rules may also be applied to the `google.protobuf.UInt64Value` Well-Known-Type.
type UInt64Rules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must equal 42
	//	  uint64 value = 1 [(buf.validate.field).uint64.const = 42];
	//	}
	//
	// ```
	Const *uint64 `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*UInt64Rules_Lt
	//	*UInt64Rules_Lte
	LessThan isUInt64Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*UInt64Rules_Gt
	//	*UInt64Rules_Gte
	GreaterThan isUInt64Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be in list [1, 2, 3]
	//	  repeated uint64 value = 1 (buf.validate.field).uint64 = { in: [1, 2, 3] };
	//	}
	//
	// ```
	In []uint64 `protobuf:"varint,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must not be in list [1, 2, 3]
	//	  repeated uint64 value = 1 (buf.validate.field).uint64 = { not_in: [1, 2, 3] };
	//	}
	//
	// ```
	NotIn []uint64 `protobuf:"varint,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  uint64 value = 1 [
	//	    (buf.validate.field).uint64.example = 1,
	//	    (buf.validate.field).uint64.example = -10
	//	  ];
	//	}
	//
	// ```
	Example []uint64 `protobuf:"varint,8,rep,name=example" json:"example,omitempty"`
}

func (x *UInt64Rules) Reset() {
	*x = UInt64Rules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UInt64Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UInt64Rules) ProtoMessage() {}

func (x *UInt64Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UInt64Rules.ProtoReflect.Descriptor instead.
func (*UInt64Rules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{10}
}

func (x *UInt64Rules) GetConst() uint64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *UInt64Rules) GetLessThan() isUInt64Rules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *UInt64Rules) GetLt() uint64 {
	if x, ok := x.GetLessThan().(*UInt64Rules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *UInt64Rules) GetLte() uint64 {
	if x, ok := x.GetLessThan().(*UInt64Rules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *UInt64Rules) GetGreaterThan() isUInt64Rules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *UInt64Rules) GetGt() uint64 {
	if x, ok := x.GetGreaterThan().(*UInt64Rules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *UInt64Rules) GetGte() uint64 {
	if x, ok := x.GetGreaterThan().(*UInt64Rules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *UInt64Rules) GetIn() []uint64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *UInt64Rules) GetNotIn() []uint64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *UInt64Rules) GetExample() []uint64 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isUInt64Rules_LessThan interface {
	isUInt64Rules_LessThan()
}

type UInt64Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be less than 10
	//	  uint64 value = 1 [(buf.validate.field).uint64.lt = 10];
	//	}
	//
	// ```
	Lt uint64 `protobuf:"varint,2,opt,name=lt,oneof"`
}

type UInt64Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be less than or equal to 10
	//	  uint64 value = 1 [(buf.validate.field).uint64.lte = 10];
	//	}
	//
	// ```
	Lte uint64 `protobuf:"varint,3,opt,name=lte,oneof"`
}

func (*UInt64Rules_Lt) isUInt64Rules_LessThan() {}

func (*UInt64Rules_Lte) isUInt64Rules_LessThan() {}

type isUInt64Rules_GreaterThan interface {
	isUInt64Rules_GreaterThan()
}

type UInt64Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be greater than 5 [uint64.gt]
	//	  uint64 value = 1 [(buf.validate.field).uint64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [uint64.gt_lt]
	//	  uint64 other_value = 2 [(buf.validate.field).uint64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [uint64.gt_lt_exclusive]
	//	  uint64 another_value = 3 [(buf.validate.field).uint64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt uint64 `protobuf:"varint,4,opt,name=gt,oneof"`
}

type UInt64Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be greater than or equal to 5 [uint64.gte]
	//	  uint64 value = 1 [(buf.validate.field).uint64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [uint64.gte_lt]
	//	  uint64 other_value = 2 [(buf.validate.field).uint64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [uint64.gte_lt_exclusive]
	//	  uint64 another_value = 3 [(buf.validate.field).uint64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte uint64 `protobuf:"varint,5,opt,name=gte,oneof"`
}

func (*UInt64Rules_Gt) isUInt64Rules_GreaterThan() {}

func (*UInt64Rules_Gte) isUInt64Rules_GreaterThan() {}

// SInt32Rules describes the constraints applied to `sint32` values.
type SInt32Rules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must equal 42
	//	  sint32 value = 1 [(buf.validate.field).sint32.const = 42];
	//	}
	//
	// ```
	Const *int32 `protobuf:"zigzag32,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*SInt32Rules_Lt
	//	*SInt32Rules_Lte
	LessThan isSInt32Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*SInt32Rules_Gt
	//	*SInt32Rules_Gte
	GreaterThan isSInt32Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be in list [1, 2, 3]
	//	  repeated sint32 value = 1 (buf.validate.field).sint32 = { in: [1, 2, 3] };
	//	}
	//
	// ```
	In []int32 `protobuf:"zigzag32,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must not be in list [1, 2, 3]
	//	  repeated sint32 value = 1 (buf.validate.field).sint32 = { not_in: [1, 2, 3] };
	//	}
	//
	// ```
	NotIn []int32 `protobuf:"zigzag32,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  sint32 value = 1 [
	//	    (buf.validate.field).sint32.example = 1,
	//	    (buf.validate.field).sint32.example = -10
	//	  ];
	//	}
	//
	// ```
	Example []int32 `protobuf:"zigzag32,8,rep,name=example" json:"example,omitempty"`
}

func (x *SInt32Rules) Reset() {
	*x = SInt32Rules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SInt32Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SInt32Rules) ProtoMessage() {}

func (x *SInt32Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SInt32Rules.ProtoReflect.Descriptor instead.
func (*SInt32Rules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{11}
}

func (x *SInt32Rules) GetConst() int32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *SInt32Rules) GetLessThan() isSInt32Rules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *SInt32Rules) GetLt() int32 {
	if x, ok := x.GetLessThan().(*SInt32Rules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *SInt32Rules) GetLte() int32 {
	if x, ok := x.GetLessThan().(*SInt32Rules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *SInt32Rules) GetGreaterThan() isSInt32Rules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *SInt32Rules) GetGt() int32 {
	if x, ok := x.GetGreaterThan().(*SInt32Rules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *SInt32Rules) GetGte() int32 {
	if x, ok := x.GetGreaterThan().(*SInt32Rules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *SInt32Rules) GetIn() []int32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *SInt32Rules) GetNotIn() []int32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *SInt32Rules) GetExample() []int32 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isSInt32Rules_LessThan interface {
	isSInt32Rules_LessThan()
}

type SInt32Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field
	// < value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be less than 10
	//	  sint32 value = 1 [(buf.validate.field).sint32.lt = 10];
	//	}
	//
	// ```
	Lt int32 `protobuf:"zigzag32,2,opt,name=lt,oneof"`
}

type SInt32Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be less than or equal to 10
	//	  sint32 value = 1 [(buf.validate.field).sint32.lte = 10];
	//	}
	//
	// ```
	Lte int32 `protobuf:"zigzag32,3,opt,name=lte,oneof"`
}

func (*SInt32Rules_Lt) isSInt32Rules_LessThan() {}

func (*SInt32Rules_Lte) isSInt32Rules_LessThan() {}

type isSInt32Rules_GreaterThan interface {
	isSInt32Rules_GreaterThan()
}

type SInt32Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be greater than 5 [sint32.gt]
	//	  sint32 value = 1 [(buf.validate.field).sint32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sint32.gt_lt]
	//	  sint32 other_value = 2 [(buf.validate.field).sint32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sint32.gt_lt_exclusive]
	//	  sint32 another_value = 3 [(buf.validate.field).sint32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int32 `protobuf:"zigzag32,4,opt,name=gt,oneof"`
}

type SInt32Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	 // value must be greater than or equal to 5 [sint32.gte]
	//	 sint32 value = 1 [(buf.validate.field).sint32.gte = 5];
	//
	//	 // value must be greater than or equal to 5 and less than 10 [sint32.gte_lt]
	//	 sint32 other_value = 2 [(buf.validate.field).sint32 = { gte: 5, lt: 10 }];
	//
	//	 // value must be greater than or equal to 10 or less than 5 [sint32.gte_lt_exclusive]
	//	 sint32 another_value = 3 [(buf.validate.field).sint32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int32 `protobuf:"zigzag32,5,opt,name=gte,oneof"`
}

func (*SInt32Rules_Gt) isSInt32Rules_GreaterThan() {}

func (*SInt32Rules_Gte) isSInt32Rules_GreaterThan() {}

// SInt64Rules describes the constraints applied to `sint64` values.
type SInt64Rules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must equal 42
	//	  sint64 value = 1 [(buf.validate.field).sint64.const = 42];
	//	}
	//
	// ```
	Const *int64 `protobuf:"zigzag64,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*SInt64Rules_Lt
	//	*SInt64Rules_Lte
	LessThan isSInt64Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*SInt64Rules_Gt
	//	*SInt64Rules_Gte
	GreaterThan isSInt64Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be in list [1, 2, 3]
	//	  repeated sint64 value = 1 (buf.validate.field).sint64 = { in: [1, 2, 3] };
	//	}
	//
	// ```
	In []int64 `protobuf:"zigzag64,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must not be in list [1, 2, 3]
	//	  repeated sint64 value = 1 (buf.validate.field).sint64 = { not_in: [1, 2, 3] };
	//	}
	//
	// ```
	NotIn []int64 `protobuf:"zigzag64,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  sint64 value = 1 [
	//	    (buf.validate.field).sint64.example = 1,
	//	    (buf.validate.field).sint64.example = -10
	//	  ];
	//	}
	//
	// ```
	Example []int64 `protobuf:"zigzag64,8,rep,name=example" json:"example,omitempty"`
}

func (x *SInt64Rules) Reset() {
	*x = SInt64Rules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SInt64Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SInt64Rules) ProtoMessage() {}

func (x *SInt64Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SInt64Rules.ProtoReflect.Descriptor instead.
func (*SInt64Rules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{12}
}

func (x *SInt64Rules) GetConst() int64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *SInt64Rules) GetLessThan() isSInt64Rules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *SInt64Rules) GetLt() int64 {
	if x, ok := x.GetLessThan().(*SInt64Rules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *SInt64Rules) GetLte() int64 {
	if x, ok := x.GetLessThan().(*SInt64Rules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *SInt64Rules) GetGreaterThan() isSInt64Rules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *SInt64Rules) GetGt() int64 {
	if x, ok := x.GetGreaterThan().(*SInt64Rules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *SInt64Rules) GetGte() int64 {
	if x, ok := x.GetGreaterThan().(*SInt64Rules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *SInt64Rules) GetIn() []int64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *SInt64Rules) GetNotIn() []int64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *SInt64Rules) GetExample() []int64 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isSInt64Rules_LessThan interface {
	isSInt64Rules_LessThan()
}

type SInt64Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field
	// < value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be less than 10
	//	  sint64 value = 1 [(buf.validate.field).sint64.lt = 10];
	//	}
	//
	// ```
	Lt int64 `protobuf:"zigzag64,2,opt,name=lt,oneof"`
}

type SInt64Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be less than or equal to 10
	//	  sint64 value = 1 [(buf.validate.field).sint64.lte = 10];
	//	}
	//
	// ```
	Lte int64 `protobuf:"zigzag64,3,opt,name=lte,oneof"`
}

func (*SInt64Rules_Lt) isSInt64Rules_LessThan() {}

func (*SInt64Rules_Lte) isSInt64Rules_LessThan() {}

type isSInt64Rules_GreaterThan interface {
	isSInt64Rules_GreaterThan()
}

type SInt64Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be greater than 5 [sint64.gt]
	//	  sint64 value = 1 [(buf.validate.field).sint64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sint64.gt_lt]
	//	  sint64 other_value = 2 [(buf.validate.field).sint64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sint64.gt_lt_exclusive]
	//	  sint64 another_value = 3 [(buf.validate.field).sint64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int64 `protobuf:"zigzag64,4,opt,name=gt,oneof"`
}

type SInt64Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be greater than or equal to 5 [sint64.gte]
	//	  sint64 value = 1 [(buf.validate.field).sint64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [sint64.gte_lt]
	//	  sint64 other_value = 2 [(buf.validate.field).sint64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [sint64.gte_lt_exclusive]
	//	  sint64 another_value = 3 [(buf.validate.field).sint64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int64 `protobuf:"zigzag64,5,opt,name=gte,oneof"`
}

func (*SInt64Rules_Gt) isSInt64Rules_GreaterThan() {}

func (*SInt64Rules_Gte) isSInt64Rules_GreaterThan() {}

// Fixed32Rules describes the constraints applied to `fixed32` values.
type Fixed32Rules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must equal 42
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.const = 42];
	//	}
	//
	// ```
	Const *uint32 `protobuf:"fixed32,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*Fixed32Rules_Lt
	//	*Fixed32Rules_Lte
	LessThan isFixed32Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*Fixed32Rules_Gt
	//	*Fixed32Rules_Gte
	GreaterThan isFixed32Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be in list [1, 2, 3]
	//	  repeated fixed32 value = 1 (buf.validate.field).fixed32 = { in: [1, 2, 3] };
	//	}
	//
	// ```
	In []uint32 `protobuf:"fixed32,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must not be in list [1, 2, 3]
	//	  repeated fixed32 value = 1 (buf.validate.field).fixed32 = { not_in: [1, 2, 3] };
	//	}
	//
	// ```
	NotIn []uint32 `protobuf:"fixed32,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  fixed32 value = 1 [
	//	    (buf.validate.field).fixed32.example = 1,
	//	    (buf.validate.field).fixed32.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []uint32 `protobuf:"fixed32,8,rep,name=example" json:"example,omitempty"`
}

func (x *Fixed32Rules) Reset() {
	*x = Fixed32Rules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Fixed32Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fixed32Rules) ProtoMessage() {}

func (x *Fixed32Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Fixed32Rules.ProtoReflect.Descriptor instead.
func (*Fixed32Rules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{13}
}

func (x *Fixed32Rules) GetConst() uint32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *Fixed32Rules) GetLessThan() isFixed32Rules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *Fixed32Rules) GetLt() uint32 {
	if x, ok := x.GetLessThan().(*Fixed32Rules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *Fixed32Rules) GetLte() uint32 {
	if x, ok := x.GetLessThan().(*Fixed32Rules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *Fixed32Rules) GetGreaterThan() isFixed32Rules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *Fixed32Rules) GetGt() uint32 {
	if x, ok := x.GetGreaterThan().(*Fixed32Rules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *Fixed32Rules) GetGte() uint32 {
	if x, ok := x.GetGreaterThan().(*Fixed32Rules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *Fixed32Rules) GetIn() []uint32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *Fixed32Rules) GetNotIn() []uint32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *Fixed32Rules) GetExample() []uint32 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isFixed32Rules_LessThan interface {
	isFixed32Rules_LessThan()
}

type Fixed32Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be less than 10
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.lt = 10];
	//	}
	//
	// ```
	Lt uint32 `protobuf:"fixed32,2,opt,name=lt,oneof"`
}

type Fixed32Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be less than or equal to 10
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.lte = 10];
	//	}
	//
	// ```
	Lte uint32 `protobuf:"fixed32,3,opt,name=lte,oneof"`
}

func (*Fixed32Rules_Lt) isFixed32Rules_LessThan() {}

func (*Fixed32Rules_Lte) isFixed32Rules_LessThan() {}

type isFixed32Rules_GreaterThan interface {
	isFixed32Rules_GreaterThan()
}

type Fixed32Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be greater than 5 [fixed32.gt]
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [fixed32.gt_lt]
	//	  fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [fixed32.gt_lt_exclusive]
	//	  fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt uint32 `protobuf:"fixed32,4,opt,name=gt,oneof"`
}

type Fixed32Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be greater than or equal to 5 [fixed32.gte]
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [fixed32.gte_lt]
	//	  fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [fixed32.gte_lt_exclusive]
	//	  fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte uint32 `protobuf:"fixed32,5,opt,name=gte,oneof"`
}

func (*Fixed32Rules_Gt) isFixed32Rules_GreaterThan() {}

func (*Fixed32Rules_Gte) isFixed32Rules_GreaterThan() {}

// Fixed64Rules describes the constraints applied to `fixed64` values.
type Fixed64Rules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must equal 42
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.const = 42];
	//	}
	//
	// ```
	Const *uint64 `protobuf:"fixed64,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*Fixed64Rules_Lt
	//	*Fixed64Rules_Lte
	LessThan isFixed64Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*Fixed64Rules_Gt
	//	*Fixed64Rules_Gte
	GreaterThan isFixed64Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be in list [1, 2, 3]
	//	  repeated fixed64 value = 1 (buf.validate.field).fixed64 = { in: [1, 2, 3] };
	//	}
	//
	// ```
	In []uint64 `protobuf:"fixed64,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must not be in list [1, 2, 3]
	//	  repeated fixed64 value = 1 (buf.validate.field).fixed64 = { not_in: [1, 2, 3] };
	//	}
	//
	// ```
	NotIn []uint64 `protobuf:"fixed64,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  fixed64 value = 1 [
	//	    (buf.validate.field).fixed64.example = 1,
	//	    (buf.validate.field).fixed64.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []uint64 `protobuf:"fixed64,8,rep,name=example" json:"example,omitempty"`
}

func (x *Fixed64Rules) Reset() {
	*x = Fixed64Rules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Fixed64Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fixed64Rules) ProtoMessage() {}

func (x *Fixed64Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Fixed64Rules.ProtoReflect.Descriptor instead.
func (*Fixed64Rules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{14}
}

func (x *Fixed64Rules) GetConst() uint64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *Fixed64Rules) GetLessThan() isFixed64Rules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *Fixed64Rules) GetLt() uint64 {
	if x, ok := x.GetLessThan().(*Fixed64Rules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *Fixed64Rules) GetLte() uint64 {
	if x, ok := x.GetLessThan().(*Fixed64Rules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *Fixed64Rules) GetGreaterThan() isFixed64Rules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *Fixed64Rules) GetGt() uint64 {
	if x, ok := x.GetGreaterThan().(*Fixed64Rules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *Fixed64Rules) GetGte() uint64 {
	if x, ok := x.GetGreaterThan().(*Fixed64Rules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *Fixed64Rules) GetIn() []uint64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *Fixed64Rules) GetNotIn() []uint64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *Fixed64Rules) GetExample() []uint64 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isFixed64Rules_LessThan interface {
	isFixed64Rules_LessThan()
}

type Fixed64Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be less than 10
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.lt = 10];
	//	}
	//
	// ```
	Lt uint64 `protobuf:"fixed64,2,opt,name=lt,oneof"`
}

type Fixed64Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be less than or equal to 10
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.lte = 10];
	//	}
	//
	// ```
	Lte uint64 `protobuf:"fixed64,3,opt,name=lte,oneof"`
}

func (*Fixed64Rules_Lt) isFixed64Rules_LessThan() {}

func (*Fixed64Rules_Lte) isFixed64Rules_LessThan() {}

type isFixed64Rules_GreaterThan interface {
	isFixed64Rules_GreaterThan()
}

type Fixed64Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be greater than 5 [fixed64.gt]
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [fixed64.gt_lt]
	//	  fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [fixed64.gt_lt_exclusive]
	//	  fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt uint64 `protobuf:"fixed64,4,opt,name=gt,oneof"`
}

type Fixed64Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be greater than or equal to 5 [fixed64.gte]
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [fixed64.gte_lt]
	//	  fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [fixed64.gte_lt_exclusive]
	//	  fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte uint64 `protobuf:"fixed64,5,opt,name=gte,oneof"`
}

func (*Fixed64Rules_Gt) isFixed64Rules_GreaterThan() {}

func (*Fixed64Rules_Gte) isFixed64Rules_GreaterThan() {}

// SFixed32Rules describes the constraints applied to `fixed32` values.
type SFixed32Rules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must equal 42
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.const = 42];
	//	}
	//
	// ```
	Const *int32 `protobuf:"fixed32,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*SFixed32Rules_Lt
	//	*SFixed32Rules_Lte
	LessThan isSFixed32Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*SFixed32Rules_Gt
	//	*SFixed32Rules_Gte
	GreaterThan isSFixed32Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be in list [1, 2, 3]
	//	  repeated sfixed32 value = 1 (buf.validate.field).sfixed32 = { in: [1, 2, 3] };
	//	}
	//
	// ```
	In []int32 `protobuf:"fixed32,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must not be in list [1, 2, 3]
	//	  repeated sfixed32 value = 1 (buf.validate.field).sfixed32 = { not_in: [1, 2, 3] };
	//	}
	//
	// ```
	NotIn []int32 `protobuf:"fixed32,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  sfixed32 value = 1 [
	//	    (buf.validate.field).sfixed32.example = 1,
	//	    (buf.validate.field).sfixed32.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []int32 `protobuf:"fixed32,8,rep,name=example" json:"example,omitempty"`
}

func (x *SFixed32Rules) Reset() {
	*x = SFixed32Rules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SFixed32Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SFixed32Rules) ProtoMessage() {}

func (x *SFixed32Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SFixed32Rules.ProtoReflect.Descriptor instead.
func (*SFixed32Rules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{15}
}

func (x *SFixed32Rules) GetConst() int32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *SFixed32Rules) GetLessThan() isSFixed32Rules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *SFixed32Rules) GetLt() int32 {
	if x, ok := x.GetLessThan().(*SFixed32Rules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *SFixed32Rules) GetLte() int32 {
	if x, ok := x.GetLessThan().(*SFixed32Rules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *SFixed32Rules) GetGreaterThan() isSFixed32Rules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *SFixed32Rules) GetGt() int32 {
	if x, ok := x.GetGreaterThan().(*SFixed32Rules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *SFixed32Rules) GetGte() int32 {
	if x, ok := x.GetGreaterThan().(*SFixed32Rules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *SFixed32Rules) GetIn() []int32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *SFixed32Rules) GetNotIn() []int32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *SFixed32Rules) GetExample() []int32 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isSFixed32Rules_LessThan interface {
	isSFixed32Rules_LessThan()
}

type SFixed32Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be less than 10
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.lt = 10];
	//	}
	//
	// ```
	Lt int32 `protobuf:"fixed32,2,opt,name=lt,oneof"`
}

type SFixed32Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be less than or equal to 10
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.lte = 10];
	//	}
	//
	// ```
	Lte int32 `protobuf:"fixed32,3,opt,name=lte,oneof"`
}

func (*SFixed32Rules_Lt) isSFixed32Rules_LessThan() {}

func (*SFixed32Rules_Lte) isSFixed32Rules_LessThan() {}

type isSFixed32Rules_GreaterThan interface {
	isSFixed32Rules_GreaterThan()
}

type SFixed32Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be greater than 5 [sfixed32.gt]
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sfixed32.gt_lt]
	//	  sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sfixed32.gt_lt_exclusive]
	//	  sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int32 `protobuf:"fixed32,4,opt,name=gt,oneof"`
}

type SFixed32Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be greater than or equal to 5 [sfixed32.gte]
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [sfixed32.gte_lt]
	//	  sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [sfixed32.gte_lt_exclusive]
	//	  sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int32 `protobuf:"fixed32,5,opt,name=gte,oneof"`
}

func (*SFixed32Rules_Gt) isSFixed32Rules_GreaterThan() {}

func (*SFixed32Rules_Gte) isSFixed32Rules_GreaterThan() {}

// SFixed64Rules describes the constraints applied to `fixed64` values.
type SFixed64Rules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must equal 42
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.const = 42];
	//	}
	//
	// ```
	Const *int64 `protobuf:"fixed64,1,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*SFixed64Rules_Lt
	//	*SFixed64Rules_Lte
	LessThan isSFixed64Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*SFixed64Rules_Gt
	//	*SFixed64Rules_Gte
	GreaterThan isSFixed64Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be in list [1, 2, 3]
	//	  repeated sfixed64 value = 1 (buf.validate.field).sfixed64 = { in: [1, 2, 3] };
	//	}
	//
	// ```
	In []int64 `protobuf:"fixed64,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must not be in list [1, 2, 3]
	//	  repeated sfixed64 value = 1 (buf.validate.field).sfixed64 = { not_in: [1, 2, 3] };
	//	}
	//
	// ```
	NotIn []int64 `protobuf:"fixed64,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  sfixed64 value = 1 [
	//	    (buf.validate.field).sfixed64.example = 1,
	//	    (buf.validate.field).sfixed64.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []int64 `protobuf:"fixed64,8,rep,name=example" json:"example,omitempty"`
}

func (x *SFixed64Rules) Reset() {
	*x = SFixed64Rules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SFixed64Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SFixed64Rules) ProtoMessage() {}

func (x *SFixed64Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SFixed64Rules.ProtoReflect.Descriptor instead.
func (*SFixed64Rules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{16}
}

func (x *SFixed64Rules) GetConst() int64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (m *SFixed64Rules) GetLessThan() isSFixed64Rules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *SFixed64Rules) GetLt() int64 {
	if x, ok := x.GetLessThan().(*SFixed64Rules_Lt); ok {
		return x.Lt
	}
	return 0
}

func (x *SFixed64Rules) GetLte() int64 {
	if x, ok := x.GetLessThan().(*SFixed64Rules_Lte); ok {
		return x.Lte
	}
	return 0
}

func (m *SFixed64Rules) GetGreaterThan() isSFixed64Rules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *SFixed64Rules) GetGt() int64 {
	if x, ok := x.GetGreaterThan().(*SFixed64Rules_Gt); ok {
		return x.Gt
	}
	return 0
}

func (x *SFixed64Rules) GetGte() int64 {
	if x, ok := x.GetGreaterThan().(*SFixed64Rules_Gte); ok {
		return x.Gte
	}
	return 0
}

func (x *SFixed64Rules) GetIn() []int64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *SFixed64Rules) GetNotIn() []int64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *SFixed64Rules) GetExample() []int64 {
	if x != nil {
		return x.Example
	}
	return nil
}

type isSFixed64Rules_LessThan interface {
	isSFixed64Rules_LessThan()
}

type SFixed64Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be less than 10
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.lt = 10];
	//	}
	//
	// ```
	Lt int64 `protobuf:"fixed64,2,opt,name=lt,oneof"`
}

type SFixed64Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be less than or equal to 10
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.lte = 10];
	//	}
	//
	// ```
	Lte int64 `protobuf:"fixed64,3,opt,name=lte,oneof"`
}

func (*SFixed64Rules_Lt) isSFixed64Rules_LessThan() {}

func (*SFixed64Rules_Lte) isSFixed64Rules_LessThan() {}

type isSFixed64Rules_GreaterThan interface {
	isSFixed64Rules_GreaterThan()
}

type SFixed64Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be greater than 5 [sfixed64.gt]
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sfixed64.gt_lt]
	//	  sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sfixed64.gt_lt_exclusive]
	//	  sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int64 `protobuf:"fixed64,4,opt,name=gt,oneof"`
}

type SFixed64Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be greater than or equal to 5 [sfixed64.gte]
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [sfixed64.gte_lt]
	//	  sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [sfixed64.gte_lt_exclusive]
	//	  sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int64 `protobuf:"fixed64,5,opt,name=gte,oneof"`
}

func (*SFixed64Rules_Gt) isSFixed64Rules_GreaterThan() {}

func (*SFixed64Rules_Gte) isSFixed64Rules_GreaterThan() {}

// BoolRules describes the constraints applied to `bool` values. These rules
// may also be applied to the `google.protobuf.BoolValue` Well-Known-Type.
type BoolRules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified boolean value.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyBool {
	//	  // value must equal true
	//	  bool value = 1 [(buf.validate.field).bool.const = true];
	//	}
	//
	// ```
	Const *bool `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyBool {
	//	  bool value = 1 [
	//	    (buf.validate.field).bool.example = 1,
	//	    (buf.validate.field).bool.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []bool `protobuf:"varint,2,rep,name=example" json:"example,omitempty"`
}

func (x *BoolRules) Reset() {
	*x = BoolRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoolRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoolRules) ProtoMessage() {}

func (x *BoolRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoolRules.ProtoReflect.Descriptor instead.
func (*BoolRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{17}
}

func (x *BoolRules) GetConst() bool {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return false
}

func (x *BoolRules) GetExample() []bool {
	if x != nil {
		return x.Example
	}
	return nil
}

// StringRules describes the constraints applied to `string` values These
// rules may also be applied to the `google.protobuf.StringValue` Well-Known-Type.
type StringRules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must equal `hello`
	//	  string value = 1 [(buf.validate.field).string.const = "hello"];
	//	}
	//
	// ```
	Const *string `protobuf:"bytes,1,opt,name=const" json:"const,omitempty"`
	// `len` dictates that the field value must have the specified
	// number of characters (Unicode code points), which may differ from the number
	// of bytes in the string. If the field value does not meet the specified
	// length, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be 5 characters
	//	  string value = 1 [(buf.validate.field).string.len = 5];
	//	}
	//
	// ```
	Len *uint64 `protobuf:"varint,19,opt,name=len" json:"len,omitempty"`
	// `min_len` specifies that the field value must have at least the specified
	// number of characters (Unicode code points), which may differ from the number
	// of bytes in the string. If the field value contains fewer characters, an error
	// message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at least 3 characters
	//	  string value = 1 [(buf.validate.field).string.min_len = 3];
	//	}
	//
	// ```
	MinLen *uint64 `protobuf:"varint,2,opt,name=min_len,json=minLen" json:"min_len,omitempty"`
	// `max_len` specifies that the field value must have no more than the specified
	// number of characters (Unicode code points), which may differ from the
	// number of bytes in the string. If the field value contains more characters,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at most 10 characters
	//	  string value = 1 [(buf.validate.field).string.max_len = 10];
	//	}
	//
	// ```
	MaxLen *uint64 `protobuf:"varint,3,opt,name=max_len,json=maxLen" json:"max_len,omitempty"`
	// `len_bytes` dictates that the field value must have the specified number of
	// bytes. If the field value does not match the specified length in bytes,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be 6 bytes
	//	  string value = 1 [(buf.validate.field).string.len_bytes = 6];
	//	}
	//
	// ```
	LenBytes *uint64 `protobuf:"varint,20,opt,name=len_bytes,json=lenBytes" json:"len_bytes,omitempty"`
	// `min_bytes` specifies that the field value must have at least the specified
	// number of bytes. If the field value contains fewer bytes, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at least 4 bytes
	//	  string value = 1 [(buf.validate.field).string.min_bytes = 4];
	//	}
	//
	// ```
	MinBytes *uint64 `protobuf:"varint,4,opt,name=min_bytes,json=minBytes" json:"min_bytes,omitempty"`
	// `max_bytes` specifies that the field value must have no more than the
	// specified number of bytes. If the field value contains more bytes, an
	// error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at most 8 bytes
	//	  string value = 1 [(buf.validate.field).string.max_bytes = 8];
	//	}
	//
	// ```
	MaxBytes *uint64 `protobuf:"varint,5,opt,name=max_bytes,json=maxBytes" json:"max_bytes,omitempty"`
	// `pattern` specifies that the field value must match the specified
	// regular expression (RE2 syntax), with the expression provided without any
	// delimiters. If the field value doesn't match the regular expression, an
	// error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not match regex pattern `^[a-zA-Z]//$`
	//	  string value = 1 [(buf.validate.field).string.pattern = "^[a-zA-Z]//$"];
	//	}
	//
	// ```
	Pattern *string `protobuf:"bytes,6,opt,name=pattern" json:"pattern,omitempty"`
	// `prefix` specifies that the field value must have the
	// specified substring at the beginning of the string. If the field value
	// doesn't start with the specified prefix, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not have prefix `pre`
	//	  string value = 1 [(buf.validate.field).string.prefix = "pre"];
	//	}
	//
	// ```
	Prefix *string `protobuf:"bytes,7,opt,name=prefix" json:"prefix,omitempty"`
	// `suffix` specifies that the field value must have the
	// specified substring at the end of the string. If the field value doesn't
	// end with the specified suffix, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not have suffix `post`
	//	  string value = 1 [(buf.validate.field).string.suffix = "post"];
	//	}
	//
	// ```
	Suffix *string `protobuf:"bytes,8,opt,name=suffix" json:"suffix,omitempty"`
	// `contains` specifies that the field value must have the
	// specified substring anywhere in the string. If the field value doesn't
	// contain the specified substring, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not contain substring `inside`.
	//	  string value = 1 [(buf.validate.field).string.contains = "inside"];
	//	}
	//
	// ```
	Contains *string `protobuf:"bytes,9,opt,name=contains" json:"contains,omitempty"`
	// `not_contains` specifies that the field value must not have the
	// specified substring anywhere in the string. If the field value contains
	// the specified substring, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value contains substring `inside`.
	//	  string value = 1 [(buf.validate.field).string.not_contains = "inside"];
	//	}
	//
	// ```
	NotContains *string `protobuf:"bytes,23,opt,name=not_contains,json=notContains" json:"not_contains,omitempty"`
	// `in` specifies that the field value must be equal to one of the specified
	// values. If the field value isn't one of the specified values, an error
	// message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be in list ["apple", "banana"]
	//	  repeated string value = 1 [(buf.validate.field).string.in = "apple", (buf.validate.field).string.in = "banana"];
	//	}
	//
	// ```
	In []string `protobuf:"bytes,10,rep,name=in" json:"in,omitempty"`
	// `not_in` specifies that the field value cannot be equal to any
	// of the specified values. If the field value is one of the specified values,
	// an error message will be generated.
	// ```proto
	//
	//	message MyString {
	//	  // value must not be in list ["orange", "grape"]
	//	  repeated string value = 1 [(buf.validate.field).string.not_in = "orange", (buf.validate.field).string.not_in = "grape"];
	//	}
	//
	// ```
	NotIn []string `protobuf:"bytes,11,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `WellKnown` rules provide advanced constraints against common string
	// patterns
	//
	// Types that are assignable to WellKnown:
	//
	//	*StringRules_Email
	//	*StringRules_Hostname
	//	*StringRules_Ip
	//	*StringRules_Ipv4
	//	*StringRules_Ipv6
	//	*StringRules_Uri
	//	*StringRules_UriRef
	//	*StringRules_Address
	//	*StringRules_Uuid
	//	*StringRules_Tuuid
	//	*StringRules_IpWithPrefixlen
	//	*StringRules_Ipv4WithPrefixlen
	//	*StringRules_Ipv6WithPrefixlen
	//	*StringRules_IpPrefix
	//	*StringRules_Ipv4Prefix
	//	*StringRules_Ipv6Prefix
	//	*StringRules_HostAndPort
	//	*StringRules_WellKnownRegex
	WellKnown isStringRules_WellKnown `protobuf_oneof:"well_known"`
	// This applies to regexes `HTTP_HEADER_NAME` and `HTTP_HEADER_VALUE` to
	// enable strict header validation. By default, this is true, and HTTP header
	// validations are [RFC-compliant](https://tools.ietf.org/html/rfc7230#section-3). Setting to false will enable looser
	// validations that only disallow `\r\n\0` characters, which can be used to
	// bypass header matching rules.
	//
	// ```proto
	//
	//	message MyString {
	//	  // The field `value` must have be a valid HTTP headers, but not enforced with strict rules.
	//	  string value = 1 [(buf.validate.field).string.strict = false];
	//	}
	//
	// ```
	Strict *bool `protobuf:"varint,25,opt,name=strict" json:"strict,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyString {
	//	  string value = 1 [
	//	    (buf.validate.field).string.example = 1,
	//	    (buf.validate.field).string.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []string `protobuf:"bytes,34,rep,name=example" json:"example,omitempty"`
}

func (x *StringRules) Reset() {
	*x = StringRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StringRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringRules) ProtoMessage() {}

func (x *StringRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringRules.ProtoReflect.Descriptor instead.
func (*StringRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{18}
}

func (x *StringRules) GetConst() string {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return ""
}

func (x *StringRules) GetLen() uint64 {
	if x != nil && x.Len != nil {
		return *x.Len
	}
	return 0
}

func (x *StringRules) GetMinLen() uint64 {
	if x != nil && x.MinLen != nil {
		return *x.MinLen
	}
	return 0
}

func (x *StringRules) GetMaxLen() uint64 {
	if x != nil && x.MaxLen != nil {
		return *x.MaxLen
	}
	return 0
}

func (x *StringRules) GetLenBytes() uint64 {
	if x != nil && x.LenBytes != nil {
		return *x.LenBytes
	}
	return 0
}

func (x *StringRules) GetMinBytes() uint64 {
	if x != nil && x.MinBytes != nil {
		return *x.MinBytes
	}
	return 0
}

func (x *StringRules) GetMaxBytes() uint64 {
	if x != nil && x.MaxBytes != nil {
		return *x.MaxBytes
	}
	return 0
}

func (x *StringRules) GetPattern() string {
	if x != nil && x.Pattern != nil {
		return *x.Pattern
	}
	return ""
}

func (x *StringRules) GetPrefix() string {
	if x != nil && x.Prefix != nil {
		return *x.Prefix
	}
	return ""
}

func (x *StringRules) GetSuffix() string {
	if x != nil && x.Suffix != nil {
		return *x.Suffix
	}
	return ""
}

func (x *StringRules) GetContains() string {
	if x != nil && x.Contains != nil {
		return *x.Contains
	}
	return ""
}

func (x *StringRules) GetNotContains() string {
	if x != nil && x.NotContains != nil {
		return *x.NotContains
	}
	return ""
}

func (x *StringRules) GetIn() []string {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *StringRules) GetNotIn() []string {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (m *StringRules) GetWellKnown() isStringRules_WellKnown {
	if m != nil {
		return m.WellKnown
	}
	return nil
}

func (x *StringRules) GetEmail() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Email); ok {
		return x.Email
	}
	return false
}

func (x *StringRules) GetHostname() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Hostname); ok {
		return x.Hostname
	}
	return false
}

func (x *StringRules) GetIp() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Ip); ok {
		return x.Ip
	}
	return false
}

func (x *StringRules) GetIpv4() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Ipv4); ok {
		return x.Ipv4
	}
	return false
}

func (x *StringRules) GetIpv6() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Ipv6); ok {
		return x.Ipv6
	}
	return false
}

func (x *StringRules) GetUri() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Uri); ok {
		return x.Uri
	}
	return false
}

func (x *StringRules) GetUriRef() bool {
	if x, ok := x.GetWellKnown().(*StringRules_UriRef); ok {
		return x.UriRef
	}
	return false
}

func (x *StringRules) GetAddress() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Address); ok {
		return x.Address
	}
	return false
}

func (x *StringRules) GetUuid() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Uuid); ok {
		return x.Uuid
	}
	return false
}

func (x *StringRules) GetTuuid() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Tuuid); ok {
		return x.Tuuid
	}
	return false
}

func (x *StringRules) GetIpWithPrefixlen() bool {
	if x, ok := x.GetWellKnown().(*StringRules_IpWithPrefixlen); ok {
		return x.IpWithPrefixlen
	}
	return false
}

func (x *StringRules) GetIpv4WithPrefixlen() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Ipv4WithPrefixlen); ok {
		return x.Ipv4WithPrefixlen
	}
	return false
}

func (x *StringRules) GetIpv6WithPrefixlen() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Ipv6WithPrefixlen); ok {
		return x.Ipv6WithPrefixlen
	}
	return false
}

func (x *StringRules) GetIpPrefix() bool {
	if x, ok := x.GetWellKnown().(*StringRules_IpPrefix); ok {
		return x.IpPrefix
	}
	return false
}

func (x *StringRules) GetIpv4Prefix() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Ipv4Prefix); ok {
		return x.Ipv4Prefix
	}
	return false
}

func (x *StringRules) GetIpv6Prefix() bool {
	if x, ok := x.GetWellKnown().(*StringRules_Ipv6Prefix); ok {
		return x.Ipv6Prefix
	}
	return false
}

func (x *StringRules) GetHostAndPort() bool {
	if x, ok := x.GetWellKnown().(*StringRules_HostAndPort); ok {
		return x.HostAndPort
	}
	return false
}

func (x *StringRules) GetWellKnownRegex() KnownRegex {
	if x, ok := x.GetWellKnown().(*StringRules_WellKnownRegex); ok {
		return x.WellKnownRegex
	}
	return KnownRegex_KNOWN_REGEX_UNSPECIFIED
}

func (x *StringRules) GetStrict() bool {
	if x != nil && x.Strict != nil {
		return *x.Strict
	}
	return false
}

func (x *StringRules) GetExample() []string {
	if x != nil {
		return x.Example
	}
	return nil
}

type isStringRules_WellKnown interface {
	isStringRules_WellKnown()
}

type StringRules_Email struct {
	// `email` specifies that the field value must be a valid email address
	// (addr-spec only) as defined by [RFC 5322](https://tools.ietf.org/html/rfc5322#section-3.4.1).
	// If the field value isn't a valid email address, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid email address
	//	  string value = 1 [(buf.validate.field).string.email = true];
	//	}
	//
	// ```
	Email bool `protobuf:"varint,12,opt,name=email,oneof"`
}

type StringRules_Hostname struct {
	// `hostname` specifies that the field value must be a valid
	// hostname as defined by [RFC 1034](https://tools.ietf.org/html/rfc1034#section-3.5). This constraint doesn't support
	// internationalized domain names (IDNs). If the field value isn't a
	// valid hostname, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid hostname
	//	  string value = 1 [(buf.validate.field).string.hostname = true];
	//	}
	//
	// ```
	Hostname bool `protobuf:"varint,13,opt,name=hostname,oneof"`
}

type StringRules_Ip struct {
	// `ip` specifies that the field value must be a valid IP
	// (v4 or v6) address, without surrounding square brackets for IPv6 addresses.
	// If the field value isn't a valid IP address, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IP address
	//	  string value = 1 [(buf.validate.field).string.ip = true];
	//	}
	//
	// ```
	Ip bool `protobuf:"varint,14,opt,name=ip,oneof"`
}

type StringRules_Ipv4 struct {
	// `ipv4` specifies that the field value must be a valid IPv4
	// address. If the field value isn't a valid IPv4 address, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv4 address
	//	  string value = 1 [(buf.validate.field).string.ipv4 = true];
	//	}
	//
	// ```
	Ipv4 bool `protobuf:"varint,15,opt,name=ipv4,oneof"`
}

type StringRules_Ipv6 struct {
	// `ipv6` specifies that the field value must be a valid
	// IPv6 address, without surrounding square brackets. If the field value is
	// not a valid IPv6 address, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv6 address
	//	  string value = 1 [(buf.validate.field).string.ipv6 = true];
	//	}
	//
	// ```
	Ipv6 bool `protobuf:"varint,16,opt,name=ipv6,oneof"`
}

type StringRules_Uri struct {
	// `uri` specifies that the field value must be a valid,
	// absolute URI as defined by [RFC 3986](https://tools.ietf.org/html/rfc3986#section-3). If the field value isn't a valid,
	// absolute URI, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid URI
	//	  string value = 1 [(buf.validate.field).string.uri = true];
	//	}
	//
	// ```
	Uri bool `protobuf:"varint,17,opt,name=uri,oneof"`
}

type StringRules_UriRef struct {
	// `uri_ref` specifies that the field value must be a valid URI
	// as defined by [RFC 3986](https://tools.ietf.org/html/rfc3986#section-3) and may be either relative or absolute. If the
	// field value isn't a valid URI, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid URI
	//	  string value = 1 [(buf.validate.field).string.uri_ref = true];
	//	}
	//
	// ```
	UriRef bool `protobuf:"varint,18,opt,name=uri_ref,json=uriRef,oneof"`
}

type StringRules_Address struct {
	// `address` specifies that the field value must be either a valid hostname
	// as defined by [RFC 1034](https://tools.ietf.org/html/rfc1034#section-3.5)
	// (which doesn't support internationalized domain names or IDNs) or a valid
	// IP (v4 or v6). If the field value isn't a valid hostname or IP, an error
	// message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid hostname, or ip address
	//	  string value = 1 [(buf.validate.field).string.address = true];
	//	}
	//
	// ```
	Address bool `protobuf:"varint,21,opt,name=address,oneof"`
}

type StringRules_Uuid struct {
	// `uuid` specifies that the field value must be a valid UUID as defined by
	// [RFC 4122](https://tools.ietf.org/html/rfc4122#section-4.1.2). If the
	// field value isn't a valid UUID, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid UUID
	//	  string value = 1 [(buf.validate.field).string.uuid = true];
	//	}
	//
	// ```
	Uuid bool `protobuf:"varint,22,opt,name=uuid,oneof"`
}

type StringRules_Tuuid struct {
	// `tuuid` (trimmed UUID) specifies that the field value must be a valid UUID as
	// defined by [RFC 4122](https://tools.ietf.org/html/rfc4122#section-4.1.2) with all dashes
	// omitted. If the field value isn't a valid UUID without dashes, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid trimmed UUID
	//	  string value = 1 [(buf.validate.field).string.tuuid = true];
	//	}
	//
	// ```
	Tuuid bool `protobuf:"varint,33,opt,name=tuuid,oneof"`
}

type StringRules_IpWithPrefixlen struct {
	// `ip_with_prefixlen` specifies that the field value must be a valid IP (v4 or v6)
	// address with prefix length. If the field value isn't a valid IP with prefix
	// length, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IP with prefix length
	//	   string value = 1 [(buf.validate.field).string.ip_with_prefixlen = true];
	//	}
	//
	// ```
	IpWithPrefixlen bool `protobuf:"varint,26,opt,name=ip_with_prefixlen,json=ipWithPrefixlen,oneof"`
}

type StringRules_Ipv4WithPrefixlen struct {
	// `ipv4_with_prefixlen` specifies that the field value must be a valid
	// IPv4 address with prefix.
	// If the field value isn't a valid IPv4 address with prefix length,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv4 address with prefix length
	//	   string value = 1 [(buf.validate.field).string.ipv4_with_prefixlen = true];
	//	}
	//
	// ```
	Ipv4WithPrefixlen bool `protobuf:"varint,27,opt,name=ipv4_with_prefixlen,json=ipv4WithPrefixlen,oneof"`
}

type StringRules_Ipv6WithPrefixlen struct {
	// `ipv6_with_prefixlen` specifies that the field value must be a valid
	// IPv6 address with prefix length.
	// If the field value is not a valid IPv6 address with prefix length,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv6 address prefix length
	//	   string value = 1 [(buf.validate.field).string.ipv6_with_prefixlen = true];
	//	}
	//
	// ```
	Ipv6WithPrefixlen bool `protobuf:"varint,28,opt,name=ipv6_with_prefixlen,json=ipv6WithPrefixlen,oneof"`
}

type StringRules_IpPrefix struct {
	// `ip_prefix` specifies that the field value must be a valid IP (v4 or v6) prefix.
	// If the field value isn't a valid IP prefix, an error message will be
	// generated. The prefix must have all zeros for the masked bits of the prefix (e.g.,
	// `127.0.0.0/16`, not `127.0.0.1/16`).
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IP prefix
	//	   string value = 1 [(buf.validate.field).string.ip_prefix = true];
	//	}
	//
	// ```
	IpPrefix bool `protobuf:"varint,29,opt,name=ip_prefix,json=ipPrefix,oneof"`
}

type StringRules_Ipv4Prefix struct {
	// `ipv4_prefix` specifies that the field value must be a valid IPv4
	// prefix. If the field value isn't a valid IPv4 prefix, an error message
	// will be generated. The prefix must have all zeros for the masked bits of
	// the prefix (e.g., `127.0.0.0/16`, not `127.0.0.1/16`).
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv4 prefix
	//	   string value = 1 [(buf.validate.field).string.ipv4_prefix = true];
	//	}
	//
	// ```
	Ipv4Prefix bool `protobuf:"varint,30,opt,name=ipv4_prefix,json=ipv4Prefix,oneof"`
}

type StringRules_Ipv6Prefix struct {
	// `ipv6_prefix` specifies that the field value must be a valid IPv6 prefix.
	// If the field value is not a valid IPv6 prefix, an error message will be
	// generated. The prefix must have all zeros for the masked bits of the prefix
	// (e.g., `2001:db8::/48`, not `2001:db8::1/48`).
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv6 prefix
	//	   string value = 1 [(buf.validate.field).string.ipv6_prefix = true];
	//	}
	//
	// ```
	Ipv6Prefix bool `protobuf:"varint,31,opt,name=ipv6_prefix,json=ipv6Prefix,oneof"`
}

type StringRules_HostAndPort struct {
	// `host_and_port` specifies the field value must be a valid host and port
	// pair. The host must be a valid hostname or IP address while the port
	// must be in the range of 0-65535, inclusive. IPv6 addresses must be delimited
	// with square brackets (e.g., `[::1]:1234`).
	HostAndPort bool `protobuf:"varint,32,opt,name=host_and_port,json=hostAndPort,oneof"`
}

type StringRules_WellKnownRegex struct {
	// `well_known_regex` specifies a common well-known pattern
	// defined as a regex. If the field value doesn't match the well-known
	// regex, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid HTTP header value
	//	  string value = 1 [(buf.validate.field).string.well_known_regex = KNOWN_REGEX_HTTP_HEADER_VALUE];
	//	}
	//
	// ```
	//
	// #### KnownRegex
	//
	// `well_known_regex` contains some well-known patterns.
	//
	// | Name                          | Number | Description                               |
	// |-------------------------------|--------|-------------------------------------------|
	// | KNOWN_REGEX_UNSPECIFIED       | 0      |                                           |
	// | KNOWN_REGEX_HTTP_HEADER_NAME  | 1      | HTTP header name as defined by [RFC 7230](https://tools.ietf.org/html/rfc7230#section-3.2)  |
	// | KNOWN_REGEX_HTTP_HEADER_VALUE | 2      | HTTP header value as defined by [RFC 7230](https://tools.ietf.org/html/rfc7230#section-3.2.4) |
	WellKnownRegex KnownRegex `protobuf:"varint,24,opt,name=well_known_regex,json=wellKnownRegex,enum=buf.validate.KnownRegex,oneof"`
}

func (*StringRules_Email) isStringRules_WellKnown() {}

func (*StringRules_Hostname) isStringRules_WellKnown() {}

func (*StringRules_Ip) isStringRules_WellKnown() {}

func (*StringRules_Ipv4) isStringRules_WellKnown() {}

func (*StringRules_Ipv6) isStringRules_WellKnown() {}

func (*StringRules_Uri) isStringRules_WellKnown() {}

func (*StringRules_UriRef) isStringRules_WellKnown() {}

func (*StringRules_Address) isStringRules_WellKnown() {}

func (*StringRules_Uuid) isStringRules_WellKnown() {}

func (*StringRules_Tuuid) isStringRules_WellKnown() {}

func (*StringRules_IpWithPrefixlen) isStringRules_WellKnown() {}

func (*StringRules_Ipv4WithPrefixlen) isStringRules_WellKnown() {}

func (*StringRules_Ipv6WithPrefixlen) isStringRules_WellKnown() {}

func (*StringRules_IpPrefix) isStringRules_WellKnown() {}

func (*StringRules_Ipv4Prefix) isStringRules_WellKnown() {}

func (*StringRules_Ipv6Prefix) isStringRules_WellKnown() {}

func (*StringRules_HostAndPort) isStringRules_WellKnown() {}

func (*StringRules_WellKnownRegex) isStringRules_WellKnown() {}

// BytesRules describe the constraints applied to `bytes` values. These rules
// may also be applied to the `google.protobuf.BytesValue` Well-Known-Type.
type BytesRules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified bytes
	// value. If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be "\x01\x02\x03\x04"
	//	  bytes value = 1 [(buf.validate.field).bytes.const = "\x01\x02\x03\x04"];
	//	}
	//
	// ```
	Const []byte `protobuf:"bytes,1,opt,name=const" json:"const,omitempty"`
	// `len` requires the field value to have the specified length in bytes.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value length must be 4 bytes.
	//	  optional bytes value = 1 [(buf.validate.field).bytes.len = 4];
	//	}
	//
	// ```
	Len *uint64 `protobuf:"varint,13,opt,name=len" json:"len,omitempty"`
	// `min_len` requires the field value to have at least the specified minimum
	// length in bytes.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value length must be at least 2 bytes.
	//	  optional bytes value = 1 [(buf.validate.field).bytes.min_len = 2];
	//	}
	//
	// ```
	MinLen *uint64 `protobuf:"varint,2,opt,name=min_len,json=minLen" json:"min_len,omitempty"`
	// `max_len` requires the field value to have at most the specified maximum
	// length in bytes.
	// If the field value exceeds the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be at most 6 bytes.
	//	  optional bytes value = 1 [(buf.validate.field).bytes.max_len = 6];
	//	}
	//
	// ```
	MaxLen *uint64 `protobuf:"varint,3,opt,name=max_len,json=maxLen" json:"max_len,omitempty"`
	// `pattern` requires the field value to match the specified regular
	// expression ([RE2 syntax](https://github.com/google/re2/wiki/Syntax)).
	// The value of the field must be valid UTF-8 or validation will fail with a
	// runtime error.
	// If the field value doesn't match the pattern, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must match regex pattern "^[a-zA-Z0-9]+$".
	//	  optional bytes value = 1 [(buf.validate.field).bytes.pattern = "^[a-zA-Z0-9]+$"];
	//	}
	//
	// ```
	Pattern *string `protobuf:"bytes,4,opt,name=pattern" json:"pattern,omitempty"`
	// `prefix` requires the field value to have the specified bytes at the
	// beginning of the string.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value does not have prefix \x01\x02
	//	  optional bytes value = 1 [(buf.validate.field).bytes.prefix = "\x01\x02"];
	//	}
	//
	// ```
	Prefix []byte `protobuf:"bytes,5,opt,name=prefix" json:"prefix,omitempty"`
	// `suffix` requires the field value to have the specified bytes at the end
	// of the string.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value does not have suffix \x03\x04
	//	  optional bytes value = 1 [(buf.validate.field).bytes.suffix = "\x03\x04"];
	//	}
	//
	// ```
	Suffix []byte `protobuf:"bytes,6,opt,name=suffix" json:"suffix,omitempty"`
	// `contains` requires the field value to have the specified bytes anywhere in
	// the string.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```protobuf
	//
	//	message MyBytes {
	//	  // value does not contain \x02\x03
	//	  optional bytes value = 1 [(buf.validate.field).bytes.contains = "\x02\x03"];
	//	}
	//
	// ```
	Contains []byte `protobuf:"bytes,7,opt,name=contains" json:"contains,omitempty"`
	// `in` requires the field value to be equal to one of the specified
	// values. If the field value doesn't match any of the specified values, an
	// error message is generated.
	//
	// ```protobuf
	//
	//	message MyBytes {
	//	  // value must in ["\x01\x02", "\x02\x03", "\x03\x04"]
	//	  optional bytes value = 1 [(buf.validate.field).bytes.in = {"\x01\x02", "\x02\x03", "\x03\x04"}];
	//	}
	//
	// ```
	In [][]byte `protobuf:"bytes,8,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to be not equal to any of the specified
	// values.
	// If the field value matches any of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must not in ["\x01\x02", "\x02\x03", "\x03\x04"]
	//	  optional bytes value = 1 [(buf.validate.field).bytes.not_in = {"\x01\x02", "\x02\x03", "\x03\x04"}];
	//	}
	//
	// ```
	NotIn [][]byte `protobuf:"bytes,9,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// WellKnown rules provide advanced constraints against common byte
	// patterns
	//
	// Types that are assignable to WellKnown:
	//
	//	*BytesRules_Ip
	//	*BytesRules_Ipv4
	//	*BytesRules_Ipv6
	WellKnown isBytesRules_WellKnown `protobuf_oneof:"well_known"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  bytes value = 1 [
	//	    (buf.validate.field).bytes.example = "\x01\x02",
	//	    (buf.validate.field).bytes.example = "\x02\x03"
	//	  ];
	//	}
	//
	// ```
	Example [][]byte `protobuf:"bytes,14,rep,name=example" json:"example,omitempty"`
}

func (x *BytesRules) Reset() {
	*x = BytesRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BytesRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BytesRules) ProtoMessage() {}

func (x *BytesRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BytesRules.ProtoReflect.Descriptor instead.
func (*BytesRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{19}
}

func (x *BytesRules) GetConst() []byte {
	if x != nil {
		return x.Const
	}
	return nil
}

func (x *BytesRules) GetLen() uint64 {
	if x != nil && x.Len != nil {
		return *x.Len
	}
	return 0
}

func (x *BytesRules) GetMinLen() uint64 {
	if x != nil && x.MinLen != nil {
		return *x.MinLen
	}
	return 0
}

func (x *BytesRules) GetMaxLen() uint64 {
	if x != nil && x.MaxLen != nil {
		return *x.MaxLen
	}
	return 0
}

func (x *BytesRules) GetPattern() string {
	if x != nil && x.Pattern != nil {
		return *x.Pattern
	}
	return ""
}

func (x *BytesRules) GetPrefix() []byte {
	if x != nil {
		return x.Prefix
	}
	return nil
}

func (x *BytesRules) GetSuffix() []byte {
	if x != nil {
		return x.Suffix
	}
	return nil
}

func (x *BytesRules) GetContains() []byte {
	if x != nil {
		return x.Contains
	}
	return nil
}

func (x *BytesRules) GetIn() [][]byte {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *BytesRules) GetNotIn() [][]byte {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (m *BytesRules) GetWellKnown() isBytesRules_WellKnown {
	if m != nil {
		return m.WellKnown
	}
	return nil
}

func (x *BytesRules) GetIp() bool {
	if x, ok := x.GetWellKnown().(*BytesRules_Ip); ok {
		return x.Ip
	}
	return false
}

func (x *BytesRules) GetIpv4() bool {
	if x, ok := x.GetWellKnown().(*BytesRules_Ipv4); ok {
		return x.Ipv4
	}
	return false
}

func (x *BytesRules) GetIpv6() bool {
	if x, ok := x.GetWellKnown().(*BytesRules_Ipv6); ok {
		return x.Ipv6
	}
	return false
}

func (x *BytesRules) GetExample() [][]byte {
	if x != nil {
		return x.Example
	}
	return nil
}

type isBytesRules_WellKnown interface {
	isBytesRules_WellKnown()
}

type BytesRules_Ip struct {
	// `ip` ensures that the field `value` is a valid IP address (v4 or v6) in byte format.
	// If the field value doesn't meet this constraint, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be a valid IP address
	//	  optional bytes value = 1 [(buf.validate.field).bytes.ip = true];
	//	}
	//
	// ```
	Ip bool `protobuf:"varint,10,opt,name=ip,oneof"`
}

type BytesRules_Ipv4 struct {
	// `ipv4` ensures that the field `value` is a valid IPv4 address in byte format.
	// If the field value doesn't meet this constraint, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be a valid IPv4 address
	//	  optional bytes value = 1 [(buf.validate.field).bytes.ipv4 = true];
	//	}
	//
	// ```
	Ipv4 bool `protobuf:"varint,11,opt,name=ipv4,oneof"`
}

type BytesRules_Ipv6 struct {
	// `ipv6` ensures that the field `value` is a valid IPv6 address in byte format.
	// If the field value doesn't meet this constraint, an error message is generated.
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be a valid IPv6 address
	//	  optional bytes value = 1 [(buf.validate.field).bytes.ipv6 = true];
	//	}
	//
	// ```
	Ipv6 bool `protobuf:"varint,12,opt,name=ipv6,oneof"`
}

func (*BytesRules_Ip) isBytesRules_WellKnown() {}

func (*BytesRules_Ipv4) isBytesRules_WellKnown() {}

func (*BytesRules_Ipv6) isBytesRules_WellKnown() {}

// EnumRules describe the constraints applied to `enum` values.
type EnumRules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` requires the field value to exactly match the specified enum value.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must be exactly MY_ENUM_VALUE1.
	//	  MyEnum value = 1 [(buf.validate.field).enum.const = 1];
	//	}
	//
	// ```
	Const *int32 `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// `defined_only` requires the field value to be one of the defined values for
	// this enum, failing on any undefined value.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must be a defined value of MyEnum.
	//	  MyEnum value = 1 [(buf.validate.field).enum.defined_only = true];
	//	}
	//
	// ```
	DefinedOnly *bool `protobuf:"varint,2,opt,name=defined_only,json=definedOnly" json:"defined_only,omitempty"`
	// `in` requires the field value to be equal to one of the
	// specified enum values. If the field value doesn't match any of the
	// specified values, an error message is generated.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must be equal to one of the specified values.
	//	  MyEnum value = 1 [(buf.validate.field).enum = { in: [1, 2]}];
	//	}
	//
	// ```
	In []int32 `protobuf:"varint,3,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to be not equal to any of the
	// specified enum values. If the field value matches one of the specified
	// values, an error message is generated.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must not be equal to any of the specified values.
	//	  MyEnum value = 1 [(buf.validate.field).enum = { not_in: [1, 2]}];
	//	}
	//
	// ```
	NotIn []int32 `protobuf:"varint,4,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	    (buf.validate.field).enum.example = 1,
	//	    (buf.validate.field).enum.example = 2
	//	}
	//
	// ```
	Example []int32 `protobuf:"varint,5,rep,name=example" json:"example,omitempty"`
}

func (x *EnumRules) Reset() {
	*x = EnumRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnumRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumRules) ProtoMessage() {}

func (x *EnumRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumRules.ProtoReflect.Descriptor instead.
func (*EnumRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{20}
}

func (x *EnumRules) GetConst() int32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *EnumRules) GetDefinedOnly() bool {
	if x != nil && x.DefinedOnly != nil {
		return *x.DefinedOnly
	}
	return false
}

func (x *EnumRules) GetIn() []int32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *EnumRules) GetNotIn() []int32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *EnumRules) GetExample() []int32 {
	if x != nil {
		return x.Example
	}
	return nil
}

// RepeatedRules describe the constraints applied to `repeated` values.
type RepeatedRules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `min_items` requires that this field must contain at least the specified
	// minimum number of items.
	//
	// Note that `min_items = 1` is equivalent to setting a field as `required`.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // value must contain at least  2 items
	//	  repeated string value = 1 [(buf.validate.field).repeated.min_items = 2];
	//	}
	//
	// ```
	MinItems *uint64 `protobuf:"varint,1,opt,name=min_items,json=minItems" json:"min_items,omitempty"`
	// `max_items` denotes that this field must not exceed a
	// certain number of items as the upper limit. If the field contains more
	// items than specified, an error message will be generated, requiring the
	// field to maintain no more than the specified number of items.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // value must contain no more than 3 item(s)
	//	  repeated string value = 1 [(buf.validate.field).repeated.max_items = 3];
	//	}
	//
	// ```
	MaxItems *uint64 `protobuf:"varint,2,opt,name=max_items,json=maxItems" json:"max_items,omitempty"`
	// `unique` indicates that all elements in this field must
	// be unique. This constraint is strictly applicable to scalar and enum
	// types, with message types not being supported.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // repeated value must contain unique items
	//	  repeated string value = 1 [(buf.validate.field).repeated.unique = true];
	//	}
	//
	// ```
	Unique *bool `protobuf:"varint,3,opt,name=unique" json:"unique,omitempty"`
	// `items` details the constraints to be applied to each item
	// in the field. Even for repeated message fields, validation is executed
	// against each item unless skip is explicitly specified.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // The items in the field `value` must follow the specified constraints.
	//	  repeated string value = 1 [(buf.validate.field).repeated.items = {
	//	    string: {
	//	      min_len: 3
	//	      max_len: 10
	//	    }
	//	  }];
	//	}
	//
	// ```
	Items *FieldConstraints `protobuf:"bytes,4,opt,name=items" json:"items,omitempty"`
}

func (x *RepeatedRules) Reset() {
	*x = RepeatedRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepeatedRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepeatedRules) ProtoMessage() {}

func (x *RepeatedRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepeatedRules.ProtoReflect.Descriptor instead.
func (*RepeatedRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{21}
}

func (x *RepeatedRules) GetMinItems() uint64 {
	if x != nil && x.MinItems != nil {
		return *x.MinItems
	}
	return 0
}

func (x *RepeatedRules) GetMaxItems() uint64 {
	if x != nil && x.MaxItems != nil {
		return *x.MaxItems
	}
	return 0
}

func (x *RepeatedRules) GetUnique() bool {
	if x != nil && x.Unique != nil {
		return *x.Unique
	}
	return false
}

func (x *RepeatedRules) GetItems() *FieldConstraints {
	if x != nil {
		return x.Items
	}
	return nil
}

// MapRules describe the constraints applied to `map` values.
type MapRules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// Specifies the minimum number of key-value pairs allowed. If the field has
	// fewer key-value pairs than specified, an error message is generated.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The field `value` must have at least 2 key-value pairs.
	//	  map<string, string> value = 1 [(buf.validate.field).map.min_pairs = 2];
	//	}
	//
	// ```
	MinPairs *uint64 `protobuf:"varint,1,opt,name=min_pairs,json=minPairs" json:"min_pairs,omitempty"`
	// Specifies the maximum number of key-value pairs allowed. If the field has
	// more key-value pairs than specified, an error message is generated.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The field `value` must have at most 3 key-value pairs.
	//	  map<string, string> value = 1 [(buf.validate.field).map.max_pairs = 3];
	//	}
	//
	// ```
	MaxPairs *uint64 `protobuf:"varint,2,opt,name=max_pairs,json=maxPairs" json:"max_pairs,omitempty"`
	// Specifies the constraints to be applied to each key in the field.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The keys in the field `value` must follow the specified constraints.
	//	  map<string, string> value = 1 [(buf.validate.field).map.keys = {
	//	    string: {
	//	      min_len: 3
	//	      max_len: 10
	//	    }
	//	  }];
	//	}
	//
	// ```
	Keys *FieldConstraints `protobuf:"bytes,4,opt,name=keys" json:"keys,omitempty"`
	// Specifies the constraints to be applied to the value of each key in the
	// field. Message values will still have their validations evaluated unless
	// skip is specified here.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The values in the field `value` must follow the specified constraints.
	//	  map<string, string> value = 1 [(buf.validate.field).map.values = {
	//	    string: {
	//	      min_len: 5
	//	      max_len: 20
	//	    }
	//	  }];
	//	}
	//
	// ```
	Values *FieldConstraints `protobuf:"bytes,5,opt,name=values" json:"values,omitempty"`
}

func (x *MapRules) Reset() {
	*x = MapRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MapRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapRules) ProtoMessage() {}

func (x *MapRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapRules.ProtoReflect.Descriptor instead.
func (*MapRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{22}
}

func (x *MapRules) GetMinPairs() uint64 {
	if x != nil && x.MinPairs != nil {
		return *x.MinPairs
	}
	return 0
}

func (x *MapRules) GetMaxPairs() uint64 {
	if x != nil && x.MaxPairs != nil {
		return *x.MaxPairs
	}
	return 0
}

func (x *MapRules) GetKeys() *FieldConstraints {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *MapRules) GetValues() *FieldConstraints {
	if x != nil {
		return x.Values
	}
	return nil
}

// AnyRules describe constraints applied exclusively to the `google.protobuf.Any` well-known type.
type AnyRules struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `in` requires the field's `type_url` to be equal to one of the
	// specified values. If it doesn't match any of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyAny {
	//	  //  The `value` field must have a `type_url` equal to one of the specified values.
	//	  google.protobuf.Any value = 1 [(buf.validate.field).any.in = ["type.googleapis.com/MyType1", "type.googleapis.com/MyType2"]];
	//	}
	//
	// ```
	In []string `protobuf:"bytes,2,rep,name=in" json:"in,omitempty"`
	// requires the field's type_url to be not equal to any of the specified values. If it matches any of the specified values, an error message is generated.
	//
	// ```proto
	//
	//	message MyAny {
	//	  // The field `value` must not have a `type_url` equal to any of the specified values.
	//	  google.protobuf.Any value = 1 [(buf.validate.field).any.not_in = ["type.googleapis.com/ForbiddenType1", "type.googleapis.com/ForbiddenType2"]];
	//	}
	//
	// ```
	NotIn []string `protobuf:"bytes,3,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
}

func (x *AnyRules) Reset() {
	*x = AnyRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnyRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnyRules) ProtoMessage() {}

func (x *AnyRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnyRules.ProtoReflect.Descriptor instead.
func (*AnyRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{23}
}

func (x *AnyRules) GetIn() []string {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *AnyRules) GetNotIn() []string {
	if x != nil {
		return x.NotIn
	}
	return nil
}

// DurationRules describe the constraints applied exclusively to the `google.protobuf.Duration` well-known type.
type DurationRules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` dictates that the field must match the specified value of the `google.protobuf.Duration` type exactly.
	// If the field's value deviates from the specified value, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must equal 5s
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.const = "5s"];
	//	}
	//
	// ```
	Const *durationpb.Duration `protobuf:"bytes,2,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*DurationRules_Lt
	//	*DurationRules_Lte
	LessThan isDurationRules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*DurationRules_Gt
	//	*DurationRules_Gte
	GreaterThan isDurationRules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` asserts that the field must be equal to one of the specified values of the `google.protobuf.Duration` type.
	// If the field's value doesn't correspond to any of the specified values,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must be in list [1s, 2s, 3s]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.in = ["1s", "2s", "3s"]];
	//	}
	//
	// ```
	In []*durationpb.Duration `protobuf:"bytes,7,rep,name=in" json:"in,omitempty"`
	// `not_in` denotes that the field must not be equal to
	// any of the specified values of the `google.protobuf.Duration` type.
	// If the field's value matches any of these values, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must not be in list [1s, 2s, 3s]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.not_in = ["1s", "2s", "3s"]];
	//	}
	//
	// ```
	NotIn []*durationpb.Duration `protobuf:"bytes,8,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other constraints. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  google.protobuf.Duration value = 1 [
	//	    (buf.validate.field).duration.example = { seconds: 1 },
	//	    (buf.validate.field).duration.example = { seconds: 2 },
	//	  ];
	//	}
	//
	// ```
	Example []*durationpb.Duration `protobuf:"bytes,9,rep,name=example" json:"example,omitempty"`
}

func (x *DurationRules) Reset() {
	*x = DurationRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DurationRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DurationRules) ProtoMessage() {}

func (x *DurationRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DurationRules.ProtoReflect.Descriptor instead.
func (*DurationRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{24}
}

func (x *DurationRules) GetConst() *durationpb.Duration {
	if x != nil {
		return x.Const
	}
	return nil
}

func (m *DurationRules) GetLessThan() isDurationRules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *DurationRules) GetLt() *durationpb.Duration {
	if x, ok := x.GetLessThan().(*DurationRules_Lt); ok {
		return x.Lt
	}
	return nil
}

func (x *DurationRules) GetLte() *durationpb.Duration {
	if x, ok := x.GetLessThan().(*DurationRules_Lte); ok {
		return x.Lte
	}
	return nil
}

func (m *DurationRules) GetGreaterThan() isDurationRules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *DurationRules) GetGt() *durationpb.Duration {
	if x, ok := x.GetGreaterThan().(*DurationRules_Gt); ok {
		return x.Gt
	}
	return nil
}

func (x *DurationRules) GetGte() *durationpb.Duration {
	if x, ok := x.GetGreaterThan().(*DurationRules_Gte); ok {
		return x.Gte
	}
	return nil
}

func (x *DurationRules) GetIn() []*durationpb.Duration {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *DurationRules) GetNotIn() []*durationpb.Duration {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *DurationRules) GetExample() []*durationpb.Duration {
	if x != nil {
		return x.Example
	}
	return nil
}

type isDurationRules_LessThan interface {
	isDurationRules_LessThan()
}

type DurationRules_Lt struct {
	// `lt` stipulates that the field must be less than the specified value of the `google.protobuf.Duration` type,
	// exclusive. If the field's value is greater than or equal to the specified
	// value, an error message will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must be less than 5s
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = "5s"];
	//	}
	//
	// ```
	Lt *durationpb.Duration `protobuf:"bytes,3,opt,name=lt,oneof"`
}

type DurationRules_Lte struct {
	// `lte` indicates that the field must be less than or equal to the specified
	// value of the `google.protobuf.Duration` type, inclusive. If the field's value is greater than the specified value,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must be less than or equal to 10s
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.lte = "10s"];
	//	}
	//
	// ```
	Lte *durationpb.Duration `protobuf:"bytes,4,opt,name=lte,oneof"`
}

func (*DurationRules_Lt) isDurationRules_LessThan() {}

func (*DurationRules_Lte) isDurationRules_LessThan() {}

type isDurationRules_GreaterThan interface {
	isDurationRules_GreaterThan()
}

type DurationRules_Gt struct {
	// `gt` requires the duration field value to be greater than the specified
	// value (exclusive). If the value of `gt` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // duration must be greater than 5s [duration.gt]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.gt = { seconds: 5 }];
	//
	//	  // duration must be greater than 5s and less than 10s [duration.gt_lt]
	//	  google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gt: { seconds: 5 }, lt: { seconds: 10 } }];
	//
	//	  // duration must be greater than 10s or less than 5s [duration.gt_lt_exclusive]
	//	  google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gt: { seconds: 10 }, lt: { seconds: 5 } }];
	//	}
	//
	// ```
	Gt *durationpb.Duration `protobuf:"bytes,5,opt,name=gt,oneof"`
}

type DurationRules_Gte struct {
	// `gte` requires the duration field value to be greater than or equal to the
	// specified value (exclusive). If the value of `gte` is larger than a
	// specified `lt` or `lte`, the range is reversed, and the field value must
	// be outside the specified range. If the field value doesn't meet the
	// required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	 // duration must be greater than or equal to 5s [duration.gte]
	//	 google.protobuf.Duration value = 1 [(buf.validate.field).duration.gte = { seconds: 5 }];
	//
	//	 // duration must be greater than or equal to 5s and less than 10s [duration.gte_lt]
	//	 google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gte: { seconds: 5 }, lt: { seconds: 10 } }];
	//
	//	 // duration must be greater than or equal to 10s or less than 5s [duration.gte_lt_exclusive]
	//	 google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gte: { seconds: 10 }, lt: { seconds: 5 } }];
	//	}
	//
	// ```
	Gte *durationpb.Duration `protobuf:"bytes,6,opt,name=gte,oneof"`
}

func (*DurationRules_Gt) isDurationRules_GreaterThan() {}

func (*DurationRules_Gte) isDurationRules_GreaterThan() {}

// TimestampRules describe the constraints applied exclusively to the `google.protobuf.Timestamp` well-known type.
type TimestampRules struct {
	state           protoimpl.MessageState
	sizeCache       protoimpl.SizeCache
	unknownFields   protoimpl.UnknownFields
	extensionFields protoimpl.ExtensionFields

	// `const` dictates that this field, of the `google.protobuf.Timestamp` type, must exactly match the specified value. If the field value doesn't correspond to the specified timestamp, an error message will be generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // value must equal 2023-05-03T10:00:00Z
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.const = {seconds: 1727998800}];
	//	}
	//
	// ```
	Const *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=const" json:"const,omitempty"`
	// Types that are assignable to LessThan:
	//
	//	*TimestampRules_Lt
	//	*TimestampRules_Lte
	//	*TimestampRules_LtNow
	LessThan isTimestampRules_LessThan `protobuf_oneof:"less_than"`
	// Types that are assignable to GreaterThan:
	//
	//	*TimestampRules_Gt
	//	*TimestampRules_Gte
	//	*TimestampRules_GtNow
	GreaterThan isTimestampRules_GreaterThan `protobuf_oneof:"greater_than"`
	// `within` specifies that this field, of the `google.protobuf.Timestamp` type, must be within the specified duration of the current time. If the field value isn't within the duration, an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // value must be within 1 hour of now
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.within = {seconds: 3600}];
	//	}
	//
	// ```
	Within  *durationpb.Duration     `protobuf:"bytes,9,opt,name=within" json:"within,omitempty"`
	Example []*timestamppb.Timestamp `protobuf:"bytes,10,rep,name=example" json:"example,omitempty"`
}

func (x *TimestampRules) Reset() {
	*x = TimestampRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimestampRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampRules) ProtoMessage() {}

func (x *TimestampRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampRules.ProtoReflect.Descriptor instead.
func (*TimestampRules) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{25}
}

func (x *TimestampRules) GetConst() *timestamppb.Timestamp {
	if x != nil {
		return x.Const
	}
	return nil
}

func (m *TimestampRules) GetLessThan() isTimestampRules_LessThan {
	if m != nil {
		return m.LessThan
	}
	return nil
}

func (x *TimestampRules) GetLt() *timestamppb.Timestamp {
	if x, ok := x.GetLessThan().(*TimestampRules_Lt); ok {
		return x.Lt
	}
	return nil
}

func (x *TimestampRules) GetLte() *timestamppb.Timestamp {
	if x, ok := x.GetLessThan().(*TimestampRules_Lte); ok {
		return x.Lte
	}
	return nil
}

func (x *TimestampRules) GetLtNow() bool {
	if x, ok := x.GetLessThan().(*TimestampRules_LtNow); ok {
		return x.LtNow
	}
	return false
}

func (m *TimestampRules) GetGreaterThan() isTimestampRules_GreaterThan {
	if m != nil {
		return m.GreaterThan
	}
	return nil
}

func (x *TimestampRules) GetGt() *timestamppb.Timestamp {
	if x, ok := x.GetGreaterThan().(*TimestampRules_Gt); ok {
		return x.Gt
	}
	return nil
}

func (x *TimestampRules) GetGte() *timestamppb.Timestamp {
	if x, ok := x.GetGreaterThan().(*TimestampRules_Gte); ok {
		return x.Gte
	}
	return nil
}

func (x *TimestampRules) GetGtNow() bool {
	if x, ok := x.GetGreaterThan().(*TimestampRules_GtNow); ok {
		return x.GtNow
	}
	return false
}

func (x *TimestampRules) GetWithin() *durationpb.Duration {
	if x != nil {
		return x.Within
	}
	return nil
}

func (x *TimestampRules) GetExample() []*timestamppb.Timestamp {
	if x != nil {
		return x.Example
	}
	return nil
}

type isTimestampRules_LessThan interface {
	isTimestampRules_LessThan()
}

type TimestampRules_Lt struct {
	// requires the duration field value to be less than the specified value (field < value). If the field value doesn't meet the required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // duration must be less than 'P3D' [duration.lt]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = { seconds: 259200 }];
	//	}
	//
	// ```
	Lt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=lt,oneof"`
}

type TimestampRules_Lte struct {
	// requires the timestamp field value to be less than or equal to the specified value (field <= value). If the field value doesn't meet the required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // timestamp must be less than or equal to '2023-05-14T00:00:00Z' [timestamp.lte]
	//	  google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.lte = { seconds: 1678867200 }];
	//	}
	//
	// ```
	Lte *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=lte,oneof"`
}

type TimestampRules_LtNow struct {
	// `lt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be less than the current time. `lt_now` can only be used with the `within` rule.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	 // value must be less than now
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.lt_now = true];
	//	}
	//
	// ```
	LtNow bool `protobuf:"varint,7,opt,name=lt_now,json=ltNow,oneof"`
}

func (*TimestampRules_Lt) isTimestampRules_LessThan() {}

func (*TimestampRules_Lte) isTimestampRules_LessThan() {}

func (*TimestampRules_LtNow) isTimestampRules_LessThan() {}

type isTimestampRules_GreaterThan interface {
	isTimestampRules_GreaterThan()
}

type TimestampRules_Gt struct {
	// `gt` requires the timestamp field value to be greater than the specified
	// value (exclusive). If the value of `gt` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // timestamp must be greater than '2023-01-01T00:00:00Z' [timestamp.gt]
	//	  google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gt = { seconds: 1672444800 }];
	//
	//	  // timestamp must be greater than '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gt_lt]
	//	  google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gt: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];
	//
	//	  // timestamp must be greater than '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gt_lt_exclusive]
	//	  google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gt: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
	//	}
	//
	// ```
	Gt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=gt,oneof"`
}

type TimestampRules_Gte struct {
	// `gte` requires the timestamp field value to be greater than or equal to the
	// specified value (exclusive). If the value of `gte` is larger than a
	// specified `lt` or `lte`, the range is reversed, and the field value
	// must be outside the specified range. If the field value doesn't meet
	// the required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' [timestamp.gte]
	//	  google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gte = { seconds: 1672444800 }];
	//
	//	  // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gte_lt]
	//	  google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gte: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];
	//
	//	  // timestamp must be greater than or equal to '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gte_lt_exclusive]
	//	  google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gte: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
	//	}
	//
	// ```
	Gte *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=gte,oneof"`
}

type TimestampRules_GtNow struct {
	// `gt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be greater than the current time. `gt_now` can only be used with the `within` rule.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // value must be greater than now
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.gt_now = true];
	//	}
	//
	// ```
	GtNow bool `protobuf:"varint,8,opt,name=gt_now,json=gtNow,oneof"`
}

func (*TimestampRules_Gt) isTimestampRules_GreaterThan() {}

func (*TimestampRules_Gte) isTimestampRules_GreaterThan() {}

func (*TimestampRules_GtNow) isTimestampRules_GreaterThan() {}

// `Violations` is a collection of `Violation` messages. This message type is returned by
// protovalidate when a proto message fails to meet the requirements set by the `Constraint` validation rules.
// Each individual violation is represented by a `Violation` message.
type Violations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `violations` is a repeated field that contains all the `Violation` messages corresponding to the violations detected.
	Violations []*Violation `protobuf:"bytes,1,rep,name=violations" json:"violations,omitempty"`
}

func (x *Violations) Reset() {
	*x = Violations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Violations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violations) ProtoMessage() {}

func (x *Violations) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violations.ProtoReflect.Descriptor instead.
func (*Violations) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{26}
}

func (x *Violations) GetViolations() []*Violation {
	if x != nil {
		return x.Violations
	}
	return nil
}

// `Violation` represents a single instance where a validation rule, expressed
// as a `Constraint`, was not met. It provides information about the field that
// caused the violation, the specific constraint that wasn't fulfilled, and a
// human-readable error message.
//
// ```json
//
//	{
//	  "fieldPath": "bar",
//	  "constraintId": "foo.bar",
//	  "message": "bar must be greater than 0"
//	}
//
// ```
type Violation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `field_path` is a machine-readable identifier that points to the specific field that failed the validation.
	// This could be a nested field, in which case the path will include all the parent fields leading to the actual field that caused the violation.
	FieldPath *string `protobuf:"bytes,1,opt,name=field_path,json=fieldPath" json:"field_path,omitempty"`
	// `constraint_id` is the unique identifier of the `Constraint` that was not fulfilled.
	// This is the same `id` that was specified in the `Constraint` message, allowing easy tracing of which rule was violated.
	ConstraintId *string `protobuf:"bytes,2,opt,name=constraint_id,json=constraintId" json:"constraint_id,omitempty"`
	// `message` is a human-readable error message that describes the nature of the violation.
	// This can be the default error message from the violated `Constraint`, or it can be a custom message that gives more context about the violation.
	Message *string `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
	// `for_key` indicates whether the violation was caused by a map key, rather than a value.
	ForKey *bool `protobuf:"varint,4,opt,name=for_key,json=forKey" json:"for_key,omitempty"`
}

func (x *Violation) Reset() {
	*x = Violation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_validate_validate_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Violation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation) ProtoMessage() {}

func (x *Violation) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation.ProtoReflect.Descriptor instead.
func (*Violation) Descriptor() ([]byte, []int) {
	return file_buf_validate_validate_proto_rawDescGZIP(), []int{27}
}

func (x *Violation) GetFieldPath() string {
	if x != nil && x.FieldPath != nil {
		return *x.FieldPath
	}
	return ""
}

func (x *Violation) GetConstraintId() string {
	if x != nil && x.ConstraintId != nil {
		return *x.ConstraintId
	}
	return ""
}

func (x *Violation) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

func (x *Violation) GetForKey() bool {
	if x != nil && x.ForKey != nil {
		return *x.ForKey
	}
	return false
}

var file_buf_validate_validate_proto_extTypes = []protoimpl.ExtensionInfo{
	{
		ExtendedType:  (*descriptorpb.MessageOptions)(nil),
		ExtensionType: (*MessageConstraints)(nil),
		Field:         1159,
		Name:          "buf.validate.message",
		Tag:           "bytes,1159,opt,name=message",
		Filename:      "buf/validate/validate.proto",
	},
	{
		ExtendedType:  (*descriptorpb.OneofOptions)(nil),
		ExtensionType: (*OneofConstraints)(nil),
		Field:         1159,
		Name:          "buf.validate.oneof",
		Tag:           "bytes,1159,opt,name=oneof",
		Filename:      "buf/validate/validate.proto",
	},
	{
		ExtendedType:  (*descriptorpb.FieldOptions)(nil),
		ExtensionType: (*FieldConstraints)(nil),
		Field:         1159,
		Name:          "buf.validate.field",
		Tag:           "bytes,1159,opt,name=field",
		Filename:      "buf/validate/validate.proto",
	},
	{
		ExtendedType:  (*descriptorpb.FieldOptions)(nil),
		ExtensionType: (*PredefinedConstraints)(nil),
		Field:         1160,
		Name:          "buf.validate.predefined",
		Tag:           "bytes,1160,opt,name=predefined",
		Filename:      "buf/validate/validate.proto",
	},
}

// Extension fields to descriptorpb.MessageOptions.
var (
	// Rules specify the validations to be performed on this message. By default,
	// no validation is performed against a message.
	//
	// optional buf.validate.MessageConstraints message = 1159;
	E_Message = &file_buf_validate_validate_proto_extTypes[0]
)

// Extension fields to descriptorpb.OneofOptions.
var (
	// Rules specify the validations to be performed on this oneof. By default,
	// no validation is performed against a oneof.
	//
	// optional buf.validate.OneofConstraints oneof = 1159;
	E_Oneof = &file_buf_validate_validate_proto_extTypes[1]
)

// Extension fields to descriptorpb.FieldOptions.
var (
	// Rules specify the validations to be performed on this field. By default,
	// no validation is performed against a field.
	//
	// optional buf.validate.FieldConstraints field = 1159;
	E_Field = &file_buf_validate_validate_proto_extTypes[2]
	// Specifies predefined rules. When extending a standard constraint message,
	// this adds additional CEL expressions that apply when the extension is used.
	//
	// ```proto
	//
	//	extend buf.validate.Int32Rules {
	//	  bool is_zero [(buf.validate.predefined).cel = {
	//	    id: "int32.is_zero",
	//	    message: "value must be zero",
	//	    expression: "!rule || this == 0",
	//	  }];
	//	}
	//
	//	message Foo {
	//	  int32 reserved = 1 [(buf.validate.field).int32.(is_zero) = true];
	//	}
	//
	// ```
	//
	// optional buf.validate.PredefinedConstraints predefined = 1160;
	E_Predefined = &file_buf_validate_validate_proto_extTypes[3]
)

var File_buf_validate_validate_proto protoreflect.FileDescriptor

var file_buf_validate_validate_proto_rawDesc = []byte{
	0x0a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x62,
	0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x56,
	0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5c, 0x0a, 0x12, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2a, 0x0a, 0x03, 0x63, 0x65, 0x6c, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52,
	0x03, 0x63, 0x65, 0x6c, 0x22, 0x2e, 0x0a, 0x10, 0x4f, 0x6e, 0x65, 0x6f, 0x66, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x22, 0xab, 0x0a, 0x0a, 0x10, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x03, 0x63, 0x65, 0x6c,
	0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x52, 0x03, 0x63, 0x65, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x64, 0x18, 0x19, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x64, 0x12, 0x2c, 0x0a, 0x06, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x18, 0x1b, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x14, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x12,
	0x30, 0x0a, 0x05, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x46, 0x6c,
	0x6f, 0x61, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x05, 0x66, 0x6c, 0x6f, 0x61,
	0x74, 0x12, 0x33, 0x0a, 0x06, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x06,
	0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x12, 0x30, 0x0a, 0x05, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48,
	0x00, 0x52, 0x05, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x12, 0x30, 0x0a, 0x05, 0x69, 0x6e, 0x74, 0x36,
	0x34, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x48, 0x00, 0x52, 0x05, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x12, 0x33, 0x0a, 0x06, 0x75, 0x69,
	0x6e, 0x74, 0x33, 0x32, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x06, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x12,
	0x33, 0x0a, 0x06, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x55,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x06, 0x75, 0x69,
	0x6e, 0x74, 0x36, 0x34, 0x12, 0x33, 0x0a, 0x06, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x2e, 0x53, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48,
	0x00, 0x52, 0x06, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x12, 0x33, 0x0a, 0x06, 0x73, 0x69, 0x6e,
	0x74, 0x36, 0x34, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x06, 0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x12, 0x36,
	0x0a, 0x07, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x46,
	0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x07, 0x66,
	0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x12, 0x36, 0x0a, 0x07, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36,
	0x34, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x46, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x07, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x12, 0x39,
	0x0a, 0x08, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x53, 0x46, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52,
	0x08, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x12, 0x39, 0x0a, 0x08, 0x73, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x36, 0x34, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x46, 0x69, 0x78, 0x65,
	0x64, 0x36, 0x34, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x08, 0x73, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x36, 0x34, 0x12, 0x2d, 0x0a, 0x04, 0x62, 0x6f, 0x6f, 0x6c, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x04, 0x62,
	0x6f, 0x6f, 0x6c, 0x12, 0x33, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00,
	0x52, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x30, 0x0a, 0x05, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x48, 0x00, 0x52, 0x05, 0x62, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x04, 0x65, 0x6e,
	0x75, 0x6d, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x48, 0x00, 0x52, 0x04, 0x65, 0x6e, 0x75, 0x6d, 0x12, 0x39, 0x0a, 0x08, 0x72, 0x65, 0x70,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x70, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x2a, 0x0a, 0x03, 0x6d, 0x61, 0x70, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x4d, 0x61, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x03, 0x6d, 0x61, 0x70,
	0x12, 0x2a, 0x0a, 0x03, 0x61, 0x6e, 0x79, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x41, 0x6e, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x03, 0x61, 0x6e, 0x79, 0x12, 0x39, 0x0a, 0x08,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x08, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x1c, 0x0a, 0x07, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x73, 0x6b, 0x69, 0x70,
	0x70, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0c, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x69,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x22, 0x43, 0x0a, 0x15, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x03, 0x63,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x52, 0x03, 0x63, 0x65, 0x6c, 0x22, 0xea, 0x17, 0x0a, 0x0a, 0x46, 0x6c, 0x6f, 0x61,
	0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x70, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x5a, 0xc2, 0x48, 0x57, 0x0a, 0x55, 0x0a, 0x0b, 0x66, 0x6c,
	0x6f, 0x61, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75,
	0x61, 0x6c, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0xa3, 0x01, 0x0a, 0x02, 0x6c, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x90, 0x01, 0xc2, 0x48, 0x8c, 0x01, 0x0a, 0x89, 0x01, 0x0a,
	0x08, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x6c, 0x74, 0x1a, 0x7d, 0x21, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xb4,
	0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x9f, 0x01, 0xc2,
	0x48, 0x9b, 0x01, 0x0a, 0x98, 0x01, 0x0a, 0x09, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x6c, 0x74,
	0x65, 0x1a, 0x8a, 0x01, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69,
	0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00,
	0x52, 0x03, 0x6c, 0x74, 0x65, 0x12, 0xf3, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x02, 0x42, 0xe0, 0x07, 0xc2, 0x48, 0xdc, 0x07, 0x0a, 0x8d, 0x01, 0x0a, 0x08, 0x66, 0x6c,
	0x6f, 0x61, 0x74, 0x2e, 0x67, 0x74, 0x1a, 0x80, 0x01, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74,
	0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc3, 0x01, 0x0a, 0x0b, 0x66, 0x6c,
	0x6f, 0x61, 0x74, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xb3, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e,
	0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a,
	0xcd, 0x01, 0x0a, 0x15, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x5f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb3, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28,
	0x29, 0x20, 0x7c, 0x7c, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c,
	0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x29, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20,
	0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a,
	0xd3, 0x01, 0x0a, 0x0c, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65,
	0x1a, 0xc2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74,
	0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20,
	0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xdd, 0x01, 0x0a, 0x16, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e,
	0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65,
	0x1a, 0xc2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x29, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0xbf, 0x08, 0x0a, 0x03,
	0x67, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x42, 0xaa, 0x08, 0xc2, 0x48, 0xa6, 0x08,
	0x0a, 0x9b, 0x01, 0x0a, 0x09, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x67, 0x74, 0x65, 0x1a, 0x8d,
	0x01, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61,
	0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xd2,
	0x01, 0x0a, 0x0c, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a,
	0xc1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69,
	0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xdc, 0x01, 0x0a, 0x16, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x67, 0x74,
	0x65, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xc1,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e,
	0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x29, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f,
	0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x0a, 0xe2, 0x01, 0x0a, 0x0d, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x67, 0x74, 0x65,
	0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xd0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20,
	0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29,
	0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20,
	0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xec, 0x01, 0x0a, 0x17, 0x66, 0x6c, 0x6f, 0x61,
	0x74, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x76, 0x65, 0x1a, 0xd0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26,
	0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c,
	0x7c, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20,
	0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x79, 0x0a,
	0x02, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x03, 0x28, 0x02, 0x42, 0x69, 0xc2, 0x48, 0x66, 0x0a, 0x64,
	0x0a, 0x08, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29,
	0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74,
	0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64, 0x79, 0x6e,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d, 0x29, 0x20,
	0x3a, 0x20, 0x27, 0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x7d, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f,
	0x69, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x02, 0x42, 0x66, 0xc2, 0x48, 0x63, 0x0a, 0x61, 0x0a,
	0x0c, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x1a, 0x51, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74,
	0x5f, 0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74,
	0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0x7d, 0x0a, 0x06, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x65, 0xc2, 0x48, 0x62, 0x0a, 0x60, 0x0a, 0x0c,
	0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x1a, 0x50, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x20, 0x3f, 0x20, 0x28, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x69, 0x73, 0x49, 0x6e, 0x66, 0x28, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x65, 0x27, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x06,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x18, 0x09, 0x20, 0x03, 0x28, 0x02, 0x42, 0x1a, 0xc2, 0x48, 0x17, 0x0a, 0x15, 0x0a, 0x0d,
	0x66, 0x6c, 0x6f, 0x61, 0x74, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74,
	0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8,
	0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09, 0x6c, 0x65, 0x73, 0x73, 0x5f,
	0x74, 0x68, 0x61, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x5f,
	0x74, 0x68, 0x61, 0x6e, 0x22, 0xfc, 0x17, 0x0a, 0x0b, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x71, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x42, 0x5b, 0xc2, 0x48, 0x58, 0x0a, 0x56, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75, 0x61,
	0x6c, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0xa4, 0x01, 0x0a, 0x02, 0x6c, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x01, 0x42, 0x91, 0x01, 0xc2, 0x48, 0x8d, 0x01, 0x0a, 0x8a, 0x01, 0x0a, 0x09,
	0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x2e, 0x6c, 0x74, 0x1a, 0x7d, 0x21, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xb5,
	0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0xa0, 0x01, 0xc2,
	0x48, 0x9c, 0x01, 0x0a, 0x99, 0x01, 0x0a, 0x0a, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x2e, 0x6c,
	0x74, 0x65, 0x1a, 0x8a, 0x01, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e,
	0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73,
	0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20,
	0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48,
	0x00, 0x52, 0x03, 0x6c, 0x74, 0x65, 0x12, 0xf8, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x01, 0x42, 0xe5, 0x07, 0xc2, 0x48, 0xe1, 0x07, 0x0a, 0x8e, 0x01, 0x0a, 0x09, 0x64,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x2e, 0x67, 0x74, 0x1a, 0x80, 0x01, 0x21, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc4, 0x01, 0x0a, 0x0c,
	0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xb3, 0x01, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73,
	0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x0a, 0xce, 0x01, 0x0a, 0x16, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x2e, 0x67, 0x74,
	0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb3, 0x01,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73,
	0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x29,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xd4, 0x01, 0x0a, 0x0d, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x2e, 0x67,
	0x74, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xc2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20,
	0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29,
	0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xde, 0x01, 0x0a, 0x17, 0x64,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xc2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20,
	0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29,
	0x20, 0x7c, 0x7c, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c,
	0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61,
	0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x02, 0x67,
	0x74, 0x12, 0xc4, 0x08, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x42,
	0xaf, 0x08, 0xc2, 0x48, 0xab, 0x08, 0x0a, 0x9c, 0x01, 0x0a, 0x0a, 0x64, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x2e, 0x67, 0x74, 0x65, 0x1a, 0x8d, 0x01, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xd3, 0x01, 0x0a, 0x0d, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a, 0xc1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28,
	0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xdd, 0x01, 0x0a, 0x17,
	0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xc1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20,
	0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29,
	0x20, 0x7c, 0x7c, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61,
	0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xe3, 0x01, 0x0a, 0x0e,
	0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xd0,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c,
	0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x0a, 0xed, 0x01, 0x0a, 0x18, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x2e, 0x67, 0x74, 0x65,
	0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xd0,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69,
	0x73, 0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26,
	0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73,
	0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x48, 0x01, 0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x7a, 0x0a, 0x02, 0x69, 0x6e, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x01, 0x42, 0x6a, 0xc2, 0x48, 0x67, 0x0a, 0x65, 0x0a, 0x09, 0x64, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69,
	0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e,
	0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x52, 0x02, 0x69, 0x6e, 0x12, 0x7e, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x01, 0x42, 0x67, 0xc2, 0x48, 0x64, 0x0a, 0x62, 0x0a, 0x0d, 0x64, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x1a, 0x51, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e,
	0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e,
	0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x6e,
	0x6f, 0x74, 0x49, 0x6e, 0x12, 0x7e, 0x0a, 0x06, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x66, 0xc2, 0x48, 0x63, 0x0a, 0x61, 0x0a, 0x0d, 0x64, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x1a, 0x50, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x20, 0x3f, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73,
	0x2e, 0x69, 0x73, 0x4e, 0x61, 0x6e, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x2e, 0x69, 0x73, 0x49, 0x6e, 0x66, 0x28, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x65,
	0x27, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x06, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x65, 0x12, 0x35, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x01, 0x42, 0x1b, 0xc2, 0x48, 0x18, 0x0a, 0x16, 0x0a, 0x0e, 0x64, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72,
	0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07,
	0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74,
	0x68, 0x61, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74,
	0x68, 0x61, 0x6e, 0x22, 0x94, 0x15, 0x0a, 0x0a, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x12, 0x70, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x5a, 0xc2, 0x48, 0x57, 0x0a, 0x55, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x12, 0x8e, 0x01, 0x0a, 0x02, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x7c, 0xc2, 0x48, 0x79, 0x0a, 0x77, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e,
	0x6c, 0x74, 0x1a, 0x6b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48,
	0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xa1, 0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x8c, 0x01, 0xc2, 0x48, 0x88, 0x01, 0x0a, 0x85, 0x01, 0x0a, 0x09, 0x69,
	0x6e, 0x74, 0x33, 0x32, 0x2e, 0x6c, 0x74, 0x65, 0x1a, 0x78, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75,
	0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x48, 0x00, 0x52, 0x03, 0x6c, 0x74, 0x65, 0x12, 0x9b, 0x07, 0x0a, 0x02, 0x67, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x88, 0x07, 0xc2, 0x48, 0x84, 0x07, 0x0a, 0x7a, 0x0a,
	0x08, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x1a, 0x6e, 0x21, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xb3, 0x01, 0x0a, 0x0b, 0x69, 0x6e,
	0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a,
	0xbb, 0x01, 0x0a, 0x15, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x5f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xa1, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc3, 0x01,
	0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xb2,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xcb, 0x01, 0x0a, 0x16, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74,
	0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25,
	0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x48, 0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0xe8, 0x07, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0xd3, 0x07, 0xc2, 0x48, 0xcf, 0x07, 0x0a, 0x88, 0x01, 0x0a,
	0x09, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x1a, 0x7b, 0x21, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc2, 0x01, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x33,
	0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a, 0xb1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61,
	0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xca, 0x01, 0x0a,
	0x16, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xaf, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20,
	0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20,
	0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xd2, 0x01, 0x0a, 0x0d, 0x69, 0x6e,
	0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xc0, 0x01, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64,
	0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71,
	0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xda,
	0x01, 0x0a, 0x17, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65,
	0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xbe, 0x01, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65,
	0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x03, 0x67,
	0x74, 0x65, 0x12, 0x79, 0x0a, 0x02, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x03, 0x28, 0x05, 0x42, 0x69,
	0xc2, 0x48, 0x66, 0x0a, 0x64, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x69, 0x6e, 0x1a,
	0x58, 0x21, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e,
	0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e,
	0x27, 0x5d, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x7d, 0x0a,
	0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x05, 0x42, 0x66, 0xc2,
	0x48, 0x63, 0x0a, 0x61, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x6e, 0x6f, 0x74, 0x5f,
	0x69, 0x6e, 0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e,
	0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0x34, 0x0a, 0x07,
	0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x05, 0x42, 0x1a, 0xc2,
	0x48, 0x17, 0x0a, 0x15, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a,
	0x09, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x22, 0x94, 0x15, 0x0a, 0x0a, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x70, 0x0a, 0x05, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x5a, 0xc2, 0x48, 0x57, 0x0a, 0x55, 0x0a,
	0x0b, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20,
	0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0x8e, 0x01, 0x0a, 0x02,
	0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x7c, 0xc2, 0x48, 0x79, 0x0a, 0x77, 0x0a,
	0x08, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x6c, 0x74, 0x1a, 0x6b, 0x21, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xa1, 0x01, 0x0a,
	0x03, 0x6c, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x8c, 0x01, 0xc2, 0x48, 0x88,
	0x01, 0x0a, 0x85, 0x01, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x6c, 0x74, 0x65, 0x1a,
	0x78, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29,
	0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x03, 0x6c, 0x74, 0x65,
	0x12, 0x9b, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x88, 0x07,
	0xc2, 0x48, 0x84, 0x07, 0x0a, 0x7a, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74,
	0x1a, 0x6e, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29,
	0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x0a, 0xb3, 0x01, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74,
	0x1a, 0xa3, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29,
	0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xbb, 0x01, 0x0a, 0x15, 0x69, 0x6e, 0x74, 0x36, 0x34,
	0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65,
	0x1a, 0xa1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29,
	0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25,
	0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20,
	0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc3, 0x01, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67,
	0x74, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xb2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20,
	0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcb, 0x01, 0x0a, 0x16, 0x69,
	0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0xe8,
	0x07, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0xd3, 0x07, 0xc2,
	0x48, 0xcf, 0x07, 0x0a, 0x88, 0x01, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74,
	0x65, 0x1a, 0x7b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc2,
	0x01, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a,
	0xb1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xca, 0x01, 0x0a, 0x16, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74,
	0x65, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xaf,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20,
	0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x0a, 0xd2, 0x01, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c,
	0x74, 0x65, 0x1a, 0xc0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26,
	0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f,
	0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xda, 0x01, 0x0a, 0x17, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e,
	0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76,
	0x65, 0x1a, 0xbe, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20,
	0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25,
	0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x48, 0x01, 0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x79, 0x0a, 0x02, 0x69, 0x6e, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x03, 0x42, 0x69, 0xc2, 0x48, 0x66, 0x0a, 0x64, 0x0a, 0x08, 0x69, 0x6e,
	0x74, 0x36, 0x34, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69,
	0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e,
	0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x52, 0x02, 0x69, 0x6e, 0x12, 0x7d, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x03, 0x42, 0x66, 0xc2, 0x48, 0x63, 0x0a, 0x61, 0x0a, 0x0c, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e,
	0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f,
	0x74, 0x49, 0x6e, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x03, 0x42, 0x1a, 0xc2, 0x48, 0x17, 0x0a, 0x15, 0x0a, 0x0d, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65,
	0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80,
	0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61,
	0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61,
	0x6e, 0x22, 0xa5, 0x15, 0x0a, 0x0b, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x71, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x42, 0x5b, 0xc2, 0x48, 0x58, 0x0a, 0x56, 0x0a, 0x0c, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x12, 0x8f, 0x01, 0x0a, 0x02, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x42, 0x7d, 0xc2, 0x48, 0x7a, 0x0a, 0x78, 0x0a, 0x09, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32,
	0x2e, 0x6c, 0x74, 0x1a, 0x6b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xa2, 0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0d, 0x42, 0x8d, 0x01, 0xc2, 0x48, 0x89, 0x01, 0x0a, 0x86, 0x01, 0x0a, 0x0a,
	0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x6c, 0x74, 0x65, 0x1a, 0x78, 0x21, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65,
	0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20,
	0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x03, 0x6c, 0x74, 0x65, 0x12, 0xa0, 0x07, 0x0a, 0x02,
	0x67, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x8d, 0x07, 0xc2, 0x48, 0x89, 0x07, 0x0a,
	0x7b, 0x0a, 0x09, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x1a, 0x6e, 0x21, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xb4, 0x01, 0x0a,
	0x0c, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xbc, 0x01, 0x0a, 0x16, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67,
	0x74, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xa1,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20,
	0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x0a, 0xc4, 0x01, 0x0a, 0x0d, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74,
	0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xb2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73,
	0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20,
	0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcc, 0x01, 0x0a, 0x17, 0x75, 0x69,
	0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0xed,
	0x07, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x42, 0xd8, 0x07, 0xc2,
	0x48, 0xd4, 0x07, 0x0a, 0x89, 0x01, 0x0a, 0x0a, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67,
	0x74, 0x65, 0x1a, 0x7b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20,
	0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a,
	0xc3, 0x01, 0x0a, 0x0d, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c,
	0x74, 0x1a, 0xb1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20,
	0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcb, 0x01, 0x0a, 0x17, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32,
	0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76,
	0x65, 0x1a, 0xaf, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26,
	0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20,
	0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xd3, 0x01, 0x0a, 0x0e, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67,
	0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xc0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61,
	0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xdb, 0x01, 0x0a, 0x18, 0x75, 0x69,
	0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xbe, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x7a,
	0x0a, 0x02, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0d, 0x42, 0x6a, 0xc2, 0x48, 0x67, 0x0a,
	0x65, 0x0a, 0x09, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69,
	0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64,
	0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x7e, 0x0a, 0x06, 0x6e, 0x6f,
	0x74, 0x5f, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0d, 0x42, 0x67, 0xc2, 0x48, 0x64, 0x0a,
	0x62, 0x0a, 0x0d, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e,
	0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c,
	0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0x35, 0x0a, 0x07, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0d, 0x42, 0x1b, 0xc2, 0x48, 0x18,
	0x0a, 0x16, 0x0a, 0x0e, 0x75, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09,
	0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x22, 0xa5, 0x15, 0x0a, 0x0b, 0x55, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x71, 0x0a, 0x05, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x42, 0x5b, 0xc2, 0x48, 0x58, 0x0a, 0x56, 0x0a,
	0x0c, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0x8f, 0x01, 0x0a,
	0x02, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x42, 0x7d, 0xc2, 0x48, 0x7a, 0x0a, 0x78,
	0x0a, 0x09, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x6c, 0x74, 0x1a, 0x6b, 0x21, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xa2,
	0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x42, 0x8d, 0x01, 0xc2,
	0x48, 0x89, 0x01, 0x0a, 0x86, 0x01, 0x0a, 0x0a, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x6c,
	0x74, 0x65, 0x1a, 0x78, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x03,
	0x6c, 0x74, 0x65, 0x12, 0xa0, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04,
	0x42, 0x8d, 0x07, 0xc2, 0x48, 0x89, 0x07, 0x0a, 0x7b, 0x0a, 0x09, 0x75, 0x69, 0x6e, 0x74, 0x36,
	0x34, 0x2e, 0x67, 0x74, 0x1a, 0x6e, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x5d, 0x29, 0x20,
	0x3a, 0x20, 0x27, 0x27, 0x0a, 0xb4, 0x01, 0x0a, 0x0c, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e,
	0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26,
	0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xbc, 0x01, 0x0a, 0x16,
	0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xa1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26,
	0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc4, 0x01, 0x0a, 0x0d, 0x75,
	0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xb2, 0x01, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x0a, 0xcc, 0x01, 0x0a, 0x17, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f,
	0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0, 0x01,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x48, 0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0xed, 0x07, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x04, 0x42, 0xd8, 0x07, 0xc2, 0x48, 0xd4, 0x07, 0x0a, 0x89, 0x01, 0x0a, 0x0a,
	0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x1a, 0x7b, 0x21, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc3, 0x01, 0x0a, 0x0d, 0x75, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a, 0xb1, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75,
	0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73,
	0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcb, 0x01,
	0x0a, 0x17, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x5f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xaf, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c,
	0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61,
	0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xd3, 0x01, 0x0a, 0x0e,
	0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xc0,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c,
	0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x0a, 0xdb, 0x01, 0x0a, 0x18, 0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65,
	0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xbe,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f,
	0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65,
	0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48,
	0x01, 0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x7a, 0x0a, 0x02, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x04, 0x42, 0x6a, 0xc2, 0x48, 0x67, 0x0a, 0x65, 0x0a, 0x09, 0x75, 0x69, 0x6e, 0x74, 0x36,
	0x34, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20,
	0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d,
	0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x02,
	0x69, 0x6e, 0x12, 0x7e, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x04, 0x42, 0x67, 0xc2, 0x48, 0x64, 0x0a, 0x62, 0x0a, 0x0d, 0x75, 0x69, 0x6e, 0x74, 0x36,
	0x34, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69,
	0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f,
	0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f, 0x74,
	0x49, 0x6e, 0x12, 0x35, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x04, 0x42, 0x1b, 0xc2, 0x48, 0x18, 0x0a, 0x16, 0x0a, 0x0e, 0x75, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65,
	0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80,
	0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61,
	0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61,
	0x6e, 0x22, 0xa5, 0x15, 0x0a, 0x0b, 0x53, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x71, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x11,
	0x42, 0x5b, 0xc2, 0x48, 0x58, 0x0a, 0x56, 0x0a, 0x0c, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x12, 0x8f, 0x01, 0x0a, 0x02, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x11, 0x42, 0x7d, 0xc2, 0x48, 0x7a, 0x0a, 0x78, 0x0a, 0x09, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32,
	0x2e, 0x6c, 0x74, 0x1a, 0x6b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xa2, 0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x11, 0x42, 0x8d, 0x01, 0xc2, 0x48, 0x89, 0x01, 0x0a, 0x86, 0x01, 0x0a, 0x0a,
	0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x6c, 0x74, 0x65, 0x1a, 0x78, 0x21, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65,
	0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20,
	0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x03, 0x6c, 0x74, 0x65, 0x12, 0xa0, 0x07, 0x0a, 0x02,
	0x67, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x11, 0x42, 0x8d, 0x07, 0xc2, 0x48, 0x89, 0x07, 0x0a,
	0x7b, 0x0a, 0x09, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x1a, 0x6e, 0x21, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xb4, 0x01, 0x0a,
	0x0c, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xbc, 0x01, 0x0a, 0x16, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67,
	0x74, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xa1,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20,
	0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x0a, 0xc4, 0x01, 0x0a, 0x0d, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74,
	0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xb2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73,
	0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20,
	0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcc, 0x01, 0x0a, 0x17, 0x73, 0x69,
	0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0xed,
	0x07, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x11, 0x42, 0xd8, 0x07, 0xc2,
	0x48, 0xd4, 0x07, 0x0a, 0x89, 0x01, 0x0a, 0x0a, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67,
	0x74, 0x65, 0x1a, 0x7b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20,
	0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a,
	0xc3, 0x01, 0x0a, 0x0d, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c,
	0x74, 0x1a, 0xb1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20,
	0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcb, 0x01, 0x0a, 0x17, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32,
	0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76,
	0x65, 0x1a, 0xaf, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26,
	0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20,
	0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xd3, 0x01, 0x0a, 0x0e, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67,
	0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xc0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61,
	0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xdb, 0x01, 0x0a, 0x18, 0x73, 0x69,
	0x6e, 0x74, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xbe, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x7a,
	0x0a, 0x02, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x03, 0x28, 0x11, 0x42, 0x6a, 0xc2, 0x48, 0x67, 0x0a,
	0x65, 0x0a, 0x09, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69,
	0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64,
	0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x7e, 0x0a, 0x06, 0x6e, 0x6f,
	0x74, 0x5f, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x11, 0x42, 0x67, 0xc2, 0x48, 0x64, 0x0a,
	0x62, 0x0a, 0x0d, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e,
	0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c,
	0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0x35, 0x0a, 0x07, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x11, 0x42, 0x1b, 0xc2, 0x48, 0x18,
	0x0a, 0x16, 0x0a, 0x0e, 0x73, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09,
	0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x22, 0xa5, 0x15, 0x0a, 0x0b, 0x53, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x71, 0x0a, 0x05, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x12, 0x42, 0x5b, 0xc2, 0x48, 0x58, 0x0a, 0x56, 0x0a,
	0x0c, 0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0x8f, 0x01, 0x0a,
	0x02, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x12, 0x42, 0x7d, 0xc2, 0x48, 0x7a, 0x0a, 0x78,
	0x0a, 0x09, 0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x6c, 0x74, 0x1a, 0x6b, 0x21, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xa2,
	0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x12, 0x42, 0x8d, 0x01, 0xc2,
	0x48, 0x89, 0x01, 0x0a, 0x86, 0x01, 0x0a, 0x0a, 0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x6c,
	0x74, 0x65, 0x1a, 0x78, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x03,
	0x6c, 0x74, 0x65, 0x12, 0xa0, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x12,
	0x42, 0x8d, 0x07, 0xc2, 0x48, 0x89, 0x07, 0x0a, 0x7b, 0x0a, 0x09, 0x73, 0x69, 0x6e, 0x74, 0x36,
	0x34, 0x2e, 0x67, 0x74, 0x1a, 0x6e, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x5d, 0x29, 0x20,
	0x3a, 0x20, 0x27, 0x27, 0x0a, 0xb4, 0x01, 0x0a, 0x0c, 0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e,
	0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26,
	0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xbc, 0x01, 0x0a, 0x16,
	0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xa1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26,
	0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc4, 0x01, 0x0a, 0x0d, 0x73,
	0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xb2, 0x01, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x0a, 0xcc, 0x01, 0x0a, 0x17, 0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f,
	0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0, 0x01,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x48, 0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0xed, 0x07, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x12, 0x42, 0xd8, 0x07, 0xc2, 0x48, 0xd4, 0x07, 0x0a, 0x89, 0x01, 0x0a, 0x0a,
	0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x1a, 0x7b, 0x21, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc3, 0x01, 0x0a, 0x0d, 0x73, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a, 0xb1, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75,
	0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73,
	0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcb, 0x01,
	0x0a, 0x17, 0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x5f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xaf, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c,
	0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61,
	0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xd3, 0x01, 0x0a, 0x0e,
	0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xc0,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c,
	0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x0a, 0xdb, 0x01, 0x0a, 0x18, 0x73, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65,
	0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xbe,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f,
	0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65,
	0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48,
	0x01, 0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x7a, 0x0a, 0x02, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x12, 0x42, 0x6a, 0xc2, 0x48, 0x67, 0x0a, 0x65, 0x0a, 0x09, 0x73, 0x69, 0x6e, 0x74, 0x36,
	0x34, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20,
	0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d,
	0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x02,
	0x69, 0x6e, 0x12, 0x7e, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x12, 0x42, 0x67, 0xc2, 0x48, 0x64, 0x0a, 0x62, 0x0a, 0x0d, 0x73, 0x69, 0x6e, 0x74, 0x36,
	0x34, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69,
	0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f,
	0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f, 0x74,
	0x49, 0x6e, 0x12, 0x35, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x12, 0x42, 0x1b, 0xc2, 0x48, 0x18, 0x0a, 0x16, 0x0a, 0x0e, 0x73, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65,
	0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80,
	0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61,
	0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61,
	0x6e, 0x22, 0xb6, 0x15, 0x0a, 0x0c, 0x46, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x12, 0x72, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x07, 0x42, 0x5c, 0xc2, 0x48, 0x59, 0x0a, 0x57, 0x0a, 0x0d, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33,
	0x32, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f, 0x20, 0x27,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52,
	0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0x90, 0x01, 0x0a, 0x02, 0x6c, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x07, 0x42, 0x7e, 0xc2, 0x48, 0x7b, 0x0a, 0x79, 0x0a, 0x0a, 0x66, 0x69, 0x78, 0x65,
	0x64, 0x33, 0x32, 0x2e, 0x6c, 0x74, 0x1a, 0x6b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x3f, 0x20, 0x27,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xa3, 0x01, 0x0a, 0x03, 0x6c, 0x74,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x07, 0x42, 0x8e, 0x01, 0xc2, 0x48, 0x8a, 0x01, 0x0a, 0x87,
	0x01, 0x0a, 0x0b, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x6c, 0x74, 0x65, 0x1a, 0x78,
	0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x03, 0x6c, 0x74, 0x65, 0x12,
	0xa5, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x07, 0x42, 0x92, 0x07, 0xc2,
	0x48, 0x8e, 0x07, 0x0a, 0x7c, 0x0a, 0x0a, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67,
	0x74, 0x1a, 0x6e, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x0a, 0xb5, 0x01, 0x0a, 0x0d, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74,
	0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20,
	0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xbd, 0x01, 0x0a, 0x17, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xa1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc5, 0x01, 0x0a, 0x0e, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xb2, 0x01, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x0a, 0xcd, 0x01, 0x0a, 0x18, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74,
	0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25,
	0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x48, 0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0xf2, 0x07, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x07, 0x42, 0xdd, 0x07, 0xc2, 0x48, 0xd9, 0x07, 0x0a, 0x8a, 0x01, 0x0a,
	0x0b, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x1a, 0x7b, 0x21, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc4, 0x01, 0x0a, 0x0e, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a, 0xb1, 0x01, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x0a, 0xcc, 0x01, 0x0a, 0x18, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65,
	0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xaf, 0x01,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c,
	0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a,
	0xd4, 0x01, 0x0a, 0x0f, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f,
	0x6c, 0x74, 0x65, 0x1a, 0xc0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xdc, 0x01, 0x0a, 0x19, 0x66, 0x69, 0x78, 0x65, 0x64,
	0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x76, 0x65, 0x1a, 0xbe, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x7b, 0x0a, 0x02,
	0x69, 0x6e, 0x18, 0x06, 0x20, 0x03, 0x28, 0x07, 0x42, 0x6b, 0xc2, 0x48, 0x68, 0x0a, 0x66, 0x0a,
	0x0a, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73,
	0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64, 0x79,
	0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x7f, 0x0a, 0x06, 0x6e, 0x6f, 0x74,
	0x5f, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x07, 0x42, 0x68, 0xc2, 0x48, 0x65, 0x0a, 0x63,
	0x0a, 0x0e, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e,
	0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c,
	0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0x36, 0x0a, 0x07, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x07, 0x42, 0x1c, 0xc2, 0x48, 0x19,
	0x0a, 0x17, 0x0a, 0x0f, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a,
	0x09, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x22, 0xb6, 0x15, 0x0a, 0x0c, 0x46,
	0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x72, 0x0a, 0x05, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x06, 0x42, 0x5c, 0xc2, 0x48, 0x59, 0x0a,
	0x57, 0x0a, 0x0d, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74,
	0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12,
	0x90, 0x01, 0x0a, 0x02, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x06, 0x42, 0x7e, 0xc2, 0x48,
	0x7b, 0x0a, 0x79, 0x0a, 0x0a, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x6c, 0x74, 0x1a,
	0x6b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29,
	0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02,
	0x6c, 0x74, 0x12, 0xa3, 0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x06,
	0x42, 0x8e, 0x01, 0xc2, 0x48, 0x8a, 0x01, 0x0a, 0x87, 0x01, 0x0a, 0x0b, 0x66, 0x69, 0x78, 0x65,
	0x64, 0x36, 0x34, 0x2e, 0x6c, 0x74, 0x65, 0x1a, 0x78, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c,
	0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61,
	0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x48, 0x00, 0x52, 0x03, 0x6c, 0x74, 0x65, 0x12, 0xa5, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x06, 0x42, 0x92, 0x07, 0xc2, 0x48, 0x8e, 0x07, 0x0a, 0x7c, 0x0a, 0x0a,
	0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x1a, 0x6e, 0x21, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xb5, 0x01, 0x0a, 0x0d, 0x66,
	0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x0a, 0xbd, 0x01, 0x0a, 0x17, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67,
	0x74, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xa1,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20,
	0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x0a, 0xc5, 0x01, 0x0a, 0x0e, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67,
	0x74, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xb2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20,
	0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcd, 0x01, 0x0a, 0x18, 0x66,
	0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x02, 0x67, 0x74,
	0x12, 0xf2, 0x07, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x06, 0x42, 0xdd,
	0x07, 0xc2, 0x48, 0xd9, 0x07, 0x0a, 0x8a, 0x01, 0x0a, 0x0b, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36,
	0x34, 0x2e, 0x67, 0x74, 0x65, 0x1a, 0x7b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75,
	0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x0a, 0xc4, 0x01, 0x0a, 0x0e, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67,
	0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a, 0xb1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcc, 0x01, 0x0a, 0x18, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xaf, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xd4, 0x01, 0x0a, 0x0f, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xc0, 0x01, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e,
	0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65,
	0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a,
	0xdc, 0x01, 0x0a, 0x19, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f,
	0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xbe, 0x01,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72,
	0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71,
	0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01,
	0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x7b, 0x0a, 0x02, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x06, 0x42, 0x6b, 0xc2, 0x48, 0x68, 0x0a, 0x66, 0x0a, 0x0a, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36,
	0x34, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20,
	0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d,
	0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x02,
	0x69, 0x6e, 0x12, 0x7f, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x06, 0x42, 0x68, 0xc2, 0x48, 0x65, 0x0a, 0x63, 0x0a, 0x0e, 0x66, 0x69, 0x78, 0x65, 0x64,
	0x36, 0x34, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e,
	0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f,
	0x74, 0x49, 0x6e, 0x12, 0x36, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x06, 0x42, 0x1c, 0xc2, 0x48, 0x19, 0x0a, 0x17, 0x0a, 0x0f, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x36, 0x34, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72,
	0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07,
	0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74,
	0x68, 0x61, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74,
	0x68, 0x61, 0x6e, 0x22, 0xc8, 0x15, 0x0a, 0x0d, 0x53, 0x46, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x73, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0f, 0x42, 0x5d, 0xc2, 0x48, 0x5a, 0x0a, 0x58, 0x0a, 0x0e, 0x73, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74,
	0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65,
	0x71, 0x75, 0x61, 0x6c, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0x91, 0x01, 0x0a, 0x02, 0x6c,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0f, 0x42, 0x7f, 0xc2, 0x48, 0x7c, 0x0a, 0x7a, 0x0a, 0x0b,
	0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x6c, 0x74, 0x1a, 0x6b, 0x21, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xa4,
	0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0f, 0x42, 0x8f, 0x01, 0xc2,
	0x48, 0x8b, 0x01, 0x0a, 0x88, 0x01, 0x0a, 0x0c, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32,
	0x2e, 0x6c, 0x74, 0x65, 0x1a, 0x78, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00,
	0x52, 0x03, 0x6c, 0x74, 0x65, 0x12, 0xaa, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0f, 0x42, 0x97, 0x07, 0xc2, 0x48, 0x93, 0x07, 0x0a, 0x7d, 0x0a, 0x0b, 0x73, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x1a, 0x6e, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xb6, 0x01, 0x0a, 0x0e, 0x73, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e,
	0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x0a, 0xbe, 0x01, 0x0a, 0x18, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67,
	0x74, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xa1,
	0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20,
	0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x0a, 0xc6, 0x01, 0x0a, 0x0f, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e,
	0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xb2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c,
	0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61,
	0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xce, 0x01, 0x0a, 0x19,
	0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x5f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20,
	0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75,
	0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x02,
	0x67, 0x74, 0x12, 0xf7, 0x07, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0f,
	0x42, 0xe2, 0x07, 0xc2, 0x48, 0xde, 0x07, 0x0a, 0x8b, 0x01, 0x0a, 0x0c, 0x73, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x1a, 0x7b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc5, 0x01, 0x0a, 0x0f, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64,
	0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a, 0xb1, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75,
	0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73,
	0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcd, 0x01,
	0x0a, 0x19, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c,
	0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xaf, 0x01, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71,
	0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73,
	0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xd5, 0x01,
	0x0a, 0x10, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c,
	0x74, 0x65, 0x1a, 0xc0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26,
	0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f,
	0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xdd, 0x01, 0x0a, 0x1a, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64,
	0x33, 0x32, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x76, 0x65, 0x1a, 0xbe, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x7c, 0x0a, 0x02,
	0x69, 0x6e, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0f, 0x42, 0x6c, 0xc2, 0x48, 0x69, 0x0a, 0x67, 0x0a,
	0x0b, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69,
	0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64,
	0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x80, 0x01, 0x0a, 0x06, 0x6e,
	0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0f, 0x42, 0x69, 0xc2, 0x48, 0x66,
	0x0a, 0x64, 0x0a, 0x0f, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e, 0x6e, 0x6f, 0x74,
	0x5f, 0x69, 0x6e, 0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69,
	0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0x37, 0x0a,
	0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0f, 0x42, 0x1d,
	0xc2, 0x48, 0x1a, 0x0a, 0x18, 0x0a, 0x10, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x33, 0x32, 0x2e,
	0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80,
	0x02, 0x42, 0x0b, 0x0a, 0x09, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x42, 0x0e,
	0x0a, 0x0c, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x22, 0xc8,
	0x15, 0x0a, 0x0d, 0x53, 0x46, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x12, 0x73, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x10, 0x42,
	0x5d, 0xc2, 0x48, 0x5a, 0x0a, 0x58, 0x0a, 0x0e, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0x91, 0x01, 0x0a, 0x02, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x10, 0x42, 0x7f, 0xc2, 0x48, 0x7c, 0x0a, 0x7a, 0x0a, 0x0b, 0x73, 0x66, 0x69, 0x78, 0x65,
	0x64, 0x36, 0x34, 0x2e, 0x6c, 0x74, 0x1a, 0x6b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x3f, 0x20, 0x27,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xa4, 0x01, 0x0a, 0x03, 0x6c, 0x74,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x10, 0x42, 0x8f, 0x01, 0xc2, 0x48, 0x8b, 0x01, 0x0a, 0x88,
	0x01, 0x0a, 0x0c, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x6c, 0x74, 0x65, 0x1a,
	0x78, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29,
	0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x03, 0x6c, 0x74, 0x65,
	0x12, 0xaa, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x10, 0x42, 0x97, 0x07,
	0xc2, 0x48, 0x93, 0x07, 0x0a, 0x7d, 0x0a, 0x0b, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34,
	0x2e, 0x67, 0x74, 0x1a, 0x6e, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xb6, 0x01, 0x0a, 0x0e, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34,
	0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73,
	0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xbe, 0x01, 0x0a,
	0x18, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x5f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xa1, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc6, 0x01,
	0x0a, 0x0f, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74,
	0x65, 0x1a, 0xb2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20,
	0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xce, 0x01, 0x0a, 0x19, 0x73, 0x66, 0x69, 0x78, 0x65,
	0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26,
	0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f,
	0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0xf7, 0x07,
	0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x10, 0x42, 0xe2, 0x07, 0xc2, 0x48,
	0xde, 0x07, 0x0a, 0x8b, 0x01, 0x0a, 0x0c, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e,
	0x67, 0x74, 0x65, 0x1a, 0x7b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x0a, 0xc5, 0x01, 0x0a, 0x0f, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74,
	0x65, 0x5f, 0x6c, 0x74, 0x1a, 0xb1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26,
	0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f,
	0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcd, 0x01, 0x0a, 0x19, 0x73, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xaf, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xd5, 0x01, 0x0a, 0x10, 0x73, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xc0, 0x01,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x0a, 0xdd, 0x01, 0x0a, 0x1a, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x67, 0x74,
	0x65, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a,
	0xbe, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29,
	0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26,
	0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20,
	0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x48, 0x01, 0x52, 0x03, 0x67, 0x74, 0x65, 0x12, 0x7c, 0x0a, 0x02, 0x69, 0x6e, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x10, 0x42, 0x6c, 0xc2, 0x48, 0x69, 0x0a, 0x67, 0x0a, 0x0b, 0x73, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x36, 0x34, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69,
	0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x80, 0x01, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x10, 0x42, 0x69, 0xc2, 0x48, 0x66, 0x0a, 0x64, 0x0a, 0x0f, 0x73,
	0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x1a, 0x51,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f,
	0x74, 0x5f, 0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73,
	0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0x37, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x03, 0x28, 0x10, 0x42, 0x1d, 0xc2, 0x48, 0x1a, 0x0a, 0x18,
	0x0a, 0x10, 0x73, 0x66, 0x69, 0x78, 0x65, 0x64, 0x36, 0x34, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09,
	0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x22, 0xbc, 0x01, 0x0a, 0x09, 0x42, 0x6f,
	0x6f, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x6f, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x59, 0xc2, 0x48, 0x56, 0x0a, 0x54, 0x0a, 0x0a, 0x62,
	0x6f, 0x6f, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75,
	0x61, 0x6c, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x08, 0x42, 0x19, 0xc2, 0x48, 0x16, 0x0a, 0x14,
	0x0a, 0x0c, 0x62, 0x6f, 0x6f, 0x6c, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x04,
	0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2a, 0x09, 0x08,
	0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x22, 0xa1, 0x39, 0x0a, 0x0b, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x73, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x5d, 0xc2, 0x48, 0x5a, 0x0a, 0x58, 0x0a, 0x0c,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x48, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x60, 0x25, 0x73, 0x60, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0x83, 0x01,
	0x0a, 0x03, 0x6c, 0x65, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x04, 0x42, 0x71, 0xc2, 0x48, 0x6e,
	0x0a, 0x6c, 0x0a, 0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x6c, 0x65, 0x6e, 0x1a, 0x5e,
	0x75, 0x69, 0x6e, 0x74, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29,
	0x29, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x65, 0x6e, 0x20, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x25, 0x73, 0x20, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63,
	0x74, 0x65, 0x72, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x65, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x03,
	0x6c, 0x65, 0x6e, 0x12, 0xa1, 0x01, 0x0a, 0x07, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x42, 0x87, 0x01, 0xc2, 0x48, 0x83, 0x01, 0x0a, 0x80, 0x01, 0x0a,
	0x0e, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x1a,
	0x6e, 0x75, 0x69, 0x6e, 0x74, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28,
	0x29, 0x29, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x6c,
	0x65, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x74, 0x20, 0x6c, 0x65,
	0x61, 0x73, 0x74, 0x20, 0x25, 0x73, 0x20, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52,
	0x06, 0x6d, 0x69, 0x6e, 0x4c, 0x65, 0x6e, 0x12, 0x9f, 0x01, 0x0a, 0x07, 0x6d, 0x61, 0x78, 0x5f,
	0x6c, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x42, 0x85, 0x01, 0xc2, 0x48, 0x81, 0x01,
	0x0a, 0x7f, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x6c,
	0x65, 0x6e, 0x1a, 0x6d, 0x75, 0x69, 0x6e, 0x74, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69,
	0x7a, 0x65, 0x28, 0x29, 0x29, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x61,
	0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x74,
	0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x25, 0x73, 0x20, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
	0x65, 0x72, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x52, 0x06, 0x6d, 0x61, 0x78, 0x4c, 0x65, 0x6e, 0x12, 0xa5, 0x01, 0x0a, 0x09, 0x6c, 0x65,
	0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x04, 0x42, 0x87, 0x01,
	0xc2, 0x48, 0x83, 0x01, 0x0a, 0x80, 0x01, 0x0a, 0x10, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x6c, 0x65, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x6c, 0x75, 0x69, 0x6e, 0x74, 0x28,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x28, 0x74, 0x68, 0x69, 0x73, 0x29, 0x2e, 0x73, 0x69, 0x7a, 0x65,
	0x28, 0x29, 0x29, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x65, 0x6e,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x25,
	0x73, 0x20, 0x62, 0x79, 0x74, 0x65, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x65, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x08, 0x6c, 0x65, 0x6e, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0xad, 0x01, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x04, 0x42, 0x8f, 0x01, 0xc2, 0x48, 0x8b, 0x01, 0x0a, 0x88, 0x01, 0x0a,
	0x10, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x1a, 0x74, 0x75, 0x69, 0x6e, 0x74, 0x28, 0x62, 0x79, 0x74, 0x65, 0x73, 0x28, 0x74, 0x68,
	0x69, 0x73, 0x29, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x29, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x20, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x74, 0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x25,
	0x73, 0x20, 0x62, 0x79, 0x74, 0x65, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0xac, 0x01, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x04, 0x42, 0x8e, 0x01, 0xc2, 0x48, 0x8a, 0x01, 0x0a, 0x87, 0x01, 0x0a,
	0x10, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x1a, 0x73, 0x75, 0x69, 0x6e, 0x74, 0x28, 0x62, 0x79, 0x74, 0x65, 0x73, 0x28, 0x74, 0x68,
	0x69, 0x73, 0x29, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x29, 0x20, 0x3e, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x20, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x74, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x25, 0x73,
	0x20, 0x62, 0x79, 0x74, 0x65, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x96, 0x01, 0x0a, 0x07, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x7c, 0xc2, 0x48, 0x79, 0x0a, 0x77, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x2e, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x1a, 0x65, 0x21, 0x74, 0x68, 0x69, 0x73,
	0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x70,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x20,
	0x72, 0x65, 0x67, 0x65, 0x78, 0x20, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x20, 0x60, 0x25,
	0x73, 0x60, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x52, 0x07, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x8c, 0x01, 0x0a, 0x06, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x74, 0xc2, 0x48, 0x71, 0x0a,
	0x6f, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x1a, 0x5e, 0x21, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x57, 0x69,
	0x74, 0x68, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x29,
	0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e,
	0x6f, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x60,
	0x25, 0x73, 0x60, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27,
	0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x8a, 0x01, 0x0a, 0x06, 0x73, 0x75, 0x66,
	0x66, 0x69, 0x78, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x72, 0xc2, 0x48, 0x6f, 0x0a, 0x6d,
	0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x1a,
	0x5c, 0x21, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x65, 0x6e, 0x64, 0x73, 0x57, 0x69, 0x74, 0x68, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x29, 0x20, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20,
	0x68, 0x61, 0x76, 0x65, 0x20, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x20, 0x60, 0x25, 0x73, 0x60,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x06, 0x73,
	0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x9a, 0x01, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x7e, 0xc2, 0x48, 0x7b, 0x0a, 0x79, 0x0a,
	0x0f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73,
	0x1a, 0x66, 0x21, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x29,
	0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e,
	0x6f, 0x74, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x20, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x20, 0x60, 0x25, 0x73, 0x60, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x73, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x42, 0x81, 0x01, 0xc2, 0x48, 0x7e, 0x0a,
	0x7c, 0x0a, 0x13, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x1a, 0x65, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x20, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x20, 0x60, 0x25, 0x73, 0x60, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x0b, 0x6e,
	0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x7a, 0x0a, 0x02, 0x69, 0x6e,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x42, 0x6a, 0xc2, 0x48, 0x67, 0x0a, 0x65, 0x0a, 0x09, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x6e, 0x1a, 0x58, 0x21, 0x28, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27,
	0x69, 0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64, 0x79, 0x6e, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x7e, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e,
	0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x67, 0xc2, 0x48, 0x64, 0x0a, 0x62, 0x0a, 0x0d, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x1a, 0x51, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f,
	0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52,
	0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0xe6, 0x01, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0xcd, 0x01, 0xc2, 0x48, 0xc9, 0x01, 0x0a, 0x61, 0x0a,
	0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x23, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x20, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x1a, 0x2c, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c,
	0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x28, 0x29,
	0x0a, 0x64, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x32, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73,
	0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73,
	0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x1a, 0x21, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12,
	0xf1, 0x01, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x08, 0x42, 0xd2, 0x01, 0xc2, 0x48, 0xce, 0x01, 0x0a, 0x65, 0x0a, 0x0f, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x20, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x32, 0x21, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x28, 0x29,
	0x0a, 0x65, 0x0a, 0x15, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x6e,
	0x61, 0x6d, 0x65, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x2d, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68,
	0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20,
	0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x1d, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xcb, 0x01, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08,
	0x42, 0xb8, 0x01, 0xc2, 0x48, 0xb4, 0x01, 0x0a, 0x55, 0x0a, 0x09, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x2e, 0x69, 0x70, 0x12, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x20, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x26, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69,
	0x70, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20,
	0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x49, 0x70, 0x28, 0x29, 0x0a, 0x5b,
	0x0a, 0x0f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x70, 0x5f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20,
	0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x1a, 0x17, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02, 0x69,
	0x70, 0x12, 0xdc, 0x01, 0x0a, 0x04, 0x69, 0x70, 0x76, 0x34, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08,
	0x42, 0xc5, 0x01, 0xc2, 0x48, 0xc1, 0x01, 0x0a, 0x5c, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x12, 0x22, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50,
	0x76, 0x34, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x29, 0x21, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73,
	0x49, 0x70, 0x28, 0x34, 0x29, 0x0a, 0x61, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x69, 0x70, 0x76, 0x34, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x31, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63,
	0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x20, 0x49, 0x50, 0x76, 0x34, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x19, 0x21,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x04, 0x69, 0x70, 0x76, 0x34,
	0x12, 0xdc, 0x01, 0x0a, 0x04, 0x69, 0x70, 0x76, 0x36, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x42,
	0xc5, 0x01, 0xc2, 0x48, 0xc1, 0x01, 0x0a, 0x5c, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x69, 0x70, 0x76, 0x36, 0x12, 0x22, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x76,
	0x36, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x29, 0x21, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x69, 0x70, 0x76, 0x36, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d,
	0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x49,
	0x70, 0x28, 0x36, 0x29, 0x0a, 0x61, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69,
	0x70, 0x76, 0x36, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x31, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68,
	0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20,
	0x49, 0x50, 0x76, 0x36, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x19, 0x21, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x36, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x04, 0x69, 0x70, 0x76, 0x36, 0x12,
	0xc4, 0x01, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x42, 0xaf, 0x01,
	0xc2, 0x48, 0xab, 0x01, 0x0a, 0x51, 0x0a, 0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x75,
	0x72, 0x69, 0x12, 0x19, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x55, 0x52, 0x49, 0x1a, 0x28, 0x21,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x75, 0x72, 0x69, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e,
	0x69, 0x73, 0x55, 0x72, 0x69, 0x28, 0x29, 0x0a, 0x56, 0x0a, 0x10, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x2e, 0x75, 0x72, 0x69, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x28, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69,
	0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x20, 0x55, 0x52, 0x49, 0x1a, 0x18, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x75, 0x72,
	0x69, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48,
	0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x6e, 0x0a, 0x07, 0x75, 0x72, 0x69, 0x5f, 0x72, 0x65,
	0x66, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x53, 0xc2, 0x48, 0x50, 0x0a, 0x4e, 0x0a, 0x0e,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x75, 0x72, 0x69, 0x5f, 0x72, 0x65, 0x66, 0x12, 0x19,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x55, 0x52, 0x49, 0x1a, 0x21, 0x21, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x75, 0x72, 0x69, 0x5f, 0x72, 0x65, 0x66, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x2e, 0x69, 0x73, 0x55, 0x72, 0x69, 0x52, 0x65, 0x66, 0x28, 0x29, 0x48, 0x00, 0x52, 0x06,
	0x75, 0x72, 0x69, 0x52, 0x65, 0x66, 0x12, 0x99, 0x02, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x42, 0xfc, 0x01, 0xc2, 0x48, 0xf8, 0x01, 0x0a,
	0x81, 0x01, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x2d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61,
	0x6d, 0x65, 0x2c, 0x20, 0x6f, 0x72, 0x20, 0x69, 0x70, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x1a, 0x40, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20,
	0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61,
	0x6d, 0x65, 0x28, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x49,
	0x70, 0x28, 0x29, 0x0a, 0x72, 0x0a, 0x14, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x3c, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69,
	0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x20, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x20, 0x6f, 0x72, 0x20, 0x69,
	0x70, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x1c, 0x21, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x9e, 0x02, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x87, 0x02, 0xc2, 0x48, 0x83, 0x02, 0x0a, 0xa5, 0x01, 0x0a, 0x0b, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x75, 0x75, 0x69, 0x64, 0x12, 0x1a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20,
	0x55, 0x55, 0x49, 0x44, 0x1a, 0x7a, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x75, 0x75, 0x69,
	0x64, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20,
	0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x28,
	0x27, 0x5e, 0x5b, 0x30, 0x2d, 0x39, 0x61, 0x2d, 0x66, 0x41, 0x2d, 0x46, 0x5d, 0x7b, 0x38, 0x7d,
	0x2d, 0x5b, 0x30, 0x2d, 0x39, 0x61, 0x2d, 0x66, 0x41, 0x2d, 0x46, 0x5d, 0x7b, 0x34, 0x7d, 0x2d,
	0x5b, 0x30, 0x2d, 0x39, 0x61, 0x2d, 0x66, 0x41, 0x2d, 0x46, 0x5d, 0x7b, 0x34, 0x7d, 0x2d, 0x5b,
	0x30, 0x2d, 0x39, 0x61, 0x2d, 0x66, 0x41, 0x2d, 0x46, 0x5d, 0x7b, 0x34, 0x7d, 0x2d, 0x5b, 0x30,
	0x2d, 0x39, 0x61, 0x2d, 0x66, 0x41, 0x2d, 0x46, 0x5d, 0x7b, 0x31, 0x32, 0x7d, 0x24, 0x27, 0x29,
	0x0a, 0x59, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x75, 0x75, 0x69, 0x64, 0x5f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x29, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20,
	0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x55, 0x55, 0x49, 0x44,
	0x1a, 0x19, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x75, 0x75, 0x69, 0x64, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x04, 0x75,
	0x75, 0x69, 0x64, 0x12, 0xf7, 0x01, 0x0a, 0x05, 0x74, 0x75, 0x75, 0x69, 0x64, 0x18, 0x21, 0x20,
	0x01, 0x28, 0x08, 0x42, 0xde, 0x01, 0xc2, 0x48, 0xda, 0x01, 0x0a, 0x73, 0x0a, 0x0c, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x75, 0x75, 0x69, 0x64, 0x12, 0x22, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x20, 0x74, 0x72, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x20, 0x55, 0x55, 0x49, 0x44, 0x1a, 0x3f,
	0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x74, 0x75, 0x75, 0x69, 0x64, 0x20, 0x7c, 0x7c, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x28, 0x27, 0x5e, 0x5b, 0x30, 0x2d,
	0x39, 0x61, 0x2d, 0x66, 0x41, 0x2d, 0x46, 0x5d, 0x7b, 0x33, 0x32, 0x7d, 0x24, 0x27, 0x29, 0x0a,
	0x63, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x75, 0x75, 0x69, 0x64, 0x5f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x31, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20,
	0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x74, 0x72, 0x69, 0x6d,
	0x6d, 0x65, 0x64, 0x20, 0x55, 0x55, 0x49, 0x44, 0x1a, 0x1a, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x74, 0x75, 0x75, 0x69, 0x64, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21,
	0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x05, 0x74, 0x75, 0x75, 0x69, 0x64, 0x12, 0xa7, 0x02,
	0x0a, 0x11, 0x69, 0x70, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x6c, 0x65, 0x6e, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x08, 0x42, 0xf8, 0x01, 0xc2, 0x48, 0xf4, 0x01,
	0x0a, 0x78, 0x0a, 0x18, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x70, 0x5f, 0x77, 0x69,
	0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x12, 0x1f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x3b, 0x21,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73,
	0x49, 0x70, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x28, 0x29, 0x0a, 0x78, 0x0a, 0x1e, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x70, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x2e, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68,
	0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x20, 0x49, 0x50, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x26, 0x21, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21,
	0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x70, 0x57, 0x69, 0x74, 0x68, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x12, 0xe2, 0x02, 0x0a, 0x13, 0x69, 0x70, 0x76, 0x34,
	0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x18,
	0x1b, 0x20, 0x01, 0x28, 0x08, 0x42, 0xaf, 0x02, 0xc2, 0x48, 0xab, 0x02, 0x0a, 0x93, 0x01, 0x0a,
	0x1a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x77, 0x69, 0x74,
	0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x12, 0x35, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x20, 0x49, 0x50, 0x76, 0x34, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20,
	0x77, 0x69, 0x74, 0x68, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x6c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x1a, 0x3e, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x5f,
	0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x20, 0x7c,
	0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x49, 0x70, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x28,
	0x34, 0x29, 0x0a, 0x92, 0x01, 0x0a, 0x20, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x70,
	0x76, 0x34, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6c, 0x65,
	0x6e, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x44, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69,
	0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69,
	0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50,
	0x76, 0x34, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x1a, 0x28, 0x21,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x11, 0x69, 0x70, 0x76, 0x34, 0x57,
	0x69, 0x74, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x12, 0xe2, 0x02, 0x0a,
	0x13, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x6c, 0x65, 0x6e, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x08, 0x42, 0xaf, 0x02, 0xc2, 0x48, 0xab,
	0x02, 0x0a, 0x93, 0x01, 0x0a, 0x1a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x70, 0x76,
	0x36, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e,
	0x12, 0x35, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x76, 0x36, 0x20, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x20, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x1a, 0x3e, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x69, 0x70, 0x76, 0x36, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x6c, 0x65, 0x6e, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27,
	0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x49, 0x70, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x28, 0x36, 0x29, 0x0a, 0x92, 0x01, 0x0a, 0x20, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x44, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68,
	0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x20, 0x49, 0x50, 0x76, 0x36, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20,
	0x77, 0x69, 0x74, 0x68, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x6c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x1a, 0x28, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x36, 0x5f,
	0x77, 0x69, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6c, 0x65, 0x6e, 0x20, 0x7c,
	0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x11,
	0x69, 0x70, 0x76, 0x36, 0x57, 0x69, 0x74, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6c, 0x65,
	0x6e, 0x12, 0xfc, 0x01, 0x0a, 0x09, 0x69, 0x70, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18,
	0x1d, 0x20, 0x01, 0x28, 0x08, 0x42, 0xdc, 0x01, 0xc2, 0x48, 0xd8, 0x01, 0x0a, 0x6c, 0x0a, 0x10,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x70, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x1f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x1a, 0x37, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27,
	0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x49, 0x70, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x28, 0x74, 0x72, 0x75, 0x65, 0x29, 0x0a, 0x68, 0x0a, 0x16, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x70, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x2e, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e,
	0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x20, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x1a, 0x1e, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21,
	0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x08, 0x69, 0x70, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x8f, 0x02, 0x0a, 0x0b, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x08, 0x42, 0xeb, 0x01, 0xc2, 0x48, 0xe7, 0x01, 0x0a, 0x75, 0x0a,
	0x12, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x12, 0x21, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x76, 0x34, 0x20,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x3c, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69,
	0x70, 0x76, 0x34, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x2e, 0x69, 0x73, 0x49, 0x70, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x28, 0x34, 0x2c, 0x20, 0x74,
	0x72, 0x75, 0x65, 0x29, 0x0a, 0x6e, 0x0a, 0x18, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69,
	0x70, 0x76, 0x34, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x30, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61,
	0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x76, 0x34, 0x20, 0x70, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x1a, 0x20, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21,
	0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x70, 0x76, 0x34, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x12, 0x8f, 0x02, 0x0a, 0x0b, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x70, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x08, 0x42, 0xeb, 0x01, 0xc2, 0x48, 0xe7, 0x01, 0x0a,
	0x75, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x21, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x76,
	0x36, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x3c, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x7c, 0x7c, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x69, 0x73, 0x49, 0x70, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x28, 0x36, 0x2c,
	0x20, 0x74, 0x72, 0x75, 0x65, 0x29, 0x0a, 0x6e, 0x0a, 0x18, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x30, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74,
	0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x76, 0x36, 0x20, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x1a, 0x20, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76,
	0x36, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x70, 0x76, 0x36, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x12, 0xc2, 0x02, 0x0a, 0x0d, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x61, 0x6e,
	0x64, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x20, 0x20, 0x01, 0x28, 0x08, 0x42, 0x9b, 0x02, 0xc2,
	0x48, 0x97, 0x02, 0x0a, 0x99, 0x01, 0x0a, 0x14, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x68,
	0x6f, 0x73, 0x74, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x41, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x20, 0x68, 0x6f, 0x73, 0x74, 0x20, 0x28, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61,
	0x6d, 0x65, 0x20, 0x6f, 0x72, 0x20, 0x49, 0x50, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x29, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x70, 0x61, 0x69, 0x72, 0x1a,
	0x3e, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x61, 0x6e, 0x64,
	0x5f, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d,
	0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x69, 0x73, 0x48, 0x6f,
	0x73, 0x74, 0x41, 0x6e, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x28, 0x74, 0x72, 0x75, 0x65, 0x29, 0x0a,
	0x79, 0x0a, 0x1a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x61,
	0x6e, 0x64, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x37, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77,
	0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x20, 0x68, 0x6f, 0x73, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x6f, 0x72,
	0x74, 0x20, 0x70, 0x61, 0x69, 0x72, 0x1a, 0x22, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x68,
	0x6f, 0x73, 0x74, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x7c, 0x7c, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x0b, 0x68, 0x6f,
	0x73, 0x74, 0x41, 0x6e, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x12, 0xb8, 0x05, 0x0a, 0x10, 0x77, 0x65,
	0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x18,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x52, 0x65, 0x67, 0x65, 0x78, 0x42, 0xf1,
	0x04, 0xc2, 0x48, 0xed, 0x04, 0x0a, 0xf0, 0x01, 0x0a, 0x23, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x72, 0x65, 0x67, 0x65,
	0x78, 0x2e, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x20, 0x48, 0x54, 0x54, 0x50, 0x20, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x20, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0xa0, 0x01, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x77, 0x65,
	0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x20, 0x21,
	0x3d, 0x20, 0x31, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27,
	0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x28, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x20, 0x3f, 0x27, 0x5e, 0x3a, 0x3f, 0x5b, 0x30, 0x2d, 0x39, 0x61, 0x2d,
	0x7a, 0x41, 0x2d, 0x5a, 0x21, 0x23, 0x24, 0x25, 0x26, 0x5c, 0x27, 0x2a, 0x2b, 0x2d, 0x2e, 0x5e,
	0x5f, 0x7c, 0x7e, 0x5c, 0x78, 0x36, 0x30, 0x5d, 0x2b, 0x24, 0x27, 0x20, 0x3a, 0x27, 0x5e, 0x5b,
	0x5e, 0x5c, 0x75, 0x30, 0x30, 0x30, 0x30, 0x5c, 0x75, 0x30, 0x30, 0x30, 0x41, 0x5c, 0x75, 0x30,
	0x30, 0x30, 0x44, 0x5d, 0x2b, 0x24, 0x27, 0x29, 0x0a, 0x8d, 0x01, 0x0a, 0x29, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x72,
	0x65, 0x67, 0x65, 0x78, 0x2e, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x35, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73,
	0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73,
	0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x48, 0x54, 0x54,
	0x50, 0x20, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x29, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f,
	0x72, 0x65, 0x67, 0x65, 0x78, 0x20, 0x21, 0x3d, 0x20, 0x31, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x27, 0x27, 0x0a, 0xe7, 0x01, 0x0a, 0x24, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x72,
	0x65, 0x67, 0x65, 0x78, 0x2e, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x48, 0x54, 0x54, 0x50, 0x20, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x95, 0x01, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x72, 0x65,
	0x67, 0x65, 0x78, 0x20, 0x21, 0x3d, 0x20, 0x32, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x28, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x20, 0x3f, 0x27, 0x5e, 0x5b,
	0x5e, 0x5c, 0x75, 0x30, 0x30, 0x30, 0x30, 0x2d, 0x5c, 0x75, 0x30, 0x30, 0x30, 0x38, 0x5c, 0x75,
	0x30, 0x30, 0x30, 0x41, 0x2d, 0x5c, 0x75, 0x30, 0x30, 0x31, 0x46, 0x5c, 0x75, 0x30, 0x30, 0x37,
	0x46, 0x5d, 0x2a, 0x24, 0x27, 0x20, 0x3a, 0x27, 0x5e, 0x5b, 0x5e, 0x5c, 0x75, 0x30, 0x30, 0x30,
	0x30, 0x5c, 0x75, 0x30, 0x30, 0x30, 0x41, 0x5c, 0x75, 0x30, 0x30, 0x30, 0x44, 0x5d, 0x2a, 0x24,
	0x27, 0x29, 0x48, 0x00, 0x52, 0x0e, 0x77, 0x65, 0x6c, 0x6c, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x52,
	0x65, 0x67, 0x65, 0x78, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x18, 0x19,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x12, 0x35, 0x0a, 0x07,
	0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x22, 0x20, 0x03, 0x28, 0x09, 0x42, 0x1b, 0xc2,
	0x48, 0x18, 0x0a, 0x16, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0c,
	0x0a, 0x0a, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x22, 0xa3, 0x11, 0x0a,
	0x0a, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x6d, 0x0a, 0x05, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x57, 0xc2, 0x48, 0x54, 0x0a,
	0x52, 0x0a, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x43,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x25, 0x78, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0x7d, 0x0a, 0x03, 0x6c, 0x65,
	0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x04, 0x42, 0x6b, 0xc2, 0x48, 0x68, 0x0a, 0x66, 0x0a, 0x09,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x6c, 0x65, 0x6e, 0x1a, 0x59, 0x75, 0x69, 0x6e, 0x74, 0x28,
	0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x29, 0x20, 0x21, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x65, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x25, 0x73, 0x20, 0x62, 0x79, 0x74, 0x65, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x65, 0x6e, 0x5d, 0x29, 0x20,
	0x3a, 0x20, 0x27, 0x27, 0x52, 0x03, 0x6c, 0x65, 0x6e, 0x12, 0x98, 0x01, 0x0a, 0x07, 0x6d, 0x69,
	0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x42, 0x7f, 0xc2, 0x48, 0x7c,
	0x0a, 0x7a, 0x0a, 0x0d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65,
	0x6e, 0x1a, 0x69, 0x75, 0x69, 0x6e, 0x74, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a,
	0x65, 0x28, 0x29, 0x29, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x69, 0x6e,
	0x5f, 0x6c, 0x65, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x74, 0x20,
	0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x25, 0x73, 0x20, 0x62, 0x79, 0x74, 0x65, 0x73, 0x27, 0x2e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x69,
	0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x06, 0x6d, 0x69,
	0x6e, 0x4c, 0x65, 0x6e, 0x12, 0x90, 0x01, 0x0a, 0x07, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x42, 0x77, 0xc2, 0x48, 0x74, 0x0a, 0x72, 0x0a, 0x0d, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x1a, 0x61, 0x75, 0x69,
	0x6e, 0x74, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x29, 0x20,
	0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x20,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x61, 0x74, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x25, 0x73, 0x20, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52,
	0x06, 0x6d, 0x61, 0x78, 0x4c, 0x65, 0x6e, 0x12, 0x99, 0x01, 0x0a, 0x07, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x7f, 0xc2, 0x48, 0x7c, 0x0a, 0x7a,
	0x0a, 0x0d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x1a,
	0x69, 0x21, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x28, 0x74, 0x68, 0x69, 0x73, 0x29, 0x2e, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x6e, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x20, 0x72, 0x65, 0x67, 0x65, 0x78, 0x20,
	0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x20, 0x60, 0x25, 0x73, 0x60, 0x27, 0x2e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x07, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x12, 0x89, 0x01, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0x71, 0xc2, 0x48, 0x6e, 0x0a, 0x6c, 0x0a, 0x0c, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x5c, 0x21, 0x74, 0x68, 0x69, 0x73,
	0x2e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x57, 0x69, 0x74, 0x68, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65,
	0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x25, 0x78, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12,
	0x87, 0x01, 0x0a, 0x06, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c,
	0x42, 0x6f, 0xc2, 0x48, 0x6c, 0x0a, 0x6a, 0x0a, 0x0c, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x73,
	0x75, 0x66, 0x66, 0x69, 0x78, 0x1a, 0x5a, 0x21, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x65, 0x6e, 0x64,
	0x73, 0x57, 0x69, 0x74, 0x68, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x73, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x64, 0x6f, 0x65,
	0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x73, 0x75, 0x66, 0x66, 0x69,
	0x78, 0x20, 0x25, 0x78, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x52, 0x06, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x8d, 0x01, 0x0a, 0x08, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x71, 0xc2, 0x48,
	0x6e, 0x0a, 0x6c, 0x0a, 0x0e, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x73, 0x1a, 0x5a, 0x21, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x73, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x64, 0x6f, 0x65,
	0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x20, 0x25, 0x78,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52,
	0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x9b, 0x01, 0x0a, 0x02, 0x69, 0x6e,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x0c, 0x42, 0x8a, 0x01, 0xc2, 0x48, 0x86, 0x01, 0x0a, 0x83, 0x01,
	0x0a, 0x08, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x6e, 0x1a, 0x77, 0x64, 0x79, 0x6e, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x2e, 0x73, 0x69, 0x7a,
	0x65, 0x28, 0x29, 0x20, 0x3e, 0x20, 0x30, 0x20, 0x26, 0x26, 0x20, 0x21, 0x28, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b,
	0x27, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x64, 0x79, 0x6e, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x7d, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69,
	0x6e, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0c, 0x42, 0x66, 0xc2, 0x48, 0x63, 0x0a, 0x61, 0x0a, 0x0c,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x1a, 0x51, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f,
	0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52,
	0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0xef, 0x01, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x08, 0x42, 0xdc, 0x01, 0xc2, 0x48, 0xd8, 0x01, 0x0a, 0x74, 0x0a, 0x08, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x12, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50,
	0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x46, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x69, 0x70, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65,
	0x28, 0x29, 0x20, 0x3d, 0x3d, 0x20, 0x30, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e,
	0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x20, 0x3d, 0x3d, 0x20, 0x34, 0x20, 0x7c, 0x7c, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x20, 0x3d, 0x3d, 0x20, 0x31, 0x36,
	0x0a, 0x60, 0x0a, 0x0e, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x5f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74,
	0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x20, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x1a, 0x1d, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x20, 0x7c,
	0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x20, 0x21, 0x3d,
	0x20, 0x30, 0x48, 0x00, 0x52, 0x02, 0x69, 0x70, 0x12, 0xea, 0x01, 0x0a, 0x04, 0x69, 0x70, 0x76,
	0x34, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0xd3, 0x01, 0xc2, 0x48, 0xcf, 0x01, 0x0a, 0x65,
	0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x12, 0x22, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x20, 0x49, 0x50, 0x76, 0x34, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x1a, 0x33, 0x21, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x20, 0x3d, 0x3d, 0x20,
	0x30, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29,
	0x20, 0x3d, 0x3d, 0x20, 0x34, 0x0a, 0x66, 0x0a, 0x10, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x69,
	0x70, 0x76, 0x34, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x31, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x69, 0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68,
	0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20,
	0x49, 0x50, 0x76, 0x34, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x1f, 0x21, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x34, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x20, 0x21, 0x3d, 0x20, 0x30, 0x48, 0x00, 0x52,
	0x04, 0x69, 0x70, 0x76, 0x34, 0x12, 0xeb, 0x01, 0x0a, 0x04, 0x69, 0x70, 0x76, 0x36, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x08, 0x42, 0xd4, 0x01, 0xc2, 0x48, 0xd0, 0x01, 0x0a, 0x66, 0x0a, 0x0a, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x36, 0x12, 0x22, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x20, 0x49, 0x50, 0x76, 0x36, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x34, 0x21,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x36, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x20, 0x3d, 0x3d, 0x20, 0x30, 0x20, 0x7c,
	0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x20, 0x3d, 0x3d,
	0x20, 0x31, 0x36, 0x0a, 0x66, 0x0a, 0x10, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x70, 0x76,
	0x36, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x31, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69,
	0x73, 0x20, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69,
	0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x49, 0x50,
	0x76, 0x36, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x1f, 0x21, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x69, 0x70, 0x76, 0x36, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e,
	0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x20, 0x21, 0x3d, 0x20, 0x30, 0x48, 0x00, 0x52, 0x04, 0x69,
	0x70, 0x76, 0x36, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x0e,
	0x20, 0x03, 0x28, 0x0c, 0x42, 0x1a, 0xc2, 0x48, 0x17, 0x0a, 0x15, 0x0a, 0x0d, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65,
	0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80,
	0x80, 0x80, 0x80, 0x02, 0x42, 0x0c, 0x0a, 0x0a, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f,
	0x77, 0x6e, 0x22, 0xd7, 0x03, 0x0a, 0x09, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x12, 0x6f, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x59, 0xc2, 0x48, 0x56, 0x0a, 0x54, 0x0a, 0x0a, 0x65, 0x6e, 0x75, 0x6d, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x25, 0x73, 0x27, 0x2e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73,
	0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x78, 0x0a, 0x02, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x03, 0x28, 0x05,
	0x42, 0x68, 0xc2, 0x48, 0x65, 0x0a, 0x63, 0x0a, 0x07, 0x65, 0x6e, 0x75, 0x6d, 0x2e, 0x69, 0x6e,
	0x1a, 0x58, 0x21, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69,
	0x6e, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69,
	0x6e, 0x27, 0x5d, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x7c,
	0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28, 0x05, 0x42, 0x65,
	0xc2, 0x48, 0x62, 0x0a, 0x60, 0x0a, 0x0b, 0x65, 0x6e, 0x75, 0x6d, 0x2e, 0x6e, 0x6f, 0x74, 0x5f,
	0x69, 0x6e, 0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e,
	0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0x33, 0x0a, 0x07,
	0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x03, 0x28, 0x05, 0x42, 0x19, 0xc2,
	0x48, 0x16, 0x0a, 0x14, 0x0a, 0x0c, 0x65, 0x6e, 0x75, 0x6d, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x22, 0xa4, 0x04, 0x0a,
	0x0d, 0x52, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xa8,
	0x01, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x04, 0x42, 0x8a, 0x01, 0xc2, 0x48, 0x86, 0x01, 0x0a, 0x83, 0x01, 0x0a, 0x12, 0x72, 0x65,
	0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73,
	0x1a, 0x6d, 0x75, 0x69, 0x6e, 0x74, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65,
	0x28, 0x29, 0x29, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x69, 0x6e, 0x5f,
	0x69, 0x74, 0x65, 0x6d, 0x73, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x20, 0x61, 0x74, 0x20, 0x6c,
	0x65, 0x61, 0x73, 0x74, 0x20, 0x25, 0x64, 0x20, 0x69, 0x74, 0x65, 0x6d, 0x28, 0x73, 0x29, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d,
	0x69, 0x6e, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52,
	0x08, 0x6d, 0x69, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0xac, 0x01, 0x0a, 0x09, 0x6d, 0x61,
	0x78, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x42, 0x8e, 0x01,
	0xc2, 0x48, 0x8a, 0x01, 0x0a, 0x87, 0x01, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x1a, 0x71, 0x75, 0x69, 0x6e,
	0x74, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x29, 0x20, 0x3e,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73,
	0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x20, 0x6e, 0x6f, 0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x69, 0x74, 0x65, 0x6d, 0x28, 0x73, 0x29, 0x27, 0x2e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x61,
	0x78, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x08,
	0x6d, 0x61, 0x78, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x78, 0x0a, 0x06, 0x75, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x60, 0xc2, 0x48, 0x5d, 0x0a, 0x5b, 0x0a,
	0x0f, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x2e, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65,
	0x12, 0x28, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x20, 0x75, 0x6e,
	0x69, 0x71, 0x75, 0x65, 0x20, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x1a, 0x1e, 0x21, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x2e, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x28, 0x29, 0x52, 0x06, 0x75, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x73, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80,
	0x80, 0x80, 0x02, 0x22, 0xb8, 0x03, 0x0a, 0x08, 0x4d, 0x61, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x12, 0x99, 0x01, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x04, 0x42, 0x7c, 0xc2, 0x48, 0x79, 0x0a, 0x77, 0x0a, 0x0d, 0x6d, 0x61, 0x70,
	0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x1a, 0x66, 0x75, 0x69, 0x6e, 0x74,
	0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x29, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x20,
	0x3f, 0x20, 0x27, 0x6d, 0x61, 0x70, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61,
	0x74, 0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x25, 0x64, 0x20, 0x65, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x5d, 0x29, 0x20, 0x3a, 0x20,
	0x27, 0x27, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x69, 0x72, 0x73, 0x12, 0x98, 0x01, 0x0a,
	0x09, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04,
	0x42, 0x7b, 0xc2, 0x48, 0x78, 0x0a, 0x76, 0x0a, 0x0d, 0x6d, 0x61, 0x70, 0x2e, 0x6d, 0x61, 0x78,
	0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x1a, 0x65, 0x75, 0x69, 0x6e, 0x74, 0x28, 0x74, 0x68, 0x69,
	0x73, 0x2e, 0x73, 0x69, 0x7a, 0x65, 0x28, 0x29, 0x29, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x20, 0x3f, 0x20, 0x27, 0x6d,
	0x61, 0x70, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x74, 0x20, 0x6d, 0x6f,
	0x73, 0x74, 0x20, 0x25, 0x64, 0x20, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x27, 0x2e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x78,
	0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x08, 0x6d,
	0x61, 0x78, 0x50, 0x61, 0x69, 0x72, 0x73, 0x12, 0x32, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x36, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x22, 0x31,
	0x0a, 0x08, 0x41, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x6e,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x15, 0x0a, 0x06, 0x6e, 0x6f,
	0x74, 0x5f, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49,
	0x6e, 0x22, 0xa2, 0x17, 0x0a, 0x0d, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x5d,
	0xc2, 0x48, 0x5a, 0x0a, 0x58, 0x0a, 0x0e, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74, 0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x12, 0xac, 0x01, 0x0a, 0x02, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x7f, 0xc2, 0x48,
	0x7c, 0x0a, 0x7a, 0x0a, 0x0b, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6c, 0x74,
	0x1a, 0x6b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52,
	0x02, 0x6c, 0x74, 0x12, 0xbf, 0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x8f, 0x01, 0xc2,
	0x48, 0x8b, 0x01, 0x0a, 0x88, 0x01, 0x0a, 0x0c, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x6c, 0x74, 0x65, 0x1a, 0x78, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00,
	0x52, 0x03, 0x6c, 0x74, 0x65, 0x12, 0xc5, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x97, 0x07,
	0xc2, 0x48, 0x93, 0x07, 0x0a, 0x7d, 0x0a, 0x0b, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x74, 0x1a, 0x6e, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c,
	0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xb6, 0x01, 0x0a, 0x0e, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26,
	0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73,
	0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xbe, 0x01, 0x0a,
	0x18, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x5f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xa1, 0x01, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc6, 0x01,
	0x0a, 0x0f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74,
	0x65, 0x1a, 0xb2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20,
	0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20,
	0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d,
	0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xce, 0x01, 0x0a, 0x19, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26,
	0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f,
	0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0x92, 0x08,
	0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0xe2, 0x07, 0xc2, 0x48, 0xde, 0x07, 0x0a, 0x8b, 0x01,
	0x0a, 0x0c, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x74, 0x65, 0x1a, 0x7b,
	0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc5, 0x01, 0x0a, 0x0f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a,
	0xb1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
	0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xcd, 0x01, 0x0a, 0x19, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76,
	0x65, 0x1a, 0xaf, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26,
	0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e,
	0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20,
	0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xd5, 0x01, 0x0a, 0x10, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xc0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71,
	0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xdd, 0x01, 0x0a, 0x1a,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65,
	0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xbe, 0x01, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65,
	0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x03, 0x67,
	0x74, 0x65, 0x12, 0x97, 0x01, 0x0a, 0x02, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6c, 0xc2, 0x48, 0x69, 0x0a,
	0x67, 0x0a, 0x0b, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x69, 0x6e, 0x1a, 0x58,
	0x21, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20,
	0x6c, 0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28,
	0x5b, 0x64, 0x79, 0x6e, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x29, 0x5b, 0x27, 0x69, 0x6e, 0x27,
	0x5d, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x9b, 0x01, 0x0a,
	0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x69, 0xc2, 0x48, 0x66, 0x0a, 0x64, 0x0a,
	0x0f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e,
	0x1a, 0x51, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x6c,
	0x69, 0x73, 0x74, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49, 0x6e, 0x12, 0x52, 0x0a, 0x07, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x1d, 0xc2, 0x48, 0x1a, 0x0a, 0x18, 0x0a, 0x10, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x1a,
	0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2a, 0x09,
	0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09, 0x6c, 0x65, 0x73,
	0x73, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x22, 0xb0, 0x18, 0x0a, 0x0e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x90, 0x01, 0x0a, 0x05, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x5e, 0xc2, 0x48, 0x5b, 0x0a, 0x59, 0x0a, 0x0f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x46, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x21, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x52, 0x05, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x12, 0xaf, 0x01, 0x0a,
	0x02, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x80, 0x01, 0xc2, 0x48, 0x7d, 0x0a, 0x7b, 0x0a, 0x0c, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x6c, 0x74, 0x1a, 0x6b, 0x21, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20,
	0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x20, 0x26,
	0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27,
	0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x02, 0x6c, 0x74, 0x12, 0xc1,
	0x01, 0x0a, 0x03, 0x6c, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x90, 0x01, 0xc2, 0x48, 0x8c, 0x01, 0x0a,
	0x89, 0x01, 0x0a, 0x0d, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x6c, 0x74,
	0x65, 0x1a, 0x78, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68,
	0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25,
	0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00, 0x52, 0x03, 0x6c,
	0x74, 0x65, 0x12, 0x73, 0x0a, 0x06, 0x6c, 0x74, 0x5f, 0x6e, 0x6f, 0x77, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x5a, 0xc2, 0x48, 0x57, 0x0a, 0x55, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x6c, 0x74, 0x5f, 0x6e, 0x6f, 0x77, 0x1a, 0x41, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5f, 0x6e, 0x6f, 0x77, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3e, 0x20, 0x6e, 0x6f, 0x77, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x6e, 0x6f, 0x77, 0x27, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x00,
	0x52, 0x05, 0x6c, 0x74, 0x4e, 0x6f, 0x77, 0x12, 0xcb, 0x07, 0x0a, 0x02, 0x67, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x9c, 0x07, 0xc2, 0x48, 0x98, 0x07, 0x0a, 0x7e, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x67, 0x74, 0x1a, 0x6e, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73, 0x28,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x3f, 0x20,
	0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xb7, 0x01, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x1a, 0xa3, 0x01, 0x68, 0x61,
	0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e,
	0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74,
	0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27,
	0x27, 0x0a, 0xbf, 0x01, 0x0a, 0x19, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x67, 0x74, 0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a,
	0xa1, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20,
	0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29,
	0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73,
	0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x0a, 0xc7, 0x01, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x67, 0x74, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xb2, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64,
	0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71,
	0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xcf, 0x01,
	0x0a, 0x1a, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x67, 0x74, 0x5f, 0x6c,
	0x74, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xb0, 0x01, 0x68,
	0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x20,
	0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x2c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48,
	0x01, 0x52, 0x02, 0x67, 0x74, 0x12, 0x98, 0x08, 0x0a, 0x03, 0x67, 0x74, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0xe7, 0x07, 0xc2, 0x48, 0xe3, 0x07, 0x0a, 0x8c, 0x01, 0x0a, 0x0d, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x67, 0x74, 0x65, 0x1a, 0x7b, 0x21, 0x68, 0x61, 0x73, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x21, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x5d, 0x29,
	0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xc6, 0x01, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x1a, 0xb1, 0x01, 0x68, 0x61, 0x73,
	0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x3d, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71,
	0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65,
	0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xce,
	0x01, 0x0a, 0x1a, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x67, 0x74, 0x65,
	0x5f, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xaf, 0x01,
	0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x29, 0x20, 0x26, 0x26,
	0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x20, 0x3c, 0x3d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f,
	0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20,
	0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c,
	0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a,
	0xd6, 0x01, 0x0a, 0x11, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x67, 0x74,
	0x65, 0x5f, 0x6c, 0x74, 0x65, 0x1a, 0xc0, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e,
	0x6c, 0x74, 0x65, 0x20, 0x3e, 0x3d, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65,
	0x20, 0x26, 0x26, 0x20, 0x28, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3e, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c,
	0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f,
	0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74,
	0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x0a, 0xde, 0x01, 0x0a, 0x1b, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x67, 0x74, 0x65, 0x5f, 0x6c, 0x74, 0x65, 0x5f, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xbe, 0x01, 0x68, 0x61, 0x73, 0x28, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x29, 0x20, 0x26, 0x26, 0x20, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65, 0x20, 0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67,
	0x74, 0x65, 0x20, 0x26, 0x26, 0x20, 0x28, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c, 0x74, 0x65,
	0x20, 0x3c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x3c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x29, 0x3f, 0x20, 0x27, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75,
	0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x25, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
	0x6f, 0x20, 0x25, 0x73, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x2e, 0x67, 0x74, 0x65, 0x2c, 0x20, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x6c,
	0x74, 0x65, 0x5d, 0x29, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48, 0x01, 0x52, 0x03, 0x67, 0x74, 0x65,
	0x12, 0x76, 0x0a, 0x06, 0x67, 0x74, 0x5f, 0x6e, 0x6f, 0x77, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x5d, 0xc2, 0x48, 0x5a, 0x0a, 0x58, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x67, 0x74, 0x5f, 0x6e, 0x6f, 0x77, 0x1a, 0x44, 0x28, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2e, 0x67, 0x74, 0x5f, 0x6e, 0x6f, 0x77, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x3c, 0x20, 0x6e, 0x6f, 0x77, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6e, 0x6f, 0x77, 0x27, 0x20, 0x3a, 0x20, 0x27, 0x27, 0x48,
	0x01, 0x52, 0x05, 0x67, 0x74, 0x4e, 0x6f, 0x77, 0x12, 0xc0, 0x01, 0x0a, 0x06, 0x77, 0x69, 0x74,
	0x68, 0x69, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x8c, 0x01, 0xc2, 0x48, 0x88, 0x01, 0x0a, 0x85, 0x01, 0x0a, 0x10,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e,
	0x1a, 0x71, 0x74, 0x68, 0x69, 0x73, 0x20, 0x3c, 0x20, 0x6e, 0x6f, 0x77, 0x2d, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x2e, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x3e, 0x20, 0x6e, 0x6f, 0x77, 0x2b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x77, 0x69,
	0x74, 0x68, 0x69, 0x6e, 0x20, 0x3f, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x20, 0x25, 0x73, 0x20,
	0x6f, 0x66, 0x20, 0x6e, 0x6f, 0x77, 0x27, 0x2e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x28, 0x5b,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x5d, 0x29, 0x20, 0x3a,
	0x20, 0x27, 0x27, 0x52, 0x06, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x12, 0x54, 0x0a, 0x07, 0x65,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x1e, 0xc2, 0x48, 0x1b, 0x0a, 0x19, 0x0a,
	0x11, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x1a, 0x04, 0x74, 0x72, 0x75, 0x65, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x2a, 0x09, 0x08, 0xe8, 0x07, 0x10, 0x80, 0x80, 0x80, 0x80, 0x02, 0x42, 0x0b, 0x0a, 0x09,
	0x6c, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x67, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x22, 0x45, 0x0a, 0x0a, 0x56, 0x69, 0x6f,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x37, 0x0a, 0x0a, 0x76, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x82, 0x01, 0x0a, 0x09, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d,
	0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x12, 0x23, 0x0a,
	0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x07,
	0x66, 0x6f, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x66,
	0x6f, 0x72, 0x4b, 0x65, 0x79, 0x2a, 0x9d, 0x01, 0x0a, 0x06, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x12, 0x16, 0x0a, 0x12, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x49, 0x47, 0x4e, 0x4f,
	0x52, 0x45, 0x5f, 0x49, 0x46, 0x5f, 0x55, 0x4e, 0x50, 0x4f, 0x50, 0x55, 0x4c, 0x41, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x5f, 0x49, 0x46,
	0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x02,
	0x12, 0x11, 0x0a, 0x0d, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x5f, 0x41, 0x4c, 0x57, 0x41, 0x59,
	0x53, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x0c, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x5f, 0x45, 0x4d,
	0x50, 0x54, 0x59, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x16, 0x0a, 0x0e, 0x49, 0x47, 0x4e,
	0x4f, 0x52, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x02, 0x1a, 0x02, 0x08,
	0x01, 0x1a, 0x02, 0x10, 0x01, 0x2a, 0x6e, 0x0a, 0x0a, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x52, 0x65,
	0x67, 0x65, 0x78, 0x12, 0x1b, 0x0a, 0x17, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x52, 0x45, 0x47,
	0x45, 0x58, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x20, 0x0a, 0x1c, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x52, 0x45, 0x47, 0x45, 0x58, 0x5f,
	0x48, 0x54, 0x54, 0x50, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x5f, 0x4e, 0x41, 0x4d, 0x45,
	0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x52, 0x45, 0x47, 0x45,
	0x58, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x5f, 0x56, 0x41,
	0x4c, 0x55, 0x45, 0x10, 0x02, 0x3a, 0x5c, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x87, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x3a, 0x54, 0x0a, 0x05, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x12, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4f,
	0x6e, 0x65, 0x6f, 0x66, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x87, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x2e, 0x4f, 0x6e, 0x65, 0x6f, 0x66, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x73, 0x52, 0x05, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x3a, 0x54, 0x0a, 0x05, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x87, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x3a,
	0x63, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x12, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x88, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66,
	0x69, 0x6e, 0x65, 0x64, 0x42, 0x6e, 0x0a, 0x12, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x42, 0x0d, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x62, 0x75, 0x66,
	0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75,
	0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66,
	0x66, 0x65, 0x72, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65,
}

var (
	file_buf_validate_validate_proto_rawDescOnce sync.Once
	file_buf_validate_validate_proto_rawDescData = file_buf_validate_validate_proto_rawDesc
)

func file_buf_validate_validate_proto_rawDescGZIP() []byte {
	file_buf_validate_validate_proto_rawDescOnce.Do(func() {
		file_buf_validate_validate_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_validate_validate_proto_rawDescData)
	})
	return file_buf_validate_validate_proto_rawDescData
}

var file_buf_validate_validate_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_buf_validate_validate_proto_msgTypes = make([]protoimpl.MessageInfo, 28)
var file_buf_validate_validate_proto_goTypes = []any{
	(Ignore)(0),                         // 0: buf.validate.Ignore
	(KnownRegex)(0),                     // 1: buf.validate.KnownRegex
	(*Constraint)(nil),                  // 2: buf.validate.Constraint
	(*MessageConstraints)(nil),          // 3: buf.validate.MessageConstraints
	(*OneofConstraints)(nil),            // 4: buf.validate.OneofConstraints
	(*FieldConstraints)(nil),            // 5: buf.validate.FieldConstraints
	(*PredefinedConstraints)(nil),       // 6: buf.validate.PredefinedConstraints
	(*FloatRules)(nil),                  // 7: buf.validate.FloatRules
	(*DoubleRules)(nil),                 // 8: buf.validate.DoubleRules
	(*Int32Rules)(nil),                  // 9: buf.validate.Int32Rules
	(*Int64Rules)(nil),                  // 10: buf.validate.Int64Rules
	(*UInt32Rules)(nil),                 // 11: buf.validate.UInt32Rules
	(*UInt64Rules)(nil),                 // 12: buf.validate.UInt64Rules
	(*SInt32Rules)(nil),                 // 13: buf.validate.SInt32Rules
	(*SInt64Rules)(nil),                 // 14: buf.validate.SInt64Rules
	(*Fixed32Rules)(nil),                // 15: buf.validate.Fixed32Rules
	(*Fixed64Rules)(nil),                // 16: buf.validate.Fixed64Rules
	(*SFixed32Rules)(nil),               // 17: buf.validate.SFixed32Rules
	(*SFixed64Rules)(nil),               // 18: buf.validate.SFixed64Rules
	(*BoolRules)(nil),                   // 19: buf.validate.BoolRules
	(*StringRules)(nil),                 // 20: buf.validate.StringRules
	(*BytesRules)(nil),                  // 21: buf.validate.BytesRules
	(*EnumRules)(nil),                   // 22: buf.validate.EnumRules
	(*RepeatedRules)(nil),               // 23: buf.validate.RepeatedRules
	(*MapRules)(nil),                    // 24: buf.validate.MapRules
	(*AnyRules)(nil),                    // 25: buf.validate.AnyRules
	(*DurationRules)(nil),               // 26: buf.validate.DurationRules
	(*TimestampRules)(nil),              // 27: buf.validate.TimestampRules
	(*Violations)(nil),                  // 28: buf.validate.Violations
	(*Violation)(nil),                   // 29: buf.validate.Violation
	(*durationpb.Duration)(nil),         // 30: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),       // 31: google.protobuf.Timestamp
	(*descriptorpb.MessageOptions)(nil), // 32: google.protobuf.MessageOptions
	(*descriptorpb.OneofOptions)(nil),   // 33: google.protobuf.OneofOptions
	(*descriptorpb.FieldOptions)(nil),   // 34: google.protobuf.FieldOptions
}
var file_buf_validate_validate_proto_depIdxs = []int32{
	2,  // 0: buf.validate.MessageConstraints.cel:type_name -> buf.validate.Constraint
	2,  // 1: buf.validate.FieldConstraints.cel:type_name -> buf.validate.Constraint
	0,  // 2: buf.validate.FieldConstraints.ignore:type_name -> buf.validate.Ignore
	7,  // 3: buf.validate.FieldConstraints.float:type_name -> buf.validate.FloatRules
	8,  // 4: buf.validate.FieldConstraints.double:type_name -> buf.validate.DoubleRules
	9,  // 5: buf.validate.FieldConstraints.int32:type_name -> buf.validate.Int32Rules
	10, // 6: buf.validate.FieldConstraints.int64:type_name -> buf.validate.Int64Rules
	11, // 7: buf.validate.FieldConstraints.uint32:type_name -> buf.validate.UInt32Rules
	12, // 8: buf.validate.FieldConstraints.uint64:type_name -> buf.validate.UInt64Rules
	13, // 9: buf.validate.FieldConstraints.sint32:type_name -> buf.validate.SInt32Rules
	14, // 10: buf.validate.FieldConstraints.sint64:type_name -> buf.validate.SInt64Rules
	15, // 11: buf.validate.FieldConstraints.fixed32:type_name -> buf.validate.Fixed32Rules
	16, // 12: buf.validate.FieldConstraints.fixed64:type_name -> buf.validate.Fixed64Rules
	17, // 13: buf.validate.FieldConstraints.sfixed32:type_name -> buf.validate.SFixed32Rules
	18, // 14: buf.validate.FieldConstraints.sfixed64:type_name -> buf.validate.SFixed64Rules
	19, // 15: buf.validate.FieldConstraints.bool:type_name -> buf.validate.BoolRules
	20, // 16: buf.validate.FieldConstraints.string:type_name -> buf.validate.StringRules
	21, // 17: buf.validate.FieldConstraints.bytes:type_name -> buf.validate.BytesRules
	22, // 18: buf.validate.FieldConstraints.enum:type_name -> buf.validate.EnumRules
	23, // 19: buf.validate.FieldConstraints.repeated:type_name -> buf.validate.RepeatedRules
	24, // 20: buf.validate.FieldConstraints.map:type_name -> buf.validate.MapRules
	25, // 21: buf.validate.FieldConstraints.any:type_name -> buf.validate.AnyRules
	26, // 22: buf.validate.FieldConstraints.duration:type_name -> buf.validate.DurationRules
	27, // 23: buf.validate.FieldConstraints.timestamp:type_name -> buf.validate.TimestampRules
	2,  // 24: buf.validate.PredefinedConstraints.cel:type_name -> buf.validate.Constraint
	1,  // 25: buf.validate.StringRules.well_known_regex:type_name -> buf.validate.KnownRegex
	5,  // 26: buf.validate.RepeatedRules.items:type_name -> buf.validate.FieldConstraints
	5,  // 27: buf.validate.MapRules.keys:type_name -> buf.validate.FieldConstraints
	5,  // 28: buf.validate.MapRules.values:type_name -> buf.validate.FieldConstraints
	30, // 29: buf.validate.DurationRules.const:type_name -> google.protobuf.Duration
	30, // 30: buf.validate.DurationRules.lt:type_name -> google.protobuf.Duration
	30, // 31: buf.validate.DurationRules.lte:type_name -> google.protobuf.Duration
	30, // 32: buf.validate.DurationRules.gt:type_name -> google.protobuf.Duration
	30, // 33: buf.validate.DurationRules.gte:type_name -> google.protobuf.Duration
	30, // 34: buf.validate.DurationRules.in:type_name -> google.protobuf.Duration
	30, // 35: buf.validate.DurationRules.not_in:type_name -> google.protobuf.Duration
	30, // 36: buf.validate.DurationRules.example:type_name -> google.protobuf.Duration
	31, // 37: buf.validate.TimestampRules.const:type_name -> google.protobuf.Timestamp
	31, // 38: buf.validate.TimestampRules.lt:type_name -> google.protobuf.Timestamp
	31, // 39: buf.validate.TimestampRules.lte:type_name -> google.protobuf.Timestamp
	31, // 40: buf.validate.TimestampRules.gt:type_name -> google.protobuf.Timestamp
	31, // 41: buf.validate.TimestampRules.gte:type_name -> google.protobuf.Timestamp
	30, // 42: buf.validate.TimestampRules.within:type_name -> google.protobuf.Duration
	31, // 43: buf.validate.TimestampRules.example:type_name -> google.protobuf.Timestamp
	29, // 44: buf.validate.Violations.violations:type_name -> buf.validate.Violation
	32, // 45: buf.validate.message:extendee -> google.protobuf.MessageOptions
	33, // 46: buf.validate.oneof:extendee -> google.protobuf.OneofOptions
	34, // 47: buf.validate.field:extendee -> google.protobuf.FieldOptions
	34, // 48: buf.validate.predefined:extendee -> google.protobuf.FieldOptions
	3,  // 49: buf.validate.message:type_name -> buf.validate.MessageConstraints
	4,  // 50: buf.validate.oneof:type_name -> buf.validate.OneofConstraints
	5,  // 51: buf.validate.field:type_name -> buf.validate.FieldConstraints
	6,  // 52: buf.validate.predefined:type_name -> buf.validate.PredefinedConstraints
	53, // [53:53] is the sub-list for method output_type
	53, // [53:53] is the sub-list for method input_type
	49, // [49:53] is the sub-list for extension type_name
	45, // [45:49] is the sub-list for extension extendee
	0,  // [0:45] is the sub-list for field type_name
}

func init() { file_buf_validate_validate_proto_init() }
func file_buf_validate_validate_proto_init() {
	if File_buf_validate_validate_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_buf_validate_validate_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Constraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*MessageConstraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*OneofConstraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*FieldConstraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*PredefinedConstraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*FloatRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*DoubleRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Int32Rules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*Int64Rules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*UInt32Rules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*UInt64Rules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*SInt32Rules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*SInt64Rules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*Fixed32Rules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*Fixed64Rules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*SFixed32Rules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*SFixed64Rules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*BoolRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*StringRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*BytesRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*EnumRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*RepeatedRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*MapRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*AnyRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*DurationRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[25].Exporter = func(v any, i int) any {
			switch v := v.(*TimestampRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			case 3:
				return &v.extensionFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[26].Exporter = func(v any, i int) any {
			switch v := v.(*Violations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_validate_validate_proto_msgTypes[27].Exporter = func(v any, i int) any {
			switch v := v.(*Violation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_buf_validate_validate_proto_msgTypes[3].OneofWrappers = []any{
		(*FieldConstraints_Float)(nil),
		(*FieldConstraints_Double)(nil),
		(*FieldConstraints_Int32)(nil),
		(*FieldConstraints_Int64)(nil),
		(*FieldConstraints_Uint32)(nil),
		(*FieldConstraints_Uint64)(nil),
		(*FieldConstraints_Sint32)(nil),
		(*FieldConstraints_Sint64)(nil),
		(*FieldConstraints_Fixed32)(nil),
		(*FieldConstraints_Fixed64)(nil),
		(*FieldConstraints_Sfixed32)(nil),
		(*FieldConstraints_Sfixed64)(nil),
		(*FieldConstraints_Bool)(nil),
		(*FieldConstraints_String_)(nil),
		(*FieldConstraints_Bytes)(nil),
		(*FieldConstraints_Enum)(nil),
		(*FieldConstraints_Repeated)(nil),
		(*FieldConstraints_Map)(nil),
		(*FieldConstraints_Any)(nil),
		(*FieldConstraints_Duration)(nil),
		(*FieldConstraints_Timestamp)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[5].OneofWrappers = []any{
		(*FloatRules_Lt)(nil),
		(*FloatRules_Lte)(nil),
		(*FloatRules_Gt)(nil),
		(*FloatRules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[6].OneofWrappers = []any{
		(*DoubleRules_Lt)(nil),
		(*DoubleRules_Lte)(nil),
		(*DoubleRules_Gt)(nil),
		(*DoubleRules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[7].OneofWrappers = []any{
		(*Int32Rules_Lt)(nil),
		(*Int32Rules_Lte)(nil),
		(*Int32Rules_Gt)(nil),
		(*Int32Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[8].OneofWrappers = []any{
		(*Int64Rules_Lt)(nil),
		(*Int64Rules_Lte)(nil),
		(*Int64Rules_Gt)(nil),
		(*Int64Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[9].OneofWrappers = []any{
		(*UInt32Rules_Lt)(nil),
		(*UInt32Rules_Lte)(nil),
		(*UInt32Rules_Gt)(nil),
		(*UInt32Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[10].OneofWrappers = []any{
		(*UInt64Rules_Lt)(nil),
		(*UInt64Rules_Lte)(nil),
		(*UInt64Rules_Gt)(nil),
		(*UInt64Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[11].OneofWrappers = []any{
		(*SInt32Rules_Lt)(nil),
		(*SInt32Rules_Lte)(nil),
		(*SInt32Rules_Gt)(nil),
		(*SInt32Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[12].OneofWrappers = []any{
		(*SInt64Rules_Lt)(nil),
		(*SInt64Rules_Lte)(nil),
		(*SInt64Rules_Gt)(nil),
		(*SInt64Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[13].OneofWrappers = []any{
		(*Fixed32Rules_Lt)(nil),
		(*Fixed32Rules_Lte)(nil),
		(*Fixed32Rules_Gt)(nil),
		(*Fixed32Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[14].OneofWrappers = []any{
		(*Fixed64Rules_Lt)(nil),
		(*Fixed64Rules_Lte)(nil),
		(*Fixed64Rules_Gt)(nil),
		(*Fixed64Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[15].OneofWrappers = []any{
		(*SFixed32Rules_Lt)(nil),
		(*SFixed32Rules_Lte)(nil),
		(*SFixed32Rules_Gt)(nil),
		(*SFixed32Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[16].OneofWrappers = []any{
		(*SFixed64Rules_Lt)(nil),
		(*SFixed64Rules_Lte)(nil),
		(*SFixed64Rules_Gt)(nil),
		(*SFixed64Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[18].OneofWrappers = []any{
		(*StringRules_Email)(nil),
		(*StringRules_Hostname)(nil),
		(*StringRules_Ip)(nil),
		(*StringRules_Ipv4)(nil),
		(*StringRules_Ipv6)(nil),
		(*StringRules_Uri)(nil),
		(*StringRules_UriRef)(nil),
		(*StringRules_Address)(nil),
		(*StringRules_Uuid)(nil),
		(*StringRules_Tuuid)(nil),
		(*StringRules_IpWithPrefixlen)(nil),
		(*StringRules_Ipv4WithPrefixlen)(nil),
		(*StringRules_Ipv6WithPrefixlen)(nil),
		(*StringRules_IpPrefix)(nil),
		(*StringRules_Ipv4Prefix)(nil),
		(*StringRules_Ipv6Prefix)(nil),
		(*StringRules_HostAndPort)(nil),
		(*StringRules_WellKnownRegex)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[19].OneofWrappers = []any{
		(*BytesRules_Ip)(nil),
		(*BytesRules_Ipv4)(nil),
		(*BytesRules_Ipv6)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[24].OneofWrappers = []any{
		(*DurationRules_Lt)(nil),
		(*DurationRules_Lte)(nil),
		(*DurationRules_Gt)(nil),
		(*DurationRules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[25].OneofWrappers = []any{
		(*TimestampRules_Lt)(nil),
		(*TimestampRules_Lte)(nil),
		(*TimestampRules_LtNow)(nil),
		(*TimestampRules_Gt)(nil),
		(*TimestampRules_Gte)(nil),
		(*TimestampRules_GtNow)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_validate_validate_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   28,
			NumExtensions: 4,
			NumServices:   0,
		},
		GoTypes:           file_buf_validate_validate_proto_goTypes,
		DependencyIndexes: file_buf_validate_validate_proto_depIdxs,
		EnumInfos:         file_buf_validate_validate_proto_enumTypes,
		MessageInfos:      file_buf_validate_validate_proto_msgTypes,
		ExtensionInfos:    file_buf_validate_validate_proto_extTypes,
	}.Build()
	File_buf_validate_validate_proto = out.File
	file_buf_validate_validate_proto_rawDesc = nil
	file_buf_validate_validate_proto_goTypes = nil
	file_buf_validate_validate_proto_depIdxs = nil
}
