/*
 * Copyright (c) 2019 - 2021, Broadcom
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef SR_USB_H
#define SR_USB_H

#define CDRU_PM_RESET_N_R	BIT(CDRU_MISC_RESET_CONTROL__CDRU_PM_RESET_N_R)
#define CDRU_USBSS_RESET_N	BIT(CDRU_MISC_RESET_CONTROL__CDRU_USBSS_RESET_N)
#define CDRU_MISC_CLK_USBSS \
			BIT(CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_USBSS_CLK_EN_R)

#define RESCAL_I_RSTB			BIT(26)
#define RESCAL_I_PWRDNB			BIT(27)

#define DRDU3_U3PHY_CTRL		0x68500014
#define	PHY_RESET			BIT(1)
#define	POR_RESET			BIT(28)
#define	MDIO_RESET			BIT(29)

#define DRDU3_PWR_CTRL			0x6850002c
#define POWER_CTRL_OVRD			BIT(2)

#define USB3H_U3PHY_CTRL		0x68510014
#define USB3H_U3SOFT_RST_N		BIT(30)

#define USB3H_PWR_CTRL			0x68510028

#define USB3_PHY_MDIO_BLOCK_BASE_REG	0x1f
#define BDC_AXI_SOFT_RST_N_OFFSET	0
#define XHC_AXI_SOFT_RST_N_OFFSET	1
#define MDIO_BUS_ID			3
#define USB3H_PHY_ID			5
#define USB3DRD_PHY_ID			2

#define USB3_PHY_RXPMD_BLOCK_BASE	0x8020
#define USB3_PHY_RXPMD_REG1		0x1
#define USB3_PHY_RXPMD_REG2		0x2
#define USB3_PHY_RXPMD_REG5		0x5
#define USB3_PHY_RXPMD_REG7		0x7

#define USB3_PHY_TXPMD_BLOCK_BASE	0x8040
#define USB3_PHY_TXPMD_REG1		0x1
#define USB3_PHY_TXPMD_REG2		0x2

#define USB3_PHY_ANA_BLOCK_BASE		0x8090
#define USB3_PHY_ANA_REG0		0x0
#define USB3_PHY_ANA_REG1		0x1
#define USB3_PHY_ANA_REG2		0x2
#define USB3_PHY_ANA_REG5		0x5
#define USB3_PHY_ANA_REG8		0x8
#define USB3_PHY_ANA_REG11		0xb

#define USB3_PHY_AEQ_BLOCK_BASE		0x80e0
#define USB3_PHY_AEQ_REG1		0x1
#define USB3_PHY_AEQ_REG3		0x3

#ifdef USB_DMA_COHERENT
#define DRDU3_U3XHC_SOFT_RST_N		BIT(31)
#define DRDU3_U3BDC_SOFT_RST_N		BIT(30)

#define DRDU3_SOFT_RESET_CTRL		0x68500030
#define DRDU3_XHC_AXI_SOFT_RST_N	BIT(1)
#define DRDU3_BDC_AXI_SOFT_RST_N	BIT(0)

#define DRDU2_PHY_CTRL			0x6852000c
#define DRDU2_U2SOFT_RST_N		BIT(29)

#define USB3H_SOFT_RESET_CTRL		0x6851002c
#define USB3H_XHC_AXI_SOFT_RST_N	BIT(1)

#define DRDU2_SOFT_RESET_CTRL		0x68520020
#define DRDU2_BDC_AXI_SOFT_RST_N	BIT(0)

#define DRD2U3H_XHC_REGS_AXIWRA		0x68511c08
#define DRD2U3H_XHC_REGS_AXIRDA		0x68511c0c
#define DRDU2D_BDC_REGS_AXIWRA		0x68521c08
#define DRDU2D_BDC_REGS_AXIRDA		0x68521c0c
#define DRDU3H_XHC_REGS_AXIWRA		0x68501c08
#define DRDU3H_XHC_REGS_AXIRDA		0x68501c0c
#define DRDU3D_BDC_REGS_AXIWRA		0x68502c08
#define DRDU3D_BDC_REGS_AXIRDA		0x68502c0c
/* cacheable write-back, allocate on both reads and writes */
#define USBAXI_AWCACHE		0xf
#define USBAXI_ARCACHE		0xf
/* non-secure */
#define USBAXI_AWPROT		0x8
#define USBAXI_ARPROT		0x8
#define USBAXIWR_SA_VAL		((USBAXI_AWCACHE << 4 | USBAXI_AWPROT) << 0)
#define USBAXIWR_SA_MASK	((0xf << 4 | 0xf) << 0)
#define USBAXIWR_UA_VAL		((USBAXI_AWCACHE << 4 | USBAXI_AWPROT) << 16)
#define USBAXIWR_UA_MASK	((0xf << 4 | 0xf) << 0)
#define USBAXIRD_SA_VAL		((USBAXI_ARCACHE << 4 | USBAXI_ARPROT) << 0)
#define USBAXIRD_SA_MASK	((0xf << 4 | 0xf) << 0)
#define USBAXIRD_UA_VAL		((USBAXI_ARCACHE << 4 | USBAXI_ARPROT) << 16)
#define USBAXIRD_UA_MASK	((0xf << 4 | 0xf) << 0)
#endif /* USB_DMA_COHERENT */

#define ICFG_DRDU3_SID_CTRL		0x6850001c
#define ICFG_USB3H_SID_CTRL		0x6851001c
#define ICFG_DRDU2_SID_CTRL		0x68520010
#define ICFG_USB_SID_SHIFT		5
#define ICFG_USB_SID_AWADDR_OFFSET	0x0
#define ICFG_USB_SID_ARADDR_OFFSET	0x4

#define USBIC_GPV_BASE			0x68600000
#define USBIC_GPV_SECURITY0		(USBIC_GPV_BASE + 0x8)
#define USBIC_GPV_SECURITY0_FIELD	BIT(0)
#define USBIC_GPV_SECURITY1		(USBIC_GPV_BASE + 0xc)
#define USBIC_GPV_SECURITY1_FIELD	(BIT(0) | BIT(1))
#define USBIC_GPV_SECURITY2		(USBIC_GPV_BASE + 0x10)
#define USBIC_GPV_SECURITY2_FIELD	(BIT(0) | BIT(1))
#define USBIC_GPV_SECURITY4		(USBIC_GPV_BASE + 0x18)
#define USBIC_GPV_SECURITY4_FIELD	BIT(0)
#define USBIC_GPV_SECURITY10		(USBIC_GPV_BASE + 0x30)
#define USBIC_GPV_SECURITY10_FIELD	(0x7 << 0)

#define USBSS_TZPCDECPROT_BASE		0x68540800
#define USBSS_TZPCDECPROT0set		(USBSS_TZPCDECPROT_BASE + 0x4)
#define USBSS_TZPCDECPROT0clr		(USBSS_TZPCDECPROT_BASE + 0x8)
#define DECPROT0_USBSS_DRD2U3H		BIT(3)
#define DECPROT0_USBSS_DRDU2H		BIT(2)
#define DECPROT0_USBSS_DRDU3D		BIT(1)
#define DECPROT0_USBSS_DRDU2D		BIT(0)
#define USBSS_TZPCDECPROT0 \
		(DECPROT0_USBSS_DRD2U3H | \
		DECPROT0_USBSS_DRDU2H |   \
		DECPROT0_USBSS_DRDU3D |   \
		DECPROT0_USBSS_DRDU2D)

int32_t usb_device_init(unsigned int);

#endif /* SR_USB_H */
