/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest zzaSW;
    private final DataMap zzaSV;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.zzaSW = putDataRequest;
        this.zzaSV = new DataMap();
        if (dataMap != null) {
            this.zzaSV.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem source) {
        return new PutDataMapRequest(PutDataRequest.zzn(source.getUri()), source.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String pathPrefix) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(pathPrefix), null);
    }

    public static PutDataMapRequest create(String path) {
        return new PutDataMapRequest(PutDataRequest.create(path), null);
    }

    public Uri getUri() {
        return this.zzaSW.getUri();
    }

    public DataMap getDataMap() {
        return this.zzaSV;
    }

    public PutDataRequest asPutDataRequest() {
        zzrb.zza zza2 = zzrb.zza(this.zzaSV);
        this.zzaSW.setData(zzrn.zzf(zza2.zzaVj));
        int n = zza2.zzaVk.size();
        for (int i = 0; i < n; ++i) {
            String string2 = Integer.toString(i);
            Asset asset = zza2.zzaVk.get(i);
            if (string2 == null) {
                throw new IllegalStateException("asset key cannot be null: " + asset);
            }
            if (asset == null) {
                throw new IllegalStateException("asset cannot be null: key=" + string2);
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                Log.d((String)"DataMap", (String)("asPutDataRequest: adding asset: " + string2 + " " + asset));
            }
            this.zzaSW.putAsset(string2, asset);
        }
        return this.zzaSW;
    }
}

