/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.zzbk;
import com.google.android.gms.wearable.internal.zzf;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelImpl
implements SafeParcelable,
Channel {
    public static final Parcelable.Creator<ChannelImpl> CREATOR = new zzl();
    final int zzCY;
    private final String zzaTK;
    private final String zzaST;
    private final String zzaTQ;

    ChannelImpl(int versionCode, String token, String nodeId, String path) {
        this.zzCY = versionCode;
        this.zzaTK = zzu.zzu(token);
        this.zzaST = zzu.zzu(nodeId);
        this.zzaTQ = zzu.zzu(path);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzl.zza(this, dest, flags);
    }

    public String toString() {
        return "ChannelImpl{versionCode=" + this.zzCY + ", token='" + this.zzaTK + '\'' + ", nodeId='" + this.zzaST + '\'' + ", path='" + this.zzaTQ + '\'' + "}";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChannelImpl)) {
            return false;
        }
        ChannelImpl channelImpl = (ChannelImpl)other;
        return this.zzaTK.equals(channelImpl.zzaTK) && zzt.equal(channelImpl.zzaST, this.zzaST) && zzt.equal(channelImpl.zzaTQ, this.zzaTQ) && channelImpl.zzCY == this.zzCY;
    }

    public int hashCode() {
        return this.zzaTK.hashCode();
    }

    @Override
    public String getNodeId() {
        return this.zzaST;
    }

    @Override
    public String getPath() {
        return this.zzaTQ;
    }

    public String getToken() {
        return this.zzaTK;
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client) {
        return client.zzb(new zzf<Status>(client){

            @Override
            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zzt(this, ChannelImpl.this.zzaTK);
            }

            protected Status zzb(Status status) {
                return status;
            }

            @Override
            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzb(x0);
            }
        });
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client, final int errorCode) {
        return client.zzb(new zzf<Status>(client){

            @Override
            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zzh(this, ChannelImpl.this.zzaTK, errorCode);
            }

            protected Status zzb(Status status) {
                return status;
            }

            @Override
            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzb(x0);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetInputStreamResult> getInputStream(GoogleApiClient client) {
        return client.zzb(new zzf<Channel.GetInputStreamResult>(client){

            @Override
            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zzu(this, ChannelImpl.this.zzaTK);
            }

            public Channel.GetInputStreamResult zzbb(Status status) {
                return new zza(status, null);
            }

            @Override
            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzbb(x0);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetOutputStreamResult> getOutputStream(GoogleApiClient client) {
        return client.zzb(new zzf<Channel.GetOutputStreamResult>(client){

            @Override
            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zzv(this, ChannelImpl.this.zzaTK);
            }

            public Channel.GetOutputStreamResult zzbc(Status status) {
                return new zzb(status, null);
            }

            @Override
            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzbc(x0);
            }
        });
    }

    @Override
    public PendingResult<Status> receiveFile(GoogleApiClient client, final Uri uri, final boolean append) {
        zzu.zzb(client, (Object)"client is null");
        zzu.zzb(uri, (Object)"uri is null");
        return client.zzb(new zzf<Status>(client){

            @Override
            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zza(this, ChannelImpl.this.zzaTK, uri, append);
            }

            public Status zzb(Status status) {
                return status;
            }

            @Override
            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzb(x0);
            }
        });
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, Uri uri) {
        return this.sendFile(client, uri, 0L, -1L);
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, final Uri uri, final long startOffset, final long length) {
        zzu.zzb(client, (Object)"client is null");
        zzu.zzb(this.zzaTK, (Object)"token is null");
        zzu.zzb(uri, (Object)"uri is null");
        zzu.zzb(startOffset >= 0L, "startOffset is negative: %s", startOffset);
        zzu.zzb(length >= 0L || length == -1L, "invalid length: %s", length);
        return client.zzb(new zzf<Status>(client){

            @Override
            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zza(this, ChannelImpl.this.zzaTK, uri, startOffset, length);
            }

            public Status zzb(Status status) {
                return status;
            }

            @Override
            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzb(x0);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        zzu.zzb(client, (Object)"client is null");
        zzu.zzb(listener, (Object)"listener is null");
        return client.zza(new zzi.zza(client, listener, this.zzaTK));
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        zzu.zzb(client, (Object)"client is null");
        zzu.zzb(listener, (Object)"listener is null");
        return client.zza(new zzi.zzc(client, listener, this.zzaTK));
    }

    static final class zzb
    implements Channel.GetOutputStreamResult {
        private final Status zzOt;
        private final OutputStream zzaTW;

        zzb(Status status, OutputStream outputStream) {
            this.zzOt = zzu.zzu(status);
            this.zzaTW = outputStream;
        }

        @Override
        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.zzaTW;
        }

        @Override
        public void release() {
            if (this.zzaTW != null) {
                try {
                    this.zzaTW.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static final class zza
    implements Channel.GetInputStreamResult {
        private final Status zzOt;
        private final InputStream zzaTV;

        zza(Status status, InputStream inputStream) {
            this.zzOt = zzu.zzu(status);
            this.zzaTV = inputStream;
        }

        @Override
        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public InputStream getInputStream() {
            return this.zzaTV;
        }

        @Override
        public void release() {
            if (this.zzaTV != null) {
                try {
                    this.zzaTV.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

