/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzd;
import com.google.android.gms.internal.zzlu;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int zzCY;
    private final DataSource zzajG;
    private long zzajV;
    private long zzajW;
    private final Value[] zzajX;
    private DataSource zzajY;
    private long zzajZ;
    private long zzaka;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzd();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.zzCY = versionCode;
        this.zzajG = dataSource;
        this.zzajY = originalDataSource;
        this.zzajV = timestampNanos;
        this.zzajW = startTimeNanos;
        this.zzajX = values;
        this.zzajZ = rawTimestamp;
        this.zzaka = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(DataPoint.zza(dataSources, rawDataPoint.zzakH), DataPoint.zza(dataSources, rawDataPoint.zzakI), rawDataPoint);
    }

    public DataPoint(DataSource dataSource, DataSource originalDataSource, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzajV, 0L), DataPoint.zza(rawDataPoint.zzajW, 0L), rawDataPoint.zzajX, originalDataSource, DataPoint.zza(rawDataPoint.zzajZ, 0L), DataPoint.zza(rawDataPoint.zzaka, 0L));
    }

    private static DataSource zza(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.zzCY = 4;
        this.zzajG = zzu.zzb(dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.zzajX = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzajX[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return zzc.zza(intent, "com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit timeUnit) {
        this.zzajV = timeUnit.toNanos(timestamp);
        if (this.zzqt() && zzlu.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzajV = zzlu.zza(this.zzajV, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zzqt() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
        this.zzajW = timeUnit.toNanos(startTime);
        this.zzajV = timeUnit.toNanos(endTime);
        return this;
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzajX[n];
    }

    public Value[] zzqu() {
        return this.zzajX;
    }

    public DataPoint setFloatValues(float ... values) {
        this.zzed(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzajX[i].setFloat(values[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.zzed(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzajX[i].setInt(values[i]);
        }
        return this;
    }

    private void zzed(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzu.zzb(n == n2, "Attempting to insert %s values, but needed %s: %s", n, n2, list);
    }

    public DataType getDataType() {
        return this.zzajG.getDataType();
    }

    public DataSource getDataSource() {
        return this.zzajG;
    }

    public DataSource getOriginalDataSource() {
        return this.zzajY;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzajV, TimeUnit.NANOSECONDS);
    }

    public long zzqv() {
        return this.zzajZ;
    }

    public long zzqw() {
        return this.zzaka;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzajW, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzajV, TimeUnit.NANOSECONDS);
    }

    public void zzqx() {
        DataSource dataSource = this.getDataSource();
        zzu.zzb(this.getDataType().getName().equals(dataSource.getDataType().getName()), "Conflicting data types found %s vs %s", this.getDataType(), this.getDataType());
        zzu.zzb(this.zzajV > 0L, "Data point does not have the timestamp set: %s", this);
        zzu.zzb(this.zzajW <= this.zzajV, "Data point with start time greater than end time found: %s", this);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DataPoint && this.zza((DataPoint)o);
    }

    private boolean zza(DataPoint dataPoint) {
        return zzt.equal(this.zzajG, dataPoint.zzajG) && this.zzajV == dataPoint.zzajV && this.zzajW == dataPoint.zzajW && Arrays.equals(this.zzajX, dataPoint.zzajX) && zzt.equal(this.zzajY, dataPoint.zzajY);
    }

    public int hashCode() {
        return zzt.hashCode(this.zzajG, this.zzajV, this.zzajW);
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.zzajX), this.zzajW, this.zzajV, this.zzajZ, this.zzaka, this.zzajG.toDebugString(), this.zzajY != null ? this.zzajY.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    public long getTimestampNanos() {
        return this.zzajV;
    }

    public long zzqy() {
        return this.zzajW;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzd.zza(this, parcel, flags);
    }

    private static long zza(Long l, long l2) {
        return l != null ? l : l2;
    }
}

