/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.io;

import edu.berkeley.nlp.lm.util.StrUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtils {
    private static String charEncoding = "UTF-8";

    public static BufferedReader openIn(String path) throws IOException {
        return IOUtils.openIn(new File(path));
    }

    public static BufferedReader openIn(File path) throws IOException {
        FilterInputStream is = IOUtils.getBufferedInputStream(path);
        if (path.getName().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(IOUtils.getReader(is));
    }

    public static BufferedReader openInHard(String path) {
        return IOUtils.openInHard(new File(path));
    }

    public static BufferedReader openInHard(File path) {
        try {
            return IOUtils.openIn(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PrintWriter openOut(String path) throws IOException {
        return IOUtils.openOut(new File(path));
    }

    public static PrintWriter openOut(File path) throws IOException {
        OutputStream os = new FileOutputStream(path);
        if (path.getName().endsWith(".gz")) {
            os = new GZIPOutputStream(os);
        }
        return new PrintWriter(IOUtils.getWriter(os));
    }

    public static PrintWriter openOutEasy(String path) {
        if (StrUtils.isEmpty(path)) {
            return null;
        }
        return IOUtils.openOutEasy(new File(path));
    }

    public static PrintWriter openOutEasy(File path) {
        if (path == null) {
            return null;
        }
        try {
            return IOUtils.openOut(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PrintWriter openOutHard(String path) {
        return IOUtils.openOutHard(new File(path));
    }

    public static PrintWriter openOutHard(File path) {
        try {
            return IOUtils.openOut(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectInputStream openObjIn(String path) throws IOException {
        return IOUtils.openObjIn(new File(path));
    }

    public static ObjectInputStream openObjIn(File path) throws IOException {
        BufferedInputStream fis = IOUtils.getBufferedInputStream(path);
        return path.getName().endsWith(".gz") ? new ObjectInputStream(new GZIPInputStream(fis)) : new ObjectInputStream(fis);
    }

    private static BufferedInputStream getBufferedInputStream(File path) throws FileNotFoundException {
        return new BufferedInputStream(Channels.newInputStream(new FileInputStream(path).getChannel()));
    }

    public static ObjectOutputStream openObjOut(String path) throws IOException {
        return IOUtils.openObjOut(new File(path));
    }

    public static ObjectOutputStream openObjOut(File path) throws IOException {
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(path));
        return path.getName().endsWith(".gz") ? new ObjectOutputStream(new GZIPOutputStream(fos)) : new ObjectOutputStream(fos);
    }

    public static Object readObjFile(String path) throws IOException, ClassNotFoundException {
        return IOUtils.readObjFile(new File(path));
    }

    public static Object readObjFile(File path) throws IOException, ClassNotFoundException {
        ObjectInputStream in = IOUtils.openObjIn(path);
        Object obj = in.readObject();
        in.close();
        return obj;
    }

    public static Object readObjFileEasy(String path) {
        if (StrUtils.isEmpty(path)) {
            return null;
        }
        return IOUtils.readObjFileEasy(new File(path));
    }

    public static Object readObjFileEasy(File path) {
        if (path == null) {
            return null;
        }
        try {
            return IOUtils.readObjFile(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object readObjFileHard(String path) {
        return IOUtils.readObjFileHard(new File(path));
    }

    public static Object readObjFileHard(File path) {
        try {
            return IOUtils.readObjFile(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeObjFile(File path, Object obj) throws IOException {
        ObjectOutputStream out = IOUtils.openObjOut(path);
        out.writeObject(obj);
        out.close();
    }

    public static boolean writeObjFileEasy(File path, Object obj) {
        if (path == null) {
            return false;
        }
        try {
            IOUtils.writeObjFile(path, obj);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void writeObjFileHard(String path, Object obj) {
        IOUtils.writeObjFileHard(new File(path), obj);
    }

    public static void writeObjFileHard(File path, Object obj) {
        try {
            IOUtils.writeObjFile(path, obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean closeEasy(BufferedReader in) {
        try {
            in.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buf = new byte[16384];
        int total = 0;
        while ((n = in.read(buf)) != -1) {
            total += n;
            out.write(buf, 0, n);
        }
        out.flush();
        return total;
    }

    public static int copy(Reader in, Writer out) throws IOException {
        int n;
        char[] buf = new char[16384];
        int total = 0;
        while ((n = in.read(buf)) != -1) {
            total += n;
            out.write(buf, 0, n);
        }
        out.flush();
        return total;
    }

    public static Iterator<String> lineIterator(String path) throws IOException {
        BufferedReader reader = IOUtils.openIn(path);
        return IOUtils.lineIterator(reader);
    }

    public static Iterator<String> lineIterator(final BufferedReader reader) {
        return new Iterator<String>(){
            private String line;

            @Override
            public boolean hasNext() {
                try {
                    return this.nextLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            private boolean nextLine() throws IOException {
                if (this.line != null) {
                    return true;
                }
                this.line = reader.readLine();
                if (this.line == null) {
                    reader.close();
                }
                return this.line != null;
            }

            @Override
            public String next() {
                try {
                    this.nextLine();
                    String retLine = this.line;
                    this.line = null;
                    return retLine;
                }
                catch (IOException e) {
                    throw new RuntimeException();
                }
            }

            @Override
            public void remove() {
                throw new RuntimeException("remove() not supported");
            }
        };
    }

    public static List<String> readLines(BufferedReader in) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    public static List<String> readLinesEasy(String path) {
        try {
            return IOUtils.readLines(path);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static List<String> readLinesHard(String path) {
        try {
            return IOUtils.readLines(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readLine(String path) throws IOException {
        BufferedReader in = IOUtils.openIn(path);
        String line = in.readLine();
        in.close();
        return line;
    }

    public static String readLineEasy(String path) {
        try {
            return IOUtils.readLine(path);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List<String> readLines(String path) throws IOException {
        BufferedReader in = IOUtils.openIn(path);
        List<String> list = IOUtils.readLines(in);
        in.close();
        return list;
    }

    public static String getCharEncoding() {
        return charEncoding;
    }

    public static void setCharEncoding(String charEncoding) {
        if (StrUtils.isEmpty(charEncoding)) {
            return;
        }
        IOUtils.charEncoding = charEncoding;
    }

    public static BufferedReader getReader(InputStream in) throws IOException {
        return new BufferedReader(new InputStreamReader(in, IOUtils.getCharEncoding()));
    }

    public static PrintWriter getWriter(OutputStream out) throws IOException {
        return new PrintWriter((Writer)new OutputStreamWriter(out, IOUtils.getCharEncoding()), true);
    }
}

