/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Calendar;
import java.util.Locale;
import org.languagetool.rules.AbstractDateCheckFilter;

public class DateCheckFilter
extends AbstractDateCheckFilter {
    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.forLanguageTag("uk"));
    }

    protected int getDayOfWeek(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.startsWith("\u043f\u043e") || day.equals("\u043f\u043d")) {
            return 2;
        }
        if (day.startsWith("\u0432\u0456") || day.equals("\u0432\u0442")) {
            return 3;
        }
        if (day.startsWith("\u0441\u0435") || day.equals("\u0441\u0440")) {
            return 4;
        }
        if (day.startsWith("\u0447\u0435") || day.equals("\u0447\u0442")) {
            return 5;
        }
        if (day.startsWith("\u043f'") || day.startsWith("\u043f\u2019") || day.equals("\u043f\u0442")) {
            return 6;
        }
        if (day.startsWith("\u0441\u0443") || day.equals("\u0441\u0431")) {
            return 7;
        }
        if (day.startsWith("\u043d\u0435") || day.equals("\u043d\u0434")) {
            return 1;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        return date.getDisplayName(7, 2, Locale.forLanguageTag("uk"));
    }

    protected int getMonth(String monthStr) {
        String mon = monthStr.toLowerCase();
        if (mon.startsWith("\u0441\u0456")) {
            return 1;
        }
        if (mon.startsWith("\u043b\u044e")) {
            return 2;
        }
        if (mon.startsWith("\u0431\u0435")) {
            return 3;
        }
        if (mon.startsWith("\u043a\u0432")) {
            return 4;
        }
        if (mon.startsWith("\u0442\u0440")) {
            return 5;
        }
        if (mon.startsWith("\u0447\u0435")) {
            return 6;
        }
        if (mon.startsWith("\u043b\u0438")) {
            return 7;
        }
        if (mon.startsWith("\u0441\u0435")) {
            return 8;
        }
        if (mon.startsWith("\u0432\u0435")) {
            return 9;
        }
        if (mon.startsWith("\u0436\u043e")) {
            return 10;
        }
        if (mon.startsWith("\u043b\u0438")) {
            return 11;
        }
        if (mon.startsWith("\u0433\u0440")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

