/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.help;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.DesktopWrapper;

public final class Help {
    public static final String ONLINE_HELP_URL = OStrings.IS_BETA ? "https://omegat.sourceforge.io/manual-latest/" : "https://omegat.sourceforge.io/manual-standard/";
    public static final String ONLINE_JAVADOC_URL = OStrings.IS_BETA ? "https://omegat.sourceforge.io/javadoc-latest/" : "https://omegat.sourceforge.io/javadoc-standard/";

    private Help() {
    }

    public static void showJavadoc() throws IOException {
        URI uri = URI.create(ONLINE_JAVADOC_URL);
        DesktopWrapper.browse(uri);
    }

    public static void showHelp() throws IOException {
        String lang = Help.detectHelpLanguage();
        URI uri = Help.getHelpFileURI(lang, "index.html");
        if (uri == null) {
            uri = URI.create(ONLINE_HELP_URL);
        }
        DesktopWrapper.browse(uri);
    }

    public static URI getHelpFileURI(String filename) {
        return Help.getHelpFileURI(null, filename);
    }

    public static URI getHelpFileURI(String lang, String filename) {
        Object path = lang == null ? filename : lang + File.separator + filename;
        File file = Paths.get(StaticUtils.installDir(), new String[]{"docs", path}).toFile();
        if (file.isFile()) {
            return file.toURI();
        }
        path = lang == null ? filename : lang + "/" + filename;
        URL url = Help.class.getResource("/docs/" + (String)path);
        if (url != null) {
            try {
                return url.toURI();
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public static String errorHaiku() {
        int id = ThreadLocalRandom.current().nextInt(11) + 1;
        return OStrings.getString("HF_HAIKU_" + id);
    }

    private static String detectHelpLanguage() {
        String country;
        String language = Locale.getDefault().getLanguage().toLowerCase(Locale.ENGLISH);
        String locale = language + "_" + (country = Locale.getDefault().getCountry().toUpperCase(Locale.ENGLISH));
        String version = Help.getDocVersion(locale);
        if (OStrings.VERSION.equals(version)) {
            return locale;
        }
        version = Help.getDocVersion(language);
        if (OStrings.VERSION.equals(version)) {
            return language;
        }
        return null;
    }

    private static String getDocVersion(String locale) {
        if (Help.getHelpFileURI(locale, "index.html") == null) {
            return null;
        }
        Properties prop = new Properties();
        URI u = Help.getHelpFileURI(locale, "version_" + locale + ".properties");
        if (u == null) {
            u = Help.getHelpFileURI(locale, "version.properties");
        }
        try (InputStream in = u.toURL().openStream();){
            prop.load(in);
        }
        catch (IOException ex) {
            return null;
        }
        return prop.getProperty("version");
    }
}

