/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNFLock {
    private final File file;
    private final boolean exclusive;
    private int fd;
    private Process flockProcess;

    public static SVNFLock obtain(File file, boolean exclusive) throws SVNException {
        if (!(SVNFileUtil.isLinux || SVNFileUtil.isBSD || SVNFileUtil.isOSX)) {
            return null;
        }
        int fd = SVNJNAUtil.flock(file, exclusive);
        if (fd >= 0) {
            return new SVNFLock(file, exclusive, fd, null);
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(SVNFLock.shouldUsePerlCommand() ? SVNFLock.getPerlCommand(file, exclusive) : SVNFLock.getFlockCommand(file, exclusive));
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            int read = inputStream.read();
            if (read == 120) {
                return new SVNFLock(file, exclusive, -1, process);
            }
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Unable to lock ''{0}'', exclusive={1}", file, exclusive);
            SVNErrorManager.error(errorMessage, SVNLogType.DEFAULT);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.DEFAULT);
        }
        return null;
    }

    private SVNFLock(File file, boolean exclusive, int fd, Process flockProcess) {
        this.file = file;
        this.exclusive = exclusive;
        this.fd = fd;
        this.flockProcess = flockProcess;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isValid() {
        return this.fd >= 0 || this.flockProcess != null;
    }

    public void release() {
        if (this.isJNALock()) {
            if (SVNJNAUtil.unflock(this.fd)) {
                this.fd = -1;
            }
        } else if (this.flockProcess != null) {
            OutputStream outputStream = this.flockProcess.getOutputStream();
            try {
                outputStream.write(10);
                outputStream.close();
                int rc = this.flockProcess.waitFor();
                if (rc != 0) {
                    SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, "Couldn't unlock \"" + this.file.getAbsolutePath() + "\", rc=" + rc, Level.FINEST);
                }
                this.flockProcess = null;
            }
            catch (IOException e) {
                SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, e, Level.FINEST);
            }
            catch (InterruptedException e) {
                SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, e, Level.FINEST);
            }
        }
    }

    public String toString() {
        return "SVNFLock{file=" + this.file + ", exclusive=" + this.exclusive + ", valid=" + this.isValid() + ", using " + (this.isJNALock() ? "JNA" : (SVNFLock.shouldUsePerlCommand() ? "'perl' command" : "'flock' utility")) + '}';
    }

    private boolean isJNALock() {
        return this.fd >= 0;
    }

    private static boolean shouldUsePerlCommand() {
        return SVNFileUtil.isOSX;
    }

    private static List<String> getFlockCommand(File file, boolean exclusive) {
        return Arrays.asList("flock", exclusive ? "--exclusive" : "--shared", file.getAbsolutePath(), "--command", "echo x && read -N 1");
    }

    private static List<String> getPerlCommand(File file, boolean exclusive) {
        return Arrays.asList("perl", "-MFcntl=:flock", "-e", "$|=1;$f=shift;open(FH, \"+>>\",$f)||die($!);" + String.format("flock(FH,%s);", exclusive ? "LOCK_EX" : "LOCK_SH") + "print \"x\";readline(STDIN);flock(FH,LOCK_UN);", file.getAbsolutePath());
    }
}

